module Darcs.Patch.RepoPatch ( RepoPatch )
    where

import Darcs.Patch.Annotate ( Annotate )
import Darcs.Patch.Apply ( Apply, ApplyState )
import Darcs.Patch.Commute ( Commute )
import Darcs.Patch.Conflict ( Conflict, CommuteNoConflicts )
import Darcs.Patch.Effect ( Effect )
import Darcs.Patch.FileHunk ( IsHunk )
import Darcs.Patch.Format ( PatchListFormat )
import Darcs.Patch.Inspect ( PatchInspect )
import Darcs.Patch.Invert ( Invert )
import Darcs.Patch.Matchable ( Matchable )
import Darcs.Patch.Merge ( Merge )
import Darcs.Patch.Prim ( PrimPatchBase, PrimOf, FromPrim )
import Darcs.Patch.Read ( ReadPatch )
import Darcs.Patch.Repair ( RepairToFL, Check )
import Darcs.Patch.Show ( ShowPatch, ShowContextPatch )

class (Apply p, Commute p, Invert p, Merge p, Effect p, IsHunk p,
       PatchInspect p, ReadPatch p, ShowPatch p, ShowContextPatch p,
       FromPrim p, Conflict p, CommuteNoConflicts p,
       Check p, RepairToFL p, PatchListFormat p,
       PrimPatchBase p, IsHunk (PrimOf p),
       Matchable p, Annotate p, ApplyState p ~ ApplyState (PrimOf p)
      )
    => RepoPatch p
