#pragma once

#include <stdint.h>

uint64_t ntoh64(uint64_t x);
#define hton64 ntoh64

void WebSocketMessageUnmaskPayload(uint8_t *payload, uint64_t payloadLength, uint32_t maskingKey);
void ProcessWebSocketMessage(int client_fd, uint8_t *payload, uint64_t numBytes);

#ifdef _MSC_VER
#pragma pack(push,1)
#endif

struct
#if defined(__GNUC__)
__attribute__ ((packed, aligned(1)))
#endif

WebSocketMessageHeader
{
  unsigned opcode : 4;
  unsigned rsv : 3;
  unsigned fin : 1;
  unsigned payloadLength : 7;
  unsigned mask : 1;
};

#ifdef _MSC_VER
__pragma(pack(pop))
#endif
