"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CffGlyphBuilder = void 0;
const ot_glyphs_1 = require("@ot-builder/ot-glyphs");
const variance_1 = require("@ot-builder/variance");
class CffGlyphBuilder {
    constructor(glyph) {
        this.glyph = glyph;
        this.stemQuantity = 0;
        this.transient = [];
        this.hints = new ot_glyphs_1.OtGlyph.CffHint();
        this.contours = [];
        this.currentContour = [];
        this.cx = 0;
        this.cy = 0;
    }
    setWidth(x) {
        this.glyph.horizontal = { start: 0, end: x };
    }
    addStemHint(isVertical, startEdge, endEdge) {
        if (isVertical) {
            this.hints.vStems.push(ot_glyphs_1.OtGlyph.CffHint.createStem(startEdge, endEdge));
        }
        else {
            this.hints.hStems.push(ot_glyphs_1.OtGlyph.CffHint.createStem(startEdge, endEdge));
        }
    }
    addHintMask(isCounterMask, flags) {
        const ssHorizontal = new Set();
        const ssVertical = new Set();
        for (let sid = 0; sid < this.stemQuantity; sid++) {
            const masked = flags[sid];
            if (sid < this.hints.hStems.length) {
                if (masked)
                    ssHorizontal.add(this.hints.hStems[sid]);
            }
            else {
                if (masked)
                    ssVertical.add(this.hints.vStems[sid - this.hints.hStems.length]);
            }
        }
        const hm = ot_glyphs_1.OtGlyph.CffHint.createMask({
            geometry: 0,
            contour: this.contours.length,
            index: this.currentContour.length
        }, ssHorizontal, ssVertical);
        if (isCounterMask) {
            this.hints.counterMasks.push(hm);
        }
        else {
            this.hints.hintMasks.push(hm);
        }
    }
    flushContour() {
        if (this.currentContour.length) {
            this.contours.push(this.currentContour);
        }
    }
    startContour() {
        this.flushContour();
        this.currentContour = [];
    }
    lineTo(x, y) {
        this.cx = variance_1.OtVar.Ops.add(this.cx, x);
        this.cy = variance_1.OtVar.Ops.add(this.cy, y);
        this.currentContour.push(ot_glyphs_1.OtGlyph.Point.create(this.cx, this.cy, ot_glyphs_1.OtGlyph.PointType.Corner));
    }
    curveTo(x1, y1, x2, y2, x3, y3) {
        const cx1 = variance_1.OtVar.Ops.add(this.cx, x1);
        const cy1 = variance_1.OtVar.Ops.add(this.cy, y1);
        const cx2 = variance_1.OtVar.Ops.add(cx1, x2);
        const cy2 = variance_1.OtVar.Ops.add(cy1, y2);
        const cx3 = variance_1.OtVar.Ops.add(cx2, x3);
        const cy3 = variance_1.OtVar.Ops.add(cy2, y3);
        this.cx = cx3;
        this.cy = cy3;
        this.currentContour.push(ot_glyphs_1.OtGlyph.Point.create(cx1, cy1, ot_glyphs_1.OtGlyph.PointType.Lead));
        this.currentContour.push(ot_glyphs_1.OtGlyph.Point.create(cx2, cy2, ot_glyphs_1.OtGlyph.PointType.Follow));
        this.currentContour.push(ot_glyphs_1.OtGlyph.Point.create(cx3, cy3, ot_glyphs_1.OtGlyph.PointType.Corner));
    }
    getRandom() {
        return 0;
    }
    endChar() {
        this.startContour();
        if (this.contours.length)
            this.glyph.geometry = new ot_glyphs_1.OtGlyph.ContourSet(this.contours);
        this.glyph.hints = this.hints;
    }
}
exports.CffGlyphBuilder = CffGlyphBuilder;
//# sourceMappingURL=shape-building.js.map