"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NopProcessor = exports.TSI01Processor = void 0;
exports.writeTSI0123 = writeTSI0123;
const io_bin_ttf_1 = require("@ot-builder/io-bin-ttf");
function writeTSI0123(frTSI02, frTSI13, table, gOrd, textProcessor) {
    const sink = [];
    for (let gid = 0; gid < gOrd.length; gid++) {
        collectTSI0123Entry(sink, gid, table.glyphPrograms.get(gOrd.at(gid)) || "", textProcessor);
    }
    collectTSI0123Entry(sink, 0xfffa, table.preProgram || "", textProcessor);
    collectTSI0123Entry(sink, 0xfffb, table.cvtProgram || "", textProcessor);
    collectTSI0123Entry(sink, 0xfffc, "", textProcessor);
    collectTSI0123Entry(sink, 0xfffd, table.fpgmProgram || "", textProcessor);
    let offset = 0;
    for (let iEntry = 0; iEntry < sink.length; iEntry++) {
        if (iEntry + 4 === sink.length) {
            frTSI02.uint16(0xfffe).uint16(0).uint32(0xabfc1f34); // Magic
        }
        const entry = sink[iEntry];
        frTSI02
            .uint16(entry.glyphIndex)
            .uint16(Math.min(entry.textBuffer.byteLength, 0x8000))
            .uint32(offset);
        frTSI13.bytes(entry.textBuffer);
        offset += entry.textBuffer.byteLength;
    }
}
function collectTSI0123Entry(sink, gid, text, textProcessor) {
    sink.push({
        glyphIndex: gid,
        textBuffer: Buffer.from(textProcessor.processProgram(gid, text), "utf-8")
    });
}
class TSI01Processor {
    constructor(extraInfoReporter) {
        this.extraInfoReporter = extraInfoReporter;
    }
    processProgram(gid, text) {
        if (gid >= 0xfffa)
            return text;
        text = text.replace(/^(?:USEMYMETRICS|(?:NON)?OVERLAP|(?:UN)?SCALEDCOMPONENTOFFSET|S?(?:OFFSET|ANCHOR))\[[rR]?\].*$(?:\r|\n|\r\n)?/gm, "");
        let pseudoInstructions = "";
        const componentInfos = this.extraInfoReporter.getCompositeGlyphInfo(gid);
        for (const component of componentInfos) {
            if (!component)
                continue;
            if (component.flags & io_bin_ttf_1.ComponentFlag.USE_MY_METRICS)
                pseudoInstructions += "USEMYMETRICS[]\r";
            if (!(component.flags & io_bin_ttf_1.ComponentFlag.NON_OVERLAPPING))
                pseudoInstructions += "OVERLAP[]\r";
            if (component.flags & io_bin_ttf_1.ComponentFlag.UNSCALED_COMPONENT_OFFSET)
                pseudoInstructions += "UNSCALEDCOMPONENTOFFSET[]\r";
            else if (component.flags & io_bin_ttf_1.ComponentFlag.SCALED_COMPONENT_OFFSET)
                pseudoInstructions += "SCALEDCOMPONENTOFFSET[]\r";
            const roundIndicator = component.flags & io_bin_ttf_1.ComponentFlag.ROUND_XY_TO_GRID ? "R" : "r";
            const argTy = component.flags & io_bin_ttf_1.ComponentFlag.ARGS_ARE_XY_VALUES ? "OFFSET" : "ANCHOR";
            if (component.flags &
                (io_bin_ttf_1.ComponentFlag.WE_HAVE_A_SCALE |
                    io_bin_ttf_1.ComponentFlag.WE_HAVE_AN_X_AND_Y_SCALE |
                    io_bin_ttf_1.ComponentFlag.WE_HAVE_A_TWO_BY_TWO)) {
                pseudoInstructions +=
                    `S${argTy}[${roundIndicator}], ${component.targetGID}, ` +
                        `${component.arg1}, ${component.arg2}, ` +
                        `${component.argXScale.toFixed(4)}, ${component.argScale01.toFixed(4)}, ` +
                        `${component.argScale10.toFixed(4)}, ${component.argYScale.toFixed(4)}\r`;
            }
            else {
                pseudoInstructions +=
                    `${argTy}[${roundIndicator}], ${component.targetGID}, ` +
                        `${component.arg1}, ${component.arg2}\r`;
            }
        }
        return pseudoInstructions + text;
    }
}
exports.TSI01Processor = TSI01Processor;
class NopProcessor {
    processProgram(gid, text) {
        return text;
    }
}
exports.NopProcessor = NopProcessor;
//# sourceMappingURL=write.js.map