<?xml version="1.0" encoding="UTF-8"?>

<!-- A stylesheet turning OAI-PMH responses into something viewable
in a web browser.  This basically lets people explore our publishing 
registry without being blinded by XML.

This stylesheet is made available under CC-0 by the GAVO project,
http://www.g-vo.org.  
See http://creativecommons.org/publicdomain/zero/1.0/ for details.
-->

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:ri="http://www.ivoa.net/xml/RegistryInterface/v1.0"
    xmlns:oai="http://www.openarchives.org/OAI/2.0/"
    xmlns="http://www.w3.org/1999/xhtml"
    version="1.0">
   
   	<xsl:include href="dachs-xsl-config.xsl"/>

    <!-- ############################################## Global behaviour -->

    <xsl:output method="xml" 
      doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
      doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"/>

    <!-- Don't spill the content of unknown elements. -->
    <xsl:template match="text()"/>

	  <xsl:template match="oai:OAI-PMH">
        <html>
            <head>
                <title>OAI PMH</title>
                <xsl:call-template name="localCompleteHead"/>
                <style type="text/css"><![CDATA[
                    .nestbox {
                        padding: 1ex;
                        margin-top: 2ex;
                        border: 1px solid grey;
                        position: relative;
                    }
                    .boxtitle {
                        background-color: white;
                        position: absolute;
                        top: -3ex;
                    }
                    .deleted a {
                        text-decoration: line-through;
                    }
                    p.attrpair {
                        text-align: right;
                        margin: 0pt;
                        padding: 0pt;
                        font-size: 80%;
                        max-width: 2000pt;
                    }
                    span.value {
                        display: inline-block;
                        min-width: 11em;
                    }
                ]]></style>
            </head>
            <body>
                <h1>OAI PMH result of <xsl:value-of select="oai:responseDate"/>
                </h1>
    				    <xsl:apply-templates/>
    				    <p><a href="/oai.xml?verb=ListIdentifiers&amp;metadataPrefix=ivo_vor">All identifiers defined here</a></p>
                <xsl:call-template name="localMakeFoot"/>
            </body>
        </html>
    </xsl:template>

    <xsl:template match="oai:request">
        <p class="reqinfo">
            Request verb was <xsl:value-of select="@verb"/>
        </p>
    </xsl:template>

    <xsl:template match="oai:error">
        <div class="errors"><p>Error code <xsl:value-of select="@code"/>:
            <xsl:value-of select="."/></p>
        </div>
    </xsl:template>

    <xsl:template match="oai:ListIdentifiers">
        <ul class="listIdentifiers">
            <xsl:apply-templates/>
        </ul>
    </xsl:template>

    <xsl:template match="oai:header">
        <li>
            <xsl:attribute name="class">oairec
                <xsl:value-of select="@status"/>
            </xsl:attribute>
            <xsl:apply-templates/>
        </li>
    </xsl:template>

    <xsl:template match="oai:identifier">
        <xsl:element name="a">
            <xsl:attribute name="href">/oai.xml?verb=GetRecord&amp;metadataPrefix=ivo_vor&amp;identifier=<xsl:value-of select="."/>
            </xsl:attribute>
            <xsl:value-of select="."/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="oai:metadata">
        <xsl:apply-templates mode="dumpall"/>
    </xsl:template>

    <xsl:template match="*" mode="dumpall">
        <div class="nestbox">
            <p class="boxtitle"><xsl:value-of select="name(.)"/></p>
            <xsl:apply-templates select="@*"/>
            <xsl:apply-templates mode="dumpall"/>
        </div>
    </xsl:template>

    <xsl:template match="@*" priority="1">
        <xsl:choose>
            <xsl:when test="name()='ivo-id'">
                <p class="attrpair"><span class="key">&#8594;</span>
                    <span class="value"><a>
                    <xsl:attribute name="href"
                   >/oai.xml?verb=GetRecord&amp;metadataPrefix=ivo_vor&amp;identifier=<xsl:value-of select="."/>
               </xsl:attribute><xsl:value-of select="."/></a></span></p>
            </xsl:when>
            <xsl:otherwise>
                <p class="attrpair">
                    <span class="key"><xsl:value-of select="name()"/></span>:
                    <span class="value"><xsl:value-of select="."/></span>
                </p>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="/ri:Resource">
        <!-- naked ri:Resource at the root: this is from metarender -->
        <html>
            <head>
                <title>Resource Record for 
                    <xsl:value-of select="identifier"/></title>
                <xsl:call-template name="localCompleteHead"/>
                <style type="text/css"><![CDATA[
                    .nestbox {
                        padding: 1ex;
                        margin-top: 2ex;
                        border: 1px solid grey;
                        position: relative;
                    }
                    .boxtitle {
                        background-color: white;
                        position: absolute;
                        top: -3ex;
                    }
                    .deleted a {
                        text-decoration: line-through;
                    }
                    p.attrpair {
                        text-align: right;
                        margin: 0pt;
                        padding: 0pt;
                        font-size: 80%;
                        max-width: 2000pt;
                    }
                    span.value {
                        display: inline-block;
                        min-width: 11em;
                    }
                ]]></style>
            </head>
            <body>
                <h1>Resource Record for <xsl:value-of select="identifier"/>
                </h1>
                <ul>
                    <li>Status: <xsl:value-of select="@status"/></li>
                    <li>Type: <xsl:value-of select="@xsi:type"/></li>
                    <li>Created: <xsl:value-of select="@created"/></li>
                    <li>Updated: <xsl:value-of select="@updated"/></li>
                </ul>
    				    <xsl:apply-templates mode="dumpall"/>
                <xsl:call-template name="localMakeFoot"/>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>


<!-- vim:et:sw=4:sta
-->
