/* Test narrowing fma.
   Copyright (C) 1997-2022 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */

#include "libm-test-driver.c"

static const struct test_aaa_f_data fma_test_data[] =
  {
    TEST_aaa_f (fma, arg_qnan_value, 2.0, 3.0, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_qnan_value, 2.0, 3.0, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_snan_value, 2.0, 3.0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, -arg_snan_value, 2.0, 3.0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, 1.0, arg_qnan_value, 3.0, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, 1.0, -arg_qnan_value, 3.0, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, 1.0, arg_snan_value, 3.0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, 1.0, -arg_snan_value, 3.0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, 1.0, 2.0, arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, 1.0, 2.0, -arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, 1.0, 2.0, arg_snan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, 1.0, 2.0, -arg_snan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, arg_max_value, arg_max_value, arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_max_value, arg_max_value, -arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_value, arg_min_value, arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_value, arg_min_value, -arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_subnorm_value, arg_min_subnorm_value, arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_subnorm_value, arg_min_subnorm_value, -arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_max_value, arg_max_value, arg_snan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, arg_max_value, arg_max_value, -arg_snan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, arg_min_value, arg_min_value, arg_snan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, arg_min_value, arg_min_value, -arg_snan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, arg_min_subnorm_value, arg_min_subnorm_value, arg_snan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, arg_min_subnorm_value, arg_min_subnorm_value, -arg_snan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, arg_qnan_value, arg_qnan_value, arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_qnan_value, arg_qnan_value, -arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_qnan_value, -arg_qnan_value, arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_qnan_value, -arg_qnan_value, -arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_qnan_value, arg_qnan_value, arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_qnan_value, arg_qnan_value, -arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_qnan_value, -arg_qnan_value, arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_qnan_value, -arg_qnan_value, -arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_snan_value, arg_qnan_value, arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, arg_qnan_value, arg_snan_value, arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, arg_qnan_value, arg_qnan_value, arg_snan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, arg_snan_value, arg_snan_value, arg_snan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, 1.0, arg_qnan_value, arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, 1.0, arg_qnan_value, -arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, 1.0, -arg_qnan_value, arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, 1.0, -arg_qnan_value, -arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, 1.0, arg_snan_value, arg_snan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, arg_qnan_value, 2.0, arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_qnan_value, 2.0, -arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_qnan_value, 2.0, arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_qnan_value, 2.0, -arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_snan_value, 2.0, arg_snan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, arg_qnan_value, arg_qnan_value, 3.0, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_qnan_value, -arg_qnan_value, 3.0, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_qnan_value, arg_qnan_value, 3.0, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_qnan_value, -arg_qnan_value, 3.0, qnan_value, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_snan_value, arg_snan_value, 3.0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, arg_plus_infty, 0.0, arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION_OK),
    TEST_aaa_f (fma, arg_plus_infty, 0.0, -arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION_OK),
    TEST_aaa_f (fma, arg_minus_infty, 0.0, arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION_OK),
    TEST_aaa_f (fma, arg_minus_infty, 0.0, -arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION_OK),
    TEST_aaa_f (fma, arg_plus_infty, 0.0, arg_snan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, arg_plus_infty, 0.0, -arg_snan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, arg_minus_infty, 0.0, arg_snan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, arg_minus_infty, 0.0, -arg_snan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, 0.0, arg_plus_infty, arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION_OK),
    TEST_aaa_f (fma, 0.0, arg_plus_infty, -arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION_OK),
    TEST_aaa_f (fma, 0.0, arg_minus_infty, arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION_OK),
    TEST_aaa_f (fma, 0.0, arg_minus_infty, -arg_qnan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION_OK),
    TEST_aaa_f (fma, 0.0, arg_plus_infty, arg_snan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, 0.0, arg_plus_infty, -arg_snan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, 0.0, arg_minus_infty, arg_snan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, 0.0, arg_minus_infty, -arg_snan_value, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    /* Bug 6801: errno setting may be missing.  */
    TEST_aaa_f (fma, arg_plus_infty, 0.0, 1.0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, arg_minus_infty, 0.0, 1.0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, 0.0, arg_plus_infty, 1.0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, 0.0, arg_minus_infty, 1.0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),

    TEST_aaa_f (fma, arg_plus_infty, arg_plus_infty, arg_minus_infty, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, arg_minus_infty, arg_plus_infty, arg_plus_infty, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, arg_plus_infty, arg_minus_infty, arg_plus_infty, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, arg_minus_infty, arg_minus_infty, arg_minus_infty, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, arg_plus_infty, 3.5L, arg_minus_infty, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, arg_minus_infty, -7.5L, arg_minus_infty, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, -13.5L, arg_plus_infty, arg_plus_infty, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),
    TEST_aaa_f (fma, arg_minus_infty, 7.5L, arg_plus_infty, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION),

    TEST_aaa_f (fma, -arg_max_value, -arg_max_value, arg_minus_infty, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_max_value / 2, arg_max_value / 2, arg_minus_infty, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_max_value, arg_max_value, arg_plus_infty, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_max_value / 2, -arg_max_value / 4, arg_plus_infty, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, 4, arg_plus_infty, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, 2, arg_minus_infty, arg_minus_infty, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_plus_infty, arg_plus_infty, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_minus_infty, arg_plus_infty, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_minus_infty, arg_minus_infty, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_plus_infty, arg_minus_infty, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),

    TEST_aaa_f (fma, arg_plus_infty, arg_plus_infty, arg_plus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_plus_infty, arg_minus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_plus_infty, arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_plus_infty, -arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_plus_infty, arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_plus_infty, -arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_plus_infty, arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_plus_infty, arg_plus_infty, -arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_plus_infty, arg_minus_infty, arg_plus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_minus_infty, arg_minus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_minus_infty, arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_minus_infty, -arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_minus_infty, arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_minus_infty, -arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_minus_infty, arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_plus_infty, arg_minus_infty, -arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_minus_infty, arg_plus_infty, arg_plus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_plus_infty, arg_minus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_plus_infty, arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_plus_infty, -arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_plus_infty, arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_plus_infty, -arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_plus_infty, arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_minus_infty, arg_plus_infty, -arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_minus_infty, arg_minus_infty, arg_plus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_minus_infty, arg_minus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_minus_infty, arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_minus_infty, -arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_minus_infty, arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_minus_infty, -arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_minus_infty, arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_minus_infty, arg_minus_infty, -arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),

    TEST_aaa_f (fma, arg_plus_infty, arg_max_value, arg_plus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_max_value, arg_minus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_max_value, arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_max_value, -arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_max_value, arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_max_value, -arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_max_value, arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_plus_infty, arg_max_value, -arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_plus_infty, arg_min_value, arg_plus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_min_value, arg_minus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_min_value, arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_min_value, -arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_min_value, arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_min_value, -arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_min_value, arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_plus_infty, arg_min_value, -arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_plus_infty, arg_min_subnorm_value, arg_plus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_min_subnorm_value, arg_minus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_min_subnorm_value, arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_min_subnorm_value, -arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_min_subnorm_value, arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_min_subnorm_value, -arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, arg_min_subnorm_value, arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_plus_infty, arg_min_subnorm_value, -arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_plus_infty, -arg_max_value, arg_plus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, -arg_max_value, arg_minus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, -arg_max_value, arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, -arg_max_value, -arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, -arg_max_value, arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, -arg_max_value, -arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, -arg_max_value, arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_plus_infty, -arg_max_value, -arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_plus_infty, -arg_min_value, arg_plus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, -arg_min_value, arg_minus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, -arg_min_value, arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, -arg_min_value, -arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, -arg_min_value, arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, -arg_min_value, -arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, -arg_min_value, arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_plus_infty, -arg_min_value, -arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_plus_infty, -arg_min_subnorm_value, arg_plus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, -arg_min_subnorm_value, arg_minus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, -arg_min_subnorm_value, arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, -arg_min_subnorm_value, -arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, -arg_min_subnorm_value, arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, -arg_min_subnorm_value, -arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_plus_infty, -arg_min_subnorm_value, arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_plus_infty, -arg_min_subnorm_value, -arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_minus_infty, arg_max_value, arg_plus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_max_value, arg_minus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_max_value, arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_max_value, -arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_max_value, arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_max_value, -arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_max_value, arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_minus_infty, arg_max_value, -arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_minus_infty, arg_min_value, arg_plus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_min_value, arg_minus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_min_value, arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_min_value, -arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_min_value, arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_min_value, -arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_min_value, arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_minus_infty, arg_min_value, -arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_minus_infty, arg_min_subnorm_value, arg_plus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_min_subnorm_value, arg_minus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_min_subnorm_value, arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_min_subnorm_value, -arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_min_subnorm_value, arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_min_subnorm_value, -arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, arg_min_subnorm_value, arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_minus_infty, arg_min_subnorm_value, -arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_minus_infty, -arg_max_value, arg_plus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, -arg_max_value, arg_minus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, -arg_max_value, arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, -arg_max_value, -arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, -arg_max_value, arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, -arg_max_value, -arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, -arg_max_value, arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_minus_infty, -arg_max_value, -arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_minus_infty, -arg_min_value, arg_plus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, -arg_min_value, arg_minus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, -arg_min_value, arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, -arg_min_value, -arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, -arg_min_value, arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, -arg_min_value, -arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, -arg_min_value, arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_minus_infty, -arg_min_value, -arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_minus_infty, -arg_min_subnorm_value, arg_plus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, -arg_min_subnorm_value, arg_minus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, -arg_min_subnorm_value, arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, -arg_min_subnorm_value, -arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, -arg_min_subnorm_value, arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, -arg_min_subnorm_value, -arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_minus_infty, -arg_min_subnorm_value, arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_minus_infty, -arg_min_subnorm_value, -arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_max_value, arg_plus_infty, arg_plus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_max_value, arg_plus_infty, arg_minus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_max_value, arg_plus_infty, arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_max_value, arg_plus_infty, -arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_max_value, arg_plus_infty, arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_max_value, arg_plus_infty, -arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_max_value, arg_plus_infty, arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_max_value, arg_plus_infty, -arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_min_value, arg_plus_infty, arg_plus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_value, arg_plus_infty, arg_minus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_value, arg_plus_infty, arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_value, arg_plus_infty, -arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_value, arg_plus_infty, arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_value, arg_plus_infty, -arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_value, arg_plus_infty, arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_min_value, arg_plus_infty, -arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_min_subnorm_value, arg_plus_infty, arg_plus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_subnorm_value, arg_plus_infty, arg_minus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_subnorm_value, arg_plus_infty, arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_subnorm_value, arg_plus_infty, -arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_subnorm_value, arg_plus_infty, arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_subnorm_value, arg_plus_infty, -arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_subnorm_value, arg_plus_infty, arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_min_subnorm_value, arg_plus_infty, -arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, -arg_max_value, arg_plus_infty, arg_plus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_max_value, arg_plus_infty, arg_minus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_max_value, arg_plus_infty, arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_max_value, arg_plus_infty, -arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_max_value, arg_plus_infty, arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_max_value, arg_plus_infty, -arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_max_value, arg_plus_infty, arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, -arg_max_value, arg_plus_infty, -arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, -arg_min_value, arg_plus_infty, arg_plus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_min_value, arg_plus_infty, arg_minus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_min_value, arg_plus_infty, arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_min_value, arg_plus_infty, -arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_min_value, arg_plus_infty, arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_min_value, arg_plus_infty, -arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_min_value, arg_plus_infty, arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, -arg_min_value, arg_plus_infty, -arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, -arg_min_subnorm_value, arg_plus_infty, arg_plus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_min_subnorm_value, arg_plus_infty, arg_minus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_min_subnorm_value, arg_plus_infty, arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_min_subnorm_value, arg_plus_infty, -arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_min_subnorm_value, arg_plus_infty, arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_min_subnorm_value, arg_plus_infty, -arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_min_subnorm_value, arg_plus_infty, arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, -arg_min_subnorm_value, arg_plus_infty, -arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_max_value, arg_minus_infty, arg_plus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_max_value, arg_minus_infty, arg_minus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_max_value, arg_minus_infty, arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_max_value, arg_minus_infty, -arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_max_value, arg_minus_infty, arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_max_value, arg_minus_infty, -arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_max_value, arg_minus_infty, arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_max_value, arg_minus_infty, -arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_min_value, arg_minus_infty, arg_plus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_value, arg_minus_infty, arg_minus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_value, arg_minus_infty, arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_value, arg_minus_infty, -arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_value, arg_minus_infty, arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_value, arg_minus_infty, -arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_value, arg_minus_infty, arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_min_value, arg_minus_infty, -arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_min_subnorm_value, arg_minus_infty, arg_plus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_subnorm_value, arg_minus_infty, arg_minus_zero, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_subnorm_value, arg_minus_infty, arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_subnorm_value, arg_minus_infty, -arg_min_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_subnorm_value, arg_minus_infty, arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_subnorm_value, arg_minus_infty, -arg_min_subnorm_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, arg_min_subnorm_value, arg_minus_infty, arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, arg_min_subnorm_value, arg_minus_infty, -arg_max_value, minus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, -arg_max_value, arg_minus_infty, arg_plus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_max_value, arg_minus_infty, arg_minus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_max_value, arg_minus_infty, arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_max_value, arg_minus_infty, -arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_max_value, arg_minus_infty, arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_max_value, arg_minus_infty, -arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_max_value, arg_minus_infty, arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, -arg_max_value, arg_minus_infty, -arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, -arg_min_value, arg_minus_infty, arg_plus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_min_value, arg_minus_infty, arg_minus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_min_value, arg_minus_infty, arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_min_value, arg_minus_infty, -arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_min_value, arg_minus_infty, arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_min_value, arg_minus_infty, -arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_min_value, arg_minus_infty, arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, -arg_min_value, arg_minus_infty, -arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, -arg_min_subnorm_value, arg_minus_infty, arg_plus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_min_subnorm_value, arg_minus_infty, arg_minus_zero, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_min_subnorm_value, arg_minus_infty, arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_min_subnorm_value, arg_minus_infty, -arg_min_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_min_subnorm_value, arg_minus_infty, arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_min_subnorm_value, arg_minus_infty, -arg_min_subnorm_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_aaa_f (fma, -arg_min_subnorm_value, arg_minus_infty, arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),
    TEST_aaa_f (fma, -arg_min_subnorm_value, arg_minus_infty, -arg_max_value, plus_infty, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED|XFAIL_ROUNDING_IBM128_LIBGCC),

    AUTO_TESTS_aaa_f (fma),
  };

static void
fma_test (void)
{
  ALL_RM_TEST (fma, 1, fma_test_data, RUN_TEST_LOOP_aaa_f, END);
}

static void
do_test (void)
{
  fma_test ();
}

/*
 * Local Variables:
 * mode:c
 * End:
 */
