# GNOME Activity Journal

GNOME Activity Journal is a tool for easily browsing and finding files
that you worked on. It uses [zeitgeist][zeitgeist] backend store, to
get information and metadata on what files/websites/contacts/etc. you
worked with. It also keeps a chronological journal of all file
activity and supports tagging and establishing relationships between
groups of files.

For more information about GNOME Activity Journal, see the [project
wiki][project-wiki].

## Bugs

Bugs should be reported to the GNOME [bug tracking system][bug-tracker].

## Dependencies

Required:

- GTK 3.24 or later
- zeitgeist 1.0.3 or later
- python3-zeitgeist 1.0.3 or later
- gnomedesktop-3.0 gir bindings
- pangocairo-1.0 gir bindings
- python3-gi
- python3-cairo
- python3-xdg
- python3-distutils
- python3-distutils-extra

Optional:

- gstreamer1.0 gir bindings - 1.16 or later ( for audio preview feature )
- gstreamer1.0-gtk3 gir bindings - 1.16 or later ( for video preview feature )
- python3-pip ( for manual system-wide install )

## Building and installing manually:

### Run app without installation: ( normal user )

Here, the app can be built and run directly from source tree.

```console
// run
$ git clone https://gitlab.gnome.org/crvi/gnome-activity-journal.git
$ cd gnome-activity-journal
$ ./run.sh
```

### System-wide install: ( needs root access )

```console
// build
$ git clone https://gitlab.gnome.org/crvi/gnome-activity-journal.git
$ cd gnome-activity-journal
$ ./setup.py build

// install from same dir ( as root )
$ sudo pip3 install .
$ sudo glib-compile-schemas /usr/local/share/glib-2.0/schemas/

// run ( as normal user )
$ /usr/local/bin/gnome-activity-journal
```

### System-wide install information:

```console
$ pip3 show gnome-activity-journal
```

### System-wide uninstall: ( needs root access )

```console
$ sudo pip3 uninstall gnome-activity-journal
$ sudo glib-compile-schemas /usr/local/share/glib-2.0/schemas/
```

## Contributing

To contribute, open merge requests [New Merge Request][new-merge-request]

Commit messages should follow the [GNOME commit message
guidelines](https://wiki.gnome.org/Git/CommitMessages). We require an URL
to either an issue or a merge request in each commit.

## License

GNOME Activity Journal is distributed under the terms of the GNU General Public License,
version 3 or later. See the [COPYING][license] file for details.

Artwork is distributed under Creative Commons Attribution Share-Alike
License. See [CC BY-SA 3.0][cc-by-sa-3] for details.

## Copyright

See [AUTHORS][authors] and the source file's headers for the copyright holder's names.

Additionally, some images use textures or other resources from 3rd parties
not directly involved with the project. Those are:

 org.gnome.ActivityJournal.svg:
  - Luigi Chiesa, 2007
    http://commons.wikimedia.org/wiki/File:Jute_nahtlos.png

## Code Of Conduct
We follow the [GNOME Code of Conduct][gnome-coc].
All communications in project spaces are expected to follow it.

[zeitgeist]: https://gitlab.freedesktop.org/zeitgeist/zeitgeist
[project-wiki]: https://wiki.gnome.org/Apps/ActivityJournal
[bug-tracker]: https://gitlab.gnome.org/crvi/gnome-activity-journal/issues
[gnome-coc]: https://wiki.gnome.org/Foundation/CodeOfConduct
[new-merge-request]: https://gitlab.gnome.org/crvi/gnome-activity-journal/-/merge_requests/new
[cc-by-sa-3]: http://creativecommons.org/licenses/by-sa/3.0/
[license]: COPYING
[authors]: AUTHORS
