// This file was generated by the Gtk# code generator.
// Any changes made will be lost if regenerated.

namespace Gst {

	using System;
	using System.Runtime.InteropServices;

#region Autogenerated code
	public partial class Util {

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern unsafe IntPtr gst_filename_to_uri(IntPtr filename, out IntPtr error);

		public static unsafe string FilenameToUri(string filename) {
			IntPtr native_filename = GLib.Marshaller.StringToFilenamePtr (filename);
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = gst_filename_to_uri(native_filename, out error);
			string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
			GLib.Marshaller.Free (native_filename);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gst_format_get_by_nick(IntPtr nick);

		public static Gst.Format FormatGetByNick(string nick) {
			IntPtr native_nick = GLib.Marshaller.StringToPtrGStrdup (nick);
			int raw_ret = gst_format_get_by_nick(native_nick);
			Gst.Format ret = (Gst.Format) raw_ret;
			GLib.Marshaller.Free (native_nick);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_format_get_details(int format);

		public static Gst.FormatDefinition FormatGetDetails(Gst.Format format) {
			IntPtr raw_ret = gst_format_get_details((int) format);
			Gst.FormatDefinition ret = Gst.FormatDefinition.New (raw_ret);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_format_get_name(int format);

		public static string FormatGetName(Gst.Format format) {
			IntPtr raw_ret = gst_format_get_name((int) format);
			string ret = GLib.Marshaller.Utf8PtrToString (raw_ret);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_format_iterate_definitions();

		public static Gst.Iterator FormatIterateDefinitions() {
			IntPtr raw_ret = gst_format_iterate_definitions();
			Gst.Iterator ret = raw_ret == IntPtr.Zero ? null : (Gst.Iterator) GLib.Opaque.GetOpaque (raw_ret, typeof (Gst.Iterator), true);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gst_format_register(IntPtr nick, IntPtr description);

		public static Gst.Format FormatRegister(string nick, string description) {
			IntPtr native_nick = GLib.Marshaller.StringToPtrGStrdup (nick);
			IntPtr native_description = GLib.Marshaller.StringToPtrGStrdup (description);
			int raw_ret = gst_format_register(native_nick, native_description);
			Gst.Format ret = (Gst.Format) raw_ret;
			GLib.Marshaller.Free (native_nick);
			GLib.Marshaller.Free (native_description);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern uint gst_format_to_quark(int format);

		public static uint FormatToQuark(Gst.Format format) {
			uint raw_ret = gst_format_to_quark((int) format);
			uint ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_uri_construct(IntPtr protocol, IntPtr location);

		[Obsolete]
		public static string UriConstruct(string protocol, string location) {
			IntPtr native_protocol = GLib.Marshaller.StringToPtrGStrdup (protocol);
			IntPtr native_location = GLib.Marshaller.StringToPtrGStrdup (location);
			IntPtr raw_ret = gst_uri_construct(native_protocol, native_location);
			string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
			GLib.Marshaller.Free (native_protocol);
			GLib.Marshaller.Free (native_location);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern uint gst_uri_error_quark();

		public static uint UriErrorQuark() {
			uint raw_ret = gst_uri_error_quark();
			uint ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_uri_from_string(IntPtr uri);

		public static Gst.Uri UriFromString(string uri) {
			IntPtr native_uri = GLib.Marshaller.StringToPtrGStrdup (uri);
			IntPtr raw_ret = gst_uri_from_string(native_uri);
			Gst.Uri ret = Gst.Uri.New (raw_ret);
			GLib.Marshaller.Free (native_uri);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_uri_from_string_escaped(IntPtr uri);

		public static Gst.Uri UriFromStringEscaped(string uri) {
			IntPtr native_uri = GLib.Marshaller.StringToPtrGStrdup (uri);
			IntPtr raw_ret = gst_uri_from_string_escaped(native_uri);
			Gst.Uri ret = Gst.Uri.New (raw_ret);
			GLib.Marshaller.Free (native_uri);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_uri_get_location(IntPtr uri);

		public static string UriGetLocation(string uri) {
			IntPtr native_uri = GLib.Marshaller.StringToPtrGStrdup (uri);
			IntPtr raw_ret = gst_uri_get_location(native_uri);
			string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
			GLib.Marshaller.Free (native_uri);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_uri_get_protocol(IntPtr uri);

		public static string UriGetProtocol(string uri) {
			IntPtr native_uri = GLib.Marshaller.StringToPtrGStrdup (uri);
			IntPtr raw_ret = gst_uri_get_protocol(native_uri);
			string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
			GLib.Marshaller.Free (native_uri);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_uri_has_protocol(IntPtr uri, IntPtr protocol);

		public static bool UriHasProtocol(string uri, string protocol) {
			IntPtr native_uri = GLib.Marshaller.StringToPtrGStrdup (uri);
			IntPtr native_protocol = GLib.Marshaller.StringToPtrGStrdup (protocol);
			bool raw_ret = gst_uri_has_protocol(native_uri, native_protocol);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_uri);
			GLib.Marshaller.Free (native_protocol);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_uri_is_valid(IntPtr uri);

		public static bool UriIsValid(string uri) {
			IntPtr native_uri = GLib.Marshaller.StringToPtrGStrdup (uri);
			bool raw_ret = gst_uri_is_valid(native_uri);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_uri);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gst_uri_join_strings(IntPtr base_uri, IntPtr ref_uri);

		public static string UriJoinStrings(string base_uri, string ref_uri) {
			IntPtr native_base_uri = GLib.Marshaller.StringToPtrGStrdup (base_uri);
			IntPtr native_ref_uri = GLib.Marshaller.StringToPtrGStrdup (ref_uri);
			IntPtr raw_ret = gst_uri_join_strings(native_base_uri, native_ref_uri);
			string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
			GLib.Marshaller.Free (native_base_uri);
			GLib.Marshaller.Free (native_ref_uri);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_uri_protocol_is_supported(int type, IntPtr protocol);

		public static bool UriProtocolIsSupported(Gst.URIType type, string protocol) {
			IntPtr native_protocol = GLib.Marshaller.StringToPtrGStrdup (protocol);
			bool raw_ret = gst_uri_protocol_is_supported((int) type, native_protocol);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_protocol);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_uri_protocol_is_valid(IntPtr protocol);

		public static bool UriProtocolIsValid(string protocol) {
			IntPtr native_protocol = GLib.Marshaller.StringToPtrGStrdup (protocol);
			bool raw_ret = gst_uri_protocol_is_valid(native_protocol);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_protocol);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_util_double_to_fraction(double src, out int dest_n, out int dest_d);

		public static void DoubleToFraction(double src, out int dest_n, out int dest_d) {
			gst_util_double_to_fraction(src, out dest_n, out dest_d);
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_util_dump_buffer(IntPtr buf);

		public static void DumpBuffer(Gst.Buffer buf) {
			gst_util_dump_buffer(buf == null ? IntPtr.Zero : buf.Handle);
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_util_dump_mem(byte[] mem, uint size);

		public static void DumpMem(byte[] mem, uint size) {
			gst_util_dump_mem(mem, size);
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_util_fraction_add(int a_n, int a_d, int b_n, int b_d, out int res_n, out int res_d);

		public static bool FractionAdd(int a_n, int a_d, int b_n, int b_d, out int res_n, out int res_d) {
			bool raw_ret = gst_util_fraction_add(a_n, a_d, b_n, b_d, out res_n, out res_d);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gst_util_fraction_compare(int a_n, int a_d, int b_n, int b_d);

		public static int FractionCompare(int a_n, int a_d, int b_n, int b_d) {
			int raw_ret = gst_util_fraction_compare(a_n, a_d, b_n, b_d);
			int ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_util_fraction_multiply(int a_n, int a_d, int b_n, int b_d, out int res_n, out int res_d);

		public static bool FractionMultiply(int a_n, int a_d, int b_n, int b_d, out int res_n, out int res_d) {
			bool raw_ret = gst_util_fraction_multiply(a_n, a_d, b_n, b_d, out res_n, out res_d);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_util_fraction_to_double(int src_n, int src_d, out double dest);

		public static double FractionToDouble(int src_n, int src_d) {
			double dest;
			gst_util_fraction_to_double(src_n, src_d, out dest);
			return dest;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern ulong gst_util_gdouble_to_guint64(double value);

		public static ulong GdoubleToGuint64(double value) {
			ulong raw_ret = gst_util_gdouble_to_guint64(value);
			ulong ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_util_get_object_array(IntPtr _object, IntPtr name, out IntPtr array);

		public static bool GetObjectArray(GLib.Object _object, string name, out GLib.ValueArray array) {
			IntPtr native_name = GLib.Marshaller.StringToPtrGStrdup (name);
			IntPtr native_array;
			bool raw_ret = gst_util_get_object_array(_object == null ? IntPtr.Zero : _object.Handle, native_name, out native_array);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_name);
			array = new GLib.ValueArray(native_array);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern ulong gst_util_get_timestamp();

		public static ulong GetTimestamp() {
			ulong raw_ret = gst_util_get_timestamp();
			ulong ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gst_util_greatest_common_divisor(int a, int b);

		public static int GreatestCommonDivisor(int a, int b) {
			int raw_ret = gst_util_greatest_common_divisor(a, b);
			int ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern long gst_util_greatest_common_divisor_int64(long a, long b);

		public static long GreatestCommonDivisorInt64(long a, long b) {
			long raw_ret = gst_util_greatest_common_divisor_int64(a, b);
			long ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern uint gst_util_group_id_next();

		public static uint GroupIdNext() {
			uint raw_ret = gst_util_group_id_next();
			uint ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern double gst_util_guint64_to_gdouble(ulong value);

		public static double Guint64ToGdouble(ulong value) {
			double raw_ret = gst_util_guint64_to_gdouble(value);
			double ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gst_util_seqnum_compare(uint s1, uint s2);

		public static int SeqnumCompare(uint s1, uint s2) {
			int raw_ret = gst_util_seqnum_compare(s1, s2);
			int ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern uint gst_util_seqnum_next();

		public static uint SeqnumNext() {
			uint raw_ret = gst_util_seqnum_next();
			uint ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_util_set_object_arg(IntPtr _object, IntPtr name, IntPtr value);

		public static void SetObjectArg(GLib.Object _object, string name, string value) {
			IntPtr native_name = GLib.Marshaller.StringToPtrGStrdup (name);
			IntPtr native_value = GLib.Marshaller.StringToPtrGStrdup (value);
			gst_util_set_object_arg(_object == null ? IntPtr.Zero : _object.Handle, native_name, native_value);
			GLib.Marshaller.Free (native_name);
			GLib.Marshaller.Free (native_value);
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gst_util_set_object_array(IntPtr _object, IntPtr name, IntPtr array);

		public static bool SetObjectArray(GLib.Object _object, string name, GLib.ValueArray array) {
			IntPtr native_name = GLib.Marshaller.StringToPtrGStrdup (name);
			bool raw_ret = gst_util_set_object_array(_object == null ? IntPtr.Zero : _object.Handle, native_name, array == null ? IntPtr.Zero : array.Handle);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_name);
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gst_util_set_value_from_string(IntPtr value, IntPtr value_str);

		public static GLib.Value SetValueFromString(string value_str) {
			GLib.Value value;
			IntPtr native_value = Marshal.AllocHGlobal (Marshal.SizeOf (typeof (GLib.Value)));
			IntPtr native_value_str = GLib.Marshaller.StringToPtrGStrdup (value_str);
			gst_util_set_value_from_string(native_value, native_value_str);
			value = (GLib.Value) Marshal.PtrToStructure (native_value, typeof (GLib.Value));
			Marshal.FreeHGlobal (native_value);
			GLib.Marshaller.Free (native_value_str);
			return value;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern ulong gst_util_uint64_scale(ulong val, ulong num, ulong denom);

		public static ulong Uint64Scale(ulong val, ulong num, ulong denom) {
			ulong raw_ret = gst_util_uint64_scale(val, num, denom);
			ulong ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern ulong gst_util_uint64_scale_ceil(ulong val, ulong num, ulong denom);

		public static ulong Uint64ScaleCeil(ulong val, ulong num, ulong denom) {
			ulong raw_ret = gst_util_uint64_scale_ceil(val, num, denom);
			ulong ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern ulong gst_util_uint64_scale_int(ulong val, int num, int denom);

		public static ulong Uint64ScaleInt(ulong val, int num, int denom) {
			ulong raw_ret = gst_util_uint64_scale_int(val, num, denom);
			ulong ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern ulong gst_util_uint64_scale_int_ceil(ulong val, int num, int denom);

		public static ulong Uint64ScaleIntCeil(ulong val, int num, int denom) {
			ulong raw_ret = gst_util_uint64_scale_int_ceil(val, num, denom);
			ulong ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern ulong gst_util_uint64_scale_int_round(ulong val, int num, int denom);

		public static ulong Uint64ScaleIntRound(ulong val, int num, int denom) {
			ulong raw_ret = gst_util_uint64_scale_int_round(val, num, denom);
			ulong ret = raw_ret;
			return ret;
		}

		[DllImport("gstreamer-1.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern ulong gst_util_uint64_scale_round(ulong val, ulong num, ulong denom);

		public static ulong Uint64ScaleRound(ulong val, ulong num, ulong denom) {
			ulong raw_ret = gst_util_uint64_scale_round(val, num, denom);
			ulong ret = raw_ret;
			return ret;
		}

#endregion
	}
}
