// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appintegrationsservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateApplication = "CreateApplication"

// CreateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApplication for more information on using the CreateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateApplicationRequest method.
//	req, resp := client.CreateApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/CreateApplication
func (c *AppIntegrationsService) CreateApplicationRequest(input *CreateApplicationInput) (req *request.Request, output *CreateApplicationOutput) {
	op := &request.Operation{
		Name:       opCreateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/applications",
	}

	if input == nil {
		input = &CreateApplicationInput{}
	}

	output = &CreateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApplication API operation for Amazon AppIntegrations Service.
//
// This API is in preview release and subject to change.
//
// Creates and persists an Application resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation CreateApplication for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceError
//     Request processing failed due to an error or failure with the service.
//
//   - ResourceQuotaExceededException
//     The allowed quota for the resource has been exceeded.
//
//   - DuplicateResourceException
//     A resource with the specified name already exists.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/CreateApplication
func (c *AppIntegrationsService) CreateApplication(input *CreateApplicationInput) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	return out, req.Send()
}

// CreateApplicationWithContext is the same as CreateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) CreateApplicationWithContext(ctx aws.Context, input *CreateApplicationInput, opts ...request.Option) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataIntegration = "CreateDataIntegration"

// CreateDataIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataIntegration for more information on using the CreateDataIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDataIntegrationRequest method.
//	req, resp := client.CreateDataIntegrationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/CreateDataIntegration
func (c *AppIntegrationsService) CreateDataIntegrationRequest(input *CreateDataIntegrationInput) (req *request.Request, output *CreateDataIntegrationOutput) {
	op := &request.Operation{
		Name:       opCreateDataIntegration,
		HTTPMethod: "POST",
		HTTPPath:   "/dataIntegrations",
	}

	if input == nil {
		input = &CreateDataIntegrationInput{}
	}

	output = &CreateDataIntegrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataIntegration API operation for Amazon AppIntegrations Service.
//
// Creates and persists a DataIntegration resource.
//
// You cannot create a DataIntegration association for a DataIntegration that
// has been previously associated. Use a different DataIntegration, or recreate
// the DataIntegration using the CreateDataIntegration API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation CreateDataIntegration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceError
//     Request processing failed due to an error or failure with the service.
//
//   - ResourceQuotaExceededException
//     The allowed quota for the resource has been exceeded.
//
//   - DuplicateResourceException
//     A resource with the specified name already exists.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/CreateDataIntegration
func (c *AppIntegrationsService) CreateDataIntegration(input *CreateDataIntegrationInput) (*CreateDataIntegrationOutput, error) {
	req, out := c.CreateDataIntegrationRequest(input)
	return out, req.Send()
}

// CreateDataIntegrationWithContext is the same as CreateDataIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) CreateDataIntegrationWithContext(ctx aws.Context, input *CreateDataIntegrationInput, opts ...request.Option) (*CreateDataIntegrationOutput, error) {
	req, out := c.CreateDataIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEventIntegration = "CreateEventIntegration"

// CreateEventIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the CreateEventIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEventIntegration for more information on using the CreateEventIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEventIntegrationRequest method.
//	req, resp := client.CreateEventIntegrationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/CreateEventIntegration
func (c *AppIntegrationsService) CreateEventIntegrationRequest(input *CreateEventIntegrationInput) (req *request.Request, output *CreateEventIntegrationOutput) {
	op := &request.Operation{
		Name:       opCreateEventIntegration,
		HTTPMethod: "POST",
		HTTPPath:   "/eventIntegrations",
	}

	if input == nil {
		input = &CreateEventIntegrationInput{}
	}

	output = &CreateEventIntegrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEventIntegration API operation for Amazon AppIntegrations Service.
//
// Creates an EventIntegration, given a specified name, description, and a reference
// to an Amazon EventBridge bus in your account and a partner event source that
// pushes events to that bus. No objects are created in the your account, only
// metadata that is persisted on the EventIntegration control plane.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation CreateEventIntegration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceError
//     Request processing failed due to an error or failure with the service.
//
//   - ResourceQuotaExceededException
//     The allowed quota for the resource has been exceeded.
//
//   - DuplicateResourceException
//     A resource with the specified name already exists.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/CreateEventIntegration
func (c *AppIntegrationsService) CreateEventIntegration(input *CreateEventIntegrationInput) (*CreateEventIntegrationOutput, error) {
	req, out := c.CreateEventIntegrationRequest(input)
	return out, req.Send()
}

// CreateEventIntegrationWithContext is the same as CreateEventIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEventIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) CreateEventIntegrationWithContext(ctx aws.Context, input *CreateEventIntegrationInput, opts ...request.Option) (*CreateEventIntegrationOutput, error) {
	req, out := c.CreateEventIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataIntegration = "DeleteDataIntegration"

// DeleteDataIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataIntegration for more information on using the DeleteDataIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDataIntegrationRequest method.
//	req, resp := client.DeleteDataIntegrationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/DeleteDataIntegration
func (c *AppIntegrationsService) DeleteDataIntegrationRequest(input *DeleteDataIntegrationInput) (req *request.Request, output *DeleteDataIntegrationOutput) {
	op := &request.Operation{
		Name:       opDeleteDataIntegration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/dataIntegrations/{Identifier}",
	}

	if input == nil {
		input = &DeleteDataIntegrationInput{}
	}

	output = &DeleteDataIntegrationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDataIntegration API operation for Amazon AppIntegrations Service.
//
// Deletes the DataIntegration. Only DataIntegrations that don't have any DataIntegrationAssociations
// can be deleted. Deleting a DataIntegration also deletes the underlying Amazon
// AppFlow flow and service linked role.
//
// You cannot create a DataIntegration association for a DataIntegration that
// has been previously associated. Use a different DataIntegration, or recreate
// the DataIntegration using the CreateDataIntegration (https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html)
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation DeleteDataIntegration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceError
//     Request processing failed due to an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/DeleteDataIntegration
func (c *AppIntegrationsService) DeleteDataIntegration(input *DeleteDataIntegrationInput) (*DeleteDataIntegrationOutput, error) {
	req, out := c.DeleteDataIntegrationRequest(input)
	return out, req.Send()
}

// DeleteDataIntegrationWithContext is the same as DeleteDataIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) DeleteDataIntegrationWithContext(ctx aws.Context, input *DeleteDataIntegrationInput, opts ...request.Option) (*DeleteDataIntegrationOutput, error) {
	req, out := c.DeleteDataIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventIntegration = "DeleteEventIntegration"

// DeleteEventIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventIntegration for more information on using the DeleteEventIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEventIntegrationRequest method.
//	req, resp := client.DeleteEventIntegrationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/DeleteEventIntegration
func (c *AppIntegrationsService) DeleteEventIntegrationRequest(input *DeleteEventIntegrationInput) (req *request.Request, output *DeleteEventIntegrationOutput) {
	op := &request.Operation{
		Name:       opDeleteEventIntegration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/eventIntegrations/{Name}",
	}

	if input == nil {
		input = &DeleteEventIntegrationInput{}
	}

	output = &DeleteEventIntegrationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEventIntegration API operation for Amazon AppIntegrations Service.
//
// Deletes the specified existing event integration. If the event integration
// is associated with clients, the request is rejected.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation DeleteEventIntegration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceError
//     Request processing failed due to an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/DeleteEventIntegration
func (c *AppIntegrationsService) DeleteEventIntegration(input *DeleteEventIntegrationInput) (*DeleteEventIntegrationOutput, error) {
	req, out := c.DeleteEventIntegrationRequest(input)
	return out, req.Send()
}

// DeleteEventIntegrationWithContext is the same as DeleteEventIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) DeleteEventIntegrationWithContext(ctx aws.Context, input *DeleteEventIntegrationInput, opts ...request.Option) (*DeleteEventIntegrationOutput, error) {
	req, out := c.DeleteEventIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApplication = "GetApplication"

// GetApplicationRequest generates a "aws/request.Request" representing the
// client's request for the GetApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApplication for more information on using the GetApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetApplicationRequest method.
//	req, resp := client.GetApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/GetApplication
func (c *AppIntegrationsService) GetApplicationRequest(input *GetApplicationInput) (req *request.Request, output *GetApplicationOutput) {
	op := &request.Operation{
		Name:       opGetApplication,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{Arn}",
	}

	if input == nil {
		input = &GetApplicationInput{}
	}

	output = &GetApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplication API operation for Amazon AppIntegrations Service.
//
// This API is in preview release and subject to change.
//
// Get an Application resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation GetApplication for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceError
//     Request processing failed due to an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/GetApplication
func (c *AppIntegrationsService) GetApplication(input *GetApplicationInput) (*GetApplicationOutput, error) {
	req, out := c.GetApplicationRequest(input)
	return out, req.Send()
}

// GetApplicationWithContext is the same as GetApplication with the addition of
// the ability to pass a context and additional request options.
//
// See GetApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) GetApplicationWithContext(ctx aws.Context, input *GetApplicationInput, opts ...request.Option) (*GetApplicationOutput, error) {
	req, out := c.GetApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDataIntegration = "GetDataIntegration"

// GetDataIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the GetDataIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataIntegration for more information on using the GetDataIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDataIntegrationRequest method.
//	req, resp := client.GetDataIntegrationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/GetDataIntegration
func (c *AppIntegrationsService) GetDataIntegrationRequest(input *GetDataIntegrationInput) (req *request.Request, output *GetDataIntegrationOutput) {
	op := &request.Operation{
		Name:       opGetDataIntegration,
		HTTPMethod: "GET",
		HTTPPath:   "/dataIntegrations/{Identifier}",
	}

	if input == nil {
		input = &GetDataIntegrationInput{}
	}

	output = &GetDataIntegrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataIntegration API operation for Amazon AppIntegrations Service.
//
// Returns information about the DataIntegration.
//
// You cannot create a DataIntegration association for a DataIntegration that
// has been previously associated. Use a different DataIntegration, or recreate
// the DataIntegration using the CreateDataIntegration (https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html)
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation GetDataIntegration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceError
//     Request processing failed due to an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/GetDataIntegration
func (c *AppIntegrationsService) GetDataIntegration(input *GetDataIntegrationInput) (*GetDataIntegrationOutput, error) {
	req, out := c.GetDataIntegrationRequest(input)
	return out, req.Send()
}

// GetDataIntegrationWithContext is the same as GetDataIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) GetDataIntegrationWithContext(ctx aws.Context, input *GetDataIntegrationInput, opts ...request.Option) (*GetDataIntegrationOutput, error) {
	req, out := c.GetDataIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEventIntegration = "GetEventIntegration"

// GetEventIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the GetEventIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEventIntegration for more information on using the GetEventIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEventIntegrationRequest method.
//	req, resp := client.GetEventIntegrationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/GetEventIntegration
func (c *AppIntegrationsService) GetEventIntegrationRequest(input *GetEventIntegrationInput) (req *request.Request, output *GetEventIntegrationOutput) {
	op := &request.Operation{
		Name:       opGetEventIntegration,
		HTTPMethod: "GET",
		HTTPPath:   "/eventIntegrations/{Name}",
	}

	if input == nil {
		input = &GetEventIntegrationInput{}
	}

	output = &GetEventIntegrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEventIntegration API operation for Amazon AppIntegrations Service.
//
// Returns information about the event integration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation GetEventIntegration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceError
//     Request processing failed due to an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/GetEventIntegration
func (c *AppIntegrationsService) GetEventIntegration(input *GetEventIntegrationInput) (*GetEventIntegrationOutput, error) {
	req, out := c.GetEventIntegrationRequest(input)
	return out, req.Send()
}

// GetEventIntegrationWithContext is the same as GetEventIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See GetEventIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) GetEventIntegrationWithContext(ctx aws.Context, input *GetEventIntegrationInput, opts ...request.Option) (*GetEventIntegrationOutput, error) {
	req, out := c.GetEventIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApplications = "ListApplications"

// ListApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplications for more information on using the ListApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListApplicationsRequest method.
//	req, resp := client.ListApplicationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListApplications
func (c *AppIntegrationsService) ListApplicationsRequest(input *ListApplicationsInput) (req *request.Request, output *ListApplicationsOutput) {
	op := &request.Operation{
		Name:       opListApplications,
		HTTPMethod: "GET",
		HTTPPath:   "/applications",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationsInput{}
	}

	output = &ListApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplications API operation for Amazon AppIntegrations Service.
//
// This API is in preview release and subject to change.
//
// Lists applications in the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation ListApplications for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceError
//     Request processing failed due to an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListApplications
func (c *AppIntegrationsService) ListApplications(input *ListApplicationsInput) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	return out, req.Send()
}

// ListApplicationsWithContext is the same as ListApplications with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) ListApplicationsWithContext(ctx aws.Context, input *ListApplicationsInput, opts ...request.Option) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationsPages iterates over the pages of a ListApplications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListApplications operation.
//	pageNum := 0
//	err := client.ListApplicationsPages(params,
//	    func(page *appintegrationsservice.ListApplicationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppIntegrationsService) ListApplicationsPages(input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool) error {
	return c.ListApplicationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationsPagesWithContext same as ListApplicationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) ListApplicationsPagesWithContext(ctx aws.Context, input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataIntegrationAssociations = "ListDataIntegrationAssociations"

// ListDataIntegrationAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListDataIntegrationAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataIntegrationAssociations for more information on using the ListDataIntegrationAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDataIntegrationAssociationsRequest method.
//	req, resp := client.ListDataIntegrationAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListDataIntegrationAssociations
func (c *AppIntegrationsService) ListDataIntegrationAssociationsRequest(input *ListDataIntegrationAssociationsInput) (req *request.Request, output *ListDataIntegrationAssociationsOutput) {
	op := &request.Operation{
		Name:       opListDataIntegrationAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/dataIntegrations/{Identifier}/associations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataIntegrationAssociationsInput{}
	}

	output = &ListDataIntegrationAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataIntegrationAssociations API operation for Amazon AppIntegrations Service.
//
// Returns a paginated list of DataIntegration associations in the account.
//
// You cannot create a DataIntegration association for a DataIntegration that
// has been previously associated. Use a different DataIntegration, or recreate
// the DataIntegration using the CreateDataIntegration (https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html)
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation ListDataIntegrationAssociations for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceError
//     Request processing failed due to an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListDataIntegrationAssociations
func (c *AppIntegrationsService) ListDataIntegrationAssociations(input *ListDataIntegrationAssociationsInput) (*ListDataIntegrationAssociationsOutput, error) {
	req, out := c.ListDataIntegrationAssociationsRequest(input)
	return out, req.Send()
}

// ListDataIntegrationAssociationsWithContext is the same as ListDataIntegrationAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataIntegrationAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) ListDataIntegrationAssociationsWithContext(ctx aws.Context, input *ListDataIntegrationAssociationsInput, opts ...request.Option) (*ListDataIntegrationAssociationsOutput, error) {
	req, out := c.ListDataIntegrationAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataIntegrationAssociationsPages iterates over the pages of a ListDataIntegrationAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataIntegrationAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDataIntegrationAssociations operation.
//	pageNum := 0
//	err := client.ListDataIntegrationAssociationsPages(params,
//	    func(page *appintegrationsservice.ListDataIntegrationAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppIntegrationsService) ListDataIntegrationAssociationsPages(input *ListDataIntegrationAssociationsInput, fn func(*ListDataIntegrationAssociationsOutput, bool) bool) error {
	return c.ListDataIntegrationAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataIntegrationAssociationsPagesWithContext same as ListDataIntegrationAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) ListDataIntegrationAssociationsPagesWithContext(ctx aws.Context, input *ListDataIntegrationAssociationsInput, fn func(*ListDataIntegrationAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataIntegrationAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataIntegrationAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataIntegrationAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataIntegrations = "ListDataIntegrations"

// ListDataIntegrationsRequest generates a "aws/request.Request" representing the
// client's request for the ListDataIntegrations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataIntegrations for more information on using the ListDataIntegrations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDataIntegrationsRequest method.
//	req, resp := client.ListDataIntegrationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListDataIntegrations
func (c *AppIntegrationsService) ListDataIntegrationsRequest(input *ListDataIntegrationsInput) (req *request.Request, output *ListDataIntegrationsOutput) {
	op := &request.Operation{
		Name:       opListDataIntegrations,
		HTTPMethod: "GET",
		HTTPPath:   "/dataIntegrations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataIntegrationsInput{}
	}

	output = &ListDataIntegrationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataIntegrations API operation for Amazon AppIntegrations Service.
//
// Returns a paginated list of DataIntegrations in the account.
//
// You cannot create a DataIntegration association for a DataIntegration that
// has been previously associated. Use a different DataIntegration, or recreate
// the DataIntegration using the CreateDataIntegration (https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html)
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation ListDataIntegrations for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceError
//     Request processing failed due to an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListDataIntegrations
func (c *AppIntegrationsService) ListDataIntegrations(input *ListDataIntegrationsInput) (*ListDataIntegrationsOutput, error) {
	req, out := c.ListDataIntegrationsRequest(input)
	return out, req.Send()
}

// ListDataIntegrationsWithContext is the same as ListDataIntegrations with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataIntegrations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) ListDataIntegrationsWithContext(ctx aws.Context, input *ListDataIntegrationsInput, opts ...request.Option) (*ListDataIntegrationsOutput, error) {
	req, out := c.ListDataIntegrationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataIntegrationsPages iterates over the pages of a ListDataIntegrations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataIntegrations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDataIntegrations operation.
//	pageNum := 0
//	err := client.ListDataIntegrationsPages(params,
//	    func(page *appintegrationsservice.ListDataIntegrationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppIntegrationsService) ListDataIntegrationsPages(input *ListDataIntegrationsInput, fn func(*ListDataIntegrationsOutput, bool) bool) error {
	return c.ListDataIntegrationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataIntegrationsPagesWithContext same as ListDataIntegrationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) ListDataIntegrationsPagesWithContext(ctx aws.Context, input *ListDataIntegrationsInput, fn func(*ListDataIntegrationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataIntegrationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataIntegrationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataIntegrationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEventIntegrationAssociations = "ListEventIntegrationAssociations"

// ListEventIntegrationAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListEventIntegrationAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEventIntegrationAssociations for more information on using the ListEventIntegrationAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEventIntegrationAssociationsRequest method.
//	req, resp := client.ListEventIntegrationAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrationAssociations
func (c *AppIntegrationsService) ListEventIntegrationAssociationsRequest(input *ListEventIntegrationAssociationsInput) (req *request.Request, output *ListEventIntegrationAssociationsOutput) {
	op := &request.Operation{
		Name:       opListEventIntegrationAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/eventIntegrations/{Name}/associations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEventIntegrationAssociationsInput{}
	}

	output = &ListEventIntegrationAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEventIntegrationAssociations API operation for Amazon AppIntegrations Service.
//
// Returns a paginated list of event integration associations in the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation ListEventIntegrationAssociations for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceError
//     Request processing failed due to an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrationAssociations
func (c *AppIntegrationsService) ListEventIntegrationAssociations(input *ListEventIntegrationAssociationsInput) (*ListEventIntegrationAssociationsOutput, error) {
	req, out := c.ListEventIntegrationAssociationsRequest(input)
	return out, req.Send()
}

// ListEventIntegrationAssociationsWithContext is the same as ListEventIntegrationAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListEventIntegrationAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) ListEventIntegrationAssociationsWithContext(ctx aws.Context, input *ListEventIntegrationAssociationsInput, opts ...request.Option) (*ListEventIntegrationAssociationsOutput, error) {
	req, out := c.ListEventIntegrationAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEventIntegrationAssociationsPages iterates over the pages of a ListEventIntegrationAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEventIntegrationAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEventIntegrationAssociations operation.
//	pageNum := 0
//	err := client.ListEventIntegrationAssociationsPages(params,
//	    func(page *appintegrationsservice.ListEventIntegrationAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppIntegrationsService) ListEventIntegrationAssociationsPages(input *ListEventIntegrationAssociationsInput, fn func(*ListEventIntegrationAssociationsOutput, bool) bool) error {
	return c.ListEventIntegrationAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEventIntegrationAssociationsPagesWithContext same as ListEventIntegrationAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) ListEventIntegrationAssociationsPagesWithContext(ctx aws.Context, input *ListEventIntegrationAssociationsInput, fn func(*ListEventIntegrationAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEventIntegrationAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEventIntegrationAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEventIntegrationAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEventIntegrations = "ListEventIntegrations"

// ListEventIntegrationsRequest generates a "aws/request.Request" representing the
// client's request for the ListEventIntegrations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEventIntegrations for more information on using the ListEventIntegrations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEventIntegrationsRequest method.
//	req, resp := client.ListEventIntegrationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrations
func (c *AppIntegrationsService) ListEventIntegrationsRequest(input *ListEventIntegrationsInput) (req *request.Request, output *ListEventIntegrationsOutput) {
	op := &request.Operation{
		Name:       opListEventIntegrations,
		HTTPMethod: "GET",
		HTTPPath:   "/eventIntegrations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEventIntegrationsInput{}
	}

	output = &ListEventIntegrationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEventIntegrations API operation for Amazon AppIntegrations Service.
//
// Returns a paginated list of event integrations in the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation ListEventIntegrations for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceError
//     Request processing failed due to an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrations
func (c *AppIntegrationsService) ListEventIntegrations(input *ListEventIntegrationsInput) (*ListEventIntegrationsOutput, error) {
	req, out := c.ListEventIntegrationsRequest(input)
	return out, req.Send()
}

// ListEventIntegrationsWithContext is the same as ListEventIntegrations with the addition of
// the ability to pass a context and additional request options.
//
// See ListEventIntegrations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) ListEventIntegrationsWithContext(ctx aws.Context, input *ListEventIntegrationsInput, opts ...request.Option) (*ListEventIntegrationsOutput, error) {
	req, out := c.ListEventIntegrationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEventIntegrationsPages iterates over the pages of a ListEventIntegrations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEventIntegrations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEventIntegrations operation.
//	pageNum := 0
//	err := client.ListEventIntegrationsPages(params,
//	    func(page *appintegrationsservice.ListEventIntegrationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *AppIntegrationsService) ListEventIntegrationsPages(input *ListEventIntegrationsInput, fn func(*ListEventIntegrationsOutput, bool) bool) error {
	return c.ListEventIntegrationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEventIntegrationsPagesWithContext same as ListEventIntegrationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) ListEventIntegrationsPagesWithContext(ctx aws.Context, input *ListEventIntegrationsInput, fn func(*ListEventIntegrationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEventIntegrationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEventIntegrationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEventIntegrationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListTagsForResource
func (c *AppIntegrationsService) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon AppIntegrations Service.
//
// Lists the tags for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InternalServiceError
//     Request processing failed due to an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListTagsForResource
func (c *AppIntegrationsService) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/TagResource
func (c *AppIntegrationsService) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon AppIntegrations Service.
//
// Adds the specified tags to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InternalServiceError
//     Request processing failed due to an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/TagResource
func (c *AppIntegrationsService) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UntagResource
func (c *AppIntegrationsService) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon AppIntegrations Service.
//
// Removes the specified tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InternalServiceError
//     Request processing failed due to an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UntagResource
func (c *AppIntegrationsService) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplication = "UpdateApplication"

// UpdateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApplication for more information on using the UpdateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateApplicationRequest method.
//	req, resp := client.UpdateApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UpdateApplication
func (c *AppIntegrationsService) UpdateApplicationRequest(input *UpdateApplicationInput) (req *request.Request, output *UpdateApplicationOutput) {
	op := &request.Operation{
		Name:       opUpdateApplication,
		HTTPMethod: "PATCH",
		HTTPPath:   "/applications/{Arn}",
	}

	if input == nil {
		input = &UpdateApplicationInput{}
	}

	output = &UpdateApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateApplication API operation for Amazon AppIntegrations Service.
//
// This API is in preview release and subject to change.
//
// Updates and persists an Application resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation UpdateApplication for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceError
//     Request processing failed due to an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UpdateApplication
func (c *AppIntegrationsService) UpdateApplication(input *UpdateApplicationInput) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	return out, req.Send()
}

// UpdateApplicationWithContext is the same as UpdateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) UpdateApplicationWithContext(ctx aws.Context, input *UpdateApplicationInput, opts ...request.Option) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataIntegration = "UpdateDataIntegration"

// UpdateDataIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataIntegration for more information on using the UpdateDataIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDataIntegrationRequest method.
//	req, resp := client.UpdateDataIntegrationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UpdateDataIntegration
func (c *AppIntegrationsService) UpdateDataIntegrationRequest(input *UpdateDataIntegrationInput) (req *request.Request, output *UpdateDataIntegrationOutput) {
	op := &request.Operation{
		Name:       opUpdateDataIntegration,
		HTTPMethod: "PATCH",
		HTTPPath:   "/dataIntegrations/{Identifier}",
	}

	if input == nil {
		input = &UpdateDataIntegrationInput{}
	}

	output = &UpdateDataIntegrationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDataIntegration API operation for Amazon AppIntegrations Service.
//
// Updates the description of a DataIntegration.
//
// You cannot create a DataIntegration association for a DataIntegration that
// has been previously associated. Use a different DataIntegration, or recreate
// the DataIntegration using the CreateDataIntegration (https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html)
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation UpdateDataIntegration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceError
//     Request processing failed due to an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UpdateDataIntegration
func (c *AppIntegrationsService) UpdateDataIntegration(input *UpdateDataIntegrationInput) (*UpdateDataIntegrationOutput, error) {
	req, out := c.UpdateDataIntegrationRequest(input)
	return out, req.Send()
}

// UpdateDataIntegrationWithContext is the same as UpdateDataIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) UpdateDataIntegrationWithContext(ctx aws.Context, input *UpdateDataIntegrationInput, opts ...request.Option) (*UpdateDataIntegrationOutput, error) {
	req, out := c.UpdateDataIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEventIntegration = "UpdateEventIntegration"

// UpdateEventIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEventIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEventIntegration for more information on using the UpdateEventIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEventIntegrationRequest method.
//	req, resp := client.UpdateEventIntegrationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UpdateEventIntegration
func (c *AppIntegrationsService) UpdateEventIntegrationRequest(input *UpdateEventIntegrationInput) (req *request.Request, output *UpdateEventIntegrationOutput) {
	op := &request.Operation{
		Name:       opUpdateEventIntegration,
		HTTPMethod: "PATCH",
		HTTPPath:   "/eventIntegrations/{Name}",
	}

	if input == nil {
		input = &UpdateEventIntegrationInput{}
	}

	output = &UpdateEventIntegrationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateEventIntegration API operation for Amazon AppIntegrations Service.
//
// Updates the description of an event integration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation UpdateEventIntegration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceError
//     Request processing failed due to an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UpdateEventIntegration
func (c *AppIntegrationsService) UpdateEventIntegration(input *UpdateEventIntegrationInput) (*UpdateEventIntegrationOutput, error) {
	req, out := c.UpdateEventIntegrationRequest(input)
	return out, req.Send()
}

// UpdateEventIntegrationWithContext is the same as UpdateEventIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEventIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) UpdateEventIntegrationWithContext(ctx aws.Context, input *UpdateEventIntegrationInput, opts ...request.Option) (*UpdateEventIntegrationOutput, error) {
	req, out := c.UpdateEventIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration for where the application should be loaded from.
type ApplicationSourceConfig struct {
	_ struct{} `type:"structure"`

	// The external URL source for the application.
	ExternalUrlConfig *ExternalUrlConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSourceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSourceConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationSourceConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplicationSourceConfig"}
	if s.ExternalUrlConfig != nil {
		if err := s.ExternalUrlConfig.Validate(); err != nil {
			invalidParams.AddNested("ExternalUrlConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExternalUrlConfig sets the ExternalUrlConfig field's value.
func (s *ApplicationSourceConfig) SetExternalUrlConfig(v *ExternalUrlConfig) *ApplicationSourceConfig {
	s.ExternalUrlConfig = v
	return s
}

// Summary information about the Application.
type ApplicationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Application.
	Arn *string `min:"1" type:"string"`

	// The time when the application was created.
	CreatedTime *time.Time `type:"timestamp"`

	// A unique identifier for the Application.
	Id *string `type:"string"`

	// The time when the application was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the application.
	Name *string `min:"1" type:"string"`

	// The namespace of the application.
	Namespace *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ApplicationSummary) SetArn(v string) *ApplicationSummary {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *ApplicationSummary) SetCreatedTime(v time.Time) *ApplicationSummary {
	s.CreatedTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *ApplicationSummary) SetId(v string) *ApplicationSummary {
	s.Id = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *ApplicationSummary) SetLastModifiedTime(v time.Time) *ApplicationSummary {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ApplicationSummary) SetName(v string) *ApplicationSummary {
	s.Name = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ApplicationSummary) SetNamespace(v string) *ApplicationSummary {
	s.Namespace = &v
	return s
}

type CreateApplicationInput struct {
	_ struct{} `type:"structure"`

	// The configuration for where the application should be loaded from.
	//
	// ApplicationSourceConfig is a required field
	ApplicationSourceConfig *ApplicationSourceConfig `type:"structure" required:"true"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see Making retries safe with
	// idempotent APIs (https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The description of the application.
	Description *string `min:"1" type:"string"`

	// The name of the application.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The namespace of the application.
	//
	// Namespace is a required field
	Namespace *string `min:"1" type:"string" required:"true"`

	// The events that the application publishes.
	Publications []*Publication `type:"list"`

	// The events that the application subscribes.
	Subscriptions []*Subscription `type:"list"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationInput"}
	if s.ApplicationSourceConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationSourceConfig"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.Namespace != nil && len(*s.Namespace) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Namespace", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ApplicationSourceConfig != nil {
		if err := s.ApplicationSourceConfig.Validate(); err != nil {
			invalidParams.AddNested("ApplicationSourceConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Publications != nil {
		for i, v := range s.Publications {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Publications", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Subscriptions != nil {
		for i, v := range s.Subscriptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Subscriptions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationSourceConfig sets the ApplicationSourceConfig field's value.
func (s *CreateApplicationInput) SetApplicationSourceConfig(v *ApplicationSourceConfig) *CreateApplicationInput {
	s.ApplicationSourceConfig = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateApplicationInput) SetClientToken(v string) *CreateApplicationInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateApplicationInput) SetDescription(v string) *CreateApplicationInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateApplicationInput) SetName(v string) *CreateApplicationInput {
	s.Name = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CreateApplicationInput) SetNamespace(v string) *CreateApplicationInput {
	s.Namespace = &v
	return s
}

// SetPublications sets the Publications field's value.
func (s *CreateApplicationInput) SetPublications(v []*Publication) *CreateApplicationInput {
	s.Publications = v
	return s
}

// SetSubscriptions sets the Subscriptions field's value.
func (s *CreateApplicationInput) SetSubscriptions(v []*Subscription) *CreateApplicationInput {
	s.Subscriptions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateApplicationInput) SetTags(v map[string]*string) *CreateApplicationInput {
	s.Tags = v
	return s
}

type CreateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Application.
	Arn *string `min:"1" type:"string"`

	// A unique identifier for the Application.
	Id *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateApplicationOutput) SetArn(v string) *CreateApplicationOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateApplicationOutput) SetId(v string) *CreateApplicationOutput {
	s.Id = &v
	return s
}

type CreateDataIntegrationInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see Making retries safe with
	// idempotent APIs (https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// A description of the DataIntegration.
	Description *string `min:"1" type:"string"`

	// The configuration for what files should be pulled from the source.
	FileConfiguration *FileConfiguration `type:"structure"`

	// The KMS key for the DataIntegration.
	//
	// KmsKey is a required field
	KmsKey *string `min:"1" type:"string" required:"true"`

	// The name of the DataIntegration.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The configuration for what data should be pulled from the source.
	ObjectConfiguration map[string]map[string][]*string `type:"map"`

	// The name of the data and how often it should be pulled from the source.
	ScheduleConfig *ScheduleConfiguration `type:"structure"`

	// The URI of the data source.
	//
	// SourceURI is a required field
	SourceURI *string `min:"1" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataIntegrationInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.KmsKey == nil {
		invalidParams.Add(request.NewErrParamRequired("KmsKey"))
	}
	if s.KmsKey != nil && len(*s.KmsKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKey", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SourceURI == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceURI"))
	}
	if s.SourceURI != nil && len(*s.SourceURI) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceURI", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.FileConfiguration != nil {
		if err := s.FileConfiguration.Validate(); err != nil {
			invalidParams.AddNested("FileConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ScheduleConfig != nil {
		if err := s.ScheduleConfig.Validate(); err != nil {
			invalidParams.AddNested("ScheduleConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDataIntegrationInput) SetClientToken(v string) *CreateDataIntegrationInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDataIntegrationInput) SetDescription(v string) *CreateDataIntegrationInput {
	s.Description = &v
	return s
}

// SetFileConfiguration sets the FileConfiguration field's value.
func (s *CreateDataIntegrationInput) SetFileConfiguration(v *FileConfiguration) *CreateDataIntegrationInput {
	s.FileConfiguration = v
	return s
}

// SetKmsKey sets the KmsKey field's value.
func (s *CreateDataIntegrationInput) SetKmsKey(v string) *CreateDataIntegrationInput {
	s.KmsKey = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDataIntegrationInput) SetName(v string) *CreateDataIntegrationInput {
	s.Name = &v
	return s
}

// SetObjectConfiguration sets the ObjectConfiguration field's value.
func (s *CreateDataIntegrationInput) SetObjectConfiguration(v map[string]map[string][]*string) *CreateDataIntegrationInput {
	s.ObjectConfiguration = v
	return s
}

// SetScheduleConfig sets the ScheduleConfig field's value.
func (s *CreateDataIntegrationInput) SetScheduleConfig(v *ScheduleConfiguration) *CreateDataIntegrationInput {
	s.ScheduleConfig = v
	return s
}

// SetSourceURI sets the SourceURI field's value.
func (s *CreateDataIntegrationInput) SetSourceURI(v string) *CreateDataIntegrationInput {
	s.SourceURI = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDataIntegrationInput) SetTags(v map[string]*string) *CreateDataIntegrationInput {
	s.Tags = v
	return s
}

type CreateDataIntegrationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN)
	Arn *string `min:"1" type:"string"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see Making retries safe with
	// idempotent APIs (https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
	ClientToken *string `min:"1" type:"string"`

	// A description of the DataIntegration.
	Description *string `min:"1" type:"string"`

	// The configuration for what files should be pulled from the source.
	FileConfiguration *FileConfiguration `type:"structure"`

	// A unique identifier.
	Id *string `type:"string"`

	// The KMS key for the DataIntegration.
	KmsKey *string `min:"1" type:"string"`

	// The name of the DataIntegration.
	Name *string `min:"1" type:"string"`

	// The configuration for what data should be pulled from the source.
	ObjectConfiguration map[string]map[string][]*string `type:"map"`

	// The name of the data and how often it should be pulled from the source.
	ScheduleConfiguration *ScheduleConfiguration `type:"structure"`

	// The URI of the data source.
	SourceURI *string `min:"1" type:"string"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataIntegrationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateDataIntegrationOutput) SetArn(v string) *CreateDataIntegrationOutput {
	s.Arn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDataIntegrationOutput) SetClientToken(v string) *CreateDataIntegrationOutput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDataIntegrationOutput) SetDescription(v string) *CreateDataIntegrationOutput {
	s.Description = &v
	return s
}

// SetFileConfiguration sets the FileConfiguration field's value.
func (s *CreateDataIntegrationOutput) SetFileConfiguration(v *FileConfiguration) *CreateDataIntegrationOutput {
	s.FileConfiguration = v
	return s
}

// SetId sets the Id field's value.
func (s *CreateDataIntegrationOutput) SetId(v string) *CreateDataIntegrationOutput {
	s.Id = &v
	return s
}

// SetKmsKey sets the KmsKey field's value.
func (s *CreateDataIntegrationOutput) SetKmsKey(v string) *CreateDataIntegrationOutput {
	s.KmsKey = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDataIntegrationOutput) SetName(v string) *CreateDataIntegrationOutput {
	s.Name = &v
	return s
}

// SetObjectConfiguration sets the ObjectConfiguration field's value.
func (s *CreateDataIntegrationOutput) SetObjectConfiguration(v map[string]map[string][]*string) *CreateDataIntegrationOutput {
	s.ObjectConfiguration = v
	return s
}

// SetScheduleConfiguration sets the ScheduleConfiguration field's value.
func (s *CreateDataIntegrationOutput) SetScheduleConfiguration(v *ScheduleConfiguration) *CreateDataIntegrationOutput {
	s.ScheduleConfiguration = v
	return s
}

// SetSourceURI sets the SourceURI field's value.
func (s *CreateDataIntegrationOutput) SetSourceURI(v string) *CreateDataIntegrationOutput {
	s.SourceURI = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDataIntegrationOutput) SetTags(v map[string]*string) *CreateDataIntegrationOutput {
	s.Tags = v
	return s
}

type CreateEventIntegrationInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see Making retries safe with
	// idempotent APIs (https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The description of the event integration.
	Description *string `min:"1" type:"string"`

	// The EventBridge bus.
	//
	// EventBridgeBus is a required field
	EventBridgeBus *string `min:"1" type:"string" required:"true"`

	// The event filter.
	//
	// EventFilter is a required field
	EventFilter *EventFilter `type:"structure" required:"true"`

	// The name of the event integration.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEventIntegrationInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.EventBridgeBus == nil {
		invalidParams.Add(request.NewErrParamRequired("EventBridgeBus"))
	}
	if s.EventBridgeBus != nil && len(*s.EventBridgeBus) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventBridgeBus", 1))
	}
	if s.EventFilter == nil {
		invalidParams.Add(request.NewErrParamRequired("EventFilter"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.EventFilter != nil {
		if err := s.EventFilter.Validate(); err != nil {
			invalidParams.AddNested("EventFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateEventIntegrationInput) SetClientToken(v string) *CreateEventIntegrationInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateEventIntegrationInput) SetDescription(v string) *CreateEventIntegrationInput {
	s.Description = &v
	return s
}

// SetEventBridgeBus sets the EventBridgeBus field's value.
func (s *CreateEventIntegrationInput) SetEventBridgeBus(v string) *CreateEventIntegrationInput {
	s.EventBridgeBus = &v
	return s
}

// SetEventFilter sets the EventFilter field's value.
func (s *CreateEventIntegrationInput) SetEventFilter(v *EventFilter) *CreateEventIntegrationInput {
	s.EventFilter = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEventIntegrationInput) SetName(v string) *CreateEventIntegrationInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEventIntegrationInput) SetTags(v map[string]*string) *CreateEventIntegrationInput {
	s.Tags = v
	return s
}

type CreateEventIntegrationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the event integration.
	EventIntegrationArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventIntegrationOutput) GoString() string {
	return s.String()
}

// SetEventIntegrationArn sets the EventIntegrationArn field's value.
func (s *CreateEventIntegrationOutput) SetEventIntegrationArn(v string) *CreateEventIntegrationOutput {
	s.EventIntegrationArn = &v
	return s
}

// Summary information about the DataIntegration association.
type DataIntegrationAssociationSummary struct {
	_ struct{} `type:"structure"`

	// The identifier for the client that is associated with the DataIntegration
	// association.
	ClientId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the DataIntegration.
	DataIntegrationArn *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the DataIntegration association.
	DataIntegrationAssociationArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataIntegrationAssociationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataIntegrationAssociationSummary) GoString() string {
	return s.String()
}

// SetClientId sets the ClientId field's value.
func (s *DataIntegrationAssociationSummary) SetClientId(v string) *DataIntegrationAssociationSummary {
	s.ClientId = &v
	return s
}

// SetDataIntegrationArn sets the DataIntegrationArn field's value.
func (s *DataIntegrationAssociationSummary) SetDataIntegrationArn(v string) *DataIntegrationAssociationSummary {
	s.DataIntegrationArn = &v
	return s
}

// SetDataIntegrationAssociationArn sets the DataIntegrationAssociationArn field's value.
func (s *DataIntegrationAssociationSummary) SetDataIntegrationAssociationArn(v string) *DataIntegrationAssociationSummary {
	s.DataIntegrationAssociationArn = &v
	return s
}

// Summary information about the DataIntegration.
type DataIntegrationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the DataIntegration.
	Arn *string `min:"1" type:"string"`

	// The name of the DataIntegration.
	Name *string `min:"1" type:"string"`

	// The URI of the data source.
	SourceURI *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataIntegrationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataIntegrationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DataIntegrationSummary) SetArn(v string) *DataIntegrationSummary {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataIntegrationSummary) SetName(v string) *DataIntegrationSummary {
	s.Name = &v
	return s
}

// SetSourceURI sets the SourceURI field's value.
func (s *DataIntegrationSummary) SetSourceURI(v string) *DataIntegrationSummary {
	s.SourceURI = &v
	return s
}

type DeleteDataIntegrationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for the DataIntegration.
	//
	// DataIntegrationIdentifier is a required field
	DataIntegrationIdentifier *string `location:"uri" locationName:"Identifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDataIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDataIntegrationInput"}
	if s.DataIntegrationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DataIntegrationIdentifier"))
	}
	if s.DataIntegrationIdentifier != nil && len(*s.DataIntegrationIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataIntegrationIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataIntegrationIdentifier sets the DataIntegrationIdentifier field's value.
func (s *DeleteDataIntegrationInput) SetDataIntegrationIdentifier(v string) *DeleteDataIntegrationInput {
	s.DataIntegrationIdentifier = &v
	return s
}

type DeleteDataIntegrationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataIntegrationOutput) GoString() string {
	return s.String()
}

type DeleteEventIntegrationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the event integration.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventIntegrationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteEventIntegrationInput) SetName(v string) *DeleteEventIntegrationInput {
	s.Name = &v
	return s
}

type DeleteEventIntegrationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventIntegrationOutput) GoString() string {
	return s.String()
}

// A resource with the specified name already exists.
type DuplicateResourceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DuplicateResourceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DuplicateResourceException) GoString() string {
	return s.String()
}

func newErrorDuplicateResourceException(v protocol.ResponseMetadata) error {
	return &DuplicateResourceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DuplicateResourceException) Code() string {
	return "DuplicateResourceException"
}

// Message returns the exception's message.
func (s *DuplicateResourceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DuplicateResourceException) OrigErr() error {
	return nil
}

func (s *DuplicateResourceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DuplicateResourceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DuplicateResourceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The event filter.
type EventFilter struct {
	_ struct{} `type:"structure"`

	// The source of the events.
	//
	// Source is a required field
	Source *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventFilter"}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Source != nil && len(*s.Source) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Source", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSource sets the Source field's value.
func (s *EventFilter) SetSource(v string) *EventFilter {
	s.Source = &v
	return s
}

// The event integration.
type EventIntegration struct {
	_ struct{} `type:"structure"`

	// The event integration description.
	Description *string `min:"1" type:"string"`

	// The Amazon EventBridge bus for the event integration.
	EventBridgeBus *string `min:"1" type:"string"`

	// The event integration filter.
	EventFilter *EventFilter `type:"structure"`

	// The Amazon Resource Name (ARN) of the event integration.
	EventIntegrationArn *string `min:"1" type:"string"`

	// The name of the event integration.
	Name *string `min:"1" type:"string"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventIntegration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventIntegration) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *EventIntegration) SetDescription(v string) *EventIntegration {
	s.Description = &v
	return s
}

// SetEventBridgeBus sets the EventBridgeBus field's value.
func (s *EventIntegration) SetEventBridgeBus(v string) *EventIntegration {
	s.EventBridgeBus = &v
	return s
}

// SetEventFilter sets the EventFilter field's value.
func (s *EventIntegration) SetEventFilter(v *EventFilter) *EventIntegration {
	s.EventFilter = v
	return s
}

// SetEventIntegrationArn sets the EventIntegrationArn field's value.
func (s *EventIntegration) SetEventIntegrationArn(v string) *EventIntegration {
	s.EventIntegrationArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *EventIntegration) SetName(v string) *EventIntegration {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *EventIntegration) SetTags(v map[string]*string) *EventIntegration {
	s.Tags = v
	return s
}

// The event integration association.
type EventIntegrationAssociation struct {
	_ struct{} `type:"structure"`

	// The metadata associated with the client.
	ClientAssociationMetadata map[string]*string `type:"map"`

	// The identifier for the client that is associated with the event integration.
	ClientId *string `min:"1" type:"string"`

	// The name of the EventBridge rule.
	EventBridgeRuleName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) for the event integration association.
	EventIntegrationAssociationArn *string `min:"1" type:"string"`

	// The identifier for the event integration association.
	EventIntegrationAssociationId *string `type:"string"`

	// The name of the event integration.
	EventIntegrationName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventIntegrationAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventIntegrationAssociation) GoString() string {
	return s.String()
}

// SetClientAssociationMetadata sets the ClientAssociationMetadata field's value.
func (s *EventIntegrationAssociation) SetClientAssociationMetadata(v map[string]*string) *EventIntegrationAssociation {
	s.ClientAssociationMetadata = v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *EventIntegrationAssociation) SetClientId(v string) *EventIntegrationAssociation {
	s.ClientId = &v
	return s
}

// SetEventBridgeRuleName sets the EventBridgeRuleName field's value.
func (s *EventIntegrationAssociation) SetEventBridgeRuleName(v string) *EventIntegrationAssociation {
	s.EventBridgeRuleName = &v
	return s
}

// SetEventIntegrationAssociationArn sets the EventIntegrationAssociationArn field's value.
func (s *EventIntegrationAssociation) SetEventIntegrationAssociationArn(v string) *EventIntegrationAssociation {
	s.EventIntegrationAssociationArn = &v
	return s
}

// SetEventIntegrationAssociationId sets the EventIntegrationAssociationId field's value.
func (s *EventIntegrationAssociation) SetEventIntegrationAssociationId(v string) *EventIntegrationAssociation {
	s.EventIntegrationAssociationId = &v
	return s
}

// SetEventIntegrationName sets the EventIntegrationName field's value.
func (s *EventIntegrationAssociation) SetEventIntegrationName(v string) *EventIntegrationAssociation {
	s.EventIntegrationName = &v
	return s
}

// The external URL source for the application.
type ExternalUrlConfig struct {
	_ struct{} `type:"structure"`

	// The URL to access the application.
	//
	// AccessUrl is a required field
	AccessUrl *string `min:"1" type:"string" required:"true"`

	// Additional URLs to allow list if different than the access URL.
	ApprovedOrigins []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalUrlConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExternalUrlConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExternalUrlConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExternalUrlConfig"}
	if s.AccessUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessUrl"))
	}
	if s.AccessUrl != nil && len(*s.AccessUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccessUrl", 1))
	}
	if s.ApprovedOrigins != nil && len(s.ApprovedOrigins) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApprovedOrigins", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessUrl sets the AccessUrl field's value.
func (s *ExternalUrlConfig) SetAccessUrl(v string) *ExternalUrlConfig {
	s.AccessUrl = &v
	return s
}

// SetApprovedOrigins sets the ApprovedOrigins field's value.
func (s *ExternalUrlConfig) SetApprovedOrigins(v []*string) *ExternalUrlConfig {
	s.ApprovedOrigins = v
	return s
}

// The configuration for what files should be pulled from the source.
type FileConfiguration struct {
	_ struct{} `type:"structure"`

	// Restrictions for what files should be pulled from the source.
	Filters map[string][]*string `type:"map"`

	// Identifiers for the source folders to pull all files from recursively.
	//
	// Folders is a required field
	Folders []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FileConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FileConfiguration"}
	if s.Folders == nil {
		invalidParams.Add(request.NewErrParamRequired("Folders"))
	}
	if s.Folders != nil && len(s.Folders) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Folders", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *FileConfiguration) SetFilters(v map[string][]*string) *FileConfiguration {
	s.Filters = v
	return s
}

// SetFolders sets the Folders field's value.
func (s *FileConfiguration) SetFolders(v []*string) *FileConfiguration {
	s.Folders = v
	return s
}

type GetApplicationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the Application.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"Arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetApplicationInput) SetArn(v string) *GetApplicationInput {
	s.Arn = &v
	return s
}

type GetApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The configuration for where the application should be loaded from.
	ApplicationSourceConfig *ApplicationSourceConfig `type:"structure"`

	// The Amazon Resource Name (ARN) of the Application.
	Arn *string `min:"1" type:"string"`

	// The created time of the Application.
	CreatedTime *time.Time `type:"timestamp"`

	// The description of the application.
	Description *string `min:"1" type:"string"`

	// A unique identifier for the Application.
	Id *string `type:"string"`

	// The last modified time of the Application.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the application.
	Name *string `min:"1" type:"string"`

	// The namespace of the application.
	Namespace *string `min:"1" type:"string"`

	// The events that the application publishes.
	Publications []*Publication `type:"list"`

	// The events that the application subscribes.
	Subscriptions []*Subscription `type:"list"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationSourceConfig sets the ApplicationSourceConfig field's value.
func (s *GetApplicationOutput) SetApplicationSourceConfig(v *ApplicationSourceConfig) *GetApplicationOutput {
	s.ApplicationSourceConfig = v
	return s
}

// SetArn sets the Arn field's value.
func (s *GetApplicationOutput) SetArn(v string) *GetApplicationOutput {
	s.Arn = &v
	return s
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *GetApplicationOutput) SetCreatedTime(v time.Time) *GetApplicationOutput {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetApplicationOutput) SetDescription(v string) *GetApplicationOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetApplicationOutput) SetId(v string) *GetApplicationOutput {
	s.Id = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *GetApplicationOutput) SetLastModifiedTime(v time.Time) *GetApplicationOutput {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetApplicationOutput) SetName(v string) *GetApplicationOutput {
	s.Name = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *GetApplicationOutput) SetNamespace(v string) *GetApplicationOutput {
	s.Namespace = &v
	return s
}

// SetPublications sets the Publications field's value.
func (s *GetApplicationOutput) SetPublications(v []*Publication) *GetApplicationOutput {
	s.Publications = v
	return s
}

// SetSubscriptions sets the Subscriptions field's value.
func (s *GetApplicationOutput) SetSubscriptions(v []*Subscription) *GetApplicationOutput {
	s.Subscriptions = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetApplicationOutput) SetTags(v map[string]*string) *GetApplicationOutput {
	s.Tags = v
	return s
}

type GetDataIntegrationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"Identifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDataIntegrationInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *GetDataIntegrationInput) SetIdentifier(v string) *GetDataIntegrationInput {
	s.Identifier = &v
	return s
}

type GetDataIntegrationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the DataIntegration.
	Arn *string `min:"1" type:"string"`

	// The KMS key for the DataIntegration.
	Description *string `min:"1" type:"string"`

	// The configuration for what files should be pulled from the source.
	FileConfiguration *FileConfiguration `type:"structure"`

	// A unique identifier.
	Id *string `type:"string"`

	// The KMS key for the DataIntegration.
	KmsKey *string `min:"1" type:"string"`

	// The name of the DataIntegration.
	Name *string `min:"1" type:"string"`

	// The configuration for what data should be pulled from the source.
	ObjectConfiguration map[string]map[string][]*string `type:"map"`

	// The name of the data and how often it should be pulled from the source.
	ScheduleConfiguration *ScheduleConfiguration `type:"structure"`

	// The URI of the data source.
	SourceURI *string `min:"1" type:"string"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataIntegrationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetDataIntegrationOutput) SetArn(v string) *GetDataIntegrationOutput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetDataIntegrationOutput) SetDescription(v string) *GetDataIntegrationOutput {
	s.Description = &v
	return s
}

// SetFileConfiguration sets the FileConfiguration field's value.
func (s *GetDataIntegrationOutput) SetFileConfiguration(v *FileConfiguration) *GetDataIntegrationOutput {
	s.FileConfiguration = v
	return s
}

// SetId sets the Id field's value.
func (s *GetDataIntegrationOutput) SetId(v string) *GetDataIntegrationOutput {
	s.Id = &v
	return s
}

// SetKmsKey sets the KmsKey field's value.
func (s *GetDataIntegrationOutput) SetKmsKey(v string) *GetDataIntegrationOutput {
	s.KmsKey = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetDataIntegrationOutput) SetName(v string) *GetDataIntegrationOutput {
	s.Name = &v
	return s
}

// SetObjectConfiguration sets the ObjectConfiguration field's value.
func (s *GetDataIntegrationOutput) SetObjectConfiguration(v map[string]map[string][]*string) *GetDataIntegrationOutput {
	s.ObjectConfiguration = v
	return s
}

// SetScheduleConfiguration sets the ScheduleConfiguration field's value.
func (s *GetDataIntegrationOutput) SetScheduleConfiguration(v *ScheduleConfiguration) *GetDataIntegrationOutput {
	s.ScheduleConfiguration = v
	return s
}

// SetSourceURI sets the SourceURI field's value.
func (s *GetDataIntegrationOutput) SetSourceURI(v string) *GetDataIntegrationOutput {
	s.SourceURI = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetDataIntegrationOutput) SetTags(v map[string]*string) *GetDataIntegrationOutput {
	s.Tags = v
	return s
}

type GetEventIntegrationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the event integration.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEventIntegrationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetEventIntegrationInput) SetName(v string) *GetEventIntegrationInput {
	s.Name = &v
	return s
}

type GetEventIntegrationOutput struct {
	_ struct{} `type:"structure"`

	// The description of the event integration.
	Description *string `min:"1" type:"string"`

	// The EventBridge bus.
	EventBridgeBus *string `min:"1" type:"string"`

	// The event filter.
	EventFilter *EventFilter `type:"structure"`

	// The Amazon Resource Name (ARN) for the event integration.
	EventIntegrationArn *string `min:"1" type:"string"`

	// The name of the event integration.
	Name *string `min:"1" type:"string"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventIntegrationOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *GetEventIntegrationOutput) SetDescription(v string) *GetEventIntegrationOutput {
	s.Description = &v
	return s
}

// SetEventBridgeBus sets the EventBridgeBus field's value.
func (s *GetEventIntegrationOutput) SetEventBridgeBus(v string) *GetEventIntegrationOutput {
	s.EventBridgeBus = &v
	return s
}

// SetEventFilter sets the EventFilter field's value.
func (s *GetEventIntegrationOutput) SetEventFilter(v *EventFilter) *GetEventIntegrationOutput {
	s.EventFilter = v
	return s
}

// SetEventIntegrationArn sets the EventIntegrationArn field's value.
func (s *GetEventIntegrationOutput) SetEventIntegrationArn(v string) *GetEventIntegrationOutput {
	s.EventIntegrationArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetEventIntegrationOutput) SetName(v string) *GetEventIntegrationOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetEventIntegrationOutput) SetTags(v map[string]*string) *GetEventIntegrationOutput {
	s.Tags = v
	return s
}

// Request processing failed due to an error or failure with the service.
type InternalServiceError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceError) GoString() string {
	return s.String()
}

func newErrorInternalServiceError(v protocol.ResponseMetadata) error {
	return &InternalServiceError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceError) Code() string {
	return "InternalServiceError"
}

// Message returns the exception's message.
func (s *InternalServiceError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceError) OrigErr() error {
	return nil
}

func (s *InternalServiceError) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceError) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request is not valid.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListApplicationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListApplicationsInput) SetMaxResults(v int64) *ListApplicationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsInput) SetNextToken(v string) *ListApplicationsInput {
	s.NextToken = &v
	return s
}

type ListApplicationsOutput struct {
	_ struct{} `type:"structure"`

	// The Applications associated with this account.
	Applications []*ApplicationSummary `min:"1" type:"list"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsOutput) GoString() string {
	return s.String()
}

// SetApplications sets the Applications field's value.
func (s *ListApplicationsOutput) SetApplications(v []*ApplicationSummary) *ListApplicationsOutput {
	s.Applications = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsOutput) SetNextToken(v string) *ListApplicationsOutput {
	s.NextToken = &v
	return s
}

type ListDataIntegrationAssociationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for the DataIntegration.
	//
	// DataIntegrationIdentifier is a required field
	DataIntegrationIdentifier *string `location:"uri" locationName:"Identifier" min:"1" type:"string" required:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataIntegrationAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataIntegrationAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataIntegrationAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataIntegrationAssociationsInput"}
	if s.DataIntegrationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DataIntegrationIdentifier"))
	}
	if s.DataIntegrationIdentifier != nil && len(*s.DataIntegrationIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataIntegrationIdentifier", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataIntegrationIdentifier sets the DataIntegrationIdentifier field's value.
func (s *ListDataIntegrationAssociationsInput) SetDataIntegrationIdentifier(v string) *ListDataIntegrationAssociationsInput {
	s.DataIntegrationIdentifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDataIntegrationAssociationsInput) SetMaxResults(v int64) *ListDataIntegrationAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataIntegrationAssociationsInput) SetNextToken(v string) *ListDataIntegrationAssociationsInput {
	s.NextToken = &v
	return s
}

type ListDataIntegrationAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) and unique ID of the DataIntegration association.
	DataIntegrationAssociations []*DataIntegrationAssociationSummary `min:"1" type:"list"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataIntegrationAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataIntegrationAssociationsOutput) GoString() string {
	return s.String()
}

// SetDataIntegrationAssociations sets the DataIntegrationAssociations field's value.
func (s *ListDataIntegrationAssociationsOutput) SetDataIntegrationAssociations(v []*DataIntegrationAssociationSummary) *ListDataIntegrationAssociationsOutput {
	s.DataIntegrationAssociations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataIntegrationAssociationsOutput) SetNextToken(v string) *ListDataIntegrationAssociationsOutput {
	s.NextToken = &v
	return s
}

type ListDataIntegrationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataIntegrationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataIntegrationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataIntegrationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataIntegrationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDataIntegrationsInput) SetMaxResults(v int64) *ListDataIntegrationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataIntegrationsInput) SetNextToken(v string) *ListDataIntegrationsInput {
	s.NextToken = &v
	return s
}

type ListDataIntegrationsOutput struct {
	_ struct{} `type:"structure"`

	// The DataIntegrations associated with this account.
	DataIntegrations []*DataIntegrationSummary `min:"1" type:"list"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataIntegrationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataIntegrationsOutput) GoString() string {
	return s.String()
}

// SetDataIntegrations sets the DataIntegrations field's value.
func (s *ListDataIntegrationsOutput) SetDataIntegrations(v []*DataIntegrationSummary) *ListDataIntegrationsOutput {
	s.DataIntegrations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataIntegrationsOutput) SetNextToken(v string) *ListDataIntegrationsOutput {
	s.NextToken = &v
	return s
}

type ListEventIntegrationAssociationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the event integration.
	//
	// EventIntegrationName is a required field
	EventIntegrationName *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventIntegrationAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventIntegrationAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventIntegrationAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEventIntegrationAssociationsInput"}
	if s.EventIntegrationName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventIntegrationName"))
	}
	if s.EventIntegrationName != nil && len(*s.EventIntegrationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventIntegrationName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventIntegrationName sets the EventIntegrationName field's value.
func (s *ListEventIntegrationAssociationsInput) SetEventIntegrationName(v string) *ListEventIntegrationAssociationsInput {
	s.EventIntegrationName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEventIntegrationAssociationsInput) SetMaxResults(v int64) *ListEventIntegrationAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventIntegrationAssociationsInput) SetNextToken(v string) *ListEventIntegrationAssociationsInput {
	s.NextToken = &v
	return s
}

type ListEventIntegrationAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The event integration associations.
	EventIntegrationAssociations []*EventIntegrationAssociation `min:"1" type:"list"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventIntegrationAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventIntegrationAssociationsOutput) GoString() string {
	return s.String()
}

// SetEventIntegrationAssociations sets the EventIntegrationAssociations field's value.
func (s *ListEventIntegrationAssociationsOutput) SetEventIntegrationAssociations(v []*EventIntegrationAssociation) *ListEventIntegrationAssociationsOutput {
	s.EventIntegrationAssociations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventIntegrationAssociationsOutput) SetNextToken(v string) *ListEventIntegrationAssociationsOutput {
	s.NextToken = &v
	return s
}

type ListEventIntegrationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventIntegrationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventIntegrationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventIntegrationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEventIntegrationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEventIntegrationsInput) SetMaxResults(v int64) *ListEventIntegrationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventIntegrationsInput) SetNextToken(v string) *ListEventIntegrationsInput {
	s.NextToken = &v
	return s
}

type ListEventIntegrationsOutput struct {
	_ struct{} `type:"structure"`

	// The event integrations.
	EventIntegrations []*EventIntegration `min:"1" type:"list"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventIntegrationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventIntegrationsOutput) GoString() string {
	return s.String()
}

// SetEventIntegrations sets the EventIntegrations field's value.
func (s *ListEventIntegrationsOutput) SetEventIntegrations(v []*EventIntegration) *ListEventIntegrationsOutput {
	s.EventIntegrations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventIntegrationsOutput) SetNextToken(v string) *ListEventIntegrationsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Information about the tags.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The configuration of an event that the application publishes.
type Publication struct {
	_ struct{} `type:"structure"`

	// The description of the publication.
	Description *string `min:"1" type:"string"`

	// The name of the publication.
	//
	// Event is a required field
	Event *string `min:"1" type:"string" required:"true"`

	// The JSON schema of the publication event.
	//
	// Schema is a required field
	Schema *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Publication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Publication) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Publication) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Publication"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Event == nil {
		invalidParams.Add(request.NewErrParamRequired("Event"))
	}
	if s.Event != nil && len(*s.Event) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Event", 1))
	}
	if s.Schema == nil {
		invalidParams.Add(request.NewErrParamRequired("Schema"))
	}
	if s.Schema != nil && len(*s.Schema) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Schema", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *Publication) SetDescription(v string) *Publication {
	s.Description = &v
	return s
}

// SetEvent sets the Event field's value.
func (s *Publication) SetEvent(v string) *Publication {
	s.Event = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *Publication) SetSchema(v string) *Publication {
	s.Schema = &v
	return s
}

// The specified resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The allowed quota for the resource has been exceeded.
type ResourceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorResourceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ResourceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceQuotaExceededException) Code() string {
	return "ResourceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ResourceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ResourceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The name of the data and how often it should be pulled from the source.
type ScheduleConfiguration struct {
	_ struct{} `type:"structure"`

	// The start date for objects to import in the first flow run as an Unix/epoch
	// timestamp in milliseconds or in ISO-8601 format.
	FirstExecutionFrom *string `min:"1" type:"string"`

	// The name of the object to pull from the data source.
	Object *string `min:"1" type:"string"`

	// How often the data should be pulled from data source.
	//
	// ScheduleExpression is a required field
	ScheduleExpression *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduleConfiguration"}
	if s.FirstExecutionFrom != nil && len(*s.FirstExecutionFrom) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirstExecutionFrom", 1))
	}
	if s.Object != nil && len(*s.Object) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Object", 1))
	}
	if s.ScheduleExpression == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduleExpression"))
	}
	if s.ScheduleExpression != nil && len(*s.ScheduleExpression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduleExpression", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirstExecutionFrom sets the FirstExecutionFrom field's value.
func (s *ScheduleConfiguration) SetFirstExecutionFrom(v string) *ScheduleConfiguration {
	s.FirstExecutionFrom = &v
	return s
}

// SetObject sets the Object field's value.
func (s *ScheduleConfiguration) SetObject(v string) *ScheduleConfiguration {
	s.Object = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *ScheduleConfiguration) SetScheduleExpression(v string) *ScheduleConfiguration {
	s.ScheduleExpression = &v
	return s
}

// The configuration of an event that the application subscribes.
type Subscription struct {
	_ struct{} `type:"structure"`

	// The description of the subscription.
	Description *string `min:"1" type:"string"`

	// The name of the subscription.
	//
	// Event is a required field
	Event *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Subscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Subscription) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Subscription) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Subscription"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Event == nil {
		invalidParams.Add(request.NewErrParamRequired("Event"))
	}
	if s.Event != nil && len(*s.Event) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Event", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *Subscription) SetDescription(v string) *Subscription {
	s.Description = &v
	return s
}

// SetEvent sets the Event field's value.
func (s *Subscription) SetEvent(v string) *Subscription {
	s.Event = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The throttling limit has been exceeded.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The tag keys.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateApplicationInput struct {
	_ struct{} `type:"structure"`

	// The configuration for where the application should be loaded from.
	ApplicationSourceConfig *ApplicationSourceConfig `type:"structure"`

	// The Amazon Resource Name (ARN) of the Application.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"Arn" min:"1" type:"string" required:"true"`

	// The description of the application.
	Description *string `min:"1" type:"string"`

	// The name of the application.
	Name *string `min:"1" type:"string"`

	// The events that the application publishes.
	Publications []*Publication `type:"list"`

	// The events that the application subscribes.
	Subscriptions []*Subscription `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ApplicationSourceConfig != nil {
		if err := s.ApplicationSourceConfig.Validate(); err != nil {
			invalidParams.AddNested("ApplicationSourceConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Publications != nil {
		for i, v := range s.Publications {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Publications", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Subscriptions != nil {
		for i, v := range s.Subscriptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Subscriptions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationSourceConfig sets the ApplicationSourceConfig field's value.
func (s *UpdateApplicationInput) SetApplicationSourceConfig(v *ApplicationSourceConfig) *UpdateApplicationInput {
	s.ApplicationSourceConfig = v
	return s
}

// SetArn sets the Arn field's value.
func (s *UpdateApplicationInput) SetArn(v string) *UpdateApplicationInput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateApplicationInput) SetDescription(v string) *UpdateApplicationInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateApplicationInput) SetName(v string) *UpdateApplicationInput {
	s.Name = &v
	return s
}

// SetPublications sets the Publications field's value.
func (s *UpdateApplicationInput) SetPublications(v []*Publication) *UpdateApplicationInput {
	s.Publications = v
	return s
}

// SetSubscriptions sets the Subscriptions field's value.
func (s *UpdateApplicationInput) SetSubscriptions(v []*Subscription) *UpdateApplicationInput {
	s.Subscriptions = v
	return s
}

type UpdateApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationOutput) GoString() string {
	return s.String()
}

type UpdateDataIntegrationInput struct {
	_ struct{} `type:"structure"`

	// A description of the DataIntegration.
	Description *string `min:"1" type:"string"`

	// A unique identifier for the DataIntegration.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"Identifier" min:"1" type:"string" required:"true"`

	// The name of the DataIntegration.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDataIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDataIntegrationInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateDataIntegrationInput) SetDescription(v string) *UpdateDataIntegrationInput {
	s.Description = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *UpdateDataIntegrationInput) SetIdentifier(v string) *UpdateDataIntegrationInput {
	s.Identifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDataIntegrationInput) SetName(v string) *UpdateDataIntegrationInput {
	s.Name = &v
	return s
}

type UpdateDataIntegrationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataIntegrationOutput) GoString() string {
	return s.String()
}

type UpdateEventIntegrationInput struct {
	_ struct{} `type:"structure"`

	// The description of the event integration.
	Description *string `min:"1" type:"string"`

	// The name of the event integration.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEventIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEventIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEventIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEventIntegrationInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateEventIntegrationInput) SetDescription(v string) *UpdateEventIntegrationInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateEventIntegrationInput) SetName(v string) *UpdateEventIntegrationInput {
	s.Name = &v
	return s
}

type UpdateEventIntegrationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEventIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEventIntegrationOutput) GoString() string {
	return s.String()
}
