// Package visualsearch implements the Azure ARM Visualsearch service API version 1.0.
//
// Visual Search API lets you discover insights about an image such as visually similar images, shopping sources, and
// related searches. The API can also perform text recognition, identify entities (people, places, things), return
// other topical content for the user to explore, and more. For more information, see [Visual Search
// Overview](https://docs.microsoft.com/azure/cognitive-services/bing-visual-search/overview).  **NOTE:** To comply
// with the new EU Copyright Directive in France, the Bing Visual Search API must omit some content from certain EU
// News sources for French users. The removed content may include thumbnail images and videos, video previews, and
// snippets which accompany search results from these sources. As a consequence, the Bing APIs may serve fewer results
// with thumbnail images and videos, video previews, and snippets to French users.
package visualsearch

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
)

const (
	// DefaultEndpoint is the default value for endpoint
	DefaultEndpoint = "https://api.cognitive.microsoft.com"
)

// BaseClient is the base client for Visualsearch.
type BaseClient struct {
	autorest.Client
	Endpoint string
}

// New creates an instance of the BaseClient client.
func New() BaseClient {
	return NewWithoutDefaults(DefaultEndpoint)
}

// NewWithoutDefaults creates an instance of the BaseClient client.
func NewWithoutDefaults(endpoint string) BaseClient {
	return BaseClient{
		Client:   autorest.NewClientWithUserAgent(UserAgent()),
		Endpoint: endpoint,
	}
}
