package desktopvirtualization

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/desktopvirtualization/mgmt/2019-12-10-preview/desktopvirtualization"

// ApplicationGroupType enumerates the values for application group type.
type ApplicationGroupType string

const (
	// ApplicationGroupTypeDesktop ...
	ApplicationGroupTypeDesktop ApplicationGroupType = "Desktop"
	// ApplicationGroupTypeRemoteApp ...
	ApplicationGroupTypeRemoteApp ApplicationGroupType = "RemoteApp"
)

// PossibleApplicationGroupTypeValues returns an array of possible values for the ApplicationGroupType const type.
func PossibleApplicationGroupTypeValues() []ApplicationGroupType {
	return []ApplicationGroupType{ApplicationGroupTypeDesktop, ApplicationGroupTypeRemoteApp}
}

// ApplicationType enumerates the values for application type.
type ApplicationType string

const (
	// ApplicationTypeDesktop ...
	ApplicationTypeDesktop ApplicationType = "Desktop"
	// ApplicationTypeRemoteApp ...
	ApplicationTypeRemoteApp ApplicationType = "RemoteApp"
)

// PossibleApplicationTypeValues returns an array of possible values for the ApplicationType const type.
func PossibleApplicationTypeValues() []ApplicationType {
	return []ApplicationType{ApplicationTypeDesktop, ApplicationTypeRemoteApp}
}

// CommandLineSetting enumerates the values for command line setting.
type CommandLineSetting string

const (
	// Allow ...
	Allow CommandLineSetting = "Allow"
	// DoNotAllow ...
	DoNotAllow CommandLineSetting = "DoNotAllow"
	// Require ...
	Require CommandLineSetting = "Require"
)

// PossibleCommandLineSettingValues returns an array of possible values for the CommandLineSetting const type.
func PossibleCommandLineSettingValues() []CommandLineSetting {
	return []CommandLineSetting{Allow, DoNotAllow, Require}
}

// HostPoolType enumerates the values for host pool type.
type HostPoolType string

const (
	// Personal ...
	Personal HostPoolType = "Personal"
	// Pooled ...
	Pooled HostPoolType = "Pooled"
)

// PossibleHostPoolTypeValues returns an array of possible values for the HostPoolType const type.
func PossibleHostPoolTypeValues() []HostPoolType {
	return []HostPoolType{Personal, Pooled}
}

// LoadBalancerType enumerates the values for load balancer type.
type LoadBalancerType string

const (
	// BreadthFirst ...
	BreadthFirst LoadBalancerType = "BreadthFirst"
	// DepthFirst ...
	DepthFirst LoadBalancerType = "DepthFirst"
	// Persistent ...
	Persistent LoadBalancerType = "Persistent"
)

// PossibleLoadBalancerTypeValues returns an array of possible values for the LoadBalancerType const type.
func PossibleLoadBalancerTypeValues() []LoadBalancerType {
	return []LoadBalancerType{BreadthFirst, DepthFirst, Persistent}
}

// PersonalDesktopAssignmentType enumerates the values for personal desktop assignment type.
type PersonalDesktopAssignmentType string

const (
	// Automatic ...
	Automatic PersonalDesktopAssignmentType = "Automatic"
	// Direct ...
	Direct PersonalDesktopAssignmentType = "Direct"
)

// PossiblePersonalDesktopAssignmentTypeValues returns an array of possible values for the PersonalDesktopAssignmentType const type.
func PossiblePersonalDesktopAssignmentTypeValues() []PersonalDesktopAssignmentType {
	return []PersonalDesktopAssignmentType{Automatic, Direct}
}

// RegistrationTokenOperation enumerates the values for registration token operation.
type RegistrationTokenOperation string

const (
	// Delete ...
	Delete RegistrationTokenOperation = "Delete"
	// None ...
	None RegistrationTokenOperation = "None"
	// Update ...
	Update RegistrationTokenOperation = "Update"
)

// PossibleRegistrationTokenOperationValues returns an array of possible values for the RegistrationTokenOperation const type.
func PossibleRegistrationTokenOperationValues() []RegistrationTokenOperation {
	return []RegistrationTokenOperation{Delete, None, Update}
}

// SessionState enumerates the values for session state.
type SessionState string

const (
	// Active ...
	Active SessionState = "Active"
	// Disconnected ...
	Disconnected SessionState = "Disconnected"
	// LogOff ...
	LogOff SessionState = "LogOff"
	// Pending ...
	Pending SessionState = "Pending"
	// Unknown ...
	Unknown SessionState = "Unknown"
	// UserProfileDiskMounted ...
	UserProfileDiskMounted SessionState = "UserProfileDiskMounted"
)

// PossibleSessionStateValues returns an array of possible values for the SessionState const type.
func PossibleSessionStateValues() []SessionState {
	return []SessionState{Active, Disconnected, LogOff, Pending, Unknown, UserProfileDiskMounted}
}

// Status enumerates the values for status.
type Status string

const (
	// StatusAvailable ...
	StatusAvailable Status = "Available"
	// StatusDisconnected ...
	StatusDisconnected Status = "Disconnected"
	// StatusShutdown ...
	StatusShutdown Status = "Shutdown"
	// StatusUnavailable ...
	StatusUnavailable Status = "Unavailable"
	// StatusUpgradeFailed ...
	StatusUpgradeFailed Status = "UpgradeFailed"
	// StatusUpgrading ...
	StatusUpgrading Status = "Upgrading"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{StatusAvailable, StatusDisconnected, StatusShutdown, StatusUnavailable, StatusUpgradeFailed, StatusUpgrading}
}

// UpdateState enumerates the values for update state.
type UpdateState string

const (
	// UpdateStateFailed ...
	UpdateStateFailed UpdateState = "Failed"
	// UpdateStateInitial ...
	UpdateStateInitial UpdateState = "Initial"
	// UpdateStatePending ...
	UpdateStatePending UpdateState = "Pending"
	// UpdateStateStarted ...
	UpdateStateStarted UpdateState = "Started"
	// UpdateStateSucceeded ...
	UpdateStateSucceeded UpdateState = "Succeeded"
)

// PossibleUpdateStateValues returns an array of possible values for the UpdateState const type.
func PossibleUpdateStateValues() []UpdateState {
	return []UpdateState{UpdateStateFailed, UpdateStateInitial, UpdateStatePending, UpdateStateStarted, UpdateStateSucceeded}
}

// Application schema for Application properties.
type Application struct {
	autorest.Response `json:"-"`
	// ApplicationProperties - Detailed properties for Application
	*ApplicationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Application.
func (a Application) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.ApplicationProperties != nil {
		objectMap["properties"] = a.ApplicationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Application struct.
func (a *Application) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationProperties ApplicationProperties
				err = json.Unmarshal(*v, &applicationProperties)
				if err != nil {
					return err
				}
				a.ApplicationProperties = &applicationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// ApplicationGroup represents a ApplicationGroup definition.
type ApplicationGroup struct {
	autorest.Response `json:"-"`
	// ApplicationGroupProperties - Detailed properties for ApplicationGroup
	*ApplicationGroupProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGroup.
func (ag ApplicationGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ag.ApplicationGroupProperties != nil {
		objectMap["properties"] = ag.ApplicationGroupProperties
	}
	if ag.Tags != nil {
		objectMap["tags"] = ag.Tags
	}
	if ag.Location != nil {
		objectMap["location"] = ag.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGroup struct.
func (ag *ApplicationGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationGroupProperties ApplicationGroupProperties
				err = json.Unmarshal(*v, &applicationGroupProperties)
				if err != nil {
					return err
				}
				ag.ApplicationGroupProperties = &applicationGroupProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ag.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ag.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ag.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ag.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ag.Type = &typeVar
			}
		}
	}

	return nil
}

// ApplicationGroupList list of ApplicationGroup definitions.
type ApplicationGroupList struct {
	autorest.Response `json:"-"`
	// Value - List of ApplicationGroup definitions.
	Value *[]ApplicationGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplicationGroupListIterator provides access to a complete listing of ApplicationGroup values.
type ApplicationGroupListIterator struct {
	i    int
	page ApplicationGroupListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationGroupListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationGroupListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationGroupListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationGroupListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationGroupListIterator) Response() ApplicationGroupList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationGroupListIterator) Value() ApplicationGroup {
	if !iter.page.NotDone() {
		return ApplicationGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationGroupListIterator type.
func NewApplicationGroupListIterator(page ApplicationGroupListPage) ApplicationGroupListIterator {
	return ApplicationGroupListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (agl ApplicationGroupList) IsEmpty() bool {
	return agl.Value == nil || len(*agl.Value) == 0
}

// applicationGroupListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (agl ApplicationGroupList) applicationGroupListPreparer(ctx context.Context) (*http.Request, error) {
	if agl.NextLink == nil || len(to.String(agl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(agl.NextLink)))
}

// ApplicationGroupListPage contains a page of ApplicationGroup values.
type ApplicationGroupListPage struct {
	fn  func(context.Context, ApplicationGroupList) (ApplicationGroupList, error)
	agl ApplicationGroupList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationGroupListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationGroupListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.agl)
	if err != nil {
		return err
	}
	page.agl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationGroupListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationGroupListPage) NotDone() bool {
	return !page.agl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationGroupListPage) Response() ApplicationGroupList {
	return page.agl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationGroupListPage) Values() []ApplicationGroup {
	if page.agl.IsEmpty() {
		return nil
	}
	return *page.agl.Value
}

// Creates a new instance of the ApplicationGroupListPage type.
func NewApplicationGroupListPage(getNextPage func(context.Context, ApplicationGroupList) (ApplicationGroupList, error)) ApplicationGroupListPage {
	return ApplicationGroupListPage{fn: getNextPage}
}

// ApplicationGroupPatch applicationGroup properties that can be patched.
type ApplicationGroupPatch struct {
	// Tags - tags to be updated
	Tags interface{} `json:"tags,omitempty"`
	// ApplicationGroupPatchProperties - ApplicationGroup properties that can be patched.
	*ApplicationGroupPatchProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGroupPatch.
func (agp ApplicationGroupPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if agp.Tags != nil {
		objectMap["tags"] = agp.Tags
	}
	if agp.ApplicationGroupPatchProperties != nil {
		objectMap["properties"] = agp.ApplicationGroupPatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationGroupPatch struct.
func (agp *ApplicationGroupPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags interface{}
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				agp.Tags = tags
			}
		case "properties":
			if v != nil {
				var applicationGroupPatchProperties ApplicationGroupPatchProperties
				err = json.Unmarshal(*v, &applicationGroupPatchProperties)
				if err != nil {
					return err
				}
				agp.ApplicationGroupPatchProperties = &applicationGroupPatchProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				agp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				agp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				agp.Type = &typeVar
			}
		}
	}

	return nil
}

// ApplicationGroupPatchProperties applicationGroup properties that can be patched.
type ApplicationGroupPatchProperties struct {
	// Description - Description of ApplicationGroup.
	Description *string `json:"description,omitempty"`
	// FriendlyName - Friendly name of ApplicationGroup.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// ApplicationGroupProperties schema for ApplicationGroup properties.
type ApplicationGroupProperties struct {
	// Description - Description of ApplicationGroup.
	Description *string `json:"description,omitempty"`
	// FriendlyName - Friendly name of ApplicationGroup.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// HostPoolArmPath - HostPool arm path of ApplicationGroup.
	HostPoolArmPath *string `json:"hostPoolArmPath,omitempty"`
	// WorkspaceArmPath - READ-ONLY; Workspace arm path of ApplicationGroup.
	WorkspaceArmPath *string `json:"workspaceArmPath,omitempty"`
	// ApplicationGroupType - Resource Type of ApplicationGroup. Possible values include: 'ApplicationGroupTypeRemoteApp', 'ApplicationGroupTypeDesktop'
	ApplicationGroupType ApplicationGroupType `json:"applicationGroupType,omitempty"`
}

// ApplicationList list of Application definitions.
type ApplicationList struct {
	autorest.Response `json:"-"`
	// Value - List of Application definitions.
	Value *[]Application `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplicationListIterator provides access to a complete listing of Application values.
type ApplicationListIterator struct {
	i    int
	page ApplicationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationListIterator) Response() ApplicationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationListIterator) Value() Application {
	if !iter.page.NotDone() {
		return Application{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationListIterator type.
func NewApplicationListIterator(page ApplicationListPage) ApplicationListIterator {
	return ApplicationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (al ApplicationList) IsEmpty() bool {
	return al.Value == nil || len(*al.Value) == 0
}

// applicationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (al ApplicationList) applicationListPreparer(ctx context.Context) (*http.Request, error) {
	if al.NextLink == nil || len(to.String(al.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(al.NextLink)))
}

// ApplicationListPage contains a page of Application values.
type ApplicationListPage struct {
	fn func(context.Context, ApplicationList) (ApplicationList, error)
	al ApplicationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.al)
	if err != nil {
		return err
	}
	page.al = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationListPage) NotDone() bool {
	return !page.al.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationListPage) Response() ApplicationList {
	return page.al
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationListPage) Values() []Application {
	if page.al.IsEmpty() {
		return nil
	}
	return *page.al.Value
}

// Creates a new instance of the ApplicationListPage type.
func NewApplicationListPage(getNextPage func(context.Context, ApplicationList) (ApplicationList, error)) ApplicationListPage {
	return ApplicationListPage{fn: getNextPage}
}

// ApplicationPatch application properties that can be patched.
type ApplicationPatch struct {
	// Tags - tags to be updated
	Tags interface{} `json:"tags,omitempty"`
	// ApplicationPatchProperties - Detailed properties for Application
	*ApplicationPatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationPatch.
func (ap ApplicationPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.Tags != nil {
		objectMap["tags"] = ap.Tags
	}
	if ap.ApplicationPatchProperties != nil {
		objectMap["properties"] = ap.ApplicationPatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationPatch struct.
func (ap *ApplicationPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags interface{}
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ap.Tags = tags
			}
		case "properties":
			if v != nil {
				var applicationPatchProperties ApplicationPatchProperties
				err = json.Unmarshal(*v, &applicationPatchProperties)
				if err != nil {
					return err
				}
				ap.ApplicationPatchProperties = &applicationPatchProperties
			}
		}
	}

	return nil
}

// ApplicationPatchProperties application properties that can be patched.
type ApplicationPatchProperties struct {
	// Description - Description of Application.
	Description *string `json:"description,omitempty"`
	// FriendlyName - Friendly name of Application.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// FilePath - Specifies a path for the executable file for the application.
	FilePath *string `json:"filePath,omitempty"`
	// CommandLineSetting - Specifies whether this published application can be launched with command line arguments provided by the client, command line arguments specified at publish time, or no command line arguments at all. Possible values include: 'DoNotAllow', 'Allow', 'Require'
	CommandLineSetting CommandLineSetting `json:"commandLineSetting,omitempty"`
	// CommandLineArguments - Command Line Arguments for Application.
	CommandLineArguments *string `json:"commandLineArguments,omitempty"`
	// ShowInPortal - Specifies whether to show the RemoteApp program in the RD Web Access server.
	ShowInPortal *bool `json:"showInPortal,omitempty"`
	// IconPath - Path to icon.
	IconPath *string `json:"iconPath,omitempty"`
	// IconIndex - Index of the icon.
	IconIndex *int32 `json:"iconIndex,omitempty"`
}

// ApplicationProperties schema for Application properties.
type ApplicationProperties struct {
	// Description - Description of Application.
	Description *string `json:"description,omitempty"`
	// FriendlyName - Friendly name of Application.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// FilePath - Specifies a path for the executable file for the application.
	FilePath *string `json:"filePath,omitempty"`
	// CommandLineSetting - Specifies whether this published application can be launched with command line arguments provided by the client, command line arguments specified at publish time, or no command line arguments at all. Possible values include: 'DoNotAllow', 'Allow', 'Require'
	CommandLineSetting CommandLineSetting `json:"commandLineSetting,omitempty"`
	// CommandLineArguments - Command Line Arguments for Application.
	CommandLineArguments *string `json:"commandLineArguments,omitempty"`
	// ShowInPortal - Specifies whether to show the RemoteApp program in the RD Web Access server.
	ShowInPortal *bool `json:"showInPortal,omitempty"`
	// IconPath - Path to icon.
	IconPath *string `json:"iconPath,omitempty"`
	// IconIndex - Index of the icon.
	IconIndex *int32 `json:"iconIndex,omitempty"`
	// IconHash - READ-ONLY; Hash of the icon.
	IconHash *string `json:"iconHash,omitempty"`
	// IconContent - READ-ONLY; the icon a 64 bit string as a byte array.
	IconContent *[]byte `json:"iconContent,omitempty"`
}

// AzureEntityResource the resource model definition for a Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// CloudError error response of an operation failure
type CloudError struct {
	// Code - Error code
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// Desktop schema for Desktop properties.
type Desktop struct {
	autorest.Response `json:"-"`
	// DesktopProperties - Detailed properties for Desktop
	*DesktopProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Desktop.
func (d Desktop) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.DesktopProperties != nil {
		objectMap["properties"] = d.DesktopProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Desktop struct.
func (d *Desktop) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var desktopProperties DesktopProperties
				err = json.Unmarshal(*v, &desktopProperties)
				if err != nil {
					return err
				}
				d.DesktopProperties = &desktopProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		}
	}

	return nil
}

// DesktopList list of Desktop definitions.
type DesktopList struct {
	autorest.Response `json:"-"`
	// Value - List of Desktop definitions.
	Value *[]Desktop `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DesktopPatch desktop properties that can be patched.
type DesktopPatch struct {
	// Tags - tags to be updated
	Tags interface{} `json:"tags,omitempty"`
	// DesktopPatchProperties - Detailed properties for Desktop
	*DesktopPatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DesktopPatch.
func (dp DesktopPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.Tags != nil {
		objectMap["tags"] = dp.Tags
	}
	if dp.DesktopPatchProperties != nil {
		objectMap["properties"] = dp.DesktopPatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DesktopPatch struct.
func (dp *DesktopPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags interface{}
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dp.Tags = tags
			}
		case "properties":
			if v != nil {
				var desktopPatchProperties DesktopPatchProperties
				err = json.Unmarshal(*v, &desktopPatchProperties)
				if err != nil {
					return err
				}
				dp.DesktopPatchProperties = &desktopPatchProperties
			}
		}
	}

	return nil
}

// DesktopPatchProperties desktop properties that can be patched.
type DesktopPatchProperties struct {
	// Description - Description of Desktop.
	Description *string `json:"description,omitempty"`
	// FriendlyName - Friendly name of Desktop.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// DesktopProperties schema for Desktop properties.
type DesktopProperties struct {
	// Description - Description of Desktop.
	Description *string `json:"description,omitempty"`
	// FriendlyName - Friendly name of Desktop.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// IconHash - READ-ONLY; Hash of the icon.
	IconHash *string `json:"iconHash,omitempty"`
	// IconContent - READ-ONLY; The icon a 64 bit string as a byte array.
	IconContent *[]byte `json:"iconContent,omitempty"`
}

// HostPool represents a HostPool definition.
type HostPool struct {
	autorest.Response `json:"-"`
	// HostPoolProperties - Detailed properties for HostPool
	*HostPoolProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for HostPool.
func (hp HostPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hp.HostPoolProperties != nil {
		objectMap["properties"] = hp.HostPoolProperties
	}
	if hp.Tags != nil {
		objectMap["tags"] = hp.Tags
	}
	if hp.Location != nil {
		objectMap["location"] = hp.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HostPool struct.
func (hp *HostPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hostPoolProperties HostPoolProperties
				err = json.Unmarshal(*v, &hostPoolProperties)
				if err != nil {
					return err
				}
				hp.HostPoolProperties = &hostPoolProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				hp.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				hp.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hp.Type = &typeVar
			}
		}
	}

	return nil
}

// HostPoolList list of HostPool definitions.
type HostPoolList struct {
	autorest.Response `json:"-"`
	// Value - List of HostPool definitions.
	Value *[]HostPool `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// HostPoolListIterator provides access to a complete listing of HostPool values.
type HostPoolListIterator struct {
	i    int
	page HostPoolListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HostPoolListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostPoolListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *HostPoolListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HostPoolListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HostPoolListIterator) Response() HostPoolList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HostPoolListIterator) Value() HostPool {
	if !iter.page.NotDone() {
		return HostPool{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the HostPoolListIterator type.
func NewHostPoolListIterator(page HostPoolListPage) HostPoolListIterator {
	return HostPoolListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (hpl HostPoolList) IsEmpty() bool {
	return hpl.Value == nil || len(*hpl.Value) == 0
}

// hostPoolListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hpl HostPoolList) hostPoolListPreparer(ctx context.Context) (*http.Request, error) {
	if hpl.NextLink == nil || len(to.String(hpl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hpl.NextLink)))
}

// HostPoolListPage contains a page of HostPool values.
type HostPoolListPage struct {
	fn  func(context.Context, HostPoolList) (HostPoolList, error)
	hpl HostPoolList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HostPoolListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostPoolListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.hpl)
	if err != nil {
		return err
	}
	page.hpl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *HostPoolListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HostPoolListPage) NotDone() bool {
	return !page.hpl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HostPoolListPage) Response() HostPoolList {
	return page.hpl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HostPoolListPage) Values() []HostPool {
	if page.hpl.IsEmpty() {
		return nil
	}
	return *page.hpl.Value
}

// Creates a new instance of the HostPoolListPage type.
func NewHostPoolListPage(getNextPage func(context.Context, HostPoolList) (HostPoolList, error)) HostPoolListPage {
	return HostPoolListPage{fn: getNextPage}
}

// HostPoolPatch hostPool properties that can be patched.
type HostPoolPatch struct {
	// Tags - tags to be updated
	Tags interface{} `json:"tags,omitempty"`
	// HostPoolPatchProperties - HostPool properties that can be patched.
	*HostPoolPatchProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for HostPoolPatch.
func (hpp HostPoolPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hpp.Tags != nil {
		objectMap["tags"] = hpp.Tags
	}
	if hpp.HostPoolPatchProperties != nil {
		objectMap["properties"] = hpp.HostPoolPatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HostPoolPatch struct.
func (hpp *HostPoolPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags interface{}
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				hpp.Tags = tags
			}
		case "properties":
			if v != nil {
				var hostPoolPatchProperties HostPoolPatchProperties
				err = json.Unmarshal(*v, &hostPoolPatchProperties)
				if err != nil {
					return err
				}
				hpp.HostPoolPatchProperties = &hostPoolPatchProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hpp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hpp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hpp.Type = &typeVar
			}
		}
	}

	return nil
}

// HostPoolPatchProperties properties of HostPool.
type HostPoolPatchProperties struct {
	// FriendlyName - Friendly name of HostPool.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// Description - Description of HostPool.
	Description *string `json:"description,omitempty"`
	// CustomRdpProperty - Custom rdp property of HostPool.
	CustomRdpProperty *string `json:"customRdpProperty,omitempty"`
	// MaxSessionLimit - The max session limit of HostPool.
	MaxSessionLimit *int32 `json:"maxSessionLimit,omitempty"`
	// PersonalDesktopAssignmentType - PersonalDesktopAssignment type for HostPool. Possible values include: 'Automatic', 'Direct'
	PersonalDesktopAssignmentType PersonalDesktopAssignmentType `json:"personalDesktopAssignmentType,omitempty"`
	// LoadBalancerType - The type of the load balancer. Possible values include: 'BreadthFirst', 'DepthFirst', 'Persistent'
	LoadBalancerType LoadBalancerType `json:"loadBalancerType,omitempty"`
	// Ring - The ring number of HostPool.
	Ring *int32 `json:"ring,omitempty"`
	// ValidationEnvironment - Is validation environment.
	ValidationEnvironment *bool `json:"validationEnvironment,omitempty"`
	// RegistrationInfo - The registration info of HostPool.
	RegistrationInfo *RegistrationInfoPatch `json:"registrationInfo,omitempty"`
	// SsoContext - Path to keyvault containing ssoContext secret.
	SsoContext *string `json:"ssoContext,omitempty"`
}

// HostPoolProperties properties of HostPool.
type HostPoolProperties struct {
	// FriendlyName - Friendly name of HostPool.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// Description - Description of HostPool.
	Description *string `json:"description,omitempty"`
	// HostPoolType - HostPool type for desktop. Possible values include: 'Personal', 'Pooled'
	HostPoolType HostPoolType `json:"hostPoolType,omitempty"`
	// PersonalDesktopAssignmentType - PersonalDesktopAssignment type for HostPool. Possible values include: 'Automatic', 'Direct'
	PersonalDesktopAssignmentType PersonalDesktopAssignmentType `json:"personalDesktopAssignmentType,omitempty"`
	// CustomRdpProperty - Custom rdp property of HostPool.
	CustomRdpProperty *string `json:"customRdpProperty,omitempty"`
	// MaxSessionLimit - The max session limit of HostPool.
	MaxSessionLimit *int32 `json:"maxSessionLimit,omitempty"`
	// LoadBalancerType - The type of the load balancer. Possible values include: 'BreadthFirst', 'DepthFirst', 'Persistent'
	LoadBalancerType LoadBalancerType `json:"loadBalancerType,omitempty"`
	// Ring - The ring number of HostPool.
	Ring *int32 `json:"ring,omitempty"`
	// ValidationEnvironment - Is validation environment.
	ValidationEnvironment *bool `json:"validationEnvironment,omitempty"`
	// RegistrationInfo - The registration info of HostPool.
	RegistrationInfo *RegistrationInfo `json:"registrationInfo,omitempty"`
	// VMTemplate - VM template for sessionhosts configuration within hostpool.
	VMTemplate *string `json:"vmTemplate,omitempty"`
	// ApplicationGroupReferences - READ-ONLY; List of applicationGroup links.
	ApplicationGroupReferences *[]string `json:"applicationGroupReferences,omitempty"`
	// SsoContext - Path to keyvault containing ssoContext secret.
	SsoContext *string `json:"ssoContext,omitempty"`
}

// ProxyResource the resource model definition for a ARM proxy resource. It will have everything other than
// required location and tags
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// RegistrationInfo represents a RegistrationInfo definition.
type RegistrationInfo struct {
	// ExpirationTime - Expiration time of registration token.
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
	// Token - The registration token base64 encoded string.
	Token *string `json:"token,omitempty"`
	// RegistrationTokenOperation - The type of resetting the token. Possible values include: 'Delete', 'None', 'Update'
	RegistrationTokenOperation RegistrationTokenOperation `json:"registrationTokenOperation,omitempty"`
}

// RegistrationInfoPatch represents a RegistrationInfo definition.
type RegistrationInfoPatch struct {
	// ExpirationTime - Expiration time of registration token.
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
	// RegistrationTokenOperation - The type of resetting the token. Possible values include: 'Delete', 'None', 'Update'
	RegistrationTokenOperation RegistrationTokenOperation `json:"registrationTokenOperation,omitempty"`
}

// Resource ...
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// ResourceProviderOperation supported operation of this resource provider.
type ResourceProviderOperation struct {
	// Name - Operation name, in format of {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display metadata associated with the operation.
	Display *ResourceProviderOperationDisplay `json:"display,omitempty"`
}

// ResourceProviderOperationDisplay display metadata associated with the operation.
type ResourceProviderOperationDisplay struct {
	// Provider - Resource provider: Microsoft Desktop Virtualization.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of this operation.
	Description *string `json:"description,omitempty"`
}

// ResourceProviderOperationList result of the request to list operations.
type ResourceProviderOperationList struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by this resource provider.
	Value *[]ResourceProviderOperation `json:"value,omitempty"`
}

// SendMessage represents message sent to a UserSession.
type SendMessage struct {
	// MessageTitle - Title of message.
	MessageTitle *string `json:"messageTitle,omitempty"`
	// MessageBody - Body of message.
	MessageBody *string `json:"messageBody,omitempty"`
}

// SessionHost represents a SessionHost definition.
type SessionHost struct {
	autorest.Response `json:"-"`
	// SessionHostProperties - Detailed properties for SessionHost
	*SessionHostProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SessionHost.
func (sh SessionHost) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sh.SessionHostProperties != nil {
		objectMap["properties"] = sh.SessionHostProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SessionHost struct.
func (sh *SessionHost) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sessionHostProperties SessionHostProperties
				err = json.Unmarshal(*v, &sessionHostProperties)
				if err != nil {
					return err
				}
				sh.SessionHostProperties = &sessionHostProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sh.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sh.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sh.Type = &typeVar
			}
		}
	}

	return nil
}

// SessionHostList list of SessionHost definitions.
type SessionHostList struct {
	autorest.Response `json:"-"`
	// Value - List of SessionHost definitions.
	Value *[]SessionHost `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SessionHostListIterator provides access to a complete listing of SessionHost values.
type SessionHostListIterator struct {
	i    int
	page SessionHostListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SessionHostListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SessionHostListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SessionHostListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SessionHostListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SessionHostListIterator) Response() SessionHostList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SessionHostListIterator) Value() SessionHost {
	if !iter.page.NotDone() {
		return SessionHost{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SessionHostListIterator type.
func NewSessionHostListIterator(page SessionHostListPage) SessionHostListIterator {
	return SessionHostListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (shl SessionHostList) IsEmpty() bool {
	return shl.Value == nil || len(*shl.Value) == 0
}

// sessionHostListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (shl SessionHostList) sessionHostListPreparer(ctx context.Context) (*http.Request, error) {
	if shl.NextLink == nil || len(to.String(shl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(shl.NextLink)))
}

// SessionHostListPage contains a page of SessionHost values.
type SessionHostListPage struct {
	fn  func(context.Context, SessionHostList) (SessionHostList, error)
	shl SessionHostList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SessionHostListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SessionHostListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.shl)
	if err != nil {
		return err
	}
	page.shl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SessionHostListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SessionHostListPage) NotDone() bool {
	return !page.shl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SessionHostListPage) Response() SessionHostList {
	return page.shl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SessionHostListPage) Values() []SessionHost {
	if page.shl.IsEmpty() {
		return nil
	}
	return *page.shl.Value
}

// Creates a new instance of the SessionHostListPage type.
func NewSessionHostListPage(getNextPage func(context.Context, SessionHostList) (SessionHostList, error)) SessionHostListPage {
	return SessionHostListPage{fn: getNextPage}
}

// SessionHostPatch sessionHost properties that can be patched.
type SessionHostPatch struct {
	// SessionHostPatchProperties - Detailed properties for SessionHost
	*SessionHostPatchProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SessionHostPatch.
func (shp SessionHostPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if shp.SessionHostPatchProperties != nil {
		objectMap["properties"] = shp.SessionHostPatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SessionHostPatch struct.
func (shp *SessionHostPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sessionHostPatchProperties SessionHostPatchProperties
				err = json.Unmarshal(*v, &sessionHostPatchProperties)
				if err != nil {
					return err
				}
				shp.SessionHostPatchProperties = &sessionHostPatchProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				shp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				shp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				shp.Type = &typeVar
			}
		}
	}

	return nil
}

// SessionHostPatchProperties sessionHost properties that can be patched.
type SessionHostPatchProperties struct {
	// AllowNewSession - Allow a new session.
	AllowNewSession *bool `json:"allowNewSession,omitempty"`
	// AssignedUser - User assigned to SessionHost.
	AssignedUser *string `json:"assignedUser,omitempty"`
}

// SessionHostProperties schema for SessionHost properties.
type SessionHostProperties struct {
	// LastHeartBeat - Last heart beat from SessionHost.
	LastHeartBeat *date.Time `json:"lastHeartBeat,omitempty"`
	// Sessions - Number of sessions on SessionHost.
	Sessions *int32 `json:"sessions,omitempty"`
	// AgentVersion - Version of agent on SessionHost.
	AgentVersion *string `json:"agentVersion,omitempty"`
	// AllowNewSession - Allow a new session.
	AllowNewSession *bool `json:"allowNewSession,omitempty"`
	// AssignedUser - User assigned to SessionHost.
	AssignedUser *string `json:"assignedUser,omitempty"`
	// Status - Status for a SessionHost. Possible values include: 'StatusAvailable', 'StatusUnavailable', 'StatusShutdown', 'StatusDisconnected', 'StatusUpgrading', 'StatusUpgradeFailed'
	Status Status `json:"status,omitempty"`
	// StatusTimestamp - READ-ONLY; The timestamp of the status.
	StatusTimestamp *date.Time `json:"statusTimestamp,omitempty"`
	// OsVersion - The version of the OS on the session host.
	OsVersion *string `json:"osVersion,omitempty"`
	// SxSStackVersion - The version of the side by side stack on the session host.
	SxSStackVersion *string `json:"sxSStackVersion,omitempty"`
	// UpdateState - Update state of a SessionHost. Possible values include: 'UpdateStateInitial', 'UpdateStatePending', 'UpdateStateStarted', 'UpdateStateSucceeded', 'UpdateStateFailed'
	UpdateState UpdateState `json:"updateState,omitempty"`
	// LastUpdateTime - READ-ONLY; The timestamp of the last update.
	LastUpdateTime *date.Time `json:"lastUpdateTime,omitempty"`
	// UpdateErrorMessage - The error message.
	UpdateErrorMessage *string `json:"updateErrorMessage,omitempty"`
}

// StartMenuItem represents a StartMenuItem definition.
type StartMenuItem struct {
	// StartMenuItemProperties - Detailed properties for StartMenuItem
	*StartMenuItemProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for StartMenuItem.
func (smi StartMenuItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if smi.StartMenuItemProperties != nil {
		objectMap["properties"] = smi.StartMenuItemProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StartMenuItem struct.
func (smi *StartMenuItem) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var startMenuItemProperties StartMenuItemProperties
				err = json.Unmarshal(*v, &startMenuItemProperties)
				if err != nil {
					return err
				}
				smi.StartMenuItemProperties = &startMenuItemProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				smi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				smi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				smi.Type = &typeVar
			}
		}
	}

	return nil
}

// StartMenuItemList list of StartMenuItem definitions.
type StartMenuItemList struct {
	autorest.Response `json:"-"`
	// Value - List of StartMenuItem definitions.
	Value *[]StartMenuItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// StartMenuItemListIterator provides access to a complete listing of StartMenuItem values.
type StartMenuItemListIterator struct {
	i    int
	page StartMenuItemListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StartMenuItemListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StartMenuItemListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *StartMenuItemListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StartMenuItemListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StartMenuItemListIterator) Response() StartMenuItemList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StartMenuItemListIterator) Value() StartMenuItem {
	if !iter.page.NotDone() {
		return StartMenuItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the StartMenuItemListIterator type.
func NewStartMenuItemListIterator(page StartMenuItemListPage) StartMenuItemListIterator {
	return StartMenuItemListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (smil StartMenuItemList) IsEmpty() bool {
	return smil.Value == nil || len(*smil.Value) == 0
}

// startMenuItemListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (smil StartMenuItemList) startMenuItemListPreparer(ctx context.Context) (*http.Request, error) {
	if smil.NextLink == nil || len(to.String(smil.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(smil.NextLink)))
}

// StartMenuItemListPage contains a page of StartMenuItem values.
type StartMenuItemListPage struct {
	fn   func(context.Context, StartMenuItemList) (StartMenuItemList, error)
	smil StartMenuItemList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StartMenuItemListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StartMenuItemListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.smil)
	if err != nil {
		return err
	}
	page.smil = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *StartMenuItemListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StartMenuItemListPage) NotDone() bool {
	return !page.smil.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StartMenuItemListPage) Response() StartMenuItemList {
	return page.smil
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StartMenuItemListPage) Values() []StartMenuItem {
	if page.smil.IsEmpty() {
		return nil
	}
	return *page.smil.Value
}

// Creates a new instance of the StartMenuItemListPage type.
func NewStartMenuItemListPage(getNextPage func(context.Context, StartMenuItemList) (StartMenuItemList, error)) StartMenuItemListPage {
	return StartMenuItemListPage{fn: getNextPage}
}

// StartMenuItemProperties schema for StartMenuItem properties.
type StartMenuItemProperties struct {
	// AppAlias - Alias of StartMenuItem.
	AppAlias *string `json:"appAlias,omitempty"`
	// FriendlyName - Friendly name of StartMenuItem.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// FilePath - Path to the file of StartMenuItem.
	FilePath *string `json:"filePath,omitempty"`
	// CommandLineArguments - Command line arguments for StartMenuItem.
	CommandLineArguments *string `json:"commandLineArguments,omitempty"`
	// IconPath - Path to the icon.
	IconPath *string `json:"iconPath,omitempty"`
	// IconIndex - Index of the icon.
	IconIndex *int32 `json:"iconIndex,omitempty"`
}

// TrackedResource the resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// UserSession represents a UserSession definition.
type UserSession struct {
	autorest.Response `json:"-"`
	// UserSessionProperties - Detailed properties for UserSession
	*UserSessionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for UserSession.
func (us UserSession) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if us.UserSessionProperties != nil {
		objectMap["properties"] = us.UserSessionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UserSession struct.
func (us *UserSession) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var userSessionProperties UserSessionProperties
				err = json.Unmarshal(*v, &userSessionProperties)
				if err != nil {
					return err
				}
				us.UserSessionProperties = &userSessionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				us.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				us.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				us.Type = &typeVar
			}
		}
	}

	return nil
}

// UserSessionList list of UserSession definitions.
type UserSessionList struct {
	autorest.Response `json:"-"`
	// Value - List of UserSession definitions.
	Value *[]UserSession `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// UserSessionListIterator provides access to a complete listing of UserSession values.
type UserSessionListIterator struct {
	i    int
	page UserSessionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UserSessionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UserSessionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UserSessionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UserSessionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UserSessionListIterator) Response() UserSessionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UserSessionListIterator) Value() UserSession {
	if !iter.page.NotDone() {
		return UserSession{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UserSessionListIterator type.
func NewUserSessionListIterator(page UserSessionListPage) UserSessionListIterator {
	return UserSessionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (usl UserSessionList) IsEmpty() bool {
	return usl.Value == nil || len(*usl.Value) == 0
}

// userSessionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (usl UserSessionList) userSessionListPreparer(ctx context.Context) (*http.Request, error) {
	if usl.NextLink == nil || len(to.String(usl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(usl.NextLink)))
}

// UserSessionListPage contains a page of UserSession values.
type UserSessionListPage struct {
	fn  func(context.Context, UserSessionList) (UserSessionList, error)
	usl UserSessionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UserSessionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UserSessionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.usl)
	if err != nil {
		return err
	}
	page.usl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UserSessionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UserSessionListPage) NotDone() bool {
	return !page.usl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UserSessionListPage) Response() UserSessionList {
	return page.usl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UserSessionListPage) Values() []UserSession {
	if page.usl.IsEmpty() {
		return nil
	}
	return *page.usl.Value
}

// Creates a new instance of the UserSessionListPage type.
func NewUserSessionListPage(getNextPage func(context.Context, UserSessionList) (UserSessionList, error)) UserSessionListPage {
	return UserSessionListPage{fn: getNextPage}
}

// UserSessionProperties schema for UserSession properties.
type UserSessionProperties struct {
	// UserPrincipalName - The user principal name.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
	// ApplicationType - Application type of application. Possible values include: 'ApplicationTypeRemoteApp', 'ApplicationTypeDesktop'
	ApplicationType ApplicationType `json:"applicationType,omitempty"`
	// SessionState - State of user session. Possible values include: 'Unknown', 'Active', 'Disconnected', 'Pending', 'LogOff', 'UserProfileDiskMounted'
	SessionState SessionState `json:"sessionState,omitempty"`
	// ActiveDirectoryUserName - The active directory user name.
	ActiveDirectoryUserName *string `json:"activeDirectoryUserName,omitempty"`
	// CreateTime - The timestamp of the user session create.
	CreateTime *date.Time `json:"createTime,omitempty"`
}

// Workspace represents a Workspace definition.
type Workspace struct {
	autorest.Response `json:"-"`
	// WorkspaceProperties - Detailed properties for Workspace
	*WorkspaceProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Workspace.
func (w Workspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.WorkspaceProperties != nil {
		objectMap["properties"] = w.WorkspaceProperties
	}
	if w.Tags != nil {
		objectMap["tags"] = w.Tags
	}
	if w.Location != nil {
		objectMap["location"] = w.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Workspace struct.
func (w *Workspace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workspaceProperties WorkspaceProperties
				err = json.Unmarshal(*v, &workspaceProperties)
				if err != nil {
					return err
				}
				w.WorkspaceProperties = &workspaceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				w.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				w.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkspaceList list of Workspace definitions.
type WorkspaceList struct {
	autorest.Response `json:"-"`
	// Value - List of Workspace definitions.
	Value *[]Workspace `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkspaceListIterator provides access to a complete listing of Workspace values.
type WorkspaceListIterator struct {
	i    int
	page WorkspaceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkspaceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkspaceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkspaceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkspaceListIterator) Response() WorkspaceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkspaceListIterator) Value() Workspace {
	if !iter.page.NotDone() {
		return Workspace{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkspaceListIterator type.
func NewWorkspaceListIterator(page WorkspaceListPage) WorkspaceListIterator {
	return WorkspaceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wl WorkspaceList) IsEmpty() bool {
	return wl.Value == nil || len(*wl.Value) == 0
}

// workspaceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wl WorkspaceList) workspaceListPreparer(ctx context.Context) (*http.Request, error) {
	if wl.NextLink == nil || len(to.String(wl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wl.NextLink)))
}

// WorkspaceListPage contains a page of Workspace values.
type WorkspaceListPage struct {
	fn func(context.Context, WorkspaceList) (WorkspaceList, error)
	wl WorkspaceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkspaceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.wl)
	if err != nil {
		return err
	}
	page.wl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkspaceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkspaceListPage) NotDone() bool {
	return !page.wl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkspaceListPage) Response() WorkspaceList {
	return page.wl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkspaceListPage) Values() []Workspace {
	if page.wl.IsEmpty() {
		return nil
	}
	return *page.wl.Value
}

// Creates a new instance of the WorkspaceListPage type.
func NewWorkspaceListPage(getNextPage func(context.Context, WorkspaceList) (WorkspaceList, error)) WorkspaceListPage {
	return WorkspaceListPage{fn: getNextPage}
}

// WorkspacePatch workspace properties that can be patched.
type WorkspacePatch struct {
	// Tags - tags to be updated
	Tags interface{} `json:"tags,omitempty"`
	// WorkspacePatchProperties - Detailed properties for Workspace
	*WorkspacePatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspacePatch.
func (wp WorkspacePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wp.Tags != nil {
		objectMap["tags"] = wp.Tags
	}
	if wp.WorkspacePatchProperties != nil {
		objectMap["properties"] = wp.WorkspacePatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkspacePatch struct.
func (wp *WorkspacePatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags interface{}
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wp.Tags = tags
			}
		case "properties":
			if v != nil {
				var workspacePatchProperties WorkspacePatchProperties
				err = json.Unmarshal(*v, &workspacePatchProperties)
				if err != nil {
					return err
				}
				wp.WorkspacePatchProperties = &workspacePatchProperties
			}
		}
	}

	return nil
}

// WorkspacePatchProperties workspace properties that can be patched.
type WorkspacePatchProperties struct {
	// Description - Description of Workspace.
	Description *string `json:"description,omitempty"`
	// FriendlyName - Friendly name of Workspace.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ApplicationGroupReferences - List of applicationGroup links.
	ApplicationGroupReferences *[]string `json:"applicationGroupReferences,omitempty"`
}

// WorkspaceProperties schema for Workspace properties.
type WorkspaceProperties struct {
	// Description - Description of Workspace.
	Description *string `json:"description,omitempty"`
	// FriendlyName - Friendly name of Workspace.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ApplicationGroupReferences - List of applicationGroup resource Ids.
	ApplicationGroupReferences *[]string `json:"applicationGroupReferences,omitempty"`
}
