//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdynatrace

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/dynatrace/armdynatrace"
	moduleVersion = "v2.1.0"
)

// ActionType - Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
type ActionType string

const (
	ActionTypeInternal ActionType = "Internal"
)

// PossibleActionTypeValues returns the possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{
		ActionTypeInternal,
	}
}

// AutoUpdateSetting - Update settings of OneAgent.
type AutoUpdateSetting string

const (
	AutoUpdateSettingDISABLED AutoUpdateSetting = "DISABLED"
	AutoUpdateSettingENABLED  AutoUpdateSetting = "ENABLED"
)

// PossibleAutoUpdateSettingValues returns the possible values for the AutoUpdateSetting const type.
func PossibleAutoUpdateSettingValues() []AutoUpdateSetting {
	return []AutoUpdateSetting{
		AutoUpdateSettingDISABLED,
		AutoUpdateSettingENABLED,
	}
}

// AvailabilityState - The availability state of OneAgent.
type AvailabilityState string

const (
	AvailabilityStateCRASHED            AvailabilityState = "CRASHED"
	AvailabilityStateLOST               AvailabilityState = "LOST"
	AvailabilityStateMONITORED          AvailabilityState = "MONITORED"
	AvailabilityStatePREMONITORED       AvailabilityState = "PRE_MONITORED"
	AvailabilityStateSHUTDOWN           AvailabilityState = "SHUTDOWN"
	AvailabilityStateUNEXPECTEDSHUTDOWN AvailabilityState = "UNEXPECTED_SHUTDOWN"
	AvailabilityStateUNKNOWN            AvailabilityState = "UNKNOWN"
	AvailabilityStateUNMONITORED        AvailabilityState = "UNMONITORED"
)

// PossibleAvailabilityStateValues returns the possible values for the AvailabilityState const type.
func PossibleAvailabilityStateValues() []AvailabilityState {
	return []AvailabilityState{
		AvailabilityStateCRASHED,
		AvailabilityStateLOST,
		AvailabilityStateMONITORED,
		AvailabilityStatePREMONITORED,
		AvailabilityStateSHUTDOWN,
		AvailabilityStateUNEXPECTEDSHUTDOWN,
		AvailabilityStateUNKNOWN,
		AvailabilityStateUNMONITORED,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// LiftrResourceCategories - Liftr resource category
type LiftrResourceCategories string

const (
	LiftrResourceCategoriesMonitorLogs LiftrResourceCategories = "MonitorLogs"
	LiftrResourceCategoriesUnknown     LiftrResourceCategories = "Unknown"
)

// PossibleLiftrResourceCategoriesValues returns the possible values for the LiftrResourceCategories const type.
func PossibleLiftrResourceCategoriesValues() []LiftrResourceCategories {
	return []LiftrResourceCategories{
		LiftrResourceCategoriesMonitorLogs,
		LiftrResourceCategoriesUnknown,
	}
}

// LogModule - Tells whether log modules are enabled or not
type LogModule string

const (
	LogModuleDISABLED LogModule = "DISABLED"
	LogModuleENABLED  LogModule = "ENABLED"
)

// PossibleLogModuleValues returns the possible values for the LogModule const type.
func PossibleLogModuleValues() []LogModule {
	return []LogModule{
		LogModuleDISABLED,
		LogModuleENABLED,
	}
}

// ManagedIdentityType - The kind of managed identity assigned to this resource.
type ManagedIdentityType string

const (
	ManagedIdentityTypeSystemAndUserAssigned ManagedIdentityType = "SystemAndUserAssigned"
	ManagedIdentityTypeSystemAssigned        ManagedIdentityType = "SystemAssigned"
	ManagedIdentityTypeUserAssigned          ManagedIdentityType = "UserAssigned"
)

// PossibleManagedIdentityTypeValues returns the possible values for the ManagedIdentityType const type.
func PossibleManagedIdentityTypeValues() []ManagedIdentityType {
	return []ManagedIdentityType{
		ManagedIdentityTypeSystemAndUserAssigned,
		ManagedIdentityTypeSystemAssigned,
		ManagedIdentityTypeUserAssigned,
	}
}

// MarketplaceSubscriptionStatus - Flag specifying the Marketplace Subscription Status of the resource. If payment is not
// made in time, the resource will go in Suspended state.
type MarketplaceSubscriptionStatus string

const (
	MarketplaceSubscriptionStatusActive    MarketplaceSubscriptionStatus = "Active"
	MarketplaceSubscriptionStatusSuspended MarketplaceSubscriptionStatus = "Suspended"
)

// PossibleMarketplaceSubscriptionStatusValues returns the possible values for the MarketplaceSubscriptionStatus const type.
func PossibleMarketplaceSubscriptionStatusValues() []MarketplaceSubscriptionStatus {
	return []MarketplaceSubscriptionStatus{
		MarketplaceSubscriptionStatusActive,
		MarketplaceSubscriptionStatusSuspended,
	}
}

// MonitoringStatus - Flag specifying if the resource monitoring is enabled or disabled.
type MonitoringStatus string

const (
	MonitoringStatusDisabled MonitoringStatus = "Disabled"
	MonitoringStatusEnabled  MonitoringStatus = "Enabled"
)

// PossibleMonitoringStatusValues returns the possible values for the MonitoringStatus const type.
func PossibleMonitoringStatusValues() []MonitoringStatus {
	return []MonitoringStatus{
		MonitoringStatusDisabled,
		MonitoringStatusEnabled,
	}
}

// MonitoringType - The monitoring mode of OneAgent
type MonitoringType string

const (
	MonitoringTypeCLOUDINFRASTRUCTURE MonitoringType = "CLOUD_INFRASTRUCTURE"
	MonitoringTypeFULLSTACK           MonitoringType = "FULL_STACK"
)

// PossibleMonitoringTypeValues returns the possible values for the MonitoringType const type.
func PossibleMonitoringTypeValues() []MonitoringType {
	return []MonitoringType{
		MonitoringTypeCLOUDINFRASTRUCTURE,
		MonitoringTypeFULLSTACK,
	}
}

// Origin - The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
// value is "user,system"
type Origin string

const (
	OriginSystem     Origin = "system"
	OriginUser       Origin = "user"
	OriginUserSystem Origin = "user,system"
)

// PossibleOriginValues returns the possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{
		OriginSystem,
		OriginUser,
		OriginUserSystem,
	}
}

// ProvisioningState - Provisioning state of the monitoring resource
type ProvisioningState string

const (
	ProvisioningStateAccepted     ProvisioningState = "Accepted"
	ProvisioningStateCanceled     ProvisioningState = "Canceled"
	ProvisioningStateCreating     ProvisioningState = "Creating"
	ProvisioningStateDeleted      ProvisioningState = "Deleted"
	ProvisioningStateDeleting     ProvisioningState = "Deleting"
	ProvisioningStateFailed       ProvisioningState = "Failed"
	ProvisioningStateNotSpecified ProvisioningState = "NotSpecified"
	ProvisioningStateSucceeded    ProvisioningState = "Succeeded"
	ProvisioningStateUpdating     ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateAccepted,
		ProvisioningStateCanceled,
		ProvisioningStateCreating,
		ProvisioningStateDeleted,
		ProvisioningStateDeleting,
		ProvisioningStateFailed,
		ProvisioningStateNotSpecified,
		ProvisioningStateSucceeded,
		ProvisioningStateUpdating,
	}
}

// SSOStatus - Indicates whether SSO is enabled or not
type SSOStatus string

const (
	SSOStatusDisabled SSOStatus = "Disabled"
	SSOStatusEnabled  SSOStatus = "Enabled"
)

// PossibleSSOStatusValues returns the possible values for the SSOStatus const type.
func PossibleSSOStatusValues() []SSOStatus {
	return []SSOStatus{
		SSOStatusDisabled,
		SSOStatusEnabled,
	}
}

// SendAADLogsStatus - Indicates whether AAD logs are being sent.
type SendAADLogsStatus string

const (
	SendAADLogsStatusDisabled SendAADLogsStatus = "Disabled"
	SendAADLogsStatusEnabled  SendAADLogsStatus = "Enabled"
)

// PossibleSendAADLogsStatusValues returns the possible values for the SendAADLogsStatus const type.
func PossibleSendAADLogsStatusValues() []SendAADLogsStatus {
	return []SendAADLogsStatus{
		SendAADLogsStatusDisabled,
		SendAADLogsStatusEnabled,
	}
}

// SendActivityLogsStatus - Indicates whether activity logs are being sent.
type SendActivityLogsStatus string

const (
	SendActivityLogsStatusDisabled SendActivityLogsStatus = "Disabled"
	SendActivityLogsStatusEnabled  SendActivityLogsStatus = "Enabled"
)

// PossibleSendActivityLogsStatusValues returns the possible values for the SendActivityLogsStatus const type.
func PossibleSendActivityLogsStatusValues() []SendActivityLogsStatus {
	return []SendActivityLogsStatus{
		SendActivityLogsStatusDisabled,
		SendActivityLogsStatusEnabled,
	}
}

// SendSubscriptionLogsStatus - Indicates whether subscription logs are being sent.
type SendSubscriptionLogsStatus string

const (
	SendSubscriptionLogsStatusDisabled SendSubscriptionLogsStatus = "Disabled"
	SendSubscriptionLogsStatusEnabled  SendSubscriptionLogsStatus = "Enabled"
)

// PossibleSendSubscriptionLogsStatusValues returns the possible values for the SendSubscriptionLogsStatus const type.
func PossibleSendSubscriptionLogsStatusValues() []SendSubscriptionLogsStatus {
	return []SendSubscriptionLogsStatus{
		SendSubscriptionLogsStatusDisabled,
		SendSubscriptionLogsStatusEnabled,
	}
}

// SendingLogsStatus - Indicates whether logs are being sent.
type SendingLogsStatus string

const (
	SendingLogsStatusDisabled SendingLogsStatus = "Disabled"
	SendingLogsStatusEnabled  SendingLogsStatus = "Enabled"
)

// PossibleSendingLogsStatusValues returns the possible values for the SendingLogsStatus const type.
func PossibleSendingLogsStatusValues() []SendingLogsStatus {
	return []SendingLogsStatus{
		SendingLogsStatusDisabled,
		SendingLogsStatusEnabled,
	}
}

// SendingMetricsStatus - Indicates whether metrics are being sent.
type SendingMetricsStatus string

const (
	SendingMetricsStatusDisabled SendingMetricsStatus = "Disabled"
	SendingMetricsStatusEnabled  SendingMetricsStatus = "Enabled"
)

// PossibleSendingMetricsStatusValues returns the possible values for the SendingMetricsStatus const type.
func PossibleSendingMetricsStatusValues() []SendingMetricsStatus {
	return []SendingMetricsStatus{
		SendingMetricsStatusDisabled,
		SendingMetricsStatusEnabled,
	}
}

// SingleSignOnStates - Various states of the SSO resource
type SingleSignOnStates string

const (
	SingleSignOnStatesDisable  SingleSignOnStates = "Disable"
	SingleSignOnStatesEnable   SingleSignOnStates = "Enable"
	SingleSignOnStatesExisting SingleSignOnStates = "Existing"
	SingleSignOnStatesInitial  SingleSignOnStates = "Initial"
)

// PossibleSingleSignOnStatesValues returns the possible values for the SingleSignOnStates const type.
func PossibleSingleSignOnStatesValues() []SingleSignOnStates {
	return []SingleSignOnStates{
		SingleSignOnStatesDisable,
		SingleSignOnStatesEnable,
		SingleSignOnStatesExisting,
		SingleSignOnStatesInitial,
	}
}

// TagAction - Valid actions for a filtering tag. Exclusion takes priority over inclusion.
type TagAction string

const (
	TagActionExclude TagAction = "Exclude"
	TagActionInclude TagAction = "Include"
)

// PossibleTagActionValues returns the possible values for the TagAction const type.
func PossibleTagActionValues() []TagAction {
	return []TagAction{
		TagActionExclude,
		TagActionInclude,
	}
}

// UpdateStatus - The current update status of OneAgent.
type UpdateStatus string

const (
	UpdateStatusINCOMPATIBLE     UpdateStatus = "INCOMPATIBLE"
	UpdateStatusOUTDATED         UpdateStatus = "OUTDATED"
	UpdateStatusSCHEDULED        UpdateStatus = "SCHEDULED"
	UpdateStatusSUPPRESSED       UpdateStatus = "SUPPRESSED"
	UpdateStatusUNKNOWN          UpdateStatus = "UNKNOWN"
	UpdateStatusUP2DATE          UpdateStatus = "UP2DATE"
	UpdateStatusUPDATEINPROGRESS UpdateStatus = "UPDATE_IN_PROGRESS"
	UpdateStatusUPDATEPENDING    UpdateStatus = "UPDATE_PENDING"
	UpdateStatusUPDATEPROBLEM    UpdateStatus = "UPDATE_PROBLEM"
)

// PossibleUpdateStatusValues returns the possible values for the UpdateStatus const type.
func PossibleUpdateStatusValues() []UpdateStatus {
	return []UpdateStatus{
		UpdateStatusINCOMPATIBLE,
		UpdateStatusOUTDATED,
		UpdateStatusSCHEDULED,
		UpdateStatusSUPPRESSED,
		UpdateStatusUNKNOWN,
		UpdateStatusUP2DATE,
		UpdateStatusUPDATEINPROGRESS,
		UpdateStatusUPDATEPENDING,
		UpdateStatusUPDATEPROBLEM,
	}
}
