//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armeducation.ClientFactory type.
type ServerFactory struct {
	GrantsServer       GrantsServer
	JoinRequestsServer JoinRequestsServer
	LabsServer         LabsServer
	ManagementServer   ManagementServer
	OperationsServer   OperationsServer
	StudentLabsServer  StudentLabsServer
	StudentsServer     StudentsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armeducation.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armeducation.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                  *ServerFactory
	trMu                 sync.Mutex
	trGrantsServer       *GrantsServerTransport
	trJoinRequestsServer *JoinRequestsServerTransport
	trLabsServer         *LabsServerTransport
	trManagementServer   *ManagementServerTransport
	trOperationsServer   *OperationsServerTransport
	trStudentLabsServer  *StudentLabsServerTransport
	trStudentsServer     *StudentsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "GrantsClient":
		initServer(s, &s.trGrantsServer, func() *GrantsServerTransport { return NewGrantsServerTransport(&s.srv.GrantsServer) })
		resp, err = s.trGrantsServer.Do(req)
	case "JoinRequestsClient":
		initServer(s, &s.trJoinRequestsServer, func() *JoinRequestsServerTransport { return NewJoinRequestsServerTransport(&s.srv.JoinRequestsServer) })
		resp, err = s.trJoinRequestsServer.Do(req)
	case "LabsClient":
		initServer(s, &s.trLabsServer, func() *LabsServerTransport { return NewLabsServerTransport(&s.srv.LabsServer) })
		resp, err = s.trLabsServer.Do(req)
	case "ManagementClient":
		initServer(s, &s.trManagementServer, func() *ManagementServerTransport { return NewManagementServerTransport(&s.srv.ManagementServer) })
		resp, err = s.trManagementServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "StudentLabsClient":
		initServer(s, &s.trStudentLabsServer, func() *StudentLabsServerTransport { return NewStudentLabsServerTransport(&s.srv.StudentLabsServer) })
		resp, err = s.trStudentLabsServer.Do(req)
	case "StudentsClient":
		initServer(s, &s.trStudentsServer, func() *StudentsServerTransport { return NewStudentsServerTransport(&s.srv.StudentsServer) })
		resp, err = s.trStudentsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
