//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armlogic_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/logic/armlogic"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccountAgreements_List.json
func ExampleIntegrationAccountAgreementsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewIntegrationAccountAgreementsClient().NewListPager("testResourceGroup", "testIntegrationAccount", &armlogic.IntegrationAccountAgreementsClientListOptions{Top: nil,
		Filter: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.IntegrationAccountAgreementListResult = armlogic.IntegrationAccountAgreementListResult{
		// 	Value: []*armlogic.IntegrationAccountAgreement{
		// 		{
		// 			Name: to.Ptr("<IntegrationAccountAgreementName>"),
		// 			Type: to.Ptr("Microsoft.Logic/integrationAccounts/agreements"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testResourceGroup/providers/Microsoft.Logic/integrationAccounts/<IntegrationAccountName>/agreements/<IntegrationAccountAgreementName>"),
		// 			Properties: &armlogic.IntegrationAccountAgreementProperties{
		// 				AgreementType: to.Ptr(armlogic.AgreementTypeX12),
		// 				ChangedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-06T22:00:54.152Z"); return t}()),
		// 				Content: &armlogic.AgreementContent{
		// 					X12: &armlogic.X12AgreementContent{
		// 						ReceiveAgreement: &armlogic.X12OneWayAgreement{
		// 							ProtocolSettings: &armlogic.X12ProtocolSettings{
		// 								AcknowledgementSettings: &armlogic.X12AcknowledgementSettings{
		// 									AcknowledgementControlNumberLowerBound: to.Ptr[int32](1),
		// 									AcknowledgementControlNumberUpperBound: to.Ptr[int32](999999999),
		// 									BatchFunctionalAcknowledgements: to.Ptr(true),
		// 									BatchImplementationAcknowledgements: to.Ptr(false),
		// 									BatchTechnicalAcknowledgements: to.Ptr(true),
		// 									NeedFunctionalAcknowledgement: to.Ptr(false),
		// 									NeedImplementationAcknowledgement: to.Ptr(false),
		// 									NeedLoopForValidMessages: to.Ptr(false),
		// 									NeedTechnicalAcknowledgement: to.Ptr(false),
		// 									RolloverAcknowledgementControlNumber: to.Ptr(true),
		// 									SendSynchronousAcknowledgement: to.Ptr(true),
		// 								},
		// 								EnvelopeSettings: &armlogic.X12EnvelopeSettings{
		// 									ControlStandardsID: to.Ptr[int32](85),
		// 									ControlVersionNumber: to.Ptr("00401"),
		// 									EnableDefaultGroupHeaders: to.Ptr(true),
		// 									GroupControlNumberLowerBound: to.Ptr[int32](1),
		// 									GroupControlNumberUpperBound: to.Ptr[int32](999999999),
		// 									GroupHeaderAgencyCode: to.Ptr("T"),
		// 									GroupHeaderDateFormat: to.Ptr(armlogic.X12DateFormatCCYYMMDD),
		// 									GroupHeaderTimeFormat: to.Ptr(armlogic.X12TimeFormatHHMM),
		// 									GroupHeaderVersion: to.Ptr("00401"),
		// 									InterchangeControlNumberLowerBound: to.Ptr[int32](1),
		// 									InterchangeControlNumberUpperBound: to.Ptr[int32](999999999),
		// 									OverwriteExistingTransactionSetControlNumber: to.Ptr(true),
		// 									ReceiverApplicationID: to.Ptr("RECEIVE-APP"),
		// 									RolloverGroupControlNumber: to.Ptr(true),
		// 									RolloverInterchangeControlNumber: to.Ptr(true),
		// 									RolloverTransactionSetControlNumber: to.Ptr(true),
		// 									SenderApplicationID: to.Ptr("BTS-SENDER"),
		// 									TransactionSetControlNumberLowerBound: to.Ptr[int32](1),
		// 									TransactionSetControlNumberUpperBound: to.Ptr[int32](999999999),
		// 									UsageIndicator: to.Ptr(armlogic.UsageIndicatorTest),
		// 									UseControlStandardsIDAsRepetitionCharacter: to.Ptr(false),
		// 								},
		// 								FramingSettings: &armlogic.X12FramingSettings{
		// 									CharacterSet: to.Ptr(armlogic.X12CharacterSetUTF8),
		// 									ComponentSeparator: to.Ptr[int32](58),
		// 									DataElementSeparator: to.Ptr[int32](42),
		// 									ReplaceCharacter: to.Ptr[int32](36),
		// 									ReplaceSeparatorsInPayload: to.Ptr(false),
		// 									SegmentTerminator: to.Ptr[int32](126),
		// 									SegmentTerminatorSuffix: to.Ptr(armlogic.SegmentTerminatorSuffixNone),
		// 								},
		// 								MessageFilter: &armlogic.X12MessageFilter{
		// 									MessageFilterType: to.Ptr(armlogic.MessageFilterTypeExclude),
		// 								},
		// 								ProcessingSettings: &armlogic.X12ProcessingSettings{
		// 									ConvertImpliedDecimal: to.Ptr(true),
		// 									CreateEmptyXMLTagsForTrailingSeparators: to.Ptr(true),
		// 									MaskSecurityInfo: to.Ptr(true),
		// 									PreserveInterchange: to.Ptr(true),
		// 									SuspendInterchangeOnError: to.Ptr(true),
		// 									UseDotAsDecimalSeparator: to.Ptr(true),
		// 								},
		// 								SchemaReferences: []*armlogic.X12SchemaReference{
		// 								},
		// 								SecuritySettings: &armlogic.X12SecuritySettings{
		// 									AuthorizationQualifier: to.Ptr("00"),
		// 									SecurityQualifier: to.Ptr("00"),
		// 								},
		// 								ValidationSettings: &armlogic.X12ValidationSettings{
		// 									AllowLeadingAndTrailingSpacesAndZeroes: to.Ptr(false),
		// 									CheckDuplicateGroupControlNumber: to.Ptr(false),
		// 									CheckDuplicateInterchangeControlNumber: to.Ptr(false),
		// 									CheckDuplicateTransactionSetControlNumber: to.Ptr(false),
		// 									InterchangeControlNumberValidityDays: to.Ptr[int32](30),
		// 									TrailingSeparatorPolicy: to.Ptr(armlogic.TrailingSeparatorPolicyNotAllowed),
		// 									TrimLeadingAndTrailingSpacesAndZeroes: to.Ptr(false),
		// 									ValidateCharacterSet: to.Ptr(true),
		// 									ValidateEDITypes: to.Ptr(true),
		// 									ValidateXSDTypes: to.Ptr(false),
		// 								},
		// 							},
		// 							ReceiverBusinessIdentity: &armlogic.BusinessIdentity{
		// 								Qualifier: to.Ptr("ZZ"),
		// 								Value: to.Ptr("ZZ"),
		// 							},
		// 							SenderBusinessIdentity: &armlogic.BusinessIdentity{
		// 								Qualifier: to.Ptr("AA"),
		// 								Value: to.Ptr("AA"),
		// 							},
		// 						},
		// 						SendAgreement: &armlogic.X12OneWayAgreement{
		// 							ProtocolSettings: &armlogic.X12ProtocolSettings{
		// 								AcknowledgementSettings: &armlogic.X12AcknowledgementSettings{
		// 									AcknowledgementControlNumberLowerBound: to.Ptr[int32](1),
		// 									AcknowledgementControlNumberUpperBound: to.Ptr[int32](999999999),
		// 									BatchFunctionalAcknowledgements: to.Ptr(true),
		// 									BatchImplementationAcknowledgements: to.Ptr(false),
		// 									BatchTechnicalAcknowledgements: to.Ptr(true),
		// 									NeedFunctionalAcknowledgement: to.Ptr(false),
		// 									NeedImplementationAcknowledgement: to.Ptr(false),
		// 									NeedLoopForValidMessages: to.Ptr(false),
		// 									NeedTechnicalAcknowledgement: to.Ptr(false),
		// 									RolloverAcknowledgementControlNumber: to.Ptr(true),
		// 									SendSynchronousAcknowledgement: to.Ptr(true),
		// 								},
		// 								EnvelopeSettings: &armlogic.X12EnvelopeSettings{
		// 									ControlStandardsID: to.Ptr[int32](100),
		// 									ControlVersionNumber: to.Ptr("0.0"),
		// 									EnableDefaultGroupHeaders: to.Ptr(true),
		// 									FunctionalGroupID: to.Ptr("1"),
		// 									GroupControlNumberLowerBound: to.Ptr[int32](1),
		// 									GroupControlNumberUpperBound: to.Ptr[int32](999999999),
		// 									GroupHeaderAgencyCode: to.Ptr("T"),
		// 									GroupHeaderDateFormat: to.Ptr(armlogic.X12DateFormatCCYYMMDD),
		// 									GroupHeaderTimeFormat: to.Ptr(armlogic.X12TimeFormatHHMM),
		// 									GroupHeaderVersion: to.Ptr("0.0"),
		// 									InterchangeControlNumberLowerBound: to.Ptr[int32](1),
		// 									InterchangeControlNumberUpperBound: to.Ptr[int32](999999999),
		// 									OverwriteExistingTransactionSetControlNumber: to.Ptr(true),
		// 									ReceiverApplicationID: to.Ptr("100"),
		// 									RolloverGroupControlNumber: to.Ptr(true),
		// 									RolloverInterchangeControlNumber: to.Ptr(true),
		// 									RolloverTransactionSetControlNumber: to.Ptr(true),
		// 									SenderApplicationID: to.Ptr("100"),
		// 									TransactionSetControlNumberLowerBound: to.Ptr[int32](1),
		// 									TransactionSetControlNumberPrefix: to.Ptr(""),
		// 									TransactionSetControlNumberSuffix: to.Ptr(""),
		// 									TransactionSetControlNumberUpperBound: to.Ptr[int32](999999999),
		// 									UsageIndicator: to.Ptr(armlogic.UsageIndicatorInformation),
		// 									UseControlStandardsIDAsRepetitionCharacter: to.Ptr(true),
		// 								},
		// 								FramingSettings: &armlogic.X12FramingSettings{
		// 									CharacterSet: to.Ptr(armlogic.X12CharacterSetUTF8),
		// 									ComponentSeparator: to.Ptr[int32](58),
		// 									DataElementSeparator: to.Ptr[int32](42),
		// 									ReplaceCharacter: to.Ptr[int32](36),
		// 									ReplaceSeparatorsInPayload: to.Ptr(false),
		// 									SegmentTerminator: to.Ptr[int32](126),
		// 									SegmentTerminatorSuffix: to.Ptr(armlogic.SegmentTerminatorSuffixNone),
		// 								},
		// 								MessageFilter: &armlogic.X12MessageFilter{
		// 									MessageFilterType: to.Ptr(armlogic.MessageFilterTypeExclude),
		// 								},
		// 								ProcessingSettings: &armlogic.X12ProcessingSettings{
		// 									ConvertImpliedDecimal: to.Ptr(true),
		// 									CreateEmptyXMLTagsForTrailingSeparators: to.Ptr(true),
		// 									MaskSecurityInfo: to.Ptr(true),
		// 									PreserveInterchange: to.Ptr(true),
		// 									SuspendInterchangeOnError: to.Ptr(true),
		// 									UseDotAsDecimalSeparator: to.Ptr(true),
		// 								},
		// 								SchemaReferences: []*armlogic.X12SchemaReference{
		// 								},
		// 								SecuritySettings: &armlogic.X12SecuritySettings{
		// 									AuthorizationQualifier: to.Ptr("00"),
		// 									SecurityQualifier: to.Ptr("00"),
		// 								},
		// 								ValidationSettings: &armlogic.X12ValidationSettings{
		// 									AllowLeadingAndTrailingSpacesAndZeroes: to.Ptr(false),
		// 									CheckDuplicateGroupControlNumber: to.Ptr(false),
		// 									CheckDuplicateInterchangeControlNumber: to.Ptr(false),
		// 									CheckDuplicateTransactionSetControlNumber: to.Ptr(false),
		// 									InterchangeControlNumberValidityDays: to.Ptr[int32](30),
		// 									TrailingSeparatorPolicy: to.Ptr(armlogic.TrailingSeparatorPolicyNotAllowed),
		// 									TrimLeadingAndTrailingSpacesAndZeroes: to.Ptr(false),
		// 									ValidateCharacterSet: to.Ptr(true),
		// 									ValidateEDITypes: to.Ptr(true),
		// 									ValidateXSDTypes: to.Ptr(false),
		// 								},
		// 							},
		// 							ReceiverBusinessIdentity: &armlogic.BusinessIdentity{
		// 								Qualifier: to.Ptr("AA"),
		// 								Value: to.Ptr("AA"),
		// 							},
		// 							SenderBusinessIdentity: &armlogic.BusinessIdentity{
		// 								Qualifier: to.Ptr("ZZ"),
		// 								Value: to.Ptr("ZZ"),
		// 							},
		// 						},
		// 					},
		// 				},
		// 				CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-06T22:00:54.151Z"); return t}()),
		// 				GuestIdentity: &armlogic.BusinessIdentity{
		// 					Qualifier: to.Ptr("AA"),
		// 					Value: to.Ptr("AA"),
		// 				},
		// 				GuestPartner: to.Ptr("GuestPartner"),
		// 				HostIdentity: &armlogic.BusinessIdentity{
		// 					Qualifier: to.Ptr("ZZ"),
		// 					Value: to.Ptr("ZZ"),
		// 				},
		// 				HostPartner: to.Ptr("HostPartner"),
		// 				Metadata: map[string]any{
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("<IntegrationAccountAgreementName>"),
		// 			Type: to.Ptr("Microsoft.Logic/integrationAccounts/agreements"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testResourceGroup/providers/Microsoft.Logic/integrationAccounts/<IntegrationAccountName>/agreements/<IntegrationAccountAgreementName>"),
		// 			Properties: &armlogic.IntegrationAccountAgreementProperties{
		// 				AgreementType: to.Ptr(armlogic.AgreementTypeAS2),
		// 				ChangedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-06T22:00:53.414Z"); return t}()),
		// 				Content: &armlogic.AgreementContent{
		// 					AS2: &armlogic.AS2AgreementContent{
		// 						ReceiveAgreement: &armlogic.AS2OneWayAgreement{
		// 							ProtocolSettings: &armlogic.AS2ProtocolSettings{
		// 								AcknowledgementConnectionSettings: &armlogic.AS2AcknowledgementConnectionSettings{
		// 									IgnoreCertificateNameMismatch: to.Ptr(true),
		// 									KeepHTTPConnectionAlive: to.Ptr(true),
		// 									SupportHTTPStatusCodeContinue: to.Ptr(true),
		// 									UnfoldHTTPHeaders: to.Ptr(true),
		// 								},
		// 								EnvelopeSettings: &armlogic.AS2EnvelopeSettings{
		// 									AutogenerateFileName: to.Ptr(true),
		// 									FileNameTemplate: to.Ptr("Test"),
		// 									MessageContentType: to.Ptr("text/plain"),
		// 									SuspendMessageOnFileNameGenerationError: to.Ptr(true),
		// 									TransmitFileNameInMimeHeader: to.Ptr(true),
		// 								},
		// 								ErrorSettings: &armlogic.AS2ErrorSettings{
		// 									ResendIfMDNNotReceived: to.Ptr(true),
		// 									SuspendDuplicateMessage: to.Ptr(true),
		// 								},
		// 								MdnSettings: &armlogic.AS2MdnSettings{
		// 									DispositionNotificationTo: to.Ptr("http://tempuri.org"),
		// 									MdnText: to.Ptr("Sample"),
		// 									MicHashingAlgorithm: to.Ptr(armlogic.HashingAlgorithmNone),
		// 									NeedMDN: to.Ptr(true),
		// 									ReceiptDeliveryURL: to.Ptr("http://tempuri.org"),
		// 									SendInboundMDNToMessageBox: to.Ptr(true),
		// 									SendMDNAsynchronously: to.Ptr(true),
		// 									SignMDN: to.Ptr(true),
		// 									SignOutboundMDNIfOptional: to.Ptr(true),
		// 								},
		// 								MessageConnectionSettings: &armlogic.AS2MessageConnectionSettings{
		// 									IgnoreCertificateNameMismatch: to.Ptr(true),
		// 									KeepHTTPConnectionAlive: to.Ptr(true),
		// 									SupportHTTPStatusCodeContinue: to.Ptr(true),
		// 									UnfoldHTTPHeaders: to.Ptr(true),
		// 								},
		// 								SecuritySettings: &armlogic.AS2SecuritySettings{
		// 									EnableNRRForInboundDecodedMessages: to.Ptr(true),
		// 									EnableNRRForInboundEncodedMessages: to.Ptr(true),
		// 									EnableNRRForInboundMDN: to.Ptr(true),
		// 									EnableNRRForOutboundDecodedMessages: to.Ptr(true),
		// 									EnableNRRForOutboundEncodedMessages: to.Ptr(true),
		// 									EnableNRRForOutboundMDN: to.Ptr(true),
		// 									OverrideGroupSigningCertificate: to.Ptr(false),
		// 								},
		// 								ValidationSettings: &armlogic.AS2ValidationSettings{
		// 									CheckCertificateRevocationListOnReceive: to.Ptr(true),
		// 									CheckCertificateRevocationListOnSend: to.Ptr(true),
		// 									CheckDuplicateMessage: to.Ptr(true),
		// 									CompressMessage: to.Ptr(true),
		// 									EncryptMessage: to.Ptr(false),
		// 									EncryptionAlgorithm: to.Ptr(armlogic.EncryptionAlgorithmAES128),
		// 									InterchangeDuplicatesValidityDays: to.Ptr[int32](100),
		// 									OverrideMessageProperties: to.Ptr(true),
		// 									SignMessage: to.Ptr(false),
		// 								},
		// 							},
		// 							ReceiverBusinessIdentity: &armlogic.BusinessIdentity{
		// 								Qualifier: to.Ptr("ZZ"),
		// 								Value: to.Ptr("ZZ"),
		// 							},
		// 							SenderBusinessIdentity: &armlogic.BusinessIdentity{
		// 								Qualifier: to.Ptr("AA"),
		// 								Value: to.Ptr("AA"),
		// 							},
		// 						},
		// 						SendAgreement: &armlogic.AS2OneWayAgreement{
		// 							ProtocolSettings: &armlogic.AS2ProtocolSettings{
		// 								AcknowledgementConnectionSettings: &armlogic.AS2AcknowledgementConnectionSettings{
		// 									IgnoreCertificateNameMismatch: to.Ptr(true),
		// 									KeepHTTPConnectionAlive: to.Ptr(true),
		// 									SupportHTTPStatusCodeContinue: to.Ptr(true),
		// 									UnfoldHTTPHeaders: to.Ptr(true),
		// 								},
		// 								EnvelopeSettings: &armlogic.AS2EnvelopeSettings{
		// 									AutogenerateFileName: to.Ptr(true),
		// 									FileNameTemplate: to.Ptr("Test"),
		// 									MessageContentType: to.Ptr("text/plain"),
		// 									SuspendMessageOnFileNameGenerationError: to.Ptr(true),
		// 									TransmitFileNameInMimeHeader: to.Ptr(true),
		// 								},
		// 								ErrorSettings: &armlogic.AS2ErrorSettings{
		// 									ResendIfMDNNotReceived: to.Ptr(true),
		// 									SuspendDuplicateMessage: to.Ptr(true),
		// 								},
		// 								MdnSettings: &armlogic.AS2MdnSettings{
		// 									DispositionNotificationTo: to.Ptr("http://tempuri.org"),
		// 									MdnText: to.Ptr("Sample"),
		// 									MicHashingAlgorithm: to.Ptr(armlogic.HashingAlgorithmNone),
		// 									NeedMDN: to.Ptr(true),
		// 									ReceiptDeliveryURL: to.Ptr("http://tempuri.org"),
		// 									SendInboundMDNToMessageBox: to.Ptr(true),
		// 									SendMDNAsynchronously: to.Ptr(true),
		// 									SignMDN: to.Ptr(true),
		// 									SignOutboundMDNIfOptional: to.Ptr(true),
		// 								},
		// 								MessageConnectionSettings: &armlogic.AS2MessageConnectionSettings{
		// 									IgnoreCertificateNameMismatch: to.Ptr(true),
		// 									KeepHTTPConnectionAlive: to.Ptr(true),
		// 									SupportHTTPStatusCodeContinue: to.Ptr(true),
		// 									UnfoldHTTPHeaders: to.Ptr(true),
		// 								},
		// 								SecuritySettings: &armlogic.AS2SecuritySettings{
		// 									EnableNRRForInboundDecodedMessages: to.Ptr(true),
		// 									EnableNRRForInboundEncodedMessages: to.Ptr(true),
		// 									EnableNRRForInboundMDN: to.Ptr(true),
		// 									EnableNRRForOutboundDecodedMessages: to.Ptr(true),
		// 									EnableNRRForOutboundEncodedMessages: to.Ptr(true),
		// 									EnableNRRForOutboundMDN: to.Ptr(true),
		// 									OverrideGroupSigningCertificate: to.Ptr(false),
		// 								},
		// 								ValidationSettings: &armlogic.AS2ValidationSettings{
		// 									CheckCertificateRevocationListOnReceive: to.Ptr(true),
		// 									CheckCertificateRevocationListOnSend: to.Ptr(true),
		// 									CheckDuplicateMessage: to.Ptr(true),
		// 									CompressMessage: to.Ptr(true),
		// 									EncryptMessage: to.Ptr(false),
		// 									EncryptionAlgorithm: to.Ptr(armlogic.EncryptionAlgorithmAES128),
		// 									InterchangeDuplicatesValidityDays: to.Ptr[int32](100),
		// 									OverrideMessageProperties: to.Ptr(true),
		// 									SignMessage: to.Ptr(false),
		// 								},
		// 							},
		// 							ReceiverBusinessIdentity: &armlogic.BusinessIdentity{
		// 								Qualifier: to.Ptr("AA"),
		// 								Value: to.Ptr("AA"),
		// 							},
		// 							SenderBusinessIdentity: &armlogic.BusinessIdentity{
		// 								Qualifier: to.Ptr("ZZ"),
		// 								Value: to.Ptr("ZZ"),
		// 							},
		// 						},
		// 					},
		// 				},
		// 				CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-06T22:00:53.413Z"); return t}()),
		// 				GuestIdentity: &armlogic.BusinessIdentity{
		// 					Qualifier: to.Ptr("AA"),
		// 					Value: to.Ptr("AA"),
		// 				},
		// 				GuestPartner: to.Ptr("GuestPartner"),
		// 				HostIdentity: &armlogic.BusinessIdentity{
		// 					Qualifier: to.Ptr("ZZ"),
		// 					Value: to.Ptr("ZZ"),
		// 				},
		// 				HostPartner: to.Ptr("HostPartner"),
		// 				Metadata: map[string]any{
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("<IntegrationAccountAgreementName>"),
		// 			Type: to.Ptr("Microsoft.Logic/integrationAccounts/agreements"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testResourceGroup/providers/Microsoft.Logic/integrationAccounts/<IntegrationAccountName>/agreements/<IntegrationAccountAgreementName>"),
		// 			Properties: &armlogic.IntegrationAccountAgreementProperties{
		// 				AgreementType: to.Ptr(armlogic.AgreementTypeEdifact),
		// 				ChangedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-06T22:00:53.821Z"); return t}()),
		// 				Content: &armlogic.AgreementContent{
		// 					Edifact: &armlogic.EdifactAgreementContent{
		// 						ReceiveAgreement: &armlogic.EdifactOneWayAgreement{
		// 							ProtocolSettings: &armlogic.EdifactProtocolSettings{
		// 								AcknowledgementSettings: &armlogic.EdifactAcknowledgementSettings{
		// 									AcknowledgementControlNumberLowerBound: to.Ptr[int32](1),
		// 									AcknowledgementControlNumberPrefix: to.Ptr(""),
		// 									AcknowledgementControlNumberSuffix: to.Ptr(""),
		// 									AcknowledgementControlNumberUpperBound: to.Ptr[int32](99999999),
		// 									BatchFunctionalAcknowledgements: to.Ptr(true),
		// 									BatchTechnicalAcknowledgements: to.Ptr(true),
		// 									NeedFunctionalAcknowledgement: to.Ptr(false),
		// 									NeedLoopForValidMessages: to.Ptr(false),
		// 									NeedTechnicalAcknowledgement: to.Ptr(true),
		// 									RolloverAcknowledgementControlNumber: to.Ptr(true),
		// 									SendSynchronousAcknowledgement: to.Ptr(true),
		// 								},
		// 								EnvelopeSettings: &armlogic.EdifactEnvelopeSettings{
		// 									ApplicationReferenceID: to.Ptr("0"),
		// 									ApplyDelimiterStringAdvice: to.Ptr(true),
		// 									CommunicationAgreementID: to.Ptr("0"),
		// 									CreateGroupingSegments: to.Ptr(true),
		// 									EnableDefaultGroupHeaders: to.Ptr(true),
		// 									FunctionalGroupID: to.Ptr("0"),
		// 									GroupApplicationPassword: to.Ptr("0"),
		// 									GroupApplicationReceiverID: to.Ptr("0"),
		// 									GroupApplicationReceiverQualifier: to.Ptr("ZZZ"),
		// 									GroupApplicationSenderID: to.Ptr("AAA"),
		// 									GroupApplicationSenderQualifier: to.Ptr("ZZZ"),
		// 									GroupAssociationAssignedCode: to.Ptr("0"),
		// 									GroupControlNumberLowerBound: to.Ptr[int64](1),
		// 									GroupControlNumberPrefix: to.Ptr("CU"),
		// 									GroupControlNumberSuffix: to.Ptr("NUM"),
		// 									GroupControlNumberUpperBound: to.Ptr[int64](99999999),
		// 									GroupControllingAgencyCode: to.Ptr("0"),
		// 									GroupMessageRelease: to.Ptr("0.0"),
		// 									GroupMessageVersion: to.Ptr("0.0"),
		// 									InterchangeControlNumberLowerBound: to.Ptr[int64](1),
		// 									InterchangeControlNumberPrefix: to.Ptr("CU"),
		// 									InterchangeControlNumberSuffix: to.Ptr("NUM"),
		// 									InterchangeControlNumberUpperBound: to.Ptr[int64](99999999),
		// 									IsTestInterchange: to.Ptr(true),
		// 									OverwriteExistingTransactionSetControlNumber: to.Ptr(true),
		// 									ProcessingPriorityCode: to.Ptr("0"),
		// 									ReceiverInternalIdentification: to.Ptr("0"),
		// 									ReceiverInternalSubIdentification: to.Ptr("0"),
		// 									RecipientReferencePasswordQualifier: to.Ptr("ZZ"),
		// 									RecipientReferencePasswordValue: to.Ptr("AA"),
		// 									RolloverGroupControlNumber: to.Ptr(true),
		// 									RolloverInterchangeControlNumber: to.Ptr(true),
		// 									RolloverTransactionSetControlNumber: to.Ptr(true),
		// 									SenderInternalIdentification: to.Ptr("AA"),
		// 									SenderInternalSubIdentification: to.Ptr("AA"),
		// 									TransactionSetControlNumberLowerBound: to.Ptr[int64](1),
		// 									TransactionSetControlNumberPrefix: to.Ptr(""),
		// 									TransactionSetControlNumberSuffix: to.Ptr(""),
		// 									TransactionSetControlNumberUpperBound: to.Ptr[int64](99999999),
		// 								},
		// 								FramingSettings: &armlogic.EdifactFramingSettings{
		// 									CharacterEncoding: to.Ptr("UTF"),
		// 									CharacterSet: to.Ptr(armlogic.EdifactCharacterSetUNOC),
		// 									ComponentSeparator: to.Ptr[int32](58),
		// 									DataElementSeparator: to.Ptr[int32](53),
		// 									DecimalPointIndicator: to.Ptr(armlogic.EdifactDecimalIndicatorComma),
		// 									ProtocolVersion: to.Ptr[int32](4),
		// 									ReleaseIndicator: to.Ptr[int32](63),
		// 									RepetitionSeparator: to.Ptr[int32](42),
		// 									SegmentTerminator: to.Ptr[int32](39),
		// 									SegmentTerminatorSuffix: to.Ptr(armlogic.SegmentTerminatorSuffixNone),
		// 								},
		// 								MessageFilter: &armlogic.EdifactMessageFilter{
		// 									MessageFilterType: to.Ptr(armlogic.MessageFilterTypeExclude),
		// 								},
		// 								ProcessingSettings: &armlogic.EdifactProcessingSettings{
		// 									CreateEmptyXMLTagsForTrailingSeparators: to.Ptr(true),
		// 									MaskSecurityInfo: to.Ptr(true),
		// 									PreserveInterchange: to.Ptr(true),
		// 									SuspendInterchangeOnError: to.Ptr(true),
		// 									UseDotAsDecimalSeparator: to.Ptr(true),
		// 								},
		// 								SchemaReferences: []*armlogic.EdifactSchemaReference{
		// 								},
		// 								ValidationSettings: &armlogic.EdifactValidationSettings{
		// 									AllowLeadingAndTrailingSpacesAndZeroes: to.Ptr(true),
		// 									CheckDuplicateGroupControlNumber: to.Ptr(true),
		// 									CheckDuplicateInterchangeControlNumber: to.Ptr(true),
		// 									CheckDuplicateTransactionSetControlNumber: to.Ptr(true),
		// 									InterchangeControlNumberValidityDays: to.Ptr[int32](30),
		// 									TrailingSeparatorPolicy: to.Ptr(armlogic.TrailingSeparatorPolicyOptional),
		// 									TrimLeadingAndTrailingSpacesAndZeroes: to.Ptr(true),
		// 									ValidateCharacterSet: to.Ptr(true),
		// 									ValidateEDITypes: to.Ptr(true),
		// 									ValidateXSDTypes: to.Ptr(true),
		// 								},
		// 							},
		// 							ReceiverBusinessIdentity: &armlogic.BusinessIdentity{
		// 								Qualifier: to.Ptr("ZZ"),
		// 								Value: to.Ptr("ZZ"),
		// 							},
		// 							SenderBusinessIdentity: &armlogic.BusinessIdentity{
		// 								Qualifier: to.Ptr("AA"),
		// 								Value: to.Ptr("AA"),
		// 							},
		// 						},
		// 						SendAgreement: &armlogic.EdifactOneWayAgreement{
		// 							ProtocolSettings: &armlogic.EdifactProtocolSettings{
		// 								AcknowledgementSettings: &armlogic.EdifactAcknowledgementSettings{
		// 									AcknowledgementControlNumberLowerBound: to.Ptr[int32](1),
		// 									AcknowledgementControlNumberPrefix: to.Ptr("CN"),
		// 									AcknowledgementControlNumberSuffix: to.Ptr("NUM"),
		// 									AcknowledgementControlNumberUpperBound: to.Ptr[int32](999999999),
		// 									BatchFunctionalAcknowledgements: to.Ptr(true),
		// 									BatchTechnicalAcknowledgements: to.Ptr(true),
		// 									NeedFunctionalAcknowledgement: to.Ptr(true),
		// 									NeedLoopForValidMessages: to.Ptr(true),
		// 									NeedTechnicalAcknowledgement: to.Ptr(true),
		// 									RolloverAcknowledgementControlNumber: to.Ptr(true),
		// 									SendSynchronousAcknowledgement: to.Ptr(true),
		// 								},
		// 								EnvelopeSettings: &armlogic.EdifactEnvelopeSettings{
		// 									ApplicationReferenceID: to.Ptr("0"),
		// 									ApplyDelimiterStringAdvice: to.Ptr(true),
		// 									CommunicationAgreementID: to.Ptr("0"),
		// 									CreateGroupingSegments: to.Ptr(true),
		// 									EnableDefaultGroupHeaders: to.Ptr(true),
		// 									FunctionalGroupID: to.Ptr("0"),
		// 									GroupApplicationPassword: to.Ptr("0"),
		// 									GroupApplicationReceiverID: to.Ptr("0"),
		// 									GroupApplicationReceiverQualifier: to.Ptr("ZZ"),
		// 									GroupApplicationSenderID: to.Ptr("AA"),
		// 									GroupApplicationSenderQualifier: to.Ptr("ZZ"),
		// 									GroupAssociationAssignedCode: to.Ptr("0"),
		// 									GroupControlNumberLowerBound: to.Ptr[int64](1),
		// 									GroupControlNumberPrefix: to.Ptr(""),
		// 									GroupControlNumberSuffix: to.Ptr(""),
		// 									GroupControlNumberUpperBound: to.Ptr[int64](999999999),
		// 									GroupControllingAgencyCode: to.Ptr("0"),
		// 									GroupMessageRelease: to.Ptr("0.0"),
		// 									GroupMessageVersion: to.Ptr("0.0"),
		// 									InterchangeControlNumberLowerBound: to.Ptr[int64](1),
		// 									InterchangeControlNumberPrefix: to.Ptr("CU"),
		// 									InterchangeControlNumberSuffix: to.Ptr("NUM"),
		// 									InterchangeControlNumberUpperBound: to.Ptr[int64](999999999),
		// 									IsTestInterchange: to.Ptr(true),
		// 									OverwriteExistingTransactionSetControlNumber: to.Ptr(true),
		// 									ProcessingPriorityCode: to.Ptr("0"),
		// 									ReceiverInternalIdentification: to.Ptr("0"),
		// 									ReceiverInternalSubIdentification: to.Ptr("0"),
		// 									RecipientReferencePasswordQualifier: to.Ptr("ZZ"),
		// 									RecipientReferencePasswordValue: to.Ptr("AA"),
		// 									RolloverGroupControlNumber: to.Ptr(true),
		// 									RolloverInterchangeControlNumber: to.Ptr(true),
		// 									RolloverTransactionSetControlNumber: to.Ptr(true),
		// 									SenderInternalIdentification: to.Ptr("AA"),
		// 									SenderInternalSubIdentification: to.Ptr("AA"),
		// 									TransactionSetControlNumberLowerBound: to.Ptr[int64](1),
		// 									TransactionSetControlNumberPrefix: to.Ptr(""),
		// 									TransactionSetControlNumberSuffix: to.Ptr(""),
		// 									TransactionSetControlNumberUpperBound: to.Ptr[int64](999999999),
		// 								},
		// 								FramingSettings: &armlogic.EdifactFramingSettings{
		// 									CharacterEncoding: to.Ptr("UTF"),
		// 									CharacterSet: to.Ptr(armlogic.EdifactCharacterSetUNOC),
		// 									ComponentSeparator: to.Ptr[int32](58),
		// 									DataElementSeparator: to.Ptr[int32](53),
		// 									DecimalPointIndicator: to.Ptr(armlogic.EdifactDecimalIndicatorComma),
		// 									ProtocolVersion: to.Ptr[int32](4),
		// 									ReleaseIndicator: to.Ptr[int32](63),
		// 									RepetitionSeparator: to.Ptr[int32](42),
		// 									SegmentTerminator: to.Ptr[int32](39),
		// 									SegmentTerminatorSuffix: to.Ptr(armlogic.SegmentTerminatorSuffixNone),
		// 								},
		// 								MessageFilter: &armlogic.EdifactMessageFilter{
		// 									MessageFilterType: to.Ptr(armlogic.MessageFilterTypeExclude),
		// 								},
		// 								ProcessingSettings: &armlogic.EdifactProcessingSettings{
		// 									CreateEmptyXMLTagsForTrailingSeparators: to.Ptr(true),
		// 									MaskSecurityInfo: to.Ptr(true),
		// 									PreserveInterchange: to.Ptr(true),
		// 									SuspendInterchangeOnError: to.Ptr(true),
		// 									UseDotAsDecimalSeparator: to.Ptr(true),
		// 								},
		// 								SchemaReferences: []*armlogic.EdifactSchemaReference{
		// 								},
		// 								ValidationSettings: &armlogic.EdifactValidationSettings{
		// 									AllowLeadingAndTrailingSpacesAndZeroes: to.Ptr(true),
		// 									CheckDuplicateGroupControlNumber: to.Ptr(true),
		// 									CheckDuplicateInterchangeControlNumber: to.Ptr(true),
		// 									CheckDuplicateTransactionSetControlNumber: to.Ptr(true),
		// 									InterchangeControlNumberValidityDays: to.Ptr[int32](30),
		// 									TrailingSeparatorPolicy: to.Ptr(armlogic.TrailingSeparatorPolicyOptional),
		// 									TrimLeadingAndTrailingSpacesAndZeroes: to.Ptr(true),
		// 									ValidateCharacterSet: to.Ptr(true),
		// 									ValidateEDITypes: to.Ptr(true),
		// 									ValidateXSDTypes: to.Ptr(true),
		// 								},
		// 							},
		// 							ReceiverBusinessIdentity: &armlogic.BusinessIdentity{
		// 								Qualifier: to.Ptr("ZZ"),
		// 								Value: to.Ptr("ZZ"),
		// 							},
		// 							SenderBusinessIdentity: &armlogic.BusinessIdentity{
		// 								Qualifier: to.Ptr("AA"),
		// 								Value: to.Ptr("AA"),
		// 							},
		// 						},
		// 					},
		// 				},
		// 				CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-06T22:00:53.820Z"); return t}()),
		// 				GuestIdentity: &armlogic.BusinessIdentity{
		// 					Qualifier: to.Ptr("AA"),
		// 					Value: to.Ptr("AA"),
		// 				},
		// 				GuestPartner: to.Ptr("GuestPartner"),
		// 				HostIdentity: &armlogic.BusinessIdentity{
		// 					Qualifier: to.Ptr("ZZ"),
		// 					Value: to.Ptr("ZZ"),
		// 				},
		// 				HostPartner: to.Ptr("HostPartner"),
		// 				Metadata: map[string]any{
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccountAgreements_Get.json
func ExampleIntegrationAccountAgreementsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIntegrationAccountAgreementsClient().Get(ctx, "testResourceGroup", "testIntegrationAccount", "testAgreement", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.IntegrationAccountAgreement = armlogic.IntegrationAccountAgreement{
	// 	Name: to.Ptr("<IntegrationAccountAgreementName>"),
	// 	Type: to.Ptr("Microsoft.Logic/integrationAccounts/agreements"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testResourceGroup/providers/Microsoft.Logic/integrationAccounts/<IntegrationAccountName>/agreements/<IntegrationAccountAgreementName>"),
	// 	Properties: &armlogic.IntegrationAccountAgreementProperties{
	// 		AgreementType: to.Ptr(armlogic.AgreementTypeAS2),
	// 		ChangedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-06T22:32:54.294Z"); return t}()),
	// 		Content: &armlogic.AgreementContent{
	// 			AS2: &armlogic.AS2AgreementContent{
	// 				ReceiveAgreement: &armlogic.AS2OneWayAgreement{
	// 					ProtocolSettings: &armlogic.AS2ProtocolSettings{
	// 						AcknowledgementConnectionSettings: &armlogic.AS2AcknowledgementConnectionSettings{
	// 							IgnoreCertificateNameMismatch: to.Ptr(true),
	// 							KeepHTTPConnectionAlive: to.Ptr(true),
	// 							SupportHTTPStatusCodeContinue: to.Ptr(true),
	// 							UnfoldHTTPHeaders: to.Ptr(true),
	// 						},
	// 						EnvelopeSettings: &armlogic.AS2EnvelopeSettings{
	// 							AutogenerateFileName: to.Ptr(true),
	// 							FileNameTemplate: to.Ptr("Test"),
	// 							MessageContentType: to.Ptr("text/plain"),
	// 							SuspendMessageOnFileNameGenerationError: to.Ptr(true),
	// 							TransmitFileNameInMimeHeader: to.Ptr(true),
	// 						},
	// 						ErrorSettings: &armlogic.AS2ErrorSettings{
	// 							ResendIfMDNNotReceived: to.Ptr(true),
	// 							SuspendDuplicateMessage: to.Ptr(true),
	// 						},
	// 						MdnSettings: &armlogic.AS2MdnSettings{
	// 							DispositionNotificationTo: to.Ptr("http://tempuri.org"),
	// 							MdnText: to.Ptr("Sample"),
	// 							MicHashingAlgorithm: to.Ptr(armlogic.HashingAlgorithmSHA1),
	// 							NeedMDN: to.Ptr(true),
	// 							ReceiptDeliveryURL: to.Ptr("http://tempuri.org"),
	// 							SendInboundMDNToMessageBox: to.Ptr(true),
	// 							SendMDNAsynchronously: to.Ptr(true),
	// 							SignMDN: to.Ptr(true),
	// 							SignOutboundMDNIfOptional: to.Ptr(true),
	// 						},
	// 						MessageConnectionSettings: &armlogic.AS2MessageConnectionSettings{
	// 							IgnoreCertificateNameMismatch: to.Ptr(true),
	// 							KeepHTTPConnectionAlive: to.Ptr(true),
	// 							SupportHTTPStatusCodeContinue: to.Ptr(true),
	// 							UnfoldHTTPHeaders: to.Ptr(true),
	// 						},
	// 						SecuritySettings: &armlogic.AS2SecuritySettings{
	// 							EnableNRRForInboundDecodedMessages: to.Ptr(true),
	// 							EnableNRRForInboundEncodedMessages: to.Ptr(true),
	// 							EnableNRRForInboundMDN: to.Ptr(true),
	// 							EnableNRRForOutboundDecodedMessages: to.Ptr(true),
	// 							EnableNRRForOutboundEncodedMessages: to.Ptr(true),
	// 							EnableNRRForOutboundMDN: to.Ptr(true),
	// 							OverrideGroupSigningCertificate: to.Ptr(false),
	// 						},
	// 						ValidationSettings: &armlogic.AS2ValidationSettings{
	// 							CheckCertificateRevocationListOnReceive: to.Ptr(true),
	// 							CheckCertificateRevocationListOnSend: to.Ptr(true),
	// 							CheckDuplicateMessage: to.Ptr(true),
	// 							CompressMessage: to.Ptr(true),
	// 							EncryptMessage: to.Ptr(false),
	// 							EncryptionAlgorithm: to.Ptr(armlogic.EncryptionAlgorithmAES128),
	// 							InterchangeDuplicatesValidityDays: to.Ptr[int32](100),
	// 							OverrideMessageProperties: to.Ptr(true),
	// 							SignMessage: to.Ptr(false),
	// 						},
	// 					},
	// 					ReceiverBusinessIdentity: &armlogic.BusinessIdentity{
	// 						Qualifier: to.Ptr("ZZ"),
	// 						Value: to.Ptr("ZZ"),
	// 					},
	// 					SenderBusinessIdentity: &armlogic.BusinessIdentity{
	// 						Qualifier: to.Ptr("AA"),
	// 						Value: to.Ptr("AA"),
	// 					},
	// 				},
	// 				SendAgreement: &armlogic.AS2OneWayAgreement{
	// 					ProtocolSettings: &armlogic.AS2ProtocolSettings{
	// 						AcknowledgementConnectionSettings: &armlogic.AS2AcknowledgementConnectionSettings{
	// 							IgnoreCertificateNameMismatch: to.Ptr(true),
	// 							KeepHTTPConnectionAlive: to.Ptr(true),
	// 							SupportHTTPStatusCodeContinue: to.Ptr(true),
	// 							UnfoldHTTPHeaders: to.Ptr(true),
	// 						},
	// 						EnvelopeSettings: &armlogic.AS2EnvelopeSettings{
	// 							AutogenerateFileName: to.Ptr(true),
	// 							FileNameTemplate: to.Ptr("Test"),
	// 							MessageContentType: to.Ptr("text/plain"),
	// 							SuspendMessageOnFileNameGenerationError: to.Ptr(true),
	// 							TransmitFileNameInMimeHeader: to.Ptr(true),
	// 						},
	// 						ErrorSettings: &armlogic.AS2ErrorSettings{
	// 							ResendIfMDNNotReceived: to.Ptr(true),
	// 							SuspendDuplicateMessage: to.Ptr(true),
	// 						},
	// 						MdnSettings: &armlogic.AS2MdnSettings{
	// 							DispositionNotificationTo: to.Ptr("http://tempuri.org"),
	// 							MdnText: to.Ptr("Sample"),
	// 							MicHashingAlgorithm: to.Ptr(armlogic.HashingAlgorithmSHA1),
	// 							NeedMDN: to.Ptr(true),
	// 							ReceiptDeliveryURL: to.Ptr("http://tempuri.org"),
	// 							SendInboundMDNToMessageBox: to.Ptr(true),
	// 							SendMDNAsynchronously: to.Ptr(true),
	// 							SignMDN: to.Ptr(true),
	// 							SignOutboundMDNIfOptional: to.Ptr(true),
	// 						},
	// 						MessageConnectionSettings: &armlogic.AS2MessageConnectionSettings{
	// 							IgnoreCertificateNameMismatch: to.Ptr(true),
	// 							KeepHTTPConnectionAlive: to.Ptr(true),
	// 							SupportHTTPStatusCodeContinue: to.Ptr(true),
	// 							UnfoldHTTPHeaders: to.Ptr(true),
	// 						},
	// 						SecuritySettings: &armlogic.AS2SecuritySettings{
	// 							EnableNRRForInboundDecodedMessages: to.Ptr(true),
	// 							EnableNRRForInboundEncodedMessages: to.Ptr(true),
	// 							EnableNRRForInboundMDN: to.Ptr(true),
	// 							EnableNRRForOutboundDecodedMessages: to.Ptr(true),
	// 							EnableNRRForOutboundEncodedMessages: to.Ptr(true),
	// 							EnableNRRForOutboundMDN: to.Ptr(true),
	// 							OverrideGroupSigningCertificate: to.Ptr(false),
	// 						},
	// 						ValidationSettings: &armlogic.AS2ValidationSettings{
	// 							CheckCertificateRevocationListOnReceive: to.Ptr(true),
	// 							CheckCertificateRevocationListOnSend: to.Ptr(true),
	// 							CheckDuplicateMessage: to.Ptr(true),
	// 							CompressMessage: to.Ptr(true),
	// 							EncryptMessage: to.Ptr(false),
	// 							EncryptionAlgorithm: to.Ptr(armlogic.EncryptionAlgorithmAES128),
	// 							InterchangeDuplicatesValidityDays: to.Ptr[int32](100),
	// 							OverrideMessageProperties: to.Ptr(true),
	// 							SignMessage: to.Ptr(false),
	// 						},
	// 					},
	// 					ReceiverBusinessIdentity: &armlogic.BusinessIdentity{
	// 						Qualifier: to.Ptr("AA"),
	// 						Value: to.Ptr("AA"),
	// 					},
	// 					SenderBusinessIdentity: &armlogic.BusinessIdentity{
	// 						Qualifier: to.Ptr("ZZ"),
	// 						Value: to.Ptr("ZZ"),
	// 					},
	// 				},
	// 			},
	// 		},
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-06T22:32:54.293Z"); return t}()),
	// 		GuestIdentity: &armlogic.BusinessIdentity{
	// 			Qualifier: to.Ptr("AA"),
	// 			Value: to.Ptr("AA"),
	// 		},
	// 		GuestPartner: to.Ptr("GuestPartner"),
	// 		HostIdentity: &armlogic.BusinessIdentity{
	// 			Qualifier: to.Ptr("ZZ"),
	// 			Value: to.Ptr("ZZ"),
	// 		},
	// 		HostPartner: to.Ptr("HostPartner"),
	// 		Metadata: map[string]any{
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccountAgreements_CreateOrUpdate.json
func ExampleIntegrationAccountAgreementsClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIntegrationAccountAgreementsClient().CreateOrUpdate(ctx, "testResourceGroup", "testIntegrationAccount", "testAgreement", armlogic.IntegrationAccountAgreement{
		Location: to.Ptr("westus"),
		Tags: map[string]*string{
			"IntegrationAccountAgreement": to.Ptr("<IntegrationAccountAgreementName>"),
		},
		Properties: &armlogic.IntegrationAccountAgreementProperties{
			AgreementType: to.Ptr(armlogic.AgreementTypeAS2),
			Content: &armlogic.AgreementContent{
				AS2: &armlogic.AS2AgreementContent{
					ReceiveAgreement: &armlogic.AS2OneWayAgreement{
						ProtocolSettings: &armlogic.AS2ProtocolSettings{
							AcknowledgementConnectionSettings: &armlogic.AS2AcknowledgementConnectionSettings{
								IgnoreCertificateNameMismatch: to.Ptr(true),
								KeepHTTPConnectionAlive:       to.Ptr(true),
								SupportHTTPStatusCodeContinue: to.Ptr(true),
								UnfoldHTTPHeaders:             to.Ptr(true),
							},
							EnvelopeSettings: &armlogic.AS2EnvelopeSettings{
								AutogenerateFileName:                    to.Ptr(true),
								FileNameTemplate:                        to.Ptr("Test"),
								MessageContentType:                      to.Ptr("text/plain"),
								SuspendMessageOnFileNameGenerationError: to.Ptr(true),
								TransmitFileNameInMimeHeader:            to.Ptr(true),
							},
							ErrorSettings: &armlogic.AS2ErrorSettings{
								ResendIfMDNNotReceived:  to.Ptr(true),
								SuspendDuplicateMessage: to.Ptr(true),
							},
							MdnSettings: &armlogic.AS2MdnSettings{
								DispositionNotificationTo:  to.Ptr("http://tempuri.org"),
								MdnText:                    to.Ptr("Sample"),
								MicHashingAlgorithm:        to.Ptr(armlogic.HashingAlgorithmSHA1),
								NeedMDN:                    to.Ptr(true),
								ReceiptDeliveryURL:         to.Ptr("http://tempuri.org"),
								SendInboundMDNToMessageBox: to.Ptr(true),
								SendMDNAsynchronously:      to.Ptr(true),
								SignMDN:                    to.Ptr(true),
								SignOutboundMDNIfOptional:  to.Ptr(true),
							},
							MessageConnectionSettings: &armlogic.AS2MessageConnectionSettings{
								IgnoreCertificateNameMismatch: to.Ptr(true),
								KeepHTTPConnectionAlive:       to.Ptr(true),
								SupportHTTPStatusCodeContinue: to.Ptr(true),
								UnfoldHTTPHeaders:             to.Ptr(true),
							},
							SecuritySettings: &armlogic.AS2SecuritySettings{
								EnableNRRForInboundDecodedMessages:  to.Ptr(true),
								EnableNRRForInboundEncodedMessages:  to.Ptr(true),
								EnableNRRForInboundMDN:              to.Ptr(true),
								EnableNRRForOutboundDecodedMessages: to.Ptr(true),
								EnableNRRForOutboundEncodedMessages: to.Ptr(true),
								EnableNRRForOutboundMDN:             to.Ptr(true),
								OverrideGroupSigningCertificate:     to.Ptr(false),
							},
							ValidationSettings: &armlogic.AS2ValidationSettings{
								CheckCertificateRevocationListOnReceive: to.Ptr(true),
								CheckCertificateRevocationListOnSend:    to.Ptr(true),
								CheckDuplicateMessage:                   to.Ptr(true),
								CompressMessage:                         to.Ptr(true),
								EncryptMessage:                          to.Ptr(false),
								EncryptionAlgorithm:                     to.Ptr(armlogic.EncryptionAlgorithmAES128),
								InterchangeDuplicatesValidityDays:       to.Ptr[int32](100),
								OverrideMessageProperties:               to.Ptr(true),
								SignMessage:                             to.Ptr(false),
							},
						},
						ReceiverBusinessIdentity: &armlogic.BusinessIdentity{
							Qualifier: to.Ptr("ZZ"),
							Value:     to.Ptr("ZZ"),
						},
						SenderBusinessIdentity: &armlogic.BusinessIdentity{
							Qualifier: to.Ptr("AA"),
							Value:     to.Ptr("AA"),
						},
					},
					SendAgreement: &armlogic.AS2OneWayAgreement{
						ProtocolSettings: &armlogic.AS2ProtocolSettings{
							AcknowledgementConnectionSettings: &armlogic.AS2AcknowledgementConnectionSettings{
								IgnoreCertificateNameMismatch: to.Ptr(true),
								KeepHTTPConnectionAlive:       to.Ptr(true),
								SupportHTTPStatusCodeContinue: to.Ptr(true),
								UnfoldHTTPHeaders:             to.Ptr(true),
							},
							EnvelopeSettings: &armlogic.AS2EnvelopeSettings{
								AutogenerateFileName:                    to.Ptr(true),
								FileNameTemplate:                        to.Ptr("Test"),
								MessageContentType:                      to.Ptr("text/plain"),
								SuspendMessageOnFileNameGenerationError: to.Ptr(true),
								TransmitFileNameInMimeHeader:            to.Ptr(true),
							},
							ErrorSettings: &armlogic.AS2ErrorSettings{
								ResendIfMDNNotReceived:  to.Ptr(true),
								SuspendDuplicateMessage: to.Ptr(true),
							},
							MdnSettings: &armlogic.AS2MdnSettings{
								DispositionNotificationTo:  to.Ptr("http://tempuri.org"),
								MdnText:                    to.Ptr("Sample"),
								MicHashingAlgorithm:        to.Ptr(armlogic.HashingAlgorithmSHA1),
								NeedMDN:                    to.Ptr(true),
								ReceiptDeliveryURL:         to.Ptr("http://tempuri.org"),
								SendInboundMDNToMessageBox: to.Ptr(true),
								SendMDNAsynchronously:      to.Ptr(true),
								SignMDN:                    to.Ptr(true),
								SignOutboundMDNIfOptional:  to.Ptr(true),
							},
							MessageConnectionSettings: &armlogic.AS2MessageConnectionSettings{
								IgnoreCertificateNameMismatch: to.Ptr(true),
								KeepHTTPConnectionAlive:       to.Ptr(true),
								SupportHTTPStatusCodeContinue: to.Ptr(true),
								UnfoldHTTPHeaders:             to.Ptr(true),
							},
							SecuritySettings: &armlogic.AS2SecuritySettings{
								EnableNRRForInboundDecodedMessages:  to.Ptr(true),
								EnableNRRForInboundEncodedMessages:  to.Ptr(true),
								EnableNRRForInboundMDN:              to.Ptr(true),
								EnableNRRForOutboundDecodedMessages: to.Ptr(true),
								EnableNRRForOutboundEncodedMessages: to.Ptr(true),
								EnableNRRForOutboundMDN:             to.Ptr(true),
								OverrideGroupSigningCertificate:     to.Ptr(false),
							},
							ValidationSettings: &armlogic.AS2ValidationSettings{
								CheckCertificateRevocationListOnReceive: to.Ptr(true),
								CheckCertificateRevocationListOnSend:    to.Ptr(true),
								CheckDuplicateMessage:                   to.Ptr(true),
								CompressMessage:                         to.Ptr(true),
								EncryptMessage:                          to.Ptr(false),
								EncryptionAlgorithm:                     to.Ptr(armlogic.EncryptionAlgorithmAES128),
								InterchangeDuplicatesValidityDays:       to.Ptr[int32](100),
								OverrideMessageProperties:               to.Ptr(true),
								SignMessage:                             to.Ptr(false),
							},
						},
						ReceiverBusinessIdentity: &armlogic.BusinessIdentity{
							Qualifier: to.Ptr("AA"),
							Value:     to.Ptr("AA"),
						},
						SenderBusinessIdentity: &armlogic.BusinessIdentity{
							Qualifier: to.Ptr("ZZ"),
							Value:     to.Ptr("ZZ"),
						},
					},
				},
			},
			GuestIdentity: &armlogic.BusinessIdentity{
				Qualifier: to.Ptr("AA"),
				Value:     to.Ptr("AA"),
			},
			GuestPartner: to.Ptr("GuestPartner"),
			HostIdentity: &armlogic.BusinessIdentity{
				Qualifier: to.Ptr("ZZ"),
				Value:     to.Ptr("ZZ"),
			},
			HostPartner: to.Ptr("HostPartner"),
			Metadata:    map[string]any{},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.IntegrationAccountAgreement = armlogic.IntegrationAccountAgreement{
	// 	Name: to.Ptr("<IntegrationAccountAgreementName>"),
	// 	Type: to.Ptr("Microsoft.Logic/integrationAccounts/agreements"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testResourceGroup/providers/Microsoft.Logic/integrationAccounts/IntegrationAccount4533/agreements/<IntegrationAccountAgreementName>"),
	// 	Properties: &armlogic.IntegrationAccountAgreementProperties{
	// 		AgreementType: to.Ptr(armlogic.AgreementTypeAS2),
	// 		ChangedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-06T22:32:54.294Z"); return t}()),
	// 		Content: &armlogic.AgreementContent{
	// 			AS2: &armlogic.AS2AgreementContent{
	// 				ReceiveAgreement: &armlogic.AS2OneWayAgreement{
	// 					ProtocolSettings: &armlogic.AS2ProtocolSettings{
	// 						AcknowledgementConnectionSettings: &armlogic.AS2AcknowledgementConnectionSettings{
	// 							IgnoreCertificateNameMismatch: to.Ptr(true),
	// 							KeepHTTPConnectionAlive: to.Ptr(true),
	// 							SupportHTTPStatusCodeContinue: to.Ptr(true),
	// 							UnfoldHTTPHeaders: to.Ptr(true),
	// 						},
	// 						EnvelopeSettings: &armlogic.AS2EnvelopeSettings{
	// 							AutogenerateFileName: to.Ptr(true),
	// 							FileNameTemplate: to.Ptr("Test"),
	// 							MessageContentType: to.Ptr("text/plain"),
	// 							SuspendMessageOnFileNameGenerationError: to.Ptr(true),
	// 							TransmitFileNameInMimeHeader: to.Ptr(true),
	// 						},
	// 						ErrorSettings: &armlogic.AS2ErrorSettings{
	// 							ResendIfMDNNotReceived: to.Ptr(true),
	// 							SuspendDuplicateMessage: to.Ptr(true),
	// 						},
	// 						MdnSettings: &armlogic.AS2MdnSettings{
	// 							DispositionNotificationTo: to.Ptr("http://tempuri.org"),
	// 							MdnText: to.Ptr("Sample"),
	// 							MicHashingAlgorithm: to.Ptr(armlogic.HashingAlgorithmSHA1),
	// 							NeedMDN: to.Ptr(true),
	// 							ReceiptDeliveryURL: to.Ptr("http://tempuri.org"),
	// 							SendInboundMDNToMessageBox: to.Ptr(true),
	// 							SendMDNAsynchronously: to.Ptr(true),
	// 							SignMDN: to.Ptr(true),
	// 							SignOutboundMDNIfOptional: to.Ptr(true),
	// 						},
	// 						MessageConnectionSettings: &armlogic.AS2MessageConnectionSettings{
	// 							IgnoreCertificateNameMismatch: to.Ptr(true),
	// 							KeepHTTPConnectionAlive: to.Ptr(true),
	// 							SupportHTTPStatusCodeContinue: to.Ptr(true),
	// 							UnfoldHTTPHeaders: to.Ptr(true),
	// 						},
	// 						SecuritySettings: &armlogic.AS2SecuritySettings{
	// 							EnableNRRForInboundDecodedMessages: to.Ptr(true),
	// 							EnableNRRForInboundEncodedMessages: to.Ptr(true),
	// 							EnableNRRForInboundMDN: to.Ptr(true),
	// 							EnableNRRForOutboundDecodedMessages: to.Ptr(true),
	// 							EnableNRRForOutboundEncodedMessages: to.Ptr(true),
	// 							EnableNRRForOutboundMDN: to.Ptr(true),
	// 							OverrideGroupSigningCertificate: to.Ptr(false),
	// 						},
	// 						ValidationSettings: &armlogic.AS2ValidationSettings{
	// 							CheckCertificateRevocationListOnReceive: to.Ptr(true),
	// 							CheckCertificateRevocationListOnSend: to.Ptr(true),
	// 							CheckDuplicateMessage: to.Ptr(true),
	// 							CompressMessage: to.Ptr(true),
	// 							EncryptMessage: to.Ptr(false),
	// 							EncryptionAlgorithm: to.Ptr(armlogic.EncryptionAlgorithmAES128),
	// 							InterchangeDuplicatesValidityDays: to.Ptr[int32](100),
	// 							OverrideMessageProperties: to.Ptr(true),
	// 							SignMessage: to.Ptr(false),
	// 						},
	// 					},
	// 					ReceiverBusinessIdentity: &armlogic.BusinessIdentity{
	// 						Qualifier: to.Ptr("ZZ"),
	// 						Value: to.Ptr("ZZ"),
	// 					},
	// 					SenderBusinessIdentity: &armlogic.BusinessIdentity{
	// 						Qualifier: to.Ptr("AA"),
	// 						Value: to.Ptr("AA"),
	// 					},
	// 				},
	// 				SendAgreement: &armlogic.AS2OneWayAgreement{
	// 					ProtocolSettings: &armlogic.AS2ProtocolSettings{
	// 						AcknowledgementConnectionSettings: &armlogic.AS2AcknowledgementConnectionSettings{
	// 							IgnoreCertificateNameMismatch: to.Ptr(true),
	// 							KeepHTTPConnectionAlive: to.Ptr(true),
	// 							SupportHTTPStatusCodeContinue: to.Ptr(true),
	// 							UnfoldHTTPHeaders: to.Ptr(true),
	// 						},
	// 						EnvelopeSettings: &armlogic.AS2EnvelopeSettings{
	// 							AutogenerateFileName: to.Ptr(true),
	// 							FileNameTemplate: to.Ptr("Test"),
	// 							MessageContentType: to.Ptr("text/plain"),
	// 							SuspendMessageOnFileNameGenerationError: to.Ptr(true),
	// 							TransmitFileNameInMimeHeader: to.Ptr(true),
	// 						},
	// 						ErrorSettings: &armlogic.AS2ErrorSettings{
	// 							ResendIfMDNNotReceived: to.Ptr(true),
	// 							SuspendDuplicateMessage: to.Ptr(true),
	// 						},
	// 						MdnSettings: &armlogic.AS2MdnSettings{
	// 							DispositionNotificationTo: to.Ptr("http://tempuri.org"),
	// 							MdnText: to.Ptr("Sample"),
	// 							MicHashingAlgorithm: to.Ptr(armlogic.HashingAlgorithmSHA1),
	// 							NeedMDN: to.Ptr(true),
	// 							ReceiptDeliveryURL: to.Ptr("http://tempuri.org"),
	// 							SendInboundMDNToMessageBox: to.Ptr(true),
	// 							SendMDNAsynchronously: to.Ptr(true),
	// 							SignMDN: to.Ptr(true),
	// 							SignOutboundMDNIfOptional: to.Ptr(true),
	// 						},
	// 						MessageConnectionSettings: &armlogic.AS2MessageConnectionSettings{
	// 							IgnoreCertificateNameMismatch: to.Ptr(true),
	// 							KeepHTTPConnectionAlive: to.Ptr(true),
	// 							SupportHTTPStatusCodeContinue: to.Ptr(true),
	// 							UnfoldHTTPHeaders: to.Ptr(true),
	// 						},
	// 						SecuritySettings: &armlogic.AS2SecuritySettings{
	// 							EnableNRRForInboundDecodedMessages: to.Ptr(true),
	// 							EnableNRRForInboundEncodedMessages: to.Ptr(true),
	// 							EnableNRRForInboundMDN: to.Ptr(true),
	// 							EnableNRRForOutboundDecodedMessages: to.Ptr(true),
	// 							EnableNRRForOutboundEncodedMessages: to.Ptr(true),
	// 							EnableNRRForOutboundMDN: to.Ptr(true),
	// 							OverrideGroupSigningCertificate: to.Ptr(false),
	// 						},
	// 						ValidationSettings: &armlogic.AS2ValidationSettings{
	// 							CheckCertificateRevocationListOnReceive: to.Ptr(true),
	// 							CheckCertificateRevocationListOnSend: to.Ptr(true),
	// 							CheckDuplicateMessage: to.Ptr(true),
	// 							CompressMessage: to.Ptr(true),
	// 							EncryptMessage: to.Ptr(false),
	// 							EncryptionAlgorithm: to.Ptr(armlogic.EncryptionAlgorithmAES128),
	// 							InterchangeDuplicatesValidityDays: to.Ptr[int32](100),
	// 							OverrideMessageProperties: to.Ptr(true),
	// 							SignMessage: to.Ptr(false),
	// 						},
	// 					},
	// 					ReceiverBusinessIdentity: &armlogic.BusinessIdentity{
	// 						Qualifier: to.Ptr("AA"),
	// 						Value: to.Ptr("AA"),
	// 					},
	// 					SenderBusinessIdentity: &armlogic.BusinessIdentity{
	// 						Qualifier: to.Ptr("ZZ"),
	// 						Value: to.Ptr("ZZ"),
	// 					},
	// 				},
	// 			},
	// 		},
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-06T22:32:54.293Z"); return t}()),
	// 		GuestIdentity: &armlogic.BusinessIdentity{
	// 			Qualifier: to.Ptr("AA"),
	// 			Value: to.Ptr("AA"),
	// 		},
	// 		GuestPartner: to.Ptr("GuestPartner"),
	// 		HostIdentity: &armlogic.BusinessIdentity{
	// 			Qualifier: to.Ptr("ZZ"),
	// 			Value: to.Ptr("ZZ"),
	// 		},
	// 		HostPartner: to.Ptr("HostPartner"),
	// 		Metadata: map[string]any{
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccountAgreements_Delete.json
func ExampleIntegrationAccountAgreementsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewIntegrationAccountAgreementsClient().Delete(ctx, "testResourceGroup", "testIntegrationAccount", "testAgreement", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccountAgreements_ListContentCallbackUrl.json
func ExampleIntegrationAccountAgreementsClient_ListContentCallbackURL() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIntegrationAccountAgreementsClient().ListContentCallbackURL(ctx, "testResourceGroup", "testIntegrationAccount", "testAgreement", armlogic.GetCallbackURLParameters{
		KeyType:  to.Ptr(armlogic.KeyTypePrimary),
		NotAfter: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-04-19T16:00:00.000Z"); return t }()),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.WorkflowTriggerCallbackURL = armlogic.WorkflowTriggerCallbackURL{
	// 	Method: to.Ptr("GET"),
	// 	BasePath: to.Ptr("https://prod-00.westus.logic.azure.com/integrationAccounts/0fdabc3a76514ca48dede71c73d9fe97/agreements/testAgreement/contents/Value"),
	// 	Queries: &armlogic.WorkflowTriggerListCallbackURLQueries{
	// 		APIVersion: to.Ptr("2015-08-01-preview"),
	// 	},
	// 	Value: to.Ptr("https://prod-00.westus.logic.azure.com:443/integrationAccounts/0fdabc3a76514ca48dede71c73d9fe97/agreements/testAgreement/contents/Value?api-version=2015-08-01-preview&sp=%2Fagreements%2FtestAgreement%2Fread&sv=1.0&sig=VK_mbQPTHTa3ezhsrI8IctckwjlL3GdJmroQH_baYj4"),
	// }
}
