//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ManagedDatabaseRecommendedSensitivityLabelsServer is a fake server for instances of the armsql.ManagedDatabaseRecommendedSensitivityLabelsClient type.
type ManagedDatabaseRecommendedSensitivityLabelsServer struct {
	// Update is the fake for method ManagedDatabaseRecommendedSensitivityLabelsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, parameters armsql.RecommendedSensitivityLabelUpdateList, options *armsql.ManagedDatabaseRecommendedSensitivityLabelsClientUpdateOptions) (resp azfake.Responder[armsql.ManagedDatabaseRecommendedSensitivityLabelsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewManagedDatabaseRecommendedSensitivityLabelsServerTransport creates a new instance of ManagedDatabaseRecommendedSensitivityLabelsServerTransport with the provided implementation.
// The returned ManagedDatabaseRecommendedSensitivityLabelsServerTransport instance is connected to an instance of armsql.ManagedDatabaseRecommendedSensitivityLabelsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewManagedDatabaseRecommendedSensitivityLabelsServerTransport(srv *ManagedDatabaseRecommendedSensitivityLabelsServer) *ManagedDatabaseRecommendedSensitivityLabelsServerTransport {
	return &ManagedDatabaseRecommendedSensitivityLabelsServerTransport{srv: srv}
}

// ManagedDatabaseRecommendedSensitivityLabelsServerTransport connects instances of armsql.ManagedDatabaseRecommendedSensitivityLabelsClient to instances of ManagedDatabaseRecommendedSensitivityLabelsServer.
// Don't use this type directly, use NewManagedDatabaseRecommendedSensitivityLabelsServerTransport instead.
type ManagedDatabaseRecommendedSensitivityLabelsServerTransport struct {
	srv *ManagedDatabaseRecommendedSensitivityLabelsServer
}

// Do implements the policy.Transporter interface for ManagedDatabaseRecommendedSensitivityLabelsServerTransport.
func (m *ManagedDatabaseRecommendedSensitivityLabelsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ManagedDatabaseRecommendedSensitivityLabelsClient.Update":
		resp, err = m.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *ManagedDatabaseRecommendedSensitivityLabelsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if m.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recommendedSensitivityLabels`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsql.RecommendedSensitivityLabelUpdateList](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Update(req.Context(), resourceGroupNameParam, managedInstanceNameParam, databaseNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
