package documentdb

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// DataTransferJobsClient is the client for the DataTransferJobs methods of the Documentdb service.
type DataTransferJobsClient struct {
	BaseClient
}

// NewDataTransferJobsClient creates an instance of the DataTransferJobsClient client.
func NewDataTransferJobsClient(subscriptionID string) DataTransferJobsClient {
	return NewDataTransferJobsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewDataTransferJobsClientWithBaseURI creates an instance of the DataTransferJobsClient client using a custom
// endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure
// stack).
func NewDataTransferJobsClientWithBaseURI(baseURI string, subscriptionID string) DataTransferJobsClient {
	return DataTransferJobsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Create creates a Data Transfer Job.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// jobName - name of the Data Transfer Job
func (client DataTransferJobsClient) Create(ctx context.Context, resourceGroupName string, accountName string, jobName string, jobCreateParameters CreateJobRequest) (result DataTransferJobGetResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataTransferJobsClient.Create")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}},
		{TargetValue: jobCreateParameters,
			Constraints: []validation.Constraint{{Target: "jobCreateParameters.Properties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "jobCreateParameters.Properties.WorkerCount", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "jobCreateParameters.Properties.WorkerCount", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}},
				}}}}}); err != nil {
		return result, validation.NewError("documentdb.DataTransferJobsClient", "Create", err.Error())
	}

	req, err := client.CreatePreparer(ctx, resourceGroupName, accountName, jobName, jobCreateParameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DataTransferJobsClient", "Create", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.DataTransferJobsClient", "Create", resp, "Failure sending request")
		return
	}

	result, err = client.CreateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DataTransferJobsClient", "Create", resp, "Failure responding to request")
		return
	}

	return
}

// CreatePreparer prepares the Create request.
func (client DataTransferJobsClient) CreatePreparer(ctx context.Context, resourceGroupName string, accountName string, jobName string, jobCreateParameters CreateJobRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"jobName":           autorest.Encode("path", jobName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/dataTransferJobs/{jobName}", pathParameters),
		autorest.WithJSON(jobCreateParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client DataTransferJobsClient) CreateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client DataTransferJobsClient) CreateResponder(resp *http.Response) (result DataTransferJobGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get get a Data Transfer Job.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// jobName - name of the Data Transfer Job
func (client DataTransferJobsClient) Get(ctx context.Context, resourceGroupName string, accountName string, jobName string) (result DataTransferJobGetResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataTransferJobsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.DataTransferJobsClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, accountName, jobName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DataTransferJobsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.DataTransferJobsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DataTransferJobsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client DataTransferJobsClient) GetPreparer(ctx context.Context, resourceGroupName string, accountName string, jobName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"jobName":           autorest.Encode("path", jobName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/dataTransferJobs/{jobName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client DataTransferJobsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client DataTransferJobsClient) GetResponder(resp *http.Response) (result DataTransferJobGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByDatabaseAccount get a list of Data Transfer jobs.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
func (client DataTransferJobsClient) ListByDatabaseAccount(ctx context.Context, resourceGroupName string, accountName string) (result DataTransferJobFeedResultsPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataTransferJobsClient.ListByDatabaseAccount")
		defer func() {
			sc := -1
			if result.dtjfr.Response.Response != nil {
				sc = result.dtjfr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.DataTransferJobsClient", "ListByDatabaseAccount", err.Error())
	}

	result.fn = client.listByDatabaseAccountNextResults
	req, err := client.ListByDatabaseAccountPreparer(ctx, resourceGroupName, accountName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DataTransferJobsClient", "ListByDatabaseAccount", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByDatabaseAccountSender(req)
	if err != nil {
		result.dtjfr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.DataTransferJobsClient", "ListByDatabaseAccount", resp, "Failure sending request")
		return
	}

	result.dtjfr, err = client.ListByDatabaseAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DataTransferJobsClient", "ListByDatabaseAccount", resp, "Failure responding to request")
		return
	}
	if result.dtjfr.hasNextLink() && result.dtjfr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByDatabaseAccountPreparer prepares the ListByDatabaseAccount request.
func (client DataTransferJobsClient) ListByDatabaseAccountPreparer(ctx context.Context, resourceGroupName string, accountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/dataTransferJobs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByDatabaseAccountSender sends the ListByDatabaseAccount request. The method will close the
// http.Response Body if it receives an error.
func (client DataTransferJobsClient) ListByDatabaseAccountSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByDatabaseAccountResponder handles the response to the ListByDatabaseAccount request. The method always
// closes the http.Response Body.
func (client DataTransferJobsClient) ListByDatabaseAccountResponder(resp *http.Response) (result DataTransferJobFeedResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByDatabaseAccountNextResults retrieves the next set of results, if any.
func (client DataTransferJobsClient) listByDatabaseAccountNextResults(ctx context.Context, lastResults DataTransferJobFeedResults) (result DataTransferJobFeedResults, err error) {
	req, err := lastResults.dataTransferJobFeedResultsPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "documentdb.DataTransferJobsClient", "listByDatabaseAccountNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByDatabaseAccountSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "documentdb.DataTransferJobsClient", "listByDatabaseAccountNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByDatabaseAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DataTransferJobsClient", "listByDatabaseAccountNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByDatabaseAccountComplete enumerates all values, automatically crossing page boundaries as required.
func (client DataTransferJobsClient) ListByDatabaseAccountComplete(ctx context.Context, resourceGroupName string, accountName string) (result DataTransferJobFeedResultsIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DataTransferJobsClient.ListByDatabaseAccount")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByDatabaseAccount(ctx, resourceGroupName, accountName)
	return
}
