package sql

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/gofrs/uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/sql/mgmt/2014-04-01/sql"

// Advisor database Advisor.
type Advisor struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Resource kind.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// AdvisorProperties - Resource properties.
	*AdvisorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Advisor.
func (a Advisor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AdvisorProperties != nil {
		objectMap["properties"] = a.AdvisorProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Advisor struct.
func (a *Advisor) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				a.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "properties":
			if v != nil {
				var advisorProperties AdvisorProperties
				err = json.Unmarshal(*v, &advisorProperties)
				if err != nil {
					return err
				}
				a.AdvisorProperties = &advisorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// AdvisorListResult represents the response to a list advisors request.
type AdvisorListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of advisors.
	Value *[]Advisor `json:"value,omitempty"`
}

// AdvisorProperties properties for a Database, Server or Elastic Pool Advisor.
type AdvisorProperties struct {
	// AdvisorStatus - READ-ONLY; Gets the status of availability of this advisor to customers. Possible values are 'GA', 'PublicPreview', 'LimitedPublicPreview' and 'PrivatePreview'. Possible values include: 'GA', 'PublicPreview', 'LimitedPublicPreview', 'PrivatePreview'
	AdvisorStatus AdvisorStatus `json:"advisorStatus,omitempty"`
	// AutoExecuteValue - Gets the auto-execute status (whether to let the system execute the recommendations) of this advisor. Possible values are 'Enabled' and 'Disabled'. Possible values include: 'Enabled', 'Disabled', 'Default'
	AutoExecuteValue AutoExecuteStatus `json:"autoExecuteValue,omitempty"`
	// RecommendationsStatus - READ-ONLY; Gets that status of recommendations for this advisor and reason for not having any recommendations. Possible values include, but are not limited to, 'Ok' (Recommendations available), LowActivity (not enough workload to analyze), 'DbSeemsTuned' (Database is doing well), etc.
	RecommendationsStatus *string `json:"recommendationsStatus,omitempty"`
	// LastChecked - READ-ONLY; Gets the time when the current resource was analyzed for recommendations by this advisor.
	LastChecked *date.Time `json:"lastChecked,omitempty"`
}

// MarshalJSON is the custom marshaler for AdvisorProperties.
func (ap AdvisorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.AutoExecuteValue != "" {
		objectMap["autoExecuteValue"] = ap.AutoExecuteValue
	}
	return json.Marshal(objectMap)
}

// CheckNameAvailabilityRequest a request to check whether the specified name for a resource is available.
type CheckNameAvailabilityRequest struct {
	// Name - The name whose availability is to be checked.
	Name *string `json:"name,omitempty"`
	// Type - The type of resource that is used as the scope of the availability check.
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResponse a response indicating whether the specified name for a resource is
// available.
type CheckNameAvailabilityResponse struct {
	autorest.Response `json:"-"`
	// Available - READ-ONLY; True if the name is available, otherwise false.
	Available *bool `json:"available,omitempty"`
	// Message - READ-ONLY; A message explaining why the name is unavailable. Will be null if the name is available.
	Message *string `json:"message,omitempty"`
	// Name - READ-ONLY; The name whose availability was checked.
	Name *string `json:"name,omitempty"`
	// Reason - READ-ONLY; The reason code explaining why the name is unavailable. Will be null if the name is available. Possible values include: 'Invalid', 'AlreadyExists'
	Reason CheckNameAvailabilityReason `json:"reason,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckNameAvailabilityResponse.
func (cnar CheckNameAvailabilityResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Database represents a database.
type Database struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Kind of database.  This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// DatabaseProperties - The properties representing the resource.
	*DatabaseProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Database.
func (d Database) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.DatabaseProperties != nil {
		objectMap["properties"] = d.DatabaseProperties
	}
	if d.Location != nil {
		objectMap["location"] = d.Location
	}
	if d.Tags != nil {
		objectMap["tags"] = d.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Database struct.
func (d *Database) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				d.Kind = &kind
			}
		case "properties":
			if v != nil {
				var databaseProperties DatabaseProperties
				err = json.Unmarshal(*v, &databaseProperties)
				if err != nil {
					return err
				}
				d.DatabaseProperties = &databaseProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				d.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				d.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseConnectionPolicy a database connection policy.
type DatabaseConnectionPolicy struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Resource kind.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// DatabaseConnectionPolicyProperties - Resource properties.
	*DatabaseConnectionPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseConnectionPolicy.
func (dcp DatabaseConnectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcp.DatabaseConnectionPolicyProperties != nil {
		objectMap["properties"] = dcp.DatabaseConnectionPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseConnectionPolicy struct.
func (dcp *DatabaseConnectionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dcp.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dcp.Location = &location
			}
		case "properties":
			if v != nil {
				var databaseConnectionPolicyProperties DatabaseConnectionPolicyProperties
				err = json.Unmarshal(*v, &databaseConnectionPolicyProperties)
				if err != nil {
					return err
				}
				dcp.DatabaseConnectionPolicyProperties = &databaseConnectionPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dcp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dcp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dcp.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseConnectionPolicyProperties properties of a database connection policy.
type DatabaseConnectionPolicyProperties struct {
	// SecurityEnabledAccess - The state of security access.
	SecurityEnabledAccess *string `json:"securityEnabledAccess,omitempty"`
	// ProxyDNSName - The fully qualified host name of the auditing proxy.
	ProxyDNSName *string `json:"proxyDnsName,omitempty"`
	// ProxyPort - The port number of the auditing proxy.
	ProxyPort *string `json:"proxyPort,omitempty"`
	// Visibility - The visibility of the auditing proxy.
	Visibility *string `json:"visibility,omitempty"`
	// UseServerDefault - Whether server default is enabled or disabled.
	UseServerDefault *string `json:"useServerDefault,omitempty"`
	// RedirectionState - The state of proxy redirection.
	RedirectionState *string `json:"redirectionState,omitempty"`
	// State - The connection policy state.
	State *string `json:"state,omitempty"`
}

// DatabaseListResult represents the response to a list database request.
type DatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of databases housed in the server.
	Value *[]Database `json:"value,omitempty"`
}

// DatabaseProperties represents the properties of a database.
type DatabaseProperties struct {
	// Collation - The collation of the database. If createMode is not Default, this value is ignored.
	Collation *string `json:"collation,omitempty"`
	// CreationDate - READ-ONLY; The creation date of the database (ISO8601 format).
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// ContainmentState - READ-ONLY; The containment state of the database.
	ContainmentState *int64 `json:"containmentState,omitempty"`
	// CurrentServiceObjectiveID - READ-ONLY; The current service level objective ID of the database. This is the ID of the service level objective that is currently active.
	CurrentServiceObjectiveID *uuid.UUID `json:"currentServiceObjectiveId,omitempty"`
	// DatabaseID - READ-ONLY; The ID of the database.
	DatabaseID *uuid.UUID `json:"databaseId,omitempty"`
	// EarliestRestoreDate - READ-ONLY; This records the earliest start date and time that restore is available for this database (ISO8601 format).
	EarliestRestoreDate *date.Time `json:"earliestRestoreDate,omitempty"`
	// CreateMode - Specifies the mode of database creation.
	// Default: regular database creation.
	// Copy: creates a database as a copy of an existing database. sourceDatabaseId must be specified as the resource ID of the source database.
	// OnlineSecondary/NonReadableSecondary: creates a database as a (readable or nonreadable) secondary replica of an existing database. sourceDatabaseId must be specified as the resource ID of the existing primary database.
	// PointInTimeRestore: Creates a database by restoring a point in time backup of an existing database. sourceDatabaseId must be specified as the resource ID of the existing database, and restorePointInTime must be specified.
	// Recovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be specified as the recoverable database resource ID to restore.
	// Restore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must be specified. If sourceDatabaseId is the database's original resource ID, then sourceDatabaseDeletionDate must be specified. Otherwise sourceDatabaseId must be the restorable dropped database resource ID and sourceDatabaseDeletionDate is ignored. restorePointInTime may also be specified to restore from an earlier point in time.
	// RestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention vault. recoveryServicesRecoveryPointResourceId must be specified as the recovery point resource ID.
	// Copy, NonReadableSecondary, OnlineSecondary and RestoreLongTermRetentionBackup are not supported for DataWarehouse edition. Possible values include: 'CreateModeCopy', 'CreateModeDefault', 'CreateModeNonReadableSecondary', 'CreateModeOnlineSecondary', 'CreateModePointInTimeRestore', 'CreateModeRecovery', 'CreateModeRestore', 'CreateModeRestoreLongTermRetentionBackup'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// SourceDatabaseID - Conditional. If createMode is Copy, NonReadableSecondary, OnlineSecondary, PointInTimeRestore, Recovery, or Restore, then this value is required. Specifies the resource ID of the source database. If createMode is NonReadableSecondary or OnlineSecondary, the name of the source database must be the same as the new database being created.
	SourceDatabaseID *string `json:"sourceDatabaseId,omitempty"`
	// SourceDatabaseDeletionDate - Conditional. If createMode is Restore and sourceDatabaseId is the deleted database's original resource id when it existed (as opposed to its current restorable dropped database id), then this value is required. Specifies the time that the database was deleted.
	SourceDatabaseDeletionDate *date.Time `json:"sourceDatabaseDeletionDate,omitempty"`
	// RestorePointInTime - Conditional. If createMode is PointInTimeRestore, this value is required. If createMode is Restore, this value is optional. Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database. Must be greater than or equal to the source database's earliestRestoreDate value.
	RestorePointInTime *date.Time `json:"restorePointInTime,omitempty"`
	// RecoveryServicesRecoveryPointResourceID - Conditional. If createMode is RestoreLongTermRetentionBackup, then this value is required. Specifies the resource ID of the recovery point to restore from.
	RecoveryServicesRecoveryPointResourceID *string `json:"recoveryServicesRecoveryPointResourceId,omitempty"`
	// Edition - The edition of the database. The DatabaseEditions enumeration contains all the valid editions. If createMode is NonReadableSecondary or OnlineSecondary, this value is ignored.
	//
	// The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or one of the following commands:
	//
	// ```azurecli
	// az sql db list-editions -l <location> -o table
	// ````
	//
	// ```powershell
	// Get-AzSqlServerServiceObjective -Location <location>
	// ````
	// . Possible values include: 'Web', 'Business', 'Basic', 'Standard', 'Premium', 'PremiumRS', 'Free', 'Stretch', 'DataWarehouse', 'System', 'System2', 'GeneralPurpose', 'BusinessCritical', 'Hyperscale'
	Edition DatabaseEdition `json:"edition,omitempty"`
	// MaxSizeBytes - The max size of the database expressed in bytes. If createMode is not Default, this value is ignored. To see possible values, query the capabilities API (/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationID}/capabilities) referred to by operationId: "Capabilities_ListByLocation."
	MaxSizeBytes *string `json:"maxSizeBytes,omitempty"`
	// RequestedServiceObjectiveID - The configured service level objective ID of the database. This is the service level objective that is in the process of being applied to the database. Once successfully updated, it will match the value of currentServiceObjectiveId property. If requestedServiceObjectiveId and requestedServiceObjectiveName are both updated, the value of requestedServiceObjectiveId overrides the value of requestedServiceObjectiveName.
	//
	// The list of SKUs may vary by region and support offer. To determine the service objective ids that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API.
	RequestedServiceObjectiveID *uuid.UUID `json:"requestedServiceObjectiveId,omitempty"`
	// RequestedServiceObjectiveName - The name of the configured service level objective of the database. This is the service level objective that is in the process of being applied to the database. Once successfully updated, it will match the value of serviceLevelObjective property.
	//
	// The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or one of the following commands:
	//
	// ```azurecli
	// az sql db list-editions -l <location> -o table
	// ````
	//
	// ```powershell
	// Get-AzSqlServerServiceObjective -Location <location>
	// ````
	// . Possible values include: 'ServiceObjectiveNameSystem', 'ServiceObjectiveNameSystem0', 'ServiceObjectiveNameSystem1', 'ServiceObjectiveNameSystem2', 'ServiceObjectiveNameSystem3', 'ServiceObjectiveNameSystem4', 'ServiceObjectiveNameSystem2L', 'ServiceObjectiveNameSystem3L', 'ServiceObjectiveNameSystem4L', 'ServiceObjectiveNameFree', 'ServiceObjectiveNameBasic', 'ServiceObjectiveNameS0', 'ServiceObjectiveNameS1', 'ServiceObjectiveNameS2', 'ServiceObjectiveNameS3', 'ServiceObjectiveNameS4', 'ServiceObjectiveNameS6', 'ServiceObjectiveNameS7', 'ServiceObjectiveNameS9', 'ServiceObjectiveNameS12', 'ServiceObjectiveNameP1', 'ServiceObjectiveNameP2', 'ServiceObjectiveNameP3', 'ServiceObjectiveNameP4', 'ServiceObjectiveNameP6', 'ServiceObjectiveNameP11', 'ServiceObjectiveNameP15', 'ServiceObjectiveNamePRS1', 'ServiceObjectiveNamePRS2', 'ServiceObjectiveNamePRS4', 'ServiceObjectiveNamePRS6', 'ServiceObjectiveNameDW100', 'ServiceObjectiveNameDW200', 'ServiceObjectiveNameDW300', 'ServiceObjectiveNameDW400', 'ServiceObjectiveNameDW500', 'ServiceObjectiveNameDW600', 'ServiceObjectiveNameDW1000', 'ServiceObjectiveNameDW1200', 'ServiceObjectiveNameDW1000c', 'ServiceObjectiveNameDW1500', 'ServiceObjectiveNameDW1500c', 'ServiceObjectiveNameDW2000', 'ServiceObjectiveNameDW2000c', 'ServiceObjectiveNameDW3000', 'ServiceObjectiveNameDW2500c', 'ServiceObjectiveNameDW3000c', 'ServiceObjectiveNameDW6000', 'ServiceObjectiveNameDW5000c', 'ServiceObjectiveNameDW6000c', 'ServiceObjectiveNameDW7500c', 'ServiceObjectiveNameDW10000c', 'ServiceObjectiveNameDW15000c', 'ServiceObjectiveNameDW30000c', 'ServiceObjectiveNameDS100', 'ServiceObjectiveNameDS200', 'ServiceObjectiveNameDS300', 'ServiceObjectiveNameDS400', 'ServiceObjectiveNameDS500', 'ServiceObjectiveNameDS600', 'ServiceObjectiveNameDS1000', 'ServiceObjectiveNameDS1200', 'ServiceObjectiveNameDS1500', 'ServiceObjectiveNameDS2000', 'ServiceObjectiveNameElasticPool'
	RequestedServiceObjectiveName ServiceObjectiveName `json:"requestedServiceObjectiveName,omitempty"`
	// ServiceLevelObjective - READ-ONLY; The current service level objective of the database. Possible values include: 'ServiceObjectiveNameSystem', 'ServiceObjectiveNameSystem0', 'ServiceObjectiveNameSystem1', 'ServiceObjectiveNameSystem2', 'ServiceObjectiveNameSystem3', 'ServiceObjectiveNameSystem4', 'ServiceObjectiveNameSystem2L', 'ServiceObjectiveNameSystem3L', 'ServiceObjectiveNameSystem4L', 'ServiceObjectiveNameFree', 'ServiceObjectiveNameBasic', 'ServiceObjectiveNameS0', 'ServiceObjectiveNameS1', 'ServiceObjectiveNameS2', 'ServiceObjectiveNameS3', 'ServiceObjectiveNameS4', 'ServiceObjectiveNameS6', 'ServiceObjectiveNameS7', 'ServiceObjectiveNameS9', 'ServiceObjectiveNameS12', 'ServiceObjectiveNameP1', 'ServiceObjectiveNameP2', 'ServiceObjectiveNameP3', 'ServiceObjectiveNameP4', 'ServiceObjectiveNameP6', 'ServiceObjectiveNameP11', 'ServiceObjectiveNameP15', 'ServiceObjectiveNamePRS1', 'ServiceObjectiveNamePRS2', 'ServiceObjectiveNamePRS4', 'ServiceObjectiveNamePRS6', 'ServiceObjectiveNameDW100', 'ServiceObjectiveNameDW200', 'ServiceObjectiveNameDW300', 'ServiceObjectiveNameDW400', 'ServiceObjectiveNameDW500', 'ServiceObjectiveNameDW600', 'ServiceObjectiveNameDW1000', 'ServiceObjectiveNameDW1200', 'ServiceObjectiveNameDW1000c', 'ServiceObjectiveNameDW1500', 'ServiceObjectiveNameDW1500c', 'ServiceObjectiveNameDW2000', 'ServiceObjectiveNameDW2000c', 'ServiceObjectiveNameDW3000', 'ServiceObjectiveNameDW2500c', 'ServiceObjectiveNameDW3000c', 'ServiceObjectiveNameDW6000', 'ServiceObjectiveNameDW5000c', 'ServiceObjectiveNameDW6000c', 'ServiceObjectiveNameDW7500c', 'ServiceObjectiveNameDW10000c', 'ServiceObjectiveNameDW15000c', 'ServiceObjectiveNameDW30000c', 'ServiceObjectiveNameDS100', 'ServiceObjectiveNameDS200', 'ServiceObjectiveNameDS300', 'ServiceObjectiveNameDS400', 'ServiceObjectiveNameDS500', 'ServiceObjectiveNameDS600', 'ServiceObjectiveNameDS1000', 'ServiceObjectiveNameDS1200', 'ServiceObjectiveNameDS1500', 'ServiceObjectiveNameDS2000', 'ServiceObjectiveNameElasticPool'
	ServiceLevelObjective ServiceObjectiveName `json:"serviceLevelObjective,omitempty"`
	// Status - READ-ONLY; The status of the database.
	Status *string `json:"status,omitempty"`
	// ElasticPoolName - The name of the elastic pool the database is in. If elasticPoolName and requestedServiceObjectiveName are both updated, the value of requestedServiceObjectiveName is ignored. Not supported for DataWarehouse edition.
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// DefaultSecondaryLocation - READ-ONLY; The default secondary region for this database.
	DefaultSecondaryLocation *string `json:"defaultSecondaryLocation,omitempty"`
	// ServiceTierAdvisors - READ-ONLY; The list of service tier advisors for this database. Expanded property
	ServiceTierAdvisors *[]ServiceTierAdvisor `json:"serviceTierAdvisors,omitempty"`
	// TransparentDataEncryption - READ-ONLY; The transparent data encryption info for this database.
	TransparentDataEncryption *[]TransparentDataEncryption `json:"transparentDataEncryption,omitempty"`
	// RecommendedIndex - READ-ONLY; The recommended indices for this database.
	RecommendedIndex *[]RecommendedIndex `json:"recommendedIndex,omitempty"`
	// FailoverGroupID - READ-ONLY; The resource identifier of the failover group containing this database.
	FailoverGroupID *string `json:"failoverGroupId,omitempty"`
	// ReadScale - Conditional. If the database is a geo-secondary, readScale indicates whether read-only connections are allowed to this database or not. Not supported for DataWarehouse edition. Possible values include: 'ReadScaleEnabled', 'ReadScaleDisabled'
	ReadScale ReadScale `json:"readScale,omitempty"`
	// SampleName - Indicates the name of the sample schema to apply when creating this database. If createMode is not Default, this value is ignored. Not supported for DataWarehouse edition. Possible values include: 'AdventureWorksLT'
	SampleName SampleName `json:"sampleName,omitempty"`
	// ZoneRedundant - Whether or not this database is zone redundant, which means the replicas of this database will be spread across multiple availability zones.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseProperties.
func (dp DatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.Collation != nil {
		objectMap["collation"] = dp.Collation
	}
	if dp.CreateMode != "" {
		objectMap["createMode"] = dp.CreateMode
	}
	if dp.SourceDatabaseID != nil {
		objectMap["sourceDatabaseId"] = dp.SourceDatabaseID
	}
	if dp.SourceDatabaseDeletionDate != nil {
		objectMap["sourceDatabaseDeletionDate"] = dp.SourceDatabaseDeletionDate
	}
	if dp.RestorePointInTime != nil {
		objectMap["restorePointInTime"] = dp.RestorePointInTime
	}
	if dp.RecoveryServicesRecoveryPointResourceID != nil {
		objectMap["recoveryServicesRecoveryPointResourceId"] = dp.RecoveryServicesRecoveryPointResourceID
	}
	if dp.Edition != "" {
		objectMap["edition"] = dp.Edition
	}
	if dp.MaxSizeBytes != nil {
		objectMap["maxSizeBytes"] = dp.MaxSizeBytes
	}
	if dp.RequestedServiceObjectiveID != nil {
		objectMap["requestedServiceObjectiveId"] = dp.RequestedServiceObjectiveID
	}
	if dp.RequestedServiceObjectiveName != "" {
		objectMap["requestedServiceObjectiveName"] = dp.RequestedServiceObjectiveName
	}
	if dp.ElasticPoolName != nil {
		objectMap["elasticPoolName"] = dp.ElasticPoolName
	}
	if dp.ReadScale != "" {
		objectMap["readScale"] = dp.ReadScale
	}
	if dp.SampleName != "" {
		objectMap["sampleName"] = dp.SampleName
	}
	if dp.ZoneRedundant != nil {
		objectMap["zoneRedundant"] = dp.ZoneRedundant
	}
	return json.Marshal(objectMap)
}

// DatabasesCreateImportOperationFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabasesCreateImportOperationFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (ImportExportResponse, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesCreateImportOperationFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesCreateImportOperationFuture.Result.
func (future *DatabasesCreateImportOperationFuture) result(client DatabasesClient) (ier ImportExportResponse, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesCreateImportOperationFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ier.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesCreateImportOperationFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ier.Response.Response, err = future.GetResult(sender); err == nil && ier.Response.Response.StatusCode != http.StatusNoContent {
		ier, err = client.CreateImportOperationResponder(ier.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesCreateImportOperationFuture", "Result", ier.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (Database, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesCreateOrUpdateFuture.Result.
func (future *DatabasesCreateOrUpdateFuture) result(client DatabasesClient) (d Database, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		d.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.CreateOrUpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesCreateOrUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseSecurityAlertPolicy contains information about a database Threat Detection policy.
type DatabaseSecurityAlertPolicy struct {
	autorest.Response `json:"-"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// Kind - READ-ONLY; Resource kind.
	Kind *string `json:"kind,omitempty"`
	// DatabaseSecurityAlertPolicyProperties - Properties of the security alert policy.
	*DatabaseSecurityAlertPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseSecurityAlertPolicy.
func (dsap DatabaseSecurityAlertPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsap.Location != nil {
		objectMap["location"] = dsap.Location
	}
	if dsap.DatabaseSecurityAlertPolicyProperties != nil {
		objectMap["properties"] = dsap.DatabaseSecurityAlertPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseSecurityAlertPolicy struct.
func (dsap *DatabaseSecurityAlertPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dsap.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dsap.Kind = &kind
			}
		case "properties":
			if v != nil {
				var databaseSecurityAlertPolicyProperties DatabaseSecurityAlertPolicyProperties
				err = json.Unmarshal(*v, &databaseSecurityAlertPolicyProperties)
				if err != nil {
					return err
				}
				dsap.DatabaseSecurityAlertPolicyProperties = &databaseSecurityAlertPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dsap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dsap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dsap.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseSecurityAlertPolicyProperties properties for a database Threat Detection policy.
type DatabaseSecurityAlertPolicyProperties struct {
	// State - Specifies the state of the policy. If state is Enabled, storageEndpoint and storageAccountAccessKey are required. Possible values include: 'SecurityAlertPolicyStateNew', 'SecurityAlertPolicyStateEnabled', 'SecurityAlertPolicyStateDisabled'
	State SecurityAlertPolicyState `json:"state,omitempty"`
	// DisabledAlerts - Specifies the semicolon-separated list of alerts that are disabled, or empty string to disable no alerts. Possible values: Sql_Injection; Sql_Injection_Vulnerability; Access_Anomaly; Data_Exfiltration; Unsafe_Action.
	DisabledAlerts *string `json:"disabledAlerts,omitempty"`
	// EmailAddresses - Specifies the semicolon-separated list of e-mail addresses to which the alert is sent.
	EmailAddresses *string `json:"emailAddresses,omitempty"`
	// EmailAccountAdmins - Specifies that the alert is sent to the account administrators. Possible values include: 'SecurityAlertPolicyEmailAccountAdminsEnabled', 'SecurityAlertPolicyEmailAccountAdminsDisabled'
	EmailAccountAdmins SecurityAlertPolicyEmailAccountAdmins `json:"emailAccountAdmins,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs. If state is Enabled, storageEndpoint is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the Threat Detection audit storage account. If state is Enabled, storageAccountAccessKey is required.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the Threat Detection audit logs.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// UseServerDefault - Specifies whether to use the default server policy. Possible values include: 'SecurityAlertPolicyUseServerDefaultEnabled', 'SecurityAlertPolicyUseServerDefaultDisabled'
	UseServerDefault SecurityAlertPolicyUseServerDefault `json:"useServerDefault,omitempty"`
}

// DatabasesExportFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesExportFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (ImportExportResponse, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesExportFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesExportFuture.Result.
func (future *DatabasesExportFuture) result(client DatabasesClient) (ier ImportExportResponse, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesExportFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ier.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesExportFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ier.Response.Response, err = future.GetResult(sender); err == nil && ier.Response.Response.StatusCode != http.StatusNoContent {
		ier, err = client.ExportResponder(ier.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesExportFuture", "Result", ier.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesImportFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesImportFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (ImportExportResponse, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesImportFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesImportFuture.Result.
func (future *DatabasesImportFuture) result(client DatabasesClient) (ier ImportExportResponse, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesImportFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ier.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesImportFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ier.Response.Response, err = future.GetResult(sender); err == nil && ier.Response.Response.StatusCode != http.StatusNoContent {
		ier, err = client.ImportResponder(ier.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesImportFuture", "Result", ier.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesPauseFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesPauseFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesPauseFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesPauseFuture.Result.
func (future *DatabasesPauseFuture) result(client DatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesPauseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesPauseFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabasesResumeFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesResumeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesResumeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesResumeFuture.Result.
func (future *DatabasesResumeFuture) result(client DatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesResumeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesResumeFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabasesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (Database, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabasesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabasesUpdateFuture.Result.
func (future *DatabasesUpdateFuture) result(client DatabasesClient) (d Database, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		d.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.UpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseTableAuditingPolicy a database table auditing policy.
type DatabaseTableAuditingPolicy struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Resource kind.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// DatabaseTableAuditingPolicyProperties - Resource properties.
	*DatabaseTableAuditingPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseTableAuditingPolicy.
func (dtap DatabaseTableAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dtap.DatabaseTableAuditingPolicyProperties != nil {
		objectMap["properties"] = dtap.DatabaseTableAuditingPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseTableAuditingPolicy struct.
func (dtap *DatabaseTableAuditingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dtap.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dtap.Location = &location
			}
		case "properties":
			if v != nil {
				var databaseTableAuditingPolicyProperties DatabaseTableAuditingPolicyProperties
				err = json.Unmarshal(*v, &databaseTableAuditingPolicyProperties)
				if err != nil {
					return err
				}
				dtap.DatabaseTableAuditingPolicyProperties = &databaseTableAuditingPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dtap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dtap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dtap.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseTableAuditingPolicyListResult represents the response to a list database table auditing policies
// request.
type DatabaseTableAuditingPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of database table auditing policies.
	Value *[]DatabaseTableAuditingPolicy `json:"value,omitempty"`
}

// DatabaseTableAuditingPolicyProperties properties of a database table auditing policy.
type DatabaseTableAuditingPolicyProperties struct {
	// UseServerDefault - Whether server default is enabled or disabled.
	UseServerDefault *string `json:"useServerDefault,omitempty"`
	// AuditingState - The state of the policy.
	AuditingState *string `json:"auditingState,omitempty"`
	// AuditLogsTableName - The audit logs table name.
	AuditLogsTableName *string `json:"auditLogsTableName,omitempty"`
	// EventTypesToAudit - Comma-separated list of event types to audit.
	EventTypesToAudit *string `json:"eventTypesToAudit,omitempty"`
	// FullAuditLogsTableName - The full audit logs table name.
	FullAuditLogsTableName *string `json:"fullAuditLogsTableName,omitempty"`
	// RetentionDays - The number of days to keep in the audit logs.
	RetentionDays *string `json:"retentionDays,omitempty"`
	// StorageAccountKey - The key of the auditing storage account.
	StorageAccountKey *string `json:"storageAccountKey,omitempty"`
	// StorageAccountName - The table storage account name
	StorageAccountName *string `json:"storageAccountName,omitempty"`
	// StorageAccountResourceGroupName - The table storage account resource group name
	StorageAccountResourceGroupName *string `json:"storageAccountResourceGroupName,omitempty"`
	// StorageAccountSecondaryKey - The secondary key of the auditing storage account.
	StorageAccountSecondaryKey *string `json:"storageAccountSecondaryKey,omitempty"`
	// StorageAccountSubscriptionID - The table storage subscription Id.
	StorageAccountSubscriptionID *uuid.UUID `json:"storageAccountSubscriptionId,omitempty"`
	// StorageTableEndpoint - The storage table endpoint.
	StorageTableEndpoint *string `json:"storageTableEndpoint,omitempty"`
}

// DatabaseUpdate represents a database update.
type DatabaseUpdate struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// DatabaseProperties - The properties representing the resource.
	*DatabaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseUpdate.
func (du DatabaseUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if du.Tags != nil {
		objectMap["tags"] = du.Tags
	}
	if du.DatabaseProperties != nil {
		objectMap["properties"] = du.DatabaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseUpdate struct.
func (du *DatabaseUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				du.Tags = tags
			}
		case "properties":
			if v != nil {
				var databaseProperties DatabaseProperties
				err = json.Unmarshal(*v, &databaseProperties)
				if err != nil {
					return err
				}
				du.DatabaseProperties = &databaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				du.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				du.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				du.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseUsage the database usages.
type DatabaseUsage struct {
	// Name - READ-ONLY; The name of the usage metric.
	Name *string `json:"name,omitempty"`
	// ResourceName - READ-ONLY; The name of the resource.
	ResourceName *string `json:"resourceName,omitempty"`
	// DisplayName - READ-ONLY; The usage metric display name.
	DisplayName *string `json:"displayName,omitempty"`
	// CurrentValue - READ-ONLY; The current value of the usage metric.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// Limit - READ-ONLY; The current limit of the usage metric.
	Limit *float64 `json:"limit,omitempty"`
	// Unit - READ-ONLY; The units of the usage metric.
	Unit *string `json:"unit,omitempty"`
	// NextResetTime - READ-ONLY; The next reset time for the usage metric (ISO8601 format).
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseUsage.
func (du DatabaseUsage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DatabaseUsageListResult the response to a list database metrics request.
type DatabaseUsageListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of database usages for the database.
	Value *[]DatabaseUsage `json:"value,omitempty"`
}

// DataMaskingPolicy represents a database data masking policy.
type DataMaskingPolicy struct {
	autorest.Response `json:"-"`
	// DataMaskingPolicyProperties - The properties of the data masking policy.
	*DataMaskingPolicyProperties `json:"properties,omitempty"`
	// Location - READ-ONLY; The location of the data masking policy.
	Location *string `json:"location,omitempty"`
	// Kind - READ-ONLY; The kind of data masking policy. Metadata, used for Azure portal.
	Kind *string `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataMaskingPolicy.
func (dmp DataMaskingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dmp.DataMaskingPolicyProperties != nil {
		objectMap["properties"] = dmp.DataMaskingPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataMaskingPolicy struct.
func (dmp *DataMaskingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataMaskingPolicyProperties DataMaskingPolicyProperties
				err = json.Unmarshal(*v, &dataMaskingPolicyProperties)
				if err != nil {
					return err
				}
				dmp.DataMaskingPolicyProperties = &dataMaskingPolicyProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dmp.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dmp.Kind = &kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dmp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dmp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dmp.Type = &typeVar
			}
		}
	}

	return nil
}

// DataMaskingPolicyProperties the properties of a database data masking policy.
type DataMaskingPolicyProperties struct {
	// DataMaskingState - The state of the data masking policy. Possible values include: 'DataMaskingStateDisabled', 'DataMaskingStateEnabled'
	DataMaskingState DataMaskingState `json:"dataMaskingState,omitempty"`
	// ExemptPrincipals - The list of the exempt principals. Specifies the semicolon-separated list of database users for which the data masking policy does not apply. The specified users receive data results without masking for all of the database queries.
	ExemptPrincipals *string `json:"exemptPrincipals,omitempty"`
	// ApplicationPrincipals - READ-ONLY; The list of the application principals. This is a legacy parameter and is no longer used.
	ApplicationPrincipals *string `json:"applicationPrincipals,omitempty"`
	// MaskingLevel - READ-ONLY; The masking level. This is a legacy parameter and is no longer used.
	MaskingLevel *string `json:"maskingLevel,omitempty"`
}

// MarshalJSON is the custom marshaler for DataMaskingPolicyProperties.
func (dmpp DataMaskingPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dmpp.DataMaskingState != "" {
		objectMap["dataMaskingState"] = dmpp.DataMaskingState
	}
	if dmpp.ExemptPrincipals != nil {
		objectMap["exemptPrincipals"] = dmpp.ExemptPrincipals
	}
	return json.Marshal(objectMap)
}

// DataMaskingRule represents a database data masking rule.
type DataMaskingRule struct {
	autorest.Response `json:"-"`
	// DataMaskingRuleProperties - The properties of the resource.
	*DataMaskingRuleProperties `json:"properties,omitempty"`
	// Location - READ-ONLY; The location of the data masking rule.
	Location *string `json:"location,omitempty"`
	// Kind - READ-ONLY; The kind of Data Masking Rule. Metadata, used for Azure portal.
	Kind *string `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataMaskingRule.
func (dmr DataMaskingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dmr.DataMaskingRuleProperties != nil {
		objectMap["properties"] = dmr.DataMaskingRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataMaskingRule struct.
func (dmr *DataMaskingRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataMaskingRuleProperties DataMaskingRuleProperties
				err = json.Unmarshal(*v, &dataMaskingRuleProperties)
				if err != nil {
					return err
				}
				dmr.DataMaskingRuleProperties = &dataMaskingRuleProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dmr.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dmr.Kind = &kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dmr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dmr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dmr.Type = &typeVar
			}
		}
	}

	return nil
}

// DataMaskingRuleListResult the response to a list data masking rules request.
type DataMaskingRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of database data masking rules.
	Value *[]DataMaskingRule `json:"value,omitempty"`
}

// DataMaskingRuleProperties the properties of a database data masking rule.
type DataMaskingRuleProperties struct {
	// ID - READ-ONLY; The rule Id.
	ID *string `json:"id,omitempty"`
	// AliasName - The alias name. This is a legacy parameter and is no longer used.
	AliasName *string `json:"aliasName,omitempty"`
	// RuleState - The rule state. Used to delete a rule. To delete an existing rule, specify the schemaName, tableName, columnName, maskingFunction, and specify ruleState as disabled. However, if the rule doesn't already exist, the rule will be created with ruleState set to enabled, regardless of the provided value of ruleState. Possible values include: 'DataMaskingRuleStateDisabled', 'DataMaskingRuleStateEnabled'
	RuleState DataMaskingRuleState `json:"ruleState,omitempty"`
	// SchemaName - The schema name on which the data masking rule is applied.
	SchemaName *string `json:"schemaName,omitempty"`
	// TableName - The table name on which the data masking rule is applied.
	TableName *string `json:"tableName,omitempty"`
	// ColumnName - The column name on which the data masking rule is applied.
	ColumnName *string `json:"columnName,omitempty"`
	// MaskingFunction - The masking function that is used for the data masking rule. Possible values include: 'DataMaskingFunctionDefault', 'DataMaskingFunctionCCN', 'DataMaskingFunctionEmail', 'DataMaskingFunctionNumber', 'DataMaskingFunctionSSN', 'DataMaskingFunctionText'
	MaskingFunction DataMaskingFunction `json:"maskingFunction,omitempty"`
	// NumberFrom - The numberFrom property of the masking rule. Required if maskingFunction is set to Number, otherwise this parameter will be ignored.
	NumberFrom *string `json:"numberFrom,omitempty"`
	// NumberTo - The numberTo property of the data masking rule. Required if maskingFunction is set to Number, otherwise this parameter will be ignored.
	NumberTo *string `json:"numberTo,omitempty"`
	// PrefixSize - If maskingFunction is set to Text, the number of characters to show unmasked in the beginning of the string. Otherwise, this parameter will be ignored.
	PrefixSize *string `json:"prefixSize,omitempty"`
	// SuffixSize - If maskingFunction is set to Text, the number of characters to show unmasked at the end of the string. Otherwise, this parameter will be ignored.
	SuffixSize *string `json:"suffixSize,omitempty"`
	// ReplacementString - If maskingFunction is set to Text, the character to use for masking the unexposed part of the string. Otherwise, this parameter will be ignored.
	ReplacementString *string `json:"replacementString,omitempty"`
}

// MarshalJSON is the custom marshaler for DataMaskingRuleProperties.
func (dmrp DataMaskingRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dmrp.AliasName != nil {
		objectMap["aliasName"] = dmrp.AliasName
	}
	if dmrp.RuleState != "" {
		objectMap["ruleState"] = dmrp.RuleState
	}
	if dmrp.SchemaName != nil {
		objectMap["schemaName"] = dmrp.SchemaName
	}
	if dmrp.TableName != nil {
		objectMap["tableName"] = dmrp.TableName
	}
	if dmrp.ColumnName != nil {
		objectMap["columnName"] = dmrp.ColumnName
	}
	if dmrp.MaskingFunction != "" {
		objectMap["maskingFunction"] = dmrp.MaskingFunction
	}
	if dmrp.NumberFrom != nil {
		objectMap["numberFrom"] = dmrp.NumberFrom
	}
	if dmrp.NumberTo != nil {
		objectMap["numberTo"] = dmrp.NumberTo
	}
	if dmrp.PrefixSize != nil {
		objectMap["prefixSize"] = dmrp.PrefixSize
	}
	if dmrp.SuffixSize != nil {
		objectMap["suffixSize"] = dmrp.SuffixSize
	}
	if dmrp.ReplacementString != nil {
		objectMap["replacementString"] = dmrp.ReplacementString
	}
	return json.Marshal(objectMap)
}

// DisasterRecoveryConfiguration represents a disaster recovery configuration.
type DisasterRecoveryConfiguration struct {
	autorest.Response `json:"-"`
	// DisasterRecoveryConfigurationProperties - The properties representing the resource.
	*DisasterRecoveryConfigurationProperties `json:"properties,omitempty"`
	// Location - READ-ONLY; Location of the server that contains this disaster recovery configuration.
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DisasterRecoveryConfiguration.
func (drc DisasterRecoveryConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if drc.DisasterRecoveryConfigurationProperties != nil {
		objectMap["properties"] = drc.DisasterRecoveryConfigurationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DisasterRecoveryConfiguration struct.
func (drc *DisasterRecoveryConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var disasterRecoveryConfigurationProperties DisasterRecoveryConfigurationProperties
				err = json.Unmarshal(*v, &disasterRecoveryConfigurationProperties)
				if err != nil {
					return err
				}
				drc.DisasterRecoveryConfigurationProperties = &disasterRecoveryConfigurationProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				drc.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				drc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				drc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				drc.Type = &typeVar
			}
		}
	}

	return nil
}

// DisasterRecoveryConfigurationListResult represents the response to a List disaster recovery
// configuration request.
type DisasterRecoveryConfigurationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of disaster recovery configurations housed under the server.
	Value *[]DisasterRecoveryConfiguration `json:"value,omitempty"`
}

// DisasterRecoveryConfigurationProperties represents the properties of a disaster recovery configuration.
type DisasterRecoveryConfigurationProperties struct {
	// Status - READ-ONLY; The status of the disaster recovery configuration. Possible values include: 'Creating', 'Ready', 'FailingOver', 'Dropping'
	Status DisasterRecoveryConfigurationStatus `json:"status,omitempty"`
	// AutoFailover - Whether or not failover can be done automatically. Possible values include: 'Off', 'On'
	AutoFailover DisasterRecoveryConfigurationAutoFailover `json:"autoFailover,omitempty"`
	// FailoverPolicy - How aggressive the automatic failover should be. Possible values include: 'Manual', 'Automatic'
	FailoverPolicy DisasterRecoveryConfigurationFailoverPolicy `json:"failoverPolicy,omitempty"`
	// PartnerServerID - Id of the partner server.
	PartnerServerID *string `json:"partnerServerId,omitempty"`
	// LogicalServerName - READ-ONLY; Logical name of the server.
	LogicalServerName *string `json:"logicalServerName,omitempty"`
	// PartnerLogicalServerName - READ-ONLY; Logical name of the partner server.
	PartnerLogicalServerName *string `json:"partnerLogicalServerName,omitempty"`
	// Role - READ-ONLY; The role of the current server in the disaster recovery configuration. Possible values include: 'None', 'Primary', 'Secondary'
	Role DisasterRecoveryConfigurationRole `json:"role,omitempty"`
}

// MarshalJSON is the custom marshaler for DisasterRecoveryConfigurationProperties.
func (drcp DisasterRecoveryConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if drcp.AutoFailover != "" {
		objectMap["autoFailover"] = drcp.AutoFailover
	}
	if drcp.FailoverPolicy != "" {
		objectMap["failoverPolicy"] = drcp.FailoverPolicy
	}
	if drcp.PartnerServerID != nil {
		objectMap["partnerServerId"] = drcp.PartnerServerID
	}
	return json.Marshal(objectMap)
}

// DisasterRecoveryConfigurationsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DisasterRecoveryConfigurationsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DisasterRecoveryConfigurationsClient) (DisasterRecoveryConfiguration, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DisasterRecoveryConfigurationsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DisasterRecoveryConfigurationsCreateOrUpdateFuture.Result.
func (future *DisasterRecoveryConfigurationsCreateOrUpdateFuture) result(client DisasterRecoveryConfigurationsClient) (drc DisasterRecoveryConfiguration, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DisasterRecoveryConfigurationsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		drc.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DisasterRecoveryConfigurationsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if drc.Response.Response, err = future.GetResult(sender); err == nil && drc.Response.Response.StatusCode != http.StatusNoContent {
		drc, err = client.CreateOrUpdateResponder(drc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DisasterRecoveryConfigurationsCreateOrUpdateFuture", "Result", drc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DisasterRecoveryConfigurationsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DisasterRecoveryConfigurationsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DisasterRecoveryConfigurationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DisasterRecoveryConfigurationsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DisasterRecoveryConfigurationsDeleteFuture.Result.
func (future *DisasterRecoveryConfigurationsDeleteFuture) result(client DisasterRecoveryConfigurationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DisasterRecoveryConfigurationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DisasterRecoveryConfigurationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DisasterRecoveryConfigurationsFailoverAllowDataLossFuture an abstraction for monitoring and retrieving
// the results of a long-running operation.
type DisasterRecoveryConfigurationsFailoverAllowDataLossFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DisasterRecoveryConfigurationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DisasterRecoveryConfigurationsFailoverAllowDataLossFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DisasterRecoveryConfigurationsFailoverAllowDataLossFuture.Result.
func (future *DisasterRecoveryConfigurationsFailoverAllowDataLossFuture) result(client DisasterRecoveryConfigurationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DisasterRecoveryConfigurationsFailoverAllowDataLossFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DisasterRecoveryConfigurationsFailoverAllowDataLossFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DisasterRecoveryConfigurationsFailoverFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type DisasterRecoveryConfigurationsFailoverFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DisasterRecoveryConfigurationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DisasterRecoveryConfigurationsFailoverFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DisasterRecoveryConfigurationsFailoverFuture.Result.
func (future *DisasterRecoveryConfigurationsFailoverFuture) result(client DisasterRecoveryConfigurationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DisasterRecoveryConfigurationsFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.DisasterRecoveryConfigurationsFailoverFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EditionCapability the database edition capabilities.
type EditionCapability struct {
	// Name - READ-ONLY; The edition name.
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; The status of the edition. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// SupportedServiceLevelObjectives - READ-ONLY; The list of supported service objectives for the edition.
	SupportedServiceLevelObjectives *[]ServiceObjectiveCapability `json:"supportedServiceLevelObjectives,omitempty"`
	// ZoneRedundant - READ-ONLY; Whether or not zone redundancy is supported for the edition.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
}

// MarshalJSON is the custom marshaler for EditionCapability.
func (ec EditionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ElasticPool represents a database elastic pool.
type ElasticPool struct {
	autorest.Response `json:"-"`
	// ElasticPoolProperties - The properties representing the resource.
	*ElasticPoolProperties `json:"properties,omitempty"`
	// Kind - READ-ONLY; Kind of elastic pool.  This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPool.
func (ep ElasticPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ep.ElasticPoolProperties != nil {
		objectMap["properties"] = ep.ElasticPoolProperties
	}
	if ep.Location != nil {
		objectMap["location"] = ep.Location
	}
	if ep.Tags != nil {
		objectMap["tags"] = ep.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPool struct.
func (ep *ElasticPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var elasticPoolProperties ElasticPoolProperties
				err = json.Unmarshal(*v, &elasticPoolProperties)
				if err != nil {
					return err
				}
				ep.ElasticPoolProperties = &elasticPoolProperties
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ep.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ep.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ep.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ep.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ep.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ep.Type = &typeVar
			}
		}
	}

	return nil
}

// ElasticPoolActivity represents the activity on an elastic pool.
type ElasticPoolActivity struct {
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ElasticPoolActivityProperties - The properties representing the resource.
	*ElasticPoolActivityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolActivity.
func (epa ElasticPoolActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epa.Location != nil {
		objectMap["location"] = epa.Location
	}
	if epa.ElasticPoolActivityProperties != nil {
		objectMap["properties"] = epa.ElasticPoolActivityProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPoolActivity struct.
func (epa *ElasticPoolActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				epa.Location = &location
			}
		case "properties":
			if v != nil {
				var elasticPoolActivityProperties ElasticPoolActivityProperties
				err = json.Unmarshal(*v, &elasticPoolActivityProperties)
				if err != nil {
					return err
				}
				epa.ElasticPoolActivityProperties = &elasticPoolActivityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				epa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				epa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				epa.Type = &typeVar
			}
		}
	}

	return nil
}

// ElasticPoolActivityListResult represents the response to a list elastic pool activity request.
type ElasticPoolActivityListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of elastic pool activities.
	Value *[]ElasticPoolActivity `json:"value,omitempty"`
}

// ElasticPoolActivityProperties represents the properties of an elastic pool.
type ElasticPoolActivityProperties struct {
	// EndTime - READ-ONLY; The time the operation finished (ISO8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// ErrorCode - READ-ONLY; The error code if available.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorMessage - READ-ONLY; The error message if available.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// ErrorSeverity - READ-ONLY; The error severity if available.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty"`
	// Operation - READ-ONLY; The operation name.
	Operation *string `json:"operation,omitempty"`
	// OperationID - READ-ONLY; The unique operation ID.
	OperationID *uuid.UUID `json:"operationId,omitempty"`
	// PercentComplete - READ-ONLY; The percentage complete if available.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// RequestedDatabaseDtuMax - READ-ONLY; The requested max DTU per database if available.
	RequestedDatabaseDtuMax *int32 `json:"requestedDatabaseDtuMax,omitempty"`
	// RequestedDatabaseDtuMin - READ-ONLY; The requested min DTU per database if available.
	RequestedDatabaseDtuMin *int32 `json:"requestedDatabaseDtuMin,omitempty"`
	// RequestedDtu - READ-ONLY; The requested DTU for the pool if available.
	RequestedDtu *int32 `json:"requestedDtu,omitempty"`
	// RequestedElasticPoolName - READ-ONLY; The requested name for the elastic pool if available.
	RequestedElasticPoolName *string `json:"requestedElasticPoolName,omitempty"`
	// RequestedStorageLimitInGB - READ-ONLY; The requested storage limit for the pool in GB if available.
	RequestedStorageLimitInGB *int64 `json:"requestedStorageLimitInGB,omitempty"`
	// ElasticPoolName - READ-ONLY; The name of the elastic pool.
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// ServerName - READ-ONLY; The name of the server the elastic pool is in.
	ServerName *string `json:"serverName,omitempty"`
	// StartTime - READ-ONLY; The time the operation started (ISO8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// State - READ-ONLY; The current state of the operation.
	State *string `json:"state,omitempty"`
	// RequestedStorageLimitInMB - READ-ONLY; The requested storage limit in MB.
	RequestedStorageLimitInMB *int32 `json:"requestedStorageLimitInMB,omitempty"`
	// RequestedDatabaseDtuGuarantee - READ-ONLY; The requested per database DTU guarantee.
	RequestedDatabaseDtuGuarantee *int32 `json:"requestedDatabaseDtuGuarantee,omitempty"`
	// RequestedDatabaseDtuCap - READ-ONLY; The requested per database DTU cap.
	RequestedDatabaseDtuCap *int32 `json:"requestedDatabaseDtuCap,omitempty"`
	// RequestedDtuGuarantee - READ-ONLY; The requested DTU guarantee.
	RequestedDtuGuarantee *int32 `json:"requestedDtuGuarantee,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolActivityProperties.
func (epap ElasticPoolActivityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ElasticPoolDatabaseActivity represents the activity on an elastic pool.
type ElasticPoolDatabaseActivity struct {
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ElasticPoolDatabaseActivityProperties - The properties representing the resource.
	*ElasticPoolDatabaseActivityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolDatabaseActivity.
func (epda ElasticPoolDatabaseActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epda.Location != nil {
		objectMap["location"] = epda.Location
	}
	if epda.ElasticPoolDatabaseActivityProperties != nil {
		objectMap["properties"] = epda.ElasticPoolDatabaseActivityProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPoolDatabaseActivity struct.
func (epda *ElasticPoolDatabaseActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				epda.Location = &location
			}
		case "properties":
			if v != nil {
				var elasticPoolDatabaseActivityProperties ElasticPoolDatabaseActivityProperties
				err = json.Unmarshal(*v, &elasticPoolDatabaseActivityProperties)
				if err != nil {
					return err
				}
				epda.ElasticPoolDatabaseActivityProperties = &elasticPoolDatabaseActivityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				epda.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				epda.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				epda.Type = &typeVar
			}
		}
	}

	return nil
}

// ElasticPoolDatabaseActivityListResult represents the response to a list elastic pool database activity
// request.
type ElasticPoolDatabaseActivityListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of elastic pool database activities.
	Value *[]ElasticPoolDatabaseActivity `json:"value,omitempty"`
}

// ElasticPoolDatabaseActivityProperties represents the properties of an elastic pool database activity.
type ElasticPoolDatabaseActivityProperties struct {
	// DatabaseName - READ-ONLY; The database name.
	DatabaseName *string `json:"databaseName,omitempty"`
	// EndTime - READ-ONLY; The time the operation finished (ISO8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// ErrorCode - READ-ONLY; The error code if available.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorMessage - READ-ONLY; The error message if available.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// ErrorSeverity - READ-ONLY; The error severity if available.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty"`
	// Operation - READ-ONLY; The operation name.
	Operation *string `json:"operation,omitempty"`
	// OperationID - READ-ONLY; The unique operation ID.
	OperationID *uuid.UUID `json:"operationId,omitempty"`
	// PercentComplete - READ-ONLY; The percentage complete if available.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// RequestedElasticPoolName - READ-ONLY; The name for the elastic pool the database is moving into if available.
	RequestedElasticPoolName *string `json:"requestedElasticPoolName,omitempty"`
	// CurrentElasticPoolName - READ-ONLY; The name of the current elastic pool the database is in if available.
	CurrentElasticPoolName *string `json:"currentElasticPoolName,omitempty"`
	// CurrentServiceObjective - READ-ONLY; The name of the current service objective if available.
	CurrentServiceObjective *string `json:"currentServiceObjective,omitempty"`
	// RequestedServiceObjective - READ-ONLY; The name of the requested service objective if available.
	RequestedServiceObjective *string `json:"requestedServiceObjective,omitempty"`
	// ServerName - READ-ONLY; The name of the server the elastic pool is in.
	ServerName *string `json:"serverName,omitempty"`
	// StartTime - READ-ONLY; The time the operation started (ISO8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// State - READ-ONLY; The current state of the operation.
	State *string `json:"state,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolDatabaseActivityProperties.
func (epdap ElasticPoolDatabaseActivityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ElasticPoolDtuCapability the Elastic Pool DTU capability.
type ElasticPoolDtuCapability struct {
	// Limit - READ-ONLY; The maximum size of the database (see 'unit' for the units).
	Limit *int64 `json:"limit,omitempty"`
	// MaxDatabaseCount - READ-ONLY; The maximum number of databases supported.
	MaxDatabaseCount *int64 `json:"maxDatabaseCount,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// SupportedMaxSizes - READ-ONLY; The list of supported max sizes.
	SupportedMaxSizes *[]MaxSizeCapability `json:"supportedMaxSizes,omitempty"`
	// IncludedMaxSize - READ-ONLY; The included (free) max size for this service level objective.
	IncludedMaxSize *MaxSizeCapability `json:"includedMaxSize,omitempty"`
	// SupportedPerDatabaseMaxSizes - READ-ONLY; The list of supported max database sizes.
	SupportedPerDatabaseMaxSizes *[]MaxSizeCapability `json:"supportedPerDatabaseMaxSizes,omitempty"`
	// SupportedPerDatabaseMaxDtus - READ-ONLY; The list of supported max database DTUs.
	SupportedPerDatabaseMaxDtus *[]ElasticPoolPerDatabaseMaxDtuCapability `json:"supportedPerDatabaseMaxDtus,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolDtuCapability.
func (epdc ElasticPoolDtuCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ElasticPoolEditionCapability the elastic pool edition capabilities.
type ElasticPoolEditionCapability struct {
	// Name - READ-ONLY; The elastic pool edition name.
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; The status of the elastic pool edition. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// SupportedElasticPoolDtus - READ-ONLY; The list of supported elastic pool DTU levels for the edition.
	SupportedElasticPoolDtus *[]ElasticPoolDtuCapability `json:"supportedElasticPoolDtus,omitempty"`
	// ZoneRedundant - READ-ONLY; Whether or not zone redundancy is supported for the edition.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolEditionCapability.
func (epec ElasticPoolEditionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ElasticPoolListResult represents the response to a list elastic pool request.
type ElasticPoolListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of elastic pools hosted in the server.
	Value *[]ElasticPool `json:"value,omitempty"`
}

// ElasticPoolPerDatabaseMaxDtuCapability the max per-database DTU capability.
type ElasticPoolPerDatabaseMaxDtuCapability struct {
	// Limit - READ-ONLY; The maximum DTUs per database.
	Limit *int64 `json:"limit,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// SupportedPerDatabaseMinDtus - READ-ONLY; The list of supported min database DTUs.
	SupportedPerDatabaseMinDtus *[]ElasticPoolPerDatabaseMinDtuCapability `json:"supportedPerDatabaseMinDtus,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolPerDatabaseMaxDtuCapability.
func (eppdmdc ElasticPoolPerDatabaseMaxDtuCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ElasticPoolPerDatabaseMinDtuCapability the minimum per-database DTU capability.
type ElasticPoolPerDatabaseMinDtuCapability struct {
	// Limit - READ-ONLY; The maximum DTUs per database.
	Limit *int64 `json:"limit,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolPerDatabaseMinDtuCapability.
func (eppdmdc ElasticPoolPerDatabaseMinDtuCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ElasticPoolProperties represents the properties of an elastic pool.
type ElasticPoolProperties struct {
	// CreationDate - READ-ONLY; The creation date of the elastic pool (ISO8601 format).
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// State - READ-ONLY; The state of the elastic pool. Possible values include: 'ElasticPoolStateCreating', 'ElasticPoolStateReady', 'ElasticPoolStateDisabled'
	State ElasticPoolState `json:"state,omitempty"`
	// Edition - The edition of the elastic pool. Possible values include: 'ElasticPoolEditionBasic', 'ElasticPoolEditionStandard', 'ElasticPoolEditionPremium', 'ElasticPoolEditionGeneralPurpose', 'ElasticPoolEditionBusinessCritical'
	Edition ElasticPoolEdition `json:"edition,omitempty"`
	// Dtu - The total shared DTU for the database elastic pool.
	Dtu *int32 `json:"dtu,omitempty"`
	// DatabaseDtuMax - The maximum DTU any one database can consume.
	DatabaseDtuMax *int32 `json:"databaseDtuMax,omitempty"`
	// DatabaseDtuMin - The minimum DTU all databases are guaranteed.
	DatabaseDtuMin *int32 `json:"databaseDtuMin,omitempty"`
	// StorageMB - Gets storage limit for the database elastic pool in MB.
	StorageMB *int32 `json:"storageMB,omitempty"`
	// ZoneRedundant - Whether or not this database elastic pool is zone redundant, which means the replicas of this database will be spread across multiple availability zones.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolProperties.
func (epp ElasticPoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epp.Edition != "" {
		objectMap["edition"] = epp.Edition
	}
	if epp.Dtu != nil {
		objectMap["dtu"] = epp.Dtu
	}
	if epp.DatabaseDtuMax != nil {
		objectMap["databaseDtuMax"] = epp.DatabaseDtuMax
	}
	if epp.DatabaseDtuMin != nil {
		objectMap["databaseDtuMin"] = epp.DatabaseDtuMin
	}
	if epp.StorageMB != nil {
		objectMap["storageMB"] = epp.StorageMB
	}
	if epp.ZoneRedundant != nil {
		objectMap["zoneRedundant"] = epp.ZoneRedundant
	}
	return json.Marshal(objectMap)
}

// ElasticPoolsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ElasticPoolsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ElasticPoolsClient) (ElasticPool, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ElasticPoolsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ElasticPoolsCreateOrUpdateFuture.Result.
func (future *ElasticPoolsCreateOrUpdateFuture) result(client ElasticPoolsClient) (ep ElasticPool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ElasticPoolsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ep.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ElasticPoolsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ep.Response.Response, err = future.GetResult(sender); err == nil && ep.Response.Response.StatusCode != http.StatusNoContent {
		ep, err = client.CreateOrUpdateResponder(ep.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ElasticPoolsCreateOrUpdateFuture", "Result", ep.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ElasticPoolsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ElasticPoolsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ElasticPoolsClient) (ElasticPool, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ElasticPoolsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ElasticPoolsUpdateFuture.Result.
func (future *ElasticPoolsUpdateFuture) result(client ElasticPoolsClient) (ep ElasticPool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ElasticPoolsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ep.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ElasticPoolsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ep.Response.Response, err = future.GetResult(sender); err == nil && ep.Response.Response.StatusCode != http.StatusNoContent {
		ep, err = client.UpdateResponder(ep.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ElasticPoolsUpdateFuture", "Result", ep.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ElasticPoolUpdate represents an elastic pool update.
type ElasticPoolUpdate struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ElasticPoolProperties - The properties representing the resource.
	*ElasticPoolProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolUpdate.
func (epu ElasticPoolUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epu.Tags != nil {
		objectMap["tags"] = epu.Tags
	}
	if epu.ElasticPoolProperties != nil {
		objectMap["properties"] = epu.ElasticPoolProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPoolUpdate struct.
func (epu *ElasticPoolUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				epu.Tags = tags
			}
		case "properties":
			if v != nil {
				var elasticPoolProperties ElasticPoolProperties
				err = json.Unmarshal(*v, &elasticPoolProperties)
				if err != nil {
					return err
				}
				epu.ElasticPoolProperties = &elasticPoolProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				epu.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				epu.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				epu.Type = &typeVar
			}
		}
	}

	return nil
}

// ExportRequest export database parameters.
type ExportRequest struct {
	// StorageKeyType - The type of the storage key to use. Possible values include: 'StorageAccessKey', 'SharedAccessKey'
	StorageKeyType StorageKeyType `json:"storageKeyType,omitempty"`
	// StorageKey - The storage key to use.  If storage key type is SharedAccessKey, it must be preceded with a "?."
	StorageKey *string `json:"storageKey,omitempty"`
	// StorageURI - The storage uri to use.
	StorageURI *string `json:"storageUri,omitempty"`
	// AdministratorLogin - The name of the SQL administrator.
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - The password of the SQL administrator.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// AuthenticationType - The authentication type. Possible values include: 'SQL', 'ADPassword'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
}

// ExtensionListResult represents the response to a list extensions request.
type ExtensionListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of extensions.
	Value *[]interface{} `json:"value,omitempty"`
}

// FirewallRule represents a server firewall rule.
type FirewallRule struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Kind of server that contains this firewall rule.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Location of the server that contains this firewall rule.
	Location *string `json:"location,omitempty"`
	// FirewallRuleProperties - The properties representing the resource.
	*FirewallRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FirewallRule.
func (fr FirewallRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fr.FirewallRuleProperties != nil {
		objectMap["properties"] = fr.FirewallRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FirewallRule struct.
func (fr *FirewallRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				fr.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				fr.Location = &location
			}
		case "properties":
			if v != nil {
				var firewallRuleProperties FirewallRuleProperties
				err = json.Unmarshal(*v, &firewallRuleProperties)
				if err != nil {
					return err
				}
				fr.FirewallRuleProperties = &firewallRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fr.Type = &typeVar
			}
		}
	}

	return nil
}

// FirewallRuleListResult represents the response to a List Firewall Rules request.
type FirewallRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of server firewall rules.
	Value *[]FirewallRule `json:"value,omitempty"`
}

// FirewallRuleProperties represents the properties of a server firewall rule.
type FirewallRuleProperties struct {
	// StartIPAddress - The start IP address of the firewall rule. Must be IPv4 format. Use value '0.0.0.0' to represent all Azure-internal IP addresses.
	StartIPAddress *string `json:"startIpAddress,omitempty"`
	// EndIPAddress - The end IP address of the firewall rule. Must be IPv4 format. Must be greater than or equal to startIpAddress. Use value '0.0.0.0' to represent all Azure-internal IP addresses.
	EndIPAddress *string `json:"endIpAddress,omitempty"`
}

// GeoBackupPolicy a database geo backup policy.
type GeoBackupPolicy struct {
	autorest.Response `json:"-"`
	// GeoBackupPolicyProperties - The properties of the geo backup policy.
	*GeoBackupPolicyProperties `json:"properties,omitempty"`
	// Kind - READ-ONLY; Kind of geo backup policy.  This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Backup policy location.
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for GeoBackupPolicy.
func (gbp GeoBackupPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gbp.GeoBackupPolicyProperties != nil {
		objectMap["properties"] = gbp.GeoBackupPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GeoBackupPolicy struct.
func (gbp *GeoBackupPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var geoBackupPolicyProperties GeoBackupPolicyProperties
				err = json.Unmarshal(*v, &geoBackupPolicyProperties)
				if err != nil {
					return err
				}
				gbp.GeoBackupPolicyProperties = &geoBackupPolicyProperties
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				gbp.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gbp.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gbp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gbp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gbp.Type = &typeVar
			}
		}
	}

	return nil
}

// GeoBackupPolicyListResult the response to a list geo backup policies request.
type GeoBackupPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of geo backup policies.
	Value *[]GeoBackupPolicy `json:"value,omitempty"`
}

// GeoBackupPolicyProperties the properties of the geo backup policy.
type GeoBackupPolicyProperties struct {
	// State - The state of the geo backup policy. Possible values include: 'GeoBackupPolicyStateDisabled', 'GeoBackupPolicyStateEnabled'
	State GeoBackupPolicyState `json:"state,omitempty"`
	// StorageType - READ-ONLY; The storage type of the geo backup policy.
	StorageType *string `json:"storageType,omitempty"`
}

// MarshalJSON is the custom marshaler for GeoBackupPolicyProperties.
func (gbpp GeoBackupPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gbpp.State != "" {
		objectMap["state"] = gbpp.State
	}
	return json.Marshal(objectMap)
}

// ImportExportResponse response for Import/Export Get operation.
type ImportExportResponse struct {
	autorest.Response `json:"-"`
	// ImportExportResponseProperties - The import/export operation properties.
	*ImportExportResponseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImportExportResponse.
func (ier ImportExportResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ier.ImportExportResponseProperties != nil {
		objectMap["properties"] = ier.ImportExportResponseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ImportExportResponse struct.
func (ier *ImportExportResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var importExportResponseProperties ImportExportResponseProperties
				err = json.Unmarshal(*v, &importExportResponseProperties)
				if err != nil {
					return err
				}
				ier.ImportExportResponseProperties = &importExportResponseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ier.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ier.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ier.Type = &typeVar
			}
		}
	}

	return nil
}

// ImportExportResponseProperties response for Import/Export Status operation.
type ImportExportResponseProperties struct {
	// RequestType - READ-ONLY; The request type of the operation.
	RequestType *string `json:"requestType,omitempty"`
	// RequestID - READ-ONLY; The request type of the operation.
	RequestID *uuid.UUID `json:"requestId,omitempty"`
	// ServerName - READ-ONLY; The name of the server.
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - READ-ONLY; The name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Status - READ-ONLY; The status message returned from the server.
	Status *string `json:"status,omitempty"`
	// LastModifiedTime - READ-ONLY; The operation status last modified time.
	LastModifiedTime *string `json:"lastModifiedTime,omitempty"`
	// QueuedTime - READ-ONLY; The operation queued time.
	QueuedTime *string `json:"queuedTime,omitempty"`
	// BlobURI - READ-ONLY; The blob uri.
	BlobURI *string `json:"blobUri,omitempty"`
	// ErrorMessage - READ-ONLY; The error message returned from the server.
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// MarshalJSON is the custom marshaler for ImportExportResponseProperties.
func (ierp ImportExportResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ImportExtensionProperties represents the properties for an import operation
type ImportExtensionProperties struct {
	// OperationMode - The type of import operation being performed. This is always Import.
	OperationMode *string `json:"operationMode,omitempty"`
	// StorageKeyType - The type of the storage key to use. Possible values include: 'StorageAccessKey', 'SharedAccessKey'
	StorageKeyType StorageKeyType `json:"storageKeyType,omitempty"`
	// StorageKey - The storage key to use.  If storage key type is SharedAccessKey, it must be preceded with a "?."
	StorageKey *string `json:"storageKey,omitempty"`
	// StorageURI - The storage uri to use.
	StorageURI *string `json:"storageUri,omitempty"`
	// AdministratorLogin - The name of the SQL administrator.
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - The password of the SQL administrator.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// AuthenticationType - The authentication type. Possible values include: 'SQL', 'ADPassword'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
}

// ImportExtensionRequest import database parameters.
type ImportExtensionRequest struct {
	// Name - The name of the extension.
	Name *string `json:"name,omitempty"`
	// Type - The type of the extension.
	Type *string `json:"type,omitempty"`
	// ImportExtensionProperties - Represents the properties of the resource.
	*ImportExtensionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ImportExtensionRequest.
func (ier ImportExtensionRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ier.Name != nil {
		objectMap["name"] = ier.Name
	}
	if ier.Type != nil {
		objectMap["type"] = ier.Type
	}
	if ier.ImportExtensionProperties != nil {
		objectMap["properties"] = ier.ImportExtensionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ImportExtensionRequest struct.
func (ier *ImportExtensionRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ier.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ier.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var importExtensionProperties ImportExtensionProperties
				err = json.Unmarshal(*v, &importExtensionProperties)
				if err != nil {
					return err
				}
				ier.ImportExtensionProperties = &importExtensionProperties
			}
		}
	}

	return nil
}

// ImportRequest import database parameters.
type ImportRequest struct {
	// DatabaseName - The name of the database to import.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Edition - The edition for the database being created.
	//
	// The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or one of the following commands:
	//
	// ```azurecli
	// az sql db list-editions -l <location> -o table
	// ````
	//
	// ```powershell
	// Get-AzSqlServerServiceObjective -Location <location>
	// ````
	// . Possible values include: 'Web', 'Business', 'Basic', 'Standard', 'Premium', 'PremiumRS', 'Free', 'Stretch', 'DataWarehouse', 'System', 'System2', 'GeneralPurpose', 'BusinessCritical', 'Hyperscale'
	Edition DatabaseEdition `json:"edition,omitempty"`
	// ServiceObjectiveName - The name of the service objective to assign to the database. Possible values include: 'ServiceObjectiveNameSystem', 'ServiceObjectiveNameSystem0', 'ServiceObjectiveNameSystem1', 'ServiceObjectiveNameSystem2', 'ServiceObjectiveNameSystem3', 'ServiceObjectiveNameSystem4', 'ServiceObjectiveNameSystem2L', 'ServiceObjectiveNameSystem3L', 'ServiceObjectiveNameSystem4L', 'ServiceObjectiveNameFree', 'ServiceObjectiveNameBasic', 'ServiceObjectiveNameS0', 'ServiceObjectiveNameS1', 'ServiceObjectiveNameS2', 'ServiceObjectiveNameS3', 'ServiceObjectiveNameS4', 'ServiceObjectiveNameS6', 'ServiceObjectiveNameS7', 'ServiceObjectiveNameS9', 'ServiceObjectiveNameS12', 'ServiceObjectiveNameP1', 'ServiceObjectiveNameP2', 'ServiceObjectiveNameP3', 'ServiceObjectiveNameP4', 'ServiceObjectiveNameP6', 'ServiceObjectiveNameP11', 'ServiceObjectiveNameP15', 'ServiceObjectiveNamePRS1', 'ServiceObjectiveNamePRS2', 'ServiceObjectiveNamePRS4', 'ServiceObjectiveNamePRS6', 'ServiceObjectiveNameDW100', 'ServiceObjectiveNameDW200', 'ServiceObjectiveNameDW300', 'ServiceObjectiveNameDW400', 'ServiceObjectiveNameDW500', 'ServiceObjectiveNameDW600', 'ServiceObjectiveNameDW1000', 'ServiceObjectiveNameDW1200', 'ServiceObjectiveNameDW1000c', 'ServiceObjectiveNameDW1500', 'ServiceObjectiveNameDW1500c', 'ServiceObjectiveNameDW2000', 'ServiceObjectiveNameDW2000c', 'ServiceObjectiveNameDW3000', 'ServiceObjectiveNameDW2500c', 'ServiceObjectiveNameDW3000c', 'ServiceObjectiveNameDW6000', 'ServiceObjectiveNameDW5000c', 'ServiceObjectiveNameDW6000c', 'ServiceObjectiveNameDW7500c', 'ServiceObjectiveNameDW10000c', 'ServiceObjectiveNameDW15000c', 'ServiceObjectiveNameDW30000c', 'ServiceObjectiveNameDS100', 'ServiceObjectiveNameDS200', 'ServiceObjectiveNameDS300', 'ServiceObjectiveNameDS400', 'ServiceObjectiveNameDS500', 'ServiceObjectiveNameDS600', 'ServiceObjectiveNameDS1000', 'ServiceObjectiveNameDS1200', 'ServiceObjectiveNameDS1500', 'ServiceObjectiveNameDS2000', 'ServiceObjectiveNameElasticPool'
	ServiceObjectiveName ServiceObjectiveName `json:"serviceObjectiveName,omitempty"`
	// MaxSizeBytes - The maximum size for the newly imported database.
	MaxSizeBytes *string `json:"maxSizeBytes,omitempty"`
	// StorageKeyType - The type of the storage key to use. Possible values include: 'StorageAccessKey', 'SharedAccessKey'
	StorageKeyType StorageKeyType `json:"storageKeyType,omitempty"`
	// StorageKey - The storage key to use.  If storage key type is SharedAccessKey, it must be preceded with a "?."
	StorageKey *string `json:"storageKey,omitempty"`
	// StorageURI - The storage uri to use.
	StorageURI *string `json:"storageUri,omitempty"`
	// AdministratorLogin - The name of the SQL administrator.
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - The password of the SQL administrator.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// AuthenticationType - The authentication type. Possible values include: 'SQL', 'ADPassword'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
}

// LocationCapabilities the capabilities for a location.
type LocationCapabilities struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; The location name.
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; Azure SQL Database's status for the location. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// SupportedServerVersions - READ-ONLY; The list of supported server versions.
	SupportedServerVersions *[]ServerVersionCapability `json:"supportedServerVersions,omitempty"`
}

// MarshalJSON is the custom marshaler for LocationCapabilities.
func (lc LocationCapabilities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MaxSizeCapability the maximum size limits for a database.
type MaxSizeCapability struct {
	// Limit - READ-ONLY; The maximum size of the database (see 'unit' for the units).
	Limit *int64 `json:"limit,omitempty"`
	// Unit - READ-ONLY; The units that the limit is expressed in. Possible values include: 'Megabytes', 'Gigabytes', 'Terabytes', 'Petabytes'
	Unit MaxSizeUnits `json:"unit,omitempty"`
	// Status - READ-ONLY; The status of the maximum size capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for MaxSizeCapability.
func (msc MaxSizeCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Metric database metrics.
type Metric struct {
	// StartTime - READ-ONLY; The start time for the metric (ISO-8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The end time for the metric (ISO-8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - READ-ONLY; The time step to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Unit - READ-ONLY; The unit of the metric. Possible values include: 'UnitTypeCount', 'UnitTypeBytes', 'UnitTypeSeconds', 'UnitTypePercent', 'UnitTypeCountPerSecond', 'UnitTypeBytesPerSecond'
	Unit UnitType `json:"unit,omitempty"`
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// MetricValues - READ-ONLY; The metric values for the specified time window and timestep.
	MetricValues *[]MetricValue `json:"metricValues,omitempty"`
}

// MarshalJSON is the custom marshaler for Metric.
func (mVar Metric) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MetricAvailability a metric availability value.
type MetricAvailability struct {
	// Retention - READ-ONLY; The length of retention for the database metric.
	Retention *string `json:"retention,omitempty"`
	// TimeGrain - READ-ONLY; The granularity of the database metric.
	TimeGrain *string `json:"timeGrain,omitempty"`
}

// MarshalJSON is the custom marshaler for MetricAvailability.
func (ma MetricAvailability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MetricDefinition a database metric definition.
type MetricDefinition struct {
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// PrimaryAggregationType - READ-ONLY; The primary aggregation type defining how metric values are displayed. Possible values include: 'PrimaryAggregationTypeNone', 'PrimaryAggregationTypeAverage', 'PrimaryAggregationTypeCount', 'PrimaryAggregationTypeMinimum', 'PrimaryAggregationTypeMaximum', 'PrimaryAggregationTypeTotal'
	PrimaryAggregationType PrimaryAggregationType `json:"primaryAggregationType,omitempty"`
	// ResourceURI - READ-ONLY; The resource uri of the database.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// Unit - READ-ONLY; The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond'
	Unit UnitDefinitionType `json:"unit,omitempty"`
	// MetricAvailabilities - READ-ONLY; The list of database metric availabilities for the metric.
	MetricAvailabilities *[]MetricAvailability `json:"metricAvailabilities,omitempty"`
}

// MarshalJSON is the custom marshaler for MetricDefinition.
func (md MetricDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MetricDefinitionListResult the response to a list database metric definitions request.
type MetricDefinitionListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of metric definitions for the database.
	Value *[]MetricDefinition `json:"value,omitempty"`
}

// MetricListResult the response to a list database metrics request.
type MetricListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of metrics for the database.
	Value *[]Metric `json:"value,omitempty"`
}

// MetricName a database metric name.
type MetricName struct {
	// Value - READ-ONLY; The name of the database metric.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - READ-ONLY; The friendly name of the database metric.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// MarshalJSON is the custom marshaler for MetricName.
func (mn MetricName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MetricValue represents database metrics.
type MetricValue struct {
	// Count - READ-ONLY; The number of values for the metric.
	Count *float64 `json:"count,omitempty"`
	// Average - READ-ONLY; The average value of the metric.
	Average *float64 `json:"average,omitempty"`
	// Maximum - READ-ONLY; The max value of the metric.
	Maximum *float64 `json:"maximum,omitempty"`
	// Minimum - READ-ONLY; The min value of the metric.
	Minimum *float64 `json:"minimum,omitempty"`
	// Timestamp - READ-ONLY; The metric timestamp (ISO-8601 format).
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Total - READ-ONLY; The total value of the metric.
	Total *float64 `json:"total,omitempty"`
}

// MarshalJSON is the custom marshaler for MetricValue.
func (mv MetricValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Operation SQL REST API operation definition.
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay display metadata associated with the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft SQL Database.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed: Server, Database, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationImpact the impact of an operation, both in absolute and relative terms.
type OperationImpact struct {
	// Name - READ-ONLY; The name of the impact dimension.
	Name *string `json:"name,omitempty"`
	// Unit - READ-ONLY; The unit in which estimated impact to dimension is measured.
	Unit *string `json:"unit,omitempty"`
	// ChangeValueAbsolute - READ-ONLY; The absolute impact to dimension.
	ChangeValueAbsolute *float64 `json:"changeValueAbsolute,omitempty"`
	// ChangeValueRelative - READ-ONLY; The relative impact to dimension (null if not applicable)
	ChangeValueRelative *float64 `json:"changeValueRelative,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationImpact.
func (oi OperationImpact) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResult result of the request to list SQL operations. It contains a list of operations and a
// URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of SQL operations supported by the SQL resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// PerformanceLevel a possible performance level of a service objective capability.
type PerformanceLevel struct {
	// Unit - READ-ONLY; Unit type used to measure service objective performance level. Possible values include: 'DTU'
	Unit PerformanceLevelUnit `json:"unit,omitempty"`
	// Value - READ-ONLY; Performance level value.
	Value *int32 `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for PerformanceLevel.
func (pl PerformanceLevel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ProxyResource ARM proxy resource.
type ProxyResource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// QueryInterval a database query.
type QueryInterval struct {
	// IntervalStartTime - READ-ONLY; The start time of the measurement interval (ISO8601 format).
	IntervalStartTime *date.Time `json:"intervalStartTime,omitempty"`
	// ExecutionCount - READ-ONLY; The number of times the query was executed during this interval.
	ExecutionCount *float64 `json:"executionCount,omitempty"`
	// Metrics - READ-ONLY; The list of query metrics during this interval.
	Metrics *[]QueryMetric `json:"metrics,omitempty"`
}

// MarshalJSON is the custom marshaler for QueryInterval.
func (qi QueryInterval) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// QueryMetric a database query.
type QueryMetric struct {
	// Name - READ-ONLY; The name of the metric
	Name *string `json:"name,omitempty"`
	// DisplayName - READ-ONLY; The name of the metric for display in user interface
	DisplayName *string `json:"displayName,omitempty"`
	// Unit - READ-ONLY; The unit of measurement. Possible values include: 'Percentage', 'KB', 'Microseconds'
	Unit QueryMetricUnit `json:"unit,omitempty"`
	// Value - READ-ONLY; The measured value
	Value *float64 `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for QueryMetric.
func (qm QueryMetric) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// QueryStatistic a database query.
type QueryStatistic struct {
	// QueryID - READ-ONLY; The id of the query
	QueryID *string `json:"queryId,omitempty"`
	// Intervals - READ-ONLY; The list of query intervals.
	Intervals *[]QueryInterval `json:"intervals,omitempty"`
}

// MarshalJSON is the custom marshaler for QueryStatistic.
func (qs QueryStatistic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// QueryStatisticListResult represents the response to a get query request.
type QueryStatisticListResult struct {
	autorest.Response `json:"-"`
	// Value - The query.
	Value *[]QueryStatistic `json:"value,omitempty"`
}

// QueryText ...
type QueryText struct {
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// QueryText - READ-ONLY; Query text.
	QueryText *string `json:"queryText,omitempty"`
}

// MarshalJSON is the custom marshaler for QueryText.
func (qt QueryText) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// QueryTextListResult represents the response to a get query text request.
type QueryTextListResult struct {
	autorest.Response `json:"-"`
	// Value - The query text.
	Value *[]QueryText `json:"value,omitempty"`
}

// RecommendedElasticPool represents a recommended elastic pool.
type RecommendedElasticPool struct {
	autorest.Response `json:"-"`
	// RecommendedElasticPoolProperties - The properties representing the resource.
	*RecommendedElasticPoolProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RecommendedElasticPool.
func (rep RecommendedElasticPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rep.RecommendedElasticPoolProperties != nil {
		objectMap["properties"] = rep.RecommendedElasticPoolProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RecommendedElasticPool struct.
func (rep *RecommendedElasticPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var recommendedElasticPoolProperties RecommendedElasticPoolProperties
				err = json.Unmarshal(*v, &recommendedElasticPoolProperties)
				if err != nil {
					return err
				}
				rep.RecommendedElasticPoolProperties = &recommendedElasticPoolProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rep.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rep.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rep.Type = &typeVar
			}
		}
	}

	return nil
}

// RecommendedElasticPoolListMetricsResult represents the response to a list recommended elastic pool
// metrics request.
type RecommendedElasticPoolListMetricsResult struct {
	autorest.Response `json:"-"`
	// Value - The list of recommended elastic pools metrics.
	Value *[]RecommendedElasticPoolMetric `json:"value,omitempty"`
}

// RecommendedElasticPoolListResult represents the response to a list recommended elastic pool request.
type RecommendedElasticPoolListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of recommended elastic pools hosted in the server.
	Value *[]RecommendedElasticPool `json:"value,omitempty"`
}

// RecommendedElasticPoolMetric represents recommended elastic pool metric.
type RecommendedElasticPoolMetric struct {
	// DateTime - The time of metric (ISO8601 format).
	DateTime *date.Time `json:"dateTime,omitempty"`
	// Dtu - Gets or sets the DTUs (Database Transaction Units). See https://azure.microsoft.com/documentation/articles/sql-database-what-is-a-dtu/
	Dtu *float64 `json:"dtu,omitempty"`
	// SizeGB - Gets or sets size in gigabytes.
	SizeGB *float64 `json:"sizeGB,omitempty"`
}

// RecommendedElasticPoolProperties represents the properties of a recommended elastic pool.
type RecommendedElasticPoolProperties struct {
	// DatabaseEdition - READ-ONLY; The edition of the recommended elastic pool. The ElasticPoolEdition enumeration contains all the valid editions. Possible values include: 'ElasticPoolEditionBasic', 'ElasticPoolEditionStandard', 'ElasticPoolEditionPremium', 'ElasticPoolEditionGeneralPurpose', 'ElasticPoolEditionBusinessCritical'
	DatabaseEdition ElasticPoolEdition `json:"databaseEdition,omitempty"`
	// Dtu - The DTU for the recommended elastic pool.
	Dtu *float64 `json:"dtu,omitempty"`
	// DatabaseDtuMin - The minimum DTU for the database.
	DatabaseDtuMin *float64 `json:"databaseDtuMin,omitempty"`
	// DatabaseDtuMax - The maximum DTU for the database.
	DatabaseDtuMax *float64 `json:"databaseDtuMax,omitempty"`
	// StorageMB - Gets storage size in megabytes.
	StorageMB *float64 `json:"storageMB,omitempty"`
	// ObservationPeriodStart - READ-ONLY; The observation period start (ISO8601 format).
	ObservationPeriodStart *date.Time `json:"observationPeriodStart,omitempty"`
	// ObservationPeriodEnd - READ-ONLY; The observation period start (ISO8601 format).
	ObservationPeriodEnd *date.Time `json:"observationPeriodEnd,omitempty"`
	// MaxObservedDtu - READ-ONLY; Gets maximum observed DTU.
	MaxObservedDtu *float64 `json:"maxObservedDtu,omitempty"`
	// MaxObservedStorageMB - READ-ONLY; Gets maximum observed storage in megabytes.
	MaxObservedStorageMB *float64 `json:"maxObservedStorageMB,omitempty"`
	// Databases - READ-ONLY; The list of databases in this pool. Expanded property
	Databases *[]Database `json:"databases,omitempty"`
	// Metrics - READ-ONLY; The list of databases housed in the server. Expanded property
	Metrics *[]RecommendedElasticPoolMetric `json:"metrics,omitempty"`
}

// MarshalJSON is the custom marshaler for RecommendedElasticPoolProperties.
func (repp RecommendedElasticPoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if repp.Dtu != nil {
		objectMap["dtu"] = repp.Dtu
	}
	if repp.DatabaseDtuMin != nil {
		objectMap["databaseDtuMin"] = repp.DatabaseDtuMin
	}
	if repp.DatabaseDtuMax != nil {
		objectMap["databaseDtuMax"] = repp.DatabaseDtuMax
	}
	if repp.StorageMB != nil {
		objectMap["storageMB"] = repp.StorageMB
	}
	return json.Marshal(objectMap)
}

// RecommendedIndex represents a database recommended index.
type RecommendedIndex struct {
	// RecommendedIndexProperties - READ-ONLY; The properties representing the resource.
	*RecommendedIndexProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RecommendedIndex.
func (ri RecommendedIndex) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RecommendedIndex struct.
func (ri *RecommendedIndex) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var recommendedIndexProperties RecommendedIndexProperties
				err = json.Unmarshal(*v, &recommendedIndexProperties)
				if err != nil {
					return err
				}
				ri.RecommendedIndexProperties = &recommendedIndexProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ri.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ri.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ri.Type = &typeVar
			}
		}
	}

	return nil
}

// RecommendedIndexProperties represents the properties of a database recommended index.
type RecommendedIndexProperties struct {
	// Action - READ-ONLY; The proposed index action. You can create a missing index, drop an unused index, or rebuild an existing index to improve its performance. Possible values include: 'Create', 'Drop', 'Rebuild'
	Action RecommendedIndexAction `json:"action,omitempty"`
	// State - READ-ONLY; The current recommendation state. Possible values include: 'Active', 'Pending', 'Executing', 'Verifying', 'PendingRevert', 'Reverting', 'Reverted', 'Ignored', 'Expired', 'Blocked', 'Success'
	State RecommendedIndexState `json:"state,omitempty"`
	// Created - READ-ONLY; The UTC datetime showing when this resource was created (ISO8601 format).
	Created *date.Time `json:"created,omitempty"`
	// LastModified - READ-ONLY; The UTC datetime of when was this resource last changed (ISO8601 format).
	LastModified *date.Time `json:"lastModified,omitempty"`
	// IndexType - READ-ONLY; The type of index (CLUSTERED, NONCLUSTERED, COLUMNSTORE, CLUSTERED COLUMNSTORE). Possible values include: 'CLUSTERED', 'NONCLUSTERED', 'COLUMNSTORE', 'CLUSTEREDCOLUMNSTORE'
	IndexType RecommendedIndexType `json:"indexType,omitempty"`
	// Schema - READ-ONLY; The schema where table to build index over resides
	Schema *string `json:"schema,omitempty"`
	// Table - READ-ONLY; The table on which to build index.
	Table *string `json:"table,omitempty"`
	// Columns - READ-ONLY; Columns over which to build index
	Columns *[]string `json:"columns,omitempty"`
	// IncludedColumns - READ-ONLY; The list of column names to be included in the index
	IncludedColumns *[]string `json:"includedColumns,omitempty"`
	// IndexScript - READ-ONLY; The full build index script
	IndexScript *string `json:"indexScript,omitempty"`
	// EstimatedImpact - READ-ONLY; The estimated impact of doing recommended index action.
	EstimatedImpact *[]OperationImpact `json:"estimatedImpact,omitempty"`
	// ReportedImpact - READ-ONLY; The values reported after index action is complete.
	ReportedImpact *[]OperationImpact `json:"reportedImpact,omitempty"`
}

// MarshalJSON is the custom marshaler for RecommendedIndexProperties.
func (rip RecommendedIndexProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RecoverableDatabase a recoverable database
type RecoverableDatabase struct {
	autorest.Response `json:"-"`
	// RecoverableDatabaseProperties - The properties of a recoverable database
	*RecoverableDatabaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoverableDatabase.
func (rd RecoverableDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rd.RecoverableDatabaseProperties != nil {
		objectMap["properties"] = rd.RecoverableDatabaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RecoverableDatabase struct.
func (rd *RecoverableDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var recoverableDatabaseProperties RecoverableDatabaseProperties
				err = json.Unmarshal(*v, &recoverableDatabaseProperties)
				if err != nil {
					return err
				}
				rd.RecoverableDatabaseProperties = &recoverableDatabaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rd.Type = &typeVar
			}
		}
	}

	return nil
}

// RecoverableDatabaseListResult the response to a list recoverable databases request
type RecoverableDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of recoverable databases
	Value *[]RecoverableDatabase `json:"value,omitempty"`
}

// RecoverableDatabaseProperties the properties of a recoverable database
type RecoverableDatabaseProperties struct {
	// Edition - READ-ONLY; The edition of the database
	Edition *string `json:"edition,omitempty"`
	// ServiceLevelObjective - READ-ONLY; The service level objective name of the database
	ServiceLevelObjective *string `json:"serviceLevelObjective,omitempty"`
	// ElasticPoolName - READ-ONLY; The elastic pool name of the database
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// LastAvailableBackupDate - READ-ONLY; The last available backup date of the database (ISO8601 format)
	LastAvailableBackupDate *date.Time `json:"lastAvailableBackupDate,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoverableDatabaseProperties.
func (rdp RecoverableDatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ReplicationLink represents a database replication link.
type ReplicationLink struct {
	autorest.Response `json:"-"`
	// Location - READ-ONLY; Location of the server that contains this firewall rule.
	Location *string `json:"location,omitempty"`
	// ReplicationLinkProperties - The properties representing the resource.
	*ReplicationLinkProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ReplicationLink.
func (rl ReplicationLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rl.ReplicationLinkProperties != nil {
		objectMap["properties"] = rl.ReplicationLinkProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ReplicationLink struct.
func (rl *ReplicationLink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rl.Location = &location
			}
		case "properties":
			if v != nil {
				var replicationLinkProperties ReplicationLinkProperties
				err = json.Unmarshal(*v, &replicationLinkProperties)
				if err != nil {
					return err
				}
				rl.ReplicationLinkProperties = &replicationLinkProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rl.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rl.Type = &typeVar
			}
		}
	}

	return nil
}

// ReplicationLinkListResult represents the response to a List database replication link request.
type ReplicationLinkListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of database replication links housed in the database.
	Value *[]ReplicationLink `json:"value,omitempty"`
}

// ReplicationLinkProperties represents the properties of a database replication link.
type ReplicationLinkProperties struct {
	// IsTerminationAllowed - READ-ONLY; Legacy value indicating whether termination is allowed.  Currently always returns true.
	IsTerminationAllowed *bool `json:"isTerminationAllowed,omitempty"`
	// ReplicationMode - READ-ONLY; Replication mode of this replication link.
	ReplicationMode *string `json:"replicationMode,omitempty"`
	// PartnerServer - READ-ONLY; The name of the server hosting the partner database.
	PartnerServer *string `json:"partnerServer,omitempty"`
	// PartnerDatabase - READ-ONLY; The name of the partner database.
	PartnerDatabase *string `json:"partnerDatabase,omitempty"`
	// PartnerLocation - READ-ONLY; The Azure Region of the partner database.
	PartnerLocation *string `json:"partnerLocation,omitempty"`
	// Role - READ-ONLY; The role of the database in the replication link. Possible values include: 'ReplicationRolePrimary', 'ReplicationRoleSecondary', 'ReplicationRoleNonReadableSecondary', 'ReplicationRoleSource', 'ReplicationRoleCopy'
	Role ReplicationRole `json:"role,omitempty"`
	// PartnerRole - READ-ONLY; The role of the partner database in the replication link. Possible values include: 'ReplicationRolePrimary', 'ReplicationRoleSecondary', 'ReplicationRoleNonReadableSecondary', 'ReplicationRoleSource', 'ReplicationRoleCopy'
	PartnerRole ReplicationRole `json:"partnerRole,omitempty"`
	// StartTime - READ-ONLY; The start time for the replication link.
	StartTime *date.Time `json:"startTime,omitempty"`
	// PercentComplete - READ-ONLY; The percentage of seeding complete for the replication link.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// ReplicationState - READ-ONLY; The replication state for the replication link. Possible values include: 'PENDING', 'SEEDING', 'CATCHUP', 'SUSPENDED'
	ReplicationState ReplicationState `json:"replicationState,omitempty"`
}

// MarshalJSON is the custom marshaler for ReplicationLinkProperties.
func (rlp ReplicationLinkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ReplicationLinksFailoverAllowDataLossFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type ReplicationLinksFailoverAllowDataLossFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationLinksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationLinksFailoverAllowDataLossFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationLinksFailoverAllowDataLossFuture.Result.
func (future *ReplicationLinksFailoverAllowDataLossFuture) result(client ReplicationLinksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ReplicationLinksFailoverAllowDataLossFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ReplicationLinksFailoverAllowDataLossFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationLinksFailoverFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationLinksFailoverFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationLinksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationLinksFailoverFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationLinksFailoverFuture.Result.
func (future *ReplicationLinksFailoverFuture) result(client ReplicationLinksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ReplicationLinksFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ReplicationLinksFailoverFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationLinksUnlinkFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationLinksUnlinkFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationLinksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationLinksUnlinkFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationLinksUnlinkFuture.Result.
func (future *ReplicationLinksUnlinkFuture) result(client ReplicationLinksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ReplicationLinksUnlinkFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ReplicationLinksUnlinkFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Resource ARM resource.
type Resource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RestorableDroppedDatabase a restorable dropped database
type RestorableDroppedDatabase struct {
	autorest.Response `json:"-"`
	// Location - READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// RestorableDroppedDatabaseProperties - The properties of a restorable dropped database
	*RestorableDroppedDatabaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorableDroppedDatabase.
func (rdd RestorableDroppedDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rdd.RestorableDroppedDatabaseProperties != nil {
		objectMap["properties"] = rdd.RestorableDroppedDatabaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestorableDroppedDatabase struct.
func (rdd *RestorableDroppedDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rdd.Location = &location
			}
		case "properties":
			if v != nil {
				var restorableDroppedDatabaseProperties RestorableDroppedDatabaseProperties
				err = json.Unmarshal(*v, &restorableDroppedDatabaseProperties)
				if err != nil {
					return err
				}
				rdd.RestorableDroppedDatabaseProperties = &restorableDroppedDatabaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rdd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rdd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rdd.Type = &typeVar
			}
		}
	}

	return nil
}

// RestorableDroppedDatabaseListResult the response to a list restorable dropped databases request
type RestorableDroppedDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of restorable dropped databases
	Value *[]RestorableDroppedDatabase `json:"value,omitempty"`
}

// RestorableDroppedDatabaseProperties the properties of a restorable dropped database
type RestorableDroppedDatabaseProperties struct {
	// DatabaseName - READ-ONLY; The name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// Edition - READ-ONLY; The edition of the database
	Edition *string `json:"edition,omitempty"`
	// MaxSizeBytes - READ-ONLY; The max size in bytes of the database
	MaxSizeBytes *string `json:"maxSizeBytes,omitempty"`
	// ServiceLevelObjective - READ-ONLY; The service level objective name of the database
	ServiceLevelObjective *string `json:"serviceLevelObjective,omitempty"`
	// ElasticPoolName - READ-ONLY; The elastic pool name of the database
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// CreationDate - READ-ONLY; The creation date of the database (ISO8601 format)
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// DeletionDate - READ-ONLY; The deletion date of the database (ISO8601 format)
	DeletionDate *date.Time `json:"deletionDate,omitempty"`
	// EarliestRestoreDate - READ-ONLY; The earliest restore date of the database (ISO8601 format)
	EarliestRestoreDate *date.Time `json:"earliestRestoreDate,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorableDroppedDatabaseProperties.
func (rddp RestorableDroppedDatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RestorePoint a database restore point.
type RestorePoint struct {
	// RestorePointProperties - The properties of the restore point.
	*RestorePointProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorePoint.
func (rp RestorePoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.RestorePointProperties != nil {
		objectMap["properties"] = rp.RestorePointProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestorePoint struct.
func (rp *RestorePoint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var restorePointProperties RestorePointProperties
				err = json.Unmarshal(*v, &restorePointProperties)
				if err != nil {
					return err
				}
				rp.RestorePointProperties = &restorePointProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rp.Type = &typeVar
			}
		}
	}

	return nil
}

// RestorePointListResult the response to a list database restore points request.
type RestorePointListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of database restore points.
	Value *[]RestorePoint `json:"value,omitempty"`
}

// RestorePointProperties represents the properties of a database restore point.
type RestorePointProperties struct {
	// RestorePointType - READ-ONLY; The restore point type of the database restore point. Possible values include: 'DISCRETE', 'CONTINUOUS'
	RestorePointType RestorePointType `json:"restorePointType,omitempty"`
	// RestorePointCreationDate - READ-ONLY; Restore point creation time (ISO8601 format). Populated when restorePointType = CONTINUOUS. Null otherwise.
	RestorePointCreationDate *date.Time `json:"restorePointCreationDate,omitempty"`
	// EarliestRestoreDate - READ-ONLY; Earliest restore time (ISO8601 format). Populated when restorePointType = DISCRETE. Null otherwise.
	EarliestRestoreDate *date.Time `json:"earliestRestoreDate,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorePointProperties.
func (rpp RestorePointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Server represents a server.
type Server struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Kind of sql server.  This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// ServerProperties - Represents the properties of the resource.
	*ServerProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Server.
func (s Server) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.ServerProperties != nil {
		objectMap["properties"] = s.ServerProperties
	}
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Server struct.
func (s *Server) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				s.Kind = &kind
			}
		case "properties":
			if v != nil {
				var serverProperties ServerProperties
				err = json.Unmarshal(*v, &serverProperties)
				if err != nil {
					return err
				}
				s.ServerProperties = &serverProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerAdministratorListResult the response to a list Active Directory Administrators request.
type ServerAdministratorListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of server Active Directory Administrators for the server.
	Value *[]ServerAzureADAdministrator `json:"value,omitempty"`
}

// ServerAdministratorProperties the properties of an server Administrator.
type ServerAdministratorProperties struct {
	// AdministratorType - The type of administrator.
	AdministratorType *string `json:"administratorType,omitempty"`
	// Login - The server administrator login value.
	Login *string `json:"login,omitempty"`
	// Sid - The server administrator Sid (Secure ID).
	Sid *uuid.UUID `json:"sid,omitempty"`
	// TenantID - The server Active Directory Administrator tenant id.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
}

// ServerAzureADAdministrator an server Active Directory Administrator.
type ServerAzureADAdministrator struct {
	autorest.Response `json:"-"`
	// ServerAdministratorProperties - The properties of the resource.
	*ServerAdministratorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerAzureADAdministrator.
func (saaa ServerAzureADAdministrator) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if saaa.ServerAdministratorProperties != nil {
		objectMap["properties"] = saaa.ServerAdministratorProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerAzureADAdministrator struct.
func (saaa *ServerAzureADAdministrator) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverAdministratorProperties ServerAdministratorProperties
				err = json.Unmarshal(*v, &serverAdministratorProperties)
				if err != nil {
					return err
				}
				saaa.ServerAdministratorProperties = &serverAdministratorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				saaa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				saaa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				saaa.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerAzureADAdministratorsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ServerAzureADAdministratorsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServerAzureADAdministratorsClient) (ServerAzureADAdministrator, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServerAzureADAdministratorsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServerAzureADAdministratorsCreateOrUpdateFuture.Result.
func (future *ServerAzureADAdministratorsCreateOrUpdateFuture) result(client ServerAzureADAdministratorsClient) (saaa ServerAzureADAdministrator, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerAzureADAdministratorsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		saaa.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ServerAzureADAdministratorsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if saaa.Response.Response, err = future.GetResult(sender); err == nil && saaa.Response.Response.StatusCode != http.StatusNoContent {
		saaa, err = client.CreateOrUpdateResponder(saaa.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ServerAzureADAdministratorsCreateOrUpdateFuture", "Result", saaa.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerAzureADAdministratorsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ServerAzureADAdministratorsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServerAzureADAdministratorsClient) (ServerAzureADAdministrator, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServerAzureADAdministratorsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServerAzureADAdministratorsDeleteFuture.Result.
func (future *ServerAzureADAdministratorsDeleteFuture) result(client ServerAzureADAdministratorsClient) (saaa ServerAzureADAdministrator, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerAzureADAdministratorsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		saaa.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ServerAzureADAdministratorsDeleteFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if saaa.Response.Response, err = future.GetResult(sender); err == nil && saaa.Response.Response.StatusCode != http.StatusNoContent {
		saaa, err = client.DeleteResponder(saaa.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ServerAzureADAdministratorsDeleteFuture", "Result", saaa.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerCommunicationLink server communication link.
type ServerCommunicationLink struct {
	autorest.Response `json:"-"`
	// ServerCommunicationLinkProperties - The properties of resource.
	*ServerCommunicationLinkProperties `json:"properties,omitempty"`
	// Location - READ-ONLY; Communication link location.
	Location *string `json:"location,omitempty"`
	// Kind - READ-ONLY; Communication link kind.  This property is used for Azure Portal metadata.
	Kind *string `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerCommunicationLink.
func (scl ServerCommunicationLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scl.ServerCommunicationLinkProperties != nil {
		objectMap["properties"] = scl.ServerCommunicationLinkProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerCommunicationLink struct.
func (scl *ServerCommunicationLink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverCommunicationLinkProperties ServerCommunicationLinkProperties
				err = json.Unmarshal(*v, &serverCommunicationLinkProperties)
				if err != nil {
					return err
				}
				scl.ServerCommunicationLinkProperties = &serverCommunicationLinkProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				scl.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				scl.Kind = &kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				scl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scl.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				scl.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerCommunicationLinkListResult a list of server communication links.
type ServerCommunicationLinkListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of server communication links.
	Value *[]ServerCommunicationLink `json:"value,omitempty"`
}

// ServerCommunicationLinkProperties the properties of a server communication link.
type ServerCommunicationLinkProperties struct {
	// State - READ-ONLY; The state.
	State *string `json:"state,omitempty"`
	// PartnerServer - The name of the partner server.
	PartnerServer *string `json:"partnerServer,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerCommunicationLinkProperties.
func (sclp ServerCommunicationLinkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sclp.PartnerServer != nil {
		objectMap["partnerServer"] = sclp.PartnerServer
	}
	return json.Marshal(objectMap)
}

// ServerCommunicationLinksCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type ServerCommunicationLinksCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServerCommunicationLinksClient) (ServerCommunicationLink, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServerCommunicationLinksCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServerCommunicationLinksCreateOrUpdateFuture.Result.
func (future *ServerCommunicationLinksCreateOrUpdateFuture) result(client ServerCommunicationLinksClient) (scl ServerCommunicationLink, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerCommunicationLinksCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		scl.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("sql.ServerCommunicationLinksCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if scl.Response.Response, err = future.GetResult(sender); err == nil && scl.Response.Response.StatusCode != http.StatusNoContent {
		scl, err = client.CreateOrUpdateResponder(scl.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ServerCommunicationLinksCreateOrUpdateFuture", "Result", scl.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerConnectionPolicy a server secure connection policy.
type ServerConnectionPolicy struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// ServerConnectionPolicyProperties - The properties of the server secure connection policy.
	*ServerConnectionPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerConnectionPolicy.
func (scp ServerConnectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scp.ServerConnectionPolicyProperties != nil {
		objectMap["properties"] = scp.ServerConnectionPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerConnectionPolicy struct.
func (scp *ServerConnectionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				scp.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				scp.Location = &location
			}
		case "properties":
			if v != nil {
				var serverConnectionPolicyProperties ServerConnectionPolicyProperties
				err = json.Unmarshal(*v, &serverConnectionPolicyProperties)
				if err != nil {
					return err
				}
				scp.ServerConnectionPolicyProperties = &serverConnectionPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				scp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				scp.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerConnectionPolicyProperties the properties of a server secure connection policy.
type ServerConnectionPolicyProperties struct {
	// ConnectionType - The server connection type. Possible values include: 'ServerConnectionTypeDefault', 'ServerConnectionTypeProxy', 'ServerConnectionTypeRedirect'
	ConnectionType ServerConnectionType `json:"connectionType,omitempty"`
}

// ServerListResult represents the response to a get server request.
type ServerListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of servers.
	Value *[]Server `json:"value,omitempty"`
}

// ServerProperties represents the properties of a server.
type ServerProperties struct {
	// FullyQualifiedDomainName - READ-ONLY; The fully qualified domain name of the server.
	FullyQualifiedDomainName *string `json:"fullyQualifiedDomainName,omitempty"`
	// Version - The version of the server. Possible values include: 'TwoFullStopZero', 'OneTwoFullStopZero'
	Version ServerVersion `json:"version,omitempty"`
	// AdministratorLogin - Administrator username for the server. Can only be specified when the server is being created (and is required for creation).
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - The administrator login password (required for server creation).
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// ExternalAdministratorSid - READ-ONLY; The ID of the Active Azure Directory object with admin permissions on this server. Legacy parameter, always null. To check for Active Directory admin, query .../servers/{serverName}/administrators.
	ExternalAdministratorSid *uuid.UUID `json:"externalAdministratorSid,omitempty"`
	// ExternalAdministratorLogin - READ-ONLY; The display name of the Azure Active Directory object with admin permissions on this server. Legacy parameter, always null. To check for Active Directory admin, query .../servers/{serverName}/administrators
	ExternalAdministratorLogin *string `json:"externalAdministratorLogin,omitempty"`
	// State - READ-ONLY; The state of the server. Possible values include: 'ServerStateReady', 'ServerStateDisabled'
	State ServerState `json:"state,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerProperties.
func (sp ServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.Version != "" {
		objectMap["version"] = sp.Version
	}
	if sp.AdministratorLogin != nil {
		objectMap["administratorLogin"] = sp.AdministratorLogin
	}
	if sp.AdministratorLoginPassword != nil {
		objectMap["administratorLoginPassword"] = sp.AdministratorLoginPassword
	}
	return json.Marshal(objectMap)
}

// ServerTableAuditingPolicy a server table auditing policy.
type ServerTableAuditingPolicy struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Resource kind.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// ServerTableAuditingPolicyProperties - Resource properties.
	*ServerTableAuditingPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerTableAuditingPolicy.
func (stap ServerTableAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if stap.ServerTableAuditingPolicyProperties != nil {
		objectMap["properties"] = stap.ServerTableAuditingPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerTableAuditingPolicy struct.
func (stap *ServerTableAuditingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				stap.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				stap.Location = &location
			}
		case "properties":
			if v != nil {
				var serverTableAuditingPolicyProperties ServerTableAuditingPolicyProperties
				err = json.Unmarshal(*v, &serverTableAuditingPolicyProperties)
				if err != nil {
					return err
				}
				stap.ServerTableAuditingPolicyProperties = &serverTableAuditingPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				stap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				stap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				stap.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerTableAuditingPolicyListResult represents the response to a list server table auditing policies
// request.
type ServerTableAuditingPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of server table auditing policies.
	Value *[]ServerTableAuditingPolicy `json:"value,omitempty"`
}

// ServerTableAuditingPolicyProperties properties of a server table auditing policy.
type ServerTableAuditingPolicyProperties struct {
	// AuditingState - The state of the policy.
	AuditingState *string `json:"auditingState,omitempty"`
	// AuditLogsTableName - The audit logs table name.
	AuditLogsTableName *string `json:"auditLogsTableName,omitempty"`
	// EventTypesToAudit - Comma-separated list of event types to audit.
	EventTypesToAudit *string `json:"eventTypesToAudit,omitempty"`
	// FullAuditLogsTableName - The full audit logs table name.
	FullAuditLogsTableName *string `json:"fullAuditLogsTableName,omitempty"`
	// RetentionDays - The number of days to keep in the audit logs.
	RetentionDays *string `json:"retentionDays,omitempty"`
	// StorageAccountKey - The key of the auditing storage account.
	StorageAccountKey *string `json:"storageAccountKey,omitempty"`
	// StorageAccountName - The table storage account name
	StorageAccountName *string `json:"storageAccountName,omitempty"`
	// StorageAccountResourceGroupName - The table storage account resource group name
	StorageAccountResourceGroupName *string `json:"storageAccountResourceGroupName,omitempty"`
	// StorageAccountSecondaryKey - The secondary key of the auditing storage account.
	StorageAccountSecondaryKey *string `json:"storageAccountSecondaryKey,omitempty"`
	// StorageAccountSubscriptionID - The table storage subscription Id.
	StorageAccountSubscriptionID *uuid.UUID `json:"storageAccountSubscriptionId,omitempty"`
	// StorageTableEndpoint - The storage table endpoint.
	StorageTableEndpoint *string `json:"storageTableEndpoint,omitempty"`
}

// ServerUpdate represents an update to a server.
type ServerUpdate struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ServerProperties - Represents the properties of the resource.
	*ServerProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerUpdate.
func (su ServerUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if su.Tags != nil {
		objectMap["tags"] = su.Tags
	}
	if su.ServerProperties != nil {
		objectMap["properties"] = su.ServerProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerUpdate struct.
func (su *ServerUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				su.Tags = tags
			}
		case "properties":
			if v != nil {
				var serverProperties ServerProperties
				err = json.Unmarshal(*v, &serverProperties)
				if err != nil {
					return err
				}
				su.ServerProperties = &serverProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				su.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				su.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				su.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerUsage represents server metrics.
type ServerUsage struct {
	// Name - READ-ONLY; Name of the server usage metric.
	Name *string `json:"name,omitempty"`
	// ResourceName - READ-ONLY; The name of the resource.
	ResourceName *string `json:"resourceName,omitempty"`
	// DisplayName - READ-ONLY; The metric display name.
	DisplayName *string `json:"displayName,omitempty"`
	// CurrentValue - READ-ONLY; The current value of the metric.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// Limit - READ-ONLY; The current limit of the metric.
	Limit *float64 `json:"limit,omitempty"`
	// Unit - READ-ONLY; The units of the metric.
	Unit *string `json:"unit,omitempty"`
	// NextResetTime - READ-ONLY; The next reset time for the metric (ISO8601 format).
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerUsage.
func (su ServerUsage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ServerUsageListResult represents the response to a list server metrics request.
type ServerUsageListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of server metrics for the server.
	Value *[]ServerUsage `json:"value,omitempty"`
}

// ServerVersionCapability the server capabilities.
type ServerVersionCapability struct {
	// Name - READ-ONLY; The server version name.
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; The status of the server version. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// SupportedEditions - READ-ONLY; The list of supported database editions.
	SupportedEditions *[]EditionCapability `json:"supportedEditions,omitempty"`
	// SupportedElasticPoolEditions - READ-ONLY; The list of supported elastic pool editions.
	SupportedElasticPoolEditions *[]ElasticPoolEditionCapability `json:"supportedElasticPoolEditions,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerVersionCapability.
func (svc ServerVersionCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ServiceObjective represents a database service objective.
type ServiceObjective struct {
	autorest.Response `json:"-"`
	// ServiceObjectiveProperties - Represents the properties of the resource.
	*ServiceObjectiveProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceObjective.
func (so ServiceObjective) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if so.ServiceObjectiveProperties != nil {
		objectMap["properties"] = so.ServiceObjectiveProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceObjective struct.
func (so *ServiceObjective) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceObjectiveProperties ServiceObjectiveProperties
				err = json.Unmarshal(*v, &serviceObjectiveProperties)
				if err != nil {
					return err
				}
				so.ServiceObjectiveProperties = &serviceObjectiveProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				so.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				so.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				so.Type = &typeVar
			}
		}
	}

	return nil
}

// ServiceObjectiveCapability the service objectives capability.
type ServiceObjectiveCapability struct {
	// Name - READ-ONLY; The service objective name.
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; The status of the service objective. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// PerformanceLevel - READ-ONLY; The performance level of the service objective capability.
	*PerformanceLevel `json:"performanceLevel,omitempty"`
	// ID - READ-ONLY; The unique ID of the service objective.
	ID *uuid.UUID `json:"id,omitempty"`
	// SupportedMaxSizes - READ-ONLY; The list of supported maximum database sizes for this service objective.
	SupportedMaxSizes *[]MaxSizeCapability `json:"supportedMaxSizes,omitempty"`
	// IncludedMaxSize - READ-ONLY; The included (free) max size for this service level objective.
	IncludedMaxSize *MaxSizeCapability `json:"includedMaxSize,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceObjectiveCapability.
func (soc ServiceObjectiveCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceObjectiveCapability struct.
func (soc *ServiceObjectiveCapability) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				soc.Name = &name
			}
		case "status":
			if v != nil {
				var status CapabilityStatus
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				soc.Status = status
			}
		case "performanceLevel":
			if v != nil {
				var performanceLevel PerformanceLevel
				err = json.Unmarshal(*v, &performanceLevel)
				if err != nil {
					return err
				}
				soc.PerformanceLevel = &performanceLevel
			}
		case "id":
			if v != nil {
				var ID uuid.UUID
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				soc.ID = &ID
			}
		case "supportedMaxSizes":
			if v != nil {
				var supportedMaxSizes []MaxSizeCapability
				err = json.Unmarshal(*v, &supportedMaxSizes)
				if err != nil {
					return err
				}
				soc.SupportedMaxSizes = &supportedMaxSizes
			}
		case "includedMaxSize":
			if v != nil {
				var includedMaxSize MaxSizeCapability
				err = json.Unmarshal(*v, &includedMaxSize)
				if err != nil {
					return err
				}
				soc.IncludedMaxSize = &includedMaxSize
			}
		}
	}

	return nil
}

// ServiceObjectiveListResult represents the response to a get database service objectives request.
type ServiceObjectiveListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of database service objectives.
	Value *[]ServiceObjective `json:"value,omitempty"`
}

// ServiceObjectiveProperties represents the properties of a database service objective.
type ServiceObjectiveProperties struct {
	// ServiceObjectiveName - READ-ONLY; The name for the service objective.
	ServiceObjectiveName *string `json:"serviceObjectiveName,omitempty"`
	// IsDefault - READ-ONLY; Gets whether the service level objective is the default service objective.
	IsDefault *bool `json:"isDefault,omitempty"`
	// IsSystem - READ-ONLY; Gets whether the service level objective is a system service objective.
	IsSystem *bool `json:"isSystem,omitempty"`
	// Description - READ-ONLY; The description for the service level objective.
	Description *string `json:"description,omitempty"`
	// Enabled - READ-ONLY; Gets whether the service level objective is enabled.
	Enabled *bool `json:"enabled,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceObjectiveProperties.
func (sop ServiceObjectiveProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ServiceTierAdvisor represents a Service Tier Advisor.
type ServiceTierAdvisor struct {
	autorest.Response `json:"-"`
	// ServiceTierAdvisorProperties - READ-ONLY; The properties representing the resource.
	*ServiceTierAdvisorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceTierAdvisor.
func (sta ServiceTierAdvisor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceTierAdvisor struct.
func (sta *ServiceTierAdvisor) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceTierAdvisorProperties ServiceTierAdvisorProperties
				err = json.Unmarshal(*v, &serviceTierAdvisorProperties)
				if err != nil {
					return err
				}
				sta.ServiceTierAdvisorProperties = &serviceTierAdvisorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sta.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sta.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sta.Type = &typeVar
			}
		}
	}

	return nil
}

// ServiceTierAdvisorListResult represents the response to a list service tier advisor request.
type ServiceTierAdvisorListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of service tier advisors for specified database.
	Value *[]ServiceTierAdvisor `json:"value,omitempty"`
}

// ServiceTierAdvisorProperties represents the properties of a Service Tier Advisor.
type ServiceTierAdvisorProperties struct {
	// ObservationPeriodStart - READ-ONLY; The observation period start (ISO8601 format).
	ObservationPeriodStart *date.Time `json:"observationPeriodStart,omitempty"`
	// ObservationPeriodEnd - READ-ONLY; The observation period start (ISO8601 format).
	ObservationPeriodEnd *date.Time `json:"observationPeriodEnd,omitempty"`
	// ActiveTimeRatio - READ-ONLY; The activeTimeRatio for service tier advisor.
	ActiveTimeRatio *float64 `json:"activeTimeRatio,omitempty"`
	// MinDtu - READ-ONLY; Gets or sets minDtu for service tier advisor.
	MinDtu *float64 `json:"minDtu,omitempty"`
	// AvgDtu - READ-ONLY; Gets or sets avgDtu for service tier advisor.
	AvgDtu *float64 `json:"avgDtu,omitempty"`
	// MaxDtu - READ-ONLY; Gets or sets maxDtu for service tier advisor.
	MaxDtu *float64 `json:"maxDtu,omitempty"`
	// MaxSizeInGB - READ-ONLY; Gets or sets maxSizeInGB for service tier advisor.
	MaxSizeInGB *float64 `json:"maxSizeInGB,omitempty"`
	// ServiceLevelObjectiveUsageMetrics - READ-ONLY; Gets or sets serviceLevelObjectiveUsageMetrics for the service tier advisor.
	ServiceLevelObjectiveUsageMetrics *[]SloUsageMetric `json:"serviceLevelObjectiveUsageMetrics,omitempty"`
	// CurrentServiceLevelObjective - READ-ONLY; Gets or sets currentServiceLevelObjective for service tier advisor.
	CurrentServiceLevelObjective *string `json:"currentServiceLevelObjective,omitempty"`
	// CurrentServiceLevelObjectiveID - READ-ONLY; Gets or sets currentServiceLevelObjectiveId for service tier advisor.
	CurrentServiceLevelObjectiveID *uuid.UUID `json:"currentServiceLevelObjectiveId,omitempty"`
	// UsageBasedRecommendationServiceLevelObjective - READ-ONLY; Gets or sets usageBasedRecommendationServiceLevelObjective for service tier advisor.
	UsageBasedRecommendationServiceLevelObjective *string `json:"usageBasedRecommendationServiceLevelObjective,omitempty"`
	// UsageBasedRecommendationServiceLevelObjectiveID - READ-ONLY; Gets or sets usageBasedRecommendationServiceLevelObjectiveId for service tier advisor.
	UsageBasedRecommendationServiceLevelObjectiveID *uuid.UUID `json:"usageBasedRecommendationServiceLevelObjectiveId,omitempty"`
	// DatabaseSizeBasedRecommendationServiceLevelObjective - READ-ONLY; Gets or sets databaseSizeBasedRecommendationServiceLevelObjective for service tier advisor.
	DatabaseSizeBasedRecommendationServiceLevelObjective *string `json:"databaseSizeBasedRecommendationServiceLevelObjective,omitempty"`
	// DatabaseSizeBasedRecommendationServiceLevelObjectiveID - READ-ONLY; Gets or sets databaseSizeBasedRecommendationServiceLevelObjectiveId for service tier advisor.
	DatabaseSizeBasedRecommendationServiceLevelObjectiveID *uuid.UUID `json:"databaseSizeBasedRecommendationServiceLevelObjectiveId,omitempty"`
	// DisasterPlanBasedRecommendationServiceLevelObjective - READ-ONLY; Gets or sets disasterPlanBasedRecommendationServiceLevelObjective for service tier advisor.
	DisasterPlanBasedRecommendationServiceLevelObjective *string `json:"disasterPlanBasedRecommendationServiceLevelObjective,omitempty"`
	// DisasterPlanBasedRecommendationServiceLevelObjectiveID - READ-ONLY; Gets or sets disasterPlanBasedRecommendationServiceLevelObjectiveId for service tier advisor.
	DisasterPlanBasedRecommendationServiceLevelObjectiveID *uuid.UUID `json:"disasterPlanBasedRecommendationServiceLevelObjectiveId,omitempty"`
	// OverallRecommendationServiceLevelObjective - READ-ONLY; Gets or sets overallRecommendationServiceLevelObjective for service tier advisor.
	OverallRecommendationServiceLevelObjective *string `json:"overallRecommendationServiceLevelObjective,omitempty"`
	// OverallRecommendationServiceLevelObjectiveID - READ-ONLY; Gets or sets overallRecommendationServiceLevelObjectiveId for service tier advisor.
	OverallRecommendationServiceLevelObjectiveID *uuid.UUID `json:"overallRecommendationServiceLevelObjectiveId,omitempty"`
	// Confidence - READ-ONLY; Gets or sets confidence for service tier advisor.
	Confidence *float64 `json:"confidence,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceTierAdvisorProperties.
func (stap ServiceTierAdvisorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SloUsageMetric a Slo Usage Metric.
type SloUsageMetric struct {
	// ServiceLevelObjective - READ-ONLY; The serviceLevelObjective for SLO usage metric. Possible values include: 'ServiceObjectiveNameSystem', 'ServiceObjectiveNameSystem0', 'ServiceObjectiveNameSystem1', 'ServiceObjectiveNameSystem2', 'ServiceObjectiveNameSystem3', 'ServiceObjectiveNameSystem4', 'ServiceObjectiveNameSystem2L', 'ServiceObjectiveNameSystem3L', 'ServiceObjectiveNameSystem4L', 'ServiceObjectiveNameFree', 'ServiceObjectiveNameBasic', 'ServiceObjectiveNameS0', 'ServiceObjectiveNameS1', 'ServiceObjectiveNameS2', 'ServiceObjectiveNameS3', 'ServiceObjectiveNameS4', 'ServiceObjectiveNameS6', 'ServiceObjectiveNameS7', 'ServiceObjectiveNameS9', 'ServiceObjectiveNameS12', 'ServiceObjectiveNameP1', 'ServiceObjectiveNameP2', 'ServiceObjectiveNameP3', 'ServiceObjectiveNameP4', 'ServiceObjectiveNameP6', 'ServiceObjectiveNameP11', 'ServiceObjectiveNameP15', 'ServiceObjectiveNamePRS1', 'ServiceObjectiveNamePRS2', 'ServiceObjectiveNamePRS4', 'ServiceObjectiveNamePRS6', 'ServiceObjectiveNameDW100', 'ServiceObjectiveNameDW200', 'ServiceObjectiveNameDW300', 'ServiceObjectiveNameDW400', 'ServiceObjectiveNameDW500', 'ServiceObjectiveNameDW600', 'ServiceObjectiveNameDW1000', 'ServiceObjectiveNameDW1200', 'ServiceObjectiveNameDW1000c', 'ServiceObjectiveNameDW1500', 'ServiceObjectiveNameDW1500c', 'ServiceObjectiveNameDW2000', 'ServiceObjectiveNameDW2000c', 'ServiceObjectiveNameDW3000', 'ServiceObjectiveNameDW2500c', 'ServiceObjectiveNameDW3000c', 'ServiceObjectiveNameDW6000', 'ServiceObjectiveNameDW5000c', 'ServiceObjectiveNameDW6000c', 'ServiceObjectiveNameDW7500c', 'ServiceObjectiveNameDW10000c', 'ServiceObjectiveNameDW15000c', 'ServiceObjectiveNameDW30000c', 'ServiceObjectiveNameDS100', 'ServiceObjectiveNameDS200', 'ServiceObjectiveNameDS300', 'ServiceObjectiveNameDS400', 'ServiceObjectiveNameDS500', 'ServiceObjectiveNameDS600', 'ServiceObjectiveNameDS1000', 'ServiceObjectiveNameDS1200', 'ServiceObjectiveNameDS1500', 'ServiceObjectiveNameDS2000', 'ServiceObjectiveNameElasticPool'
	ServiceLevelObjective ServiceObjectiveName `json:"serviceLevelObjective,omitempty"`
	// ServiceLevelObjectiveID - READ-ONLY; The serviceLevelObjectiveId for SLO usage metric.
	ServiceLevelObjectiveID *uuid.UUID `json:"serviceLevelObjectiveId,omitempty"`
	// InRangeTimeRatio - READ-ONLY; Gets or sets inRangeTimeRatio for SLO usage metric.
	InRangeTimeRatio *float64 `json:"inRangeTimeRatio,omitempty"`
}

// MarshalJSON is the custom marshaler for SloUsageMetric.
func (sum SloUsageMetric) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// TableAuditingPolicyProperties properties of a table auditing policy.
type TableAuditingPolicyProperties struct {
	// AuditingState - The state of the policy.
	AuditingState *string `json:"auditingState,omitempty"`
	// AuditLogsTableName - The audit logs table name.
	AuditLogsTableName *string `json:"auditLogsTableName,omitempty"`
	// EventTypesToAudit - Comma-separated list of event types to audit.
	EventTypesToAudit *string `json:"eventTypesToAudit,omitempty"`
	// FullAuditLogsTableName - The full audit logs table name.
	FullAuditLogsTableName *string `json:"fullAuditLogsTableName,omitempty"`
	// RetentionDays - The number of days to keep in the audit logs.
	RetentionDays *string `json:"retentionDays,omitempty"`
	// StorageAccountKey - The key of the auditing storage account.
	StorageAccountKey *string `json:"storageAccountKey,omitempty"`
	// StorageAccountName - The table storage account name
	StorageAccountName *string `json:"storageAccountName,omitempty"`
	// StorageAccountResourceGroupName - The table storage account resource group name
	StorageAccountResourceGroupName *string `json:"storageAccountResourceGroupName,omitempty"`
	// StorageAccountSecondaryKey - The secondary key of the auditing storage account.
	StorageAccountSecondaryKey *string `json:"storageAccountSecondaryKey,omitempty"`
	// StorageAccountSubscriptionID - The table storage subscription Id.
	StorageAccountSubscriptionID *uuid.UUID `json:"storageAccountSubscriptionId,omitempty"`
	// StorageTableEndpoint - The storage table endpoint.
	StorageTableEndpoint *string `json:"storageTableEndpoint,omitempty"`
}

// TopQueries a database query.
type TopQueries struct {
	// AggregationFunction - READ-ONLY; The function that is used to aggregate each query's metrics. Possible values include: 'Min', 'Max', 'Avg', 'Sum'
	AggregationFunction QueryAggregationFunction `json:"aggregationFunction,omitempty"`
	// ExecutionType - READ-ONLY; The execution type that is used to filter the query instances that are returned. Possible values include: 'Any', 'Regular', 'Irregular', 'Aborted', 'Exception'
	ExecutionType QueryExecutionType `json:"executionType,omitempty"`
	// IntervalType - READ-ONLY; The duration of the interval (ISO8601 duration format).
	IntervalType *string `json:"intervalType,omitempty"`
	// NumberOfTopQueries - READ-ONLY; The number of requested queries.
	NumberOfTopQueries *float64 `json:"numberOfTopQueries,omitempty"`
	// ObservationStartTime - READ-ONLY; The start time for queries that are returned (ISO8601 format)
	ObservationStartTime *date.Time `json:"observationStartTime,omitempty"`
	// ObservationEndTime - READ-ONLY; The end time for queries that are returned (ISO8601 format)
	ObservationEndTime *date.Time `json:"observationEndTime,omitempty"`
	// ObservedMetric - READ-ONLY; The type of metric to use for ordering the top metrics. Possible values include: 'CPU', 'Io', 'Logio', 'Duration', 'ExecutionCount'
	ObservedMetric QueryObservedMetricType `json:"observedMetric,omitempty"`
	// Queries - READ-ONLY; The list of queries.
	Queries *[]QueryStatistic `json:"queries,omitempty"`
}

// MarshalJSON is the custom marshaler for TopQueries.
func (tq TopQueries) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// TopQueriesListResult represents the response to a get top queries request.
type TopQueriesListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of top queries.
	Value *[]TopQueries `json:"value,omitempty"`
}

// TrackedResource ARM tracked top level resource.
type TrackedResource struct {
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// TransparentDataEncryption represents a database transparent data encryption configuration.
type TransparentDataEncryption struct {
	autorest.Response `json:"-"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// TransparentDataEncryptionProperties - Represents the properties of the resource.
	*TransparentDataEncryptionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TransparentDataEncryption.
func (tde TransparentDataEncryption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tde.TransparentDataEncryptionProperties != nil {
		objectMap["properties"] = tde.TransparentDataEncryptionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TransparentDataEncryption struct.
func (tde *TransparentDataEncryption) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tde.Location = &location
			}
		case "properties":
			if v != nil {
				var transparentDataEncryptionProperties TransparentDataEncryptionProperties
				err = json.Unmarshal(*v, &transparentDataEncryptionProperties)
				if err != nil {
					return err
				}
				tde.TransparentDataEncryptionProperties = &transparentDataEncryptionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tde.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tde.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tde.Type = &typeVar
			}
		}
	}

	return nil
}

// TransparentDataEncryptionActivity represents a database transparent data encryption Scan.
type TransparentDataEncryptionActivity struct {
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// TransparentDataEncryptionActivityProperties - Represents the properties of the resource.
	*TransparentDataEncryptionActivityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TransparentDataEncryptionActivity.
func (tdea TransparentDataEncryptionActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tdea.TransparentDataEncryptionActivityProperties != nil {
		objectMap["properties"] = tdea.TransparentDataEncryptionActivityProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TransparentDataEncryptionActivity struct.
func (tdea *TransparentDataEncryptionActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tdea.Location = &location
			}
		case "properties":
			if v != nil {
				var transparentDataEncryptionActivityProperties TransparentDataEncryptionActivityProperties
				err = json.Unmarshal(*v, &transparentDataEncryptionActivityProperties)
				if err != nil {
					return err
				}
				tdea.TransparentDataEncryptionActivityProperties = &transparentDataEncryptionActivityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tdea.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tdea.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tdea.Type = &typeVar
			}
		}
	}

	return nil
}

// TransparentDataEncryptionActivityListResult represents the response to a list database transparent data
// encryption activity request.
type TransparentDataEncryptionActivityListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of database transparent data encryption activities.
	Value *[]TransparentDataEncryptionActivity `json:"value,omitempty"`
}

// TransparentDataEncryptionActivityProperties represents the properties of a database transparent data
// encryption Scan.
type TransparentDataEncryptionActivityProperties struct {
	// Status - READ-ONLY; The status of the database. Possible values include: 'Encrypting', 'Decrypting'
	Status TransparentDataEncryptionActivityStatus `json:"status,omitempty"`
	// PercentComplete - READ-ONLY; The percent complete of the transparent data encryption scan for a database.
	PercentComplete *float64 `json:"percentComplete,omitempty"`
}

// MarshalJSON is the custom marshaler for TransparentDataEncryptionActivityProperties.
func (tdeap TransparentDataEncryptionActivityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// TransparentDataEncryptionListResult represents the response to a list transparent data encryption
// configurations request.
type TransparentDataEncryptionListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of transparent data encryption configurations.
	Value *[]TransparentDataEncryption `json:"value,omitempty"`
}

// TransparentDataEncryptionProperties represents the properties of a database transparent data encryption.
type TransparentDataEncryptionProperties struct {
	// Status - The status of the database transparent data encryption. Possible values include: 'TransparentDataEncryptionStatusEnabled', 'TransparentDataEncryptionStatusDisabled'
	Status TransparentDataEncryptionStatus `json:"status,omitempty"`
}

// UnlinkParameters represents the parameters for Unlink Replication Link request.
type UnlinkParameters struct {
	// ForcedTermination - Determines whether link will be terminated in a forced or a friendly way.
	ForcedTermination *bool `json:"forcedTermination,omitempty"`
}
