/*
 * CLOUD API
 *
 * IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// TargetGroupHealthCheck struct for TargetGroupHealthCheck
type TargetGroupHealthCheck struct {
	// The maximum time in milliseconds to wait for a target to respond to a check. For target VMs with 'Check Interval' set, the lesser of the two  values is used once the TCP connection is established.
	CheckTimeout *int32 `json:"checkTimeout,omitempty"`
	// The interval in milliseconds between consecutive health checks; default is 2000.
	CheckInterval *int32 `json:"checkInterval,omitempty"`
	// The maximum number of attempts to reconnect to a target after a connection failure. Valid range is 0 to 65535, and default is three reconnection attempts.
	Retries *int32 `json:"retries,omitempty"`
}

// NewTargetGroupHealthCheck instantiates a new TargetGroupHealthCheck object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewTargetGroupHealthCheck() *TargetGroupHealthCheck {
	this := TargetGroupHealthCheck{}

	return &this
}

// NewTargetGroupHealthCheckWithDefaults instantiates a new TargetGroupHealthCheck object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewTargetGroupHealthCheckWithDefaults() *TargetGroupHealthCheck {
	this := TargetGroupHealthCheck{}
	return &this
}

// GetCheckTimeout returns the CheckTimeout field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *TargetGroupHealthCheck) GetCheckTimeout() *int32 {
	if o == nil {
		return nil
	}

	return o.CheckTimeout

}

// GetCheckTimeoutOk returns a tuple with the CheckTimeout field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *TargetGroupHealthCheck) GetCheckTimeoutOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.CheckTimeout, true
}

// SetCheckTimeout sets field value
func (o *TargetGroupHealthCheck) SetCheckTimeout(v int32) {

	o.CheckTimeout = &v

}

// HasCheckTimeout returns a boolean if a field has been set.
func (o *TargetGroupHealthCheck) HasCheckTimeout() bool {
	if o != nil && o.CheckTimeout != nil {
		return true
	}

	return false
}

// GetCheckInterval returns the CheckInterval field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *TargetGroupHealthCheck) GetCheckInterval() *int32 {
	if o == nil {
		return nil
	}

	return o.CheckInterval

}

// GetCheckIntervalOk returns a tuple with the CheckInterval field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *TargetGroupHealthCheck) GetCheckIntervalOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.CheckInterval, true
}

// SetCheckInterval sets field value
func (o *TargetGroupHealthCheck) SetCheckInterval(v int32) {

	o.CheckInterval = &v

}

// HasCheckInterval returns a boolean if a field has been set.
func (o *TargetGroupHealthCheck) HasCheckInterval() bool {
	if o != nil && o.CheckInterval != nil {
		return true
	}

	return false
}

// GetRetries returns the Retries field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *TargetGroupHealthCheck) GetRetries() *int32 {
	if o == nil {
		return nil
	}

	return o.Retries

}

// GetRetriesOk returns a tuple with the Retries field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *TargetGroupHealthCheck) GetRetriesOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.Retries, true
}

// SetRetries sets field value
func (o *TargetGroupHealthCheck) SetRetries(v int32) {

	o.Retries = &v

}

// HasRetries returns a boolean if a field has been set.
func (o *TargetGroupHealthCheck) HasRetries() bool {
	if o != nil && o.Retries != nil {
		return true
	}

	return false
}

func (o TargetGroupHealthCheck) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.CheckTimeout != nil {
		toSerialize["checkTimeout"] = o.CheckTimeout
	}
	if o.CheckInterval != nil {
		toSerialize["checkInterval"] = o.CheckInterval
	}
	if o.Retries != nil {
		toSerialize["retries"] = o.Retries
	}
	return json.Marshal(toSerialize)
}

type NullableTargetGroupHealthCheck struct {
	value *TargetGroupHealthCheck
	isSet bool
}

func (v NullableTargetGroupHealthCheck) Get() *TargetGroupHealthCheck {
	return v.value
}

func (v *NullableTargetGroupHealthCheck) Set(val *TargetGroupHealthCheck) {
	v.value = val
	v.isSet = true
}

func (v NullableTargetGroupHealthCheck) IsSet() bool {
	return v.isSet
}

func (v *NullableTargetGroupHealthCheck) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTargetGroupHealthCheck(val *TargetGroupHealthCheck) *NullableTargetGroupHealthCheck {
	return &NullableTargetGroupHealthCheck{value: val, isSet: true}
}

func (v NullableTargetGroupHealthCheck) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTargetGroupHealthCheck) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
