/**
 * Go SDK for OpenFGA
 *
 * API version: 1.x
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"

	"encoding/json"
)

// ListUsersRequest struct for ListUsersRequest
type ListUsersRequest struct {
	AuthorizationModelId *string   `json:"authorization_model_id,omitempty"yaml:"authorization_model_id,omitempty"`
	Object               FgaObject `json:"object"yaml:"object"`
	Relation             string    `json:"relation"yaml:"relation"`
	// The type of results returned. Only accepts exactly one value.
	UserFilters      []UserTypeFilter `json:"user_filters"yaml:"user_filters"`
	ContextualTuples *[]TupleKey      `json:"contextual_tuples,omitempty"yaml:"contextual_tuples,omitempty"`
	// Additional request context that will be used to evaluate any ABAC conditions encountered in the query evaluation.
	Context *map[string]interface{} `json:"context,omitempty"yaml:"context,omitempty"`
}

// NewListUsersRequest instantiates a new ListUsersRequest object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewListUsersRequest(object FgaObject, relation string, userFilters []UserTypeFilter) *ListUsersRequest {
	this := ListUsersRequest{}
	this.Object = object
	this.Relation = relation
	this.UserFilters = userFilters
	return &this
}

// NewListUsersRequestWithDefaults instantiates a new ListUsersRequest object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewListUsersRequestWithDefaults() *ListUsersRequest {
	this := ListUsersRequest{}
	return &this
}

// GetAuthorizationModelId returns the AuthorizationModelId field value if set, zero value otherwise.
func (o *ListUsersRequest) GetAuthorizationModelId() string {
	if o == nil || o.AuthorizationModelId == nil {
		var ret string
		return ret
	}
	return *o.AuthorizationModelId
}

// GetAuthorizationModelIdOk returns a tuple with the AuthorizationModelId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ListUsersRequest) GetAuthorizationModelIdOk() (*string, bool) {
	if o == nil || o.AuthorizationModelId == nil {
		return nil, false
	}
	return o.AuthorizationModelId, true
}

// HasAuthorizationModelId returns a boolean if a field has been set.
func (o *ListUsersRequest) HasAuthorizationModelId() bool {
	if o != nil && o.AuthorizationModelId != nil {
		return true
	}

	return false
}

// SetAuthorizationModelId gets a reference to the given string and assigns it to the AuthorizationModelId field.
func (o *ListUsersRequest) SetAuthorizationModelId(v string) {
	o.AuthorizationModelId = &v
}

// GetObject returns the Object field value
func (o *ListUsersRequest) GetObject() FgaObject {
	if o == nil {
		var ret FgaObject
		return ret
	}

	return o.Object
}

// GetObjectOk returns a tuple with the Object field value
// and a boolean to check if the value has been set.
func (o *ListUsersRequest) GetObjectOk() (*FgaObject, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Object, true
}

// SetObject sets field value
func (o *ListUsersRequest) SetObject(v FgaObject) {
	o.Object = v
}

// GetRelation returns the Relation field value
func (o *ListUsersRequest) GetRelation() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Relation
}

// GetRelationOk returns a tuple with the Relation field value
// and a boolean to check if the value has been set.
func (o *ListUsersRequest) GetRelationOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Relation, true
}

// SetRelation sets field value
func (o *ListUsersRequest) SetRelation(v string) {
	o.Relation = v
}

// GetUserFilters returns the UserFilters field value
func (o *ListUsersRequest) GetUserFilters() []UserTypeFilter {
	if o == nil {
		var ret []UserTypeFilter
		return ret
	}

	return o.UserFilters
}

// GetUserFiltersOk returns a tuple with the UserFilters field value
// and a boolean to check if the value has been set.
func (o *ListUsersRequest) GetUserFiltersOk() (*[]UserTypeFilter, bool) {
	if o == nil {
		return nil, false
	}
	return &o.UserFilters, true
}

// SetUserFilters sets field value
func (o *ListUsersRequest) SetUserFilters(v []UserTypeFilter) {
	o.UserFilters = v
}

// GetContextualTuples returns the ContextualTuples field value if set, zero value otherwise.
func (o *ListUsersRequest) GetContextualTuples() []TupleKey {
	if o == nil || o.ContextualTuples == nil {
		var ret []TupleKey
		return ret
	}
	return *o.ContextualTuples
}

// GetContextualTuplesOk returns a tuple with the ContextualTuples field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ListUsersRequest) GetContextualTuplesOk() (*[]TupleKey, bool) {
	if o == nil || o.ContextualTuples == nil {
		return nil, false
	}
	return o.ContextualTuples, true
}

// HasContextualTuples returns a boolean if a field has been set.
func (o *ListUsersRequest) HasContextualTuples() bool {
	if o != nil && o.ContextualTuples != nil {
		return true
	}

	return false
}

// SetContextualTuples gets a reference to the given []TupleKey and assigns it to the ContextualTuples field.
func (o *ListUsersRequest) SetContextualTuples(v []TupleKey) {
	o.ContextualTuples = &v
}

// GetContext returns the Context field value if set, zero value otherwise.
func (o *ListUsersRequest) GetContext() map[string]interface{} {
	if o == nil || o.Context == nil {
		var ret map[string]interface{}
		return ret
	}
	return *o.Context
}

// GetContextOk returns a tuple with the Context field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ListUsersRequest) GetContextOk() (*map[string]interface{}, bool) {
	if o == nil || o.Context == nil {
		return nil, false
	}
	return o.Context, true
}

// HasContext returns a boolean if a field has been set.
func (o *ListUsersRequest) HasContext() bool {
	if o != nil && o.Context != nil {
		return true
	}

	return false
}

// SetContext gets a reference to the given map[string]interface{} and assigns it to the Context field.
func (o *ListUsersRequest) SetContext(v map[string]interface{}) {
	o.Context = &v
}

func (o ListUsersRequest) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AuthorizationModelId != nil {
		toSerialize["authorization_model_id"] = o.AuthorizationModelId
	}
	toSerialize["object"] = o.Object
	toSerialize["relation"] = o.Relation
	toSerialize["user_filters"] = o.UserFilters
	if o.ContextualTuples != nil {
		toSerialize["contextual_tuples"] = o.ContextualTuples
	}
	if o.Context != nil {
		toSerialize["context"] = o.Context
	}
	var b bytes.Buffer
	enc := json.NewEncoder(&b)
	enc.SetEscapeHTML(false)
	err := enc.Encode(toSerialize)
	if err != nil {
		return nil, err
	}
	return b.Bytes(), nil
}

type NullableListUsersRequest struct {
	value *ListUsersRequest
	isSet bool
}

func (v NullableListUsersRequest) Get() *ListUsersRequest {
	return v.value
}

func (v *NullableListUsersRequest) Set(val *ListUsersRequest) {
	v.value = val
	v.isSet = true
}

func (v NullableListUsersRequest) IsSet() bool {
	return v.isSet
}

func (v *NullableListUsersRequest) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableListUsersRequest(val *ListUsersRequest) *NullableListUsersRequest {
	return &NullableListUsersRequest{value: val, isSet: true}
}

func (v NullableListUsersRequest) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableListUsersRequest) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
