# Address Rewrite Rules Demo

This demo shows how the extended `AddressRewriteRule` feature in `pion/ice` rewrites addresses for a multi-homed host. It runs a small client that gathers host, srflx, UDP, and TCP candidates so you can see exactly what each rule produces.

The included `docker-compose.yml` places one container on multiple host networks, similar to setups like the Glimesh broadcast box. The demo covers:

1. Multiple host networks with fixed public IPs for each interface.
2. Host and server-reflexive addresses from deterministic srflx pools.
3. Scoped rules that only rewrite specific CIDRs, with a global fallback for others.
4. TCP candidates generated by an automatic TCP mux.
5. Zero-length External handling: replace+empty drops a candidate, append+empty keeps it (useful for deny/allow layering).

## Scenarios

| Key         | Description                                                                 |
| ----------- | --------------------------------------------------------------------------- |
| `multi-net` | Two host networks with distinct public IPs plus a global fallback.          |
| `srflx`     | A srflx pool (two addresses) plus a host mapping for the service interface. |
| `scoped`    | A CIDR-scoped rule that overrides the global mapping only for matching IPs. |
| `iface`     | Interface-scoped host rewrite; only matching NICs are rewritten.            |

The client prints local interfaces and each gathered candidate. A `nil` candidate marks the end of the scenario.

## Docker Compose Topology

The service `nat-demo` attaches to three bridge networks:

| Network       | Subnet       | Purpose               |
| ------------- | ------------ | --------------------- |
| `lan_blue`    | 10.10.0.0/24 | First host interface  |
| `lan_green`   | 10.20.0.0/24 | Second host interface |
| `lan_service` | 10.30.0.0/24 | Shared service leg    |

Run everything with:

```sh
docker compose up --build nat-demo
```

## Configuration Variables

All mappings come from environment variables so you can match your own network. The important ones are defined in `docker-compose.yml`:

* `NAT_DEMO_BLUE_LOCAL` / `NAT_DEMO_BLUE_PUBLIC`
* `NAT_DEMO_BLUE_IFACE` (default `eth0`)
* `NAT_DEMO_GREEN_LOCAL` / `NAT_DEMO_GREEN_PUBLIC`
* `NAT_DEMO_GREEN_IFACE` (default `eth1`)
* `NAT_DEMO_GLOBAL_HOST_FALLBACK`
* `NAT_DEMO_SERVICE_LOCAL` / `NAT_DEMO_SERVICE_HOST_PUBLIC`
* `NAT_DEMO_SCOPED_PUBLIC` / `NAT_DEMO_SCOPED_CIDR`
* `NAT_DEMO_SRFLX_PRIMARY` / `NAT_DEMO_SRFLX_SECONDARY`
* `NAT_DEMO_DROP_LAN` (optional) — set to `1` to drop LAN host candidates via a replace+empty rule.

Override any value with `docker compose run -e VAR=... nat-demo`.
