/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.jive;

import java.awt.GridBagConstraints;

public enum Anchor {
    
    CENTER, NORTH, NORTHEAST, EAST, SOUTHEAST, SOUTH, SOUTHWEST, WEST, NORTHWEST;
    
    public int getGbc() {

        if (this == Anchor.NORTH) {
            return GridBagConstraints.NORTH;
        }
        
        if (this == Anchor.NORTHEAST) {
            return GridBagConstraints.NORTHEAST;
        }
        
        if (this == Anchor.EAST) {
            return GridBagConstraints.EAST;
        }
        
        if (this == Anchor.SOUTHEAST) {
            return GridBagConstraints.SOUTHEAST;
        }
        
        if (this == Anchor.SOUTH) {
            return GridBagConstraints.SOUTH;
        }
        
        if (this == Anchor.SOUTHWEST) {
            return GridBagConstraints.SOUTHWEST;
        }
        
        if (this == Anchor.WEST) {
            return GridBagConstraints.WEST;
        }
        
        if (this == Anchor.NORTHWEST) {
            return GridBagConstraints.NORTHWEST;
        }
        
        return GridBagConstraints.WEST;
    }

}