/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.service;

import java.io.PrintWriter;
import java.io.StringWriter;

public class ExecResult {

    private Process process;
    private String command;
    private StringBuffer output;
    private Throwable oops;
    private int exitCode = -1;

    public ExecResult() {

        output = new StringBuffer();
        oops = null;
    }

    public void setCommand(String command) {
        this.command = command;
    }
    
    public String getCommand() {
        return command;
    }
    
    public void setOutput(StringBuffer output) {
        this.output = output;
    }

    public void appendOutput(StringBuffer buffer) {
        this.output.append(buffer);
    }

    public void appendOutput(String buffer) {
        this.output.append(buffer);
    }

    public String getOutput() {
        return output.toString();
    }

    public void setProcess(Process process) {
        this.process = process;
    }
    
    public Process getProcess() {
        return process;
    }
    
    public void setThrowable(Throwable oops) {
        this.oops = oops;
    }

    public Throwable getThrowable() {
        return oops;
    }

    public String getStackTrace() {

        if (oops == null) {
            return "";
        }

        StringWriter buffer = new StringWriter();
        oops.printStackTrace(new PrintWriter(buffer));
        return buffer.toString();
    }

    public void setExitCode(int exitCode) {

        this.exitCode = exitCode;
        
    }

    public int getExitCode() {

        return exitCode;
    }

    public boolean failed() {

        if (exitCode == 0) {
            return false;
        }

        return true;
    }

    @Override
    public String toString() {

        StringBuffer buffer = new StringBuffer();

        buffer.append("Command '" + command + "' failed!\n");
        buffer.append("Exit Code: ");
        buffer.append(exitCode);
        buffer.append('\n');
        buffer.append("Console Output: ");
        buffer.append(output);
        buffer.append('\n');
        
        if (oops != null) {
            buffer.append("Stacktrace: ");
            buffer.append(getStackTrace());
            buffer.append('\n');
        }

        return buffer.toString();
    }
}
