% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrxcenter.r
\name{qrxcenter}
\alias{qrxcenter}
\title{qrxcenter}
\usage{
qrxcenter(x, ...)
}
\arguments{
\item{x}{a numeric matrix or vector with at least 2 rows}

\item{...}{passed to \code{\link[base:qr]{base::qr()}}}
}
\value{
a list with components \code{x} (transformed data matrix), \code{R} (the matrix that can be used to transform raw \code{x} and to transform regression coefficients computed on transformed \code{x} back to the original space), \code{Ri} (transforms transformed \code{x} back to original scale except for \code{xbar}), and \code{xbar} (vector of means of original \code{x} columns`)
}
\description{
Mean-center a data matrix and QR transform it
}
\details{
For a numeric matrix \code{x} (or a numeric vector that is automatically changed to a one-column matrix), computes column means and subtracts them from \code{x} columns, and passes this matrix to \code{\link[base:qr]{base::qr()}} to orthogonalize columns.  Columns of the transformed \code{x} are negated as needed so that original directions are preserved (which are arbitrary with QR decomposition).  Instead of the default \code{qr} operation for which sums of squares of column values are 1.0, \code{qrxcenter} makes all the transformed columns have standard deviation of 1.0.
}
\examples{
set.seed(1)
age <- 1:10
country <- sample(c('Slovenia', 'Italy', 'France'), 10, TRUE)
x <- model.matrix(~ age + country)[, -1]
x
w <- qrxcenter(x)
w
# Reproduce w$x
sweep(x, 2, w$xbar) \%*\% w$R
# Reproduce x from w$x
sweep(w$x \%*\% w$Ri, 2, w$xbar, FUN='+')
# See also https://hbiostat.org/r/examples/gtrans/gtrans#sec-splinebasis
}
