
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGraphicsOpacityEffect.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QGraphicsOpacityEffect>
#include <QBrush>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QPainter>
#include <QPixmap>
#include <QPoint>
#include <QRectF>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGraphicsOpacityEffect

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QGraphicsOpacityEffect::staticMetaObject);
}


// double QGraphicsOpacityEffect::opacity()


static void _init_f_opacity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_opacity_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsOpacityEffect *)cls)->opacity ());
}


// QBrush QGraphicsOpacityEffect::opacityMask()


static void _init_f_opacityMask_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QBrush > ();
}

static void _call_f_opacityMask_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QBrush > ((QBrush)((QGraphicsOpacityEffect *)cls)->opacityMask ());
}


// void QGraphicsOpacityEffect::setOpacity(double opacity)


static void _init_f_setOpacity_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("opacity");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOpacity_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsOpacityEffect *)cls)->setOpacity (arg1);
}


// void QGraphicsOpacityEffect::setOpacityMask(const QBrush &mask)


static void _init_f_setOpacityMask_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mask");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOpacityMask_1910 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QBrush &arg1 = gsi::arg_reader<const QBrush & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsOpacityEffect *)cls)->setOpacityMask (arg1);
}


// static QString QGraphicsOpacityEffect::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QGraphicsOpacityEffect::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QGraphicsOpacityEffect () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":opacity", "@brief Method double QGraphicsOpacityEffect::opacity()\n", true, &_init_f_opacity_c0, &_call_f_opacity_c0);
  methods += new qt_gsi::GenericMethod (":opacityMask", "@brief Method QBrush QGraphicsOpacityEffect::opacityMask()\n", true, &_init_f_opacityMask_c0, &_call_f_opacityMask_c0);
  methods += new qt_gsi::GenericMethod ("setOpacity|opacity=", "@brief Method void QGraphicsOpacityEffect::setOpacity(double opacity)\n", false, &_init_f_setOpacity_1071, &_call_f_setOpacity_1071);
  methods += new qt_gsi::GenericMethod ("setOpacityMask|opacityMask=", "@brief Method void QGraphicsOpacityEffect::setOpacityMask(const QBrush &mask)\n", false, &_init_f_setOpacityMask_1910, &_call_f_setOpacityMask_1910);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QGraphicsOpacityEffect::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("enabledChanged(bool)", "enabledChanged", gsi::arg("enabled"), "@brief Signal declaration for QGraphicsOpacityEffect::enabledChanged(bool enabled)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QGraphicsOpacityEffect::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<double > ("opacityChanged(double)", "opacityChanged", gsi::arg("opacity"), "@brief Signal declaration for QGraphicsOpacityEffect::opacityChanged(double opacity)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QBrush & > ("opacityMaskChanged(const QBrush &)", "opacityMaskChanged", gsi::arg("mask"), "@brief Signal declaration for QGraphicsOpacityEffect::opacityMaskChanged(const QBrush &mask)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsOpacityEffect::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QGraphicsEffect> &qtdecl_QGraphicsEffect ();

qt_gsi::QtNativeClass<QGraphicsOpacityEffect> decl_QGraphicsOpacityEffect (qtdecl_QGraphicsEffect (), "QtWidgets", "QGraphicsOpacityEffect_Native",
  methods_QGraphicsOpacityEffect (),
  "@hide\n@alias QGraphicsOpacityEffect");

GSI_QTWIDGETS_PUBLIC gsi::Class<QGraphicsOpacityEffect> &qtdecl_QGraphicsOpacityEffect () { return decl_QGraphicsOpacityEffect; }

}


class QGraphicsOpacityEffect_Adaptor : public QGraphicsOpacityEffect, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGraphicsOpacityEffect_Adaptor();

  //  [adaptor ctor] QGraphicsOpacityEffect::QGraphicsOpacityEffect(QObject *parent)
  QGraphicsOpacityEffect_Adaptor() : QGraphicsOpacityEffect()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsOpacityEffect::QGraphicsOpacityEffect(QObject *parent)
  QGraphicsOpacityEffect_Adaptor(QObject *parent) : QGraphicsOpacityEffect(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QGraphicsOpacityEffect::drawSource(QPainter *painter)
  void fp_QGraphicsOpacityEffect_drawSource_1426 (QPainter *painter) {
    QGraphicsOpacityEffect::drawSource(painter);
  }

  //  [expose] bool QGraphicsOpacityEffect::isSignalConnected(const QMetaMethod &signal)
  bool fp_QGraphicsOpacityEffect_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QGraphicsOpacityEffect::isSignalConnected(signal);
  }

  //  [expose] int QGraphicsOpacityEffect::receivers(const char *signal)
  int fp_QGraphicsOpacityEffect_receivers_c1731 (const char *signal) const {
    return QGraphicsOpacityEffect::receivers(signal);
  }

  //  [expose] QObject *QGraphicsOpacityEffect::sender()
  QObject * fp_QGraphicsOpacityEffect_sender_c0 () const {
    return QGraphicsOpacityEffect::sender();
  }

  //  [expose] int QGraphicsOpacityEffect::senderSignalIndex()
  int fp_QGraphicsOpacityEffect_senderSignalIndex_c0 () const {
    return QGraphicsOpacityEffect::senderSignalIndex();
  }

  //  [expose] QRectF QGraphicsOpacityEffect::sourceBoundingRect(Qt::CoordinateSystem system)
  QRectF fp_QGraphicsOpacityEffect_sourceBoundingRect_c2426 (const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & system) const {
    return QGraphicsOpacityEffect::sourceBoundingRect(qt_gsi::QtToCppAdaptor<Qt::CoordinateSystem>(system).cref());
  }

  //  [expose] bool QGraphicsOpacityEffect::sourceIsPixmap()
  bool fp_QGraphicsOpacityEffect_sourceIsPixmap_c0 () const {
    return QGraphicsOpacityEffect::sourceIsPixmap();
  }

  //  [expose] QPixmap QGraphicsOpacityEffect::sourcePixmap(Qt::CoordinateSystem system, QPoint *offset, QGraphicsEffect::PixmapPadMode mode)
  QPixmap fp_QGraphicsOpacityEffect_sourcePixmap_c6763 (const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & system, QPoint *offset, const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & mode) const {
    return QGraphicsOpacityEffect::sourcePixmap(qt_gsi::QtToCppAdaptor<Qt::CoordinateSystem>(system).cref(), offset, qt_gsi::QtToCppAdaptor<QGraphicsEffect::PixmapPadMode>(mode).cref());
  }

  //  [expose] void QGraphicsOpacityEffect::updateBoundingRect()
  void fp_QGraphicsOpacityEffect_updateBoundingRect_0 () {
    QGraphicsOpacityEffect::updateBoundingRect();
  }

  //  [adaptor impl] QRectF QGraphicsOpacityEffect::boundingRectFor(const QRectF &sourceRect)
  QRectF cbs_boundingRectFor_c1862_0(const QRectF &sourceRect) const
  {
    return QGraphicsOpacityEffect::boundingRectFor(sourceRect);
  }

  virtual QRectF boundingRectFor(const QRectF &sourceRect) const
  {
    if (cb_boundingRectFor_c1862_0.can_issue()) {
      return cb_boundingRectFor_c1862_0.issue<QGraphicsOpacityEffect_Adaptor, QRectF, const QRectF &>(&QGraphicsOpacityEffect_Adaptor::cbs_boundingRectFor_c1862_0, sourceRect);
    } else {
      return QGraphicsOpacityEffect::boundingRectFor(sourceRect);
    }
  }

  //  [emitter impl] void QGraphicsOpacityEffect::destroyed(QObject *)
  void emitter_QGraphicsOpacityEffect_destroyed_1302(QObject *arg1)
  {
    emit QGraphicsOpacityEffect::destroyed(arg1);
  }

  //  [emitter impl] void QGraphicsOpacityEffect::enabledChanged(bool enabled)
  void emitter_QGraphicsOpacityEffect_enabledChanged_864(bool enabled)
  {
    emit QGraphicsOpacityEffect::enabledChanged(enabled);
  }

  //  [adaptor impl] bool QGraphicsOpacityEffect::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QGraphicsOpacityEffect::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QGraphicsOpacityEffect_Adaptor, bool, QEvent *>(&QGraphicsOpacityEffect_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QGraphicsOpacityEffect::event(_event);
    }
  }

  //  [adaptor impl] bool QGraphicsOpacityEffect::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QGraphicsOpacityEffect::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QGraphicsOpacityEffect_Adaptor, bool, QObject *, QEvent *>(&QGraphicsOpacityEffect_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QGraphicsOpacityEffect::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QGraphicsOpacityEffect::objectNameChanged(const QString &objectName)
  void emitter_QGraphicsOpacityEffect_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QGraphicsOpacityEffect::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QGraphicsOpacityEffect::opacityChanged(double opacity)
  void emitter_QGraphicsOpacityEffect_opacityChanged_1071(double opacity)
  {
    emit QGraphicsOpacityEffect::opacityChanged(opacity);
  }

  //  [emitter impl] void QGraphicsOpacityEffect::opacityMaskChanged(const QBrush &mask)
  void emitter_QGraphicsOpacityEffect_opacityMaskChanged_1910(const QBrush &mask)
  {
    emit QGraphicsOpacityEffect::opacityMaskChanged(mask);
  }

  //  [adaptor impl] void QGraphicsOpacityEffect::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QGraphicsOpacityEffect::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QGraphicsOpacityEffect_Adaptor, QChildEvent *>(&QGraphicsOpacityEffect_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QGraphicsOpacityEffect::childEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsOpacityEffect::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QGraphicsOpacityEffect::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QGraphicsOpacityEffect_Adaptor, QEvent *>(&QGraphicsOpacityEffect_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QGraphicsOpacityEffect::customEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsOpacityEffect::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QGraphicsOpacityEffect::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QGraphicsOpacityEffect_Adaptor, const QMetaMethod &>(&QGraphicsOpacityEffect_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QGraphicsOpacityEffect::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QGraphicsOpacityEffect::draw(QPainter *painter)
  void cbs_draw_1426_0(QPainter *painter)
  {
    QGraphicsOpacityEffect::draw(painter);
  }

  virtual void draw(QPainter *painter)
  {
    if (cb_draw_1426_0.can_issue()) {
      cb_draw_1426_0.issue<QGraphicsOpacityEffect_Adaptor, QPainter *>(&QGraphicsOpacityEffect_Adaptor::cbs_draw_1426_0, painter);
    } else {
      QGraphicsOpacityEffect::draw(painter);
    }
  }

  //  [adaptor impl] void QGraphicsOpacityEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)
  void cbs_sourceChanged_3695_0(QFlags<QGraphicsEffect::ChangeFlag> flags)
  {
    QGraphicsOpacityEffect::sourceChanged(flags);
  }

  virtual void sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)
  {
    if (cb_sourceChanged_3695_0.can_issue()) {
      cb_sourceChanged_3695_0.issue<QGraphicsOpacityEffect_Adaptor, QFlags<QGraphicsEffect::ChangeFlag> >(&QGraphicsOpacityEffect_Adaptor::cbs_sourceChanged_3695_0, flags);
    } else {
      QGraphicsOpacityEffect::sourceChanged(flags);
    }
  }

  //  [adaptor impl] void QGraphicsOpacityEffect::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QGraphicsOpacityEffect::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QGraphicsOpacityEffect_Adaptor, QTimerEvent *>(&QGraphicsOpacityEffect_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QGraphicsOpacityEffect::timerEvent(event);
    }
  }

  gsi::Callback cb_boundingRectFor_c1862_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_draw_1426_0;
  gsi::Callback cb_sourceChanged_3695_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QGraphicsOpacityEffect_Adaptor::~QGraphicsOpacityEffect_Adaptor() { }

//  Constructor QGraphicsOpacityEffect::QGraphicsOpacityEffect(QObject *parent) (adaptor class)

static void _init_ctor_QGraphicsOpacityEffect_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QGraphicsOpacityEffect_Adaptor> ();
}

static void _call_ctor_QGraphicsOpacityEffect_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QGraphicsOpacityEffect_Adaptor *> (new QGraphicsOpacityEffect_Adaptor (arg1));
}


// QRectF QGraphicsOpacityEffect::boundingRectFor(const QRectF &sourceRect)

static void _init_cbs_boundingRectFor_c1862_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceRect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_cbs_boundingRectFor_c1862_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = args.read<const QRectF & > (heap);
  ret.write<QRectF > ((QRectF)((QGraphicsOpacityEffect_Adaptor *)cls)->cbs_boundingRectFor_c1862_0 (arg1));
}

static void _set_callback_cbs_boundingRectFor_c1862_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cb_boundingRectFor_c1862_0 = cb;
}


// void QGraphicsOpacityEffect::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QGraphicsOpacityEffect::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QGraphicsOpacityEffect::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QGraphicsOpacityEffect_Adaptor *)cls)->emitter_QGraphicsOpacityEffect_destroyed_1302 (arg1);
}


// void QGraphicsOpacityEffect::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QGraphicsOpacityEffect::draw(QPainter *painter)

static void _init_cbs_draw_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_draw_1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cbs_draw_1426_0 (arg1);
}

static void _set_callback_cbs_draw_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cb_draw_1426_0 = cb;
}


// exposed void QGraphicsOpacityEffect::drawSource(QPainter *painter)

static void _init_fp_drawSource_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawSource_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsOpacityEffect_Adaptor *)cls)->fp_QGraphicsOpacityEffect_drawSource_1426 (arg1);
}


// emitter void QGraphicsOpacityEffect::enabledChanged(bool enabled)

static void _init_emitter_enabledChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_enabledChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QGraphicsOpacityEffect_Adaptor *)cls)->emitter_QGraphicsOpacityEffect_enabledChanged_864 (arg1);
}


// bool QGraphicsOpacityEffect::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsOpacityEffect_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QGraphicsOpacityEffect::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsOpacityEffect_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QGraphicsOpacityEffect::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QGraphicsOpacityEffect_Adaptor *)cls)->fp_QGraphicsOpacityEffect_isSignalConnected_c2394 (arg1));
}


// emitter void QGraphicsOpacityEffect::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QGraphicsOpacityEffect_Adaptor *)cls)->emitter_QGraphicsOpacityEffect_objectNameChanged_4567 (arg1);
}


// emitter void QGraphicsOpacityEffect::opacityChanged(double opacity)

static void _init_emitter_opacityChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("opacity");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_opacityChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ((QGraphicsOpacityEffect_Adaptor *)cls)->emitter_QGraphicsOpacityEffect_opacityChanged_1071 (arg1);
}


// emitter void QGraphicsOpacityEffect::opacityMaskChanged(const QBrush &mask)

static void _init_emitter_opacityMaskChanged_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mask");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_opacityMaskChanged_1910 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QBrush &arg1 = gsi::arg_reader<const QBrush & >() (args, heap);
  ((QGraphicsOpacityEffect_Adaptor *)cls)->emitter_QGraphicsOpacityEffect_opacityMaskChanged_1910 (arg1);
}


// exposed int QGraphicsOpacityEffect::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QGraphicsOpacityEffect_Adaptor *)cls)->fp_QGraphicsOpacityEffect_receivers_c1731 (arg1));
}


// exposed QObject *QGraphicsOpacityEffect::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QGraphicsOpacityEffect_Adaptor *)cls)->fp_QGraphicsOpacityEffect_sender_c0 ());
}


// exposed int QGraphicsOpacityEffect::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGraphicsOpacityEffect_Adaptor *)cls)->fp_QGraphicsOpacityEffect_senderSignalIndex_c0 ());
}


// exposed QRectF QGraphicsOpacityEffect::sourceBoundingRect(Qt::CoordinateSystem system)

static void _init_fp_sourceBoundingRect_c2426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("system", true, "Qt::LogicalCoordinates");
  decl->add_arg<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_fp_sourceBoundingRect_c2426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::CoordinateSystem>(heap, Qt::LogicalCoordinates), heap);
  ret.write<QRectF > ((QRectF)((QGraphicsOpacityEffect_Adaptor *)cls)->fp_QGraphicsOpacityEffect_sourceBoundingRect_c2426 (arg1));
}


// void QGraphicsOpacityEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)

static void _init_cbs_sourceChanged_3695_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<QFlags<QGraphicsEffect::ChangeFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_sourceChanged_3695_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QGraphicsEffect::ChangeFlag> arg1 = args.read<QFlags<QGraphicsEffect::ChangeFlag> > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cbs_sourceChanged_3695_0 (arg1);
}

static void _set_callback_cbs_sourceChanged_3695_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cb_sourceChanged_3695_0 = cb;
}


// exposed bool QGraphicsOpacityEffect::sourceIsPixmap()

static void _init_fp_sourceIsPixmap_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_sourceIsPixmap_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QGraphicsOpacityEffect_Adaptor *)cls)->fp_QGraphicsOpacityEffect_sourceIsPixmap_c0 ());
}


// exposed QPixmap QGraphicsOpacityEffect::sourcePixmap(Qt::CoordinateSystem system, QPoint *offset, QGraphicsEffect::PixmapPadMode mode)

static void _init_fp_sourcePixmap_c6763 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("system", true, "Qt::LogicalCoordinates");
  decl->add_arg<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("offset", true, "nullptr");
  decl->add_arg<QPoint * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "QGraphicsEffect::PadToEffectiveBoundingRect");
  decl->add_arg<const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_fp_sourcePixmap_c6763 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::CoordinateSystem>(heap, Qt::LogicalCoordinates), heap);
  QPoint *arg2 = args ? gsi::arg_reader<QPoint * >() (args, heap) : gsi::arg_maker<QPoint * >() (nullptr, heap);
  const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QGraphicsEffect::PixmapPadMode>(heap, QGraphicsEffect::PadToEffectiveBoundingRect), heap);
  ret.write<QPixmap > ((QPixmap)((QGraphicsOpacityEffect_Adaptor *)cls)->fp_QGraphicsOpacityEffect_sourcePixmap_c6763 (arg1, arg2, arg3));
}


// void QGraphicsOpacityEffect::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QGraphicsOpacityEffect::updateBoundingRect()

static void _init_fp_updateBoundingRect_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateBoundingRect_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsOpacityEffect_Adaptor *)cls)->fp_QGraphicsOpacityEffect_updateBoundingRect_0 ();
}


namespace gsi
{

gsi::Class<QGraphicsOpacityEffect> &qtdecl_QGraphicsOpacityEffect ();

static gsi::Methods methods_QGraphicsOpacityEffect_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsOpacityEffect::QGraphicsOpacityEffect(QObject *parent)\nThis method creates an object of class QGraphicsOpacityEffect.", &_init_ctor_QGraphicsOpacityEffect_Adaptor_1302, &_call_ctor_QGraphicsOpacityEffect_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("boundingRectFor", "@brief Virtual method QRectF QGraphicsOpacityEffect::boundingRectFor(const QRectF &sourceRect)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_boundingRectFor_c1862_0, &_call_cbs_boundingRectFor_c1862_0);
  methods += new qt_gsi::GenericMethod ("boundingRectFor", "@hide", true, &_init_cbs_boundingRectFor_c1862_0, &_call_cbs_boundingRectFor_c1862_0, &_set_callback_cbs_boundingRectFor_c1862_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QGraphicsOpacityEffect::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QGraphicsOpacityEffect::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QGraphicsOpacityEffect::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QGraphicsOpacityEffect::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*draw", "@brief Virtual method void QGraphicsOpacityEffect::draw(QPainter *painter)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_draw_1426_0, &_call_cbs_draw_1426_0);
  methods += new qt_gsi::GenericMethod ("*draw", "@hide", false, &_init_cbs_draw_1426_0, &_call_cbs_draw_1426_0, &_set_callback_cbs_draw_1426_0);
  methods += new qt_gsi::GenericMethod ("*drawSource", "@brief Method void QGraphicsOpacityEffect::drawSource(QPainter *painter)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawSource_1426, &_call_fp_drawSource_1426);
  methods += new qt_gsi::GenericMethod ("emit_enabledChanged", "@brief Emitter for signal void QGraphicsOpacityEffect::enabledChanged(bool enabled)\nCall this method to emit this signal.", false, &_init_emitter_enabledChanged_864, &_call_emitter_enabledChanged_864);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QGraphicsOpacityEffect::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QGraphicsOpacityEffect::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QGraphicsOpacityEffect::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QGraphicsOpacityEffect::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("emit_opacityChanged", "@brief Emitter for signal void QGraphicsOpacityEffect::opacityChanged(double opacity)\nCall this method to emit this signal.", false, &_init_emitter_opacityChanged_1071, &_call_emitter_opacityChanged_1071);
  methods += new qt_gsi::GenericMethod ("emit_opacityMaskChanged", "@brief Emitter for signal void QGraphicsOpacityEffect::opacityMaskChanged(const QBrush &mask)\nCall this method to emit this signal.", false, &_init_emitter_opacityMaskChanged_1910, &_call_emitter_opacityMaskChanged_1910);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QGraphicsOpacityEffect::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QGraphicsOpacityEffect::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QGraphicsOpacityEffect::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*sourceBoundingRect", "@brief Method QRectF QGraphicsOpacityEffect::sourceBoundingRect(Qt::CoordinateSystem system)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sourceBoundingRect_c2426, &_call_fp_sourceBoundingRect_c2426);
  methods += new qt_gsi::GenericMethod ("*sourceChanged", "@brief Virtual method void QGraphicsOpacityEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sourceChanged_3695_0, &_call_cbs_sourceChanged_3695_0);
  methods += new qt_gsi::GenericMethod ("*sourceChanged", "@hide", false, &_init_cbs_sourceChanged_3695_0, &_call_cbs_sourceChanged_3695_0, &_set_callback_cbs_sourceChanged_3695_0);
  methods += new qt_gsi::GenericMethod ("*sourceIsPixmap", "@brief Method bool QGraphicsOpacityEffect::sourceIsPixmap()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sourceIsPixmap_c0, &_call_fp_sourceIsPixmap_c0);
  methods += new qt_gsi::GenericMethod ("*sourcePixmap", "@brief Method QPixmap QGraphicsOpacityEffect::sourcePixmap(Qt::CoordinateSystem system, QPoint *offset, QGraphicsEffect::PixmapPadMode mode)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sourcePixmap_c6763, &_call_fp_sourcePixmap_c6763);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QGraphicsOpacityEffect::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateBoundingRect", "@brief Method void QGraphicsOpacityEffect::updateBoundingRect()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateBoundingRect_0, &_call_fp_updateBoundingRect_0);
  return methods;
}

gsi::Class<QGraphicsOpacityEffect_Adaptor> decl_QGraphicsOpacityEffect_Adaptor (qtdecl_QGraphicsOpacityEffect (), "QtWidgets", "QGraphicsOpacityEffect",
  methods_QGraphicsOpacityEffect_Adaptor (),
  "@qt\n@brief Binding of QGraphicsOpacityEffect");

}

