/*
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 */


/*!
    \file   lcmaps.h
    \brief  Basic interface of the LCMAPS library.
    \author Martijn Steenbakkers for the EU DataGrid.
    \author Oscar Koeroo for the EGEE project.

    In order to use this API, please set in your application the following
    defines:
    \def    LCMAPS_GSI_MODE
    \brief If set, the GSI dependent interface can be used
    \b LCMAPS_USE_DLOPEN
    \brief If set, the interface takes care of loading the LCMAPS libraries with
    dlopen (so it has no link dependency to any particular version).
    \ingroup LcmapsInterface
*/
/**
    \defgroup LcmapsInterface The LCMAPS API for LCMAPS clients
    \brief The API is available by including one of the specific
    interface header files:

    - \ref lcmaps_return_account_from_pem.h
    - \ref lcmaps_verify_account_from_pem.h

    See \ref lcmaps_client.c "the examples" for an example of how to use the interface.

    FIXME: explain the actual interface.

    \example lcmaps_client.c
    This is an example program that uses the interface.

    It uses only one of the four different interfaces, but the others work along
    similar lines.
    
    For details on the various macros used in this example, see 
    \ref lcmaps_if.h "the interface definition".  */


#ifndef LCMAPS_H
#define LCMAPS_H

/******************************************************************************
                             Include header files
******************************************************************************/

#ifdef LCMAPS_GSI_MODE
#    include "lcmaps_openssl.h"
#    include "lcmaps_globus.h"
#else
#    include "lcmaps_basic.h"
#endif


/**
   \fn lcmaps_disable_voms_attributes_verification
   This is the lcmaps_disable_voms_attributes_verification function documentation

 */

#endif /* LCMAPS_H */
