/*
 * Copyright (C) 2023 Linux Studio Plugins Project <https://lsp-plug.in/>
 *           (C) 2023 Vladimir Sadovnikov <sadko4u@gmail.com>
 *
 * This file is part of lsp-dsp-lib
 * Created on: 22 апр. 2023 г.
 *
 * lsp-dsp-lib is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * lsp-dsp-lib is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with lsp-dsp-lib. If not, see <https://www.gnu.org/licenses/>.
 */

#include <lsp-plug.in/common/finally.h>
#include <lsp-plug.in/dsp/dsp.h>
#include <lsp-plug.in/test-fw/ByteBuffer.h>
#include <lsp-plug.in/test-fw/utest.h>

#include <private/utest/dsp/bitmap/util.h>

namespace lsp
{
    namespace generic
    {
        void bitmap_put_b8b8(dsp::bitmap_t *dst, const dsp::bitmap_t *src, ssize_t x, ssize_t y);
        void bitmap_add_b8b8(dsp::bitmap_t *dst, const dsp::bitmap_t *src, ssize_t x, ssize_t y);
        void bitmap_sub_b8b8(dsp::bitmap_t *dst, const dsp::bitmap_t *src, ssize_t x, ssize_t y);
        void bitmap_max_b8b8(dsp::bitmap_t *dst, const dsp::bitmap_t *src, ssize_t x, ssize_t y);
        void bitmap_min_b8b8(dsp::bitmap_t *dst, const dsp::bitmap_t *src, ssize_t x, ssize_t y);
    }
} /* namespace lsp */

namespace lsp
{
    namespace test
    {
        static uint8_t bitmap_data[] =
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4a, 0xb1, 0xe7, 0xf9, 0xe6, 0xcb, 0x93, 0x41, 0x00, 0x00, 0x00, 0xd0, 0xff, 0xff, 0xff, 0xfd, 0xf1, 0xd1, 0x93, 0x27, 0x00, 0x00, 0x00,
            0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xff, 0xe1, 0xc6, 0xd9, 0xfe, 0xff, 0xc5, 0x00, 0x00, 0x00, 0xd0, 0xff, 0xd4, 0xc0, 0xc2, 0xd7, 0xfc, 0xff, 0xf8, 0x54, 0x00, 0x00,
            0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xff, 0xfa, 0x4d, 0x00, 0x00, 0x00, 0x18, 0x7b, 0x59, 0x00, 0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x18, 0xb3, 0xff, 0xf2, 0x14, 0x00,
            0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8e, 0xff, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xec, 0xff, 0x62, 0x00,
            0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa1, 0xff, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0xba, 0xff, 0x84, 0x00,
            0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xd1, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb6, 0xff, 0x77, 0x00,
            0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0xf9, 0xff, 0xbb, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x0d, 0xef, 0xff, 0x42, 0x00,
            0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x56, 0xf5, 0xff, 0xfc, 0xac, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x27, 0xbb, 0xff, 0xcf, 0x02, 0x00,
            0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xb0, 0xfe, 0xff, 0xff, 0xca, 0x37, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0xd4, 0xc0, 0xc6, 0xe2, 0xff, 0xff, 0xd8, 0x24, 0x00, 0x00,
            0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0x99, 0xf8, 0xff, 0xfa, 0x52, 0x00, 0x00, 0x00, 0xd0, 0xff, 0xff, 0xff, 0xf8, 0xe3, 0xbd, 0x6a, 0x09, 0x00, 0x00, 0x00,
            0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xc4, 0xff, 0xef, 0x0a, 0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0xf5, 0xff, 0x44, 0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd1, 0xff, 0x54, 0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0xf4, 0xff, 0x33, 0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x3e, 0x05, 0x00, 0x00, 0x00, 0x19, 0xb0, 0xff, 0xd1, 0x01, 0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0xd0, 0xff, 0xf2, 0xec, 0xec, 0xec, 0xec, 0xec, 0xec, 0x4d, 0x00, 0xd8, 0xff, 0xf9, 0xd4, 0xc4, 0xd8, 0xf9, 0xff, 0xe3, 0x28, 0x00, 0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0xd0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x54, 0x00, 0x58, 0xae, 0xd8, 0xeb, 0xfb, 0xf1, 0xca, 0x7b, 0x0f, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        };

        static const lsp::dsp::bitmap_t bitmap =
        {
            38, // width
            33, // height
            38, // stride
            bitmap_data // data
        };

        typedef void (* bitmap_func_b1b8_t)(lsp::dsp::bitmap_t *dst, const lsp::dsp::bitmap_t *src, ssize_t x, ssize_t y);

        static const bitmap_pattern_t put_patterns[] =
        {
            {
                0, 0,
                0x88,
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000d0ff50000000000000000000004ab1e7f9e6cb9341000000d0fffffffdf1d19327000000\n"
                "0000d0ff500000000000000000008effffe1c6d9feffc5000000d0ffd4c0c2d7fcfff8540000\n"
                "0000d0ff50000000000000000040fffa4d000000187b59000000d0ff5000000018b3fff21400\n"
                "0000d0ff5000000000000000008effa200000000000000000000d0ff50000000000decff6200\n"
                "0000d0ff500000000000000000a1ff8a00000000000000000000d0ff500000000000baff8400\n"
                "0000d0ff50000000000000000080ffd105000000000000000000d0ff500000000000b6ff7700\n"
                "0000d0ff50000000000000000025f9ffbb250000000000000000d0ff50000000000defff4200\n"
                "0000d0ff5000000000000000000056f5fffcac3f000000000000d0ff5000000027bbffcf0200\n"
                "0000d0ff50000000000000000000002ab0feffffca3700000000d0ffd4c0c6e2ffffd8240000\n"
                "0000d0ff500000000000000000000000002b99f8fffa52000000d0fffffff8e3bd6a09000000\n"
                "0000d0ff5000000000000000000000000000001fc4ffef0a0000d0ff50000000000000000000\n"
                "0000d0ff5000000000000000000000000000000011f5ff440000d0ff50000000000000000000\n"
                "0000d0ff5000000000000000000000000000000000d1ff540000d0ff50000000000000000000\n"
                "0000d0ff500000000000000000000000000000000af4ff330000d0ff50000000000000000000\n"
                "0000d0ff500000000000000000783e0500000019b0ffd1010000d0ff50000000000000000000\n"
                "0000d0fff2ecececececec4d00d8fff9d4c4d8f9ffe328000000d0ff50000000000000000000\n"
                "0000d0ffffffffffffffff540058aed8ebfbf1ca7b0f00000000d0ff50000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
            },
            {
                -8, -8,
                0x88,
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "000000000000004ab1e7f9e6cb9341000000d0fffffffdf1d193270000008888888888888888\n"
                "0000000000008effffe1c6d9feffc5000000d0ffd4c0c2d7fcfff85400008888888888888888\n"
                "000000000040fffa4d000000187b59000000d0ff5000000018b3fff214008888888888888888\n"
                "00000000008effa200000000000000000000d0ff50000000000decff62008888888888888888\n"
                "0000000000a1ff8a00000000000000000000d0ff500000000000baff84008888888888888888\n"
                "000000000080ffd105000000000000000000d0ff500000000000b6ff77008888888888888888\n"
                "000000000025f9ffbb250000000000000000d0ff50000000000defff42008888888888888888\n"
                "00000000000056f5fffcac3f000000000000d0ff5000000027bbffcf02008888888888888888\n"
                "000000000000002ab0feffffca3700000000d0ffd4c0c6e2ffffd82400008888888888888888\n"
                "0000000000000000002b99f8fffa52000000d0fffffff8e3bd6a090000008888888888888888\n"
                "00000000000000000000001fc4ffef0a0000d0ff500000000000000000008888888888888888\n"
                "00000000000000000000000011f5ff440000d0ff500000000000000000008888888888888888\n"
                "00000000000000000000000000d1ff540000d0ff500000000000000000008888888888888888\n"
                "0000000000000000000000000af4ff330000d0ff500000000000000000008888888888888888\n"
                "0000000000783e0500000019b0ffd1010000d0ff500000000000000000008888888888888888\n"
                "ececec4d00d8fff9d4c4d8f9ffe328000000d0ff500000000000000000008888888888888888\n"
                "ffffff540058aed8ebfbf1ca7b0f00000000d0ff500000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
            },
            {
                8, -8,
                0x88,
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "88888888888888880000d0ff50000000000000000000004ab1e7f9e6cb9341000000d0ffffff\n"
                "88888888888888880000d0ff500000000000000000008effffe1c6d9feffc5000000d0ffd4c0\n"
                "88888888888888880000d0ff50000000000000000040fffa4d000000187b59000000d0ff5000\n"
                "88888888888888880000d0ff5000000000000000008effa200000000000000000000d0ff5000\n"
                "88888888888888880000d0ff500000000000000000a1ff8a00000000000000000000d0ff5000\n"
                "88888888888888880000d0ff50000000000000000080ffd105000000000000000000d0ff5000\n"
                "88888888888888880000d0ff50000000000000000025f9ffbb250000000000000000d0ff5000\n"
                "88888888888888880000d0ff5000000000000000000056f5fffcac3f000000000000d0ff5000\n"
                "88888888888888880000d0ff50000000000000000000002ab0feffffca3700000000d0ffd4c0\n"
                "88888888888888880000d0ff500000000000000000000000002b99f8fffa52000000d0ffffff\n"
                "88888888888888880000d0ff5000000000000000000000000000001fc4ffef0a0000d0ff5000\n"
                "88888888888888880000d0ff5000000000000000000000000000000011f5ff440000d0ff5000\n"
                "88888888888888880000d0ff5000000000000000000000000000000000d1ff540000d0ff5000\n"
                "88888888888888880000d0ff500000000000000000000000000000000af4ff330000d0ff5000\n"
                "88888888888888880000d0ff500000000000000000783e0500000019b0ffd1010000d0ff5000\n"
                "88888888888888880000d0fff2ecececececec4d00d8fff9d4c4d8f9ffe328000000d0ff5000\n"
                "88888888888888880000d0ffffffffffffffff540058aed8ebfbf1ca7b0f00000000d0ff5000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
            },
            {
                8, 8,
                0x88,
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "8888888888888888000000000000000000000000000000000000000000000000000000000000\n"
                "88888888888888880000d0ff50000000000000000000004ab1e7f9e6cb9341000000d0ffffff\n"
                "88888888888888880000d0ff500000000000000000008effffe1c6d9feffc5000000d0ffd4c0\n"
                "88888888888888880000d0ff50000000000000000040fffa4d000000187b59000000d0ff5000\n"
                "88888888888888880000d0ff5000000000000000008effa200000000000000000000d0ff5000\n"
                "88888888888888880000d0ff500000000000000000a1ff8a00000000000000000000d0ff5000\n"
                "88888888888888880000d0ff50000000000000000080ffd105000000000000000000d0ff5000\n"
                "88888888888888880000d0ff50000000000000000025f9ffbb250000000000000000d0ff5000\n"
                "88888888888888880000d0ff5000000000000000000056f5fffcac3f000000000000d0ff5000\n"
                "88888888888888880000d0ff50000000000000000000002ab0feffffca3700000000d0ffd4c0\n"
                "88888888888888880000d0ff500000000000000000000000002b99f8fffa52000000d0ffffff\n"
                "88888888888888880000d0ff5000000000000000000000000000001fc4ffef0a0000d0ff5000\n"
                "88888888888888880000d0ff5000000000000000000000000000000011f5ff440000d0ff5000\n"
                "88888888888888880000d0ff5000000000000000000000000000000000d1ff540000d0ff5000\n"
                "88888888888888880000d0ff500000000000000000000000000000000af4ff330000d0ff5000\n"
                "88888888888888880000d0ff500000000000000000783e0500000019b0ffd1010000d0ff5000\n"
                "88888888888888880000d0fff2ecececececec4d00d8fff9d4c4d8f9ffe328000000d0ff5000\n"
            },
            {
                -8, 8,
                0x88,
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "0000000000000000000000000000000000000000000000000000000000008888888888888888\n"
                "000000000000004ab1e7f9e6cb9341000000d0fffffffdf1d193270000008888888888888888\n"
                "0000000000008effffe1c6d9feffc5000000d0ffd4c0c2d7fcfff85400008888888888888888\n"
                "000000000040fffa4d000000187b59000000d0ff5000000018b3fff214008888888888888888\n"
                "00000000008effa200000000000000000000d0ff50000000000decff62008888888888888888\n"
                "0000000000a1ff8a00000000000000000000d0ff500000000000baff84008888888888888888\n"
                "000000000080ffd105000000000000000000d0ff500000000000b6ff77008888888888888888\n"
                "000000000025f9ffbb250000000000000000d0ff50000000000defff42008888888888888888\n"
                "00000000000056f5fffcac3f000000000000d0ff5000000027bbffcf02008888888888888888\n"
                "000000000000002ab0feffffca3700000000d0ffd4c0c6e2ffffd82400008888888888888888\n"
                "0000000000000000002b99f8fffa52000000d0fffffff8e3bd6a090000008888888888888888\n"
                "00000000000000000000001fc4ffef0a0000d0ff500000000000000000008888888888888888\n"
                "00000000000000000000000011f5ff440000d0ff500000000000000000008888888888888888\n"
                "00000000000000000000000000d1ff540000d0ff500000000000000000008888888888888888\n"
                "0000000000000000000000000af4ff330000d0ff500000000000000000008888888888888888\n"
                "0000000000783e0500000019b0ffd1010000d0ff500000000000000000008888888888888888\n"
                "ececec4d00d8fff9d4c4d8f9ffe328000000d0ff500000000000000000008888888888888888\n"
            },
            {
                0, 0,
                0,
                NULL
            }
        };

        static const bitmap_pattern_t add_patterns[] =
        {
            {
                0, 0,
                0x11,
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111e1ff61111111111111111111115bc2f8fff7dca452111111e1ffffffffffe2a438111111\n"
                "1111e1ff611111111111111111119ffffff2d7eaffffd6111111e1ffe5d1d3e8ffffff651111\n"
                "1111e1ff61111111111111111151ffff5e111111298c6a111111e1ff6111111129c4ffff2511\n"
                "1111e1ff6111111111111111119fffb311111111111111111111e1ff61111111111efdff7311\n"
                "1111e1ff611111111111111111b2ff9b11111111111111111111e1ff611111111111cbff9511\n"
                "1111e1ff61111111111111111191ffe216111111111111111111e1ff611111111111c7ff8811\n"
                "1111e1ff61111111111111111136ffffcc361111111111111111e1ff61111111111effff5311\n"
                "1111e1ff6111111111111111111167ffffffbd50111111111111e1ff6111111138ccffe01311\n"
                "1111e1ff61111111111111111111113bc1ffffffdb4811111111e1ffe5d1d7f3ffffe9351111\n"
                "1111e1ff611111111111111111111111113caaffffff63111111e1fffffffff4ce7b1a111111\n"
                "1111e1ff61111111111111111111111111111130d5ffff1b1111e1ff61111111111111111111\n"
                "1111e1ff6111111111111111111111111111111122ffff551111e1ff61111111111111111111\n"
                "1111e1ff6111111111111111111111111111111111e2ff651111e1ff61111111111111111111\n"
                "1111e1ff611111111111111111111111111111111bffff441111e1ff61111111111111111111\n"
                "1111e1ff611111111111111111894f161111112ac1ffe2121111e1ff61111111111111111111\n"
                "1111e1fffffdfdfdfdfdfd5e11e9ffffe5d5e9fffff439111111e1ff61111111111111111111\n"
                "1111e1ffffffffffffffff651169bfe9fcffffdb8c2011111111e1ff61111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
            },
            {
                -9, -9,
                0x11,
                "1111111111115bc2f8fff7dca452111111e1ffffffffffe2a438111111111111111111111111\n"
                "11111111119ffffff2d7eaffffd6111111e1ffe5d1d3e8ffffff651111111111111111111111\n"
                "1111111151ffff5e111111298c6a111111e1ff6111111129c4ffff2511111111111111111111\n"
                "111111119fffb311111111111111111111e1ff61111111111efdff7311111111111111111111\n"
                "11111111b2ff9b11111111111111111111e1ff611111111111cbff9511111111111111111111\n"
                "1111111191ffe216111111111111111111e1ff611111111111c7ff8811111111111111111111\n"
                "1111111136ffffcc361111111111111111e1ff61111111111effff5311111111111111111111\n"
                "111111111167ffffffbd50111111111111e1ff6111111138ccffe01311111111111111111111\n"
                "1111111111113bc1ffffffdb4811111111e1ffe5d1d7f3ffffe9351111111111111111111111\n"
                "11111111111111113caaffffff63111111e1fffffffff4ce7b1a111111111111111111111111\n"
                "1111111111111111111130d5ffff1b1111e1ff61111111111111111111111111111111111111\n"
                "111111111111111111111122ffff551111e1ff61111111111111111111111111111111111111\n"
                "111111111111111111111111e2ff651111e1ff61111111111111111111111111111111111111\n"
                "11111111111111111111111bffff441111e1ff61111111111111111111111111111111111111\n"
                "11111111894f161111112ac1ffe2121111e1ff61111111111111111111111111111111111111\n"
                "fdfd5e11e9ffffe5d5e9fffff439111111e1ff61111111111111111111111111111111111111\n"
                "ffff651169bfe9fcffffdb8c2011111111e1ff61111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
            },
            {
                10, -10,
                0x11,
                "111111111111111111111111e1ff611111111111111111119ffffff2d7eaffffd6111111e1ff\n"
                "111111111111111111111111e1ff61111111111111111151ffff5e111111298c6a111111e1ff\n"
                "111111111111111111111111e1ff6111111111111111119fffb311111111111111111111e1ff\n"
                "111111111111111111111111e1ff611111111111111111b2ff9b11111111111111111111e1ff\n"
                "111111111111111111111111e1ff61111111111111111191ffe216111111111111111111e1ff\n"
                "111111111111111111111111e1ff61111111111111111136ffffcc361111111111111111e1ff\n"
                "111111111111111111111111e1ff6111111111111111111167ffffffbd50111111111111e1ff\n"
                "111111111111111111111111e1ff61111111111111111111113bc1ffffffdb4811111111e1ff\n"
                "111111111111111111111111e1ff611111111111111111111111113caaffffff63111111e1ff\n"
                "111111111111111111111111e1ff61111111111111111111111111111130d5ffff1b1111e1ff\n"
                "111111111111111111111111e1ff6111111111111111111111111111111122ffff551111e1ff\n"
                "111111111111111111111111e1ff6111111111111111111111111111111111e2ff651111e1ff\n"
                "111111111111111111111111e1ff611111111111111111111111111111111bffff441111e1ff\n"
                "111111111111111111111111e1ff611111111111111111894f161111112ac1ffe2121111e1ff\n"
                "111111111111111111111111e1fffffdfdfdfdfdfd5e11e9ffffe5d5e9fffff439111111e1ff\n"
                "111111111111111111111111e1ffffffffffffffff651169bfe9fcffffdb8c2011111111e1ff\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
            },
            {
                9, 11,
                0x11,
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111e1ff61111111111111111111115bc2f8fff7dca452111111e1ffff\n"
                "1111111111111111111111e1ff611111111111111111119ffffff2d7eaffffd6111111e1ffe5\n"
                "1111111111111111111111e1ff61111111111111111151ffff5e111111298c6a111111e1ff61\n"
                "1111111111111111111111e1ff6111111111111111119fffb311111111111111111111e1ff61\n"
                "1111111111111111111111e1ff611111111111111111b2ff9b11111111111111111111e1ff61\n"
                "1111111111111111111111e1ff61111111111111111191ffe216111111111111111111e1ff61\n"
                "1111111111111111111111e1ff61111111111111111136ffffcc361111111111111111e1ff61\n"
                "1111111111111111111111e1ff6111111111111111111167ffffffbd50111111111111e1ff61\n"
                "1111111111111111111111e1ff61111111111111111111113bc1ffffffdb4811111111e1ffe5\n"
                "1111111111111111111111e1ff611111111111111111111111113caaffffff63111111e1ffff\n"
                "1111111111111111111111e1ff61111111111111111111111111111130d5ffff1b1111e1ff61\n"
                "1111111111111111111111e1ff6111111111111111111111111111111122ffff551111e1ff61\n"
                "1111111111111111111111e1ff6111111111111111111111111111111111e2ff651111e1ff61\n"
            },
            {
                -11, 7,
                0x11,
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "111111115bc2f8fff7dca452111111e1ffffffffffe2a4381111111111111111111111111111\n"
                "1111119ffffff2d7eaffffd6111111e1ffe5d1d3e8ffffff6511111111111111111111111111\n"
                "111151ffff5e111111298c6a111111e1ff6111111129c4ffff25111111111111111111111111\n"
                "11119fffb311111111111111111111e1ff61111111111efdff73111111111111111111111111\n"
                "1111b2ff9b11111111111111111111e1ff611111111111cbff95111111111111111111111111\n"
                "111191ffe216111111111111111111e1ff611111111111c7ff88111111111111111111111111\n"
                "111136ffffcc361111111111111111e1ff61111111111effff53111111111111111111111111\n"
                "11111167ffffffbd50111111111111e1ff6111111138ccffe013111111111111111111111111\n"
                "111111113bc1ffffffdb4811111111e1ffe5d1d7f3ffffe93511111111111111111111111111\n"
                "1111111111113caaffffff63111111e1fffffffff4ce7b1a1111111111111111111111111111\n"
                "111111111111111130d5ffff1b1111e1ff611111111111111111111111111111111111111111\n"
                "11111111111111111122ffff551111e1ff611111111111111111111111111111111111111111\n"
                "11111111111111111111e2ff651111e1ff611111111111111111111111111111111111111111\n"
                "1111111111111111111bffff441111e1ff611111111111111111111111111111111111111111\n"
                "1111894f161111112ac1ffe2121111e1ff611111111111111111111111111111111111111111\n"
                "5e11e9ffffe5d5e9fffff439111111e1ff611111111111111111111111111111111111111111\n"
                "651169bfe9fcffffdb8c2011111111e1ff611111111111111111111111111111111111111111\n"
            },
            {
                0, 0,
                0,
                NULL
            }
        };

        static const bitmap_pattern_t sub_patterns[] =
        {
            {
                0, 0,
                0xee,
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeee1e009eeeeeeeeeeeeeeeeeeeeea43d070008235badeeeeee1e00000000001d5bc7eeeeee\n"
                "eeee1e009eeeeeeeeeeeeeeeeeee6000000d2815000029eeeeee1e001a2e2c170000009aeeee\n"
                "eeee1e009eeeeeeeeeeeeeeeeeae0000a1eeeeeed67395eeeeee1e009eeeeeeed63b0000daee\n"
                "eeee1e009eeeeeeeeeeeeeeeee60004ceeeeeeeeeeeeeeeeeeee1e009eeeeeeeeee102008cee\n"
                "eeee1e009eeeeeeeeeeeeeeeee4d0064eeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeee34006aee\n"
                "eeee1e009eeeeeeeeeeeeeeeee6e001de9eeeeeeeeeeeeeeeeee1e009eeeeeeeeeee380077ee\n"
                "eeee1e009eeeeeeeeeeeeeeeeec9000033c9eeeeeeeeeeeeeeee1e009eeeeeeeeee10000acee\n"
                "eeee1e009eeeeeeeeeeeeeeeeeee9800000042afeeeeeeeeeeee1e009eeeeeeec733001fecee\n"
                "eeee1e009eeeeeeeeeeeeeeeeeeeeec43e00000024b7eeeeeeee1e001a2e280c000016caeeee\n"
                "eeee1e009eeeeeeeeeeeeeeeeeeeeeeeeec3550000009ceeeeee1e000000000b3184e5eeeeee\n"
                "eeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeecf2a0000e4eeee1e009eeeeeeeeeeeeeeeeeee\n"
                "eeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeedd0000aaeeee1e009eeeeeeeeeeeeeeeeeee\n"
                "eeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee1d009aeeee1e009eeeeeeeeeeeeeeeeeee\n"
                "eeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee40000bbeeee1e009eeeeeeeeeeeeeeeeeee\n"
                "eeee1e009eeeeeeeeeeeeeeeee76b0e9eeeeeed53e001dedeeee1e009eeeeeeeeeeeeeeeeeee\n"
                "eeee1e0000020202020202a1ee1600001a2a1600000bc6eeeeee1e009eeeeeeeeeeeeeeeeeee\n"
                "eeee1e00000000000000009aee9640160300002473dfeeeeeeee1e009eeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
            },
            {
                -9, -9,
                0xee,
                "eeeeeeeeeeeea43d070008235badeeeeee1e00000000001d5bc7eeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeee6000000d2815000029eeeeee1e001a2e2c170000009aeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeae0000a1eeeeeed67395eeeeee1e009eeeeeeed63b0000daeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeee60004ceeeeeeeeeeeeeeeeeeee1e009eeeeeeeeee102008ceeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeee4d0064eeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeee34006aeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeee6e001de9eeeeeeeeeeeeeeeeee1e009eeeeeeeeeee380077eeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeec9000033c9eeeeeeeeeeeeeeee1e009eeeeeeeeee10000aceeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeee9800000042afeeeeeeeeeeee1e009eeeeeeec733001feceeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeec43e00000024b7eeeeeeee1e001a2e280c000016caeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeec3550000009ceeeeee1e000000000b3184e5eeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeecf2a0000e4eeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeedd0000aaeeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeee1d009aeeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeee40000bbeeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeee76b0e9eeeeeed53e001dedeeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "0202a1ee1600001a2a1600000bc6eeeeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "00009aee9640160300002473dfeeeeeeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
            },
            {
                10, -10,
                0xee,
                "eeeeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeeeee6000000d2815000029eeeeee1e00\n"
                "eeeeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeeeae0000a1eeeeeed67395eeeeee1e00\n"
                "eeeeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeee60004ceeeeeeeeeeeeeeeeeeee1e00\n"
                "eeeeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeee4d0064eeeeeeeeeeeeeeeeeeee1e00\n"
                "eeeeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeee6e001de9eeeeeeeeeeeeeeeeee1e00\n"
                "eeeeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeeec9000033c9eeeeeeeeeeeeeeee1e00\n"
                "eeeeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeeeee9800000042afeeeeeeeeeeee1e00\n"
                "eeeeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeeeeeeec43e00000024b7eeeeeeee1e00\n"
                "eeeeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeeeeeeeeeeec3550000009ceeeeee1e00\n"
                "eeeeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeecf2a0000e4eeee1e00\n"
                "eeeeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeedd0000aaeeee1e00\n"
                "eeeeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee1d009aeeee1e00\n"
                "eeeeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee40000bbeeee1e00\n"
                "eeeeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeee76b0e9eeeeeed53e001dedeeee1e00\n"
                "eeeeeeeeeeeeeeeeeeeeeeee1e0000020202020202a1ee1600001a2a1600000bc6eeeeee1e00\n"
                "eeeeeeeeeeeeeeeeeeeeeeee1e00000000000000009aee9640160300002473dfeeeeeeee1e00\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
            },
            {
                9, 11,
                0xee,
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeeeeeeea43d070008235badeeeeee1e0000\n"
                "eeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeeeee6000000d2815000029eeeeee1e001a\n"
                "eeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeeeae0000a1eeeeeed67395eeeeee1e009e\n"
                "eeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeee60004ceeeeeeeeeeeeeeeeeeee1e009e\n"
                "eeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeee4d0064eeeeeeeeeeeeeeeeeeee1e009e\n"
                "eeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeee6e001de9eeeeeeeeeeeeeeeeee1e009e\n"
                "eeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeeec9000033c9eeeeeeeeeeeeeeee1e009e\n"
                "eeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeeeee9800000042afeeeeeeeeeeee1e009e\n"
                "eeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeeeeeeec43e00000024b7eeeeeeee1e001a\n"
                "eeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeeeeeeeeeeec3550000009ceeeeee1e0000\n"
                "eeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeecf2a0000e4eeee1e009e\n"
                "eeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeedd0000aaeeee1e009e\n"
                "eeeeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee1d009aeeee1e009e\n"
            },
            {
                -11, 7,
                0xee,
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeea43d070008235badeeeeee1e00000000001d5bc7eeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeee6000000d2815000029eeeeee1e001a2e2c170000009aeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeae0000a1eeeeeed67395eeeeee1e009eeeeeeed63b0000daeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeee60004ceeeeeeeeeeeeeeeeeeee1e009eeeeeeeeee102008ceeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeee4d0064eeeeeeeeeeeeeeeeeeee1e009eeeeeeeeeee34006aeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeee6e001de9eeeeeeeeeeeeeeeeee1e009eeeeeeeeeee380077eeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeec9000033c9eeeeeeeeeeeeeeee1e009eeeeeeeeee10000aceeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeee9800000042afeeeeeeeeeeee1e009eeeeeeec733001feceeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeec43e00000024b7eeeeeeee1e001a2e280c000016caeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeec3550000009ceeeeee1e000000000b3184e5eeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeecf2a0000e4eeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeedd0000aaeeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeee1d009aeeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeee40000bbeeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeee76b0e9eeeeeed53e001dedeeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "a1ee1600001a2a1600000bc6eeeeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "9aee9640160300002473dfeeeeeeee1e009eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
            },
            {
                0, 0,
                0,
                NULL
            }
        };

        static const bitmap_pattern_t max_patterns[] =
        {
            {
                0, 0,
                0x88,
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888d0ff888888888888888888888888b1e7f9e6cb9388888888d0fffffffdf1d19388888888\n"
                "8888d0ff888888888888888888888effffe1c6d9feffc5888888d0ffd4c0c2d7fcfff8888888\n"
                "8888d0ff88888888888888888888fffa88888888888888888888d0ff8888888888b3fff28888\n"
                "8888d0ff8888888888888888888effa288888888888888888888d0ff888888888888ecff8888\n"
                "8888d0ff888888888888888888a1ff8a88888888888888888888d0ff888888888888baff8888\n"
                "8888d0ff88888888888888888888ffd188888888888888888888d0ff888888888888b6ff8888\n"
                "8888d0ff88888888888888888888f9ffbb888888888888888888d0ff888888888888efff8888\n"
                "8888d0ff8888888888888888888888f5fffcac88888888888888d0ff8888888888bbffcf8888\n"
                "8888d0ff888888888888888888888888b0feffffca8888888888d0ffd4c0c6e2ffffd8888888\n"
                "8888d0ff888888888888888888888888888899f8fffa88888888d0fffffff8e3bd8888888888\n"
                "8888d0ff88888888888888888888888888888888c4ffef888888d0ff88888888888888888888\n"
                "8888d0ff8888888888888888888888888888888888f5ff888888d0ff88888888888888888888\n"
                "8888d0ff8888888888888888888888888888888888d1ff888888d0ff88888888888888888888\n"
                "8888d0ff8888888888888888888888888888888888f4ff888888d0ff88888888888888888888\n"
                "8888d0ff88888888888888888888888888888888b0ffd1888888d0ff88888888888888888888\n"
                "8888d0fff2ecececececec8888d8fff9d4c4d8f9ffe388888888d0ff88888888888888888888\n"
                "8888d0ffffffffffffffff888888aed8ebfbf1ca888888888888d0ff88888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
            },
            {
                -9, -9,
                0x88,
                "88888888888888b1e7f9e6cb9388888888d0fffffffdf1d19388888888888888888888888888\n"
                "88888888888effffe1c6d9feffc5888888d0ffd4c0c2d7fcfff8888888888888888888888888\n"
                "8888888888fffa88888888888888888888d0ff8888888888b3fff28888888888888888888888\n"
                "888888888effa288888888888888888888d0ff888888888888ecff8888888888888888888888\n"
                "88888888a1ff8a88888888888888888888d0ff888888888888baff8888888888888888888888\n"
                "8888888888ffd188888888888888888888d0ff888888888888b6ff8888888888888888888888\n"
                "8888888888f9ffbb888888888888888888d0ff888888888888efff8888888888888888888888\n"
                "888888888888f5fffcac88888888888888d0ff8888888888bbffcf8888888888888888888888\n"
                "88888888888888b0feffffca8888888888d0ffd4c0c6e2ffffd8888888888888888888888888\n"
                "88888888888888888899f8fffa88888888d0fffffff8e3bd8888888888888888888888888888\n"
                "8888888888888888888888c4ffef888888d0ff88888888888888888888888888888888888888\n"
                "888888888888888888888888f5ff888888d0ff88888888888888888888888888888888888888\n"
                "888888888888888888888888d1ff888888d0ff88888888888888888888888888888888888888\n"
                "888888888888888888888888f4ff888888d0ff88888888888888888888888888888888888888\n"
                "8888888888888888888888b0ffd1888888d0ff88888888888888888888888888888888888888\n"
                "ecec8888d8fff9d4c4d8f9ffe388888888d0ff88888888888888888888888888888888888888\n"
                "ffff888888aed8ebfbf1ca888888888888d0ff88888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
                "8888888888888888888888888888888888888888888888888888888888888888888888888888\n"
            },
            {
                10, -10,
                0x11,
                "111111111111111111111111d0ff501111111111111111118effffe1c6d9feffc5111111d0ff\n"
                "111111111111111111111111d0ff50111111111111111140fffa4d111111187b59111111d0ff\n"
                "111111111111111111111111d0ff5011111111111111118effa211111111111111111111d0ff\n"
                "111111111111111111111111d0ff501111111111111111a1ff8a11111111111111111111d0ff\n"
                "111111111111111111111111d0ff50111111111111111180ffd111111111111111111111d0ff\n"
                "111111111111111111111111d0ff50111111111111111125f9ffbb251111111111111111d0ff\n"
                "111111111111111111111111d0ff5011111111111111111156f5fffcac3f111111111111d0ff\n"
                "111111111111111111111111d0ff50111111111111111111112ab0feffffca3711111111d0ff\n"
                "111111111111111111111111d0ff501111111111111111111111112b99f8fffa52111111d0ff\n"
                "111111111111111111111111d0ff5011111111111111111111111111111fc4ffef111111d0ff\n"
                "111111111111111111111111d0ff5011111111111111111111111111111111f5ff441111d0ff\n"
                "111111111111111111111111d0ff5011111111111111111111111111111111d1ff541111d0ff\n"
                "111111111111111111111111d0ff5011111111111111111111111111111111f4ff331111d0ff\n"
                "111111111111111111111111d0ff501111111111111111783e1111111119b0ffd1111111d0ff\n"
                "111111111111111111111111d0fff2ecececececec4d11d8fff9d4c4d8f9ffe328111111d0ff\n"
                "111111111111111111111111d0ffffffffffffffff541158aed8ebfbf1ca7b1111111111d0ff\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
            },
            {
                9, 11,
                0x55,
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555555555555555555555555555555555555555555555555555555555\n"
                "5555555555555555555555d0ff555555555555555555555555b1e7f9e6cb9355555555d0ffff\n"
                "5555555555555555555555d0ff555555555555555555558effffe1c6d9feffc5555555d0ffd4\n"
                "5555555555555555555555d0ff55555555555555555555fffa55555555557b59555555d0ff55\n"
                "5555555555555555555555d0ff5555555555555555558effa255555555555555555555d0ff55\n"
                "5555555555555555555555d0ff555555555555555555a1ff8a55555555555555555555d0ff55\n"
                "5555555555555555555555d0ff55555555555555555580ffd155555555555555555555d0ff55\n"
                "5555555555555555555555d0ff55555555555555555555f9ffbb555555555555555555d0ff55\n"
                "5555555555555555555555d0ff5555555555555555555556f5fffcac55555555555555d0ff55\n"
                "5555555555555555555555d0ff555555555555555555555555b0feffffca5555555555d0ffd4\n"
                "5555555555555555555555d0ff555555555555555555555555555599f8fffa55555555d0ffff\n"
                "5555555555555555555555d0ff55555555555555555555555555555555c4ffef555555d0ff55\n"
                "5555555555555555555555d0ff5555555555555555555555555555555555f5ff555555d0ff55\n"
                "5555555555555555555555d0ff5555555555555555555555555555555555d1ff555555d0ff55\n"
            },
            {
                -11, 7,
                0x11,
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "1111111111111111111111111111111111111111111111111111111111111111111111111111\n"
                "111111114ab1e7f9e6cb9341111111d0fffffffdf1d193271111111111111111111111111111\n"
                "1111118effffe1c6d9feffc5111111d0ffd4c0c2d7fcfff85411111111111111111111111111\n"
                "111140fffa4d111111187b59111111d0ff5011111118b3fff214111111111111111111111111\n"
                "11118effa211111111111111111111d0ff501111111111ecff62111111111111111111111111\n"
                "1111a1ff8a11111111111111111111d0ff501111111111baff84111111111111111111111111\n"
                "111180ffd111111111111111111111d0ff501111111111b6ff77111111111111111111111111\n"
                "111125f9ffbb251111111111111111d0ff501111111111efff42111111111111111111111111\n"
                "11111156f5fffcac3f111111111111d0ff5011111127bbffcf11111111111111111111111111\n"
                "111111112ab0feffffca3711111111d0ffd4c0c6e2ffffd82411111111111111111111111111\n"
                "1111111111112b99f8fffa52111111d0fffffff8e3bd6a111111111111111111111111111111\n"
                "11111111111111111fc4ffef111111d0ff501111111111111111111111111111111111111111\n"
                "11111111111111111111f5ff441111d0ff501111111111111111111111111111111111111111\n"
                "11111111111111111111d1ff541111d0ff501111111111111111111111111111111111111111\n"
                "11111111111111111111f4ff331111d0ff501111111111111111111111111111111111111111\n"
                "1111783e1111111119b0ffd1111111d0ff501111111111111111111111111111111111111111\n"
                "4d11d8fff9d4c4d8f9ffe328111111d0ff501111111111111111111111111111111111111111\n"
                "541158aed8ebfbf1ca7b1111111111d0ff501111111111111111111111111111111111111111\n"
            },
            {
                0, 0,
                0,
                NULL
            }
        };

        static const bitmap_pattern_t min_patterns[] =
        {
            {
                0, 0,
                0xee,
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000d0ee50000000000000000000004ab1e7eee6cb9341000000d0eeeeeeeeeed19327000000\n"
                "0000d0ee500000000000000000008eeeeee1c6d9eeeec5000000d0eed4c0c2d7eeeeee540000\n"
                "0000d0ee50000000000000000040eeee4d000000187b59000000d0ee5000000018b3eeee1400\n"
                "0000d0ee5000000000000000008eeea200000000000000000000d0ee50000000000decee6200\n"
                "0000d0ee500000000000000000a1ee8a00000000000000000000d0ee500000000000baee8400\n"
                "0000d0ee50000000000000000080eed105000000000000000000d0ee500000000000b6ee7700\n"
                "0000d0ee50000000000000000025eeeebb250000000000000000d0ee50000000000deeee4200\n"
                "0000d0ee5000000000000000000056eeeeeeac3f000000000000d0ee5000000027bbeecf0200\n"
                "0000d0ee50000000000000000000002ab0eeeeeeca3700000000d0eed4c0c6e2eeeed8240000\n"
                "0000d0ee500000000000000000000000002b99eeeeee52000000d0eeeeeeeee3bd6a09000000\n"
                "0000d0ee5000000000000000000000000000001fc4eeee0a0000d0ee50000000000000000000\n"
                "0000d0ee5000000000000000000000000000000011eeee440000d0ee50000000000000000000\n"
                "0000d0ee5000000000000000000000000000000000d1ee540000d0ee50000000000000000000\n"
                "0000d0ee500000000000000000000000000000000aeeee330000d0ee50000000000000000000\n"
                "0000d0ee500000000000000000783e0500000019b0eed1010000d0ee50000000000000000000\n"
                "0000d0eeeeecececececec4d00d8eeeed4c4d8eeeee328000000d0ee50000000000000000000\n"
                "0000d0eeeeeeeeeeeeeeee540058aed8ebeeeeca7b0f00000000d0ee50000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
                "0000000000000000000000000000000000000000000000000000000000000000000000000000\n"
            },
            {
                -9, -9,
                0xee,
                "0000000000004ab1e7eee6cb9341000000d0eeeeeeeeeed19327000000eeeeeeeeeeeeeeeeee\n"
                "00000000008eeeeee1c6d9eeeec5000000d0eed4c0c2d7eeeeee540000eeeeeeeeeeeeeeeeee\n"
                "0000000040eeee4d000000187b59000000d0ee5000000018b3eeee1400eeeeeeeeeeeeeeeeee\n"
                "000000008eeea200000000000000000000d0ee50000000000decee6200eeeeeeeeeeeeeeeeee\n"
                "00000000a1ee8a00000000000000000000d0ee500000000000baee8400eeeeeeeeeeeeeeeeee\n"
                "0000000080eed105000000000000000000d0ee500000000000b6ee7700eeeeeeeeeeeeeeeeee\n"
                "0000000025eeeebb250000000000000000d0ee50000000000deeee4200eeeeeeeeeeeeeeeeee\n"
                "000000000056eeeeeeac3f000000000000d0ee5000000027bbeecf0200eeeeeeeeeeeeeeeeee\n"
                "0000000000002ab0eeeeeeca3700000000d0eed4c0c6e2eeeed8240000eeeeeeeeeeeeeeeeee\n"
                "00000000000000002b99eeeeee52000000d0eeeeeeeee3bd6a09000000eeeeeeeeeeeeeeeeee\n"
                "000000000000000000001fc4eeee0a0000d0ee50000000000000000000eeeeeeeeeeeeeeeeee\n"
                "000000000000000000000011eeee440000d0ee50000000000000000000eeeeeeeeeeeeeeeeee\n"
                "000000000000000000000000d1ee540000d0ee50000000000000000000eeeeeeeeeeeeeeeeee\n"
                "00000000000000000000000aeeee330000d0ee50000000000000000000eeeeeeeeeeeeeeeeee\n"
                "00000000783e0500000019b0eed1010000d0ee50000000000000000000eeeeeeeeeeeeeeeeee\n"
                "ecec4d00d8eeeed4c4d8eeeee328000000d0ee50000000000000000000eeeeeeeeeeeeeeeeee\n"
                "eeee540058aed8ebeeeeca7b0f00000000d0ee50000000000000000000eeeeeeeeeeeeeeeeee\n"
                "0000000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeee\n"
                "0000000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeee\n"
                "0000000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeee\n"
                "0000000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeee\n"
                "0000000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeee\n"
                "0000000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeee\n"
                "0000000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
            },
            {
                10, -10,
                0xaa,
                "aaaaaaaaaaaaaaaaaaaa0000aaaa500000000000000000008eaaaaaaaaaaaaaaaa000000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa50000000000000000040aaaa4d000000187b59000000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa5000000000000000008eaaa200000000000000000000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa500000000000000000a1aa8a00000000000000000000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa50000000000000000080aaaa05000000000000000000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa50000000000000000025aaaaaa250000000000000000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa5000000000000000000056aaaaaaaa3f000000000000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa50000000000000000000002aaaaaaaaaaa3700000000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa500000000000000000000000002b99aaaaaa52000000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa5000000000000000000000000000001faaaaaa0a0000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa5000000000000000000000000000000011aaaa440000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa5000000000000000000000000000000000aaaa540000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa500000000000000000000000000000000aaaaa330000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaa500000000000000000783e0500000019aaaaaa010000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaaaaaaaaaaaaaaaa4d00aaaaaaaaaaaaaaaaaa28000000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa0000aaaaaaaaaaaaaaaaaa540058aaaaaaaaaaaa7b0f00000000aaaa\n"
                "aaaaaaaaaaaaaaaaaaaa00000000000000000000000000000000000000000000000000000000\n"
                "aaaaaaaaaaaaaaaaaaaa00000000000000000000000000000000000000000000000000000000\n"
                "aaaaaaaaaaaaaaaaaaaa00000000000000000000000000000000000000000000000000000000\n"
                "aaaaaaaaaaaaaaaaaaaa00000000000000000000000000000000000000000000000000000000\n"
                "aaaaaaaaaaaaaaaaaaaa00000000000000000000000000000000000000000000000000000000\n"
                "aaaaaaaaaaaaaaaaaaaa00000000000000000000000000000000000000000000000000000000\n"
                "aaaaaaaaaaaaaaaaaaaa00000000000000000000000000000000000000000000000000000000\n"
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\n"
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\n"
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\n"
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\n"
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\n"
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\n"
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\n"
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\n"
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\n"
                "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa\n"
            },
            {
                9, 11,
                0xee,
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeee0000000000000000000000000000000000000000000000000000000000\n"
                "eeeeeeeeeeeeeeeeee0000000000000000000000000000000000000000000000000000000000\n"
                "eeeeeeeeeeeeeeeeee0000000000000000000000000000000000000000000000000000000000\n"
                "eeeeeeeeeeeeeeeeee0000000000000000000000000000000000000000000000000000000000\n"
                "eeeeeeeeeeeeeeeeee0000000000000000000000000000000000000000000000000000000000\n"
                "eeeeeeeeeeeeeeeeee0000000000000000000000000000000000000000000000000000000000\n"
                "eeeeeeeeeeeeeeeeee0000000000000000000000000000000000000000000000000000000000\n"
                "eeeeeeeeeeeeeeeeee0000000000000000000000000000000000000000000000000000000000\n"
                "eeeeeeeeeeeeeeeeee0000000000000000000000000000000000000000000000000000000000\n"
                "eeeeeeeeeeeeeeeeee0000d0ee50000000000000000000004ab1e7eee6cb9341000000d0eeee\n"
                "eeeeeeeeeeeeeeeeee0000d0ee500000000000000000008eeeeee1c6d9eeeec5000000d0eed4\n"
                "eeeeeeeeeeeeeeeeee0000d0ee50000000000000000040eeee4d000000187b59000000d0ee50\n"
                "eeeeeeeeeeeeeeeeee0000d0ee5000000000000000008eeea200000000000000000000d0ee50\n"
                "eeeeeeeeeeeeeeeeee0000d0ee500000000000000000a1ee8a00000000000000000000d0ee50\n"
                "eeeeeeeeeeeeeeeeee0000d0ee50000000000000000080eed105000000000000000000d0ee50\n"
                "eeeeeeeeeeeeeeeeee0000d0ee50000000000000000025eeeebb250000000000000000d0ee50\n"
                "eeeeeeeeeeeeeeeeee0000d0ee5000000000000000000056eeeeeeac3f000000000000d0ee50\n"
                "eeeeeeeeeeeeeeeeee0000d0ee50000000000000000000002ab0eeeeeeca3700000000d0eed4\n"
                "eeeeeeeeeeeeeeeeee0000d0ee500000000000000000000000002b99eeeeee52000000d0eeee\n"
                "eeeeeeeeeeeeeeeeee0000d0ee5000000000000000000000000000001fc4eeee0a0000d0ee50\n"
                "eeeeeeeeeeeeeeeeee0000d0ee5000000000000000000000000000000011eeee440000d0ee50\n"
                "eeeeeeeeeeeeeeeeee0000d0ee5000000000000000000000000000000000d1ee540000d0ee50\n"
            },
            {
                -11, 7,
                0xee,
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee\n"
                "000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "000000000000000000000000000000000000000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "000000004ab1e7eee6cb9341000000d0eeeeeeeeeed19327000000eeeeeeeeeeeeeeeeeeeeee\n"
                "0000008eeeeee1c6d9eeeec5000000d0eed4c0c2d7eeeeee540000eeeeeeeeeeeeeeeeeeeeee\n"
                "000040eeee4d000000187b59000000d0ee5000000018b3eeee1400eeeeeeeeeeeeeeeeeeeeee\n"
                "00008eeea200000000000000000000d0ee50000000000decee6200eeeeeeeeeeeeeeeeeeeeee\n"
                "0000a1ee8a00000000000000000000d0ee500000000000baee8400eeeeeeeeeeeeeeeeeeeeee\n"
                "000080eed105000000000000000000d0ee500000000000b6ee7700eeeeeeeeeeeeeeeeeeeeee\n"
                "000025eeeebb250000000000000000d0ee50000000000deeee4200eeeeeeeeeeeeeeeeeeeeee\n"
                "00000056eeeeeeac3f000000000000d0ee5000000027bbeecf0200eeeeeeeeeeeeeeeeeeeeee\n"
                "000000002ab0eeeeeeca3700000000d0eed4c0c6e2eeeed8240000eeeeeeeeeeeeeeeeeeeeee\n"
                "0000000000002b99eeeeee52000000d0eeeeeeeee3bd6a09000000eeeeeeeeeeeeeeeeeeeeee\n"
                "00000000000000001fc4eeee0a0000d0ee50000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "00000000000000000011eeee440000d0ee50000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "00000000000000000000d1ee540000d0ee50000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "0000000000000000000aeeee330000d0ee50000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "0000783e0500000019b0eed1010000d0ee50000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "4d00d8eeeed4c4d8eeeee328000000d0ee50000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
                "540058aed8ebeeeeca7b0f00000000d0ee50000000000000000000eeeeeeeeeeeeeeeeeeeeee\n"
            },
            {
                0, 0,
                0,
                NULL
            }
        };


    } /* namespace test */
} /* namespace lsp */

UTEST_BEGIN("dsp.bitmap", b8b8)

    void test_pattern(const char *name, bitmap_func_b1b8_t func, const bitmap_pattern_t *pattern)
    {
        printf("Testing '%s' at point (%d, %d)\n", name, int(pattern->x), int(pattern->y));

        dsp::bitmap_t tmp;
        ByteBuffer bbuf(bitmap.width * bitmap.height);

        tmp.width   = bitmap.width;
        tmp.height  = bitmap.height;
        tmp.stride  = tmp.width;
        tmp.data    = bbuf.data();
        memset(bbuf.data(), pattern->fill, bitmap.width * bitmap.height);

        func(&tmp, &bitmap, pattern->x, pattern->y);

        UTEST_ASSERT(!bbuf.corrupted());

        char *result = rasterize(&tmp);
        UTEST_ASSERT(result != NULL);
        lsp_finally { free(result); };

        if (strcmp(result, pattern->data) != 0)
        {
            UTEST_FAIL_MSG("Faled rasterization:\ngot pattern:\n%s\nexpected pattern:\n%s\n", result, pattern->data);
        }
    }

    void test_patterns(const char *name, bitmap_func_b1b8_t func, const bitmap_pattern_t * list)
    {
        if (!UTEST_SUPPORTED(func))
            return;

        for (; list->data != NULL; ++list)
            test_pattern(name, func, list);
    }


    UTEST_MAIN
    {
        using namespace lsp;

        #define TEST_PATTERNS(func, list) \
            test_patterns(#func, func, list)

        TEST_PATTERNS(generic::bitmap_put_b8b8, put_patterns);
        TEST_PATTERNS(generic::bitmap_add_b8b8, add_patterns);
        TEST_PATTERNS(generic::bitmap_sub_b8b8, sub_patterns);
        TEST_PATTERNS(generic::bitmap_max_b8b8, max_patterns);
        TEST_PATTERNS(generic::bitmap_min_b8b8, min_patterns);
    }

UTEST_END;



