/* Generated by wayland-scanner 1.23.1 */

#ifndef KYWC_CAPTURE_V1_CLIENT_PROTOCOL_H
#define KYWC_CAPTURE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_kywc_capture_v1 The kywc_capture_v1 protocol
 * @section page_ifaces_kywc_capture_v1 Interfaces
 * - @subpage page_iface_kywc_capture_manager_v1 - manager to inform clients and begin get capturing
 * - @subpage page_iface_kywc_capture_frame_v1 - a frame ready for copy
 * - @subpage page_iface_kywc_capture_cursor_v1 - cursor handle
 * @section page_copyright_kywc_capture_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024 KylinSoft Co., Ltd.
 * SPDX-License-Identifier: MulanPSL-2.0
 * </pre>
 */
struct kywc_capture_cursor_v1;
struct kywc_capture_frame_v1;
struct kywc_capture_manager_v1;
struct wl_seat;

#ifndef KYWC_CAPTURE_MANAGER_V1_INTERFACE
#define KYWC_CAPTURE_MANAGER_V1_INTERFACE
/**
 * @page page_iface_kywc_capture_manager_v1 kywc_capture_manager_v1
 * @section page_iface_kywc_capture_manager_v1_desc Description
 *
 * This object is a manager which offers requests to start capturing from a source.
 * @section page_iface_kywc_capture_manager_v1_api API
 * See @ref iface_kywc_capture_manager_v1.
 */
/**
 * @defgroup iface_kywc_capture_manager_v1 The kywc_capture_manager_v1 interface
 *
 * This object is a manager which offers requests to start capturing from a source.
 */
extern const struct wl_interface kywc_capture_manager_v1_interface;
#endif
#ifndef KYWC_CAPTURE_FRAME_V1_INTERFACE
#define KYWC_CAPTURE_FRAME_V1_INTERFACE
/**
 * @page page_iface_kywc_capture_frame_v1 kywc_capture_frame_v1
 * @section page_iface_kywc_capture_frame_v1_desc Description
 *
 * @section page_iface_kywc_capture_frame_v1_api API
 * See @ref iface_kywc_capture_frame_v1.
 */
/**
 * @defgroup iface_kywc_capture_frame_v1 The kywc_capture_frame_v1 interface
 *
 */
extern const struct wl_interface kywc_capture_frame_v1_interface;
#endif
#ifndef KYWC_CAPTURE_CURSOR_V1_INTERFACE
#define KYWC_CAPTURE_CURSOR_V1_INTERFACE
/**
 * @page page_iface_kywc_capture_cursor_v1 kywc_capture_cursor_v1
 * @section page_iface_kywc_capture_cursor_v1_desc Description
 *
 * When the seat or frame is destroyed, this object becomes inert.
 * @section page_iface_kywc_capture_cursor_v1_api API
 * See @ref iface_kywc_capture_cursor_v1.
 */
/**
 * @defgroup iface_kywc_capture_cursor_v1 The kywc_capture_cursor_v1 interface
 *
 * When the seat or frame is destroyed, this object becomes inert.
 */
extern const struct wl_interface kywc_capture_cursor_v1_interface;
#endif

#define KYWC_CAPTURE_MANAGER_V1_CAPTURE_OUTPUT 0
#define KYWC_CAPTURE_MANAGER_V1_CAPTURE_WORKSPACE 1
#define KYWC_CAPTURE_MANAGER_V1_CAPTURE_TOPLEVEL 2
#define KYWC_CAPTURE_MANAGER_V1_CAPTURE_CURSOR 3
#define KYWC_CAPTURE_MANAGER_V1_DESTROY 4


/**
 * @ingroup iface_kywc_capture_manager_v1
 */
#define KYWC_CAPTURE_MANAGER_V1_CAPTURE_OUTPUT_SINCE_VERSION 1
/**
 * @ingroup iface_kywc_capture_manager_v1
 */
#define KYWC_CAPTURE_MANAGER_V1_CAPTURE_WORKSPACE_SINCE_VERSION 1
/**
 * @ingroup iface_kywc_capture_manager_v1
 */
#define KYWC_CAPTURE_MANAGER_V1_CAPTURE_TOPLEVEL_SINCE_VERSION 1
/**
 * @ingroup iface_kywc_capture_manager_v1
 */
#define KYWC_CAPTURE_MANAGER_V1_CAPTURE_CURSOR_SINCE_VERSION 1
/**
 * @ingroup iface_kywc_capture_manager_v1
 */
#define KYWC_CAPTURE_MANAGER_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_kywc_capture_manager_v1 */
static inline void
kywc_capture_manager_v1_set_user_data(struct kywc_capture_manager_v1 *kywc_capture_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) kywc_capture_manager_v1, user_data);
}

/** @ingroup iface_kywc_capture_manager_v1 */
static inline void *
kywc_capture_manager_v1_get_user_data(struct kywc_capture_manager_v1 *kywc_capture_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) kywc_capture_manager_v1);
}

static inline uint32_t
kywc_capture_manager_v1_get_version(struct kywc_capture_manager_v1 *kywc_capture_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) kywc_capture_manager_v1);
}

/**
 * @ingroup iface_kywc_capture_manager_v1
 *
 * Capture the next frame of an entire output.
 */
static inline struct kywc_capture_frame_v1 *
kywc_capture_manager_v1_capture_output(struct kywc_capture_manager_v1 *kywc_capture_manager_v1, int32_t overlay_cursor, const char *output)
{
	struct wl_proxy *frame;

	frame = wl_proxy_marshal_flags((struct wl_proxy *) kywc_capture_manager_v1,
			 KYWC_CAPTURE_MANAGER_V1_CAPTURE_OUTPUT, &kywc_capture_frame_v1_interface, wl_proxy_get_version((struct wl_proxy *) kywc_capture_manager_v1), 0, NULL, overlay_cursor, output);

	return (struct kywc_capture_frame_v1 *) frame;
}

/**
 * @ingroup iface_kywc_capture_manager_v1
 *
 * Capture the next frame of an entire workspace in one output.
 */
static inline struct kywc_capture_frame_v1 *
kywc_capture_manager_v1_capture_workspace(struct kywc_capture_manager_v1 *kywc_capture_manager_v1, const char *workspace, const char *output)
{
	struct wl_proxy *frame;

	frame = wl_proxy_marshal_flags((struct wl_proxy *) kywc_capture_manager_v1,
			 KYWC_CAPTURE_MANAGER_V1_CAPTURE_WORKSPACE, &kywc_capture_frame_v1_interface, wl_proxy_get_version((struct wl_proxy *) kywc_capture_manager_v1), 0, NULL, workspace, output);

	return (struct kywc_capture_frame_v1 *) frame;
}

/**
 * @ingroup iface_kywc_capture_manager_v1
 *
 * Capture the next frame of an entire toplevel.
 */
static inline struct kywc_capture_frame_v1 *
kywc_capture_manager_v1_capture_toplevel(struct kywc_capture_manager_v1 *kywc_capture_manager_v1, const char *toplevel, uint32_t without_decoration)
{
	struct wl_proxy *frame;

	frame = wl_proxy_marshal_flags((struct wl_proxy *) kywc_capture_manager_v1,
			 KYWC_CAPTURE_MANAGER_V1_CAPTURE_TOPLEVEL, &kywc_capture_frame_v1_interface, wl_proxy_get_version((struct wl_proxy *) kywc_capture_manager_v1), 0, NULL, toplevel, without_decoration);

	return (struct kywc_capture_frame_v1 *) frame;
}

/**
 * @ingroup iface_kywc_capture_manager_v1
 *
 * Capture the cursor of the seat and frame.
 */
static inline struct kywc_capture_cursor_v1 *
kywc_capture_manager_v1_capture_cursor(struct kywc_capture_manager_v1 *kywc_capture_manager_v1, struct wl_seat *seat, struct kywc_capture_frame_v1 *frame)
{
	struct wl_proxy *cursor;

	cursor = wl_proxy_marshal_flags((struct wl_proxy *) kywc_capture_manager_v1,
			 KYWC_CAPTURE_MANAGER_V1_CAPTURE_CURSOR, &kywc_capture_cursor_v1_interface, wl_proxy_get_version((struct wl_proxy *) kywc_capture_manager_v1), 0, NULL, seat, frame);

	return (struct kywc_capture_cursor_v1 *) cursor;
}

/**
 * @ingroup iface_kywc_capture_manager_v1
 *
 * All objects created by the manager will still remain valid, until their
 * appropriate destroy request has been called.
 */
static inline void
kywc_capture_manager_v1_destroy(struct kywc_capture_manager_v1 *kywc_capture_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kywc_capture_manager_v1,
			 KYWC_CAPTURE_MANAGER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) kywc_capture_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifndef KYWC_CAPTURE_FRAME_V1_FLAGS_ENUM
#define KYWC_CAPTURE_FRAME_V1_FLAGS_ENUM
enum kywc_capture_frame_v1_flags {
	/**
	 * buffer is a dmabuf
	 */
	KYWC_CAPTURE_FRAME_V1_FLAGS_DMABUF = 1,
	/**
	 * buffer is reused
	 */
	KYWC_CAPTURE_FRAME_V1_FLAGS_REUSED = 2,
};
#endif /* KYWC_CAPTURE_FRAME_V1_FLAGS_ENUM */

/**
 * @ingroup iface_kywc_capture_frame_v1
 * @struct kywc_capture_frame_v1_listener
 */
struct kywc_capture_frame_v1_listener {
	/**
	 * frame copy failed
	 *
	 * This event indicates that the attempted frame copy has failed.
	 * After receiving this event, the client should destroy the
	 * object.
	 */
	void (*failed)(void *data,
		       struct kywc_capture_frame_v1 *kywc_capture_frame_v1);
	/**
	 * frame copy has been cancelled
	 *
	 * Sent if the compositor cancels the frame because the source
	 * has gone. Upon receiving this event, the client should destroy
	 * this object.
	 */
	void (*cancelled)(void *data,
			  struct kywc_capture_frame_v1 *kywc_capture_frame_v1);
	/**
	 * buffer information
	 *
	 * Provides information about buffer parameters that need to be
	 * used for this frame.
	 * @param fd buffer file descriptor
	 * @param format DRM_FORMAT code
	 * @param width buffer width in pixels
	 * @param height buffer height in pixels
	 * @param offset buffer offset in bytes
	 * @param stride buffer stride in bytes
	 * @param modifier_hi high 32 bits of layout modifier
	 * @param modifier_lo low 32 bits of layout modifier
	 * @param flags buffer flags
	 */
	void (*buffer)(void *data,
		       struct kywc_capture_frame_v1 *kywc_capture_frame_v1,
		       int32_t fd,
		       uint32_t format,
		       uint32_t width,
		       uint32_t height,
		       uint32_t offset,
		       uint32_t stride,
		       uint32_t modifier_hi,
		       uint32_t modifier_lo,
		       uint32_t flags);
	/**
	 * buffer information with plane
	 *
	 * Provides information about buffer parameters with the plane
	 * index that need to be used for this frame.
	 * @param index plane index
	 * @param fd buffer file descriptor
	 * @param offset buffer offset in bytes
	 * @param stride buffer stride in bytes
	 * @since 2
	 */
	void (*buffer_with_plane)(void *data,
				  struct kywc_capture_frame_v1 *kywc_capture_frame_v1,
				  uint32_t index,
				  int32_t fd,
				  uint32_t offset,
				  uint32_t stride);
	/**
	 * all buffer parameters have been sent
	 *
	 * 
	 * @since 2
	 */
	void (*buffer_done)(void *data,
			    struct kywc_capture_frame_v1 *kywc_capture_frame_v1);
};

/**
 * @ingroup iface_kywc_capture_frame_v1
 */
static inline int
kywc_capture_frame_v1_add_listener(struct kywc_capture_frame_v1 *kywc_capture_frame_v1,
				   const struct kywc_capture_frame_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) kywc_capture_frame_v1,
				     (void (**)(void)) listener, data);
}

#define KYWC_CAPTURE_FRAME_V1_DESTROY 0
#define KYWC_CAPTURE_FRAME_V1_RELEASE_BUFFER 1

/**
 * @ingroup iface_kywc_capture_frame_v1
 */
#define KYWC_CAPTURE_FRAME_V1_FAILED_SINCE_VERSION 1
/**
 * @ingroup iface_kywc_capture_frame_v1
 */
#define KYWC_CAPTURE_FRAME_V1_CANCELLED_SINCE_VERSION 1
/**
 * @ingroup iface_kywc_capture_frame_v1
 */
#define KYWC_CAPTURE_FRAME_V1_BUFFER_SINCE_VERSION 1
/**
 * @ingroup iface_kywc_capture_frame_v1
 */
#define KYWC_CAPTURE_FRAME_V1_BUFFER_WITH_PLANE_SINCE_VERSION 2
/**
 * @ingroup iface_kywc_capture_frame_v1
 */
#define KYWC_CAPTURE_FRAME_V1_BUFFER_DONE_SINCE_VERSION 2

/**
 * @ingroup iface_kywc_capture_frame_v1
 */
#define KYWC_CAPTURE_FRAME_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_kywc_capture_frame_v1
 */
#define KYWC_CAPTURE_FRAME_V1_RELEASE_BUFFER_SINCE_VERSION 1

/** @ingroup iface_kywc_capture_frame_v1 */
static inline void
kywc_capture_frame_v1_set_user_data(struct kywc_capture_frame_v1 *kywc_capture_frame_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) kywc_capture_frame_v1, user_data);
}

/** @ingroup iface_kywc_capture_frame_v1 */
static inline void *
kywc_capture_frame_v1_get_user_data(struct kywc_capture_frame_v1 *kywc_capture_frame_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) kywc_capture_frame_v1);
}

static inline uint32_t
kywc_capture_frame_v1_get_version(struct kywc_capture_frame_v1 *kywc_capture_frame_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) kywc_capture_frame_v1);
}

/**
 * @ingroup iface_kywc_capture_frame_v1
 *
 * Destroys the frame. This request can be sent at any time by the client.
 */
static inline void
kywc_capture_frame_v1_destroy(struct kywc_capture_frame_v1 *kywc_capture_frame_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kywc_capture_frame_v1,
			 KYWC_CAPTURE_FRAME_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) kywc_capture_frame_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_kywc_capture_frame_v1
 *
 * Mark the buffer is not used by client. This request is sent after buffer event.
 */
static inline void
kywc_capture_frame_v1_release_buffer(struct kywc_capture_frame_v1 *kywc_capture_frame_v1, uint32_t want_buffer)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kywc_capture_frame_v1,
			 KYWC_CAPTURE_FRAME_V1_RELEASE_BUFFER, NULL, wl_proxy_get_version((struct wl_proxy *) kywc_capture_frame_v1), 0, want_buffer);
}

/**
 * @ingroup iface_kywc_capture_cursor_v1
 * @struct kywc_capture_cursor_v1_listener
 */
struct kywc_capture_cursor_v1_listener {
	/**
	 * cursor entered a frame
	 *
	 * This event indicates that when a cursor enters the frame. It
	 * shall be generated before the "position" and "hotspot" events.
	 *
	 * If the pointer object referenced by the seat does not exist,
	 * this event will not be triggered.
	 */
	void (*enter)(void *data,
		      struct kywc_capture_cursor_v1 *kywc_capture_cursor_v1);
	/**
	 * cursor left frame
	 *
	 * This event indicates that when a cursor leaves the frame. No
	 * "position" or "hotspot" event is generated for the cursor until
	 * the cursor enters the frame again.
	 *
	 * If the pointer object referenced by the seat is removed, this
	 * event will be sent.
	 */
	void (*leave)(void *data,
		      struct kywc_capture_cursor_v1 *kywc_capture_cursor_v1);
	/**
	 * informs cursor position
	 *
	 * This event informs the cursor position. The given position is
	 * relative to the frame's top left corner in transformed buffer
	 * pixel coordinates.
	 *
	 * Note, if the frame parameter is set to null in the
	 * capture_cursor request, the given position coordinates are
	 * global.
	 * @param x position x coordinates
	 * @param y position y coordinates
	 */
	void (*position)(void *data,
			 struct kywc_capture_cursor_v1 *kywc_capture_cursor_v1,
			 int32_t x,
			 int32_t y);
	/**
	 * informs cursor hotspot
	 *
	 * This event informs the cursor hotspot. The hotspot describes
	 * the offset between the cursor image and the position of the
	 * input device.
	 *
	 * The parameters x and y represent the offset of the new hotspot
	 * relative to the origin of the cursor image, which is typically
	 * the top-left corner of the image.
	 * @param x hotspot x coordinates
	 * @param y hotspot y coordinates
	 */
	void (*hotspot)(void *data,
			struct kywc_capture_cursor_v1 *kywc_capture_cursor_v1,
			int32_t x,
			int32_t y);
};

/**
 * @ingroup iface_kywc_capture_cursor_v1
 */
static inline int
kywc_capture_cursor_v1_add_listener(struct kywc_capture_cursor_v1 *kywc_capture_cursor_v1,
				    const struct kywc_capture_cursor_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) kywc_capture_cursor_v1,
				     (void (**)(void)) listener, data);
}

#define KYWC_CAPTURE_CURSOR_V1_DESTROY 0

/**
 * @ingroup iface_kywc_capture_cursor_v1
 */
#define KYWC_CAPTURE_CURSOR_V1_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_kywc_capture_cursor_v1
 */
#define KYWC_CAPTURE_CURSOR_V1_LEAVE_SINCE_VERSION 1
/**
 * @ingroup iface_kywc_capture_cursor_v1
 */
#define KYWC_CAPTURE_CURSOR_V1_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_kywc_capture_cursor_v1
 */
#define KYWC_CAPTURE_CURSOR_V1_HOTSPOT_SINCE_VERSION 1

/**
 * @ingroup iface_kywc_capture_cursor_v1
 */
#define KYWC_CAPTURE_CURSOR_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_kywc_capture_cursor_v1 */
static inline void
kywc_capture_cursor_v1_set_user_data(struct kywc_capture_cursor_v1 *kywc_capture_cursor_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) kywc_capture_cursor_v1, user_data);
}

/** @ingroup iface_kywc_capture_cursor_v1 */
static inline void *
kywc_capture_cursor_v1_get_user_data(struct kywc_capture_cursor_v1 *kywc_capture_cursor_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) kywc_capture_cursor_v1);
}

static inline uint32_t
kywc_capture_cursor_v1_get_version(struct kywc_capture_cursor_v1 *kywc_capture_cursor_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) kywc_capture_cursor_v1);
}

/**
 * @ingroup iface_kywc_capture_cursor_v1
 *
 * Destroys the object. This request can be sent at any time by the client.
 */
static inline void
kywc_capture_cursor_v1_destroy(struct kywc_capture_cursor_v1 *kywc_capture_cursor_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kywc_capture_cursor_v1,
			 KYWC_CAPTURE_CURSOR_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) kywc_capture_cursor_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
