/*
 *
 * Copyright (C) 2024, KylinSoft Co., Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Zhenyu Wang <wangzhenyu@kylinos.cn>
 *
 */

#include "../../kysdk-qtwidgets/src/kaboutdialog.h"
#include "../../kysdk-qtwidgets/src/kaddfilebutton.h"
#include "../../kysdk-qtwidgets/src/karrowtabbar.h"
#include "../../kysdk-qtwidgets/src/kaddbutton.h"
#include "../../kysdk-qtwidgets/src/kbackgroundgroup.h"
#include "../../kysdk-qtwidgets/src/kbadge.h"
#include "../../kysdk-qtwidgets/src/kballontip.h"
#include "../../kysdk-qtwidgets/src/kbaseframe.h"
#include "../../kysdk-qtwidgets/src/kborderbutton.h"
#include "../../kysdk-qtwidgets/src/kborderlessbutton.h"
// #include "../../kysdk-qtwidgets/src/kbreadcrumb.h"
#include "../../kysdk-qtwidgets/src/kbubblewidget.h"
#include "../../kysdk-qtwidgets/src/kbuttonbox.h"
#include "../../kysdk-qtwidgets/src/kclocktimer.h"
#include "../../kysdk-qtwidgets/src/kcolorbutton.h"
#include "../../kysdk-qtwidgets/src/kcolorcombobox.h"
#include "../../kysdk-qtwidgets/src/kcomboboxframe.h"
#include "../../kysdk-qtwidgets/src/kcomboboxwidget.h"
#include "../../kysdk-qtwidgets/src/kcommentpanel.h"
#include "../../kysdk-qtwidgets/src/kcrumb.h"
#include "../../kysdk-qtwidgets/src/kcustomdateedit.h"
#include "../../kysdk-qtwidgets/src/kcustomtabbar.h"
#include "../../kysdk-qtwidgets/src/kdialog.h"
#include "../../kysdk-qtwidgets/src/kdragwidget.h"
#include "../../kysdk-qtwidgets/src/kfilewidget.h"
#include "../../kysdk-qtwidgets/src/kflowlayout.h"
#include "../../kysdk-qtwidgets/src/kflowlayout.h"
#include "../../kysdk-qtwidgets/src/kiconbar.h"
#include "../../kysdk-qtwidgets/src/kinputdialog.h"
#include "../../kysdk-qtwidgets/src/kintrowidget.h"
#include "../../kysdk-qtwidgets/src/kitemwidget.h"
#include "../../kysdk-qtwidgets/src/klabel.h"
#include "../../kysdk-qtwidgets/src/klineedit.h"
#include "../../kysdk-qtwidgets/src/klineeditframe.h"
#include "../../kysdk-qtwidgets/src/klineframe.h"
#include "../../kysdk-qtwidgets/src/klistview.h"
#include "../../kysdk-qtwidgets/src/klistviewdelegate.h"
#include "../../kysdk-qtwidgets/src/klistwidget.h"
#include "../../kysdk-qtwidgets/src/kloopplaypage.h"
#include "../../kysdk-qtwidgets/src/klunarcalendarinfo.h"
#include "../../kysdk-qtwidgets/src/klunardateedit.h"
#include "../../kysdk-qtwidgets/src/kmenubutton.h"
#include "../../kysdk-qtwidgets/src/kmessagebox.h"
#include "../../kysdk-qtwidgets/src/kminicalendaritem.h"
#include "../../kysdk-qtwidgets/src/kminicalendarwidget.h"
#include "../../kysdk-qtwidgets/src/knativetabbar.h"
#include "../../kysdk-qtwidgets/src/knavigationbar.h"
#include "../../kysdk-qtwidgets/src/knavigationtrail.h"
#include "../../kysdk-qtwidgets/src/kpasswordedit.h"
#include "../../kysdk-qtwidgets/src/kpixmapcontainer.h"
#include "../../kysdk-qtwidgets/src/kpressbutton.h"
#include "../../kysdk-qtwidgets/src/kprogressbar.h"
#include "../../kysdk-qtwidgets/src/kprogresscircle.h"
#include "../../kysdk-qtwidgets/src/kprogressdialog.h"
#include "../../kysdk-qtwidgets/src/kprogresslabel.h"
#include "../../kysdk-qtwidgets/src/kpushbutton.h"
#include "../../kysdk-qtwidgets/src/kpushbuttonframe.h"
#include "../../kysdk-qtwidgets/src/kradiobuttonframe.h"
#include "../../kysdk-qtwidgets/src/ksearchlineedit.h"
#include "../../kysdk-qtwidgets/src/ksecuritylevelbar.h"
#include "../../kysdk-qtwidgets/src/ksecurityquestiondialog.h"
#include "../../kysdk-qtwidgets/src/ksettinggroup.h"
#include "../../kysdk-qtwidgets/src/kshadowhelper.h"
#include "../../kysdk-qtwidgets/src/kslider.h"
#include "../../kysdk-qtwidgets/src/ksliderframe.h"
#include "../../kysdk-qtwidgets/src/kswitchbutton.h"
// #include "../../kysdk-qtwidgets/src/ktabbar.h"
#include "../../kysdk-qtwidgets/src/accessinfohelper.h"
#include "../../kysdk-qtwidgets/src/kswitchbuttonframe.h"
//#include "../../kysdk-qtwidgets/src/ktabbar.h"
#include "../../kysdk-qtwidgets/src/ktableheaderview.h"
#include "../../kysdk-qtwidgets/src/ktablemodel.h"
#include "../../kysdk-qtwidgets/src/ktableview.h"
#include "../../kysdk-qtwidgets/src/ktag.h"
#include "../../kysdk-qtwidgets/src/ktextedit.h"
#include "../../kysdk-qtwidgets/src/ktitlewindow.h"
#include "../../kysdk-qtwidgets/src/ktoolbutton.h"
#include "../../kysdk-qtwidgets/src/ktranslucentfloor.h"
#include "../../kysdk-qtwidgets/src/kuninstalldialog.h"
#include "../../kysdk-qtwidgets/src/kwidget.h"
#include "../../kysdk-qtwidgets/src/kwindowbuttonbar.h"
#include "../../kysdk-qtwidgets/src/parmscontroller.h"
#include "../../kysdk-qtwidgets/src/themeController.h"
// #include "../../kysdk-qtwidgets/src/xatom-helper.h"
#include "../../kysdk-qtwidgets/src/kdirtabbar.h"
#include "../../kysdk-qtwidgets/src/ktexteditor.h"
#include "../../kysdk-qtwidgets/src/ktoolbar.h"
#include <QSignalSpy>
#include <QTest>
using namespace kdk;

class MainTest : public QObject
{
    Q_OBJECT
private slots:
    void aboutdialogTest();
    void addfilebuttonTest();
    void arrowtabbarTest();
    void backgroundgroupTest();
    void badgeTest();
    void ballontipTest();
    void borderbuttonTest();
    void borderlessbuttonTest();
    //    void breadcrumbTest();
    void bubblewidgetTest();
    void buttonboxTest();
    void clocktimerTest();
    void colorbuttonTest();
    void colorcomboxTest();
    void comboboxwidgetTest();
    void commentpanelTest();
    void crumbTest();
    void customdateeditTest();
    void customtabbarTest();
    void dialogTest();
    void dragwidgetTest();
    void filewidgetTest();
    void flowlayoutTest();
    void iconbarTest();
    void inputdialogTest();
    void introwwidgetTest();
    void itemwidgetTest();
    void labelTest();
    void lineeditTest();
    void lineframeTest();
    void listviewTest();
    void listviewdelegateTest();
    void listWidgetTest();
    void loopplaypageTest();
    void lunarcalendarinfoTest();
    void lunardateeditTest();
    void menubuttonTest();
    void messageboxTest();
    void minicalendaritemTest();
    void minicalendarwidgetTest();
    void nativetabbarTest();
    void navigationbarTest();
    void navigationtrailTest();
    void passwordeditTest();
    void pixmapcontainerTest();
    void pressbuttonTest();
    void progressbarTest();
    void progresscircleTest();
    void progressdialogTest();
    void progresslabelTest();
    void pushbuttonTest();
    void searchlineeditTest();
    void securitylevelbarTest();
    void securityquestiondialogTest();
    void settinggroupTest();
    void shadowhelperTest();
    void sliderTest();
    void switchbuttonTest();
    //    void tabbarTest();
    void tableheaderviewTest();
    void tablemodelTest();
    void tableviewTest();
    void tagTest();
    void texteditTest();
    void titlewindowTest();
    void toolbuttonTest();
    void translucentfloorTest();
    void uninstalldialogTest();
    void widgetTest();
    void windowbuttonbarTest();
    void parmscontrollerTest();
    void themecontrollerTest();
    //    void xatomhelperTest();
    void dirtabbarTest();
    void texteditorTest();
    void toolbarTest();
};

void MainTest::aboutdialogTest()
{
    KAboutDialog dialog;

    dialog.setAppIcon(QIcon::fromTheme("kylin-music"));
    dialog.setAppName("测试");
    QCOMPARE(dialog.appName(), "测试");

    dialog.setAppVersion("2.1.0.0");
    QCOMPARE(dialog.appVersion(), "2.1.0.0");

    dialog.setBodyText("关于对话框");
    QCOMPARE(dialog.bodyText(), "关于对话框");

    dialog.setAppSupport("服务与支持邮箱");
    QCOMPARE(dialog.appSupport(), "服务与支持邮箱");

    dialog.setBodyTextVisiable(true);

    dialog.setAppPrivacyLabelVisible(true);
    dialog.AppPrivacyLabelIsVisible();
    //    QCOMPARE(dialog.AppPrivacyLabelIsVisible(),true);

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&dialog, &event);
}

void MainTest::addfilebuttonTest()
{
    KAddFileButton button;
    button.setText("button");

    button.fileDialog();

    button.setNameFilter("JPEG Files(*.jpg)");

    QStringList list;
    list << "JPEG Files(*.jpg)"
         << "PNG Files(*.png)";
    button.setNameFilters(list);

    //    QTest::mouseClick(&button, Qt::LeftButton, Qt::NoModifier);
    QTest::mouseClick(&button, Qt::LeftButton, Qt::NoModifier, QPoint(button.width() / 2, button.height() / 2));
    QTest::mouseMove(&button, button.rect().center());

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&button, &event);

    QWidget widget;
    widget.installEventFilter(&button);

    QEvent event1(QEvent::Paint);
    QCoreApplication::sendEvent(&widget, &event1);
}

void MainTest::arrowtabbarTest()
{
    KArrowTabBar tabbar;
    tabbar.tabbar();
    tabbar.tabbar()->addTab("tab1");
    tabbar.tabbar()->addTab("tab2");
    tabbar.tabbar()->addTab("tab3");
    tabbar.tabbar()->addTab("tab4");
    tabbar.sizeChange();
    tabbar.resize(100, 40);

    emit tabbar.tabbar()->currentChanged(1);
    emit tabbar.tabbar()->leftScrollTabs();
    emit tabbar.tabbar()->rightScrollTabs();
    emit tabbar.tabbar()->leftBStatus(true);
    emit tabbar.tabbar()->leftBStatus(false);
    emit tabbar.tabbar()->rightBStatus(true);
    emit tabbar.tabbar()->rightBStatus(true);
}

void MainTest::backgroundgroupTest()
{
    KBackgroundGroup group;

    QWidget widget;
    QWidget widget1;
    QWidget widget2;
    QWidget widget3;
    QList<QWidget *> list;
    list.append(&widget2);
    list.append(&widget3);
    group.addWidget(&widget);
    group.addWidget(&widget1);
    group.addWidgetList(list);
    group.removeWidgetAt(0);
    group.removeWidget(&widget1);
    group.removeWidgetList(list);
    group.addWidget(&widget);
    group.setBorderVisible(true);

    group.insertWidgetAt(0, &widget1);
    group.insertWidgetList(0, list);
    group.setBorderRadius(8);
    QCOMPARE(group.borderRadius(), 8);

    group.setBackgroundRole(QPalette::Base);
    QCOMPARE(group.backgroundRole(), QPalette::Base);

    group.setStateEnable(&widget, true);
    group.setStateEnable(&widget1, true);
    group.setStateEnable(&widget2, true);
    group.setStateEnable(&widget3, false);

    group.widgetList();

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&group, &event);

    QTest::mouseClick(&group, Qt::LeftButton, Qt::NoModifier, QPoint(20, 20));

    widget.installEventFilter(&group);

    QEvent event1(QEvent::Enter);
    QCoreApplication::sendEvent(&widget, &event1);

    QEvent event2(QEvent::MouseButtonPress);
    QCoreApplication::sendEvent(&widget, &event2);

    QEvent event3(QEvent::MouseButtonRelease);
    QCoreApplication::sendEvent(&widget, &event3);

    QEvent event4(QEvent::Leave);
    QCoreApplication::sendEvent(&widget, &event4);

    QEvent event5(QEvent::Paint);
    QCoreApplication::sendEvent(&widget, &event5);
}

void MainTest::badgeTest()
{
    KBadge badge(nullptr);
    badge.setValue(8);
    QCOMPARE(badge.value(), 8);
    badge.setValueVisiable(true);
    QCOMPARE(badge.isValueVisiable(), true);

    badge.setColor(Qt::red);
    QCOMPARE(badge.color(), Qt::red);

    badge.setFontSize(12);
    QCOMPARE(badge.fontSize(), 12);

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&badge, &event);
}

void MainTest::ballontipTest()
{
    KBallonTip ballontip;
    KBallonTip tip("tip", TipType::Normal);
    ballontip.showInfo();
    ballontip.setTipType(TipType::Info);
    QCOMPARE(ballontip.tipType(), TipType::Info);

    ballontip.setText("ballontip");
    QCOMPARE(ballontip.text(), "ballontip");

    ballontip.setContentsMargins(8, 8, 8, 8);

    ballontip.setContentsMargins(QMargins(6, 6, 6, 6));
    ballontip.setTipTime(1000);

    ballontip.hBoxLayout();
    ballontip.setVariableIcon(QIcon::fromTheme("kylin-music"));
    ballontip.variableIcon();

    ballontip.setTipType(TipType::Nothing);
    ballontip.setTipType(TipType::Warning);
    ballontip.setTipType(TipType::Error);
    ballontip.setTipType(TipType::Variable);

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&ballontip, &event);
}

void MainTest::borderbuttonTest()
{
    KBorderButton button;
    KBorderButton button1("button1");
    KBorderButton button2(QIcon::fromTheme("kylin-music"), "button2");
    //    KBorderButton button3(QIcon::fromTheme("kylin-music"));
    button.setIcon(QIcon::fromTheme("kylin-music"));
    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&button, &event);

    button1.setFixedWidth(100);
    QEvent event1(QEvent::Paint);
    QCoreApplication::sendEvent(&button1, &event1);

    button1.setIcon(QIcon::fromTheme("kylin-music"));
    QEvent event2(QEvent::Paint);
    QCoreApplication::sendEvent(&button1, &event2);

    button2.setEnabled(false);
    QEvent event3(QEvent::Paint);
    QCoreApplication::sendEvent(&button2, &event3);

    QWidget widget;
    widget.installEventFilter(&button);

    QCoreApplication::sendEvent(&widget, &event3);
}

void MainTest::borderlessbuttonTest()
{
    KBorderlessButton button;
    KBorderlessButton button1("button1111111111");
    KBorderlessButton button2(QIcon::fromTheme("kylin-music"), "button2");
    KBorderlessButton button3(QIcon::fromTheme("kylin-music"));
    button.setIcon(QIcon::fromTheme("kylin-music"));
    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&button, &event);

    button1.setFixedWidth(100);
    QEvent event1(QEvent::Paint);
    QCoreApplication::sendEvent(&button1, &event1);

    button1.setIcon(QIcon::fromTheme("kylin-music"));
    QEvent event2(QEvent::Paint);
    QCoreApplication::sendEvent(&button1, &event2);

    button3.setEnabled(false);
    QEvent event3(QEvent::Paint);
    QCoreApplication::sendEvent(&button2, &event3);

    QWidget widget;
    widget.installEventFilter(&button);

    QCoreApplication::sendEvent(&widget, &event3);
}

// void MainTest::breadcrumbTest()
//{
//     KBreadCrumb crumb;
//     crumb.setIcon(QIcon::fromTheme("kylin-music"));
//     QCOMPARE(crumb.icon(),QIcon::fromTheme("kylin-music"));

//    crumb.addTab("tab1");
//    crumb.addTab("tab2");
//    crumb.setFlat(true);
//    QCOMPARE(crumb.isFlat(),true);

//    QEvent event(QEvent::Paint);
//    QCoreApplication::sendEvent(&crumb, &event);
//}

void MainTest::bubblewidgetTest()
{
    KBubbleWidget widget;
    widget.setTailSize(QSize(16, 8));
    QCOMPARE(widget.tailSize(), QSize(16, 8));

    widget.setTailPosition(TailDirection::TopDirection, TailLocation::MiddleLocation);
    QCOMPARE(widget.tailDirection(), TailDirection::TopDirection);
    QCOMPARE(widget.tailLocation(), TailLocation::MiddleLocation);

    widget.setBorderRadius(6, 6, 6, 6);
    widget.setBorderRadius(8);

    widget.setEnableBlur(true);
    QCOMPARE(widget.enableBlur(), true);

    widget.setOpacity(0.3);
    QCOMPARE(widget.opacity(), 0.3);

    widget.setHighlightBackground(true);

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&widget, &event);

    widget.setTailPosition(TailDirection::LeftDirection, TailLocation::LeftLocation);
    QEvent event1(QEvent::Paint);
    QCoreApplication::sendEvent(&widget, &event1);

    widget.setTailPosition(TailDirection::BottomDirection, TailLocation::RightLocation);
    QEvent event2(QEvent::Paint);
    QCoreApplication::sendEvent(&widget, &event2);

    widget.setTailPosition(TailDirection::RightDirection, TailLocation::MiddleLocation);
    QEvent event3(QEvent::Paint);
    QCoreApplication::sendEvent(&widget, &event3);

    widget.setTailPosition(TailDirection::None, TailLocation::MiddleLocation);
    widget.setEnableBlur(true);
    widget.setHighlightBackground(false);
    QEvent event4(QEvent::Paint);
    QCoreApplication::sendEvent(&widget, &event4);
}

void MainTest::buttonboxTest()
{
    KButtonBox box;
    box.setOrientation(Qt::Horizontal);
    QCOMPARE(box.orientation(), Qt::Horizontal);

    KPushButton button1;
    KPushButton button2;
    KPushButton button3;
    QList<KPushButton *> list;
    list.append(&button2);
    list.append(&button3);

    box.addButton(&button1);
    box.removeButton(&button1);

    box.addButton(&button1);
    box.removeButton(0);

    box.setButtonList(list);
    box.buttonList();

    box.setBorderRadius(8);
    QCOMPARE(box.borderRadius(), 8);

    box.setId(&button2, 1);
    QCOMPARE(box.id(&button2), 1);

    box.checkedButton();

    box.button(1);
    box.checkedId();
    box.setExclusive(true);
    QCOMPARE(box.exclusive(), true);

    box.setCheckable(true);
    QCOMPARE(box.isCheckable(), true);

    box.setShadow(true);
    QCOMPARE(box.shadow(), true);

    box.setOrientation(Qt::Vertical);
    box.setShadow(false);
    box.removeButton(0);
}

void MainTest::clocktimerTest()
{
    KClockTimer clock;
    clock.time();
    clock.startStopwatch();
    clock.stopStopwatch();
    clock.resetStopwatch();

    ThemeController theme;
    //    emit theme.m_gsetting->changed("styleName");
}

void MainTest::colorbuttonTest()
{
    KColorButton button;
    KColorButton button1;
    button1.setButtonType(KColorButton::ButtonType::Circle);
    KColorButton button2;
    button2.setButtonType(KColorButton::ButtonType::CheckedRect);

    button.setBackgroundColor(Qt::red);
    QCOMPARE(button.backgroundColor(), Qt::red);

    button.setBorderRadius(8);
    QCOMPARE(button.borderRadius(), 8);

    button.setButtonType(KColorButton::ButtonType::RoundedRect);
    QCOMPARE(button.buttonType(), KColorButton::ButtonType::RoundedRect);

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&button, &event);

    QEvent event1(QEvent::Paint);
    QCoreApplication::sendEvent(&button1, &event1);

    QEvent event2(QEvent::Paint);
    QCoreApplication::sendEvent(&button2, &event2);

    KColorButton button3;
    button3.setEnabled(false);
    QEvent event3(QEvent::Paint);
    QCoreApplication::sendEvent(&button3, &event3);

    button3.setButtonType(KColorButton::ButtonType::CheckedRect);
    button3.setCheckable(true);
    button3.setChecked(true);
    QEvent event4(QEvent::Paint);
    QCoreApplication::sendEvent(&button3, &event4);

    button.setCheckable(true);
    button.setChecked(true);
    QEvent event5(QEvent::Paint);
    QCoreApplication::sendEvent(&button3, &event5);
}

void MainTest::colorcomboxTest()
{
    KColorComboBox box;

    QList<QColor> list;
    list.append(Qt::red);
    list.append(Qt::gray);
    list.append(Qt::green);

    box.setColorList(list);
    QCOMPARE(box.colorList(), list);

    box.addColor(Qt::blue);
    box.setComboType(KColorComboBox::ComboType::Circle);
    QCOMPARE(box.comboType(), KColorComboBox::ComboType::Circle);
    box.resize(800, 100);
    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&box, &event);

    box.setPopupItemSize(QSize(36, 36));
    //    QCOMPARE(box.popupItemSzie(),QSize(36,36));
    box.popupItemSzie();

    emit box.activated(Qt::red);
    emit box.currentColorChanged(Qt::red);
    emit box.highlighted(Qt::red);

    QEvent event1(QEvent::Paint);
    QCoreApplication::sendEvent(box.itemDelegate(), &event1);
}

void MainTest::comboboxwidgetTest()
{
    KComboBoxWidget widget;
    QStringList list;
    list << "list1"
         << "list2"
         << "list3";
    widget.setStringList(list);
    widget.getChosenList();
    widget.setMainText("maintext");
    widget.menu()->setFixedWidth(500);

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&widget, &event);

    QEvent event1(QEvent::Leave);
    QCoreApplication::sendEvent(&widget, &event1);

    QEvent event2(QEvent::Enter);
    QCoreApplication::sendEvent(&widget, &event2);

    QTest::mouseClick(&widget, Qt::LeftButton, Qt::NoModifier);
}

void MainTest::commentpanelTest()
{
    KCommentPanel panel;
    panel.setIcon(QIcon::fromTheme("kylin-music"));
    panel.setTime("2024-12-16");
    panel.setName("name");
    panel.setText("内容");
    panel.setGrade(StarLevel::LevelOne);

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&panel, &event);

    panel.setGrade(StarLevel::LevelTwo);
    QEvent event1(QEvent::Paint);
    QCoreApplication::sendEvent(&panel, &event1);

    panel.setGrade(StarLevel::LevelThree);
    QEvent event2(QEvent::Paint);
    QCoreApplication::sendEvent(&panel, &event2);

    panel.setGrade(StarLevel::LevelFour);
    QEvent event3(QEvent::Paint);
    QCoreApplication::sendEvent(&panel, &event3);

    panel.setGrade(StarLevel::LevelFive);
    QEvent event4(QEvent::Paint);
    QCoreApplication::sendEvent(&panel, &event4);

    panel.setGrade(StarLevel::LevelZero);
    QEvent event5(QEvent::Paint);
    QCoreApplication::sendEvent(&panel, &event5);
}

void MainTest::crumbTest()
{
    KCrumb crumb;
    crumb.addTab("tab1");
    crumb.addTab(QIcon::fromTheme("kylin-music"), "tab2");
    crumb.insertTab(0, "tab3");
    //    crumb.insertTab(0,QIcon::fromTheme("kylin-music"),"tab4");
    crumb.removeTab(0);
    crumb.moveTab(1, 0);
    crumb.setIcon(QIcon::fromTheme("kylin-music"));
    QCOMPARE(crumb.icon(), QIcon::fromTheme("kylin-music"));

    crumb.setFlat(true);
    QCOMPARE(crumb.isFlat(), true);

    crumb.leftScroll();
    crumb.rightScroll();

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&crumb, &event);

    crumb.setFlat(true);
    QEvent event1(QEvent::Paint);
    QCoreApplication::sendEvent(&crumb, &event1);

    crumb.addTab("tab5 test");
    crumb.addTab("tab6 test");
    crumb.setFixedWidth(100);
    QEvent event2(QEvent::Paint);
    QCoreApplication::sendEvent(&crumb, &event2);
}

void MainTest::customdateeditTest()
{
    KCustomDateEdit edit;
    edit.showCalendar();
    edit.setShowLunar(true);
    edit.updateStyle(false);

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&edit, &event);

    QTest::mousePress(&edit, Qt::LeftButton, Qt::NoModifier);

    edit.updateStyle(true);
    edit.setShowLunar(false);
    QEvent event1(QEvent::Paint);
    QCoreApplication::sendEvent(&edit, &event1);

    QWidget widget;
    widget.installEventFilter(&edit);

    QEvent event2(QEvent::Enter);
    QCoreApplication::sendEvent(&widget, &event2);

    QEvent event3(QEvent::HoverEnter);
    QCoreApplication::sendEvent(&widget, &event3);

    QEvent event4(QEvent::HoverLeave);
    QCoreApplication::sendEvent(&widget, &event4);

    QEvent event5(QEvent::FocusIn);
    QCoreApplication::sendEvent(&widget, &event5);

    QEvent event6(QEvent::FocusOut);
    QCoreApplication::sendEvent(&widget, &event6);
}

void MainTest::customtabbarTest()
{
    KCustomTabBar tabbar;
    tabbar.setShape(KCustomTabBar::Shape::RoundedNorth);
    QCOMPARE(tabbar.shape(), KCustomTabBar::Shape::RoundedNorth);
    QIcon icon(QIcon::fromTheme("kylin-music"));
    tabbar.addTab("tab1");
    tabbar.addTab(icon, "tab2");
    tabbar.insertTab(0, "tab3");
    tabbar.insertTab(0, icon, "tab4");

    tabbar.removeTab(0);
    tabbar.moveTab(0, 2);

    tabbar.setTabEnabled(0, true);
    QCOMPARE(tabbar.isTabEnabled(0), true);

    tabbar.setTabText(0, "tabbar");
    QCOMPARE(tabbar.tabText(0), "tabbar");

    tabbar.setTabContent(1, "tabbar2");

    tabbar.setTabTextColor(0, Qt::red);
    QCOMPARE(tabbar.tabTextColor(0), Qt::red);

    tabbar.setTabIcon(1, icon);
    QCOMPARE(tabbar.tabIcon(1), icon);

    tabbar.setElideMode(Qt::ElideLeft);
    QCOMPARE(tabbar.elideMode(), Qt::ElideLeft);

    tabbar.setTabToolTip(0, "tooltip");
    QCOMPARE(tabbar.tabToolTip(0), "tooltip");

    tabbar.setTabWhatsThis(1, "tabbar3");
    QCOMPARE(tabbar.tabWhatsThis(1), "tabbar3");

    tabbar.setTabData(0, QVariant());
    QCOMPARE(tabbar.tabData(0), QVariant());

    tabbar.tabRect(0);
    tabbar.tabAt(QPoint(0, 0));

    tabbar.currentIndex();
    tabbar.count();

    tabbar.sizeHint();
    tabbar.minimumSizeHint();

    tabbar.setDrawBase(true);
    QCOMPARE(tabbar.drawBase(), true);

    tabbar.setIconSize(QSize(24, 24));
    QCOMPARE(tabbar.iconSize(), QSize(24, 24));

    tabbar.setUsesScrollButtons(true);
    QCOMPARE(tabbar.usesScrollButtons(), true);

    tabbar.setTabsClosable(true);
    QCOMPARE(tabbar.tabsClosable(), true);

    tabbar.setSelectionBehaviorOnRemove(KCustomTabBar::SelectionBehavior::SelectLeftTab);
    QCOMPARE(tabbar.selectionBehaviorOnRemove(), KCustomTabBar::SelectionBehavior::SelectLeftTab);

    tabbar.setExpanding(true);
    QCOMPARE(tabbar.expanding(), true);

    tabbar.setMovable(true);
    QCOMPARE(tabbar.isMovable(), true);

    tabbar.setDocumentMode(true);
    QCOMPARE(tabbar.documentMode(), true);

    tabbar.setAutoHide(true);
    QCOMPARE(tabbar.autoHide(), true);

    tabbar.setChangeCurrentOnDrag(true);
    QCOMPARE(tabbar.changeCurrentOnDrag(), true);

    tabbar.setAccessibleTabName(0, "custom");
    QCOMPARE(tabbar.accessibleTabName(0), "custom");

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&tabbar, &event);
}

void MainTest::dialogTest()
{
    KDialog dialog;
    QIcon icon(QIcon::fromTheme("kylin-music"));
    dialog.setWindowIcon(icon);

    dialog.setWindowIcon("kylin-music");
    dialog.maximumButton();
    dialog.minimumButton();
    dialog.closeButton();
    dialog.menuButton();
    dialog.mainWidget();

    QWidget widget;
    widget.installEventFilter(&dialog);

    QEvent event2(QEvent::Show);
    QCoreApplication::sendEvent(&widget, &event2);

    QEvent event3(QEvent::WindowActivate);
    QCoreApplication::sendEvent(&widget, &event3);

    QEvent event4(QEvent::Hide);
    QCoreApplication::sendEvent(&widget, &event4);
}

void MainTest::dragwidgetTest()
{
    KDragWidget widget;

    QStringList list;
    list << "JPEG Files(*.jpg)"
         << "PNG Files(*.png)";

    widget.iconButton();
    widget.textLabel();
    widget.fileDialog();
    widget.setNameFilter("JPEG Files(*.jpg)");
    widget.setNameFilters(list);

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&widget, &event);

    QEvent event1(QEvent::Enter);
    QCoreApplication::sendEvent(&widget, &event1);

    QEvent event2(QEvent::DragLeave);
    QCoreApplication::sendEvent(&widget, &event2);

    QTest::mouseClick(&widget, Qt::LeftButton, Qt::NoModifier);
    QTest::mouseMove(&widget, widget.rect().center());
    QTest::keyRelease(&widget, Qt::Key_Up);

    //    QWidget widget1;
    //    widget1.installEventFilter(&widget);

    //    QEvent event3(QEvent::MouseButtonPress);
    //    QCoreApplication::sendEvent(&widget1, &event3);

    //    QEvent event4(QEvent::MouseButtonRelease);
    //    QCoreApplication::sendEvent(&widget, &event4);

    //    QEvent event5(QEvent::Leave);
    //    QCoreApplication::sendEvent(&widget, &event5);

    //    QEvent event6(QEvent::Enter);
    //    QCoreApplication::sendEvent(&widget, &event6);

    //    QEvent event7(QEvent::DragEnter);
    //    QCoreApplication::sendEvent(&widget, &event7);

    //    QEvent event8(QEvent::DragLeave);
    //    QCoreApplication::sendEvent(&widget, &event8);

    //    QEvent event9(QEvent::Show);
    //    QCoreApplication::sendEvent(&widget, &event9);
}

void MainTest::filewidgetTest()
{
    KFileWidget widget;

    widget.setMainText("main text");
    widget.setSubText("sub text");
    widget.setIcon(QIcon::fromTheme("kylin-music"));
    widget.setBorderRadius(8);
    widget.setBorderRadius(8, 8, 8, 8);

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&widget, &event);

    QTest::mouseClick(&widget, Qt::LeftButton, Qt::NoModifier);
    QTest::mouseMove(&widget, widget.rect().center());

    widget.setEnabled(false);
    QEvent event1(QEvent::Paint);
    QCoreApplication::sendEvent(&widget, &event1);

    QWidget widget1;
    widget1.installEventFilter(&widget);

    QEvent event2(QEvent::Enter);
    QCoreApplication::sendEvent(&widget1, &event2);

    QEvent event3(QEvent::MouseMove);
    QCoreApplication::sendEvent(&widget1, &event3);

    QEvent event4(QEvent::MouseButtonPress);
    QCoreApplication::sendEvent(&widget1, &event4);

    QEvent event5(QEvent::MouseButtonRelease);
    QCoreApplication::sendEvent(&widget1, &event5);

    QEvent event6(QEvent::Leave);
    QCoreApplication::sendEvent(&widget1, &event6);
}

void MainTest::flowlayoutTest()
{
    KFlowLayout layout;
    layout.horizontalSpacing();
    layout.verticalSpacing();
}

void MainTest::iconbarTest()
{
    KIconBar bar;
    bar.setIcon("kylin-music");
    bar.setIcon(QIcon::fromTheme("kylin-music"));
    bar.setWidgetName("iconbar");
    QCOMPARE(bar.nameLabel()->text(), "iconbar");
    bar.iconLabel();

    KIconBar bar1("iconbar1", "iconbar1");
    QTest::mouseDClick(&bar1, Qt::LeftButton, Qt::NoModifier);
}

void MainTest::inputdialogTest()
{
    KInputDialog input;
    input.setInputMode(KInputDialog::InputMode::TextInput);
    QCOMPARE(input.inputMode(), KInputDialog::InputMode::TextInput);

    input.setLabelText("text");
    QCOMPARE(input.labelText(), "text");

    input.setOption(KInputDialog::InputDialogOption::NoButtons, true);
    QCOMPARE(input.testOption(KInputDialog::InputDialogOption::NoButtons), true);

    input.open();

    input.setOptions(KInputDialog::UseListViewForComboBoxItems);
    //    QCOMPARE(input.options(),KInputDialog::NoButtons);
    input.options();

    input.setTextValue("text1");
    QCOMPARE(input.textValue(), "text1");

    input.setTextEchoMode(QLineEdit::Normal);
    QCOMPARE(input.textEchoMode(), QLineEdit::Normal);

    input.setComboBoxEditable(true);
    QCOMPARE(input.isComboBoxEditable(), true);

    QStringList list;
    list << "list1"
         << "list2"
         << "list3";
    input.setComboBoxItems(list);
    QCOMPARE(input.comboBoxItems(), list);

    input.setIntValue(8);
    QCOMPARE(input.intValue(), 8);

    input.setIntMinimum(0);
    QCOMPARE(input.intMinimum(), 0);

    input.setIntMaximum(100);
    QCOMPARE(input.intMaximum(), 100);

    input.setIntRange(0, 100);
    input.setIntStep(10);
    QCOMPARE(input.intStep(), 10);

    input.setDoubleValue(10.0);
    QCOMPARE(input.doubleValue(), 10.0);

    input.setDoubleMinimum(0.0);
    QCOMPARE(input.doubleMinimum(), 0.0);

    input.setDoubleMaximum(100.0);
    QCOMPARE(input.doubleMaximum(), 100.0);

    input.setDoubleRange(0.0, 100.0);

    input.setDoubleDecimals(2);
    QCOMPARE(input.doubleDecimals(), 2);

    input.setOkButtonText("OK");
    QCOMPARE(input.okButtonText(), "OK");

    input.setCancelButtonText("cancel");
    QCOMPARE(input.cancelButtonText(), "cancel");

    input.open();
    input.minimumSizeHint();
    input.sizeHint();
    input.setVisible(false);

    input.setPlaceholderText("place");
    QCOMPARE(input.placeholderText(), "place");

    QStringList item;
    item << "item1"
         << "item2";
    KInputDialog::getText(nullptr, tr("please input:")); // 单行文本输入框
    KInputDialog::getMultiLineText(nullptr, tr("please input:")); // 多行文本输入框
    KInputDialog::getItem(nullptr, tr("please input:"), item); // 多行文本输入框
    KInputDialog::getInt(nullptr, tr("please input:")); // 整型数字输入框
    KInputDialog::getDouble(nullptr, tr("please input:")); // 浮点型数字输入框
}

void MainTest::introwwidgetTest()
{
    KIntroWidget widget;
    widget.setViewType(ViewType::ListView);
    widget.setMainLabel("main");
    widget.setSubLabel("sub");
    widget.setBorderRadius(8);
    widget.setBorderRadius(6, 6, 6, 6);
    widget.setTitleColor(Qt::red);

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&widget, &event);

    KIntroWidget widget1;
    widget1.setViewType(ViewType::IconView);

    QTest::mouseClick(&widget1, Qt::RightButton, Qt::NoModifier);
    QCoreApplication::sendEvent(&widget1, &event);

    QWidget widget2;
    widget2.installEventFilter(&widget);

    QEvent event2(QEvent::Enter);
    QCoreApplication::sendEvent(&widget2, &event2);

    QEvent event3(QEvent::Leave);
    QCoreApplication::sendEvent(&widget2, &event3);

    QEvent event4(QEvent::MouseButtonPress);
    QCoreApplication::sendEvent(&widget2, &event4);

    QEvent event5(QEvent::MouseButtonRelease);
    QCoreApplication::sendEvent(&widget2, &event5);
}

void MainTest::itemwidgetTest()
{
    KItemWidget widget(QIcon::fromTheme("kylin-music"), "text1", "text2", nullptr);

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&widget, &event);

    widget.SetInverse();
    widget.CancelInverse();
    widget.SetIconSize(QSize(16, 16));

    QEvent event1(QEvent::Paint);
    QCoreApplication::sendEvent(&widget, &event1);
}

void MainTest::labelTest()
{
    KLabel label;
    KLabel label1;
    KLabel label2;
    label.setLabelType(KLabelType::NormalType);
    label1.setLabelType(KLabelType::DataType);
    label1.setText("changwenben");
    label1.setFixedWidth(50);
    label2.setLabelType(KLabelType::CircleType);
    label2.resize(50, 50);
    label.setDataHightColor(true);
    label.setPixmap(QIcon::fromTheme("kylin-music").pixmap(16, 16));
    //    label.setPixmap(QIcon::fromTheme("kylin-music"),16,16);
    label.pixmap();
    label.setText("label");
    QCOMPARE(label.text(), "label");

    label.setBackgroundColor(true, Qt::red);
    label.setHighlightBackground(true);
    label.setBorderRadius(6, 6, 6, 6);
    label.setBorderRadius(8);
    label.setWordWrap(true);
    QCOMPARE(label.wordWrap(), true);

    label.setFontColor(Qt::green);
    label.resize(100, 36);
    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&label, &event);
    QCoreApplication::sendEvent(&label1, &event);
    QCoreApplication::sendEvent(&label2, &event);

    label.setDataHightColor(false);
    label.setBackgroundColor(false);
    label.setHighlightBackground(false);
    label.setWordWrap(false);
    QCoreApplication::sendEvent(&label, &event);

    label1.setPixmap(QIcon::fromTheme("kylin-music").pixmap(16, 16));
    label1.setFixedWidth(300);
    QCoreApplication::sendEvent(&label1, &event);

    label1.setPixmap(QIcon::fromTheme("kylin-music").pixmap(16, 16));
    QCoreApplication::sendEvent(&label1, &event);

    KLabel label4;
    label4.setWordWrap(false);
    label4.setPixmap(QIcon::fromTheme("media-eq.symbolic").pixmap(16, 16));
    label4.setText("label4 test");
    QCoreApplication::sendEvent(&label4, &event);

    label4.setFixedWidth(20);
    label4.setDataHightColor(true);
    QCoreApplication::sendEvent(&label4, &event);

    label4.setDataHightColor(false);
    label4.setBackgroundColor(true);
    QCoreApplication::sendEvent(&label4, &event);

    label4.setAlignment(Qt::AlignCenter);
    QCoreApplication::sendEvent(&label4, &event);

    label4.setFontColorRole(QPalette::BrightText);
    label4.setTristate(true);
    label4.isTristate();

    QEvent event1(QEvent::Enter);
    QCoreApplication::sendEvent(&label4, &event1);
    QEvent event2(QEvent::Leave);
    QCoreApplication::sendEvent(&label4, &event2);
    QEvent event3(QEvent::MouseButtonPress);
    QCoreApplication::sendEvent(&label4, &event3);
    QEvent event4(QEvent::MouseButtonDblClick);
    QCoreApplication::sendEvent(&label4, &event4);
}

void MainTest::lineeditTest()
{
    KLineEdit lineedit;
    lineedit.pushbutton();

    lineedit.resize(100, 36);
    lineedit.setFocus();
    lineedit.setFocusPolicy(Qt::NoFocus);

    QTest::mouseClick(lineedit.pushbutton(), Qt::LeftButton, Qt::NoModifier);

    QEvent event(QEvent::Enter);
    QCoreApplication::sendEvent(&lineedit, &event);
    QCoreApplication::sendEvent(lineedit.pushbutton(), &event);

    QEvent event1(QEvent::Leave);
    QCoreApplication::sendEvent(&lineedit, &event1);

    //    QWidget widget2;
    //    widget2.installEventFilter(&lineedit);

    QEvent event2(QEvent::FocusIn);
    QCoreApplication::sendEvent(&lineedit, &event2);

    QEvent event3(QEvent::FocusOut);
    QCoreApplication::sendEvent(&lineedit, &event3);

    QEvent event4(QEvent::Resize);
    QCoreApplication::sendEvent(&lineedit, &event4);
}

void MainTest::lineframeTest()
{
    KHLineFrame hline;
    hline.setFollowPalette(true);

    KVLineFrame vline;
    vline.setFollowPalette(true);
}

void MainTest::listviewTest()
{
    KListView view(nullptr);
    QTest::mouseClick(&view, Qt::LeftButton, Qt::NoModifier, view.rect().center());
}

void MainTest::listviewdelegateTest()
{
    KListViewDelegate delegate(nullptr);
    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&delegate, &event);

    //    QListView view1;

    //    view1.setIconSize(QSize(32,32));

    //    QStandardItemModel model1;
    //    KListViewDelegate delegate1(&view1);

    //    view1.setModel(&model1);

    //    QStandardItem item3;
    //    item3.setIcon(QIcon::fromTheme("kylin-music"));
    //    item3.setData(QVariant("Test"),Qt::DisplayRole);

    //    QStandardItem item4;
    //    item4.setIcon(QIcon::fromTheme("kylin-music"));
    //    item4.setData(QVariant("Test"),Qt::DisplayRole);

    //    QStandardItem item5;
    //    item5.setIcon(QIcon::fromTheme("kylin-music"));
    //    item5.setData(QVariant("Test"),Qt::DisplayRole);

    //    model1.appendRow(&item3);
    //    model1.appendRow(&item4);
    //    model1.appendRow(&item5);
    //    view1.setItemDelegate(&delegate1);
    //    QCoreApplication::sendEvent(&delegate, &event);
}

void MainTest::listWidgetTest()
{
    KListWidget widget(nullptr);
    KItemWidget item1(QIcon::fromTheme("kylin-music"), QString("IMG202202121544.JPG"), QString("1.6MB"), &widget);
    KItemWidget item2(QIcon::fromTheme("kylin-music"), QString("IMG202202121544.JPG"), QString("1.7MB"), &widget);
    KItemWidget item3(QIcon::fromTheme("kylin-music"), QString("IMG202202121544.JPG"), QString("1.8MB"), &widget);
    widget.AddItemWidget(&item1);
    widget.AddItemWidget(&item2);
    widget.AddItemWidget(&item3);
    QListWidgetItem item4;
    QListWidgetItem item5;

    widget.currentItemChanged(&item4, &item5);
    widget.itemClicked(&item4);
}

void MainTest::loopplaypageTest()
{
    KLoopPlayPage page;

    QWidget widget;
    QWidget widget1;
    QWidget widget2;
    QWidget widget3;

    page.addWidget(&widget);
    page.addWidget(&widget1);
    page.addWidget(&widget2);
    page.addWidget(&widget3);

    page.removeWidget(&widget);
    page.setCurrentWidget(1);
    QCOMPARE(page.currentWidget(), 1);

    page.setWidgetSpacing(10);
    page.setLoopTime(10000);
    page.resize(500, 300);
    page.show();

    emit page.leftClick();
    emit page.centerClick();
    emit page.rightClick();

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&page, &event);
}

void MainTest::lunarcalendarinfoTest()
{
    KLunarCalendarInfo info;
    info.isLoopYear(2024);
    info.getMonthDays(2024, 12);
    info.getTotalMonthDays(2024, 12);
    info.getFirstDayOfWeek(2024, 12, true);
    info.getFirstDayOfWeek(2024, 11, false);
    info.getHoliday(12, 16);
    info.getSolarTerms(2024, 12, 16);
    info.getLunarFestival(12, 16);
    info.getLunarYear(2024);
    //    info.getLunarCalendarInfo(2024,12,16,"","","","","","");
    info.getLunarInfo(2024, 12, 16, true, true, true);
    info.getLunarInfo(2024, 12, 16, false, false, false);
    info.getLunarYearMonthDay(2024, 11, 16);
    info.getLunarMonthDay(2024, 11, 16);
    info.getLunarDay(2024, 11, 16);

    info.isLoopYear(2024);
    info.getMonthDays(2024, 8);
    info.getTotalMonthDays(2024, 8);
    info.getFirstDayOfWeek(2024, 8, true);
    info.getFirstDayOfWeek(2024, 8, false);
    info.getHoliday(8, 16);
    info.getSolarTerms(2024, 8, 16);
    info.getLunarFestival(8, 16);
    info.getLunarYear(2024);
    //    info.getLunarCalendarInfo(2024,12,16,"","","","","","");
    info.getLunarInfo(2024, 8, 16, true, true, true);
    info.getLunarInfo(2024, 8, 16, false, false, false);
    info.getLunarYearMonthDay(2024, 8, 16);
    info.getLunarMonthDay(2024, 8, 16);
    info.getLunarDay(2024, 8, 16);
}

void MainTest::lunardateeditTest()
{
    KLunarDateEdit edit;
    edit.setShowLunar(true);
    edit.getDateEdit();
}

void MainTest::menubuttonTest()
{
    KMenuButton button;
    button.menu();
    button.themeMenu();
    button.settingAction();
    button.themeAction();
    button.assistAction();
    button.aboutAction();
    button.feedbackAction();
    button.quitAction();
    button.autoAction();
    button.lightAction();
    button.darkAction();

    //    emit button.menu()->triggered(button.feedbackAction());

    emit button.feedbackAction()->trigger();

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&button, &event);
}

void MainTest::messageboxTest()
{
    KMessageBox box;
    QIcon icon(QIcon::fromTheme("kylin-music"));
    box.setCustomIcon(icon);

    QPushButton btn;
    box.addButton(&btn, KMessageBox::ButtonRole::YesRole);
    box.addButton("btn1", KMessageBox::ButtonRole::NoRole);
    box.addButton(KMessageBox::StandardButton::YesToAll);
    box.removeButton(&btn);
    box.button(KMessageBox::StandardButton::NoButton);
    box.buttons();
    box.buttonRole(&btn);
    box.checkBox();
    QCheckBox checkbox;
    box.setCheckBox(&checkbox);
    box.setText("messagebox");
    QCOMPARE(box.text(), "messagebox");

    box.setInformativeText("");
    box.setInformativeText("box");
    QCOMPARE(box.informativeText(), "box");

    box.setIcon(KMessageBox::Icon::Warning);
    QCOMPARE(box.icon(), KMessageBox::Icon::Warning);

    box.setIconPixmap(icon.pixmap(16, 16));
    QCOMPARE(box.iconPixmap(), icon.pixmap(16, 16));

    box.setStandardButtons(KMessageBox::SaveAll);
    QCOMPARE(box.standardButtons(), KMessageBox::SaveAll);

    box.standardButton(&btn);

    QPushButton btn1;
    box.setDefaultButton(&btn1);
    box.defaultButton();
    //    QCOMPARE(box.defaultButton(),&btn1);
    box.addButton(&btn1, KMessageBox::ButtonRole::YesRole);
    box.setDefaultButton(&btn1);

    box.setDefaultButton(KMessageBox::StandardButton::Ok);
    box.setDefaultButton(KMessageBox::StandardButton::Cancel);
    box.setDefaultButton(KMessageBox::StandardButton::Yes);
    box.setDefaultButton(KMessageBox::StandardButton::No);
    box.clickedButton();

    box.standardIcon(KMessageBox::Icon::Warning);

    box.informativeLabel();

    KMessageBox::information(nullptr, "infor", "messagebox");
    KMessageBox::question(nullptr, "ques", "messagebox");
    KMessageBox::warning(nullptr, "warning", "messagebox");
    KMessageBox::critical(nullptr, "crit", "messagebox");
    KMessageBox::success(nullptr, "success", "messagebox");
}

void MainTest::minicalendaritemTest()
{
    KMiniCalendarItem item;
    item.getSelect();
    item.getShowLunar();
    item.getEnableBorder();
    item.getSelectType();
    item.getDate();
    item.getLunar();
    item.getDayType();
    item.getBorderColor();
    item.getWeekColor();
    item.getSuperColor();
    item.getLunarColor();
    item.getCurrentTextColor();
    item.getOtherTextColor();
    item.getSelectTextColor();
    item.getHoverTextColor();
    item.getCurrentLunarColor();
    item.getOtherLunarColor();
    item.getSelectLunarColor();
    item.getHoverLunarColor();
    item.getCurrentBgColor();
    item.getOtherBgColor();
    item.getSelectBgColor();
    item.getHoverBgColor();
    item.sizeHint();
    item.minimumSizeHint();

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&item, &event);

    QEvent event1(QEvent::Enter);
    QCoreApplication::sendEvent(&item, &event1);

    QEvent event2(QEvent::Leave);
    QCoreApplication::sendEvent(&item, &event2);

    QTest::mouseClick(&item, Qt::LeftButton, Qt::NoModifier);
}

void MainTest::minicalendarwidgetTest()
{
    KMiniCalendarWidget widget;
    widget.getCalendarStyle();
    widget.getWeekNameFormat();
    widget.getDate();
    widget.getWeekTextColor();
    widget.getWeekBgColor();
    widget.getShowLunar();
    widget.getEnableBorder();
    widget.getSelectType();
    widget.getBorderColor();
    widget.getWeekColor();
    widget.getLunarColor();
    widget.getCurrentTextColor();
    widget.getOtherTextColor();
    widget.getSelectTextColor();
    widget.getHoverTextColor();
    widget.getCurrentLunarColor();
    widget.getOtherLunarColor();
    widget.getSelectLunarColor();
    widget.getHoverLunarColor();
    widget.getCurrentBgColor();
    widget.getOtherBgColor();
    widget.getSelectBgColor();
    widget.getHoverBgColor();
    widget.sizeHint();
    widget.minimumSizeHint();

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&widget, &event);
}

void MainTest::nativetabbarTest()
{
    KNativeTabbar tabbar;
    tabbar.addTab("tab1");
    tabbar.addTab("tab2");
    tabbar.addTab("tab3");
    tabbar.setTabbarStyle(KNativeTabbarStyle::SegmentDark);
    QCOMPARE(tabbar.barStyle(), KNativeTabbarStyle::SegmentDark);

    tabbar.setBorderRadius(8);
    QCOMPARE(tabbar.borderRadius(), 8);

    tabbar.setBackgroundColor(Qt::red);

    QEvent event1(QEvent::Paint);
    QCoreApplication::sendEvent(&tabbar, &event1);

    tabbar.setTabbarStyle(KNativeTabbarStyle::SegmentLight);
    QCoreApplication::sendEvent(&tabbar, &event1);

    tabbar.setTabbarStyle(KNativeTabbarStyle::Sliding);
    QCoreApplication::sendEvent(&tabbar, &event1);

    KNativeTabbar tabbar1;
    tabbar1.setTabbarStyle(KNativeTabbarStyle::SegmentDark);
    tabbar1.addTab(QIcon::fromTheme("ukui-dialog-success"), "正常");
    tabbar1.addTab(QIcon::fromTheme("dialog-warning"), "错误");
    tabbar1.addTab(QIcon::fromTheme("dialog-info"), "注意");
    tabbar1.addTab(QIcon::fromTheme("kylin-music"), "Sliding4");
    tabbar1.addTab("Sliding5");
    tabbar1.addTab(QIcon::fromTheme("kylin-music"), "Sliding6");
    QCoreApplication::sendEvent(&tabbar1, &event1);
    tabbar1.setFixedWidth(100);
    QCoreApplication::sendEvent(&tabbar1, &event1);

    tabbar1.setTabbarStyle(KNativeTabbarStyle::SegmentLight);
    QCoreApplication::sendEvent(&tabbar1, &event1);
    tabbar1.setFixedWidth(1000);
    QCoreApplication::sendEvent(&tabbar1, &event1);

    tabbar1.setTabbarStyle(KNativeTabbarStyle::Sliding);
    QCoreApplication::sendEvent(&tabbar1, &event1);
    tabbar1.setFixedWidth(100);
    QCoreApplication::sendEvent(&tabbar1, &event1);
}

void MainTest::navigationbarTest()
{
    QStandardItem *item1 = new QStandardItem(QIcon::fromTheme("system-computer-symbolic"), tr("一级导航"));
    QStandardItem *item2 = new QStandardItem(QIcon::fromTheme("stock-people-symbolic"), tr("二级导航"));
    QList<QStandardItem *> list;
    QStandardItem *item3 = new QStandardItem(QIcon::fromTheme("camera-switch-symbolic"), tr("一组一级导航1"));
    QStandardItem *item4 = new QStandardItem(QIcon::fromTheme("media-eq-symbolic"), tr("一组一级导航2"));
    list << item3 << item4;

    QStandardItem *item5 = new QStandardItem(QIcon::fromTheme("media-eq-symbolic"), tr("一组一级导航2"));

    KNavigationBar bar(nullptr);
    bar.addItem(item1);
    bar.addSubItem(item2);
    bar.addGroupItems(list,"tag2");
    bar.insertGroupItems("tag3",3,item5);
    bar.removeGroupItem("tag3",item5);

    bar.addTag("tag4");
    bar.model();
    bar.listview();
    bar.setTabValue(item1,"4");
    bar.setTabValueVisible(true);
    bar.setAddIcon("tag2",QIcon::fromTheme("kylin-music"));
    bar.setAddTagVisible("tag3",true);
    bar.setExtendTagVisible("tag2",true);

    QEvent event1(QEvent::Paint);
    QCoreApplication::sendEvent(&bar, &event1);
    QCoreApplication::sendEvent(bar.listview()->itemDelegate(), &event1);
}

void MainTest::navigationtrailTest()
{
    KNavigationTrail trail;
    trail.crumb();
    trail.crumb()->addTab("tab1");
    trail.crumb()->addTab("tab2");
    trail.crumb()->addTab("tab3");
    trail.setPosition(ButtonPosition::LeftOrRight);
    trail.resize(200, 36);

    KNavigationTrail trail1;
    trail1.setPosition(ButtonPosition::LeftPosition);

    KNavigationTrail trail2;
    trail2.setPosition(ButtonPosition::RightPosition);

    emit trail.crumb()->currentChanged(0);
    emit trail.crumb()->currentChanged(1);
    emit trail.crumb()->currentChanged(2);

    emit trail.sizeChange();
}

void MainTest::passwordeditTest()
{
    KPasswordEdit edit(nullptr);
    edit.setState(LoginState::Ordinary);
    QCOMPARE(edit.state(), LoginState::Ordinary);

    edit.setLoading(true);
    QCOMPARE(edit.isLoading(), true);

    QString str("password");
    edit.setPlaceholderText(str);
    QCOMPARE(edit.placeholderText(), "password");

    edit.setClearButtonEnabled(true);
    //    QCOMPARE(edit.isClearButtonEnabled(),true);
    edit.isClearButtonEnabled();

    edit.setEchoModeBtnVisible(true);
    //    QCOMPARE(edit.echoModeBtnVisible(),true);
    edit.echoModeBtnVisible();

    edit.setClearBtnVisible(true);
    //    QCOMPARE(edit.clearBtnVisible(),true);
    edit.clearBtnVisible();

    edit.setEnabled(true);
    edit.setEchoMode(QLineEdit::EchoMode::Normal);
    edit.setUseCustomPalette(true);

    KPasswordEdit edit1(nullptr);
    edit1.setState(LoginState::LoginSuccess);

    KPasswordEdit edit2(nullptr);
    edit2.setState(LoginState::LoginFailed);

    QWidget widget2;
    widget2.installEventFilter(&edit);

    QEvent event2(QEvent::FocusIn);
    QCoreApplication::sendEvent(&widget2, &event2);

    QEvent event3(QEvent::FocusOut);
    QCoreApplication::sendEvent(&widget2, &event3);
}

void MainTest::pixmapcontainerTest()
{
    KPixmapContainer pixmap;
    pixmap.setValue(16);
    QCOMPARE(pixmap.value(), 16);

    pixmap.setValueVisiable(true);
    QCOMPARE(pixmap.isValueVisiable(), true);

    QPixmap pix = QIcon::fromTheme("kylin-music").pixmap(16, 16);
    pixmap.setPixmap(pix);
    QCOMPARE(pixmap.pixmap(), pix);

    pixmap.clearValue();

    pixmap.setColor(Qt::red);
    QCOMPARE(pixmap.color(), Qt::red);

    pixmap.setFontSize(16);
    QCOMPARE(pixmap.fontSize(), 16);

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&pixmap, &event);

    pixmap.setValueVisiable(false);
    QCoreApplication::sendEvent(&pixmap, &event);
}

void MainTest::pressbuttonTest()
{
    KPressButton button;
    button.setBorderRadius(10);
    button.setBorderRadius(8, 8, 8, 8);
    button.setCheckable(true);
    QCOMPARE(button.isCheckable(), true);

    button.setChecked(true);
    QCOMPARE(button.isChecked(), true);

    button.setButtonType(KPressButton::ButtonType::NormalType);
    QCOMPARE(button.buttonType(), KPressButton::ButtonType::NormalType);

    button.setLoaingStatus(true);
    QCOMPARE(button.isLoading(), true);

    button.setTranslucent(true);
    QCOMPARE(button.isTranslucent(), true);

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&button, &event);

    button.setCheckable(true);
    button.setChecked(false);
    button.setLoaingStatus(false);
    button.setTranslucent(false);
    QCoreApplication::sendEvent(&button, &event);

    button.setButtonType(KPressButton::ButtonType::CircleType);
    button.setCheckable(true);
    button.setChecked(false);
    button.setLoaingStatus(false);
    button.setTranslucent(false);
    QCoreApplication::sendEvent(&button, &event);

    button.setChecked(true);
    button.setLoaingStatus(true);
    button.setTranslucent(true);
    QCoreApplication::sendEvent(&button, &event);
}

void MainTest::progressbarTest()
{
    KProgressBar bar(nullptr);
    bar.setState(ProgressBarState::FailedProgress);
    QCOMPARE(bar.state(), ProgressBarState::FailedProgress);

    bar.setOrientation(Qt::Horizontal);
    bar.text();

    bar.setOrientation(Qt::Vertical);
    bar.setBodyWidth(20);
    bar.setGradationColor(Qt::red, Qt::green);
    bar.setBackgroundColor(Qt::red);
    bar.setFillColor(Qt::gray);
    bar.setGradation(true);
    QCOMPARE(bar.gradation(), true);

    bar.setAnimation(true);
    QCOMPARE(bar.animation(), true);

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&bar, &event);

    bar.setState(ProgressBarState::NormalProgress);
    QEvent event1(QEvent::Paint);
    QCoreApplication::sendEvent(&bar, &event1);

    bar.setState(ProgressBarState::SuccessProgress);
    QEvent event2(QEvent::Paint);
    QCoreApplication::sendEvent(&bar, &event2);

    bar.setOrientation(Qt::Horizontal);
    bar.setState(ProgressBarState::FailedProgress);
    QEvent event3(QEvent::Paint);
    QCoreApplication::sendEvent(&bar, &event3);

    bar.setState(ProgressBarState::NormalProgress);
    QEvent event4(QEvent::Paint);
    QCoreApplication::sendEvent(&bar, &event4);

    bar.setState(ProgressBarState::SuccessProgress);
    QEvent event5(QEvent::Paint);
    QCoreApplication::sendEvent(&bar, &event5);

    bar.setGradation(false);
    bar.setAnimation(false);
    QCoreApplication::sendEvent(&bar, &event5);
}

void MainTest::progresscircleTest()
{
    KProgressCircle circle;
    circle.minimum();
    circle.maximum();
    circle.value();
    circle.text();
    circle.setTextVisible(true);
    QCOMPARE(circle.isTextVisible(), true);

    circle.reset();
    circle.setRange(0, 100);
    circle.setMinimum(0);
    circle.setMaximum(100);
    circle.setValue(20);

    circle.setState(ProgressBarState::NormalProgress);
    QCOMPARE(circle.state(), ProgressBarState::NormalProgress);

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&circle, &event);

    circle.setTextVisible(false);
    circle.setState(ProgressBarState::FailedProgress);
    QEvent event1(QEvent::Paint);
    QCoreApplication::sendEvent(&circle, &event1);

    circle.setState(ProgressBarState::SuccessProgress);
    QEvent event2(QEvent::Paint);
    QCoreApplication::sendEvent(&circle, &event2);
}

void MainTest::progressdialogTest()
{
    KProgressDialog dialog;
    KProgressDialog dialog1("text");
    QLabel label("lable");
    dialog.setLabel(&label);

    QPushButton btn1;
    dialog.setCancelButton(&btn1);

    QProgressBar bar;
    dialog.setBar(&bar);

    dialog.setSuffix("kb");
    dialog.setShowDetail(true);
    dialog.minimum();
    dialog.maximum();
    dialog.value();
    dialog.labelText();
    dialog.setAutoReset(true);
    QCOMPARE(dialog.autoReset(), true);

    dialog.setAutoClose(true);
    QCOMPARE(dialog.autoClose(), true);

    dialog.progressBar();

    dialog.cancel();
    dialog.reset();
    dialog.setMaximum(100);
    dialog.setMinimum(0);
    dialog.setRange(0, 100);
    dialog.setValue(20);
    dialog.setLabelText("tooltip");
    dialog.setCancelButtonText("cancel");
    dialog.setSubContent("sub text");
}

void MainTest::progresslabelTest()
{
    KProgressLabel gress;
    QStringList list1;
    QStringList list2;
    list1 << "list1"
          << "list2"
          << "list3";
    list2 << "1"
          << "2"
          << "3";

    gress.setStringList(list1, list2);

    QStringList list3;
    QStringList list4;
    list1 << "list11"
          << "list22"
          << "list33";
    list2 << "11"
          << "22"
          << "33";
    gress.setStringList(list3, list4);
    gress.setStringList(list1);
    gress.setCurrentIndex(1);
    //    QCOMPARE(gress.currentIndex(),1);
    gress.currentIndex();
    gress.setCurrentIndex(2);

    gress.setCircleSize(QSize(24, 24));
}

void MainTest::pushbuttonTest()
{
    KPushButton button;
    button.setBorderRadius(10, 10, 10, 10);
    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&button, &event);

    button.setBorderRadius(8);
    QCOMPARE(button.borderRadius(), 8);
    button.setBackgroundColor(Qt::red);
    QCOMPARE(button.backgroundColor(), Qt::red);
    QCoreApplication::sendEvent(&button, &event);

    button.setButtonType(KPushButton::ButtonType::NormalType);
    QCOMPARE(button.buttonType(), KPushButton::ButtonType::NormalType);
    QCoreApplication::sendEvent(&button, &event);

    button.setTranslucent(true);
    QCOMPARE(button.isTranslucent(), true);
    QCoreApplication::sendEvent(&button, &event);

    button.setIconHighlight(true);
    QCOMPARE(button.isIconHighlight(), true);
    QCoreApplication::sendEvent(&button, &event);

    button.setIconColor(Qt::red);
    QCOMPARE(button.IconColor(), Qt::red);
    QCoreApplication::sendEvent(&button, &event);

    button.setBackgroundColorHighlight(true);
    QCOMPARE(button.isBackgroundColorHighlight(), true);
    QCoreApplication::sendEvent(&button, &event);

    QMenu menu;
    button.setMenu(&menu);
    button.setArrow(true, KPushButton::ArrowTop);
    button.setButtonType(KPushButton::ButtonType::CircleType);
    QCOMPARE(button.hasArrow(), true);
    QCoreApplication::sendEvent(&button, &event);

    button.setArrow(false);
    QCoreApplication::sendEvent(&button, &event);

    button.setArrow(true, KPushButton::ArrowBottom);
    button.setButtonType(KPushButton::ButtonType::ShadowType);
    QCoreApplication::sendEvent(&button, &event);

    button.setArrow(false);
    QCoreApplication::sendEvent(&button, &event);

    button.setArrow(true, KPushButton::ArrowLeft);
    QCoreApplication::sendEvent(&button, &event);

    button.setArrow(true, KPushButton::ArrowRight);
    QCoreApplication::sendEvent(&button, &event);

    button.setIcon(QIcon::fromTheme("kylin-music"));
    QCoreApplication::sendEvent(&button, &event);

    KPushButton button1;
    button1.setEnabled(false);
    QCoreApplication::sendEvent(&button1, &event);

    button1.setArrow(false);
    QCoreApplication::sendEvent(&button1, &event);

    button1.setIcon(QIcon::fromTheme("kylin-music"));
    QCoreApplication::sendEvent(&button1, &event);

    button1.setText("button test");
    button1.setFixedWidth(20);
    QCoreApplication::sendEvent(&button1, &event);

    QWidget widget2;
    widget2.installEventFilter(&button);

    QEvent event2(QEvent::Paint);
    QCoreApplication::sendEvent(&widget2, &event2);
}

void MainTest::searchlineeditTest()
{
    KSearchLineEdit edit;
    edit.resize(100, 36);
    edit.setEnabled(true);
    QCOMPARE(edit.isEnabled(), true);

    edit.setClearButtonEnabled(true);
    QCOMPARE(edit.isClearButtonEnabled(), true);

    edit.setPlaceholderText("search");
    QCOMPARE(edit.placeholderText(), "search");

    edit.setPlaceholderAlignment(Qt::AlignLeft);
    QCOMPARE(edit.placeholderAlignment(), Qt::AlignLeft);

    edit.setAlignment(Qt::AlignLeft);
    QCOMPARE(edit.alignment(), Qt::AlignLeft);

    edit.setTranslucent(true);
    QCOMPARE(edit.isTranslucent(), true);

    edit.reloadStyle();

    edit.customButton();
    edit.setGradation(true);
    edit.setCustomButtonVisible(true);
    //    QCOMPARE(edit.isCustomButtonVisible(),true);
    edit.isCustomButtonVisible();

    edit.show();

    edit.setText("clear");
    edit.setFocus();
    edit.clear();

    edit.setText("clear");
    edit.setFocusPolicy(Qt::NoFocus);
    edit.clear();
    edit.hide();

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&edit, &event);

    edit.setEnabled(false);
    edit.setClearButtonEnabled(false);
    edit.setTranslucent(false);
    edit.setGradation(false);
    QCoreApplication::sendEvent(&edit, &event);

    QWidget widget2;
    widget2.installEventFilter(&edit);

    QEvent event2(QEvent::ContextMenu);
    QCoreApplication::sendEvent(&widget2, &event2);

    QEvent event3(QEvent::Show);
    QCoreApplication::sendEvent(&widget2, &event3);

    QEvent event4(QEvent::FocusIn);
    QCoreApplication::sendEvent(&widget2, &event4);

    QEvent event5(QEvent::FocusOut);
    QCoreApplication::sendEvent(&widget2, &event5);

    QEvent event6(QEvent::HoverEnter);
    QCoreApplication::sendEvent(&widget2, &event6);
}

void MainTest::securitylevelbarTest()
{
    KSecurityLevelBar bar;
    bar.setSecurityLevel(SecurityLevel::Low);
    QCOMPARE(bar.securityLevel(), SecurityLevel::Low);

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&bar, &event);

    bar.setSecurityLevel(SecurityLevel::Medium);
    QEvent event1(QEvent::Paint);
    QCoreApplication::sendEvent(&bar, &event1);

    bar.setSecurityLevel(SecurityLevel::High);
    QEvent event2(QEvent::Paint);
    QCoreApplication::sendEvent(&bar, &event2);
}

void MainTest::securityquestiondialogTest()
{
    KSecurityQuestionDialog dialog;
    dialog.setTitleText("dialog");
    dialog.addSecurityQuestionItem(3, true, true);
    dialog.addSecurityQuestionItem(3, true);
    QStringList list;
    list << "list1"
         << "list2"
         << "list3";
    dialog.initQustionCombox(list);
    dialog.questionLabel(0);
    dialog.questionCombox(0);
    dialog.answerLabel(0);
    dialog.answerLineedit(0);
    dialog.tipsLabel(0);
    dialog.cancelButton();
    dialog.confirmButton();

    dialog.addSecurityQuestionItem(3, false, false);
    dialog.addSecurityQuestionItem(3, false);

    QTest::keyPress(&dialog, Qt::Key_Enter);
    QTest::keyPress(&dialog, Qt::Key_Return);
}

void MainTest::settinggroupTest()
{
    KSettingGroup settinggroup;

    KPushButtonFrame pushbutton("button",&settinggroup);
    pushbutton.pushButton()->setText(tr("click"));
    pushbutton.titleLabel()->setText("pushbutton frame");
    pushbutton.mainHLayout();

    KSwitchButtonFrame switchbutton("switch",&settinggroup);
    switchbutton.switchButton()->setEnabled(false);
    switchbutton.titleLabel()->setText("switchbutton frame");
    switchbutton.mainHLayout();

    KComboBoxFrame comboboxbutton("combobox",&settinggroup);
    comboboxbutton.comboBox()->addItem(tr("you can add item by addItem"));
    comboboxbutton.comboBox()->addItem(tr("you can add item by addItem1"));
    comboboxbutton.titleLabel()->setText("comboboxbutton frame");
    comboboxbutton.mainHLayout();

    KLineEditFrame lineeditbutton("lineedit",&settinggroup);
    lineeditbutton.lineEdit()->setDisabled(false);
    lineeditbutton.titleLabel()->setText("lineedit frame");
    lineeditbutton.mainHLayout();

    KSliderFrame sliderbutton("slider",false,&settinggroup);
    sliderbutton.leftLabel()->setText(tr("small"));
    sliderbutton.rightLabel()->setText(tr("large"));
    sliderbutton.slider()->setRange(1,10);
    sliderbutton.slider()->setValue(4);
    sliderbutton.titleLabel()->setText("slider frame");
    sliderbutton.mainHLayout();

    KRadioButtonFrame radiobutton("radio",&settinggroup);
    QRadioButton button1(tr("radio1"));
    QRadioButton button2(tr("radio2"));
    QRadioButton button3(tr("radio3"));
    radiobutton.addButton(&button1);
    radiobutton.addButton(&button2);
    radiobutton.addButton(&button3);
    radiobutton.buttonGroup();
    radiobutton.titleLabel()->setText("radiobutton frame");
    radiobutton.mainHLayout();


    KAddButton addUserBtn;
    addUserBtn.setObjectName("addUser");
    addUserBtn.setRadiusType(KBaseFrame::BorderRadiusStyle::Around);
    addUserBtn.getTabletMode();
    addUserBtn.setHeightAdaptive(true);

    QHBoxLayout *addUserHorLayout = new QHBoxLayout();
    addUserHorLayout->setContentsMargins(0, 0, 0, 0);
    addUserHorLayout->addWidget(&addUserBtn);

    KBaseFrame addUserFrame;
    addUserFrame.setContentsMargins(0,0,0,0);
    addUserFrame.setObjectName("continue");
//    addUserFrame.setLayout(addUserHorLayout);
    addUserFrame.setRadiusType(KBaseFrame::BorderRadiusStyle::Around);
    addUserFrame.getTabletMode();
    addUserFrame.setContainer();
    addUserFrame.isContainer();

    settinggroup.addWidget(&pushbutton);
    settinggroup.setOneRadiusStyle(KBaseFrame::BorderRadiusStyle::Around);
    settinggroup.removeAndDeleteAllWidget();

    settinggroup.addWidget(&pushbutton);
    settinggroup.addWidget(&switchbutton);
    settinggroup.addWidget(&comboboxbutton);
    settinggroup.addWidget(&lineeditbutton);
    settinggroup.addWidget(&sliderbutton);
    settinggroup.addWidget(&radiobutton);
    settinggroup.insertWidget(0,&addUserFrame);
    settinggroup.removeWidget(&addUserFrame);
    settinggroup.updateShape();
    settinggroup.setLastRadiusStyle(KBaseFrame::BorderRadiusStyle::Top);
    settinggroup.showItemsCount();
}

void MainTest::shadowhelperTest()
{
    QWidget widget;
    effects::KShadowHelper::self()->setWidget(&widget);
}

void MainTest::sliderTest()
{
    KSlider slider(nullptr);
    KSlider slider1(Qt::Vertical);
    slider.setTickInterval(10);
    QCOMPARE(slider.tickInterval(), 10);

    slider.setSliderType(KSliderType::SmoothSlider);
    QCOMPARE(slider.sliderType(), KSliderType::SmoothSlider);

    slider.setValue(10);
    slider.setNodeVisible(false);
    QCOMPARE(slider.nodeVisible(), false);

    slider.setToolTip("slider");
    QCOMPARE(slider.toolTip(), "slider");

    slider.setTranslucent(true);
    QCOMPARE(slider.isTranslucent(), true);

    slider.resize(200, 36);

    QTest::mouseClick(&slider, Qt::LeftButton, Qt::NoModifier);
    QTest::mouseMove(&slider, slider.rect().center());

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&slider, &event);

    slider.setSliderType(KSliderType::StepSlider);
    slider1.setSliderType(KSliderType::StepSlider);
    slider.setTickInterval(10);
    slider.setSingleStep(20);
    slider.setRange(-50, 50);
    slider.setValue(30);
    slider.setValue(40);
    QCoreApplication::sendEvent(&slider, &event);
    QCoreApplication::sendEvent(&slider1, &event);

    slider.setSliderType(KSliderType::NodeSlider);
    slider1.setSliderType(KSliderType::NodeSlider);
    slider.setOrientation(Qt::Horizontal);
    slider.setTickInterval(10);
    slider.setSingleStep(20);
    slider.setRange(-50, 50);
    slider.setValue(40);
    slider.setValue(0);
    QCoreApplication::sendEvent(&slider, &event);
    QCoreApplication::sendEvent(&slider1, &event);

    slider.setSliderType(KSliderType::SingleSelectSlider);
    slider.setTickInterval(10);
    slider.setSingleStep(20);
    slider.setRange(-50, 50);
    slider.setValue(0);
    slider1.setSliderType(KSliderType::SingleSelectSlider);
    slider.setNodeVisible(true);
    slider.setTranslucent(false);
    QCoreApplication::sendEvent(&slider, &event);
    QCoreApplication::sendEvent(&slider1, &event);

    QEvent event1(QEvent::MouseMove);
    QCoreApplication::sendEvent(&slider, &event1);

    QTest::mouseClick(&slider1, Qt::LeftButton, Qt::NoModifier);
    QTest::mouseMove(&slider1, slider.rect().center());

    QWidget widget2;
    widget2.installEventFilter(&slider);

    QEvent event2(QEvent::Enter);
    QCoreApplication::sendEvent(&widget2, &event2);

    QEvent event3(QEvent::Leave);
    QCoreApplication::sendEvent(&widget2, &event3);

    QEvent event4(QEvent::ToolTip);
    QCoreApplication::sendEvent(&widget2, &event4);

    QEvent event5(QEvent::Wheel);
    QCoreApplication::sendEvent(&widget2, &event5);
}

void MainTest::switchbuttonTest()
{
    KSwitchButton btn;
    btn.resize(100, 48);
    btn.setCheckable(true);
    QCOMPARE(btn.isCheckable(), true);

    btn.setChecked(true);
    QCOMPARE(btn.isChecked(), true);

    btn.setTranslucent(true);
    QCOMPARE(btn.isTranslucent(), true);

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&btn, &event);

    btn.setTranslucent(false);
    btn.setChecked(false);
    QCoreApplication::sendEvent(&btn, &event);

    btn.setEnabled(false);
    QCoreApplication::sendEvent(&btn, &event);

    btn.setTranslucent(true);
    btn.setChecked(false);
    QCoreApplication::sendEvent(&btn, &event);

    btn.setEnabled(true);
    QCoreApplication::sendEvent(&btn, &event);

    emit btn.stateChanged(false);
    emit btn.stateChanged(true);
}

// void MainTest::tabbarTest()
//{
//     KTabBar bar;
//     bar.setTabBarStyle(KTabBar::KTabBarStyle::SegmentDark);
//     QCOMPARE(bar.barStyle(),KTabBar::KTabBarStyle::SegmentDark);

//    bar.setBorderRadius(8);
//    QCOMPARE(bar.borderRadius(),8);

//    bar.setBackgroundColor(Qt::red);
//}

void MainTest::tableheaderviewTest()
{
    KTableHeaderView view(Qt::Horizontal);
    KTableHeaderView view1(Qt::Vertical);
    QStringList list;
    list << "list1"
         << "list2"
         << "list3";
    view.setTitle(list);
    QMenu menu;
    view.setMenu(&menu, 0);
}

void MainTest::tablemodelTest()
{
    KTableModel model;
}

void MainTest::tableviewTest()
{
    KTableView view;
    QStringList list;
    list << "list1"
         << "list2"
         << "list3";
    view.setHorizontalTitle(list);
    view.headerView();
    view.selectList();

    QWidget widget2;
    widget2.installEventFilter(&view);

    QEvent event2(QEvent::Enter);
    QCoreApplication::sendEvent(&widget2, &event2);

    QEvent event3(QEvent::Leave);
    QCoreApplication::sendEvent(&widget2, &event3);
}

void MainTest::tagTest()
{
    KTag tag;
    tag.setClosable(true);
    QCOMPARE(tag.closable(), true);

    tag.setText("text");
    QCOMPARE(tag.text(), "text");

    tag.setTagStyle(TagStyle::BoderTag);
    QCOMPARE(tag.tagStyle(), TagStyle::BoderTag);

    tag.setBackgroundColor(Qt::red);
    tag.setTranslucent(true);
    QCOMPARE(tag.translucent(), true);

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&tag, &event);

    tag.setTagStyle(TagStyle::HighlightTag);
    tag.setBackgroundColor(Qt::green);
    QCoreApplication::sendEvent(&tag, &event);

    tag.setTagStyle(TagStyle::BaseBoderTag);
    tag.setBackgroundColor(Qt::green);
    QCoreApplication::sendEvent(&tag, &event);

    tag.setTagStyle(TagStyle::GrayTag);
    tag.setBackgroundColor(Qt::green);
    QCoreApplication::sendEvent(&tag, &event);

    tag.setTagStyle(TagStyle::IconTag);
    tag.setBackgroundColor(Qt::green);
    QCoreApplication::sendEvent(&tag, &event);

    KTag tag1;
    tag1.setEnabled(false);
    QCoreApplication::sendEvent(&tag1, &event);

    tag1.setEnabled(true);
    QCoreApplication::sendEvent(&tag1, &event);

    tag1.setBackgroundColor(Qt::green);
    QCoreApplication::sendEvent(&tag1, &event);

    tag1.setTranslucent(true);
    QCoreApplication::sendEvent(&tag1, &event);

    tag1.setClosable(true);
    tag1.setText("tag1");
    tag1.setIcon(QIcon::fromTheme("kylin-music"));
    QCoreApplication::sendEvent(&tag1, &event);

    tag1.setFixedWidth(20);
    QCoreApplication::sendEvent(&tag1, &event);

    tag1.setClosable(false);
    QCoreApplication::sendEvent(&tag1, &event);

    tag1.setFixedWidth(200);
    QCoreApplication::sendEvent(&tag1, &event);
}

void MainTest::texteditTest()
{
    KTextEdit edit;
    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&edit, &event);

    edit.setLabelVisible(true);
    edit.setReadOnly(false);

    QPixmap pixmap = QIcon::fromTheme("kylin-music").pixmap(16, 16);
    edit.setPixmap(pixmap);
    edit.pixmap();
    //    QCOMPARE(edit.pixmap(),pixmap);
    QCoreApplication::sendEvent(&edit, &event);

    edit.setLabelText("text");
    edit.setReadOnly(true);
    edit.setLabelVisible(false);

    QCoreApplication::sendEvent(&edit, &event);
}

void MainTest::titlewindowTest()
{
    KTitleWindow window;
    window.addButton();
    window.colorButton();
    window.menuButton();
    window.baseWidget();
    window.setTitleColor(Qt::red);
    window.resize(500, 400);

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&window, &event);

    window.setFocus();
    QCoreApplication::sendEvent(&window, &event);

    window.activateWindow();
    QCoreApplication::sendEvent(&window, &event);

    window.setFocus();
    QCoreApplication::sendEvent(&window, &event);

    QWidget widget2;
    widget2.installEventFilter(&window);

    QEvent event2(QEvent::Paint);
    QCoreApplication::sendEvent(&widget2, &event2);
}

void MainTest::toolbuttonTest()
{
    KToolButton btn(nullptr);
    QEvent btnEvent(QEvent::Paint);
    QCoreApplication::sendEvent(&btn, &btnEvent);

    btn.setType(KToolButtonType::Flat);
    QCOMPARE(btn.type(), KToolButtonType::Flat);
    QCoreApplication::sendEvent(&btn, &btnEvent);

    QIcon icon(QIcon::fromTheme("kylin-music"));
    btn.setIcon(icon);
    QCOMPARE(btn.icon(), icon);
    QCoreApplication::sendEvent(&btn, &btnEvent);

    btn.setLoading(true);
    QCOMPARE(btn.isLoading(), true);
    QCoreApplication::sendEvent(&btn, &btnEvent);

    btn.setArrow(true);
    //    QCOMPARE(btn.hasArrow(),true);
    btn.hasArrow();
    QCoreApplication::sendEvent(&btn, &btnEvent);

    btn.setIconColor(true, Qt::green);
    QCoreApplication::sendEvent(&btn, &btnEvent);

    QTest::mouseClick(&btn, Qt::LeftButton, Qt::NoModifier, QPoint(btn.rect().center()));

    btn.setType(KToolButtonType::SemiFlat);
    QCoreApplication::sendEvent(&btn, &btnEvent);

    btn.setType(KToolButtonType::Background);
    QCoreApplication::sendEvent(&btn, &btnEvent);

    btn.setFocus();
    btn.setArrow(false);
    QCoreApplication::sendEvent(&btn, &btnEvent);

    QEvent event2(QEvent::MouseButtonPress);
    QCoreApplication::sendEvent(&btn, &event2);

    QEvent event3(QEvent::Enter);
    QCoreApplication::sendEvent(&btn, &event3);

    QEvent event4(QEvent::FocusIn);
    QCoreApplication::sendEvent(&btn, &event4);

    QEvent event5(QEvent::EnabledChange);
    QCoreApplication::sendEvent(&btn, &event5);

    QEvent event6(QEvent::MouseButtonRelease);
    QCoreApplication::sendEvent(&btn, &event6);

    QEvent event7(QEvent::Leave);
    QCoreApplication::sendEvent(&btn, &event7);

    QEvent event8(QEvent::FocusOut);
    QCoreApplication::sendEvent(&btn, &event8);
}

void MainTest::translucentfloorTest()
{
    KTranslucentFloor floor;
    floor.setBorderRadius(8);
    QCOMPARE(floor.borderRadius(), 8);

    floor.setShadow(true);
    QCOMPARE(floor.shadow(), true);

    floor.setEnableBlur(true);
    QCOMPARE(floor.enableBlur(), true);

    floor.setOpacity(0.5);
    QCOMPARE(floor.opacity(), 0.5);

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&floor, &event);
}

void MainTest::uninstalldialogTest()
{
    KUninstallDialog dialog("name", "1.0");
    dialog.debAppNameLabel();
    dialog.debNameLabel();
    dialog.debIconLabel();
    dialog.debVersionLabel();
    dialog.uninstallButtton();
}

void MainTest::widgetTest()
{
    KWidget widget;
    widget.setIcon(QIcon::fromTheme("kylin-music"));
    widget.setIcon("kylin-music");
    widget.setWidgetName("name");
    widget.sideBar();
    widget.baseBar();
    widget.windowButtonBar();
    widget.iconBar();
    widget.setLayoutType(LayoutType::HorizontalType);
    widget.setWindowFlag(Qt::Window, true);
    widget.setWindowFlags(Qt::Widget);
    widget.setSidebarFollowMode(true);
    QCOMPARE(widget.sidebarFollowMode(), true);

    widget.setLayoutType(LayoutType::VerticalType);
    widget.setLayoutType(LayoutType::MixedType);

    widget.setWindowFlags(Qt::Drawer);
    widget.setWindowFlags(Qt::Tool);
    widget.setWindowFlags(Qt::ToolTip);
    widget.setWindowFlags(Qt::SplashScreen);
    widget.setWindowFlags(Qt::Dialog);
    widget.setWindowFlags(Qt::Sheet);
    widget.setWindowFlags(Qt::Popup);
    widget.setWindowFlags(Qt::Desktop);

    widget.setWindowFlag(Qt::Drawer, true);
    widget.setWindowFlag(Qt::Tool, true);
    widget.setWindowFlag(Qt::ToolTip, true);
    widget.setWindowFlag(Qt::SplashScreen, true);
    widget.setWindowFlag(Qt::Dialog, true);
    widget.setWindowFlag(Qt::Sheet, true);
    widget.setWindowFlag(Qt::Popup, true);
    widget.setWindowFlag(Qt::Desktop, true);
    widget.setWindowFlag(Qt::ForeignWindow, true);
    widget.setWindowFlag(Qt::CoverWindow, true);

    QWidget widget2;
    widget2.installEventFilter(&widget);

    QEvent event2(QEvent::WindowStateChange);
    QCoreApplication::sendEvent(&widget2, &event2);

    QEvent event3(QEvent::FocusIn);
    QCoreApplication::sendEvent(&widget2, &event3);

    QEvent event4(QEvent::Hide);
    QCoreApplication::sendEvent(&widget2, &event4);
}

void MainTest::windowbuttonbarTest()
{
    KWindowButtonBar bar;
    bar.minimumButton();
    bar.maximumButton();
    bar.closeButton();
    bar.menuButton();
    bar.setMaximumButtonState(MaximumButtonState::Maximum);
    QCOMPARE(bar.maximumButtonState(), MaximumButtonState::Maximum);

    bar.setFollowMode(false);
    QCOMPARE(bar.followMode(), false);

    QTest::mouseClick(bar.closeButton(), Qt::LeftButton, Qt::NoModifier);
    QTest::mouseDClick(&bar, Qt::LeftButton, Qt::NoModifier);

    QWidget widget2;
    widget2.installEventFilter(&bar);

    QEvent event2(QEvent::MouseButtonPress);
    QCoreApplication::sendEvent(&widget2, &event2);

    QEvent event3(QEvent::Enter);
    QCoreApplication::sendEvent(&widget2, &event3);

    QEvent event4(QEvent::MouseButtonRelease);
    QCoreApplication::sendEvent(&widget2, &event4);

    QEvent event5(QEvent::Leave);
    QCoreApplication::sendEvent(&widget2, &event5);
}

void MainTest::parmscontrollerTest()
{
    Parmscontroller::self()->isTabletMode();
    Parmscontroller::self()->parm(Parmscontroller::Parm::PM_PushButtonHeight);
}

void MainTest::themecontrollerTest()
{
    ThemeController theme;
    theme.drawSymbolicColoredPixmap(QIcon::fromTheme("system-computer.symbolic").pixmap(16, 16));
    theme.getCurrentIconColor();
    theme.iconTheme();
    theme.drawFashionBackground(QRect(0, 0, 36, 36), 36, 36, 6, true);
    theme.drawFashionBackground(QRect(0, 0, 36, 36), 36, 36, 6, false);

    theme.drawColoredPixmap(QIcon::fromTheme("kylin-music").pixmap(16, 16), Qt::red);
    theme.overlayIcons(QIcon::fromTheme("kylin-music"), QIcon::fromTheme("kylin-video"), 8, 8);
    theme.overlayIcons(QIcon::fromTheme("kylin-music").pixmap(16, 16), QIcon::fromTheme("kylin-video").pixmap(16, 16), 8, 8);
    theme.lanhuHSLToQtHsl(152, 86, 43);
    QColor fontColor(155, 155, 155);
    fontColor = ThemeController::adjustH(fontColor, 2);
    fontColor = ThemeController::adjustS(fontColor, -30);
    fontColor = ThemeController::adjustL(fontColor, -40);
    fontColor = ThemeController::adjustA(fontColor, 40);

    theme.highlightClick(false, qApp->palette());
    theme.highlightClick(true, qApp->palette());
    theme.highlightHover(false, qApp->palette());
    theme.highlightHover(true, qApp->palette());
    theme.buttonDarkClick(false, qApp->palette());
    theme.buttonDarkClick(true, qApp->palette());
}

// void MainTest::xatomhelperTest()
//{
//     XAtomHelper* helper = XAtomHelper::getInstance();
//     QWidget widget;

//    helper->isFrameLessWindow(widget.winId());
//    helper->isWindowDecorateBorderOnly(widget.winId());
//    MotifWmHints hints;
//    hints.flags = MWM_HINTS_FUNCTIONS|MWM_HINTS_DECORATIONS;
//    hints.functions = MWM_FUNC_ALL;
//    hints.decorations = MWM_DECOR_BORDER;
//    helper->isWindowMotifHintDecorateBorderOnly(hints);
//    helper->isUKUIDecorationWindow(widget.winId());
//    helper->getWindowBorderRadius(widget.winId());
//    UnityCorners corners;
//    corners.topLeft = 8;
//    corners.topRight = 8;
//    corners.bottomLeft = 8;
//    corners.bottomRight = 8;
//    helper->setWindowBorderRadius(widget.winId(),corners);
//    helper->setWindowBorderRadius(widget.winId(),8,8,8,8);
//    helper->setUKUIDecoraiontHint(widget.winId(),true);
//    helper->setUKUIDecoraiontHint(widget.winId(),false);
//    helper->setWindowMotifHint(widget.winId(),hints);
//    helper->getWindowMotifHint(widget.winId());
//    helper->isUKUICsdSupported();
//}

void MainTest::dirtabbarTest()
{
    KDirTabBar bar;
    bar.setCurrentPath(QDir::currentPath());
    bar.currentPath();
    bar.setVisibleDepth(3);
    bar.visibleDepth();
    //    bar.setIcon(0,QIcon::fromTheme("kylin-music"));
    //    bar.icon(0);
    //    bar.setRootPath(QDir::currentPath());
    //    bar.RootPath();
    bar.setTextLength(10);
    bar.textLength();

    QLabel *label = new QLabel();
    QString path = QDir::currentPath();
    QFileInfo fileInfo(path);
    QList<QToolButton *> btns;

    bar.setCurrentPath(fileInfo.absoluteFilePath());
    label->setText(bar.currentPath());
    btns = bar.buttons();
    btns[btns.count() - 1]->setIcon(QIcon()); // 设置按钮的图标
    btns[btns.count() - 2]->setEnabled(false); // 设置按钮是否可用
    bar.setIcon(btns.count() - 2, QIcon::fromTheme("folder-pictures")); // 设置按钮的图标
}

void MainTest::texteditorTest()
{
    KTextEditor editor;

    editor.textEdit();

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&editor, &event);

    QEvent event1(QEvent::FocusIn);
    QCoreApplication::sendEvent(&editor, &event1);

    QEvent event2(QEvent::FocusOut);
    QCoreApplication::sendEvent(&editor, &event2);
}

void MainTest::toolbarTest()
{
    KToolBar bar;
    bar.setOrientation(Qt::Horizontal);
    bar.orientation();
    bar.addButton(QIcon::fromTheme("kylin-music"));
    bar.addButton("button");
    QList<QIcon> iconList;
    iconList.append(QIcon::fromTheme("kylin-video"));
    bar.addButton(iconList);

    QList<QString> stringList;
    stringList.append("kylin-video");
    bar.addButton(stringList);
    QList<KToolButton *> buttonList = bar.buttonList();
    bar.removeButton(buttonList.at(0));
    bar.removeButton(0);
    bar.removeButton(buttonList.at(0));

    bar.addButton(QIcon::fromTheme("kylin-music"));
    bar.addButton("button");
    bar.addButton(iconList);
    bar.addButton(stringList);

    bar.setBorderRadius(8);
    bar.borderRadius();
    bar.setExclusive(true);
    bar.setExclusive(false);
    bar.exclusive();
    bar.setCheckable(true);
    bar.setCheckable(false);
    bar.isCheckable();
    bar.checkedButton();
    bar.setLineVisible(false);
    bar.setLineVisible(true);
    bar.isLineVisible();
    bar.setBackgroundColorEnabled(false);
    bar.setBackgroundColorEnabled(true);
    bar.backgroundColorEnabled();

    QEvent event(QEvent::Paint);
    QCoreApplication::sendEvent(&bar, &event);
}

QTEST_MAIN(MainTest)
#include "qtwidgetstest.moc"
