/* ----- core/mult3sntrup653, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_mult3sntrup653_checksums[] = {
  "6c633f57506622093b66449977dda48d3736b0f20eb6f78104f010d8b94c5e51",
  "2262cd945501dd3967456d24154cd50599be6620378821a6b96ffa95fd8b47ff",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_mult3sntrup653_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_mult3sntrup653_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_mult3sntrup653_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_mult3sntrup653_CONSTBYTES

static void *storage_core_mult3sntrup653_h;
static unsigned char *test_core_mult3sntrup653_h;
static void *storage_core_mult3sntrup653_n;
static unsigned char *test_core_mult3sntrup653_n;
static void *storage_core_mult3sntrup653_k;
static unsigned char *test_core_mult3sntrup653_k;
static void *storage_core_mult3sntrup653_c;
static unsigned char *test_core_mult3sntrup653_c;
static void *storage_core_mult3sntrup653_h2;
static unsigned char *test_core_mult3sntrup653_h2;
static void *storage_core_mult3sntrup653_n2;
static unsigned char *test_core_mult3sntrup653_n2;
static void *storage_core_mult3sntrup653_k2;
static unsigned char *test_core_mult3sntrup653_k2;
static void *storage_core_mult3sntrup653_c2;
static unsigned char *test_core_mult3sntrup653_c2;

#define precomputed_core_mult3sntrup653_NUM 4

static const unsigned char precomputed_core_mult3sntrup653_h[precomputed_core_mult3sntrup653_NUM][crypto_core_OUTPUTBYTES] = {
  {255,0,255,0,0,1,0,0,0,255,1,0,255,1,255,1,1,255,0,1,255,1,0,0,0,255,1,1,255,1,0,0,1,0,1,0,0,1,0,1,0,255,255,255,255,255,0,0,0,1,0,0,0,0,0,0,0,1,0,1,0,1,0,1,0,0,255,255,255,1,0,255,255,1,0,255,255,255,0,1,255,0,255,255,0,0,1,1,255,0,255,255,0,0,255,255,255,0,0,1,255,255,0,1,0,0,255,0,1,1,255,255,0,1,255,1,1,255,0,255,1,255,255,0,255,0,0,0,0,1,1,0,0,1,1,0,255,255,1,255,0,1,255,0,0,255,1,1,0,255,0,0,255,1,1,0,0,0,0,0,0,0,255,1,1,255,1,255,0,1,1,0,255,0,1,1,255,0,255,1,255,0,0,0,0,255,1,255,1,0,255,255,1,255,255,0,1,0,0,1,1,1,0,255,0,1,255,255,0,0,255,1,0,1,1,255,255,1,0,255,0,255,0,1,255,0,255,1,1,0,1,255,255,1,1,1,255,255,1,1,1,1,0,255,0,0,0,255,0,1,1,255,255,255,255,0,0,255,1,1,0,0,1,255,255,255,0,0,255,0,1,0,0,255,255,0,1,0,0,1,1,1,255,1,0,0,1,1,1,255,1,0,0,0,1,255,0,255,255,0,0,255,255,255,255,1,1,255,255,0,1,0,0,255,0,255,0,1,1,1,255,1,1,0,255,0,0,0,255,0,0,1,255,255,1,255,0,255,1,1,255,255,0,255,255,255,255,255,0,1,255,255,255,0,0,255,255,1,255,255,1,0,255,1,255,1,0,1,1,0,255,255,1,1,0,0,255,255,0,1,255,0,1,255,0,0,0,1,1,1,0,1,255,0,0,1,255,0,255,0,0,1,0,0,255,1,255,0,1,0,255,1,1,255,255,0,0,255,0,1,0,255,255,255,0,255,1,0,1,0,0,0,0,1,1,1,255,1,255,255,1,255,1,255,1,0,0,255,0,0,255,255,1,1,0,255,255,0,255,0,0,0,255,0,1,0,0,1,255,0,0,1,1,1,1,1,1,255,255,255,1,1,255,0,255,255,255,0,255,0,1,0,1,1,0,0,0,1,1,0,1,255,255,255,0,255,0,1,255,255,255,1,0,1,0,1,255,255,1,0,255,0,255,1,255,1,0,255,0,255,0,0,1,0,0,1,255,1,255,0,0,255,0,0,0,1,1,0,1,0,255,255,0,1,0,1,0,0,0,0,1,255,0,255,0,0,1,0,255,255,0,0,1,0,1,0,255,1,255,0,0,0,255,1,1,1,1,1,255,0,0,255,255,0,0,1,255,255,1,255,1,0,255,0,255,0,0,1,0,1,1,0,0,0,0,255,0,0,0,0,1,255,255,255,1,255,255,255,255,255,1,0,1,0,0,0,0,255,255,1,0,0,1,255,1,255,255,1,0,0,0,1,255},
  {0,0,1,1,255,0,255,255,1,255,1,0,0,255,255,0,0,1,0,255,255,0,1,1,255,0,1,0,255,0,255,0,255,255,0,255,1,255,0,1,0,255,0,0,1,0,0,255,1,255,255,1,1,1,1,1,0,0,255,0,0,0,0,1,0,1,1,255,0,1,255,1,255,255,0,0,1,1,0,1,1,0,1,1,1,1,0,255,0,1,0,0,255,255,255,1,0,1,1,0,0,0,0,0,1,0,1,1,0,1,1,255,255,0,1,1,0,0,0,255,1,1,255,0,1,1,0,1,1,1,0,0,255,0,0,0,255,1,255,255,1,0,255,1,255,1,1,255,1,1,0,255,255,255,0,0,0,0,255,255,255,1,255,1,1,0,1,1,255,0,255,0,1,1,255,0,0,1,0,255,255,0,255,1,0,255,255,0,255,255,0,0,0,255,255,255,1,255,255,0,0,0,1,0,1,0,0,1,0,255,0,0,0,0,0,255,1,0,255,1,0,255,0,255,0,255,1,0,0,1,0,1,255,255,0,1,1,1,1,1,255,0,0,1,255,255,0,255,1,255,255,255,255,1,0,255,1,1,255,255,1,255,0,1,0,0,1,255,255,1,0,0,0,1,255,255,0,1,0,255,0,1,0,1,1,1,0,255,255,1,1,1,0,0,255,255,1,1,0,1,1,1,1,0,255,0,0,0,255,1,255,0,1,1,0,255,1,0,0,0,0,1,1,255,0,0,255,0,1,0,255,1,1,1,255,1,0,0,255,255,0,0,1,0,0,0,0,1,255,0,0,0,255,255,0,0,0,255,1,255,0,1,1,255,255,1,0,255,255,0,255,1,1,0,255,0,0,1,1,0,1,1,0,1,255,255,1,255,255,0,0,255,0,0,1,1,255,255,1,0,0,1,255,0,0,0,255,255,0,1,1,255,0,1,0,255,1,0,255,255,0,0,255,0,255,0,255,255,0,0,255,0,1,1,1,1,1,255,255,255,1,0,1,1,0,0,0,0,255,0,0,1,1,255,0,1,255,255,255,1,1,1,1,1,1,255,0,0,1,1,255,0,0,0,255,1,1,0,255,0,0,255,0,0,0,255,0,1,255,1,255,255,0,0,255,255,1,1,255,0,0,255,255,255,0,0,255,0,0,1,1,1,1,0,255,0,0,255,1,0,255,1,0,0,0,0,255,255,1,1,0,0,0,255,1,0,0,255,0,0,0,1,0,255,255,1,1,255,0,1,0,1,0,255,0,0,1,0,0,0,1,255,255,255,1,255,255,1,0,0,0,255,0,255,255,255,255,255,0,1,1,255,1,0,255,0,0,0,0,0,0,0,0,255,255,0,255,1,255,0,255,255,1,0,1,0,0,1,255,0,1,255,255,1,0,255,1,255,0,1,1,255,1,0,0,0,0,0,0,1,1,0,255,1,255,0,255,0,0,255,1,1,255,255,1,255,1,255,255,255,255,1,0},
  {255,255,0,1,1,255,1,1,1,255,1,255,0,1,0,1,0,0,1,0,255,0,1,1,255,0,255,1,0,255,255,0,1,255,0,0,0,1,255,1,0,1,0,255,255,255,255,255,0,1,255,0,255,255,255,0,255,0,0,255,0,1,0,1,0,1,1,255,1,0,0,0,0,0,0,1,255,0,1,1,255,1,0,0,1,0,1,255,255,255,255,0,0,0,0,1,255,255,0,0,1,1,1,255,255,0,1,0,1,1,0,255,0,1,0,1,1,0,0,255,1,255,0,0,0,255,255,0,0,1,255,1,0,0,255,255,1,1,1,1,255,255,0,255,1,255,0,1,255,0,255,1,1,1,0,0,1,0,255,255,0,255,255,255,0,255,0,0,255,0,255,0,1,0,0,0,255,0,0,0,0,0,255,1,255,1,0,1,255,0,255,0,0,0,0,255,255,0,255,0,255,0,255,255,1,255,1,255,255,0,255,0,255,255,0,0,255,1,1,0,255,1,1,1,255,0,255,0,1,255,0,1,0,1,1,255,255,1,255,255,1,1,0,255,1,1,255,1,1,0,1,255,0,1,255,255,0,255,1,255,0,1,255,255,0,1,255,0,255,0,0,0,0,1,1,0,0,0,255,1,255,1,255,0,1,1,0,1,0,0,255,255,0,0,255,1,1,255,1,0,0,255,0,255,0,255,0,0,255,255,255,0,1,255,1,0,1,1,255,0,255,0,0,0,255,0,1,0,1,1,1,255,1,255,1,1,0,1,255,255,1,1,255,1,0,0,255,0,1,0,255,0,1,255,255,0,0,255,0,255,0,1,255,0,255,1,0,1,1,255,255,0,255,1,0,0,255,0,1,1,1,0,1,0,0,255,0,255,0,1,1,1,0,1,0,255,1,255,255,0,255,0,0,1,1,255,1,0,0,0,1,1,255,0,1,0,0,255,1,0,1,255,255,255,255,1,0,255,1,1,255,0,0,0,1,0,0,255,1,255,1,1,0,1,1,0,255,1,255,255,0,0,255,255,0,255,0,0,255,255,0,1,0,1,0,255,255,1,1,1,1,0,0,1,0,1,255,255,1,255,255,1,255,1,1,0,0,0,1,0,1,0,0,1,1,0,0,1,1,1,1,1,255,255,255,1,1,255,0,1,255,255,1,0,0,0,255,0,255,0,0,1,1,255,1,0,255,255,1,255,0,0,1,1,255,1,1,255,1,0,255,0,0,0,1,0,0,0,1,1,1,1,1,255,1,1,1,1,0,0,1,0,0,0,0,255,0,1,1,1,1,255,255,1,1,255,1,255,255,1,0,1,1,0,0,0,0,255,0,1,0,0,255,0,255,1,1,0,0,1,0,0,0,1,0,255,255,0,1,1,1,0,0,0,1,255,255,0,1,255,1,0,1,0,255,1,1,255,0,1,1,1,255,0,255,0,1,1,0,0,1,0,255,0,255,1,255,255,1,0,1,0,0},
  {255,0,0,255,1,1,255,1,1,1,255,255,255,255,1,1,1,0,1,0,1,0,0,255,0,1,1,1,255,1,1,0,1,255,255,1,255,1,1,0,255,255,255,1,255,255,255,255,1,0,1,0,1,1,1,255,1,0,0,1,0,0,1,255,1,1,0,255,255,0,1,0,0,0,255,1,1,0,0,0,1,0,0,0,255,0,0,255,255,255,255,255,1,0,255,255,0,255,1,1,1,0,255,1,255,255,1,0,255,1,1,255,0,255,1,0,255,255,255,255,255,0,1,1,0,255,0,0,255,1,0,1,255,255,1,255,255,0,255,255,255,255,0,0,1,255,255,1,1,255,255,0,0,255,255,0,0,1,1,0,1,255,0,255,0,0,1,1,0,1,1,255,1,255,0,255,255,255,1,1,1,255,255,0,1,255,1,0,1,1,1,0,1,255,255,0,255,255,0,1,1,0,1,255,255,1,255,0,1,1,0,1,1,255,255,1,255,0,0,1,0,255,255,255,0,1,1,1,1,255,0,0,1,255,255,1,0,0,1,1,1,0,1,1,0,255,1,255,0,1,0,0,1,255,255,0,1,1,255,255,0,255,0,255,1,255,1,255,1,0,255,0,1,0,255,1,0,0,1,1,1,255,1,1,0,255,255,1,255,1,0,0,1,0,0,1,0,0,0,255,0,0,0,1,0,255,1,1,1,0,1,0,1,255,1,255,0,1,255,0,255,0,1,1,255,255,1,255,1,1,255,1,1,0,1,255,1,0,255,1,255,255,1,1,1,255,255,0,255,0,1,1,1,1,1,1,1,1,0,0,255,1,0,255,0,255,255,255,1,255,0,255,1,0,0,1,0,0,1,1,0,0,0,0,0,255,1,1,255,0,0,0,0,255,255,255,1,1,1,255,0,255,1,255,255,0,0,1,0,0,1,255,0,255,255,255,255,255,1,1,255,0,0,255,1,255,255,0,1,255,0,255,255,0,0,255,255,1,0,0,1,255,1,0,1,255,255,0,255,255,1,255,1,1,255,0,255,255,255,1,0,1,255,1,1,255,0,255,0,255,1,1,0,0,1,0,1,1,255,1,255,0,255,255,1,0,255,0,1,1,0,0,0,255,1,1,0,0,0,255,1,1,255,255,255,1,255,0,255,1,255,1,0,0,1,1,255,255,255,1,1,255,0,255,255,1,255,255,255,255,1,0,1,255,0,255,1,1,1,255,0,0,1,1,255,0,1,1,255,255,255,0,255,1,255,1,1,0,255,1,0,1,255,255,255,255,0,0,0,255,0,1,0,255,0,0,0,255,0,0,0,0,0,0,255,255,255,255,1,1,255,255,1,1,0,1,1,0,1,255,0,255,255,255,255,255,255,1,0,1,1,255,0,1,1,1,1,1,255,1,0,1,255,255,1,255,255,0,255,1,1,255,0,255,255,1,0,0,1,1,0,0,1,1,255,255,255,1,1,1,0,1,0},
} ;

static const unsigned char precomputed_core_mult3sntrup653_n[precomputed_core_mult3sntrup653_NUM][crypto_core_INPUTBYTES] = {
  {0,1,0,0,1,0,1,1,0,0,-1,1,1,0,-1,0,0,0,0,0,-1,1,1,1,-1,-1,0,0,1,-1,0,0,0,0,1,0,1,1,0,1,0,0,0,-1,1,0,0,0,-1,-1,0,0,1,-1,0,-1,0,0,-1,1,0,0,0,-1,0,-1,-1,-1,0,0,-1,1,1,0,-1,0,1,1,0,0,0,0,1,0,1,0,0,0,-1,-1,1,0,0,-1,1,0,0,-1,-1,1,0,1,0,-1,-1,0,0,0,1,0,0,-1,1,1,1,0,-1,1,-1,0,0,0,0,1,-1,-1,0,-1,-1,0,0,1,0,0,-1,-1,-1,0,0,-1,1,0,0,0,0,1,0,-1,0,0,-1,-1,0,-1,0,0,0,1,1,0,1,0,0,1,-1,1,1,1,0,-1,-1,-1,0,0,0,0,0,0,0,0,0,1,-1,0,-1,0,0,0,0,0,0,0,0,0,-1,0,0,0,-1,0,1,-1,1,0,1,0,0,-1,-1,0,1,1,0,-1,-1,0,-1,1,-1,0,1,0,1,0,1,0,1,0,0,-1,0,1,0,-1,-1,1,1,-1,1,0,0,0,1,0,0,-1,0,0,0,0,0,0,0,1,-1,-1,0,1,0,0,-1,0,0,-1,-1,1,-1,1,-1,1,1,0,1,0,0,-1,0,0,0,1,1,1,0,1,1,0,-1,0,0,1,1,0,-1,0,1,1,0,1,0,0,1,1,0,1,1,0,0,-1,-1,1,1,-1,0,0,0,-1,0,0,0,-1,0,0,0,0,-1,0,-1,1,-1,0,-1,0,1,0,-1,1,0,0,-1,1,-1,1,0,-1,0,0,1,0,0,0,0,0,-1,0,0,1,0,0,1,0,-1,-1,1,0,0,-1,-1,-1,-1,-1,-1,1,0,0,0,0,1,-1,0,1,1,0,0,0,-1,-1,0,0,1,0,1,-1,-1,0,1,1,0,0,0,-1,-1,0,0,1,1,1,0,0,1,-1,-1,0,0,0,1,0,-1,-1,0,-1,0,1,0,-1,1,0,1,1,1,0,0,0,0,1,0,-1,0,1,0,1,0,-1,1,1,0,1,0,-1,-1,-1,0,-1,1,1,0,-1,0,0,1,-1,0,0,1,1,0,1,0,0,0,0,1,0,1,-1,0,1,-1,-1,0,0,1,-1,0,0,0,0,1,0,0,0,0,0,-1,0,0,-1,-1,-1,1,0,0,-1,-1,0,-1,-1,-1,0,-1,1,-1,0,0,-1,1,-1,-1,-1,-1,1,0,0,1,0,0,1,0,-1,0,0,0,0,0,-1,1,0,0,0,0,-1,-1,-1,0,1,-1,1,-1,-1,-1,-1,1,0,-1,0,-1,0,1,-1,0,-1,0,0,1,1,0,-1,0,-1,1,0,1,1,1,0,0,0,0,0,1,1,0,0,0,0,-1,0,1,1,0,-1,-1,0,0,0,1,0,-1,0,0,0,0,0,0,-1,0,0,1,1,1,1,0,1,1,-1,0,0,-1,0,0,-1,0,1,0,0,0,1,0,0,0,1,-1,0,1,-1,1,0,0,0,0,0,-1,1,0,-1,-1,-1,0,0,0,0,-1,0,0},
  {0,0,-1,0,0,1,-1,0,0,1,1,-1,0,0,0,0,-1,0,0,0,-1,0,1,1,1,0,1,-1,-1,-1,-1,0,1,1,1,1,-1,0,1,1,-1,0,-1,1,0,0,-1,-1,-1,0,1,-1,0,0,0,0,1,1,0,1,1,0,-1,-1,1,-1,1,0,-1,0,1,-1,0,1,1,0,0,-1,1,1,0,-1,-1,0,1,0,0,1,1,-1,0,1,-1,0,-1,1,-1,0,1,1,-1,1,1,0,1,1,-1,1,-1,0,1,1,0,1,-1,-1,-1,0,-1,0,0,-1,-1,0,1,0,-1,0,1,0,0,0,1,-1,0,1,0,-1,0,-1,0,0,1,0,-1,0,1,1,1,1,1,0,1,1,0,0,0,-1,0,1,0,0,0,1,0,0,0,0,-1,0,0,-1,0,0,-1,0,-1,0,1,0,0,-1,1,-1,0,0,0,0,1,-1,-1,0,0,0,0,0,-1,1,-1,-1,0,-1,1,1,0,-1,-1,-1,0,1,-1,0,0,-1,0,0,-1,0,1,0,0,0,1,0,0,1,-1,0,0,1,0,-1,0,0,0,1,0,0,1,0,0,-1,1,0,0,1,-1,0,0,1,0,1,0,-1,1,0,0,-1,1,1,0,-1,0,0,1,1,0,0,1,0,0,-1,0,1,-1,-1,0,0,1,1,1,1,-1,-1,0,0,-1,0,0,0,0,1,0,0,-1,0,0,-1,0,0,0,0,1,1,0,0,1,1,0,1,0,-1,0,1,0,1,0,1,0,0,-1,1,0,-1,0,1,-1,0,-1,-1,-1,1,0,1,0,0,1,-1,0,0,1,-1,0,-1,-1,1,-1,0,-1,0,0,0,0,0,0,0,1,0,1,0,-1,0,1,0,1,1,0,1,-1,0,1,1,0,1,1,-1,0,0,0,0,1,1,0,0,1,1,-1,0,0,0,0,0,0,0,-1,0,-1,1,1,0,0,-1,0,0,0,0,1,1,0,1,-1,1,-1,-1,0,0,0,0,-1,0,0,0,-1,0,0,1,-1,-1,0,1,0,1,0,0,-1,-1,-1,1,1,-1,-1,0,1,0,-1,0,0,-1,0,0,1,1,0,1,1,0,0,-1,0,-1,0,-1,0,1,1,0,-1,0,-1,0,1,0,-1,1,0,0,0,0,0,0,0,-1,1,-1,0,1,-1,-1,0,1,-1,0,0,1,0,0,0,1,0,1,0,-1,-1,0,-1,-1,0,1,0,0,-1,0,0,0,-1,1,0,0,0,1,1,0,0,1,-1,0,0,0,0,-1,-1,1,1,1,1,-1,0,-1,1,1,1,0,0,1,-1,1,1,0,0,0,0,-1,1,1,1,-1,0,0,0,0,1,-1,0,0,0,0,0,0,0,0,-1,0,0,-1,1,1,1,-1,0,0,0,0,0,0,0,1,1,0,0,0,-1,0,0,1,0,0,1,1,0,0,1,1,0,0,1,0,-1,0,0,-1,1,0,-1,0,-1,-1,1,1,0,0,0,0,1,-1,0,0,0,0,0,0,1,0,0,0,1,1,0,1,0,0,-1,0,1,0,-1,0,0,0,0,0,-1,1,0},
  {-1,1,0,0,0,0,1,1,1,1,1,1,1,-1,1,-1,1,0,0,0,-1,-1,1,0,0,-1,0,1,1,0,0,0,1,0,0,0,-1,0,1,1,-1,-1,0,1,-1,0,1,0,0,0,0,1,-1,1,0,0,0,1,1,0,-1,1,-1,0,-1,0,-1,0,0,0,-1,1,0,0,0,0,0,1,1,1,-1,-1,-1,-1,-1,0,1,0,1,0,1,0,-1,-1,-1,0,-1,0,1,-1,0,0,0,1,-1,0,-1,1,0,-1,1,0,0,0,0,0,0,-1,0,0,-1,0,0,0,1,0,0,0,1,1,1,0,1,1,-1,-1,0,-1,-1,-1,0,1,0,1,0,0,1,0,0,-1,0,0,0,0,1,1,0,0,1,-1,0,-1,1,0,-1,0,0,0,0,1,0,-1,0,0,-1,0,0,1,1,0,-1,1,0,0,0,0,0,-1,0,1,-1,0,0,0,1,0,-1,-1,0,0,0,1,-1,0,-1,0,-1,-1,-1,0,0,1,0,0,0,1,1,1,0,-1,-1,1,1,0,0,1,-1,-1,1,0,0,0,0,-1,-1,0,0,1,1,0,1,0,1,0,0,1,0,1,1,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,-1,1,1,0,0,0,1,0,0,0,-1,-1,0,-1,0,1,1,0,0,0,0,0,1,0,-1,1,1,0,-1,-1,1,0,0,-1,0,0,-1,1,0,-1,-1,0,0,0,1,1,0,1,0,-1,0,1,-1,0,0,0,0,-1,-1,-1,0,1,0,0,-1,-1,0,1,0,-1,-1,0,-1,0,-1,-1,0,0,0,-1,-1,1,1,1,0,1,0,-1,-1,0,0,0,1,0,1,0,1,1,0,0,0,-1,0,1,-1,-1,0,0,-1,0,0,0,0,-1,-1,0,-1,-1,0,0,-1,0,1,-1,1,0,1,0,-1,-1,1,1,0,1,1,-1,1,1,-1,0,0,1,1,-1,0,-1,0,0,1,0,0,-1,0,-1,-1,0,1,-1,0,0,0,-1,-1,0,1,-1,0,1,1,1,0,1,1,-1,0,0,1,1,-1,1,0,0,1,-1,0,1,0,1,0,0,0,0,0,-1,-1,-1,0,0,0,-1,0,0,0,1,0,0,0,0,1,1,-1,0,-1,0,1,1,0,0,-1,1,0,0,0,0,0,0,0,0,-1,0,0,-1,-1,1,1,0,0,1,0,0,1,1,1,-1,1,0,0,1,0,0,-1,1,-1,0,0,0,0,-1,0,1,-1,0,1,-1,1,0,0,1,1,0,0,-1,1,-1,0,-1,0,0,1,-1,0,1,-1,1,0,1,0,0,1,0,0,0,0,0,-1,0,0,1,1,1,0,-1,0,-1,0,1,0,1,-1,0,0,0,0,1,-1,0,-1,1,0,0,-1,1,0,1,-1,0,0,0,0,0,0,0,0,0,1,1,0,1,-1,-1,1,-1,0,-1,1,0,0,-1,-1,0,0,-1,1,0,-1,-1,0,-1,-1,1,-1,0,0,0,0,1,1,-1,-1,1,0,-1,0,0,0,0,0,0,0,1,0,0,0,1,1,0,0,-1,-1},
  {0,0,1,1,0,-1,0,-1,-1,-1,1,0,0,-1,0,-1,0,1,1,0,-1,-1,1,0,0,0,1,0,0,1,1,-1,1,0,1,1,-1,-1,0,0,1,1,1,0,0,0,-1,0,0,0,1,0,-1,1,-1,-1,0,0,-1,0,-1,0,0,0,-1,1,-1,0,-1,1,0,0,1,0,0,0,-1,0,-1,0,0,0,0,0,-1,1,0,-1,0,-1,0,1,1,1,0,0,0,0,-1,0,-1,0,1,0,0,-1,0,-1,0,0,1,1,1,1,-1,0,1,0,0,-1,0,0,0,0,1,-1,1,-1,0,1,1,-1,-1,0,0,1,1,0,0,-1,0,0,0,0,-1,-1,-1,1,1,-1,1,1,0,1,1,1,1,-1,1,1,1,0,0,1,1,0,-1,-1,1,-1,1,-1,1,0,0,1,-1,0,0,0,1,0,1,0,0,0,0,0,0,0,1,1,-1,-1,0,0,0,1,0,-1,0,1,0,0,0,0,1,0,-1,0,1,1,0,0,0,-1,0,0,1,1,1,-1,-1,0,-1,0,-1,0,0,-1,0,-1,1,0,0,-1,-1,0,-1,-1,0,0,0,1,0,-1,0,-1,1,1,1,-1,0,1,0,0,0,1,0,-1,-1,1,0,0,-1,1,0,-1,0,0,0,0,1,-1,-1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,-1,0,0,0,-1,1,0,1,1,0,0,1,-1,0,1,1,0,0,0,0,0,1,1,-1,0,1,1,1,-1,1,0,-1,1,0,-1,-1,0,1,1,0,0,0,1,1,0,-1,1,0,0,0,1,1,1,0,-1,0,1,-1,-1,0,0,-1,1,0,0,-1,1,-1,1,1,1,1,1,-1,-1,-1,0,1,-1,-1,-1,-1,0,0,1,-1,-1,0,-1,0,0,1,0,1,0,-1,-1,0,1,0,0,0,-1,0,1,-1,0,-1,0,0,-1,0,-1,1,0,1,0,1,-1,1,0,-1,-1,0,1,0,-1,0,1,1,-1,0,1,1,0,1,-1,-1,-1,0,0,0,1,0,1,0,-1,1,1,0,0,1,-1,-1,0,1,0,-1,0,1,-1,0,0,-1,1,1,-1,0,0,0,0,1,0,-1,-1,1,1,0,0,-1,0,0,1,0,0,0,-1,-1,0,1,1,0,0,0,1,0,0,0,0,0,0,1,-1,-1,0,0,1,1,-1,0,0,0,1,0,0,0,0,-1,0,1,0,0,0,1,0,0,-1,1,1,1,0,0,0,0,0,-1,1,1,0,1,-1,1,0,-1,0,0,0,1,1,0,0,1,-1,-1,1,1,0,1,1,0,-1,-1,0,0,0,0,1,-1,0,1,0,-1,0,0,0,0,-1,1,0,1,-1,0,0,-1,1,1,0,0,0,0,0,0,0,0,-1,0,-1,0,1,1,0,0,0,-1,-1,0,0,-1,1,0,1,0,1,-1,0,1,-1,0,0,0,-1,0,-1,0,1,1,-1,-1,-1,0,1,0,0,0,0,0,1,0,-1,0,-1,0,0,0,0,1,0,0,-1,-1,-1,1,0,-1,1,1,1,-1,1,0,0},
} ;

static const unsigned char precomputed_core_mult3sntrup653_k[precomputed_core_mult3sntrup653_NUM][crypto_core_KEYBYTES] = {
  {1,0,-1,-1,-1,1,0,1,0,0,-1,1,0,0,0,-1,0,-1,0,0,0,1,0,-1,0,0,0,0,0,1,1,1,-1,0,0,0,0,-1,0,-1,1,-1,0,0,1,0,0,0,0,0,-1,0,0,1,-1,-1,0,0,-1,-1,0,1,0,-1,0,1,1,0,0,-1,0,1,-1,0,-1,0,-1,-1,-1,0,0,1,0,-1,0,1,0,-1,0,1,-1,-1,1,1,-1,1,0,-1,0,-1,-1,1,1,0,0,-1,0,0,0,-1,-1,1,-1,0,0,0,-1,0,0,0,0,0,0,0,0,1,-1,-1,0,-1,1,-1,1,1,0,0,0,-1,0,-1,1,0,-1,0,0,1,0,1,0,-1,-1,-1,0,-1,0,1,1,0,0,0,0,1,0,0,0,1,1,1,-1,0,0,0,1,0,0,-1,1,0,0,1,-1,1,0,1,0,1,-1,0,0,0,0,1,-1,1,0,-1,0,-1,1,1,0,-1,0,-1,0,-1,0,1,0,0,-1,1,-1,0,0,1,-1,0,0,0,1,0,0,0,1,-1,1,0,0,0,0,1,0,0,0,-1,1,1,1,0,1,-1,0,0,-1,0,0,0,0,0,1,1,1,1,1,0,1,1,1,0,1,-1,0,1,0,1,-1,0,-1,0,0,0,0,0,1,0,1,1,-1,0,0,-1,-1,0,-1,-1,0,0,1,1,0,0,0,0,0,-1,-1,1,0,-1,0,0,-1,0,0,0,1,1,-1,0,0,-1,0,1,1,-1,0,-1,-1,0,1,0,0,-1,0,0,1,0,0,-1,1,0,1,-1,0,0,0,0,0,0,0,1,1,1,1,-1,0,1,0,-1,0,0,0,0,0,-1,1,0,1,0,-1,1,-1,0,0,0,1,0,-1,0,-1,0,0,-1,-1,0,0,0,0,1,-1,1,0,0,1,-1,-1,0,-1,0,1,1,-1,0,0,1,0,0,0,0,0,-1,0,0,0,0,1,1,0,0,0,0,1,0,0,-1,-1,-1,1,1,-1,0,0,-1,-1,0,1,1,1,0,-1,-1,1,0,-1,-1,0,0,-1,-1,0,0,-1,1,1,0,-1,-1,0,0,0,0,-1,0,0,0,0,-1,-1,0,1,0,0,-1,0,-1,-1,1,0,1,0,1,0,0,-1,0,0,0,0,0,0,1,-1,1,-1,0,0,0,1,-1,0,0,0,0,1,0,0,0,-1,1,-1,1,0,0,0,-1,0,0,1,1,1,0,-1,-1,0,0,0,0,0,0,1,0,-1,-1,0,0,0,1,1,1,0,0,1,1,0,-1,0,-1,0,0,0,1,1,0,0,1,-1,0,-1,-1,1,0,0,1,-1,-1,0,1,1,0,-1,-1,-1,0,-1,0,1,0,0,0,1,1,1,-1,1,-1,0,0,1,1,0,-1,0,1,0,0,-1,1,1,0,0,1,1,0,0,1,0,0,-1,0,0,-1,-1,0,0,0,0,0,0,0,0,0,-1,0,0,-1,-1,-1,0,-1,1,0,-1,0,0,0,0,1,1,0,-1,-1,1,1,0,-1,-1,1,0,1,0,0,1,-1,-1,0,0,-1,1,1,0,0,-1},
  {0,-1,1,1,0,1,-1,-1,0,0,-1,-1,0,1,1,1,1,-1,1,1,1,-1,1,0,0,-1,0,0,0,0,-1,1,0,1,0,0,1,-1,1,-1,0,0,0,0,-1,0,1,-1,0,0,1,0,1,0,1,0,0,1,0,0,1,1,1,-1,0,1,1,0,1,0,0,-1,0,1,0,0,-1,0,-1,1,-1,0,0,-1,1,0,0,1,0,0,0,-1,0,0,0,0,0,0,-1,0,1,-1,0,0,0,0,0,-1,0,1,0,0,0,1,1,1,0,1,0,0,0,-1,0,0,1,1,0,-1,1,-1,-1,0,0,1,0,1,0,0,1,0,0,1,0,1,1,0,1,-1,-1,0,-1,0,1,-1,-1,-1,0,1,0,0,0,0,0,1,0,1,0,0,0,0,-1,-1,-1,0,1,0,0,-1,1,0,1,0,1,1,0,-1,0,0,0,-1,0,0,1,0,-1,0,0,1,0,1,-1,1,-1,1,0,-1,-1,0,0,1,1,0,0,0,0,1,-1,-1,-1,0,0,1,-1,0,1,-1,0,1,0,0,0,1,0,1,0,-1,-1,0,0,0,0,0,0,-1,-1,0,1,0,-1,0,1,0,-1,0,0,1,0,0,-1,0,-1,1,0,0,0,0,1,0,1,0,1,1,-1,1,-1,1,0,0,0,-1,0,1,1,-1,0,1,0,1,1,0,1,-1,1,1,0,-1,0,0,1,-1,1,0,-1,1,0,1,-1,-1,1,0,0,-1,-1,1,0,-1,1,0,-1,1,1,0,1,-1,-1,0,-1,0,0,0,-1,0,1,0,1,1,1,0,0,1,0,-1,0,1,1,-1,1,-1,-1,1,1,1,1,-1,0,0,0,0,1,1,0,1,-1,0,0,1,0,1,0,0,1,0,1,1,0,0,1,0,1,0,-1,0,0,0,1,1,0,0,0,-1,0,-1,0,0,0,0,0,-1,0,-1,0,0,-1,0,1,-1,0,0,0,0,-1,0,-1,1,0,0,0,0,1,-1,0,-1,0,1,-1,1,1,0,0,0,0,0,0,-1,0,0,1,0,0,0,0,0,1,-1,0,0,0,-1,-1,1,-1,1,0,0,-1,-1,0,0,0,1,0,0,0,0,0,0,-1,-1,-1,0,1,1,0,0,0,-1,0,1,0,0,1,0,0,1,0,-1,-1,1,0,0,-1,0,0,0,0,0,-1,0,1,-1,0,1,0,0,0,0,0,0,-1,0,0,0,0,-1,0,0,0,0,0,0,0,0,1,-1,0,0,-1,1,-1,1,-1,-1,1,0,0,-1,-1,0,0,-1,0,-1,0,-1,1,-1,0,-1,0,0,0,-1,0,1,-1,0,0,0,0,0,1,0,0,0,-1,0,0,-1,0,0,0,-1,1,0,1,-1,1,1,-1,-1,1,1,-1,0,0,0,-1,0,0,0,0,0,0,0,0,1,1,0,1,1,0,-1,0,-1,0,1,0,1,1,0,0,1,1,0,0,-1,0,0,-1,1,0,1,1,-1,-1,0,0,1,0,1,0,0,0,1,1,-1,0,0,-1,0,0,0,0,0,0,0,-1,0,1,-1,0,-1,1},
  {-1,-1,0,1,0,0,-1,-1,-1,0,0,-1,0,1,0,-1,0,1,-1,0,1,-1,0,-1,0,1,0,1,0,0,-1,1,0,0,1,0,0,-1,0,1,-1,1,-1,0,1,1,0,0,1,-1,1,0,-1,0,0,-1,-1,0,0,1,0,1,1,-1,0,0,0,-1,-1,-1,1,1,0,1,0,1,-1,0,0,0,-1,1,-1,0,1,1,1,1,-1,0,0,1,1,1,-1,-1,0,0,1,-1,0,1,0,-1,1,1,0,-1,-1,0,-1,1,0,1,-1,-1,0,-1,-1,-1,0,0,1,1,0,0,1,-1,0,0,0,1,-1,0,0,0,-1,1,1,0,-1,1,0,1,-1,1,1,0,-1,0,-1,-1,-1,-1,0,-1,1,0,0,1,0,1,1,0,0,0,0,1,0,0,1,1,0,0,1,0,-1,0,0,0,0,0,0,0,0,0,-1,0,-1,0,-1,0,0,0,1,0,0,1,0,0,-1,0,1,-1,0,-1,1,-1,-1,0,0,0,1,1,0,0,0,-1,1,0,1,-1,0,0,-1,-1,-1,0,-1,-1,0,-1,0,1,1,0,-1,1,0,0,0,0,0,0,0,1,1,1,0,0,0,-1,-1,0,0,-1,0,0,0,0,0,-1,0,0,-1,-1,1,0,-1,0,0,0,0,-1,0,0,1,0,0,0,0,0,-1,1,1,-1,0,0,0,0,1,-1,0,0,0,0,1,-1,1,0,0,0,0,-1,-1,-1,0,0,-1,1,0,0,0,0,0,1,0,-1,0,-1,-1,1,0,0,-1,1,-1,0,0,1,0,0,0,-1,0,0,1,1,0,0,-1,1,-1,1,0,1,0,0,1,0,1,-1,1,1,-1,0,0,-1,0,0,0,0,0,0,0,0,-1,0,0,-1,0,1,0,0,0,1,0,-1,0,-1,1,0,0,1,1,1,0,0,-1,0,0,-1,-1,-1,0,0,-1,0,0,0,-1,0,1,1,-1,0,0,1,-1,0,-1,-1,1,1,-1,0,1,1,-1,0,0,0,-1,1,0,1,1,0,-1,1,-1,-1,1,0,0,1,0,0,0,0,1,0,0,1,-1,1,1,0,0,0,1,1,0,0,0,0,-1,-1,1,1,1,0,-1,0,0,1,0,0,-1,0,0,-1,1,0,0,-1,0,0,0,1,0,1,-1,0,-1,0,-1,0,0,1,-1,0,0,-1,0,1,-1,0,-1,0,0,1,1,0,-1,0,1,0,0,0,0,0,1,0,-1,0,1,1,0,0,-1,0,-1,0,1,1,0,0,0,-1,-1,0,-1,1,0,0,1,0,-1,1,-1,-1,0,0,0,-1,-1,0,0,-1,0,0,0,0,1,0,0,0,1,0,1,0,1,-1,-1,0,-1,0,1,-1,0,-1,0,1,0,0,1,0,-1,-1,0,0,-1,-1,-1,0,1,0,-1,1,-1,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,0,1,-1,0,0,0,-1,0,1,0,1,0,-1,-1,-1,0,1,-1,0,-1,0,0,-1,1,0,1,1,0,0,1,0,0,0,1,1,0,-1,0,-1,-1,-1,0,-1,-1,-1,0,0},
  {-1,1,0,0,1,1,-1,0,1,0,0,0,0,1,0,1,0,0,0,-1,1,0,0,1,0,0,0,0,0,0,1,0,1,-1,-1,0,-1,0,1,-1,0,1,-1,-1,0,0,0,0,0,0,0,-1,1,0,0,0,1,1,0,-1,-1,0,0,0,0,0,-1,0,0,1,-1,0,-1,1,0,1,0,-1,0,-1,0,0,-1,1,1,-1,0,1,1,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,-1,0,1,-1,-1,0,0,1,0,1,-1,1,1,0,-1,-1,1,1,0,1,1,0,0,0,-1,0,0,0,0,1,0,1,1,0,0,0,0,-1,1,-1,1,0,1,0,0,0,-1,0,1,1,1,-1,0,1,-1,-1,0,1,-1,-1,0,0,0,1,0,-1,-1,0,0,0,0,1,1,1,1,1,0,0,0,1,1,1,0,1,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,1,0,1,-1,1,1,0,1,0,1,-1,0,0,0,-1,1,-1,0,0,0,0,0,0,1,0,-1,-1,1,0,0,1,0,-1,1,0,0,0,-1,-1,0,1,0,-1,1,0,-1,-1,-1,0,1,-1,0,1,0,0,0,-1,0,0,-1,0,1,0,0,0,0,0,-1,0,1,1,-1,0,0,0,-1,1,1,0,-1,0,0,-1,0,1,1,-1,0,1,0,0,1,-1,0,0,0,-1,1,-1,0,-1,0,0,-1,0,0,0,0,-1,1,0,1,-1,0,0,0,1,1,-1,-1,0,0,0,-1,-1,0,1,-1,0,1,0,-1,0,-1,0,0,0,0,0,0,0,-1,-1,1,-1,0,0,-1,0,0,1,-1,0,0,1,-1,-1,1,1,-1,0,1,0,0,0,-1,-1,-1,1,1,0,0,1,-1,0,0,-1,-1,0,0,0,0,0,-1,0,1,0,0,0,-1,1,-1,1,0,0,0,1,-1,1,-1,0,0,-1,0,-1,-1,0,-1,0,0,-1,-1,-1,0,0,-1,1,-1,1,1,-1,-1,1,-1,0,0,0,0,-1,0,1,0,0,1,0,-1,0,1,0,0,0,0,0,0,0,1,1,1,0,0,0,0,-1,-1,1,0,1,0,1,1,0,0,1,1,0,0,0,-1,1,0,-1,-1,0,1,0,1,0,0,-1,-1,-1,0,-1,1,-1,-1,0,1,0,0,1,0,0,1,0,0,0,1,1,-1,1,-1,0,-1,-1,0,1,1,1,0,0,0,1,0,0,-1,0,0,0,1,-1,0,1,0,0,0,0,0,1,0,0,1,0,-1,-1,1,0,0,0,1,0,-1,0,-1,-1,0,0,-1,1,-1,0,-1,0,1,0,0,0,1,-1,0,0,0,-1,1,1,0,-1,0,1,0,1,-1,-1,0,0,0,0,0,-1,0,-1,0,-1,0,-1,-1,0,1,-1,1,1,1,0,0,-1,0,1,-1,1,1,0,0,1,0,-1,0,0,1,0,0,-1,0,1,1,-1,1,0,-1,0,1,1,1,-1,-1,0,-1,1,1,0,0,0,1,0,0,0,1,-1,0,0,0,0,1,0,1,1,1},
} ;

static const unsigned char precomputed_core_mult3sntrup653_c[precomputed_core_mult3sntrup653_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
} ;

static void test_core_mult3sntrup653_impl(long long impl)
{
  unsigned char *h = test_core_mult3sntrup653_h;
  unsigned char *n = test_core_mult3sntrup653_n;
  unsigned char *k = test_core_mult3sntrup653_k;
  unsigned char *c = test_core_mult3sntrup653_c;
  unsigned char *h2 = test_core_mult3sntrup653_h2;
  unsigned char *n2 = test_core_mult3sntrup653_n2;
  unsigned char *k2 = test_core_mult3sntrup653_k2;
  unsigned char *c2 = test_core_mult3sntrup653_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_mult3sntrup653_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_mult3sntrup653(impl);
    printf("core_mult3sntrup653 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_mult3sntrup653_implementation(impl),ntruprime_dispatch_core_mult3sntrup653_compiler(impl));
  } else {
    crypto_core = ntruprime_core_mult3sntrup653;
    printf("core_mult3sntrup653 selected implementation %s compiler %s\n",ntruprime_core_mult3sntrup653_implementation(),ntruprime_core_mult3sntrup653_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(n2,n2,k,c);
      public(n2,hlen);
      public(k,klen);
      public(c,clen);
      if (memcmp(n2,h,hlen) != 0) fail("failure: crypto_core does not handle n=h overlap\n");
      memcpy(n2,n,nlen);
      secret(n,nlen);
      secret(k2,klen);
      secret(c,clen);
      crypto_core(k2,n,k2,c);
      public(k2,hlen);
      public(n,nlen);
      public(c,clen);
      if (memcmp(k2,h,hlen) != 0) fail("failure: crypto_core does not handle k=h overlap\n");
      memcpy(k2,k,klen);
      secret(n,nlen);
      secret(k,klen);
      secret(c2,clen);
      crypto_core(c2,n,k,c2);
      public(c2,hlen);
      public(n,nlen);
      public(k,klen);
      if (memcmp(c2,h,hlen) != 0) fail("failure: crypto_core does not handle c=h overlap\n");
      memcpy(c2,c,clen);
    }
    checksum_expected(core_mult3sntrup653_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_mult3sntrup653_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_mult3sntrup653_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_mult3sntrup653_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_mult3sntrup653_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_mult3sntrup653_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_mult3sntrup653_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_mult3sntrup653_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_mult3sntrup653_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_mult3sntrup653_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_mult3sntrup653(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"mult3sntrup653")) return;
  storage_core_mult3sntrup653_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_mult3sntrup653_h = aligned(storage_core_mult3sntrup653_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_mult3sntrup653_n = callocplus(crypto_core_INPUTBYTES);
  test_core_mult3sntrup653_n = aligned(storage_core_mult3sntrup653_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_mult3sntrup653_k = callocplus(crypto_core_KEYBYTES);
  test_core_mult3sntrup653_k = aligned(storage_core_mult3sntrup653_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_mult3sntrup653_c = callocplus(crypto_core_CONSTBYTES);
  test_core_mult3sntrup653_c = aligned(storage_core_mult3sntrup653_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_mult3sntrup653_h2 = callocplus(maxalloc);
  test_core_mult3sntrup653_h2 = aligned(storage_core_mult3sntrup653_h2,crypto_core_OUTPUTBYTES);
  storage_core_mult3sntrup653_n2 = callocplus(maxalloc);
  test_core_mult3sntrup653_n2 = aligned(storage_core_mult3sntrup653_n2,crypto_core_INPUTBYTES);
  storage_core_mult3sntrup653_k2 = callocplus(maxalloc);
  test_core_mult3sntrup653_k2 = aligned(storage_core_mult3sntrup653_k2,crypto_core_KEYBYTES);
  storage_core_mult3sntrup653_c2 = callocplus(maxalloc);
  test_core_mult3sntrup653_c2 = aligned(storage_core_mult3sntrup653_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_mult3sntrup653 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_mult3sntrup653();++impl)
      forked(test_core_mult3sntrup653_impl,impl);
    ++test_core_mult3sntrup653_h;
    ++test_core_mult3sntrup653_n;
    ++test_core_mult3sntrup653_k;
    ++test_core_mult3sntrup653_c;
    ++test_core_mult3sntrup653_h2;
    ++test_core_mult3sntrup653_n2;
    ++test_core_mult3sntrup653_k2;
    ++test_core_mult3sntrup653_c2;
  }
  free(storage_core_mult3sntrup653_c2);
  free(storage_core_mult3sntrup653_k2);
  free(storage_core_mult3sntrup653_n2);
  free(storage_core_mult3sntrup653_h2);
  free(storage_core_mult3sntrup653_c);
  free(storage_core_mult3sntrup653_k);
  free(storage_core_mult3sntrup653_n);
  free(storage_core_mult3sntrup653_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

