/**
 * \file pappsomspp/processing/cbor/mzcbor/mzcborreaderbase.cpp
 * \date 19/11/2025
 * \author Olivier Langella
 * \brief read mzcbor stream or file
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#include "mzcborreaderbase.h"
#include "cvparam.h"
#include "pappsomspp/core/exception/exceptionnotfound.h"

pappso::cbor::mzcbor::MzcborReaderBase::MzcborReaderBase()
{
}

pappso::cbor::mzcbor::MzcborReaderBase::~MzcborReaderBase()
{
}

void
pappso::cbor::mzcbor::MzcborReaderBase::close()
{
}

void
pappso::cbor::mzcbor::MzcborReaderBase::readCbor(QFile *cborp, pappso::UiMonitorInterface &monitor)
{
  qDebug();
  initCborReader(cborp);

  qDebug();
  if(mpa_cborReader->isMap())
    {
      readRoot(monitor);
    }
  qDebug();
}

void
pappso::cbor::mzcbor::MzcborReaderBase::readCbor(QIODevice *cborp,
                                                 pappso::UiMonitorInterface &monitor)
{
  qDebug();
  initCborReader(cborp);

  qDebug();
  if(mpa_cborReader->isMap())
    {
      readRoot(monitor);
    }
  qDebug();
}


void
pappso::cbor::mzcbor::MzcborReaderBase::readRoot(pappso::UiMonitorInterface &monitor
                                                 [[maybe_unused]])
{
  qDebug();
  mpa_cborReader->enterContainer();

  while(getExpectedString())
    {

      if(m_expectedString == "mzCBOR")
        {
          m_isMzcbor = true;
          mpa_cborReader->next();
        }
      else if(m_expectedString == "mzML")
        {
          m_isMzcbor = true;
          qDebug() << m_expectedString;
          mpa_cborReader->next();

          while(getExpectedString())
            {
              qDebug() << m_expectedString;
              if(m_expectedString == "run")
                {
                  readMsrun();
                }
              else if(m_expectedString == "referenceableParamGroupList")
                {
                  readReferenceableParamGroupList();
                }
              else
                {
                  mpa_cborReader->next();
                }
              if(m_stopParsing)
                break;
            }
        }
    }
  mpa_cborReader->leaveContainer();
}


bool
pappso::cbor::mzcbor::MzcborReaderBase::isMzcbor() const
{
  return m_isMzcbor;
}

const QStringList &
pappso::cbor::mzcbor::MzcborReaderBase::getMsrunIdList() const
{
  return m_msrunIdList;
}


void
pappso::cbor::mzcbor::MzcborReaderBase::readReferenceableParamGroupList()
{
  mpa_cborReader->enterContainer();

  while(getExpectedString())
    {
      if(m_expectedString == "referenceableParamGroup")
        {
          mpa_cborReader->next();
          /*
  mpa_cborReader->enterContainer();

  while(getExpectedString())
    {
      if(m_expectedString == "cvParam")
        {
          std::map<QString, pappso::cbor::mzcbor::CvParam> cvParamMap =
            CvParam::getCvParamsMapFromCbor(*mpa_cborReader);
        }
      else
        {
          mpa_cborReader->next();
        }
    }

  mpa_cborReader->leaveContainer();*/
        }
      else
        {
          mpa_cborReader->next();
        }
    }

  mpa_cborReader->leaveContainer();
}
void
pappso::cbor::mzcbor::MzcborReaderBase::readMsrun()
{
  mpa_cborReader->enterContainer();

  while(getExpectedString())
    {
      if(m_expectedString == "id")
        {
          getExpectedString();
          m_msrunIdList << m_expectedString;
        }
      else
        {
          mpa_cborReader->next();
        }
    }

  mpa_cborReader->leaveContainer();
}

std::map<QString, pappso::cbor::mzcbor::CvParam>
pappso::cbor::mzcbor::MzcborReaderBase::getCvParamsMap()
{
  qDebug();
  std::map<QString, CvParam> accession_values;
  mpa_cborReader->enterContainer(); // start array

  while(mpa_cborReader->hasNext())
    {

      CvParam cv_param;
      cv_param.fromCbor(*mpa_cborReader);
      accession_values.insert({cv_param.accession, cv_param});
    }

  mpa_cborReader->leaveContainer(); // end array
  return accession_values;
}
