
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file OdaGeoDecoderAttributes.h
    \\brief Definition of OdaGeoDecoder Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MagRequest.h" 
#include "OdaGeoDecoderWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


OdaGeoDecoderWrapper::OdaGeoDecoderWrapper(): odageodecoder_(new OdaGeoDecoder())

{

	
	
	
} 
OdaGeoDecoderWrapper::OdaGeoDecoderWrapper(OdaGeoDecoder* odageodecoder): odageodecoder_(odageodecoder)
{
	
	
} 

OdaGeoDecoderWrapper::~OdaGeoDecoderWrapper()
{
	
}

void OdaGeoDecoderWrapper::set(const MagRequest& request)
{
	
	

	if  (request.countValues("ODB_FILENAME") ) {
		string path_value = request("ODB_FILENAME");
		odageodecoder_->path_ = path_value;
		}
	if  (request.countValues("ODB_LATITUDE_VARIABLE") ) {
		string latitude_value = request("ODB_LATITUDE_VARIABLE");
		odageodecoder_->latitude_ = latitude_value;
		}
	if  (request.countValues("ODB_LONGITUDE_VARIABLE") ) {
		string longitude_value = request("ODB_LONGITUDE_VARIABLE");
		odageodecoder_->longitude_ = longitude_value;
		}
	if  (request.countValues("ODB_VALUE_VARIABLE") ) {
		string value_value = request("ODB_VALUE_VARIABLE");
		odageodecoder_->value_ = value_value;
		}
	if  (request.countValues("ODB_Y_COMPONENT_VARIABLE") ) {
		string y_value = request("ODB_Y_COMPONENT_VARIABLE");
		odageodecoder_->y_ = y_value;
		}
	if  (request.countValues("ODB_X_COMPONENT_VARIABLE") ) {
		string x_value = request("ODB_X_COMPONENT_VARIABLE");
		odageodecoder_->x_ = x_value;
		}
	if  (request.countValues("ODB_NB_ROWS") ) {
		int nb_rows_value = request("ODB_NB_ROWS");
		odageodecoder_->nb_rows_ = nb_rows_value;
		}
	if  (request.countValues("ODB_USER_TITLE") ) {
		string title_value = request("ODB_USER_TITLE");
		odageodecoder_->title_ = title_value;
		}
	if  (request.countValues("ODB_COORDINATES_UNIT") ) {
		string unit_value = request("ODB_COORDINATES_UNIT");
		odageodecoder_->unit_ = unit_value;
		}
	
	
		string odb_binning_value = request.countValues("ODB_BINNING") ?  (string) request("ODB_BINNING") : "off";
	MagLog::debug() << " ODB_BINNING set to " << odb_binning_value << endl;
	BinningObjectWrapper* odb_binning_wrapper = 0;
	try
	{
		odb_binning_wrapper = SimpleFactory<BinningObjectWrapper>::create(odb_binning_value);
	}
	 catch (NoFactoryException) {
		MagLog::warning() << "[" << odb_binning_value << "] is not a valid value for odb_binning: reset to default -> [off]" << endl;
		odb_binning_wrapper = SimpleFactory<BinningObjectWrapper>::create("off");
	}
	odb_binning_wrapper->set(request);
	odageodecoder_->odb_binning_ =  unique_ptr<BinningObject>(odb_binning_wrapper->object());
	delete odb_binning_wrapper;
	
}

void OdaGeoDecoderWrapper::print(ostream& out)  const
{
	out << "OdaGeoDecoderWrapper[]";
}


    



#include "BinningObjectWrapper.h"

static SimpleObjectMaker<BinningObjectWrapper> OdaGeoDecoder_odb_binning_binning_Wrapper("binning");


#include "BinningObjectWrapper.h"

static SimpleObjectMaker<BinningObjectWrapper> OdaGeoDecoder_odb_binning_on_Wrapper("on");


#include "NoBinningObjectWrapper.h"
static SimpleObjectMaker<NoBinningObject, BinningObject> OdaGeoDecoder_odb_binning_nobinning ("nobinning");
static SimpleObjectMaker<NoBinningObjectWrapper, BinningObjectWrapper> OdaGeoDecoder_odb_binning_nobinning_wrapper ("nobinning");


#include "NoBinningObjectWrapper.h"
static SimpleObjectMaker<NoBinningObject, BinningObject> OdaGeoDecoder_odb_binning_off ("off");
static SimpleObjectMaker<NoBinningObjectWrapper, BinningObjectWrapper> OdaGeoDecoder_odb_binning_off_wrapper ("off");



