// license:CC0-1.0
// copyright-holders:Vas Crabb, Couriersud

#include "netlist/devices/net_lib.h"

#ifndef __PLIB_PREPROCESSOR__

#endif

#define USE_FRONTIERS 1

NETLIST_START(zac1b11142_schematics)
{

	// Shared chips

	TTL_7474_DIP(U3A) // FIXME: need 74LS family model (higher input impedance, half the sink capability)
	CD4016_DIP(U5D)

	NET_C(VCC, U3A.14, U5D.14)
	NET_C(GND, U3A.7, U5D.7)

	NET_C(VCC, U3A.10, U3A.11, U3A.12, U3A.13) // only half of this chip is used in this audio section - tie up the other inputs

	// ANAL1/IOA3/IOA4 -> RULLANTE/CASSA

	CAP(C61, CAP_U(10))
	CAP(C62, CAP_P(1000))
	CAP(C63, CAP_U(0.01))
	CAP(C68, CAP_U(0.1))
	RES(R84, RES_K(1.5))
	RES(R102, RES_K(10))
	RES(R103, RES_K(10))
	RES(R104, RES_K(120))
	RES(R105, RES_K(56))
	RES(R120, RES_K(47))
	RES(R121, 680) // incorrectly labelled R128 on schematic
	RES(R122, RES_K(33))
	RES(R123, RES_K(1))
	RES(R124, RES_K(39))
	RES(R125, RES_K(560))
	RES(R126, RES_K(470))
	RES(R127, RES_K(100))
	RES(R128, RES_K(56))
	RES(R129, RES_K(1))
	RES(R130, RES_K(33))
	RES(R131, RES_K(150))
	RES(R132, RES_K(1))
	RES(R133, RES_K(1))
	LM3900(U5C1)
	LM3900(U5C2)
	LM3900(U5C3)

	NET_C(ANAL1, R133.1, C63.1, U5D.9, U5D.10)
	NET_C(IOA3, U5D.6)
	NET_C(IOA4, U5D.12)
	NET_C(U5D.11, R132.1, R131.1)
	NET_C(R131.2, R130.1, U5C1.MINUS)
	NET_C(R130.2, R124.1, U5C1.OUT)
	NET_C(R120.1, U5C1.PLUS)
	NET_C(U5D.8, R129.1, R128.1)
	NET_C(R128.2, R126.2, R127.1, R125.1, C62.1, U5C2.MINUS)
	NET_C(R125.2, C62.2, U5C2.OUT, R123.1)
	NET_C(R121.1, U5C2.PLUS)
	NET_C(R123.2, C61.1, C68.1)
	NET_C(C68.2, R122.1)
	NET_C(R122.2, R104.1, U5C3.MINUS)
	NET_C(R104.2, U5C3.OUT, R105.1)
	NET_C(R102.1, U5C3.PLUS)
	NET_C(R103.2, R102.2, R84.1)
	NET_C(VCC, R126.1, R103.1, U5C1.VCC, U5C2.VCC, U5C3.VCC)
	NET_C(GND, R133.2, C63.2, R132.2, R120.2, R129.2, R127.2, R121.2, C61.2, R84.2, U5C1.GND, U5C2.GND, U5C3.GND)
	ALIAS(RULLANTE, R124.2)
	ALIAS(CASSA, R105.2)


	// ANAL2 -> BASSO

	CAP(C29, CAP_U(0.1))
	CAP(C45, CAP_P(1000))
	CAP(C52, CAP_U(0.022)) // schematic says "0,02µ" but that isn't a standard e-series value
	CAP(C53, CAP_U(0.022)) // schematic says "0,02µ" but that isn't a standard e-series value
	CAP(C54, CAP_U(2.2))
	RES(R46, RES_K(1))
	RES(R69, RES_K(2.2))
	RES(R83, RES_K(2.2))
	RES(R85, RES_K(120))
	RES(R86, RES_K(100))
	RES(R87, RES_K(33))
	RES(R88, RES_K(15)) // schematic says "15" but board has 15kΩ resistor and 15Ω would be way too low
	RES(R98, RES_K(180))
	RES(R99, RES_K(47))
	RES(R100, RES_K(1))
	RES(R101, RES_K(4.7))
	RES(R106, RES_K(68))
	RES(R118, RES_K(33))
	LM3900(U5B4)
	LM3900(U5C4)

	NET_C(ANAL2, R46.1, C29.1)
	NET_C(C29.2, R69.1)
	NET_C(R69.2, R98.1, C52.1, U5B4.MINUS)
	NET_C(R98.2, C52.2, U5B4.OUT, C53.1)
	NET_C(R99.1, U5B4.PLUS)
	NET_C(R101.2, R99.2, R100.1)
	NET_C(C53.2, R118.1)
	NET_C(R118.2, C54.1, R83.1)
	NET_C(R83.2, C45.1, R85.1, U5C4.MINUS)
	NET_C(C45.2, R85.2, U5C4.OUT, R106.1)
	NET_C(R86.1, U5C4.PLUS)
	NET_C(R87.2, R86.2, R88.1)
	NET_C(VCC, R101.1, R87.1, U5B4.VCC, U5C4.VCC)
	NET_C(GND, R46.2, R100.2, C54.2, R88.2, U5B4.GND, U5C4.GND)
	ALIAS(BASSO, R106.2)


	// ANAL3/SW1

	CAP(C44, CAP_U(0.1))
	CAP(C56, CAP_U(0.01))
	RES(R70, RES_K(10))
	RES(R71, RES_K(1))
	RES(R72, RES_K(10))
	RES(R82, RES_K(10))

	NET_C(ANAL3, R71.1, R72.1)
	NET_C(R72.2, U5D.4, R70.1)
	NET_C(SW1, U5D.5) // this connection is not shown on the schematic
	NET_C(U5D.3, C56.1)
	NET_C(R70.2, C44.1)
	NET_C(C44.2, R82.1)
	NET_C(GND, R71.2, C56.2)


	// ANAL6
	// schematic shows an open jumper between R80 and the mix, so this channel may have been disconnected in practice
	// at least one physical board has no connection between the pads

	CAP(C42, CAP_U(0.1))
	CAP(C43, CAP_U(0.01))
	RES(R47, RES_K(1))
	RES(R48, RES_K(10))
	//RES(R80, RES_K(10))
	RES(R81, RES_K(10))

	NET_C(ANAL6, R47.1, R48.1)
	NET_C(R48.2, C42.1)
	NET_C(C42.2, R81.1)
	NET_C(R81.2, C43.1/*, R80.1*/)
	NET_C(GND, R47.2, C43.2)


	// ANAL4 -> PIANO

	CAP(C41, CAP_U(0.1))
	CAP(C49, CAP_U(0.01))
	RES(R78, RES_K(1))
	RES(R79, RES_K(47))
	RES(R90, RES_K(68))
	RES(R91, RES_K(12))
	RES(R92, RES_K(33))
	RES(R93, RES_K(100))
	RES(R107, RES_K(100))
	LM3900(U5B2)

	NET_C(ANAL4, R78.1, C41.1)
	NET_C(C41.2, R79.1)
	NET_C(R79.2, C49.1, R107.1, U5B2.MINUS)
	NET_C(C49.2, R107.2, U5B2.OUT, R90.1)
	NET_C(R93.1, U5B2.PLUS)
	NET_C(R92.2, R93.2, R91.1)
	NET_C(VCC, R92.1, U5B2.VCC)
	NET_C(GND, R78.2, R91.2, U5B2.GND)
	ALIAS(PIANO, R90.2)


	// ANAL5 -> TROMBA

	CAP(C28, CAP_P(1000))
	CAP(C37, CAP_U(1))
	CAP(C50, CAP_P(1000))
	QBJT_EB(T6, "BC548C") // schematic says "BC548"
	RES(R39, 220)
	RES(R40, RES_K(100))
	RES(R64, RES_K(4.7))
	RES(R65, RES_K(4.7))
	RES(R66, RES_K(1))
	RES(R67, RES_K(1))
	RES(R94, RES_K(10))
	RES(R95, RES_K(100))
	RES(R96, RES_K(4.7))
	RES(R108, RES_K(10))
	RES(R109, RES_K(10))
	RES(R110, RES_K(10))
	RES(R111, RES_K(8.2))
	RES(R112, RES_K(100))
	RES(R113, RES_M(1))
	LM3900(U5B1)
	TTL_74LS14_GATE(U4A1)

	NET_C(ANAL5, R66.1, R67.1)
	NET_C(R67.2, C28.1, R40.1, T6.B)
	NET_C(R64.2, T6.C, U3A.3)
	NET_C(R65.2, U3A.2, U3A.4)
	NET_C(U3A.1, U4A1.Q)
	NET_C(U3A.5, R39.1, U5D.13)
	NET_C(U4A1.A, R39.2, C37.1)
	NET_C(R109.1, R94.2, R108.1, R95.1)
	NET_C(R109.2, LEVELT)
	NET_C(R110.2, R112.1, R111.1)
	NET_C(R112.2, U5D.1, C50.1, R113.1, U5B1.MINUS)
	NET_C(R95.2, U5B1.PLUS)
	NET_C(U5D.2, C50.2, R113.2, U5B1.OUT, R96.1)
	NET_C(VCC, R64.1, R65.1, R94.1, R110.1, U5B1.VCC, U4A1.VCC)
	NET_C(GND, R66.2, C28.2, R40.2, T6.E, C37.2, R108.2, R111.2, U5B1.GND, U4A1.GND)
	ALIAS(TROMBA, R96.2)


	// Mixdown

	CAP(C40, CAP_U(0.1))
	POT(P1, RES_K(10))
	QBJT_EB(T7, "BC548C") // schematic says "BC548"
	RES(R41, RES_K(8.2))
	RES(R42, RES_K(5.6))
	RES(R43, RES_K(3.3))
	RES(R44, RES_K(1.5))
	RES(R45, RES_K(10))
	RES(R68, RES_K(10))
	RES(R73, 820)
	RES(R74, 390)
	RES(R75, 150)
	RES(R76, 47)
	RES(R77, RES_K(10))
	RES(R97, RES_K(150))
	RES(R114, RES_K(4.7))
	RES(R115, RES_K(82))
	RES(R116, RES_K(47))
	RES(R117, RES_K(1))
	RES(R119, RES_K(4.7))
	TTL_74156_DIP(U4B) // FIXME: should be a 74LS156 (lower sink capability)
	LM3900(U5B3)

	NET_C(RULLANTE, CASSA, BASSO, R82.2, /*R80.2,*/ PIANO, C40.1, R77.1)
	NET_C(C40.2, R97.1)
	NET_C(TROMBA, R97.2, R41.2, R42.2, R43.2, R44.2, R73.2, R74.2, R75.2, R76.2)
	NET_C(IOA2, U4B.13)
	NET_C(IOA1, U4B.3)
	NET_C(IOA0, U4B.1, U4B.15)
	NET_C(U4B.9, R41.1)
	NET_C(U4B.10, R42.1)
	NET_C(U4B.11, R43.1)
	NET_C(U4B.12, R44.1)
	NET_C(U4B.7, R73.1)
	NET_C(U4B.6, R74.1)
	NET_C(U4B.5, R75.1)
	NET_C(U4B.4, R76.1)
	NET_C(R77.2, U5B3.PLUS)
	NET_C(R119.2, R117.2, R116.1)
	NET_C(R116.2, R115.1, U5B3.MINUS)
	NET_C(R115.2, U5B3.OUT, R114.1)
	NET_C(R114.2, R45.1, P1.1)
	NET_C(R45.2, T7.C)
	NET_C(T7.B, R68.1)
	NET_C(R68.2, LEVEL)
	NET_C(VCC, R119.1, U4B.16, U5B3.VCC)
	NET_C(GND, P1.3, T7.E, R117.1, U4B.2, U4B.8, U4B.14)
	NET_C(GND, U5B3.GND)

}

NETLIST_START(zac1b11142_schematics_speech)
{

	CS(I_SP, 0) // Fed through stream ...

	LM3900(U5D4)
	CAP(C31, CAP_U(0.22))
	CAP(C33, CAP_P(470))
	CAP(C30, CAP_P(47))
	CAP(C8,  CAP_U(0.1))
	RES(R63, RES_K(2.2))
	RES(R62, RES_K(220))
	RES(R61, RES_K(860))
	RES(R50, RES_K(820))
	RES(R49, RES_K(820))
	RES(R11, RES_K(2.2))
	RES(R4,  RES_K(10))
	POT(P2,  RES_K(10))

	NET_C(GND, C31.2, R63.2, R50.2, P2.3, U5D4.GND)
	NET_C(VCC, U5D4.VCC, I_SP.1)

	NET_C(C31.1, I_SP.2, R63.1, R62.1)
	NET_C(R62.2, C33.1)
	NET_C(C33.2, R61.1)
	NET_C(R61.2, R49.1, C30.1, U5D4.MINUS)
	NET_C(R50.1, U5D4.PLUS)
	NET_C(R49.2, C30.2, R11.1, U5D4.OUT)
	NET_C(R11.2, P2.1)
	NET_C(P2.2, R4.1)
	NET_C(R4.2, C8.1)

	NET_C(C8.2, R1.1)

}

NETLIST_START(zac1b11142_schematics_dac)
{

	CS(I_DAC, 0)    // Fed through stream ...

	QBJT_EB(T4, "2N4401")

	CAP(C20, CAP_U(0.01))
	CAP(C21, CAP_U(0.1))
	RES(R13, RES_M(3.3))
	RES(R15, RES_K(3.3))
	RES(R16, RES_K(2.2))
	RES(R17, RES_K(3.3))
	RES(R18, RES_K(10))
	POT(P3,  RES_K(10))

	NET_C(GND, T4.B, R17.2, C20.2, P3.3)
	NET_C(VCC, R15.1)
	NET_C(I_M5, R13.1, I_DAC.2)
	NET_C(I_DAC.1, T4.E, R13.2)
	NET_C(T4.C, R15.2, R17.1, C20.1, R16.2)
	NET_C(R16.1, P3.1)
	NET_C(P3.2, R18.1)
	NET_C(R18.2, C21.1)
	NET_C(C21.2, C8.2)
}

NETLIST_START(zac1b11142)
{

	SOLVER(Solver, 48000)
	#if (USE_FRONTIERS)
	PARAM(Solver.ACCURACY, 1e-7)
	PARAM(Solver.NR_LOOPS, 300)
	PARAM(Solver.METHOD, "MAT_CR")
	PARAM(Solver.PARALLEL, 4)
	PARAM(Solver.DYNAMIC_TS, 0)
	#else
	PARAM(Solver.ACCURACY, 1e-6)
	PARAM(Solver.NR_LOOPS, 300)
	PARAM(Solver.METHOD, "MAT_CR")
	PARAM(Solver.PARALLEL, 0)
	PARAM(Solver.DYNAMIC_TS, 0)
	PARAM(Solver.DYNAMIC_LTE, 5e-1)
	PARAM(Solver.DYNAMIC_MIN_TIMESTEP, 1e-6)
	#endif
	LOCAL_SOURCE(zac1b11142_schematics)
	LOCAL_SOURCE(zac1b11142_schematics_speech)
	LOCAL_SOURCE(zac1b11142_schematics_dac)

	ANALOG_INPUT(I_P12, 11.3) // +12V dropped with a 1N4004
	ANALOG_INPUT(I_P5, 5)
	ANALOG_INPUT(I_M5, -5)
	ALIAS(VCC, I_P5.Q)
	ALIAS(I_V0.Q, GND)

	NET_MODEL("AY8910PORT FAMILY(TYPE=NMOS OVL=0.05 OVH=0.05 ORL=100.0 ORH=0.5k)")

	// AY-3-8910 4G/4H digital outputs
	LOGIC_INPUT(I_IOA0,   1, "AY8910PORT")
	LOGIC_INPUT(I_IOA1,   1, "AY8910PORT")
	LOGIC_INPUT(I_IOA2,   1, "AY8910PORT")
	LOGIC_INPUT(I_IOA3,   1, "AY8910PORT")
	LOGIC_INPUT(I_IOA4,   1, "AY8910PORT")
	LOGIC_INPUT(I_LEVEL,  1, "AY8910PORT")
	LOGIC_INPUT(I_LEVELT, 1, "AY8910PORT")
	LOGIC_INPUT(I_SW1,    1, "AY8910PORT")

	ALIAS(IOA0,   I_IOA0.Q)
	ALIAS(IOA1,   I_IOA1.Q)
	ALIAS(IOA2,   I_IOA2.Q)
	ALIAS(IOA3,   I_IOA3.Q)
	ALIAS(IOA4,   I_IOA4.Q)
	ALIAS(LEVEL,  I_LEVEL.Q)
	ALIAS(LEVELT, I_LEVELT.Q)
	ALIAS(SW1,    I_SW1.Q)

	NET_C(VCC, I_IOA0.VCC, I_IOA1.VCC, I_IOA2.VCC, I_IOA3.VCC, I_IOA4.VCC,
		I_LEVEL.VCC, I_LEVELT.VCC, I_SW1.VCC)
	NET_C(GND, I_IOA0.GND, I_IOA1.GND, I_IOA2.GND, I_IOA3.GND, I_IOA4.GND,
		I_LEVEL.GND, I_LEVELT.GND, I_SW1.GND)

	// AY-3-8910 4G/4H analog outputs
	RES(R_AY4G_A, 1000)
	RES(R_AY4G_B, 1000)
	RES(R_AY4G_C, 1000)
	RES(R_AY4H_A, 1000)
	RES(R_AY4H_B, 1000)
	RES(R_AY4H_C, 1000)
	NET_C(I_P5, R_AY4G_A.1, R_AY4G_B.1, R_AY4G_C.1, R_AY4H_A.1, R_AY4H_B.1, R_AY4H_C.1)
	ALIAS(ANAL1, R_AY4G_A.2)
	ALIAS(ANAL2, R_AY4G_B.2)
	ALIAS(ANAL3, R_AY4G_C.2)
	ALIAS(ANAL4, R_AY4H_A.2)
	ALIAS(ANAL5, R_AY4H_B.2)
	ALIAS(ANAL6, R_AY4H_C.2)

	INCLUDE(zac1b11142_schematics)
	INCLUDE(zac1b11142_schematics_speech)
	INCLUDE(zac1b11142_schematics_dac)

	RES(R1, RES_K(100))
	RES(R3, RES_K(10))
	CAP(C7, CAP_U(0.1))

	NET_C(P1.2, R3.1)
	NET_C(R3.2, C7.1)
	NET_C(C7.2, R1.1)   // Connect to Pin 2 - also other sounds are mixed in here <- sound out
	NET_C(R1.2, GND)    // Actually connected to ~6V from pin 3 of TDA1510

	#if (USE_FRONTIERS)
	OPTIMIZE_FRONTIER(R124.1, RES_K(39), 50)
	OPTIMIZE_FRONTIER(R105.1, RES_K(56), 50)
	OPTIMIZE_FRONTIER(R106.1, RES_K(68), 50)
	// R80 not connected
	//OPTIMIZE_FRONTIER(R80.1,  RES_K(10), 50)

	OPTIMIZE_FRONTIER(R90.1, RES_K(68), 50)
	OPTIMIZE_FRONTIER(R96.1, RES_K(4.7), 50)
	#endif

	/* -----------------------------------------------------------------------
	 * Power terminals
	 * -----------------------------------------------------------------------*/

	// Reverse so that volume raises with raising percentage in ui
	PARAM(P1.REVERSE, 1)
	PARAM(P2.REVERSE, 1)
	PARAM(P3.REVERSE, 1)
}
