package Monitoring::GLPlugin::SNMP::MibsAndOids::PRINTERMIB;

$Monitoring::GLPlugin::SNMP::MibsAndOids::origin->{'PRINTER-MIB'} = {
  url => '',
  name => 'PRINTER-MIB',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::mib_ids->{'PRINTER-MIB'} =
    '1.3.6.1.2.1.43';

$Monitoring::GLPlugin::SNMP::MibsAndOids::mibs_and_oids->{'PRINTER-MIB'} = {
  printmib => '1.3.6.1.2.1.43',
  prtMIBConformance => '1.3.6.1.2.1.43.2',
  prtMIBGroups => '1.3.6.1.2.1.43.2.2',
  prtGeneral => '1.3.6.1.2.1.43.5',
  prtGeneralTable => '1.3.6.1.2.1.43.5.1',
  prtGeneralEntry => '1.3.6.1.2.1.43.5.1.1',
  prtGeneralConfigChanges => '1.3.6.1.2.1.43.5.1.1.1',
  prtGeneralCurrentLocalization => '1.3.6.1.2.1.43.5.1.1.2',
  prtGeneralReset => '1.3.6.1.2.1.43.5.1.1.3',
  prtGeneralResetDefinition => 'PRINTER-MIB::PrtGeneralResetTC',
  prtGeneralCurrentOperator => '1.3.6.1.2.1.43.5.1.1.4',
  prtGeneralServicePerson => '1.3.6.1.2.1.43.5.1.1.5',
  prtInputDefaultIndex => '1.3.6.1.2.1.43.5.1.1.6',
  prtOutputDefaultIndex => '1.3.6.1.2.1.43.5.1.1.7',
  prtMarkerDefaultIndex => '1.3.6.1.2.1.43.5.1.1.8',
  prtMediaPathDefaultIndex => '1.3.6.1.2.1.43.5.1.1.9',
  prtConsoleLocalization => '1.3.6.1.2.1.43.5.1.1.10',
  prtConsoleNumberOfDisplayLines => '1.3.6.1.2.1.43.5.1.1.11',
  prtConsoleNumberOfDisplayChars => '1.3.6.1.2.1.43.5.1.1.12',
  prtConsoleDisable => '1.3.6.1.2.1.43.5.1.1.13',
  prtConsoleDisableDefinition => 'PRINTER-MIB::prtConsoleDisable',
  prtAuxiliarySheetStartupPage => '1.3.6.1.2.1.43.5.1.1.14',
  prtAuxiliarySheetStartupPageDefinition => 'PRINTER-MIB::PresentOnOff',
  prtAuxiliarySheetBannerPage => '1.3.6.1.2.1.43.5.1.1.15',
  prtAuxiliarySheetBannerPageDefinition => 'PRINTER-MIB::PresentOnOff',
  prtGeneralPrinterName => '1.3.6.1.2.1.43.5.1.1.16',
  prtGeneralSerialNumber => '1.3.6.1.2.1.43.5.1.1.17',
  prtAlertCriticalEvents => '1.3.6.1.2.1.43.5.1.1.18',
  prtAlertAllEvents => '1.3.6.1.2.1.43.5.1.1.19',
  prtStorageRefTable => '1.3.6.1.2.1.43.5.2',
  prtStorageRefEntry => '1.3.6.1.2.1.43.5.2.1',
  prtStorageRefSeqNumber => '1.3.6.1.2.1.43.5.2.1.1',
  prtStorageRefIndex => '1.3.6.1.2.1.43.5.2.1.2',
  prtDeviceRefTable => '1.3.6.1.2.1.43.5.3',
  prtDeviceRefEntry => '1.3.6.1.2.1.43.5.3.1',
  prtDeviceRefSeqNumber => '1.3.6.1.2.1.43.5.3.1.1',
  prtDeviceRefIndex => '1.3.6.1.2.1.43.5.3.1.2',
  prtCover => '1.3.6.1.2.1.43.6',
  prtCoverTable => '1.3.6.1.2.1.43.6.1',
  prtCoverEntry => '1.3.6.1.2.1.43.6.1.1',
  prtCoverIndex => '1.3.6.1.2.1.43.6.1.1.1',
  prtCoverDescription => '1.3.6.1.2.1.43.6.1.1.2',
  prtCoverStatus => '1.3.6.1.2.1.43.6.1.1.3',
  prtCoverStatusDefinition => 'PRINTER-MIB::PrtCoverStatusTC',
  prtLocalization => '1.3.6.1.2.1.43.7',
  prtLocalizationTable => '1.3.6.1.2.1.43.7.1',
  prtLocalizationEntry => '1.3.6.1.2.1.43.7.1.1',
  prtLocalizationIndex => '1.3.6.1.2.1.43.7.1.1.1',
  prtLocalizationLanguage => '1.3.6.1.2.1.43.7.1.1.2',
  prtLocalizationCountry => '1.3.6.1.2.1.43.7.1.1.3',
  prtLocalizationCharacterSet => '1.3.6.1.2.1.43.7.1.1.4',
  prtLocalizationCharacterSetDefinition => 'PRINTER-MIB::CodedCharSet',
  prtInput => '1.3.6.1.2.1.43.8',
  prtInputTable => '1.3.6.1.2.1.43.8.2',
  prtInputEntry => '1.3.6.1.2.1.43.8.2.1',
  prtInputIndex => '1.3.6.1.2.1.43.8.2.1.1',
  prtInputType => '1.3.6.1.2.1.43.8.2.1.2',
  prtInputTypeDefinition => 'PRINTER-MIB::PrtInputTypeTC',
  prtInputDimUnit => '1.3.6.1.2.1.43.8.2.1.3',
  prtInputDimUnitDefinition => 'PRINTER-MIB::PrtMediaUnitTC',
  prtInputMediaDimFeedDirDeclared => '1.3.6.1.2.1.43.8.2.1.4',
  prtInputMediaDimXFeedDirDeclared => '1.3.6.1.2.1.43.8.2.1.5',
  prtInputMediaDimFeedDirChosen => '1.3.6.1.2.1.43.8.2.1.6',
  prtInputMediaDimXFeedDirChosen => '1.3.6.1.2.1.43.8.2.1.7',
  prtInputCapacityUnit => '1.3.6.1.2.1.43.8.2.1.8',
  prtInputCapacityUnitDefinition => 'PRINTER-MIB::PrtCapacityUnitTC',
  prtInputMaxCapacity => '1.3.6.1.2.1.43.8.2.1.9',
  prtInputCurrentLevel => '1.3.6.1.2.1.43.8.2.1.10',
  prtInputStatus => '1.3.6.1.2.1.43.8.2.1.11',
  prtInputStatusDefinition => 'PRINTER-MIB::PrtSubUnitStatusTC',
  prtInputMediaName => '1.3.6.1.2.1.43.8.2.1.12',
  prtInputName => '1.3.6.1.2.1.43.8.2.1.13',
  prtInputVendorName => '1.3.6.1.2.1.43.8.2.1.14',
  prtInputModel => '1.3.6.1.2.1.43.8.2.1.15',
  prtInputVersion => '1.3.6.1.2.1.43.8.2.1.16',
  prtInputSerialNumber => '1.3.6.1.2.1.43.8.2.1.17',
  prtInputDescription => '1.3.6.1.2.1.43.8.2.1.18',
  prtInputSecurity => '1.3.6.1.2.1.43.8.2.1.19',
  prtInputSecurityDefinition => 'PRINTER-MIB::PresentOnOff',
  prtInputMediaWeight => '1.3.6.1.2.1.43.8.2.1.20',
  prtInputMediaType => '1.3.6.1.2.1.43.8.2.1.21',
  prtInputMediaColor => '1.3.6.1.2.1.43.8.2.1.22',
  prtInputMediaFormParts => '1.3.6.1.2.1.43.8.2.1.23',
  prtInputMediaLoadTimeout => '1.3.6.1.2.1.43.8.2.1.24',
  prtInputNextIndex => '1.3.6.1.2.1.43.8.2.1.25',
  prtOutput => '1.3.6.1.2.1.43.9',
  prtOutputTable => '1.3.6.1.2.1.43.9.2',
  prtOutputEntry => '1.3.6.1.2.1.43.9.2.1',
  prtOutputIndex => '1.3.6.1.2.1.43.9.2.1.1',
  prtOutputType => '1.3.6.1.2.1.43.9.2.1.2',
  prtOutputTypeDefinition => 'PRINTER-MIB::PrtOutputTypeTC',
  prtOutputCapacityUnit => '1.3.6.1.2.1.43.9.2.1.3',
  prtOutputCapacityUnitDefinition => 'PRINTER-MIB::PrtCapacityUnitTC',
  prtOutputMaxCapacity => '1.3.6.1.2.1.43.9.2.1.4',
  prtOutputRemainingCapacity => '1.3.6.1.2.1.43.9.2.1.5',
  prtOutputStatus => '1.3.6.1.2.1.43.9.2.1.6',
  prtOutputStatusDefinition => 'PRINTER-MIB::PrtSubUnitStatusTC',
  prtOutputName => '1.3.6.1.2.1.43.9.2.1.7',
  prtOutputVendorName => '1.3.6.1.2.1.43.9.2.1.8',
  prtOutputModel => '1.3.6.1.2.1.43.9.2.1.9',
  prtOutputVersion => '1.3.6.1.2.1.43.9.2.1.10',
  prtOutputSerialNumber => '1.3.6.1.2.1.43.9.2.1.11',
  prtOutputDescription => '1.3.6.1.2.1.43.9.2.1.12',
  prtOutputSecurity => '1.3.6.1.2.1.43.9.2.1.13',
  prtOutputSecurityDefinition => 'PRINTER-MIB::PresentOnOff',
  prtOutputDimUnit => '1.3.6.1.2.1.43.9.2.1.14',
  prtOutputDimUnitDefinition => 'PRINTER-MIB::PrtMediaUnitTC',
  prtOutputMaxDimFeedDir => '1.3.6.1.2.1.43.9.2.1.15',
  prtOutputMaxDimXFeedDir => '1.3.6.1.2.1.43.9.2.1.16',
  prtOutputMinDimFeedDir => '1.3.6.1.2.1.43.9.2.1.17',
  prtOutputMinDimXFeedDir => '1.3.6.1.2.1.43.9.2.1.18',
  prtOutputStackingOrder => '1.3.6.1.2.1.43.9.2.1.19',
  prtOutputStackingOrderDefinition => 'PRINTER-MIB::PrtOutputStackingOrderTC',
  prtOutputPageDeliveryOrientation => '1.3.6.1.2.1.43.9.2.1.20',
  prtOutputPageDeliveryOrientationDefinition => 'PRINTER-MIB::PrtOutputPageDeliveryOrientationTC',
  prtOutputBursting => '1.3.6.1.2.1.43.9.2.1.21',
  prtOutputBurstingDefinition => 'PRINTER-MIB::PresentOnOff',
  prtOutputDecollating => '1.3.6.1.2.1.43.9.2.1.22',
  prtOutputDecollatingDefinition => 'PRINTER-MIB::PresentOnOff',
  prtOutputPageCollated => '1.3.6.1.2.1.43.9.2.1.23',
  prtOutputPageCollatedDefinition => 'PRINTER-MIB::PresentOnOff',
  prtOutputOffsetStacking => '1.3.6.1.2.1.43.9.2.1.24',
  prtOutputOffsetStackingDefinition => 'PRINTER-MIB::PresentOnOff',
  prtMarker => '1.3.6.1.2.1.43.10',
  prtMarkerTable => '1.3.6.1.2.1.43.10.2',
  prtMarkerEntry => '1.3.6.1.2.1.43.10.2.1',
  prtMarkerIndex => '1.3.6.1.2.1.43.10.2.1.1',
  prtMarkerMarkTech => '1.3.6.1.2.1.43.10.2.1.2',
  prtMarkerMarkTechDefinition => 'PRINTER-MIB::PrtMarkerMarkTechTC',
  prtMarkerCounterUnit => '1.3.6.1.2.1.43.10.2.1.3',
  prtMarkerCounterUnitDefinition => 'PRINTER-MIB::PrtMarkerCounterUnitTC',
  prtMarkerLifeCount => '1.3.6.1.2.1.43.10.2.1.4',
  prtMarkerPowerOnCount => '1.3.6.1.2.1.43.10.2.1.5',
  prtMarkerProcessColorants => '1.3.6.1.2.1.43.10.2.1.6',
  prtMarkerSpotColorants => '1.3.6.1.2.1.43.10.2.1.7',
  prtMarkerAddressabilityUnit => '1.3.6.1.2.1.43.10.2.1.8',
  prtMarkerAddressabilityUnitDefinition => 'PRINTER-MIB::prtMarkerAddressabilityUnit',
  prtMarkerAddressabilityFeedDir => '1.3.6.1.2.1.43.10.2.1.9',
  prtMarkerAddressabilityXFeedDir => '1.3.6.1.2.1.43.10.2.1.10',
  prtMarkerNorthMargin => '1.3.6.1.2.1.43.10.2.1.11',
  prtMarkerSouthMargin => '1.3.6.1.2.1.43.10.2.1.12',
  prtMarkerWestMargin => '1.3.6.1.2.1.43.10.2.1.13',
  prtMarkerEastMargin => '1.3.6.1.2.1.43.10.2.1.14',
  prtMarkerStatus => '1.3.6.1.2.1.43.10.2.1.15',
  prtMarkerStatusDefinition => 'PRINTER-MIB::PrtSubUnitStatusTC',
  prtMarkerSupplies => '1.3.6.1.2.1.43.11',
  prtMarkerSuppliesTable => '1.3.6.1.2.1.43.11.1',
  prtMarkerSuppliesEntry => '1.3.6.1.2.1.43.11.1.1',
  prtMarkerSuppliesIndex => '1.3.6.1.2.1.43.11.1.1.1',
  prtMarkerSuppliesMarkerIndex => '1.3.6.1.2.1.43.11.1.1.2',
  prtMarkerSuppliesColorantIndex => '1.3.6.1.2.1.43.11.1.1.3',
  prtMarkerSuppliesClass => '1.3.6.1.2.1.43.11.1.1.4',
  prtMarkerSuppliesClassDefinition => 'PRINTER-MIB::PrtMarkerSuppliesClassTC',
  prtMarkerSuppliesType => '1.3.6.1.2.1.43.11.1.1.5',
  prtMarkerSuppliesTypeDefinition => 'PRINTER-MIB::PrtMarkerSuppliesTypeTC',
  prtMarkerSuppliesDescription => '1.3.6.1.2.1.43.11.1.1.6',
  prtMarkerSuppliesSupplyUnit => '1.3.6.1.2.1.43.11.1.1.7',
  prtMarkerSuppliesSupplyUnitDefinition => 'PRINTER-MIB::PrtMarkerSuppliesSupplyUnitTC',
  prtMarkerSuppliesMaxCapacity => '1.3.6.1.2.1.43.11.1.1.8',
  prtMarkerSuppliesLevel => '1.3.6.1.2.1.43.11.1.1.9',
  prtMarkerColorant => '1.3.6.1.2.1.43.12',
  prtMarkerColorantTable => '1.3.6.1.2.1.43.12.1',
  prtMarkerColorantEntry => '1.3.6.1.2.1.43.12.1.1',
  prtMarkerColorantIndex => '1.3.6.1.2.1.43.12.1.1.1',
  prtMarkerColorantMarkerIndex => '1.3.6.1.2.1.43.12.1.1.2',
  prtMarkerColorantRole => '1.3.6.1.2.1.43.12.1.1.3',
  prtMarkerColorantRoleDefinition => 'PRINTER-MIB::PrtMarkerColorantRoleTC',
  prtMarkerColorantValue => '1.3.6.1.2.1.43.12.1.1.4',
  prtMarkerColorantTonality => '1.3.6.1.2.1.43.12.1.1.5',
  prtMediaPath => '1.3.6.1.2.1.43.13',
  prtMediaPathTable => '1.3.6.1.2.1.43.13.4',
  prtMediaPathEntry => '1.3.6.1.2.1.43.13.4.1',
  prtMediaPathIndex => '1.3.6.1.2.1.43.13.4.1.1',
  prtMediaPathMaxSpeedPrintUnit => '1.3.6.1.2.1.43.13.4.1.2',
  prtMediaPathMaxSpeedPrintUnitDefinition => 'PRINTER-MIB::PrtMediaPathMaxSpeedPrintUnitTC',
  prtMediaPathMediaSizeUnit => '1.3.6.1.2.1.43.13.4.1.3',
  prtMediaPathMediaSizeUnitDefinition => 'PRINTER-MIB::PrtMediaUnitTC',
  prtMediaPathMaxSpeed => '1.3.6.1.2.1.43.13.4.1.4',
  prtMediaPathMaxMediaFeedDir => '1.3.6.1.2.1.43.13.4.1.5',
  prtMediaPathMaxMediaXFeedDir => '1.3.6.1.2.1.43.13.4.1.6',
  prtMediaPathMinMediaFeedDir => '1.3.6.1.2.1.43.13.4.1.7',
  prtMediaPathMinMediaXFeedDir => '1.3.6.1.2.1.43.13.4.1.8',
  prtMediaPathType => '1.3.6.1.2.1.43.13.4.1.9',
  prtMediaPathTypeDefinition => 'PRINTER-MIB::PrtMediaPathTypeTC',
  prtMediaPathDescription => '1.3.6.1.2.1.43.13.4.1.10',
  prtMediaPathStatus => '1.3.6.1.2.1.43.13.4.1.11',
  prtMediaPathStatusDefinition => 'PRINTER-MIB::PrtSubUnitStatusTC',
  prtChannel => '1.3.6.1.2.1.43.14',
  prtChannelTable => '1.3.6.1.2.1.43.14.1',
  prtChannelEntry => '1.3.6.1.2.1.43.14.1.1',
  prtChannelIndex => '1.3.6.1.2.1.43.14.1.1.1',
  prtChannelType => '1.3.6.1.2.1.43.14.1.1.2',
  prtChannelTypeDefinition => 'PRINTER-MIB::PrtChannelTypeTC',
  prtChannelProtocolVersion => '1.3.6.1.2.1.43.14.1.1.3',
  prtChannelCurrentJobCntlLangIndex => '1.3.6.1.2.1.43.14.1.1.4',
  prtChannelDefaultPageDescLangIndex => '1.3.6.1.2.1.43.14.1.1.5',
  prtChannelState => '1.3.6.1.2.1.43.14.1.1.6',
  prtChannelStateDefinition => 'PRINTER-MIB::PrtChannelStateTC',
  prtChannelIfIndex => '1.3.6.1.2.1.43.14.1.1.7',
  prtChannelStatus => '1.3.6.1.2.1.43.14.1.1.8',
  prtChannelStatusDefinition => 'PRINTER-MIB::PrtSubUnitStatusTC',
  prtChannelInformation => '1.3.6.1.2.1.43.14.1.1.9',
  prtInterpreter => '1.3.6.1.2.1.43.15',
  prtInterpreterTable => '1.3.6.1.2.1.43.15.1',
  prtInterpreterEntry => '1.3.6.1.2.1.43.15.1.1',
  prtInterpreterIndex => '1.3.6.1.2.1.43.15.1.1.1',
  prtInterpreterLangFamily => '1.3.6.1.2.1.43.15.1.1.2',
  prtInterpreterLangFamilyDefinition => 'PRINTER-MIB::PrtInterpreterLangFamilyTC',
  prtInterpreterLangLevel => '1.3.6.1.2.1.43.15.1.1.3',
  prtInterpreterLangVersion => '1.3.6.1.2.1.43.15.1.1.4',
  prtInterpreterDescription => '1.3.6.1.2.1.43.15.1.1.5',
  prtInterpreterVersion => '1.3.6.1.2.1.43.15.1.1.6',
  prtInterpreterDefaultOrientation => '1.3.6.1.2.1.43.15.1.1.7',
  prtInterpreterDefaultOrientationDefinition => 'PRINTER-MIB::PrtPrintOrientationTC',
  prtInterpreterFeedAddressability => '1.3.6.1.2.1.43.15.1.1.8',
  prtInterpreterXFeedAddressability => '1.3.6.1.2.1.43.15.1.1.9',
  prtInterpreterDefaultCharSetIn => '1.3.6.1.2.1.43.15.1.1.10',
  prtInterpreterDefaultCharSetInDefinition => 'PRINTER-MIB::CodedCharSet',
  prtInterpreterDefaultCharSetOut => '1.3.6.1.2.1.43.15.1.1.11',
  prtInterpreterDefaultCharSetOutDefinition => 'PRINTER-MIB::CodedCharSet',
  prtInterpreterTwoWay => '1.3.6.1.2.1.43.15.1.1.12',
  prtInterpreterTwoWayDefinition => 'PRINTER-MIB::PrtInterpreterTwoWayTC',
  prtConsoleDisplayBuffer => '1.3.6.1.2.1.43.16',
  prtConsoleDisplayBufferTable => '1.3.6.1.2.1.43.16.5',
  prtConsoleDisplayBufferEntry => '1.3.6.1.2.1.43.16.5.1',
  prtConsoleDisplayBufferIndex => '1.3.6.1.2.1.43.16.5.1.1',
  prtConsoleDisplayBufferText => '1.3.6.1.2.1.43.16.5.1.2',
  prtConsoleLights => '1.3.6.1.2.1.43.17',
  prtConsoleLightTable => '1.3.6.1.2.1.43.17.6',
  prtConsoleLightEntry => '1.3.6.1.2.1.43.17.6.1',
  prtConsoleLightIndex => '1.3.6.1.2.1.43.17.6.1.1',
  prtConsoleOnTime => '1.3.6.1.2.1.43.17.6.1.2',
  prtConsoleOffTime => '1.3.6.1.2.1.43.17.6.1.3',
  prtConsoleColor => '1.3.6.1.2.1.43.17.6.1.4',
  prtConsoleColorDefinition => 'PRINTER-MIB::PrtConsoleColorTC',
  prtConsoleDescription => '1.3.6.1.2.1.43.17.6.1.5',
  prtAlert => '1.3.6.1.2.1.43.18',
  prtAlertTable => '1.3.6.1.2.1.43.18.1',
  prtAlertEntry => '1.3.6.1.2.1.43.18.1.1',
  prtAlertIndex => '1.3.6.1.2.1.43.18.1.1.1',
  prtAlertSeverityLevel => '1.3.6.1.2.1.43.18.1.1.2',
  prtAlertSeverityLevelDefinition => 'PRINTER-MIB::PrtAlertSeverityLevelTC',
  prtAlertTrainingLevel => '1.3.6.1.2.1.43.18.1.1.3',
  prtAlertTrainingLevelDefinition => 'PRINTER-MIB::PrtAlertTrainingLevelTC',
  prtAlertGroup => '1.3.6.1.2.1.43.18.1.1.4',
  prtAlertGroupDefinition => 'PRINTER-MIB::PrtAlertGroupTC',
  prtAlertGroupIndex => '1.3.6.1.2.1.43.18.1.1.5',
  prtAlertLocation => '1.3.6.1.2.1.43.18.1.1.6',
  prtAlertCode => '1.3.6.1.2.1.43.18.1.1.7',
  prtAlertCodeDefinition => 'PRINTER-MIB::PrtAlertCodeTC',
  prtAlertDescription => '1.3.6.1.2.1.43.18.1.1.8',
  prtAlertTime => '1.3.6.1.2.1.43.18.1.1.9',
  printerV1Alert => '1.3.6.1.2.1.43.18.2',
  printerV2AlertPrefix => '1.3.6.1.2.1.43.18.2.0',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::definitions->{'PRINTER-MIB'} = {
  CodedCharSet => {
    '1' => 'other',
  },
  PrtInputTypeTC => {
    '1' => 'other',
    '2' => 'unknown',
    '3' => 'sheetFeedAutoRemovableTray',
    '4' => 'sheetFeedAutoNonRemovableTray',
    '5' => 'sheetFeedManual',
    '6' => 'continuousRoll',
    '7' => 'continuousFanFold',
  },
  PrtChannelStateTC => {
    '1' => 'other',
    '3' => 'printDataAccepted',
    '4' => 'noDataAccepted',
  },
  PrtMediaPathTypeTC => {
    '1' => 'other',
    '2' => 'unknown',
    '3' => 'longEdgeBindingDuplex',
    '4' => 'shortEdgeBindingDuplex',
    '5' => 'simplex',
  },
  PrtConsoleColorTC => {
    '1' => 'other',
    '2' => 'unknown',
    '3' => 'white',
    '4' => 'red',
    '5' => 'green',
    '6' => 'blue',
    '7' => 'cyan',
    '8' => 'magenta',
    '9' => 'yellow',
    '10' => 'orange',
  },
  PrtMarkerSuppliesClassTC => {
    '1' => 'other',
    '3' => 'supplyThatIsConsumed',
    '4' => 'receptacleThatIsFilled',
  },
  PrtChannelTypeTC => {
    '1' => 'other',
    '3' => 'chSerialPort',
    '4' => 'chParallelPort',
    '5' => 'chIEEE1284Port',
    '6' => 'chSCSIPort',
    '7' => 'chAppleTalkPAP',
    '8' => 'chLPDServer',
    '9' => 'chNetwareRPrinter',
    '10' => 'chNetwarePServer',
    '11' => 'chPort9100',
    '12' => 'chAppSocket',
    '13' => 'chFTP',
    '14' => 'chTFTP',
    '15' => 'chDLCLLCPort',
    '16' => 'chIBM3270',
    '17' => 'chIBM5250',
    '18' => 'chFax',
    '19' => 'chIEEE1394',
    '20' => 'chTransport1',
    '21' => 'chCPAP',
    '26' => 'chPCPrint',
    '27' => 'chServerMessageBlock',
    '28' => 'chPSM',
    '31' => 'chSystemObjectManager',
    '32' => 'chDECLAT',
    '33' => 'chNPAP',
    '34' => 'chUSB',
    '35' => 'chIRDA',
    '36' => 'chPrintXChange',
    '37' => 'chPortTCP',
    '38' => 'chBidirPortTCP',
    '39' => 'chUNPP',
    '40' => 'chAppleTalkADSP',
    '41' => 'chPortSPX',
    '42' => 'chPortHTTP',
    '43' => 'chNDPS',
  },
  PrtOutputStackingOrderTC => {
    '2' => 'unknown',
    '3' => 'firstToLast',
    '4' => 'lastToFirst',
  },
  PrtInterpreterLangFamilyTC => {
    '1' => 'other',
    '2' => 'unknown',
    '3' => 'langPCL',
    '4' => 'langHPGL',
    '5' => 'langPJL',
    '6' => 'langPS',
    '7' => 'langIPDS',
    '8' => 'langPPDS',
    '9' => 'langEscapeP',
    '10' => 'langEpson',
    '11' => 'langDDIF',
    '12' => 'langInterpress',
    '13' => 'langISO6429',
    '14' => 'langLineData',
    '15' => 'langMODCA',
    '16' => 'langREGIS',
    '17' => 'langSCS',
    '18' => 'langSPDL',
    '19' => 'langTEK4014',
    '20' => 'langPDS',
    '21' => 'langIGP',
    '22' => 'langCodeV',
    '23' => 'langDSCDSE',
    '24' => 'langWPS',
    '25' => 'langLN03',
    '26' => 'langCCITT',
    '27' => 'langQUIC',
    '28' => 'langCPAP',
    '29' => 'langDecPPL',
    '30' => 'langSimpleText',
    '31' => 'langNPAP',
    '32' => 'langDOC',
    '33' => 'langimPress',
    '34' => 'langPinwriter',
    '35' => 'langNPDL',
    '36' => 'langNEC201PL',
    '37' => 'langAutomatic',
    '38' => 'langPages',
    '39' => 'langLIPS',
    '40' => 'langTIFF',
    '41' => 'langDiagnostic',
    '42' => 'langPSPrinter',
    '43' => 'langCaPSL',
    '44' => 'langEXCL',
    '45' => 'langLCDS',
    '46' => 'langXES',
    '47' => 'langPCLXL',
    '48' => 'langART',
    '49' => 'langTIPSI',
    '50' => 'langPrescribe',
    '51' => 'langLinePrinter',
    '52' => 'langIDP',
    '53' => 'langXJCL',
    '54' => 'langPDF',
    '55' => 'langRPDL',
    '56' => 'langIntermecIPL',
    '57' => 'langUBIFingerprint',
    '58' => 'langUBIDirectProtocol',
    '59' => 'langFujitsu',
  },
  prtConsoleDisable => {
    '3' => 'operatorConsoleEnabled',
    '4' => 'operatorConsoleDisabled',
    '5' => 'operatorConsoleEnabledLevel1',
    '6' => 'operatorConsoleEnabledLevel2',
    '7' => 'operatorConsoleEnabledLevel3',
  },
  PrtMarkerSuppliesTypeTC => {
    '1' => 'other',
    '2' => 'unknown',
    '3' => 'toner',
    '4' => 'wasteToner',
    '5' => 'ink',
    '6' => 'inkCartridge',
    '7' => 'inkRibbon',
    '8' => 'wasteInk',
    '9' => 'opc',
    '10' => 'developer',
    '11' => 'fuserOil',
    '12' => 'solidWax',
    '13' => 'ribbonWax',
    '14' => 'wasteWax',
    '15' => 'fuser',
    '16' => 'coronaWire',
    '17' => 'fuserOilWick',
    '18' => 'cleanerUnit',
    '19' => 'fuserCleaningPad',
    '20' => 'transferUnit',
    '21' => 'tonerCartridge',
    '22' => 'fuserOiler',
    '23' => 'water',
    '24' => 'wasteWater',
    '25' => 'glueWaterAdditive',
    '26' => 'wastePaper',
    '27' => 'bindingSupply',
    '28' => 'bandingSupply',
    '29' => 'stitchingWire',
    '30' => 'shrinkWrap',
    '31' => 'paperWrap',
    '32' => 'staples',
    '33' => 'inserts',
    '34' => 'covers',
  },
  prtMarkerAddressabilityUnit => {
    '3' => 'tenThousandthsOfInches',
    '4' => 'micrometers',
  },
  PrtMediaPathMaxSpeedPrintUnitTC => {
    '3' => 'tenThousandthsOfInchesPerHour',
    '4' => 'micrometersPerHour',
    '5' => 'charactersPerHour',
    '6' => 'linesPerHour',
    '7' => 'impressionsPerHour',
    '8' => 'sheetsPerHour',
    '9' => 'dotRowPerHour',
    '16' => 'feetPerHour',
    '17' => 'metersPerHour',
  },
  PrtMarkerColorantRoleTC => {
    '1' => 'other',
    '3' => 'process',
    '4' => 'spot',
  },
  PrtMarkerMarkTechTC => {
    '1' => 'other',
    '2' => 'unknown',
    '3' => 'electrophotographicLED',
    '4' => 'electrophotographicLaser',
    '5' => 'electrophotographicOther',
    '6' => 'impactMovingHeadDotMatrix9pin',
    '7' => 'impactMovingHeadDotMatrix24pin',
    '8' => 'impactMovingHeadDotMatrixOther',
    '9' => 'impactMovingHeadFullyFormed',
    '10' => 'impactBand',
    '11' => 'impactOther',
    '12' => 'inkjetAqueous',
    '13' => 'inkjetSolid',
    '14' => 'inkjetOther',
    '15' => 'pen',
    '16' => 'thermalTransfer',
    '17' => 'thermalSensitive',
    '18' => 'thermalDiffusion',
    '19' => 'thermalOther',
    '20' => 'electroerosion',
    '21' => 'electrostatic',
    '22' => 'photographicMicrofiche',
    '23' => 'photographicImagesetter',
    '24' => 'photographicOther',
    '25' => 'ionDeposition',
    '26' => 'eBeam',
    '27' => 'typesetter',
  },
  PrtPrintOrientationTC => {
    '1' => 'other',
    '3' => 'portrait',
    '4' => 'landscape',
  },
  PrtAlertTrainingLevelTC => {
    '1' => 'other',
    '2' => 'unknown',
    '3' => 'untrained',
    '4' => 'trained',
    '5' => 'fieldService',
    '6' => 'management',
    '7' => 'noInterventionRequired',
  },
  PrtMediaUnitTC => {
    '3' => 'tenThousandthsOfInches',
    '4' => 'micrometers',
  },
  PrtCapacityUnitTC => {
    '3' => 'tenThousandthsOfInches',
    '4' => 'micrometers',
    '8' => 'sheets',
    '16' => 'feet',
    '17' => 'meters',
  },
  PrtInterpreterTwoWayTC => {
    '3' => 'yes',
    '4' => 'no',
  },
  PrtCoverStatusTC => {
    '1' => 'other',
    '3' => 'coverOpen',
    '4' => 'coverClosed',
    '5' => 'interlockOpen',
    '6' => 'interlockClosed',
  },
  PresentOnOff => {
    '1' => 'other',
    '3' => 'on',
    '4' => 'off',
    '5' => 'notPresent',
  },
  PrtMarkerCounterUnitTC => {
    '3' => 'tenThousandthsOfInches',
    '4' => 'micrometers',
    '5' => 'characters',
    '6' => 'lines',
    '7' => 'impressions',
    '8' => 'sheets',
    '9' => 'dotRow',
    '11' => 'hours',
    '16' => 'feet',
    '17' => 'meters',
  },
  PrtAlertCodeTC => {
    '1' => 'other',
    '2' => 'unknown',
    '3' => 'coverOpened',
    '4' => 'coverClosed',
    '5' => 'interlockOpened',
    '6' => 'interlockClosed',
    '7' => 'configurationChanged',
    '8' => 'jammed',
    '9' => 'subunitMissing',
    '10' => 'subunitLifeAlmostOver',
    '11' => 'subunitLifeOver',
    '12' => 'subunitAlmostEmpty',
    '13' => 'subunitEmpty',
    '14' => 'subunitAlmostFull',
    '15' => 'subunitFull',
    '16' => 'subunitNearLimit',
    '17' => 'subunitAtLimit',
    '18' => 'subunitOpened',
    '19' => 'subunitClosed',
    '20' => 'subunitTurnedOn',
    '21' => 'subunitTurnedOff',
    '22' => 'subunitOffline',
    '23' => 'subunitPowerSaver',
    '24' => 'subunitWarmingUp',
    '25' => 'subunitAdded',
    '26' => 'subunitRemoved',
    '27' => 'subunitResourceAdded',
    '28' => 'subunitResourceRemoved',
    '29' => 'subunitRecoverableFailure',
    '30' => 'subunitUnrecoverableFailure',
    '31' => 'subunitRecoverableStorageError',
    '32' => 'subunitUnrecoverableStorageError',
    '33' => 'subunitMotorFailure',
    '34' => 'subunitMemoryExhausted',
    '35' => 'subunitUnderTemperature',
    '36' => 'subunitOverTemperature',
    '37' => 'subunitTimingFailure',
    '38' => 'subunitThermistorFailure',
    '501' => 'doorOpen',
    '502' => 'doorClosed',
    '503' => 'poweredUp',
    '504' => 'poweredDown',
    '505' => 'printerNMSReset',
    '506' => 'printerManualReset',
    '507' => 'printerReadyToPrint',
    '801' => 'inputMediaTrayMissing',
    '802' => 'inputMediaSizeChanged',
    '803' => 'inputMediaWeightChanged',
    '804' => 'inputMediaTypeChanged',
    '805' => 'inputMediaColorChanged',
    '806' => 'inputMediaFormPartsChange',
    '807' => 'inputMediaSupplyLow',
    '808' => 'inputMediaSupplyEmpty',
    '809' => 'inputMediaChangeRequest',
    '810' => 'inputManualInputRequest',
    '811' => 'inputTrayPositionFailure',
    '812' => 'inputTrayElevationFailure',
    '813' => 'inputCannotFeedSizeSelected',
    '901' => 'outputMediaTrayMissing',
    '902' => 'outputMediaTrayAlmostFull',
    '903' => 'outputMediaTrayFull',
    '904' => 'outputMailboxSelectFailure',
    '1001' => 'markerFuserUnderTemperature',
    '1002' => 'markerFuserOverTemperature',
    '1003' => 'markerFuserTimingFailure',
    '1004' => 'markerFuserThermistorFailure',
    '1005' => 'markerAdjustingPrintQuality',
    '1101' => 'markerTonerEmpty',
    '1102' => 'markerInkEmpty',
    '1103' => 'markerPrintRibbonEmpty',
    '1104' => 'markerTonerAlmostEmpty',
    '1105' => 'markerInkAlmostEmpty',
    '1106' => 'markerPrintRibbonAlmostEmpty',
    '1107' => 'markerWasteTonerReceptacleAlmostFull',
    '1108' => 'markerWasteInkReceptacleAlmostFull',
    '1109' => 'markerWasteTonerReceptacleFull',
    '1110' => 'markerWasteInkReceptacleFull',
    '1111' => 'markerOpcLifeAlmostOver',
    '1112' => 'markerOpcLifeOver',
    '1113' => 'markerDeveloperAlmostEmpty',
    '1114' => 'markerDeveloperEmpty',
    '1115' => 'markerTonerCartridgeMissing',
    '1301' => 'mediaPathMediaTrayMissing',
    '1302' => 'mediaPathMediaTrayAlmostFull',
    '1303' => 'mediaPathMediaTrayFull',
    '1501' => 'interpreterMemoryIncreased',
    '1502' => 'interpreterMemoryDecreased',
    '1503' => 'interpreterCartridgeAdded',
    '1504' => 'interpreterCartridgeDeleted',
    '1505' => 'interpreterResourceAdded',
    '1506' => 'interpreterResourceDeleted',
    '1507' => 'interpreterResourceUnavailable',
    '1509' => 'interpreterComplexPageEncountered',
    '1801' => 'alertRemovalOfBinaryChangeEntry',
  },
  PrtMarkerSuppliesSupplyUnitTC => {
    '3' => 'tenThousandthsOfInches',
    '4' => 'micrometers',
    '7' => 'impressions',
    '8' => 'sheets',
    '11' => 'hours',
    '12' => 'thousandthsOfOunces',
    '13' => 'tenthsOfGrams',
    '14' => 'hundrethsOfFluidOunces',
    '15' => 'tenthsOfMilliliters',
    '16' => 'feet',
    '17' => 'meters',
    '18' => 'items',
  },
  PrtGeneralResetTC => {
    '3' => 'notResetting',
    '4' => 'powerCycleReset',
    '5' => 'resetToNVRAM',
    '6' => 'resetToFactoryDefaults',
  },
  PrtOutputPageDeliveryOrientationTC => {
    '3' => 'faceUp',
    '4' => 'faceDown',
  },
  PrtAlertGroupTC => {
    '1' => 'other',
    '3' => 'hostResourcesMIBStorageTable',
    '4' => 'hostResourcesMIBDeviceTable',
    '5' => 'generalPrinter',
    '6' => 'cover',
    '7' => 'localization',
    '8' => 'input',
    '9' => 'output',
    '10' => 'marker',
    '11' => 'markerSupplies',
    '12' => 'markerColorant',
    '13' => 'mediaPath',
    '14' => 'channel',
    '15' => 'interpreter',
    '16' => 'consoleDisplayBuffer',
    '17' => 'consoleLights',
    '18' => 'alert',
    '30' => 'finDevice',
    '31' => 'finSupply',
    '32' => 'finSupplyMediaInput',
    '33' => 'finAttributeTable',
  },
  PrtAlertSeverityLevelTC => {
    '1' => 'other',
    '3' => 'criticalBinaryChangeEvent',
    '4' => 'warningUnaryChangeEvent',
    '5' => 'warningBinaryChangeEvent',
  },
  PrtOutputTypeTC => {
    '1' => 'other',
    '2' => 'unknown',
    '3' => 'removableBin',
    '4' => 'unRemovableBin',
    '5' => 'continuousRollDevice',
    '6' => 'mailBox',
    '7' => 'continuousFanFold',
  },
  PrtSubUnitStatusTC => sub {
    my $status = shift;
    my @status = ();
    if ($status - 64 >= 0) {
      push(@status, 'Currently at intended state');
      $status -= 64;
    } else {
      push(@status, 'Transitioning to intended state');
    }
    if ($status - 32 >= 0) {
      push(@status, 'State is Off-Line');
      $status -= 32;
    } else {
      push(@status, 'State is On-Line');
    }
    if ($status - 16 >= 0) {
      push(@status, 'Critical Alerts');
      $status -= 16;
    } else {
      push(@status, 'No Critical Alerts');
    }
    if ($status - 8 >= 0) {
      push(@status, 'Non-Critical Alerts');
      $status -= 8;
    } else {
      push(@status, 'No Non-Critical Alerts');
    }
    if ($status == 0) {
      push(@status, 'Available and Idle')
    } elsif ($status == 2) {
      push(@status, 'Available and Standby');
    } elsif ($status == 4) {
      push(@status, 'Available and Active');
    } elsif ($status == 6) {
      push(@status, 'Available and Busy');
    } elsif ($status == 1) {
      push(@status, 'Unavailable and OnRequest');
    } elsif ($status == 3) {
      push(@status, 'Unavailable because Broken');
    } elsif ($status == 5) {
      push(@status, 'Unknown');
    }
    return join('|', @status);
  },
};
