/* ******************************************************************************
   *  BSIM4 4.8.2 released by Chetan Kumar Dabhi 01/01/2020                     *
   *  BSIM4 Model Equations                                                     *
   ******************************************************************************

   ******************************************************************************
   *  Copyright (c) 2020 University of California                               *
   *                                                                            *
   *  Project Director: Prof. Chenming Hu.                                      *
   *  Current developers: Chetan Kumar Dabhi   (Ph.D. student, IIT Kanpur)      *
   *                      Prof. Yogesh Chauhan (IIT Kanpur)                     *
   *                      Dr. Pragya Kushwaha  (Postdoc, UC Berkeley)           *
   *                      Dr. Avirup Dasgupta  (Postdoc, UC Berkeley)           *
   *                      Ming-Yen Kao         (Ph.D. student, UC Berkeley)     *
   *  Authors: Gary W. Ng, Weidong Liu, Xuemei Xi, Mohan Dunga, Wenwei Yang     *
   *           Ali Niknejad, Chetan Kumar Dabhi, Yogesh Singh Chauhan,          *
   *           Sayeef Salahuddin, Chenming Hu                                   * 
   ******************************************************************************/

/*
Licensed under Educational Community License, Version 2.0 (the "License"); you may
not use this file except in compliance with the License. You may obtain a copy of the license at
http://opensource.org/licenses/ECL-2.0
Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations
under the License.
*/

#include "ngspice/ngspice.h"
#include "ngspice/devdefs.h"
#include "bsim4def.h"
#include "ngspice/suffix.h"

IFparm BSIM4pTable[] = { /* parameters */
IOP( "l",   BSIM4_L,      IF_REAL   , "Length"),
IOP( "w",   BSIM4_W,      IF_REAL   , "Width"),
IOP( "m",   BSIM4_M,      IF_REAL   , "Separate Parallel multiplier"),
IOP( "nf",  BSIM4_NF,     IF_REAL   , "Number of fingers"),
IOP( "sa",  BSIM4_SA,     IF_REAL   , "distance between  OD edge to poly of one side "),
IOP( "sb",  BSIM4_SB,     IF_REAL   , "distance between  OD edge to poly of the other side"),
IOP( "sd",  BSIM4_SD,     IF_REAL   , "distance between neighbour fingers"),
IOP( "sca",  BSIM4_SCA,     IF_REAL   , "Integral of the first distribution function for scattered well dopant"),
IOP( "scb",  BSIM4_SCB,     IF_REAL   , "Integral of the second distribution function for scattered well dopant"),
IOP( "scc",  BSIM4_SCC,     IF_REAL   , "Integral of the third distribution function for scattered well dopant"),
IOP( "sc",  BSIM4_SC,     IF_REAL   , "Distance to a single well edge "),
IOP( "min",  BSIM4_MIN,   IF_INTEGER , "Minimize either D or S"),
IOP( "ad",  BSIM4_AD,     IF_REAL   , "Drain area"),
IOP( "as",  BSIM4_AS,     IF_REAL   , "Source area"),
IOP( "pd",  BSIM4_PD,     IF_REAL   , "Drain perimeter"),
IOP( "ps",  BSIM4_PS,     IF_REAL   , "Source perimeter"),
IOP( "nrd", BSIM4_NRD,    IF_REAL   , "Number of squares in drain"),
IOP( "nrs", BSIM4_NRS,    IF_REAL   , "Number of squares in source"),
IOP( "off", BSIM4_OFF,    IF_FLAG   , "Device is initially off"),
IOP( "rbdb", BSIM4_RBDB,  IF_REAL   , "Body resistance"),
IOP( "rbsb", BSIM4_RBSB,  IF_REAL   , "Body resistance"),
IOP( "rbpb", BSIM4_RBPB,  IF_REAL   , "Body resistance"),
IOP( "rbps", BSIM4_RBPS,  IF_REAL   , "Body resistance"),
IOP( "rbpd", BSIM4_RBPD,  IF_REAL   , "Body resistance"),
IOP( "delvto", BSIM4_DELVTO,  IF_REAL   , "Zero bias threshold voltage variation"),
IOPR( "delvt0", BSIM4_DELVTO,  IF_REAL   , "Zero bias threshold voltage variation"),
IOP( "mulu0", BSIM4_MULU0, IF_REAL, "Low field mobility multiplier"),
IOP( "xgw",  BSIM4_XGW, IF_REAL, "Distance from gate contact center to device edge"),
IOP( "ngcon", BSIM4_NGCON, IF_REAL, "Number of gate contacts"),
IOP( "wnflag", BSIM4_WNFLAG, IF_INTEGER, "W/NF device flag for bin selection"),

IOP( "trnqsmod", BSIM4_TRNQSMOD, IF_INTEGER, "Transient NQS model selector"),
IOP( "acnqsmod", BSIM4_ACNQSMOD, IF_INTEGER, "AC NQS model selector"),
IOP( "rbodymod", BSIM4_RBODYMOD, IF_INTEGER, "Distributed body R model selector"),
IOP( "rgatemod", BSIM4_RGATEMOD, IF_INTEGER, "Gate resistance model selector"),
IOP( "geomod", BSIM4_GEOMOD, IF_INTEGER, "Geometry dependent parasitics model selector"),
IOP( "rgeomod", BSIM4_RGEOMOD, IF_INTEGER, "S/D resistance and contact model selector"),
IP( "ic",  BSIM4_IC,     IF_REALVEC , "Vector of DS,GS,BS initial voltages"),
OP( "gmbs",         BSIM4_GMBS,       IF_REAL,    "Gmb"),
OP( "gm",           BSIM4_GM,         IF_REAL,    "Gm"),
OP( "gds",          BSIM4_GDS,        IF_REAL,    "Gds"),
OP( "vdsat",        BSIM4_VDSAT,      IF_REAL,    "Vdsat"),
OP( "vth",          BSIM4_VON,        IF_REAL,    "Vth"),
OP( "id",           BSIM4_CD,         IF_REAL,    "Ids"),
OP( "ibd",          BSIM4_CBD,        IF_REAL,    "Ibd"),
OP( "ibs",          BSIM4_CBS,        IF_REAL,    "Ibs"),
OP( "gbd",          BSIM4_GBD,        IF_REAL,    "gbd"),
OP( "gbs",          BSIM4_GBS,        IF_REAL,    "gbs"),
OP( "isub",         BSIM4_CSUB,       IF_REAL,    "Isub"),
OP( "igidl",        BSIM4_IGIDL,      IF_REAL,    "Igidl"),
OP( "igisl",        BSIM4_IGISL,      IF_REAL,    "Igisl"),
OP( "igs",          BSIM4_IGS,        IF_REAL,    "Igs"),
OP( "igd",          BSIM4_IGD,        IF_REAL,    "Igd"),
OP( "igb",          BSIM4_IGB,        IF_REAL,    "Igb"),
OP( "igcs",         BSIM4_IGCS,       IF_REAL,    "Igcs"),
OP( "igcd",         BSIM4_IGCD,       IF_REAL,    "Igcd"),
OP( "vbs",          BSIM4_VBS,        IF_REAL,    "Vbs"),
OP( "vgs",          BSIM4_VGS,        IF_REAL,    "Vgs"),
OP( "vds",          BSIM4_VDS,        IF_REAL,    "Vds"),
OP( "cgg",         BSIM4_CGGB,       IF_REAL,    "Cggb"),
OP( "cgs",         BSIM4_CGSB,       IF_REAL,    "Cgsb"),
OP( "cgd",         BSIM4_CGDB,       IF_REAL,    "Cgdb"),
OP( "cbg",         BSIM4_CBGB,       IF_REAL,    "Cbgb"),
OP( "cbd",         BSIM4_CBDB,       IF_REAL,    "Cbdb"),
OP( "cbs",         BSIM4_CBSB,       IF_REAL,    "Cbsb"),
OP( "cdg",         BSIM4_CDGB,       IF_REAL,    "Cdgb"),
OP( "cdd",         BSIM4_CDDB,       IF_REAL,    "Cddb"),
OP( "cds",         BSIM4_CDSB,       IF_REAL,    "Cdsb"),
OP( "csg",         BSIM4_CSGB,       IF_REAL,    "Csgb"),
OP( "csd",         BSIM4_CSDB,       IF_REAL,    "Csdb"),
OP( "css",         BSIM4_CSSB,       IF_REAL,    "Cssb"),
OP( "cgb",         BSIM4_CGBB,       IF_REAL,    "Cgbb"),
OP( "cdb",         BSIM4_CDBB,       IF_REAL,    "Cdbb"),
OP( "csb",         BSIM4_CSBB,       IF_REAL,    "Csbb"),
OP( "cbb",         BSIM4_CBBB,       IF_REAL,    "Cbbb"),
OP( "capbd",       BSIM4_CAPBD,      IF_REAL,    "Capbd"),
OP( "capbs",       BSIM4_CAPBS,      IF_REAL,    "Capbs"),
OP( "qg",          BSIM4_QG,         IF_REAL,    "Qgate"),
OP( "qb",          BSIM4_QB,         IF_REAL,    "Qbulk"),
OP( "qd",          BSIM4_QD,         IF_REAL,    "Qdrain"),
OP( "qs",          BSIM4_QS,         IF_REAL,    "Qsource"),
OP( "qinv",        BSIM4_QINV,       IF_REAL,    "Qinversion"),
OP( "qdef",        BSIM4_QDEF,       IF_REAL,    "Qdef"),
OP( "gcrg",        BSIM4_GCRG,       IF_REAL,    "Gcrg"),
OP( "gtau",        BSIM4_GTAU,       IF_REAL,    "Gtau"),
};

IFparm BSIM4mPTable[] = { /* model parameters */
IOP( "cvchargemod", BSIM4_MOD_CVCHARGEMOD, IF_INTEGER, "Capacitance Charge model selector"),
IOP( "capmod", BSIM4_MOD_CAPMOD, IF_INTEGER, "Capacitance model selector"),
IOP( "diomod", BSIM4_MOD_DIOMOD, IF_INTEGER, "Diode IV model selector"),
IOP( "rdsmod", BSIM4_MOD_RDSMOD, IF_INTEGER, "Bias-dependent S/D resistance model selector"),
IOP( "trnqsmod", BSIM4_MOD_TRNQSMOD, IF_INTEGER, "Transient NQS model selector"),
IOP( "acnqsmod", BSIM4_MOD_ACNQSMOD, IF_INTEGER, "AC NQS model selector"),
IOP( "mobmod", BSIM4_MOD_MOBMOD, IF_INTEGER, "Mobility model selector"),
IOP( "rbodymod", BSIM4_MOD_RBODYMOD, IF_INTEGER, "Distributed body R model selector"),
IOP( "rgatemod", BSIM4_MOD_RGATEMOD, IF_INTEGER, "Gate R model selector"),
IOP( "permod", BSIM4_MOD_PERMOD, IF_INTEGER, "Pd and Ps model selector"),
IOP( "geomod", BSIM4_MOD_GEOMOD, IF_INTEGER, "Geometry dependent parasitics model selector"),
IOP( "rgeomod", BSIM4_MOD_RGEOMOD, IF_INTEGER, "S/D resistance and contact model selector"),
IOP( "fnoimod", BSIM4_MOD_FNOIMOD, IF_INTEGER, "Flicker noise model selector"),
IOP( "tnoimod", BSIM4_MOD_TNOIMOD, IF_INTEGER, "Thermal noise model selector"),
IOP( "mtrlmod", BSIM4_MOD_MTRLMOD, IF_INTEGER, "parameter for non-silicon substrate or metal gate selector"),
IOP( "mtrlcompatmod", BSIM4_MOD_MTRLCOMPATMOD, IF_INTEGER, "New Material Mod backward compatibility selector"),
IOP( "igcmod", BSIM4_MOD_IGCMOD, IF_INTEGER, "Gate-to-channel Ig model selector"),
IOP( "igbmod", BSIM4_MOD_IGBMOD, IF_INTEGER, "Gate-to-body Ig model selector"),
IOP( "tempmod", BSIM4_MOD_TEMPMOD, IF_INTEGER, "Temperature model selector"),
IOP( "gidlmod", BSIM4_MOD_GIDLMOD, IF_INTEGER, "parameter for GIDL selector"), /* v4.7 New GIDL/GISL */
IOP( "paramchk", BSIM4_MOD_PARAMCHK, IF_INTEGER, "Model parameter checking selector"),
IOP( "binunit", BSIM4_MOD_BINUNIT, IF_INTEGER, "Bin  unit  selector"),
IOP( "version", BSIM4_MOD_VERSION, IF_STRING, "parameter for model version"),
IOP( "eot", BSIM4_MOD_EOT, IF_REAL, "Equivalent gate oxide thickness in meters"),
IOP( "vddeot", BSIM4_MOD_VDDEOT, IF_REAL, "Voltage for extraction of Equivalent gate oxide thickness"),
IOP( "tempeot", BSIM4_MOD_TEMPEOT, IF_REAL, " Temperature for extraction of EOT"),
IOP( "leffeot", BSIM4_MOD_LEFFEOT, IF_REAL, " Effective length for extraction of EOT"),
IOP( "weffeot", BSIM4_MOD_WEFFEOT, IF_REAL, "Effective width for extraction of EOT"),
IOP( "ados", BSIM4_MOD_ADOS, IF_REAL, "Charge centroid parameter"),
IOP( "bdos", BSIM4_MOD_BDOS, IF_REAL, "Charge centroid parameter"),
IOP( "toxe", BSIM4_MOD_TOXE, IF_REAL, "Electrical gate oxide thickness in meters"),
IOP( "toxp", BSIM4_MOD_TOXP, IF_REAL, "Physical gate oxide thickness in meters"),
IOP( "toxm", BSIM4_MOD_TOXM, IF_REAL, "Gate oxide thickness at which parameters are extracted"),
IOP( "toxref", BSIM4_MOD_TOXREF, IF_REAL, "Target tox value"),
IOP( "dtox", BSIM4_MOD_DTOX, IF_REAL, "Defined as (toxe - toxp) "),
IOP( "epsrox", BSIM4_MOD_EPSROX, IF_REAL, "Dielectric constant of the gate oxide relative to vacuum"),
IOP( "cdsc", BSIM4_MOD_CDSC, IF_REAL, "Drain/Source and channel coupling capacitance"),
IOP( "cdscb", BSIM4_MOD_CDSCB, IF_REAL, "Body-bias dependence of cdsc"), 
IOP( "cdscd", BSIM4_MOD_CDSCD, IF_REAL, "Drain-bias dependence of cdsc"), 
IOP( "cit", BSIM4_MOD_CIT, IF_REAL, "Interface state capacitance"),
IOP( "nfactor", BSIM4_MOD_NFACTOR, IF_REAL, "Subthreshold swing Coefficient"),
IOP( "xj", BSIM4_MOD_XJ, IF_REAL, "Junction depth in meters"),
IOP( "vsat", BSIM4_MOD_VSAT, IF_REAL, "Saturation velocity at tnom"),
IOP( "at", BSIM4_MOD_AT, IF_REAL, "Temperature coefficient of vsat"),
IOP( "a0", BSIM4_MOD_A0, IF_REAL, "Non-uniform depletion width effect coefficient."), 
IOP( "ags", BSIM4_MOD_AGS, IF_REAL, "Gate bias  coefficient of Abulk."), 
IOP( "a1", BSIM4_MOD_A1, IF_REAL, "Non-saturation effect coefficient"),
IOP( "a2", BSIM4_MOD_A2, IF_REAL, "Non-saturation effect coefficient"),
IOP( "keta", BSIM4_MOD_KETA, IF_REAL, "Body-bias coefficient of non-uniform depletion width effect."),
IOP( "phig", BSIM4_MOD_PHIG, IF_REAL, "Work function of gate"),
IOP( "epsrgate", BSIM4_MOD_EPSRGATE, IF_REAL, "Dielectric constant of gate relative to vacuum"),
IOP( "easub",BSIM4_MOD_EASUB, IF_REAL, "Electron affinity of substrate"),
IOP( "epsrsub", BSIM4_MOD_EPSRSUB, IF_REAL, "Dielectric constant of substrate relative to vacuum"),
IOP( "ni0sub", BSIM4_MOD_NI0SUB, IF_REAL, "Intrinsic carrier concentration of substrate at 300.15K"),
IOP( "bg0sub", BSIM4_MOD_BG0SUB, IF_REAL, "Band-gap of substrate at T=0K"),
IOP( "tbgasub", BSIM4_MOD_TBGASUB, IF_REAL, "First parameter of band-gap change due to temperature"),
IOP( "tbgbsub", BSIM4_MOD_TBGBSUB, IF_REAL, "Second parameter of band-gap change due to temperature"),
IOP( "nsub", BSIM4_MOD_NSUB, IF_REAL, "Substrate doping concentration"),
IOP( "ndep", BSIM4_MOD_NDEP, IF_REAL, "Channel doping concentration at the depletion edge"),
IOP( "nsd", BSIM4_MOD_NSD, IF_REAL, "S/D doping concentration"),
IOP( "phin", BSIM4_MOD_PHIN, IF_REAL, "Adjusting parameter for surface potential due to non-uniform vertical doping"),
IOP( "ngate", BSIM4_MOD_NGATE, IF_REAL, "Poly-gate doping concentration"),
IOP( "gamma1", BSIM4_MOD_GAMMA1, IF_REAL, "Vth body coefficient"),
IOP( "gamma2", BSIM4_MOD_GAMMA2, IF_REAL, "Vth body coefficient"),
IOP( "vbx", BSIM4_MOD_VBX, IF_REAL, "Vth transition body Voltage"),
IOP( "vbm", BSIM4_MOD_VBM, IF_REAL, "Maximum body voltage"),

IOP( "xt", BSIM4_MOD_XT, IF_REAL, "Doping depth"),
IOP( "k1", BSIM4_MOD_K1, IF_REAL, "Bulk effect coefficient 1"),
IOP( "kt1", BSIM4_MOD_KT1, IF_REAL, "Temperature coefficient of Vth"),
IOP( "kt1l", BSIM4_MOD_KT1L, IF_REAL, "Temperature coefficient of Vth"),
IOP( "kt2",  BSIM4_MOD_KT2, IF_REAL, "Body-coefficient of kt1"),
IOP( "k2",   BSIM4_MOD_K2,  IF_REAL, "Bulk effect coefficient 2"),
IOP( "k3",   BSIM4_MOD_K3,  IF_REAL, "Narrow width effect coefficient"),
IOP( "k3b",  BSIM4_MOD_K3B, IF_REAL, "Body effect coefficient of k3"),
IOP( "w0",   BSIM4_MOD_W0,  IF_REAL, "Narrow width effect parameter"),
IOP( "dvtp0",  BSIM4_MOD_DVTP0, IF_REAL, "First parameter for Vth shift due to pocket"),
IOP( "dvtp1",  BSIM4_MOD_DVTP1, IF_REAL, "Second parameter for Vth shift due to pocket"),
IOP( "dvtp2",  BSIM4_MOD_DVTP2, IF_REAL, "3rd parameter for Vth shift due to pocket"),
IOP( "dvtp3",  BSIM4_MOD_DVTP3, IF_REAL, "4th parameter for Vth shift due to pocket"),
IOP( "dvtp4",  BSIM4_MOD_DVTP4, IF_REAL, "5th parameter for Vth shift due to pocket"),
IOP( "dvtp5",  BSIM4_MOD_DVTP5, IF_REAL, "6th parameter for Vth shift due to pocket"),
IOP( "lpe0",  BSIM4_MOD_LPE0, IF_REAL, "Equivalent length of pocket region at zero bias"),
IOP( "lpeb",  BSIM4_MOD_LPEB, IF_REAL, "Equivalent length of pocket region accounting for body bias"),
IOP( "dvt0", BSIM4_MOD_DVT0, IF_REAL, "Short channel effect coeff. 0"),
IOP( "dvt1", BSIM4_MOD_DVT1, IF_REAL, "Short channel effect coeff. 1"),
IOP( "dvt2", BSIM4_MOD_DVT2, IF_REAL, "Short channel effect coeff. 2"),
IOP( "dvt0w", BSIM4_MOD_DVT0W, IF_REAL, "Narrow Width coeff. 0"),
IOP( "dvt1w", BSIM4_MOD_DVT1W, IF_REAL, "Narrow Width effect coeff. 1"),
IOP( "dvt2w", BSIM4_MOD_DVT2W, IF_REAL, "Narrow Width effect coeff. 2"),
IOP( "drout", BSIM4_MOD_DROUT, IF_REAL, "DIBL coefficient of output resistance"),
IOP( "dsub", BSIM4_MOD_DSUB, IF_REAL, "DIBL coefficient in the subthreshold region"),
IOP( "vth0", BSIM4_MOD_VTH0, IF_REAL,"Threshold voltage"),
IOPR("vtho", BSIM4_MOD_VTH0, IF_REAL,"Threshold voltage"),
IOP( "ua", BSIM4_MOD_UA, IF_REAL, "Linear gate dependence of mobility"),
IOP( "ua1", BSIM4_MOD_UA1, IF_REAL, "Temperature coefficient of ua"),
IOP( "ub", BSIM4_MOD_UB, IF_REAL, "Quadratic gate dependence of mobility"),
IOP( "ub1", BSIM4_MOD_UB1, IF_REAL, "Temperature coefficient of ub"),
IOP( "uc", BSIM4_MOD_UC, IF_REAL, "Body-bias dependence of mobility"),
IOP( "uc1", BSIM4_MOD_UC1, IF_REAL, "Temperature coefficient of uc"),
IOP( "ud", BSIM4_MOD_UD, IF_REAL, "Coulomb scattering factor of mobility"),
IOP( "ud1", BSIM4_MOD_UD1, IF_REAL, "Temperature coefficient of ud"),
IOP( "up", BSIM4_MOD_UP, IF_REAL, "Channel length linear factor of mobility"),
IOP( "lp", BSIM4_MOD_LP, IF_REAL, "Channel length exponential factor of mobility"),
IOP( "u0", BSIM4_MOD_U0, IF_REAL, "Low-field mobility at Tnom"),
IOP( "eu", BSIM4_MOD_EU, IF_REAL, "Mobility exponent"),
IOP( "ucs", BSIM4_MOD_UCS, IF_REAL, "Colombic scattering exponent"),
IOP( "ute", BSIM4_MOD_UTE, IF_REAL, "Temperature coefficient of mobility"),
IOP( "ucste", BSIM4_MOD_UCSTE, IF_REAL,"Temperature coefficient of colombic mobility"),
IOP( "voff", BSIM4_MOD_VOFF, IF_REAL, "Threshold voltage offset"),
IOP( "minv", BSIM4_MOD_MINV, IF_REAL, "Fitting parameter for moderate inversion in Vgsteff"),
IOP( "minvcv", BSIM4_MOD_MINVCV, IF_REAL, "Fitting parameter for moderate inversion in Vgsteffcv"),
IOP( "voffl", BSIM4_MOD_VOFFL, IF_REAL, "Length dependence parameter for Vth offset"),
IOP( "voffcvl", BSIM4_MOD_VOFFCVL, IF_REAL, "Length dependence parameter for Vth offset in CV"),
IOP( "tnom", BSIM4_MOD_TNOM, IF_REAL, "Parameter measurement temperature"),
IOP( "cgso", BSIM4_MOD_CGSO, IF_REAL, "Gate-source overlap capacitance per width"),
IOP( "cgdo", BSIM4_MOD_CGDO, IF_REAL, "Gate-drain overlap capacitance per width"),
IOP( "cgbo", BSIM4_MOD_CGBO, IF_REAL, "Gate-bulk overlap capacitance per length"),
IOP( "xpart", BSIM4_MOD_XPART, IF_REAL, "Channel charge partitioning"),
IOP( "delta", BSIM4_MOD_DELTA, IF_REAL, "Effective Vds parameter"),
IOP( "rsh", BSIM4_MOD_RSH, IF_REAL, "Source-drain sheet resistance"),
IOP( "rdsw", BSIM4_MOD_RDSW, IF_REAL, "Source-drain resistance per width"),    
IOP( "rdswmin", BSIM4_MOD_RDSWMIN, IF_REAL, "Source-drain resistance per width at high Vg"),
IOP( "rsw", BSIM4_MOD_RSW, IF_REAL, "Source resistance per width"),
IOP( "rdw", BSIM4_MOD_RDW, IF_REAL, "Drain resistance per width"),
IOP( "rdwmin", BSIM4_MOD_RDWMIN, IF_REAL, "Drain resistance per width at high Vg"),
IOP( "rswmin", BSIM4_MOD_RSWMIN, IF_REAL, "Source resistance per width at high Vg"),

IOP( "prwg", BSIM4_MOD_PRWG, IF_REAL, "Gate-bias effect on parasitic resistance "),    
IOP( "prwb", BSIM4_MOD_PRWB, IF_REAL, "Body-effect on parasitic resistance "),    

IOP( "prt", BSIM4_MOD_PRT, IF_REAL, "Temperature coefficient of parasitic resistance "),    
IOP( "eta0", BSIM4_MOD_ETA0, IF_REAL, "Subthreshold region DIBL coefficient"),
IOP( "etab", BSIM4_MOD_ETAB, IF_REAL, "Subthreshold region DIBL coefficient"),
IOP( "pclm", BSIM4_MOD_PCLM, IF_REAL, "Channel length modulation Coefficient"),
IOP( "pdiblc1", BSIM4_MOD_PDIBL1, IF_REAL, "Drain-induced barrier lowering coefficient"),   
IOP( "pdiblc2", BSIM4_MOD_PDIBL2, IF_REAL, "Drain-induced barrier lowering coefficient"),   
IOP( "pdiblcb", BSIM4_MOD_PDIBLB, IF_REAL, "Body-effect on drain-induced barrier lowering"),   
IOP( "fprout", BSIM4_MOD_FPROUT, IF_REAL, "Rout degradation coefficient for pocket devices"),
IOP( "pdits", BSIM4_MOD_PDITS, IF_REAL, "Coefficient for drain-induced Vth shifts"),
IOP( "pditsl", BSIM4_MOD_PDITSL, IF_REAL, "Length dependence of drain-induced Vth shifts"),
IOP( "pditsd", BSIM4_MOD_PDITSD, IF_REAL, "Vds dependence of drain-induced Vth shifts"),
IOP( "pscbe1", BSIM4_MOD_PSCBE1, IF_REAL, "Substrate current body-effect coefficient"),   
IOP( "pscbe2", BSIM4_MOD_PSCBE2, IF_REAL, "Substrate current body-effect coefficient"),   
IOP( "pvag", BSIM4_MOD_PVAG, IF_REAL, "Gate dependence of output resistance parameter"),   

IOP( "jss", BSIM4_MOD_JSS, IF_REAL, "Bottom source junction reverse saturation current density"),
IOP( "jsws", BSIM4_MOD_JSWS, IF_REAL, "Isolation edge sidewall source junction reverse saturation current density"),
IOP( "jswgs", BSIM4_MOD_JSWGS, IF_REAL, "Gate edge source junction reverse saturation current density"),
IOP( "pbs", BSIM4_MOD_PBS, IF_REAL, "Source junction built-in potential"),
IOP( "njs", BSIM4_MOD_NJS, IF_REAL, "Source junction emission coefficient"),
IOP( "xtis", BSIM4_MOD_XTIS, IF_REAL, "Source junction current temperature exponent"),
IOP( "mjs", BSIM4_MOD_MJS, IF_REAL, "Source bottom junction capacitance grading coefficient"),
IOP( "pbsws", BSIM4_MOD_PBSWS, IF_REAL, "Source sidewall junction capacitance built in potential"),
IOP( "mjsws", BSIM4_MOD_MJSWS, IF_REAL, "Source sidewall junction capacitance grading coefficient"),
IOP( "pbswgs", BSIM4_MOD_PBSWGS, IF_REAL, "Source (gate side) sidewall junction capacitance built in potential"),
IOP( "mjswgs", BSIM4_MOD_MJSWGS, IF_REAL, "Source (gate side) sidewall junction capacitance grading coefficient"),
IOP( "cjs", BSIM4_MOD_CJS, IF_REAL, "Source bottom junction capacitance per unit area"),
IOP( "cjsws", BSIM4_MOD_CJSWS, IF_REAL, "Source sidewall junction capacitance per unit periphery"),
IOP( "cjswgs", BSIM4_MOD_CJSWGS, IF_REAL, "Source (gate side) sidewall junction capacitance per unit width"),

IOP( "jsd", BSIM4_MOD_JSD, IF_REAL, "Bottom drain junction reverse saturation current density"),
IOP( "jswd", BSIM4_MOD_JSWD, IF_REAL, "Isolation edge sidewall drain junction reverse saturation current density"),
IOP( "jswgd", BSIM4_MOD_JSWGD, IF_REAL, "Gate edge drain junction reverse saturation current density"),
IOP( "pbd", BSIM4_MOD_PBD, IF_REAL, "Drain junction built-in potential"),
IOP( "njd", BSIM4_MOD_NJD, IF_REAL, "Drain junction emission coefficient"),
IOP( "xtid", BSIM4_MOD_XTID, IF_REAL, "Drainjunction current temperature exponent"),
IOP( "mjd", BSIM4_MOD_MJD, IF_REAL, "Drain bottom junction capacitance grading coefficient"),
IOP( "pbswd", BSIM4_MOD_PBSWD, IF_REAL, "Drain sidewall junction capacitance built in potential"),
IOP( "mjswd", BSIM4_MOD_MJSWD, IF_REAL, "Drain sidewall junction capacitance grading coefficient"),
IOP( "pbswgd", BSIM4_MOD_PBSWGD, IF_REAL, "Drain (gate side) sidewall junction capacitance built in potential"),
IOP( "mjswgd", BSIM4_MOD_MJSWGD, IF_REAL, "Drain (gate side) sidewall junction capacitance grading coefficient"),
IOP( "cjd", BSIM4_MOD_CJD, IF_REAL, "Drain bottom junction capacitance per unit area"),
IOP( "cjswd", BSIM4_MOD_CJSWD, IF_REAL, "Drain sidewall junction capacitance per unit periphery"),
IOP( "cjswgd", BSIM4_MOD_CJSWGD, IF_REAL, "Drain (gate side) sidewall junction capacitance per unit width"),

IOP( "vfbcv", BSIM4_MOD_VFBCV, IF_REAL, "Flat Band Voltage parameter for capmod=0 only"),
IOP( "vfb", BSIM4_MOD_VFB, IF_REAL, "Flat Band Voltage"),
IOP( "tpb", BSIM4_MOD_TPB, IF_REAL, "Temperature coefficient of pb"),
IOP( "tcj", BSIM4_MOD_TCJ, IF_REAL, "Temperature coefficient of cj"),
IOP( "tpbsw", BSIM4_MOD_TPBSW, IF_REAL, "Temperature coefficient of pbsw"),
IOP( "tcjsw", BSIM4_MOD_TCJSW, IF_REAL, "Temperature coefficient of cjsw"),
IOP( "tpbswg", BSIM4_MOD_TPBSWG, IF_REAL, "Temperature coefficient of pbswg"),
IOP( "tcjswg", BSIM4_MOD_TCJSWG, IF_REAL, "Temperature coefficient of cjswg"),
IOP( "acde", BSIM4_MOD_ACDE, IF_REAL, "Exponential coefficient for finite charge thickness"),
IOP( "moin", BSIM4_MOD_MOIN, IF_REAL, "Coefficient for gate-bias dependent surface potential"),
IOP( "noff", BSIM4_MOD_NOFF, IF_REAL, "C-V turn-on/off parameter"),
IOP( "voffcv", BSIM4_MOD_VOFFCV, IF_REAL, "C-V lateral-shift parameter"),
IOP( "dmcg", BSIM4_MOD_DMCG, IF_REAL, "Distance of Mid-Contact to Gate edge"),
IOP( "dmci", BSIM4_MOD_DMCI, IF_REAL, "Distance of Mid-Contact to Isolation"),
IOP( "dmdg", BSIM4_MOD_DMDG, IF_REAL, "Distance of Mid-Diffusion to Gate edge"),
IOP( "dmcgt", BSIM4_MOD_DMCGT, IF_REAL, "Distance of Mid-Contact to Gate edge in Test structures"),
IOP( "xgw",  BSIM4_MOD_XGW, IF_REAL, "Distance from gate contact center to device edge"),
IOP( "xgl",  BSIM4_MOD_XGL, IF_REAL, "Variation in Ldrawn"),
IOP( "rshg", BSIM4_MOD_RSHG, IF_REAL, "Gate sheet resistance"),
IOP( "ngcon", BSIM4_MOD_NGCON, IF_REAL, "Number of gate contacts"),
IOP( "xrcrg1",  BSIM4_MOD_XRCRG1, IF_REAL, "First fitting parameter the bias-dependent Rg"),
IOP( "xrcrg2",  BSIM4_MOD_XRCRG2, IF_REAL, "Second fitting parameter the bias-dependent Rg"),
IOP( "lambda",  BSIM4_MOD_LAMBDA, IF_REAL, " Velocity overshoot parameter"),
IOP( "vtl",      BSIM4_MOD_VTL,     IF_REAL, " thermal velocity"),
IOP( "lc",     BSIM4_MOD_LC,     IF_REAL, " back scattering parameter"),
IOP( "xn",     BSIM4_MOD_XN,     IF_REAL, " back scattering parameter"),
IOP( "vfbsdoff",     BSIM4_MOD_VFBSDOFF,     IF_REAL, "S/D flatband voltage offset"),
IOP( "tvfbsdoff",     BSIM4_MOD_TVFBSDOFF,     IF_REAL, "Temperature parameter for vfbsdoff"),
IOP( "tvoff",     BSIM4_MOD_TVOFF,     IF_REAL, "Temperature parameter for voff"),
IOP( "tnfactor",     BSIM4_MOD_TNFACTOR,     IF_REAL, "Temperature parameter for nfactor"), /* v4.7 Tanvir*/
IOP( "teta0",     BSIM4_MOD_TETA0,     IF_REAL, "Temperature parameter for eta0"),  /* v4.7 Tanvir*/
IOP( "tvoffcv",     BSIM4_MOD_TVOFFCV,     IF_REAL, "Temperature parameter for tvoffcv"),  /* v4.7 Tanvir*/

IOP( "lintnoi", BSIM4_MOD_LINTNOI, IF_REAL, "lint offset for noise calculation"),
IOP( "lint", BSIM4_MOD_LINT, IF_REAL, "Length reduction parameter"),
IOP( "ll",   BSIM4_MOD_LL, IF_REAL, "Length reduction parameter"),
IOP( "llc",  BSIM4_MOD_LLC, IF_REAL, "Length reduction parameter for CV"),
IOP( "lln",  BSIM4_MOD_LLN, IF_REAL, "Length reduction parameter"),
IOP( "lw",   BSIM4_MOD_LW,  IF_REAL, "Length reduction parameter"),
IOP( "lwc",  BSIM4_MOD_LWC, IF_REAL, "Length reduction parameter for CV"),
IOP( "lwn",  BSIM4_MOD_LWN, IF_REAL, "Length reduction parameter"),
IOP( "lwl",  BSIM4_MOD_LWL, IF_REAL, "Length reduction parameter"),
IOP( "lwlc", BSIM4_MOD_LWLC, IF_REAL, "Length reduction parameter for CV"),
IOP( "lmin", BSIM4_MOD_LMIN, IF_REAL, "Minimum length for the model"),
IOP( "lmax", BSIM4_MOD_LMAX, IF_REAL, "Maximum length for the model"),

IOP( "wr",   BSIM4_MOD_WR, IF_REAL, "Width dependence of rds"),
IOP( "wint", BSIM4_MOD_WINT, IF_REAL, "Width reduction parameter"),
IOP( "dwg",  BSIM4_MOD_DWG, IF_REAL, "Width reduction parameter"),
IOP( "dwb",  BSIM4_MOD_DWB, IF_REAL, "Width reduction parameter"),

IOP( "wl",   BSIM4_MOD_WL, IF_REAL, "Width reduction parameter"),
IOP( "wlc",  BSIM4_MOD_WLC, IF_REAL, "Width reduction parameter for CV"),
IOP( "wln",  BSIM4_MOD_WLN, IF_REAL, "Width reduction parameter"),
IOP( "ww",   BSIM4_MOD_WW, IF_REAL, "Width reduction parameter"),
IOP( "wwc",  BSIM4_MOD_WWC, IF_REAL, "Width reduction parameter for CV"),
IOP( "wwn",  BSIM4_MOD_WWN, IF_REAL, "Width reduction parameter"),
IOP( "wwl",  BSIM4_MOD_WWL, IF_REAL, "Width reduction parameter"),
IOP( "wwlc", BSIM4_MOD_WWLC, IF_REAL, "Width reduction parameter for CV"),
IOP( "wmin", BSIM4_MOD_WMIN, IF_REAL, "Minimum width for the model"),
IOP( "wmax", BSIM4_MOD_WMAX, IF_REAL, "Maximum width for the model"),

IOP( "b0",  BSIM4_MOD_B0, IF_REAL, "Abulk narrow width parameter"),
IOP( "b1",  BSIM4_MOD_B1, IF_REAL, "Abulk narrow width parameter"),

IOP( "cgsl", BSIM4_MOD_CGSL, IF_REAL, "New C-V model parameter"),
IOP( "cgdl", BSIM4_MOD_CGDL, IF_REAL, "New C-V model parameter"),
IOP( "ckappas", BSIM4_MOD_CKAPPAS, IF_REAL, "S/G overlap C-V parameter "),
IOP( "ckappad", BSIM4_MOD_CKAPPAD, IF_REAL, "D/G overlap C-V parameter"),
IOP( "cf",  BSIM4_MOD_CF, IF_REAL, "Fringe capacitance parameter"),
IOP( "clc", BSIM4_MOD_CLC, IF_REAL, "Vdsat parameter for C-V model"),
IOP( "cle", BSIM4_MOD_CLE, IF_REAL, "Vdsat parameter for C-V model"),
IOP( "dwc", BSIM4_MOD_DWC, IF_REAL, "Delta W for C-V model"),
IOP( "dlc", BSIM4_MOD_DLC, IF_REAL, "Delta L for C-V model"),
IOP( "xw", BSIM4_MOD_XW, IF_REAL, "W offset for channel width due to mask/etch effect"),
IOP( "xl", BSIM4_MOD_XL, IF_REAL, "L offset for channel length due to mask/etch effect"),
IOP( "dlcig", BSIM4_MOD_DLCIG, IF_REAL, "Delta L for Ig model"),
IOP( "dlcigd", BSIM4_MOD_DLCIGD, IF_REAL, "Delta L for Ig model drain side"),
IOP( "dwj", BSIM4_MOD_DWJ, IF_REAL, "Delta W for S/D junctions"),

IOP( "alpha0", BSIM4_MOD_ALPHA0, IF_REAL, "substrate current model parameter"),
IOP( "alpha1", BSIM4_MOD_ALPHA1, IF_REAL, "substrate current model parameter"),
IOP( "beta0", BSIM4_MOD_BETA0, IF_REAL, "substrate current model parameter"),

IOP( "agidl", BSIM4_MOD_AGIDL, IF_REAL, "Pre-exponential constant for GIDL"),
IOP( "bgidl", BSIM4_MOD_BGIDL, IF_REAL, "Exponential constant for GIDL"),
IOP( "cgidl", BSIM4_MOD_CGIDL, IF_REAL, "Parameter for body-bias dependence of GIDL"),
IOP( "rgidl", BSIM4_MOD_RGIDL, IF_REAL, "GIDL vg parameter"),	/* v4.7 New GIDL/GISL */ 
IOP( "kgidl", BSIM4_MOD_KGIDL, IF_REAL, "GIDL vb parameter"),   /* v4.7 New GIDL/GISL */
IOP( "fgidl", BSIM4_MOD_FGIDL, IF_REAL, "GIDL vb parameter"),   /* v4.7 New GIDL/GISL */
IOP( "egidl", BSIM4_MOD_EGIDL, IF_REAL, "Fitting parameter for Bandbending"),
IOP( "agisl", BSIM4_MOD_AGISL, IF_REAL, "Pre-exponential constant for GISL"),
IOP( "bgisl", BSIM4_MOD_BGISL, IF_REAL, "Exponential constant for GISL"),
IOP( "cgisl", BSIM4_MOD_CGISL, IF_REAL, "Parameter for body-bias dependence of GISL"),
IOP( "rgisl", BSIM4_MOD_RGISL, IF_REAL, "GISL vg parameter"),	/* v4.7 New GIDL/GISL */ 
IOP( "kgisl", BSIM4_MOD_KGISL, IF_REAL, "GISL vb parameter"),   /* v4.7 New GIDL/GISL */
IOP( "fgisl", BSIM4_MOD_FGISL, IF_REAL, "GISL vb parameter"),   /* v4.7 New GIDL/GISL */
IOP( "egisl", BSIM4_MOD_EGISL, IF_REAL, "Fitting parameter for Bandbending"),
IOP( "aigc", BSIM4_MOD_AIGC, IF_REAL, "Parameter for Igc"),
IOP( "bigc", BSIM4_MOD_BIGC, IF_REAL, "Parameter for Igc"),
IOP( "cigc", BSIM4_MOD_CIGC, IF_REAL, "Parameter for Igc"),
IOP( "aigsd", BSIM4_MOD_AIGSD, IF_REAL, "Parameter for Igs,d"),
IOP( "bigsd", BSIM4_MOD_BIGSD, IF_REAL, "Parameter for Igs,d"),
IOP( "cigsd", BSIM4_MOD_CIGSD, IF_REAL, "Parameter for Igs,d"),
IOP( "aigs", BSIM4_MOD_AIGS, IF_REAL, "Parameter for Igs"),
IOP( "bigs", BSIM4_MOD_BIGS, IF_REAL, "Parameter for Igs"),
IOP( "cigs", BSIM4_MOD_CIGS, IF_REAL, "Parameter for Igs"),
IOP( "aigd", BSIM4_MOD_AIGD, IF_REAL, "Parameter for Igd"),
IOP( "bigd", BSIM4_MOD_BIGD, IF_REAL, "Parameter for Igd"),
IOP( "cigd", BSIM4_MOD_CIGD, IF_REAL, "Parameter for Igd"),
IOP( "aigbacc", BSIM4_MOD_AIGBACC, IF_REAL, "Parameter for Igb"),
IOP( "bigbacc", BSIM4_MOD_BIGBACC, IF_REAL, "Parameter for Igb"),
IOP( "cigbacc", BSIM4_MOD_CIGBACC, IF_REAL, "Parameter for Igb"),
IOP( "aigbinv", BSIM4_MOD_AIGBINV, IF_REAL, "Parameter for Igb"),
IOP( "bigbinv", BSIM4_MOD_BIGBINV, IF_REAL, "Parameter for Igb"),
IOP( "cigbinv", BSIM4_MOD_CIGBINV, IF_REAL, "Parameter for Igb"),
IOP( "nigc", BSIM4_MOD_NIGC, IF_REAL, "Parameter for Igc slope"),
IOP( "nigbinv", BSIM4_MOD_NIGBINV, IF_REAL, "Parameter for Igbinv slope"),
IOP( "nigbacc", BSIM4_MOD_NIGBACC, IF_REAL, "Parameter for Igbacc slope"),
IOP( "ntox", BSIM4_MOD_NTOX, IF_REAL, "Exponent for Tox ratio"),
IOP( "eigbinv", BSIM4_MOD_EIGBINV, IF_REAL, "Parameter for the Si bandgap for Igbinv"),
IOP( "pigcd", BSIM4_MOD_PIGCD, IF_REAL, "Parameter for Igc partition"),
IOP( "poxedge", BSIM4_MOD_POXEDGE, IF_REAL, "Factor for the gate edge Tox"),

IOP( "ijthdfwd", BSIM4_MOD_IJTHDFWD, IF_REAL, "Forward drain diode forward limiting current"),
IOP( "ijthsfwd", BSIM4_MOD_IJTHSFWD, IF_REAL, "Forward source diode forward limiting current"),
IOP( "ijthdrev", BSIM4_MOD_IJTHDREV, IF_REAL, "Reverse drain diode forward limiting current"),
IOP( "ijthsrev", BSIM4_MOD_IJTHSREV, IF_REAL, "Reverse source diode forward limiting current"),
IOP( "xjbvd", BSIM4_MOD_XJBVD, IF_REAL, "Fitting parameter for drain diode breakdown current"),
IOP( "xjbvs", BSIM4_MOD_XJBVS, IF_REAL, "Fitting parameter for source diode breakdown current"),
IOP( "bvd", BSIM4_MOD_BVD, IF_REAL, "Drain diode breakdown voltage"),
IOP( "bvs", BSIM4_MOD_BVS, IF_REAL, "Source diode breakdown voltage"),

IOP( "jtss", BSIM4_MOD_JTSS, IF_REAL, "Source bottom trap-assisted saturation current density"),
IOP( "jtsd", BSIM4_MOD_JTSD, IF_REAL, "Drain bottom trap-assisted saturation current density"),
IOP( "jtssws", BSIM4_MOD_JTSSWS, IF_REAL, "Source STI sidewall trap-assisted saturation current density"),
IOP( "jtsswd", BSIM4_MOD_JTSSWD, IF_REAL, "Drain STI sidewall trap-assisted saturation current density"),
IOP( "jtsswgs", BSIM4_MOD_JTSSWGS, IF_REAL, "Source gate-edge sidewall trap-assisted saturation current density"),
IOP( "jtsswgd", BSIM4_MOD_JTSSWGD, IF_REAL, "Drain gate-edge sidewall trap-assisted saturation current density"),
IOP( "jtweff", BSIM4_MOD_JTWEFF, IF_REAL, "TAT current width dependence"),
IOP( "njts", BSIM4_MOD_NJTS, IF_REAL, "Non-ideality factor for bottom junction"),
IOP( "njtssw", BSIM4_MOD_NJTSSW, IF_REAL, "Non-ideality factor for STI sidewall junction"),
IOP( "njtsswg", BSIM4_MOD_NJTSSWG, IF_REAL, "Non-ideality factor for gate-edge sidewall junction"),
IOP( "njtsd", BSIM4_MOD_NJTSD, IF_REAL, "Non-ideality factor for bottom junction drain side"),
IOP( "njtsswd", BSIM4_MOD_NJTSSWD, IF_REAL, "Non-ideality factor for STI sidewall junction drain side"),
IOP( "njtsswgd", BSIM4_MOD_NJTSSWGD, IF_REAL, "Non-ideality factor for gate-edge sidewall junction drain side"),
IOP( "xtss", BSIM4_MOD_XTSS, IF_REAL, "Power dependence of JTSS on temperature"),
IOP( "xtsd", BSIM4_MOD_XTSD, IF_REAL, "Power dependence of JTSD on temperature"),
IOP( "xtssws", BSIM4_MOD_XTSSWS, IF_REAL, "Power dependence of JTSSWS on temperature"),
IOP( "xtsswd", BSIM4_MOD_XTSSWD, IF_REAL, "Power dependence of JTSSWD on temperature"),
IOP( "xtsswgs", BSIM4_MOD_XTSSWGS, IF_REAL, "Power dependence of JTSSWGS on temperature"),
IOP( "xtsswgd", BSIM4_MOD_XTSSWGD, IF_REAL, "Power dependence of JTSSWGD on temperature"),
IOP( "tnjts", BSIM4_MOD_TNJTS, IF_REAL, "Temperature coefficient for NJTS"),
IOP( "tnjtssw", BSIM4_MOD_TNJTSSW, IF_REAL, "Temperature coefficient for NJTSSW"),
IOP( "tnjtsswg", BSIM4_MOD_TNJTSSWG, IF_REAL, "Temperature coefficient for NJTSSWG"),
IOP( "tnjtsd", BSIM4_MOD_TNJTSD, IF_REAL, "Temperature coefficient for NJTSD"),
IOP( "tnjtsswd", BSIM4_MOD_TNJTSSWD, IF_REAL, "Temperature coefficient for NJTSSWD"),
IOP( "tnjtsswgd", BSIM4_MOD_TNJTSSWGD, IF_REAL, "Temperature coefficient for NJTSSWGD"),
IOP( "vtss", BSIM4_MOD_VTSS, IF_REAL, "Source bottom trap-assisted voltage dependent parameter"),
IOP( "vtsd", BSIM4_MOD_VTSD, IF_REAL, "Drain bottom trap-assisted voltage dependent parameter"),
IOP( "vtssws", BSIM4_MOD_VTSSWS, IF_REAL, "Source STI sidewall trap-assisted voltage dependent parameter"),
IOP( "vtsswd", BSIM4_MOD_VTSSWD, IF_REAL, "Drain STI sidewall trap-assisted voltage dependent parameter"),
IOP( "vtsswgs", BSIM4_MOD_VTSSWGS, IF_REAL, "Source gate-edge sidewall trap-assisted voltage dependent parameter"),
IOP( "vtsswgd", BSIM4_MOD_VTSSWGD, IF_REAL, "Drain gate-edge sidewall trap-assisted voltage dependent parameter"),

IOP( "gbmin", BSIM4_MOD_GBMIN, IF_REAL, "Minimum body conductance"),
IOP( "rbdb", BSIM4_MOD_RBDB, IF_REAL, "Resistance between bNode and dbNode"),
IOP( "rbpb", BSIM4_MOD_RBPB, IF_REAL, "Resistance between bNodePrime and bNode"),
IOP( "rbsb", BSIM4_MOD_RBSB, IF_REAL, "Resistance between bNode and sbNode"),
IOP( "rbps", BSIM4_MOD_RBPS, IF_REAL, "Resistance between bNodePrime and sbNode"),
IOP( "rbpd", BSIM4_MOD_RBPD, IF_REAL, "Resistance between bNodePrime and bNode"),

IOP( "rbps0",  BSIM4_MOD_RBPS0,   IF_REAL   , "Body resistance RBPS scaling"),
IOP( "rbpsl",  BSIM4_MOD_RBPSL,   IF_REAL   , "Body resistance RBPS L scaling"),
IOP( "rbpsw",  BSIM4_MOD_RBPSW,   IF_REAL   , "Body resistance RBPS W scaling"),
IOP( "rbpsnf", BSIM4_MOD_RBPSNF,  IF_REAL   , "Body resistance RBPS NF scaling"),

IOP( "rbpd0",  BSIM4_MOD_RBPD0,   IF_REAL   , "Body resistance RBPD scaling"),
IOP( "rbpdl",  BSIM4_MOD_RBPDL,   IF_REAL   , "Body resistance RBPD L scaling"),
IOP( "rbpdw",  BSIM4_MOD_RBPDW,   IF_REAL   , "Body resistance RBPD W scaling"),
IOP( "rbpdnf", BSIM4_MOD_RBPDNF,  IF_REAL   , "Body resistance RBPD NF scaling"),

IOP( "rbpbx0", BSIM4_MOD_RBPBX0,  IF_REAL   , "Body resistance RBPBX  scaling"),
IOP( "rbpbxl", BSIM4_MOD_RBPBXL,  IF_REAL   , "Body resistance RBPBX L scaling"),
IOP( "rbpbxw", BSIM4_MOD_RBPBXW,  IF_REAL   , "Body resistance RBPBX W scaling"),
IOP( "rbpbxnf", BSIM4_MOD_RBPBXNF, IF_REAL   , "Body resistance RBPBX NF scaling"),
IOP( "rbpby0", BSIM4_MOD_RBPBY0,  IF_REAL   , "Body resistance RBPBY  scaling"),
IOP( "rbpbyl", BSIM4_MOD_RBPBYL,  IF_REAL   , "Body resistance RBPBY L scaling"),
IOP( "rbpbyw", BSIM4_MOD_RBPBYW,  IF_REAL   , "Body resistance RBPBY W scaling"),
IOP( "rbpbynf", BSIM4_MOD_RBPBYNF, IF_REAL   , "Body resistance RBPBY NF scaling"),

IOP( "rbsbx0", BSIM4_MOD_RBSBX0,  IF_REAL   , "Body resistance RBSBX  scaling"),
IOP( "rbsby0", BSIM4_MOD_RBSBY0,  IF_REAL   , "Body resistance RBSBY  scaling"),
IOP( "rbdbx0", BSIM4_MOD_RBDBX0,  IF_REAL   , "Body resistance RBDBX  scaling"),
IOP( "rbdby0", BSIM4_MOD_RBDBY0,  IF_REAL   , "Body resistance RBDBY  scaling"),

IOP( "rbsdbxl",  BSIM4_MOD_RBSDBXL,   IF_REAL   , "Body resistance RBSDBX L scaling"),
IOP( "rbsdbxw",  BSIM4_MOD_RBSDBXW,   IF_REAL   , "Body resistance RBSDBX W scaling"),
IOP( "rbsdbxnf", BSIM4_MOD_RBSDBXNF,  IF_REAL   , "Body resistance RBSDBX NF scaling"),
IOP( "rbsdbyl",  BSIM4_MOD_RBSDBYL,   IF_REAL   , "Body resistance RBSDBY L scaling"),
IOP( "rbsdbyw",  BSIM4_MOD_RBSDBYW,   IF_REAL   , "Body resistance RBSDBY W scaling"),
IOP( "rbsdbynf", BSIM4_MOD_RBSDBYNF,  IF_REAL   , "Body resistance RBSDBY NF scaling"),

IOP( "lcdsc",  BSIM4_MOD_LCDSC, IF_REAL, "Length dependence of cdsc"),
IOP( "lcdscb", BSIM4_MOD_LCDSCB, IF_REAL, "Length dependence of cdscb"),
IOP( "lcdscd", BSIM4_MOD_LCDSCD, IF_REAL, "Length dependence of cdscd"),
IOP( "lcit",   BSIM4_MOD_LCIT,  IF_REAL, "Length dependence of cit"),
IOP( "lnfactor", BSIM4_MOD_LNFACTOR, IF_REAL, "Length dependence of nfactor"),
IOP( "lxj", BSIM4_MOD_LXJ, IF_REAL, "Length dependence of xj"),
IOP( "lvsat", BSIM4_MOD_LVSAT, IF_REAL, "Length dependence of vsat"),
IOP( "lat", BSIM4_MOD_LAT, IF_REAL, "Length dependence of at"),
IOP( "la0", BSIM4_MOD_LA0, IF_REAL, "Length dependence of a0"), 
IOP( "lags", BSIM4_MOD_LAGS, IF_REAL, "Length dependence of ags"), 
IOP( "la1", BSIM4_MOD_LA1, IF_REAL, "Length dependence of a1"),
IOP( "la2", BSIM4_MOD_LA2, IF_REAL, "Length dependence of a2"),
IOP( "lketa", BSIM4_MOD_LKETA, IF_REAL, "Length dependence of keta"),
IOP( "lnsub", BSIM4_MOD_LNSUB, IF_REAL, "Length dependence of nsub"),
IOP( "lndep",  BSIM4_MOD_LNDEP, IF_REAL, "Length dependence of ndep"),
IOP( "lnsd",  BSIM4_MOD_LNSD, IF_REAL, "Length dependence of nsd"),
IOP( "lphin", BSIM4_MOD_LPHIN, IF_REAL, "Length dependence of phin"),
IOP( "lngate", BSIM4_MOD_LNGATE, IF_REAL, "Length dependence of ngate"),
IOP( "lgamma1", BSIM4_MOD_LGAMMA1, IF_REAL, "Length dependence of gamma1"),
IOP( "lgamma2", BSIM4_MOD_LGAMMA2, IF_REAL, "Length dependence of gamma2"),
IOP( "lvbx", BSIM4_MOD_LVBX, IF_REAL, "Length dependence of vbx"),
IOP( "lvbm", BSIM4_MOD_LVBM, IF_REAL, "Length dependence of vbm"),
IOP( "lxt",  BSIM4_MOD_LXT,  IF_REAL, "Length dependence of xt"),
IOP( "lk1",   BSIM4_MOD_LK1,  IF_REAL, "Length dependence of k1"),
IOP( "lkt1",  BSIM4_MOD_LKT1, IF_REAL, "Length dependence of kt1"),
IOP( "lkt1l", BSIM4_MOD_LKT1L, IF_REAL, "Length dependence of kt1l"),
IOP( "lkt2",  BSIM4_MOD_LKT2, IF_REAL, "Length dependence of kt2"),
IOP( "lk2",   BSIM4_MOD_LK2,  IF_REAL, "Length dependence of k2"),
IOP( "lk3",   BSIM4_MOD_LK3,  IF_REAL, "Length dependence of k3"),
IOP( "lk3b",  BSIM4_MOD_LK3B, IF_REAL, "Length dependence of k3b"),
IOP( "lw0",   BSIM4_MOD_LW0,  IF_REAL, "Length dependence of w0"),
IOP( "ldvtp0",  BSIM4_MOD_LDVTP0, IF_REAL, "Length dependence of dvtp0"),
IOP( "ldvtp1",  BSIM4_MOD_LDVTP1, IF_REAL, "Length dependence of dvtp1"),
IOP( "ldvtp2",  BSIM4_MOD_LDVTP2, IF_REAL, "Length dependence of dvtp2"),
IOP( "ldvtp3",  BSIM4_MOD_LDVTP3, IF_REAL, "Length dependence of dvtp3"),
IOP( "ldvtp4",  BSIM4_MOD_LDVTP4, IF_REAL, "Length dependence of dvtp4"),
IOP( "ldvtp5",  BSIM4_MOD_LDVTP5, IF_REAL, "Length dependence of dvtp5"),
IOP( "llpe0",  BSIM4_MOD_LLPE0, IF_REAL, "Length dependence of lpe0"),
IOP( "llpeb",  BSIM4_MOD_LLPEB, IF_REAL, "Length dependence of lpeb"),
IOP( "ldvt0", BSIM4_MOD_LDVT0, IF_REAL, "Length dependence of dvt0"),
IOP( "ldvt1", BSIM4_MOD_LDVT1, IF_REAL, "Length dependence of dvt1"),
IOP( "ldvt2", BSIM4_MOD_LDVT2, IF_REAL, "Length dependence of dvt2"),
IOP( "ldvt0w", BSIM4_MOD_LDVT0W, IF_REAL, "Length dependence of dvt0w"),
IOP( "ldvt1w", BSIM4_MOD_LDVT1W, IF_REAL, "Length dependence of dvt1w"),
IOP( "ldvt2w", BSIM4_MOD_LDVT2W, IF_REAL, "Length dependence of dvt2w"),
IOP( "ldrout", BSIM4_MOD_LDROUT, IF_REAL, "Length dependence of drout"),
IOP( "ldsub", BSIM4_MOD_LDSUB, IF_REAL, "Length dependence of dsub"),
IOP( "lvth0", BSIM4_MOD_LVTH0, IF_REAL,"Length dependence of vth0"),
IOPR("lvtho", BSIM4_MOD_LVTH0, IF_REAL,"Length dependence of vtho"),
IOP( "lua",  BSIM4_MOD_LUA, IF_REAL, "Length dependence of ua"),
IOP( "lua1", BSIM4_MOD_LUA1, IF_REAL, "Length dependence of ua1"),
IOP( "lub", BSIM4_MOD_LUB, IF_REAL, "Length dependence of ub"),
IOP( "lub1", BSIM4_MOD_LUB1, IF_REAL, "Length dependence of ub1"),
IOP( "luc",  BSIM4_MOD_LUC, IF_REAL, "Length dependence of uc"),
IOP( "luc1", BSIM4_MOD_LUC1, IF_REAL, "Length dependence of uc1"),
IOP( "lud",  BSIM4_MOD_LUD, IF_REAL, "Length dependence of ud"),
IOP( "lud1", BSIM4_MOD_LUD1, IF_REAL, "Length dependence of ud1"),
IOP( "lup",  BSIM4_MOD_LUP, IF_REAL, "Length dependence of up"),
IOP( "llp",  BSIM4_MOD_LLP, IF_REAL, "Length dependence of lp"),
IOP( "lu0",  BSIM4_MOD_LU0, IF_REAL, "Length dependence of u0"),
IOP( "lute", BSIM4_MOD_LUTE, IF_REAL, "Length dependence of ute"),
IOP( "lucste", BSIM4_MOD_LUCSTE, IF_REAL, "Length dependence of ucste"),
IOP( "lvoff", BSIM4_MOD_LVOFF, IF_REAL, "Length dependence of voff"),
IOP( "lminv", BSIM4_MOD_LMINV, IF_REAL, "Length dependence of minv"),
IOP( "lminvcv", BSIM4_MOD_LMINVCV, IF_REAL, "Length dependence of minvcv"),
IOP( "ldelta", BSIM4_MOD_LDELTA, IF_REAL, "Length dependence of delta"),
IOP( "lrdsw", BSIM4_MOD_LRDSW,  IF_REAL, "Length dependence of rdsw "),    
IOP( "lrsw", BSIM4_MOD_LRSW, IF_REAL, "Length dependence of rsw"),
IOP( "lrdw", BSIM4_MOD_LRDW, IF_REAL, "Length dependence of rdw"),

IOP( "lprwg", BSIM4_MOD_LPRWG,  IF_REAL, "Length dependence of prwg "),    
IOP( "lprwb", BSIM4_MOD_LPRWB,  IF_REAL, "Length dependence of prwb "),    

IOP( "lprt", BSIM4_MOD_LPRT, IF_REAL, "Length dependence of prt "),    
IOP( "leta0", BSIM4_MOD_LETA0, IF_REAL, "Length dependence of eta0"),   
IOP( "letab", BSIM4_MOD_LETAB, IF_REAL, "Length dependence of etab"),   
IOP( "lpclm", BSIM4_MOD_LPCLM, IF_REAL, "Length dependence of pclm"),   
IOP( "lpdiblc1", BSIM4_MOD_LPDIBL1, IF_REAL, "Length dependence of pdiblc1"),   
IOP( "lpdiblc2", BSIM4_MOD_LPDIBL2, IF_REAL, "Length dependence of pdiblc2"),   
IOP( "lpdiblcb", BSIM4_MOD_LPDIBLB, IF_REAL, "Length dependence of pdiblcb"),   
IOP( "lfprout", BSIM4_MOD_LFPROUT, IF_REAL, "Length dependence of pdiblcb"),
IOP( "lpdits", BSIM4_MOD_LPDITS, IF_REAL, "Length dependence of pdits"),
IOP( "lpditsd", BSIM4_MOD_LPDITSD, IF_REAL, "Length dependence of pditsd"),
IOP( "lpscbe1",  BSIM4_MOD_LPSCBE1, IF_REAL, "Length dependence of pscbe1"),   
IOP( "lpscbe2",  BSIM4_MOD_LPSCBE2, IF_REAL, "Length dependence of pscbe2"),   
IOP( "lpvag", BSIM4_MOD_LPVAG, IF_REAL, "Length dependence of pvag"),   
IOP( "lwr",  BSIM4_MOD_LWR, IF_REAL, "Length dependence of wr"),
IOP( "ldwg", BSIM4_MOD_LDWG, IF_REAL, "Length dependence of dwg"),
IOP( "ldwb", BSIM4_MOD_LDWB, IF_REAL, "Length dependence of dwb"),
IOP( "lb0",  BSIM4_MOD_LB0, IF_REAL, "Length dependence of b0"),
IOP( "lb1",  BSIM4_MOD_LB1, IF_REAL, "Length dependence of b1"),
IOP( "lcgsl", BSIM4_MOD_LCGSL, IF_REAL, "Length dependence of cgsl"),
IOP( "lcgdl", BSIM4_MOD_LCGDL, IF_REAL, "Length dependence of cgdl"),
IOP( "lckappas", BSIM4_MOD_LCKAPPAS, IF_REAL, "Length dependence of ckappas"),
IOP( "lckappad", BSIM4_MOD_LCKAPPAD, IF_REAL, "Length dependence of ckappad"),
IOP( "lcf",  BSIM4_MOD_LCF,  IF_REAL, "Length dependence of cf"),
IOP( "lclc", BSIM4_MOD_LCLC, IF_REAL, "Length dependence of clc"),
IOP( "lcle", BSIM4_MOD_LCLE, IF_REAL, "Length dependence of cle"),
IOP( "lalpha0", BSIM4_MOD_LALPHA0, IF_REAL, "Length dependence of alpha0"),
IOP( "lalpha1", BSIM4_MOD_LALPHA1, IF_REAL, "Length dependence of alpha1"),
IOP( "lbeta0", BSIM4_MOD_LBETA0, IF_REAL, "Length dependence of beta0"),

IOP( "lagidl", BSIM4_MOD_LAGIDL, IF_REAL, "Length dependence of agidl"),
IOP( "lbgidl", BSIM4_MOD_LBGIDL, IF_REAL, "Length dependence of bgidl"),
IOP( "lcgidl", BSIM4_MOD_LCGIDL, IF_REAL, "Length dependence of cgidl"),
IOP( "lrgidl", BSIM4_MOD_LRGIDL, IF_REAL, "Length dependence of rgidl"),	/* v4.7 New GIDL/GISL */
IOP( "lkgidl", BSIM4_MOD_LKGIDL, IF_REAL, "Length dependence of kgidl"),	/* v4.7 New GIDL/GISL */
IOP( "lfgidl", BSIM4_MOD_LFGIDL, IF_REAL, "Length dependence of fgidl"),	/* v4.7 New GIDL/GISL */
IOP( "legidl", BSIM4_MOD_LEGIDL, IF_REAL, "Length dependence of egidl"),
IOP( "lagisl", BSIM4_MOD_LAGISL, IF_REAL, "Length dependence of agisl"),
IOP( "lbgisl", BSIM4_MOD_LBGISL, IF_REAL, "Length dependence of bgisl"),
IOP( "lcgisl", BSIM4_MOD_LCGISL, IF_REAL, "Length dependence of cgisl"),
IOP( "lrgisl", BSIM4_MOD_LRGISL, IF_REAL, "Length dependence of rgisl"),	/* v4.7 New GIDL/GISL */
IOP( "lkgisl", BSIM4_MOD_LKGISL, IF_REAL, "Length dependence of kgisl"),	/* v4.7 New GIDL/GISL */
IOP( "lfgisl", BSIM4_MOD_LFGISL, IF_REAL, "Length dependence of fgisl"),	/* v4.7 New GIDL/GISL */
IOP( "legisl", BSIM4_MOD_LEGISL, IF_REAL, "Length dependence of egisl"),
IOP( "laigc", BSIM4_MOD_LAIGC, IF_REAL, "Length dependence of aigc"),
IOP( "lbigc", BSIM4_MOD_LBIGC, IF_REAL, "Length dependence of bigc"),
IOP( "lcigc", BSIM4_MOD_LCIGC, IF_REAL, "Length dependence of cigc"),
IOP( "laigsd", BSIM4_MOD_LAIGSD, IF_REAL, "Length dependence of aigsd"),
IOP( "lbigsd", BSIM4_MOD_LBIGSD, IF_REAL, "Length dependence of bigsd"),
IOP( "lcigsd", BSIM4_MOD_LCIGSD, IF_REAL, "Length dependence of cigsd"),
IOP( "laigs", BSIM4_MOD_LAIGS, IF_REAL, "Length dependence of aigs"),
IOP( "lbigs", BSIM4_MOD_LBIGS, IF_REAL, "Length dependence of bigs"),
IOP( "lcigs", BSIM4_MOD_LCIGS, IF_REAL, "Length dependence of cigs"),
IOP( "laigd", BSIM4_MOD_LAIGD, IF_REAL, "Length dependence of aigd"),
IOP( "lbigd", BSIM4_MOD_LBIGD, IF_REAL, "Length dependence of bigd"),
IOP( "lcigd", BSIM4_MOD_LCIGD, IF_REAL, "Length dependence of cigd"),
IOP( "laigbacc", BSIM4_MOD_LAIGBACC, IF_REAL, "Length dependence of aigbacc"),
IOP( "lbigbacc", BSIM4_MOD_LBIGBACC, IF_REAL, "Length dependence of bigbacc"),
IOP( "lcigbacc", BSIM4_MOD_LCIGBACC, IF_REAL, "Length dependence of cigbacc"),
IOP( "laigbinv", BSIM4_MOD_LAIGBINV, IF_REAL, "Length dependence of aigbinv"),
IOP( "lbigbinv", BSIM4_MOD_LBIGBINV, IF_REAL, "Length dependence of bigbinv"),
IOP( "lcigbinv", BSIM4_MOD_LCIGBINV, IF_REAL, "Length dependence of cigbinv"),
IOP( "lnigc", BSIM4_MOD_LNIGC, IF_REAL, "Length dependence of nigc"),
IOP( "lnigbinv", BSIM4_MOD_LNIGBINV, IF_REAL, "Length dependence of nigbinv"),
IOP( "lnigbacc", BSIM4_MOD_LNIGBACC, IF_REAL, "Length dependence of nigbacc"),
IOP( "lntox", BSIM4_MOD_LNTOX, IF_REAL, "Length dependence of ntox"),
IOP( "leigbinv", BSIM4_MOD_LEIGBINV, IF_REAL, "Length dependence for eigbinv"),
IOP( "lpigcd", BSIM4_MOD_LPIGCD, IF_REAL, "Length dependence for pigcd"),
IOP( "lpoxedge", BSIM4_MOD_LPOXEDGE, IF_REAL, "Length dependence for poxedge"),

IOP( "lvfbcv", BSIM4_MOD_LVFBCV, IF_REAL, "Length dependence of vfbcv"),
IOP( "lvfb", BSIM4_MOD_LVFB, IF_REAL, "Length dependence of vfb"),
IOP( "lacde", BSIM4_MOD_LACDE, IF_REAL, "Length dependence of acde"),
IOP( "lmoin", BSIM4_MOD_LMOIN, IF_REAL, "Length dependence of moin"),
IOP( "lnoff", BSIM4_MOD_LNOFF, IF_REAL, "Length dependence of noff"),
IOP( "lvoffcv", BSIM4_MOD_LVOFFCV, IF_REAL, "Length dependence of voffcv"),
IOP( "lxrcrg1",  BSIM4_MOD_LXRCRG1, IF_REAL, "Length dependence of xrcrg1"),
IOP( "lxrcrg2",  BSIM4_MOD_LXRCRG2, IF_REAL, "Length dependence of xrcrg2"),
IOP( "llambda",  BSIM4_MOD_LLAMBDA, IF_REAL, "Length dependence of lambda"),
IOP( "lvtl",      BSIM4_MOD_LVTL,     IF_REAL, " Length dependence of vtl"),
IOP( "lxn",     BSIM4_MOD_LXN,    IF_REAL, " Length dependence of xn"),
IOP( "leu",  BSIM4_MOD_LEU, IF_REAL, " Length dependence of eu"),
IOP( "lucs",  BSIM4_MOD_LUCS, IF_REAL, "Length dependence of lucs"),
IOP( "lvfbsdoff",     BSIM4_MOD_LVFBSDOFF,     IF_REAL, "Length dependence of vfbsdoff"),
IOP( "ltvfbsdoff",     BSIM4_MOD_LTVFBSDOFF,     IF_REAL, "Length dependence of tvfbsdoff"),
IOP( "ltvoff",     BSIM4_MOD_LTVOFF,     IF_REAL, "Length dependence of tvoff"),
IOP( "ltnfactor",     BSIM4_MOD_LTNFACTOR,     IF_REAL, "Length dependence of tnfactor"),  /* v4.7 Tanvir*/
IOP( "lteta0",     BSIM4_MOD_LTETA0,     IF_REAL, "Length dependence of teta0"),  /* v4.7 Tanvir*/
IOP( "ltvoffcv",     BSIM4_MOD_LTVOFFCV,     IF_REAL, "Length dependence of tvoffcv"),  /* v4.7 Tanvir*/

IOP( "wcdsc",  BSIM4_MOD_WCDSC, IF_REAL, "Width dependence of cdsc"),
IOP( "wcdscb", BSIM4_MOD_WCDSCB, IF_REAL, "Width dependence of cdscb"),  
IOP( "wcdscd", BSIM4_MOD_WCDSCD, IF_REAL, "Width dependence of cdscd"),  
IOP( "wcit",   BSIM4_MOD_WCIT,  IF_REAL, "Width dependence of cit"),
IOP( "wnfactor", BSIM4_MOD_WNFACTOR, IF_REAL, "Width dependence of nfactor"),
IOP( "wxj", BSIM4_MOD_WXJ, IF_REAL, "Width dependence of xj"),
IOP( "wvsat", BSIM4_MOD_WVSAT, IF_REAL, "Width dependence of vsat"),
IOP( "wat", BSIM4_MOD_WAT, IF_REAL, "Width dependence of at"),
IOP( "wa0", BSIM4_MOD_WA0, IF_REAL, "Width dependence of a0"), 
IOP( "wags", BSIM4_MOD_WAGS, IF_REAL, "Width dependence of ags"), 
IOP( "wa1", BSIM4_MOD_WA1, IF_REAL, "Width dependence of a1"),
IOP( "wa2", BSIM4_MOD_WA2, IF_REAL, "Width dependence of a2"),
IOP( "wketa", BSIM4_MOD_WKETA, IF_REAL, "Width dependence of keta"),
IOP( "wnsub", BSIM4_MOD_WNSUB, IF_REAL, "Width dependence of nsub"),
IOP( "wndep",  BSIM4_MOD_WNDEP, IF_REAL, "Width dependence of ndep"),
IOP( "wnsd",  BSIM4_MOD_WNSD, IF_REAL, "Width dependence of nsd"),
IOP( "wphin", BSIM4_MOD_WPHIN, IF_REAL, "Width dependence of phin"),
IOP( "wngate", BSIM4_MOD_WNGATE, IF_REAL, "Width dependence of ngate"),
IOP( "wgamma1", BSIM4_MOD_WGAMMA1, IF_REAL, "Width dependence of gamma1"),
IOP( "wgamma2", BSIM4_MOD_WGAMMA2, IF_REAL, "Width dependence of gamma2"),
IOP( "wvbx", BSIM4_MOD_WVBX, IF_REAL, "Width dependence of vbx"),
IOP( "wvbm", BSIM4_MOD_WVBM, IF_REAL, "Width dependence of vbm"),
IOP( "wxt",  BSIM4_MOD_WXT,  IF_REAL, "Width dependence of xt"),
IOP( "wk1",   BSIM4_MOD_WK1,  IF_REAL, "Width dependence of k1"),
IOP( "wkt1",  BSIM4_MOD_WKT1, IF_REAL, "Width dependence of kt1"),
IOP( "wkt1l", BSIM4_MOD_WKT1L, IF_REAL, "Width dependence of kt1l"),
IOP( "wkt2",  BSIM4_MOD_WKT2, IF_REAL, "Width dependence of kt2"),
IOP( "wk2",   BSIM4_MOD_WK2,  IF_REAL, "Width dependence of k2"),
IOP( "wk3",   BSIM4_MOD_WK3,  IF_REAL, "Width dependence of k3"),
IOP( "wk3b",  BSIM4_MOD_WK3B, IF_REAL, "Width dependence of k3b"),
IOP( "ww0",   BSIM4_MOD_WW0,  IF_REAL, "Width dependence of w0"),
IOP( "wdvtp0",  BSIM4_MOD_WDVTP0, IF_REAL, "Width dependence of dvtp0"),
IOP( "wdvtp1",  BSIM4_MOD_WDVTP1, IF_REAL, "Width dependence of dvtp1"),
IOP( "wdvtp2",  BSIM4_MOD_WDVTP2, IF_REAL, "Width dependence of dvtp2"),
IOP( "wdvtp3",  BSIM4_MOD_WDVTP3, IF_REAL, "Width dependence of dvtp3"),
IOP( "wdvtp4",  BSIM4_MOD_WDVTP4, IF_REAL, "Width dependence of dvtp4"),
IOP( "wdvtp5",  BSIM4_MOD_WDVTP5, IF_REAL, "Width dependence of dvtp5"),
IOP( "wlpe0",  BSIM4_MOD_WLPE0, IF_REAL, "Width dependence of lpe0"),
IOP( "wlpeb",  BSIM4_MOD_WLPEB, IF_REAL, "Width dependence of lpeb"),
IOP( "wdvt0", BSIM4_MOD_WDVT0, IF_REAL, "Width dependence of dvt0"),
IOP( "wdvt1", BSIM4_MOD_WDVT1, IF_REAL, "Width dependence of dvt1"),
IOP( "wdvt2", BSIM4_MOD_WDVT2, IF_REAL, "Width dependence of dvt2"),
IOP( "wdvt0w", BSIM4_MOD_WDVT0W, IF_REAL, "Width dependence of dvt0w"),
IOP( "wdvt1w", BSIM4_MOD_WDVT1W, IF_REAL, "Width dependence of dvt1w"),
IOP( "wdvt2w", BSIM4_MOD_WDVT2W, IF_REAL, "Width dependence of dvt2w"),
IOP( "wdrout", BSIM4_MOD_WDROUT, IF_REAL, "Width dependence of drout"),
IOP( "wdsub", BSIM4_MOD_WDSUB, IF_REAL, "Width dependence of dsub"),
IOP( "wvth0", BSIM4_MOD_WVTH0, IF_REAL,"Width dependence of vth0"),
IOPR("wvtho", BSIM4_MOD_WVTH0, IF_REAL,"Width dependence of vtho"),
IOP( "wua",  BSIM4_MOD_WUA, IF_REAL, "Width dependence of ua"),
IOP( "wua1", BSIM4_MOD_WUA1, IF_REAL, "Width dependence of ua1"),
IOP( "wub", BSIM4_MOD_WUB, IF_REAL, "Width dependence of ub"),
IOP( "wub1", BSIM4_MOD_WUB1, IF_REAL, "Width dependence of ub1"),
IOP( "wuc",  BSIM4_MOD_WUC, IF_REAL, "Width dependence of uc"),
IOP( "wuc1", BSIM4_MOD_WUC1, IF_REAL, "Width dependence of uc1"),
IOP( "wud",  BSIM4_MOD_WUD, IF_REAL, "Width dependence of ud"),
IOP( "wud1", BSIM4_MOD_WUD1, IF_REAL, "Width dependence of ud1"),
IOP( "wup",  BSIM4_MOD_WUP, IF_REAL, "Width dependence of up"),
IOP( "wlp",  BSIM4_MOD_WLP, IF_REAL, "Width dependence of lp"),
IOP( "wu0",  BSIM4_MOD_WU0, IF_REAL, "Width dependence of u0"),
IOP( "wute", BSIM4_MOD_WUTE, IF_REAL, "Width dependence of ute"),
IOP( "wucste", BSIM4_MOD_WUCSTE, IF_REAL, "Width dependence of ucste"),
IOP( "wvoff", BSIM4_MOD_WVOFF, IF_REAL, "Width dependence of voff"),
IOP( "wminv", BSIM4_MOD_WMINV, IF_REAL, "Width dependence of minv"),
IOP( "wminvcv", BSIM4_MOD_WMINVCV, IF_REAL, "Width dependence of minvcv"),
IOP( "wdelta", BSIM4_MOD_WDELTA, IF_REAL, "Width dependence of delta"),
IOP( "wrdsw", BSIM4_MOD_WRDSW,  IF_REAL, "Width dependence of rdsw "),
IOP( "wrsw", BSIM4_MOD_WRSW, IF_REAL, "Width dependence of rsw"),
IOP( "wrdw", BSIM4_MOD_WRDW, IF_REAL, "Width dependence of rdw"),

IOP( "wprwg", BSIM4_MOD_WPRWG,  IF_REAL, "Width dependence of prwg "),
IOP( "wprwb", BSIM4_MOD_WPRWB,  IF_REAL, "Width dependence of prwb "),

IOP( "wprt", BSIM4_MOD_WPRT, IF_REAL, "Width dependence of prt"),
IOP( "weta0", BSIM4_MOD_WETA0, IF_REAL, "Width dependence of eta0"),   
IOP( "wetab", BSIM4_MOD_WETAB, IF_REAL, "Width dependence of etab"),   
IOP( "wpclm", BSIM4_MOD_WPCLM, IF_REAL, "Width dependence of pclm"),   
IOP( "wpdiblc1", BSIM4_MOD_WPDIBL1, IF_REAL, "Width dependence of pdiblc1"),   
IOP( "wpdiblc2", BSIM4_MOD_WPDIBL2, IF_REAL, "Width dependence of pdiblc2"),   
IOP( "wpdiblcb", BSIM4_MOD_WPDIBLB, IF_REAL, "Width dependence of pdiblcb"),   
IOP( "wfprout", BSIM4_MOD_WFPROUT, IF_REAL, "Width dependence of pdiblcb"),
IOP( "wpdits", BSIM4_MOD_WPDITS, IF_REAL, "Width dependence of pdits"),
IOP( "wpditsd", BSIM4_MOD_WPDITSD, IF_REAL, "Width dependence of pditsd"),
IOP( "wpscbe1",  BSIM4_MOD_WPSCBE1, IF_REAL, "Width dependence of pscbe1"),   
IOP( "wpscbe2",  BSIM4_MOD_WPSCBE2, IF_REAL, "Width dependence of pscbe2"),   
IOP( "wpvag", BSIM4_MOD_WPVAG, IF_REAL, "Width dependence of pvag"),   
IOP( "wwr",  BSIM4_MOD_WWR, IF_REAL, "Width dependence of wr"),
IOP( "wdwg", BSIM4_MOD_WDWG, IF_REAL, "Width dependence of dwg"),
IOP( "wdwb", BSIM4_MOD_WDWB, IF_REAL, "Width dependence of dwb"),
IOP( "wb0",  BSIM4_MOD_WB0, IF_REAL, "Width dependence of b0"),
IOP( "wb1",  BSIM4_MOD_WB1, IF_REAL, "Width dependence of b1"),
IOP( "wcgsl", BSIM4_MOD_WCGSL, IF_REAL, "Width dependence of cgsl"),
IOP( "wcgdl", BSIM4_MOD_WCGDL, IF_REAL, "Width dependence of cgdl"),
IOP( "wckappas", BSIM4_MOD_WCKAPPAS, IF_REAL, "Width dependence of ckappas"),
IOP( "wckappad", BSIM4_MOD_WCKAPPAD, IF_REAL, "Width dependence of ckappad"),
IOP( "wcf",  BSIM4_MOD_WCF,  IF_REAL, "Width dependence of cf"),
IOP( "wclc", BSIM4_MOD_WCLC, IF_REAL, "Width dependence of clc"),
IOP( "wcle", BSIM4_MOD_WCLE, IF_REAL, "Width dependence of cle"),
IOP( "walpha0", BSIM4_MOD_WALPHA0, IF_REAL, "Width dependence of alpha0"),
IOP( "walpha1", BSIM4_MOD_WALPHA1, IF_REAL, "Width dependence of alpha1"),
IOP( "wbeta0", BSIM4_MOD_WBETA0, IF_REAL, "Width dependence of beta0"),

IOP( "wagidl", BSIM4_MOD_WAGIDL, IF_REAL, "Width dependence of agidl"),
IOP( "wbgidl", BSIM4_MOD_WBGIDL, IF_REAL, "Width dependence of bgidl"),
IOP( "wcgidl", BSIM4_MOD_WCGIDL, IF_REAL, "Width dependence of cgidl"),
IOP( "wrgidl", BSIM4_MOD_WRGIDL, IF_REAL, "Width dependence of rgidl"),		/* v4.7 New GIDL/GISL */
IOP( "wkgidl", BSIM4_MOD_WKGIDL, IF_REAL, "Width dependence of kgidl"),		/* v4.7 New GIDL/GISL */
IOP( "wfgidl", BSIM4_MOD_WFGIDL, IF_REAL, "Width dependence of fgidl"),		/* v4.7 New GIDL/GISL */
IOP( "wegidl", BSIM4_MOD_WEGIDL, IF_REAL, "Width dependence of egidl"),
IOP( "wagisl", BSIM4_MOD_WAGISL, IF_REAL, "Width dependence of agisl"),
IOP( "wbgisl", BSIM4_MOD_WBGISL, IF_REAL, "Width dependence of bgisl"),
IOP( "wcgisl", BSIM4_MOD_WCGISL, IF_REAL, "Width dependence of cgisl"),
IOP( "wrgisl", BSIM4_MOD_WRGISL, IF_REAL, "Width dependence of rgisl"),		/* v4.7 New GIDL/GISL */
IOP( "wkgisl", BSIM4_MOD_WKGISL, IF_REAL, "Width dependence of kgisl"),		/* v4.7 New GIDL/GISL */
IOP( "wfgisl", BSIM4_MOD_WFGISL, IF_REAL, "Width dependence of fgisl"),		/* v4.7 New GIDL/GISL */
IOP( "wegisl", BSIM4_MOD_WEGISL, IF_REAL, "Width dependence of egisl"),
IOP( "waigc", BSIM4_MOD_WAIGC, IF_REAL, "Width dependence of aigc"),
IOP( "wbigc", BSIM4_MOD_WBIGC, IF_REAL, "Width dependence of bigc"),
IOP( "wcigc", BSIM4_MOD_WCIGC, IF_REAL, "Width dependence of cigc"),
IOP( "waigsd", BSIM4_MOD_WAIGSD, IF_REAL, "Width dependence of aigsd"),
IOP( "wbigsd", BSIM4_MOD_WBIGSD, IF_REAL, "Width dependence of bigsd"),
IOP( "wcigsd", BSIM4_MOD_WCIGSD, IF_REAL, "Width dependence of cigsd"),
IOP( "waigs", BSIM4_MOD_WAIGS, IF_REAL, "Width dependence of aigs"),
IOP( "wbigs", BSIM4_MOD_WBIGS, IF_REAL, "Width dependence of bigs"),
IOP( "wcigs", BSIM4_MOD_WCIGS, IF_REAL, "Width dependence of cigs"),
IOP( "waigd", BSIM4_MOD_WAIGD, IF_REAL, "Width dependence of aigd"),
IOP( "wbigd", BSIM4_MOD_WBIGD, IF_REAL, "Width dependence of bigd"),
IOP( "wcigd", BSIM4_MOD_WCIGD, IF_REAL, "Width dependence of cigd"),
IOP( "waigbacc", BSIM4_MOD_WAIGBACC, IF_REAL, "Width dependence of aigbacc"),
IOP( "wbigbacc", BSIM4_MOD_WBIGBACC, IF_REAL, "Width dependence of bigbacc"),
IOP( "wcigbacc", BSIM4_MOD_WCIGBACC, IF_REAL, "Width dependence of cigbacc"),
IOP( "waigbinv", BSIM4_MOD_WAIGBINV, IF_REAL, "Width dependence of aigbinv"),
IOP( "wbigbinv", BSIM4_MOD_WBIGBINV, IF_REAL, "Width dependence of bigbinv"),
IOP( "wcigbinv", BSIM4_MOD_WCIGBINV, IF_REAL, "Width dependence of cigbinv"),
IOP( "wnigc", BSIM4_MOD_WNIGC, IF_REAL, "Width dependence of nigc"),
IOP( "wnigbinv", BSIM4_MOD_WNIGBINV, IF_REAL, "Width dependence of nigbinv"),
IOP( "wnigbacc", BSIM4_MOD_WNIGBACC, IF_REAL, "Width dependence of nigbacc"),
IOP( "wntox", BSIM4_MOD_WNTOX, IF_REAL, "Width dependence of ntox"),
IOP( "weigbinv", BSIM4_MOD_WEIGBINV, IF_REAL, "Width dependence for eigbinv"),
IOP( "wpigcd", BSIM4_MOD_WPIGCD, IF_REAL, "Width dependence for pigcd"),
IOP( "wpoxedge", BSIM4_MOD_WPOXEDGE, IF_REAL, "Width dependence for poxedge"),
IOP( "wvfbcv", BSIM4_MOD_WVFBCV, IF_REAL, "Width dependence of vfbcv"),
IOP( "wvfb", BSIM4_MOD_WVFB, IF_REAL, "Width dependence of vfb"),
IOP( "wacde", BSIM4_MOD_WACDE, IF_REAL, "Width dependence of acde"),
IOP( "wmoin", BSIM4_MOD_WMOIN, IF_REAL, "Width dependence of moin"),
IOP( "wnoff", BSIM4_MOD_WNOFF, IF_REAL, "Width dependence of noff"),
IOP( "wvoffcv", BSIM4_MOD_WVOFFCV, IF_REAL, "Width dependence of voffcv"),
IOP( "wxrcrg1",  BSIM4_MOD_WXRCRG1, IF_REAL, "Width dependence of xrcrg1"),
IOP( "wxrcrg2",  BSIM4_MOD_WXRCRG2, IF_REAL, "Width dependence of xrcrg2"),
IOP( "wlambda",  BSIM4_MOD_WLAMBDA, IF_REAL, "Width dependence of lambda"),
IOP( "wvtl",      BSIM4_MOD_WVTL,     IF_REAL, "Width dependence of vtl"),
IOP( "wxn",     BSIM4_MOD_WXN,    IF_REAL, "Width dependence of xn"),
IOP( "weu",  BSIM4_MOD_WEU, IF_REAL, "Width dependence of eu"),
IOP( "wucs",  BSIM4_MOD_WUCS, IF_REAL, "Width dependence of ucs"),
IOP( "wvfbsdoff",     BSIM4_MOD_WVFBSDOFF,     IF_REAL, "Width dependence of vfbsdoff"),
IOP( "wtvfbsdoff",     BSIM4_MOD_WTVFBSDOFF,     IF_REAL, "Width dependence of tvfbsdoff"),
IOP( "wtvoff",     BSIM4_MOD_WTVOFF,     IF_REAL, "Width dependence of tvoff"),
IOP( "wtnfactor",     BSIM4_MOD_WTNFACTOR,     IF_REAL, "Width dependence of tnfactor"),  /* v4.7 Tanvir*/
IOP( "wteta0",     BSIM4_MOD_WTETA0,     IF_REAL, "Width dependence of teta0"),  /* v4.7 Tanvir*/
IOP( "wtvoffcv",     BSIM4_MOD_WTVOFFCV,     IF_REAL, "Width dependence of tvoffcv"),  /* v4.7 Tanvir*/

IOP( "pcdsc",  BSIM4_MOD_PCDSC, IF_REAL, "Cross-term dependence of cdsc"),
IOP( "pcdscb", BSIM4_MOD_PCDSCB, IF_REAL, "Cross-term dependence of cdscb"), 
IOP( "pcdscd", BSIM4_MOD_PCDSCD, IF_REAL, "Cross-term dependence of cdscd"),
IOP( "pcit",   BSIM4_MOD_PCIT,  IF_REAL, "Cross-term dependence of cit"),
IOP( "pnfactor", BSIM4_MOD_PNFACTOR, IF_REAL, "Cross-term dependence of nfactor"),
IOP( "pxj", BSIM4_MOD_PXJ, IF_REAL, "Cross-term dependence of xj"),
IOP( "pvsat", BSIM4_MOD_PVSAT, IF_REAL, "Cross-term dependence of vsat"),
IOP( "pat", BSIM4_MOD_PAT, IF_REAL, "Cross-term dependence of at"),
IOP( "pa0", BSIM4_MOD_PA0, IF_REAL, "Cross-term dependence of a0"), 
IOP( "pags", BSIM4_MOD_PAGS, IF_REAL, "Cross-term dependence of ags"),
IOP( "pa1", BSIM4_MOD_PA1, IF_REAL, "Cross-term dependence of a1"),
IOP( "pa2", BSIM4_MOD_PA2, IF_REAL, "Cross-term dependence of a2"),
IOP( "pketa", BSIM4_MOD_PKETA, IF_REAL, "Cross-term dependence of keta"),
IOP( "pnsub", BSIM4_MOD_PNSUB, IF_REAL, "Cross-term dependence of nsub"),
IOP( "pndep",  BSIM4_MOD_PNDEP, IF_REAL, "Cross-term dependence of ndep"),
IOP( "pnsd",  BSIM4_MOD_PNSD, IF_REAL, "Cross-term dependence of nsd"),
IOP( "pphin", BSIM4_MOD_PPHIN, IF_REAL, "Cross-term dependence of phin"),
IOP( "pngate", BSIM4_MOD_PNGATE, IF_REAL, "Cross-term dependence of ngate"),
IOP( "pgamma1", BSIM4_MOD_PGAMMA1, IF_REAL, "Cross-term dependence of gamma1"),
IOP( "pgamma2", BSIM4_MOD_PGAMMA2, IF_REAL, "Cross-term dependence of gamma2"),
IOP( "pvbx", BSIM4_MOD_PVBX, IF_REAL, "Cross-term dependence of vbx"),
IOP( "pvbm", BSIM4_MOD_PVBM, IF_REAL, "Cross-term dependence of vbm"),
IOP( "pxt",  BSIM4_MOD_PXT,  IF_REAL, "Cross-term dependence of xt"),
IOP( "pk1",   BSIM4_MOD_PK1,  IF_REAL, "Cross-term dependence of k1"),
IOP( "pkt1",  BSIM4_MOD_PKT1, IF_REAL, "Cross-term dependence of kt1"),
IOP( "pkt1l", BSIM4_MOD_PKT1L, IF_REAL, "Cross-term dependence of kt1l"),
IOP( "pkt2",  BSIM4_MOD_PKT2, IF_REAL, "Cross-term dependence of kt2"),
IOP( "pk2",   BSIM4_MOD_PK2,  IF_REAL, "Cross-term dependence of k2"),
IOP( "pk3",   BSIM4_MOD_PK3,  IF_REAL, "Cross-term dependence of k3"),
IOP( "pk3b",  BSIM4_MOD_PK3B, IF_REAL, "Cross-term dependence of k3b"),
IOP( "pw0",   BSIM4_MOD_PW0,  IF_REAL, "Cross-term dependence of w0"),
IOP( "pdvtp0",  BSIM4_MOD_PDVTP0, IF_REAL, "Cross-term dependence of dvtp0"),
IOP( "pdvtp1",  BSIM4_MOD_PDVTP1, IF_REAL, "Cross-term dependence of dvtp1"),
IOP( "pdvtp2",  BSIM4_MOD_PDVTP2, IF_REAL, "Cross-term dependence of dvtp2"),
IOP( "pdvtp3",  BSIM4_MOD_PDVTP3, IF_REAL, "Cross-term dependence of dvtp3"),
IOP( "pdvtp4",  BSIM4_MOD_PDVTP4, IF_REAL, "Cross-term dependence of dvtp4"),
IOP( "pdvtp5",  BSIM4_MOD_PDVTP5, IF_REAL, "Cross-term dependence of dvtp5"),
IOP( "plpe0",  BSIM4_MOD_PLPE0, IF_REAL, "Cross-term dependence of lpe0"),
IOP( "plpeb",  BSIM4_MOD_PLPEB, IF_REAL, "Cross-term dependence of lpeb"),
IOP( "pdvt0", BSIM4_MOD_PDVT0, IF_REAL, "Cross-term dependence of dvt0"),
IOP( "pdvt1", BSIM4_MOD_PDVT1, IF_REAL, "Cross-term dependence of dvt1"),
IOP( "pdvt2", BSIM4_MOD_PDVT2, IF_REAL, "Cross-term dependence of dvt2"),
IOP( "pdvt0w", BSIM4_MOD_PDVT0W, IF_REAL, "Cross-term dependence of dvt0w"),
IOP( "pdvt1w", BSIM4_MOD_PDVT1W, IF_REAL, "Cross-term dependence of dvt1w"),
IOP( "pdvt2w", BSIM4_MOD_PDVT2W, IF_REAL, "Cross-term dependence of dvt2w"),
IOP( "pdrout", BSIM4_MOD_PDROUT, IF_REAL, "Cross-term dependence of drout"),
IOP( "pdsub", BSIM4_MOD_PDSUB, IF_REAL, "Cross-term dependence of dsub"),
IOP( "pvth0", BSIM4_MOD_PVTH0, IF_REAL,"Cross-term dependence of vth0"),
IOPR("pvtho", BSIM4_MOD_PVTH0, IF_REAL,"Cross-term dependence of vtho"),
IOP( "pua",  BSIM4_MOD_PUA, IF_REAL, "Cross-term dependence of ua"),
IOP( "pua1", BSIM4_MOD_PUA1, IF_REAL, "Cross-term dependence of ua1"),
IOP( "pub", BSIM4_MOD_PUB, IF_REAL, "Cross-term dependence of ub"),
IOP( "pub1", BSIM4_MOD_PUB1, IF_REAL, "Cross-term dependence of ub1"),
IOP( "puc",  BSIM4_MOD_PUC, IF_REAL, "Cross-term dependence of uc"),
IOP( "puc1", BSIM4_MOD_PUC1, IF_REAL, "Cross-term dependence of uc1"),
IOP( "pud",  BSIM4_MOD_PUD, IF_REAL, "Cross-term dependence of ud"),
IOP( "pud1", BSIM4_MOD_PUD1, IF_REAL, "Cross-term dependence of ud1"),
IOP( "pup",  BSIM4_MOD_PUP, IF_REAL, "Cross-term dependence of up"),
IOP( "plp",  BSIM4_MOD_PLP, IF_REAL, "Cross-term dependence of lp"),
IOP( "pu0",  BSIM4_MOD_PU0, IF_REAL, "Cross-term dependence of u0"),
IOP( "pute", BSIM4_MOD_PUTE, IF_REAL, "Cross-term dependence of ute"),
IOP( "pucste", BSIM4_MOD_PUCSTE, IF_REAL, "Cross-term dependence of ucste"),
IOP( "pvoff", BSIM4_MOD_PVOFF, IF_REAL, "Cross-term dependence of voff"),
IOP( "pminv", BSIM4_MOD_PMINV, IF_REAL, "Cross-term dependence of minv"),
IOP( "pminvcv", BSIM4_MOD_PMINVCV, IF_REAL, "Cross-term dependence of minvcv"),
IOP( "pdelta", BSIM4_MOD_PDELTA, IF_REAL, "Cross-term dependence of delta"),
IOP( "prdsw", BSIM4_MOD_PRDSW,  IF_REAL, "Cross-term dependence of rdsw "),    
IOP( "prsw", BSIM4_MOD_PRSW, IF_REAL, "Cross-term dependence of rsw"),
IOP( "prdw", BSIM4_MOD_PRDW, IF_REAL, "Cross-term dependence of rdw"),

IOP( "pprwg", BSIM4_MOD_PPRWG,  IF_REAL, "Cross-term dependence of prwg "),    
IOP( "pprwb", BSIM4_MOD_PPRWB,  IF_REAL, "Cross-term dependence of prwb "),    

IOP( "pprt", BSIM4_MOD_PPRT, IF_REAL, "Cross-term dependence of prt "),
IOP( "peta0", BSIM4_MOD_PETA0, IF_REAL, "Cross-term dependence of eta0"),
IOP( "petab", BSIM4_MOD_PETAB, IF_REAL, "Cross-term dependence of etab"),
IOP( "ppclm", BSIM4_MOD_PPCLM, IF_REAL, "Cross-term dependence of pclm"),
IOP( "ppdiblc1", BSIM4_MOD_PPDIBL1, IF_REAL, "Cross-term dependence of pdiblc1"),
IOP( "ppdiblc2", BSIM4_MOD_PPDIBL2, IF_REAL, "Cross-term dependence of pdiblc2"),
IOP( "ppdiblcb", BSIM4_MOD_PPDIBLB, IF_REAL, "Cross-term dependence of pdiblcb"),
IOP( "pfprout", BSIM4_MOD_PFPROUT, IF_REAL, "Cross-term dependence of pdiblcb"),
IOP( "ppdits", BSIM4_MOD_PPDITS, IF_REAL, "Cross-term dependence of pdits"),
IOP( "ppditsd", BSIM4_MOD_PPDITSD, IF_REAL, "Cross-term dependence of pditsd"),
IOP( "ppscbe1",  BSIM4_MOD_PPSCBE1, IF_REAL, "Cross-term dependence of pscbe1"),
IOP( "ppscbe2",  BSIM4_MOD_PPSCBE2, IF_REAL, "Cross-term dependence of pscbe2"),
IOP( "ppvag", BSIM4_MOD_PPVAG, IF_REAL, "Cross-term dependence of pvag"),   
IOP( "pwr",  BSIM4_MOD_PWR, IF_REAL, "Cross-term dependence of wr"),
IOP( "pdwg", BSIM4_MOD_PDWG, IF_REAL, "Cross-term dependence of dwg"),
IOP( "pdwb", BSIM4_MOD_PDWB, IF_REAL, "Cross-term dependence of dwb"),
IOP( "pb0",  BSIM4_MOD_PB0, IF_REAL, "Cross-term dependence of b0"),
IOP( "pb1",  BSIM4_MOD_PB1, IF_REAL, "Cross-term dependence of b1"),
IOP( "pcgsl", BSIM4_MOD_PCGSL, IF_REAL, "Cross-term dependence of cgsl"),
IOP( "pcgdl", BSIM4_MOD_PCGDL, IF_REAL, "Cross-term dependence of cgdl"),
IOP( "pckappas", BSIM4_MOD_PCKAPPAS, IF_REAL, "Cross-term dependence of ckappas"),
IOP( "pckappad", BSIM4_MOD_PCKAPPAD, IF_REAL, "Cross-term dependence of ckappad"),
IOP( "pcf",  BSIM4_MOD_PCF,  IF_REAL, "Cross-term dependence of cf"),
IOP( "pclc", BSIM4_MOD_PCLC, IF_REAL, "Cross-term dependence of clc"),
IOP( "pcle", BSIM4_MOD_PCLE, IF_REAL, "Cross-term dependence of cle"),
IOP( "palpha0", BSIM4_MOD_PALPHA0, IF_REAL, "Cross-term dependence of alpha0"),
IOP( "palpha1", BSIM4_MOD_PALPHA1, IF_REAL, "Cross-term dependence of alpha1"),
IOP( "pbeta0", BSIM4_MOD_PBETA0, IF_REAL, "Cross-term dependence of beta0"),

IOP( "pagidl", BSIM4_MOD_PAGIDL, IF_REAL, "Cross-term dependence of agidl"),
IOP( "pbgidl", BSIM4_MOD_PBGIDL, IF_REAL, "Cross-term dependence of bgidl"),
IOP( "pcgidl", BSIM4_MOD_PCGIDL, IF_REAL, "Cross-term dependence of cgidl"),
IOP( "prgidl", BSIM4_MOD_PRGIDL, IF_REAL, "Cross-term dependence of rgidl"),	/* v4.7 New GIDL/GISL */
IOP( "pkgidl", BSIM4_MOD_PKGIDL, IF_REAL, "Cross-term dependence of kgidl"),	/* v4.7 New GIDL/GISL */
IOP( "pfgidl", BSIM4_MOD_PFGIDL, IF_REAL, "Cross-term dependence of fgidl"),	/* v4.7 New GIDL/GISL */
IOP( "pegidl", BSIM4_MOD_PEGIDL, IF_REAL, "Cross-term dependence of egidl"),
IOP( "pagisl", BSIM4_MOD_PAGISL, IF_REAL, "Cross-term dependence of agisl"),
IOP( "pbgisl", BSIM4_MOD_PBGISL, IF_REAL, "Cross-term dependence of bgisl"),
IOP( "pcgisl", BSIM4_MOD_PCGISL, IF_REAL, "Cross-term dependence of cgisl"),
IOP( "pegisl", BSIM4_MOD_PEGISL, IF_REAL, "Cross-term dependence of egisl"),
IOP( "prgisl", BSIM4_MOD_PRGISL, IF_REAL, "Cross-term dependence of rgisl"),	/* v4.7 New GIDL/GISL */
IOP( "pkgisl", BSIM4_MOD_PKGISL, IF_REAL, "Cross-term dependence of kgisl"),	/* v4.7 New GIDL/GISL */
IOP( "pfgisl", BSIM4_MOD_PFGISL, IF_REAL, "Cross-term dependence of fgisl"),	/* v4.7 New GIDL/GISL */
IOP( "paigc", BSIM4_MOD_PAIGC, IF_REAL, "Cross-term dependence of aigc"),
IOP( "pbigc", BSIM4_MOD_PBIGC, IF_REAL, "Cross-term dependence of bigc"),
IOP( "pcigc", BSIM4_MOD_PCIGC, IF_REAL, "Cross-term dependence of cigc"),
IOP( "paigsd", BSIM4_MOD_PAIGSD, IF_REAL, "Cross-term dependence of aigsd"),
IOP( "pbigsd", BSIM4_MOD_PBIGSD, IF_REAL, "Cross-term dependence of bigsd"),
IOP( "pcigsd", BSIM4_MOD_PCIGSD, IF_REAL, "Cross-term dependence of cigsd"),
IOP( "paigs", BSIM4_MOD_PAIGS, IF_REAL, "Cross-term dependence of aigs"),
IOP( "pbigs", BSIM4_MOD_PBIGS, IF_REAL, "Cross-term dependence of bigs"),
IOP( "pcigs", BSIM4_MOD_PCIGS, IF_REAL, "Cross-term dependence of cigs"),
IOP( "paigd", BSIM4_MOD_PAIGD, IF_REAL, "Cross-term dependence of aigd"),
IOP( "pbigd", BSIM4_MOD_PBIGD, IF_REAL, "Cross-term dependence of bigd"),
IOP( "pcigd", BSIM4_MOD_PCIGD, IF_REAL, "Cross-term dependence of cigd"),
IOP( "paigbacc", BSIM4_MOD_PAIGBACC, IF_REAL, "Cross-term dependence of aigbacc"),
IOP( "pbigbacc", BSIM4_MOD_PBIGBACC, IF_REAL, "Cross-term dependence of bigbacc"),
IOP( "pcigbacc", BSIM4_MOD_PCIGBACC, IF_REAL, "Cross-term dependence of cigbacc"),
IOP( "paigbinv", BSIM4_MOD_PAIGBINV, IF_REAL, "Cross-term dependence of aigbinv"),
IOP( "pbigbinv", BSIM4_MOD_PBIGBINV, IF_REAL, "Cross-term dependence of bigbinv"),
IOP( "pcigbinv", BSIM4_MOD_PCIGBINV, IF_REAL, "Cross-term dependence of cigbinv"),
IOP( "pnigc", BSIM4_MOD_PNIGC, IF_REAL, "Cross-term dependence of nigc"),
IOP( "pnigbinv", BSIM4_MOD_PNIGBINV, IF_REAL, "Cross-term dependence of nigbinv"),
IOP( "pnigbacc", BSIM4_MOD_PNIGBACC, IF_REAL, "Cross-term dependence of nigbacc"),
IOP( "pntox", BSIM4_MOD_PNTOX, IF_REAL, "Cross-term dependence of ntox"),
IOP( "peigbinv", BSIM4_MOD_PEIGBINV, IF_REAL, "Cross-term dependence for eigbinv"),
IOP( "ppigcd", BSIM4_MOD_PPIGCD, IF_REAL, "Cross-term dependence for pigcd"),
IOP( "ppoxedge", BSIM4_MOD_PPOXEDGE, IF_REAL, "Cross-term dependence for poxedge"),
IOP( "pvfbcv", BSIM4_MOD_PVFBCV, IF_REAL, "Cross-term dependence of vfbcv"),
IOP( "pvfb", BSIM4_MOD_PVFB, IF_REAL, "Cross-term dependence of vfb"),
IOP( "pacde", BSIM4_MOD_PACDE, IF_REAL, "Cross-term dependence of acde"),
IOP( "pmoin", BSIM4_MOD_PMOIN, IF_REAL, "Cross-term dependence of moin"),
IOP( "pnoff", BSIM4_MOD_PNOFF, IF_REAL, "Cross-term dependence of noff"),
IOP( "pvoffcv", BSIM4_MOD_PVOFFCV, IF_REAL, "Cross-term dependence of voffcv"),
IOP( "pxrcrg1",  BSIM4_MOD_PXRCRG1, IF_REAL, "Cross-term dependence of xrcrg1"),
IOP( "pxrcrg2",  BSIM4_MOD_PXRCRG2, IF_REAL, "Cross-term dependence of xrcrg2"),
IOP( "plambda",  BSIM4_MOD_PLAMBDA, IF_REAL, "Cross-term dependence of lambda"),
IOP( "pvtl",      BSIM4_MOD_PVTL,     IF_REAL, "Cross-term dependence of vtl"),
IOP( "pxn",     BSIM4_MOD_PXN,    IF_REAL, "Cross-term dependence of xn"),
IOP( "peu",  BSIM4_MOD_PEU, IF_REAL, "Cross-term dependence of eu"),
IOP( "pucs",  BSIM4_MOD_PUCS, IF_REAL, "Cross-term dependence of ucs"),
IOP( "pvfbsdoff",     BSIM4_MOD_PVFBSDOFF,     IF_REAL, "Cross-term dependence of vfbsdoff"),
IOP( "ptvfbsdoff",     BSIM4_MOD_PTVFBSDOFF,     IF_REAL, "Cross-term dependence of tvfbsdoff"),
IOP( "ptvoff",     BSIM4_MOD_PTVOFF,     IF_REAL, "Cross-term dependence of tvoff"),
IOP( "ptnfactor",     BSIM4_MOD_PTNFACTOR,     IF_REAL, "Cross-term dependence of tnfactor"),  /* v4.7 Tanvir*/
IOP( "pteta0",     BSIM4_MOD_PTETA0,     IF_REAL, "Cross-term dependence of teta0"),  /* v4.7 Tanvir*/
IOP( "ptvoffcv",     BSIM4_MOD_PTVOFFCV,     IF_REAL, "Cross-term dependence of tvoffcv"),  /* v4.7 Tanvir*/

/* stress effect*/
IOP( "saref", BSIM4_MOD_SAREF, IF_REAL, "Reference distance between OD edge to poly of one side"),
IOP( "sbref", BSIM4_MOD_SBREF, IF_REAL, "Reference distance between OD edge to poly of the other side"),
IOP( "wlod", BSIM4_MOD_WLOD, IF_REAL, "Width parameter for stress effect"),
IOP( "ku0", BSIM4_MOD_KU0, IF_REAL, "Mobility degradation/enhancement coefficient for LOD"),
IOP( "kvsat", BSIM4_MOD_KVSAT, IF_REAL, "Saturation velocity degradation/enhancement parameter for LOD"),
IOP( "kvth0", BSIM4_MOD_KVTH0, IF_REAL, "Threshold degradation/enhancement parameter for LOD"),
IOP( "tku0", BSIM4_MOD_TKU0, IF_REAL, "Temperature coefficient of KU0"),
IOP( "llodku0",  BSIM4_MOD_LLODKU0, IF_REAL, "Length parameter for u0 LOD effect"),
IOP( "wlodku0",  BSIM4_MOD_WLODKU0, IF_REAL, "Width parameter for u0 LOD effect"),
IOP( "llodvth",  BSIM4_MOD_LLODVTH, IF_REAL, "Length parameter for vth LOD effect"),
IOP( "wlodvth",  BSIM4_MOD_WLODVTH, IF_REAL, "Width parameter for vth LOD effect"),
IOP( "lku0", BSIM4_MOD_LKU0, IF_REAL, "Length dependence of ku0"),
IOP( "wku0", BSIM4_MOD_WKU0, IF_REAL, "Width dependence of ku0"),
IOP( "pku0", BSIM4_MOD_PKU0, IF_REAL, "Cross-term dependence of ku0"),
IOP( "lkvth0", BSIM4_MOD_LKVTH0, IF_REAL, "Length dependence of kvth0"),
IOP( "wkvth0", BSIM4_MOD_WKVTH0, IF_REAL, "Width dependence of kvth0"),
IOP( "pkvth0", BSIM4_MOD_PKVTH0, IF_REAL, "Cross-term dependence of kvth0"),
IOP( "stk2", BSIM4_MOD_STK2, IF_REAL, "K2 shift factor related to stress effect on vth"),
IOP( "lodk2", BSIM4_MOD_LODK2, IF_REAL, "K2 shift modification factor for stress effect"),
IOP( "steta0", BSIM4_MOD_STETA0, IF_REAL, "eta0 shift factor related to stress effect on vth"),
IOP( "lodeta0", BSIM4_MOD_LODETA0, IF_REAL, "eta0 shift modification factor for stress effect"),
/* Well Proximity Effect */
IOP( "web", BSIM4_MOD_WEB, IF_REAL, "Coefficient for SCB"),
IOP( "wec", BSIM4_MOD_WEC, IF_REAL, "Coefficient for SCC"),
IOP( "kvth0we", BSIM4_MOD_KVTH0WE, IF_REAL, "Threshold shift factor for well proximity effect"),
IOP( "k2we", BSIM4_MOD_K2WE, IF_REAL, " K2 shift factor for well proximity effect "),
IOP( "ku0we", BSIM4_MOD_KU0WE, IF_REAL, " Mobility degradation factor for well proximity effect "),
IOP( "scref", BSIM4_MOD_SCREF, IF_REAL, " Reference distance to calculate SCA, SCB and SCC"),
IOP( "wpemod", BSIM4_MOD_WPEMOD, IF_REAL, " Flag for WPE model (WPEMOD=1 to activate this model) "),
IOP( "lkvth0we", BSIM4_MOD_LKVTH0WE, IF_REAL, "Length dependence of kvth0we"),
IOP( "lk2we", BSIM4_MOD_LK2WE, IF_REAL, " Length dependence of k2we "),
IOP( "lku0we", BSIM4_MOD_LKU0WE, IF_REAL, " Length dependence of ku0we "),
IOP( "wkvth0we", BSIM4_MOD_WKVTH0WE, IF_REAL, "Width dependence of kvth0we"),
IOP( "wk2we", BSIM4_MOD_WK2WE, IF_REAL, " Width dependence of k2we "),
IOP( "wku0we", BSIM4_MOD_WKU0WE, IF_REAL, " Width dependence of ku0we "),
IOP( "pkvth0we", BSIM4_MOD_PKVTH0WE, IF_REAL, "Cross-term dependence of kvth0we"),
IOP( "pk2we", BSIM4_MOD_PK2WE, IF_REAL, " Cross-term dependence of k2we "),
IOP( "pku0we", BSIM4_MOD_PKU0WE, IF_REAL, " Cross-term dependence of ku0we "),

IOP( "noia", BSIM4_MOD_NOIA, IF_REAL, "Flicker noise parameter"),
IOP( "noib", BSIM4_MOD_NOIB, IF_REAL, "Flicker noise parameter"),
IOP( "noic", BSIM4_MOD_NOIC, IF_REAL, "Flicker noise parameter"),
IOP( "tnoia", BSIM4_MOD_TNOIA, IF_REAL, "Thermal noise parameter"),
IOP( "tnoib", BSIM4_MOD_TNOIB, IF_REAL, "Thermal noise parameter"),
IOP( "tnoic", BSIM4_MOD_TNOIC, IF_REAL, "Thermal noise parameter"),
IOP( "rnoia", BSIM4_MOD_RNOIA, IF_REAL, "Thermal noise coefficient"),
IOP( "rnoib", BSIM4_MOD_RNOIB, IF_REAL, "Thermal noise coefficient"),
IOP( "rnoic", BSIM4_MOD_RNOIC, IF_REAL, "Thermal noise coefficient"),
IOP( "gidlclamp", BSIM4_MOD_GIDLCLAMP, IF_REAL, "gidl clamp value"),
IOP( "idovvds", BSIM4_MOD_IDOVVDSC, IF_REAL, "noise clamping limit parameter"),
IOP( "ntnoi", BSIM4_MOD_NTNOI, IF_REAL, "Thermal noise parameter"),
IOP( "em", BSIM4_MOD_EM, IF_REAL, "Flicker noise parameter"),
IOP( "ef", BSIM4_MOD_EF, IF_REAL, "Flicker noise frequency exponent"),
IOP( "af", BSIM4_MOD_AF, IF_REAL, "Flicker noise exponent"),
IOP( "kf", BSIM4_MOD_KF, IF_REAL, "Flicker noise coefficient"),

IOP("vgs_max", BSIM4_MOD_VGS_MAX, IF_REAL, "maximum voltage G-S branch"),
IOP("vgd_max", BSIM4_MOD_VGD_MAX, IF_REAL, "maximum voltage G-D branch"),
IOP("vgb_max", BSIM4_MOD_VGB_MAX, IF_REAL, "maximum voltage G-B branch"),
IOP("vds_max", BSIM4_MOD_VDS_MAX, IF_REAL, "maximum voltage D-S branch"),
IOP("vbs_max", BSIM4_MOD_VBS_MAX, IF_REAL, "maximum voltage B-S branch"),
IOP("vbd_max", BSIM4_MOD_VBD_MAX, IF_REAL, "maximum voltage B-D branch"),
IOP("vgsr_max", BSIM4_MOD_VGSR_MAX, IF_REAL, "maximum voltage G-S branch"),
IOP("vgdr_max", BSIM4_MOD_VGDR_MAX, IF_REAL, "maximum voltage G-D branch"),
IOP("vgbr_max", BSIM4_MOD_VGBR_MAX, IF_REAL, "maximum voltage G-B branch"),
IOP("vbsr_max", BSIM4_MOD_VBSR_MAX, IF_REAL, "maximum voltage B-S branch"),
IOP("vbdr_max", BSIM4_MOD_VBDR_MAX, IF_REAL, "maximum voltage B-D branch"),

IP( "nmos", BSIM4_MOD_NMOS,  IF_FLAG, "Flag to indicate NMOS"),
IP( "pmos", BSIM4_MOD_PMOS,  IF_FLAG, "Flag to indicate PMOS"),
};

char *BSIM4names[] = {
   "Drain",
   "Gate",
   "Source",
   "Bulk",
   "Charge"
};

int	BSIM4nSize = NUMELEMS(BSIM4names);
int	BSIM4pTSize = NUMELEMS(BSIM4pTable);
int	BSIM4mPTSize = NUMELEMS(BSIM4mPTable);
int	BSIM4iSize = sizeof(BSIM4instance);
int	BSIM4mSize = sizeof(BSIM4model);
