/*
nitroxcalc
Copyright (C) 2015-2024 Salvo "LtWorf" Tomaselli

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

author Salvo "LtWorf" Tomaselli <tiposchi@tiscali.it>
*/

import QtQuick 2.0
import QtQuick.Particles 2.0

Rectangle {
    color: "#0170FE"

    Image {
        source: "background.jpg"
        fillMode: Image.PreserveAspectCrop
        anchors.fill: parent
    }

    Timer {
        interval: 8000
        triggeredOnStart: true
        repeat: true
        running: true
        onTriggered: {
            emitter.burst(50);
        }
    }

    MouseArea {
        anchors.fill: parent
        acceptedButtons: Qt.LeftButton | Qt.RightButton
    }

    ParticleSystem {
        id: particles
        running: true
    }

    ImageParticle {
        anchors.fill: parent
        system: particles
        source: "bubble.png"
        sizeTable: "sparkleSize.png"
        alpha: 0
        colorVariation: 0.6
    }

    Rectangle {
        width: parent.width
        height: 5
        anchors.bottom: parent.bottom
        opacity: 0
        Emitter {
            id: emitter
            anchors.fill: parent
            system: particles
            emitRate: 3
            lifeSpan: 30000
            size: 20
            endSize: 30
            velocity: PointDirection {y: -72; yVariation: 24}
            sizeVariation: 10
        }
    }


}
