/**
 * Enum of all token types, with bit fields to signify meaningful properties.
 */
export declare enum TokenType {
    PRECEDENCE_MASK = 15,
    IS_KEYWORD = 16,
    IS_ASSIGN = 32,
    IS_RIGHT_ASSOCIATIVE = 64,
    IS_PREFIX = 128,
    IS_POSTFIX = 256,
    num = 0,
    bigint = 512,
    regexp = 1024,
    string = 1536,
    name = 2048,
    eof = 2560,
    bracketL = 3072,
    bracketR = 3584,
    braceL = 4096,
    braceBarL = 4608,
    braceR = 5120,
    braceBarR = 5632,
    parenL = 6144,
    parenR = 6656,
    comma = 7168,
    semi = 7680,
    colon = 8192,
    doubleColon = 8704,
    dot = 9216,
    question = 9728,
    questionDot = 10240,
    arrow = 10752,
    template = 11264,
    ellipsis = 11776,
    backQuote = 12288,
    dollarBraceL = 12800,
    at = 13312,
    hash = 13824,
    eq = 14368,
    assign = 14880,
    preIncDec = 15744,
    postIncDec = 16256,
    bang = 16512,
    tilde = 17024,
    pipeline = 17409,
    nullishCoalescing = 17922,
    logicalOR = 18435,
    logicalAND = 18948,
    bitwiseOR = 19461,
    bitwiseXOR = 19974,
    bitwiseAND = 20487,
    equality = 21000,
    lessThan = 21513,
    greaterThan = 22025,
    relationalOrEqual = 22537,
    bitShift = 23050,
    plus = 23691,
    minus = 24203,
    modulo = 24588,
    star = 25100,
    slash = 25612,
    exponent = 26189,
    jsxName = 26624,
    jsxText = 27136,
    jsxTagStart = 27648,
    jsxTagEnd = 28160,
    typeParameterStart = 28672,
    nonNullAssertion = 29184,
    _break = 29712,
    _case = 30224,
    _catch = 30736,
    _continue = 31248,
    _debugger = 31760,
    _default = 32272,
    _do = 32784,
    _else = 33296,
    _finally = 33808,
    _for = 34320,
    _function = 34832,
    _if = 35344,
    _return = 35856,
    _switch = 36368,
    _throw = 37008,
    _try = 37392,
    _var = 37904,
    _let = 38416,
    _const = 38928,
    _while = 39440,
    _with = 39952,
    _new = 40464,
    _this = 40976,
    _super = 41488,
    _class = 42000,
    _extends = 42512,
    _export = 43024,
    _import = 43536,
    _yield = 44048,
    _null = 44560,
    _true = 45072,
    _false = 45584,
    _in = 46105,
    _instanceof = 46617,
    _typeof = 47248,
    _void = 47760,
    _delete = 48272,
    _async = 48656,
    _get = 49168,
    _set = 49680,
    _declare = 50192,
    _readonly = 50704,
    _abstract = 51216,
    _static = 51728,
    _public = 52240,
    _private = 52752,
    _protected = 53264,
    _as = 53776,
    _enum = 54288,
    _type = 54800,
    _implements = 55312
}
export declare function formatTokenType(tokenType: TokenType): string;
