// simple-is.js
// MIT licensed, see LICENSE file
// Copyright (c) 2013 Olov Lassus <olov.lassus@gmail.com>

var is = (function() {
    "use strict";

    var hasOwnProperty = Object.prototype.hasOwnProperty;
    var toString = Object.prototype.toString;
    var _undefined = void 0;

    return {
        nan: function(v) {
            return v !== v;
        },
        boolean: function(v) {
            return typeof v === "boolean";
        },
        number: function(v) {
            return typeof v === "number";
        },
        string: function(v) {
            return typeof v === "string";
        },
        fn: function(v) {
            return typeof v === "function";
        },
        object: function(v) {
            return v !== null && typeof v === "object";
        },
        primitive: function(v) {
            var t = typeof v;
            return v === null || v === _undefined ||
                t === "boolean" || t === "number" || t === "string";
        },
        array: Array.isArray || function(v) {
            return toString.call(v) === "[object Array]";
        },
        finitenumber: function(v) {
            return typeof v === "number" && isFinite(v);
        },
        someof: function(v, values) {
            return values.indexOf(v) >= 0;
        },
        noneof: function(v, values) {
            return values.indexOf(v) === -1;
        },
        own: function(obj, prop) {
            return hasOwnProperty.call(obj, prop);
        },
    };
})();

if (typeof module !== "undefined" && typeof module.exports !== "undefined") {
    module.exports = is;
}
