# Copyright (C) 2021-2022 Greenbone Networks GmbH
#
# SPDX-License-Identifier: AGPL-3.0-or-later
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

from typing import Optional

from .deb import DEBPackage
from .ebuild import EBuildPackage
from .package import Package, PackageType
from .rpm import RPMPackage
from .slackware import SlackPackage

__SWITCHER = {
    PackageType.RPM: RPMPackage,
    PackageType.DEB: DEBPackage,
    PackageType.EBUILD: EBuildPackage,
    PackageType.SLACK: SlackPackage,
}


def package_class_by_type(pt: PackageType) -> Optional[Package]:
    """
    package_class_by_type may returns Package if defined otherwise None
    """
    return __SWITCHER.get(pt)
