/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.util;

import com.sourceforge.knecs.dsm.util.Species;
import com.sourceforge.knecs.dsm.util.TranslationProperty;
import com.sourceforge.knecs.dsm.util.Xlink;
import com.sourceforge.knecs.util.CMCSProperties;
import com.sourceforge.knecs.util.LoggerUtils;
import com.sourceforge.knecs.util.NSProperty;
import com.sourceforge.knecs.util.SimpleDateFormat;
import com.sourceforge.knecs.util.UrlUtils;
import com.sourceforge.knecs.util.xml.CaptureErrorHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PedigreeUtils {
    public static final String DCNS = "http://purl.org/dc/elements/1.1/";
    public static final String DCTERMSNS = "http://purl.org/dc/terms/";
    public static final String CMCSNS = "http://purl.oclc.org/NET/cmcs/schema/";
    public static final String CMCSEXPNS = "http://purl.oclc.org/NET/cmcs/exp/schema/";
    public static final String CMCSINTNS = "http://purl.oclc.org/NET/cmcs/internal/schema/";
    public static final String RDFNS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String XLINKNS = "http://www.w3.org/1999/xlink";
    public static final String TITLE = "http://purl.org/dc/elements/1.1/:title";
    public static final String CREATOR = "http://purl.org/dc/elements/1.1/:creator";
    public static final String CONTRIBUTOR = "http://purl.org/dc/elements/1.1/:contributor";
    public static final String PUBLISHER = "http://purl.org/dc/elements/1.1/:publisher";
    public static final String ALTERNATIVE = "http://purl.org/dc/terms/:alternative";
    public static final String SUBJECT = "http://purl.org/dc/elements/1.1/:subject";
    public static final String DESCRIPTION = "http://purl.org/dc/elements/1.1/:description";
    public static final String ABSTRACT = "http://purl.org/dc/terms/:abstract";
    public static final String TYPE = "http://purl.org/dc/elements/1.1/:type";
    public static final String FORMAT = "http://purl.org/dc/elements/1.1/:format";
    public static final String LANGUAGE = "http://purl.org/dc/elements/1.1/:language";
    public static final String DATE = "http://purl.org/dc/elements/1.1/:date";
    public static final String CREATED = "http://purl.org/dc/terms/:created";
    public static final String ISSUED = "http://purl.org/dc/terms/:issued";
    public static final String MODIFIED = "http://purl.org/dc/terms/:modified";
    public static final String VALID = "http://purl.org/dc/terms/:valid";
    public static final String AVAILABLE = "http://purl.org/dc/terms/:available";
    public static final String ISREFERENCEDBY = "http://purl.org/dc/terms/:isreferencedby";
    public static final String REFERENCES = "http://purl.org/dc/terms/:references";
    public static final String ISVERSIONOF = "http://purl.org/dc/terms/:isversionof";
    public static final String HASVERSION = "http://purl.org/dc/terms/:hasversion";
    public static final String ISREPLACEEDBY = "http://purl.org/dc/terms/:isreplacedby";
    public static final String REPLACES = "http://purl.org/dc/terms/:replaces";
    public static final String REQUIRES = "http://purl.org/dc/terms/:requires";
    public static final String ISPARTOF = "http://purl.org/dc/terms/:ispartof";
    public static final String HASPART = "http://purl.org/dc/terms/:haspart";
    public static final String ISFORMATOF = "http://purl.org/dc/terms/:isformatof";
    public static final String HASFORMAT = "http://purl.org/dc/terms/:hasformat";
    public static final String CHEMICALPROPERTY = "http://purl.oclc.org/NET/cmcs/schema/:chemicalproperty";
    public static final String HASINPUTS = "http://purl.oclc.org/NET/cmcs/schema/:hasinputs";
    public static final String HASOUTPUTS = "http://purl.oclc.org/NET/cmcs/schema/:hasoutputs";
    public static final String HASSPECIES = "http://purl.oclc.org/NET/cmcs/schema/:hasspecies";
    public static final String HASPARAMSBOUNDEDBY = "http://purl.oclc.org/NET/cmcs/schema/:hasparamsboundedby";
    public static final String PROGRAMNAME = "http://purl.oclc.org/NET/cmcs/schema/:ProgramName";
    public static final String PROGRAMVERSION = "http://purl.oclc.org/NET/cmcs/schema/:ProgramVersion";
    public static final String ISSANCTIONEDBY = "http://purl.oclc.org/NET/cmcs/schema/:issanctionedby";
    public static final String ISPARTOFPROJECT = "http://purl.oclc.org/NET/cmcs/schema/:ispartofproject";
    public static final String COMPUTER = "http://purl.oclc.org/NET/cmcs/exp/schema/:Computer";
    public static final String OPERATINGSYSTEM = "http://purl.oclc.org/NET/cmcs/exp/schema/:OperatingSystem";
    private static Logger mLogger = Logger.getLogger("com.sourceforge.knecs");

    private PedigreeUtils() {
    }

    public static String makeRDFBag(Vector values) {
        Object firstObj;
        String temp;
        if (values.size() == 1 && (temp = (firstObj = values.elementAt(0)).toString()).indexOf("<Bag") >= 0) {
            return temp;
        }
        String XMLString2 = new String();
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String rdfNamespace = props.getProperty("rdfns");
        int numItems = values.size();
        if (numItems > 0) {
            XMLString2 = "<Bag xmlns=\"" + rdfNamespace + "\" xmlns:rdf=\"" + rdfNamespace + "\">";
            for (int i = 0; i < numItems; ++i) {
                String nextTag = values.elementAt(i).toString();
                mLogger.info("makeRDFBag item" + nextTag);
                if (nextTag == null || nextTag.equals("")) continue;
                XMLString2 = XMLString2 + "<li xmlns=\"" + rdfNamespace + "\">";
                XMLString2 = XMLString2 + nextTag + "</li>";
            }
            XMLString2 = XMLString2 + " </Bag>";
        }
        return XMLString2;
    }

    public static String makeRelativeXMLforHref(String role, String type, String title, String href) {
        String relativePath = UrlUtils.getPathRelativeToWebapp(href);
        String XML = PedigreeUtils.makeXMLforHref(role, type, title, relativePath);
        return XML;
    }

    public static String makeXMLforHref(String role, String type, String title, String href) {
        String XMLString2 = new String();
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String rdfNamespace = props.getProperty("rdfns");
        String xlinkNamespace = props.getProperty("xlinkns");
        String cmcsNamespace = props.getProperty("cmcsns");
        XMLString2 = "<href xmlns=\"" + cmcsNamespace + "\" xlink:href=\"";
        XMLString2 = XMLString2 + href + "\" ";
        title = title.trim();
        type = type.trim();
        role = role.trim();
        if (title.length() != 0) {
            XMLString2 = XMLString2 + "xlink:title=\"" + title + "\" ";
        }
        if (type.length() != 0) {
            XMLString2 = XMLString2 + "xlink:type=\"" + type + "\" ";
        }
        if (role.length() != 0) {
            XMLString2 = XMLString2 + "xlink:role=\"" + role + "\" ";
        }
        XMLString2 = XMLString2 + "xmlns:cmcs=\"" + cmcsNamespace;
        XMLString2 = XMLString2 + "\" xmlns:xlink=\"" + xlinkNamespace;
        XMLString2 = XMLString2 + "\"></href>";
        return XMLString2;
    }

    public static String makeXMLforHref(Xlink xlink) {
        String XMLString2 = new String();
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String rdfNamespace = props.getProperty("rdfns");
        String xlinkNamespace = props.getProperty("xlinkns");
        String cmcsNamespace = props.getProperty("cmcsns");
        String href = xlink.getHref();
        String title = xlink.getTitle();
        String type = xlink.getType();
        String role = xlink.getRole();
        XMLString2 = "<href xmlns=\"" + cmcsNamespace + "\" xlink:href=\"";
        XMLString2 = XMLString2 + href + "\" ";
        title = title.trim();
        type = type.trim();
        role = role.trim();
        if (title.length() != 0) {
            XMLString2 = XMLString2 + "xlink:title=\"" + title + "\" ";
        }
        if (type.length() != 0) {
            XMLString2 = XMLString2 + "xlink:type=\"" + type + "\" ";
        }
        if (role.length() != 0) {
            XMLString2 = XMLString2 + "xlink:role=\"" + role + "\" ";
        }
        XMLString2 = XMLString2 + "xmlns:cmcs=\"" + cmcsNamespace;
        XMLString2 = XMLString2 + "\" xmlns:xlink=\"" + xlinkNamespace;
        XMLString2 = XMLString2 + "\"></href>";
        return XMLString2;
    }

    public static String makeXMLforSpeciesList(Vector spList) {
        String XMLString2 = new String();
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String cmcsNamespace = props.getProperty("cmcsns");
        if (spList.isEmpty()) {
            return "";
        }
        XMLString2 = "<speciesList xmlns=\"" + cmcsNamespace + "\"> ";
        int size = spList.size();
        for (int idx = 0; idx < size; ++idx) {
            String type;
            XMLString2 = XMLString2 + "<species xmlns=\"" + cmcsNamespace + "\"> ";
            Species species = (Species)spList.get(idx);
            String cas = species.getCas().trim();
            if (cas != null || cas != "") {
                XMLString2 = XMLString2 + "<cas xmlns=\"" + cmcsNamespace + "\">";
                XMLString2 = XMLString2 + cas + "</cas> ";
            }
            boolean hasFormulas = false;
            Species.Tuple tup = species.removeFirstFormulaInList();
            if (tup != null) {
                XMLString2 = XMLString2 + "<formulaList xmlns=\"" + cmcsNamespace + "\"> ";
            }
            while (tup != null) {
                hasFormulas = true;
                String formula = tup.getValue();
                type = tup.getType();
                XMLString2 = XMLString2 + "<formula xmlns=\"" + cmcsNamespace + "\"";
                if (type.length() != 0) {
                    XMLString2 = XMLString2 + " type=\"" + type + "\"";
                }
                XMLString2 = XMLString2 + ">";
                XMLString2 = XMLString2 + formula + "</formula> ";
                tup = species.removeFirstFormulaInList();
            }
            if (hasFormulas) {
                XMLString2 = XMLString2 + "</formulaList>";
            }
            boolean hasNames = false;
            tup = species.removeFirstNameInList();
            if (tup != null) {
                XMLString2 = XMLString2 + "<nameList xmlns=\"" + cmcsNamespace + "\"> ";
            }
            while (tup != null) {
                hasNames = true;
                String name = tup.getValue();
                type = tup.getType();
                XMLString2 = XMLString2 + "<name xmlns=\"" + cmcsNamespace + "\"";
                if (type.length() != 0) {
                    XMLString2 = XMLString2 + " type=\"" + type + "\"";
                }
                XMLString2 = XMLString2 + ">";
                XMLString2 = XMLString2 + name + "</name> ";
                tup = species.removeFirstNameInList();
            }
            if (hasNames) {
                XMLString2 = XMLString2 + "</nameList> ";
            }
            XMLString2 = XMLString2 + "</species> ";
        }
        XMLString2 = XMLString2 + "</speciesList> ";
        return XMLString2;
    }

    public static void parseTranslations(String propValue, Vector result) throws Exception {
        if (propValue.indexOf("<translation") != -1) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            propValue = "<myroot>" + propValue + "</myroot>";
            Document doc = db.parse(new ByteArrayInputStream(propValue.getBytes()));
            NodeList translationNodes = doc.getElementsByTagName("translation");
            for (int idx = 0; idx < translationNodes.getLength(); ++idx) {
                Element translation = (Element)translationNodes.item(idx);
                String translatedUrl = translation.getAttribute("xlink:href");
                String translationName = translation.getAttribute("xlink:title");
                int pos = translationName.indexOf(40);
                if (pos >= 0) {
                    translationName = translationName.substring(0, pos);
                }
                result.add(new TranslationProperty(translationName, translatedUrl));
            }
        }
    }

    public static void parseChildren(String propValue, Vector result) throws Exception {
        if (propValue.indexOf("<notebookroot") != -1) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(propValue.getBytes()));
            NodeList childNodes = doc.getElementsByTagName("child");
            for (int idx = 0; idx < childNodes.getLength(); ++idx) {
                Element child = (Element)childNodes.item(idx);
                String href = child.getAttribute("xlink:href");
                if (href == null || href.equals("")) {
                    href = child.getAttribute("href");
                }
                result.add(href);
            }
        }
    }

    public static void parseBag(String propValue, Vector result) throws Exception {
        if (propValue.indexOf("<Bag") != -1) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(propValue.getBytes()));
            NodeList liNodes = doc.getElementsByTagName("li");
            String item = null;
            Node content = null;
            for (int idx = 0; idx < liNodes.getLength(); ++idx) {
                Element el = (Element)liNodes.item(idx);
                NodeList children = el.getChildNodes();
                content = children.getLength() > 1 && children.item(1).getNodeType() == 1 ? children.item(1) : el.getFirstChild();
                if (content == null) {
                    item = new String();
                    result.add(item);
                    continue;
                }
                short type = content.getNodeType();
                switch (type) {
                    case 3: {
                        item = content.getNodeValue();
                        break;
                    }
                    case 1: {
                        XMLSerializer serializer = new XMLSerializer();
                        StringWriter strWriter = new StringWriter();
                        OutputFormat outFormat = new OutputFormat();
                        serializer.setOutputCharStream(strWriter);
                        serializer.setOutputFormat(outFormat);
                        serializer.serialize((Element)content);
                        item = strWriter.toString();
                        strWriter.close();
                    }
                }
                result.add(item);
            }
        }
    }

    public static void parseSpeciesList(String propValue, Vector result) throws Exception {
        if (propValue.indexOf("<speciesList") != -1) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(propValue.getBytes()));
            NodeList speciesNodes = doc.getElementsByTagName("species");
            for (int idx = 0; idx < speciesNodes.getLength(); ++idx) {
                NodeList nameNodesList;
                NodeList formNodesList;
                Element el = (Element)speciesNodes.item(idx);
                Species sp = new Species();
                NodeList casNodeList = el.getElementsByTagName("cas");
                if (casNodeList != null) {
                    Element casElement = (Element)casNodeList.item(0);
                    Node casNode = casElement.getFirstChild();
                    String casValue = casNode.getNodeValue();
                    sp.setCas(casValue);
                }
                if ((formNodesList = el.getElementsByTagName("formula")) != null) {
                    for (int formidx = 0; formidx < formNodesList.getLength(); ++formidx) {
                        Element formula = (Element)formNodesList.item(formidx);
                        Node formNode = formula.getFirstChild();
                        String formValue = formNode.getNodeValue();
                        String type = new String();
                        sp.addFormulaToList(formValue, type);
                    }
                }
                if ((nameNodesList = el.getElementsByTagName("name")) != null) {
                    for (int nameidx = 0; nameidx < nameNodesList.getLength(); ++nameidx) {
                        Element name = (Element)nameNodesList.item(nameidx);
                        Node nameNode = name.getFirstChild();
                        String nameValue = nameNode.getNodeValue();
                        String type = new String();
                        sp.addNameToList(nameValue, type);
                    }
                }
                result.add(sp);
            }
        }
    }

    public static boolean parseXlink(String propValue, Xlink link) throws Exception {
        boolean ret = false;
        if (propValue.indexOf("<href") != -1) {
            Document doc;
            NodeList hrefNode;
            Element hrefElement;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (!propValue.startsWith("<?xml version=", 0)) {
                propValue = "<myroot>" + propValue + "</myroot>";
            }
            if ((hrefElement = (Element)(hrefNode = (doc = db.parse(new ByteArrayInputStream(propValue.getBytes()))).getElementsByTagName("href")).item(0)).hasAttribute("xlink:href") || hrefElement.hasAttribute("xlink:role") || hrefElement.hasAttribute("xlink:type") || hrefElement.hasAttribute("xlink:title")) {
                String hrefStr = hrefElement.getAttribute("xlink:href");
                String roleStr = hrefElement.getAttribute("xlink:role");
                String typeStr = hrefElement.getAttribute("xlink:type");
                String titleStr = hrefElement.getAttribute("xlink:title");
                link.setHref(hrefStr);
                link.setTitle(titleStr);
                link.setType(typeStr);
                link.setRole(roleStr);
                ret = true;
            }
        }
        return ret;
    }

    public static boolean parseValue(String propValue, Vector result) throws Exception {
        boolean hasBag = false;
        try {
            PedigreeUtils.validateXml(propValue);
        }
        catch (SAXException e) {
            result.add(propValue);
            return hasBag;
        }
        if (propValue.indexOf("<Bag") != -1) {
            hasBag = true;
            Vector bagVector = new Vector();
            PedigreeUtils.parseBag(propValue, bagVector);
            for (int idx = 0; idx < bagVector.size(); ++idx) {
                String vectorContents = (String)bagVector.get(idx);
                if (vectorContents.indexOf("<href") != -1) {
                    Xlink newXlink = new Xlink();
                    if (PedigreeUtils.parseXlink(vectorContents, newXlink)) {
                        result.add(newXlink);
                        continue;
                    }
                    result.add(vectorContents);
                    continue;
                }
                result.add(vectorContents);
            }
        } else if (propValue.indexOf("<href") != -1) {
            Xlink newXlink = new Xlink();
            if (PedigreeUtils.parseXlink(propValue, newXlink)) {
                result.add(newXlink);
            } else {
                result.add(new String(propValue));
            }
        } else {
            result.add(new String(propValue));
        }
        return hasBag;
    }

    public static boolean isXlink(NSProperty propValue) {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        Vector xlinkProps = CMCSProperties.getPropertyAsNSPropertyVector("xlinkproperties");
        return xlinkProps.contains(propValue);
    }

    public static boolean supportsXlink(NSProperty propValue) {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        Vector maybeXlink = CMCSProperties.getPropertyAsNSPropertyVector("mayhavexlinkproperties");
        return maybeXlink.contains(propValue) || PedigreeUtils.isXlink(propValue);
    }

    public static boolean supportsSpecies(NSProperty propValue) {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        Vector speciesProps = CMCSProperties.getPropertyAsNSPropertyVector("speciesproperties");
        return speciesProps.contains(propValue);
    }

    public static boolean supportsMany(NSProperty propValue) throws Exception {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        Vector bagProps = CMCSProperties.getPropertyAsNSPropertyVector("bagproperties");
        return bagProps.contains(propValue);
    }

    public static String makeXML(Vector values, NSProperty property) throws Exception {
        return PedigreeUtils.makeXML(values, property, false);
    }

    public static String makeXML(Vector values, NSProperty property, boolean forceBag) throws Exception {
        String result = new String();
        if (values.size() > 0 && values.elementAt(0) instanceof Species) {
            result = PedigreeUtils.makeXMLforSpeciesList(values);
        } else {
            int idx;
            Vector<String> newValues = new Vector<String>();
            int size = values.size();
            for (idx = 0; idx < size; ++idx) {
                if (values.get(idx) instanceof Xlink) {
                    Xlink link = (Xlink)values.get(idx);
                    String XMLHrefString = PedigreeUtils.makeXMLforHref(link);
                    newValues.add(XMLHrefString);
                    continue;
                }
                newValues.add((String)values.get(idx));
            }
            if (PedigreeUtils.supportsMany(property) || forceBag || values.size() > 1) {
                result = PedigreeUtils.makeRDFBag(newValues);
            } else {
                for (idx = 0; idx < newValues.size(); ++idx) {
                    result = result + (String)newValues.get(idx);
                }
            }
        }
        return result;
    }

    public static void validateXml(String propValue) throws SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            CaptureErrorHandler er = new CaptureErrorHandler();
            db.setErrorHandler(er);
            mLogger.info("PedigreeUtils.validateXML" + propValue);
            String tmp = "<myroot>" + propValue + "</myroot>";
            Document doc = db.parse(new ByteArrayInputStream(tmp.getBytes()));
            if (er.isError()) {
                throw new SAXException("SAX ValidateError:" + tmp + "=>" + er.getMessages());
            }
        }
        catch (ParserConfigurationException e) {
            mLogger.severe("Error creating DocumentBuilder:\n" + e.toString() + "\n" + LoggerUtils.getStackTrace(e));
            throw new SAXException("Unable to create DocumentBuilder:" + e.getMessage());
        }
        catch (IOException e) {
            mLogger.severe("Unexpected I/O error:\n" + e.toString() + "\n" + LoggerUtils.getStackTrace(e));
            throw new SAXException("SAX IO Error" + e.getMessage());
        }
    }

    public static String getTextContent(String propValue) throws Exception {
        String ret = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new ByteArrayInputStream(propValue.getBytes()));
        NodeList children = doc.getDocumentElement().getChildNodes();
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            Node curNode = children.item(i);
            if (curNode.getNodeType() != 3) continue;
            ret = curNode.getNodeValue();
            break;
        }
        return ret;
    }

    public static void addCommonMetaData(String creator, String app, String version, Hashtable props) {
        Object ns = null;
        props.put(new NSProperty(CREATOR), creator);
        props.put(new NSProperty(CREATED), new SimpleDateFormat().getCurrentDateTimeAsString());
        props.put(new NSProperty(PROGRAMNAME), app);
        props.put(new NSProperty(PROGRAMVERSION), version);
        props.put(new NSProperty(COMPUTER), System.getProperty("os.arch"));
        props.put(new NSProperty(OPERATINGSYSTEM), System.getProperty("os.name") + " " + System.getProperty("os.version"));
    }
}

