// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Interface_ParamSet_HeaderFile
#define _Interface_ParamSet_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_Interface_ParamSet.hxx>

#include <Standard_PCharacter.hxx>
#include <Standard_Integer.hxx>
#include <Handle_Interface_ParamList.hxx>
#include <Handle_Interface_ParamSet.hxx>
#include <MMgt_TShared.hxx>
#include <Standard_CString.hxx>
#include <Interface_ParamType.hxx>
class Interface_ParamList;
class Standard_OutOfRange;
class Interface_FileParameter;


//! Defines an ordered set of FileParameters, in a way to be
//! efficient as in memory requirement or in speed
class Interface_ParamSet : public MMgt_TShared
{

public:

  
  //! Creates an empty ParamSet, beginning at number "nst" and of
  //! initial reservation "nres" : the "nres" first parameters
  //! which follow "ndeb" (included) will be put in an Array
  //! (a ParamList). The remainders are set in Next(s) ParamSet(s)
  Standard_EXPORT Interface_ParamSet(const Standard_Integer nres, const Standard_Integer nst = 1);
  
  //! Adds a parameter defined as its Value (CString and length) and
  //! Type. Optionnal EntityNumber (for FileReaderData) can be given
  //! Allows a better memory management than Appending a
  //! complete FileParameter
  //! If <lnval> < 0, <val> is assumed to be managed elsewhere : its
  //! adress is stored as such. Else, <val> is copied in a locally
  //! (quickly) managed Page of Characters
  //! Returns new count of recorded Parameters
  Standard_EXPORT   Standard_Integer Append (const Standard_CString val, const Standard_Integer lnval, const Interface_ParamType typ, const Standard_Integer nument) ;
  
  //! Adds a parameter at the end of the ParamSet (transparent
  //! about reservation and "Next")
  //! Returns new count of recorded Parameters
  Standard_EXPORT   Standard_Integer Append (const Interface_FileParameter& FP) ;
  
  //! Returns the total count of parameters (including nexts)
  Standard_EXPORT   Standard_Integer NbParams()  const;
  
  //! Returns a parameter identified by its number
  Standard_EXPORT  const  Interface_FileParameter& Param (const Standard_Integer num)  const;
  
  //! Same as above, but in order to be modified on place
  Standard_EXPORT   Interface_FileParameter& ChangeParam (const Standard_Integer num) ;
  
  //! Changes a parameter identified by its number
  Standard_EXPORT   void SetParam (const Standard_Integer num, const Interface_FileParameter& FP) ;
  
  //! Builds and returns the sub-list correspinding to parameters,
  //! from "num" included, with count "nb"
  //! If <num> and <nb> are zero, returns the whole list
  Standard_EXPORT   Handle(Interface_ParamList) Params (const Standard_Integer num, const Standard_Integer nb)  const;
  
  //! Destructor (waiting for transparent memory management)
  Standard_EXPORT   void Destroy() ;
~Interface_ParamSet()
{
  Destroy();
}



  DEFINE_STANDARD_RTTI(Interface_ParamSet)

protected:




private: 


  Standard_PCharacter theval;
  Standard_Integer thelnval;
  Standard_Integer thelnres;
  Standard_Integer thenbpar;
  Standard_Integer themxpar;
  Handle(Interface_ParamList) thelist;
  Handle(Interface_ParamSet) thenext;


};







#endif // _Interface_ParamSet_HeaderFile
