/*
 * clipboard.h
 *
 *
 * Authors:
 *  Richard Hult <rhult@hem.passagen.se>
 *  Ricardo Markiewicz <rmarkie@fi.uba.ar>
 *  Andres de Barbara <adebarbara@fi.uba.ar>
 *  Marc Lorber <lorber.marc@wanadoo.fr>
 *
 * Web page: https://ahoi.io/project/oregano
 *
 * Copyright (C) 1999-2001  Richard Hult
 * Copyright (C) 2003,2004  Ricardo Markiewicz
 * Copyright (C) 2009-2012  Marc Lorber
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __CLIPBOARD_H
#define __CLIPBOARD_H

typedef struct _ClipboardData ClipboardData;

typedef void (*ClipBoardFunction)(ClipboardData *data, gpointer user_data);

void clipboard_empty (void);
gboolean clipboard_is_empty (void);
void clipboard_foreach (ClipBoardFunction callback, gpointer user_data);
void clipboard_add_object (GObject *item);
GObjectClass *clipboard_data_get_item_class (ClipboardData *data);
GObject *clipboard_data_get_item_data (ClipboardData *data);

#endif
