/***************************************************************************
    begin       : Mon Jun 14 2010
    copyright   : (C) 2010 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

//#include <windows.h>

#include "Platform.h"
#include "UMDF_UsbCommunication.h"

#if defined(WIN_UMDF)
    #define ECA_REG_MAIN_PATH   "SOFTWARE\\REINER SCT\\cyberJackDriverPackage\\umdf"
#else
    #define ECA_REG_MAIN_PATH   "Software\\REINER SCT\\cyberJack Base Components"
#endif



CBaseCommunication *rsct_platform_create_com(const char *deviceName, CReader *reader) {
  CBaseCommunication *com=NULL;
  char *sc;

  sc=strdup(deviceName);
#ifdef UNDER_CE
  com=new CUSBCommunicationCe(sc, reader);
#else
  strupr(sc);
  if(strstr(sc, "USB"))
    com=new CUSBCommunication(sc, reader);
  else if (strstr(sc, "COM"))
	  com = new CSerialCommunication(sc, reader);

#ifdef WIN_UMDF
  else if (strstr(sc, "UMDF"))
	  com = new CUmdfUSBCommunication(*((UMDF_CALLBACK **)(deviceName+5)), reader);
  else if (strstr(sc, "UMD1"))
	  com = new CUmdfUSBCommunication(*((UMDF_CALLBACK_1 **)(deviceName + 5 + sizeof(UMDF_CALLBACK *))), reader);
#endif
#endif //UNDER_CE
  free(sc);

  return com;
}



const char *rsct_get_package_version(void) {
#ifndef UNDER_CE
  static char *Version=NULL;

  if (Version==NULL) {
    HKEY hKey;

    if(RegOpenKeyEx(HKEY_LOCAL_MACHINE, ECA_REG_MAIN_PATH,0,KEY_READ,&hKey)==ERROR_SUCCESS) {
      DWORD dwLength;

      dwLength=0;

      if(RegQueryValueEx (hKey,"VERSION",NULL,NULL,NULL,&dwLength)==ERROR_SUCCESS) {
        char *tempVersion=new char[dwLength+1];
        if (RegQueryValueEx (hKey,"VERSION",NULL,NULL,(LPBYTE)tempVersion,&dwLength)==ERROR_SUCCESS) {
          tempVersion[dwLength]='\0';
          Version=tempVersion;
        }
      }
      RegCloseKey(hKey);
    }
  }
  if (Version == 0)
      Version = "9.0.0";

  return Version;
#else
# error this function MUST be implemented for all OS
# error the package version MUST reflect all functional driver layers
# error the package version MAY NOT reflect physical driver layers (USB portdriver)
# error the package version MAY NOT reflect sychronisation layers (pcscd)
# error the version string MUST be one-dimensional, means MUST NOT consists of two or more concatenated version strings
#endif
}



uint32_t rsct_get_environment(const char *Name, uint32_t defval) {
#if !defined(UNDER_CE)
  HKEY hKey;
  unsigned long Result=defval;

  if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,
                   ECA_REG_MAIN_PATH,
                   0,
                   KEY_READ,
                   &hKey)==ERROR_SUCCESS) {
    DWORD dwLength;
    DWORD sCTHelp;

    dwLength=sizeof(sCTHelp);

    if (RegQueryValueEx(hKey, Name, NULL, NULL, (LPBYTE)&sCTHelp, &dwLength)==ERROR_SUCCESS) {
      Result=sCTHelp;
    }
    RegCloseKey(hKey);
  }
  return Result;
#else
  return defval;
#endif
}

const char *rsct_get_environment(const char *Name, const char * defval) {
  char *Result=NULL;
#if !defined(UNDER_CE)
  HKEY hKey;

  if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,
                   ECA_REG_MAIN_PATH,
                   0,
                   KEY_READ,
                   &hKey)==ERROR_SUCCESS) {
    DWORD dwLength;

    dwLength=0;

    if (RegQueryValueEx(hKey, Name, NULL, NULL, NULL, &dwLength)==ERROR_SUCCESS)
		{
			Result=new char[dwLength];
      if (RegQueryValueEx(hKey, Name, NULL, NULL, (LPBYTE)Result, &dwLength)!=ERROR_SUCCESS) {
         delete[] Result;
				 Result=NULL;
			}
    }
    RegCloseKey(hKey);
  }
#endif
	if(Result==NULL)
		Result=strdup(defval);
  return Result;
}




#ifdef _MANAGED
#pragma managed(push, off)
#endif



BOOL APIENTRY  DllMain( HANDLE	hModule, 
                       DWORD	ul_reason_for_call, 
                       LPVOID	lpReserved
					 )
{
	UNREFERENCED_PARAMETER(lpReserved);
	UNREFERENCED_PARAMETER(ul_reason_for_call);
	UNREFERENCED_PARAMETER(hModule);

//	::MessageBox (0,L"DllLoaded",L"cjeca_ce",MB_ICONSTOP);
    return TRUE;
}




/*
BOOL APIENTRY DllMain( HMODULE hModule,
                       uint32_t  ul_reason_for_call,
                       LPVOID lpReserved
					 )
{
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
	case DLL_PROCESS_DETACH:
		break;
	}
    return TRUE;
}


int _tmain(int argc, _TCHAR* argv[])
{
	return 0;
}*/


#ifdef _MANAGED
#pragma managed(pop)
#endif


