#include <stdlib.h>
#include <stdio.h>
#include <stdbool.h>
#include <assert.h>
#include <math.h>

/* MS only got around to adding 'isfinite',  asinh in VS2013 : */

#if defined( _MSC_VER) && (_MSC_VER < 1800)
   #include <float.h>
   #define isnan _isnan
#endif

long double geo_potential( const long double x, const long double y,
                                  const long double z, long double *derivs,
                                  int n_terms);   /* geo_pot.c */
double geo_potential_in_au( const double x, const double y, const double z,
                 double *derivs, const int n_terms);    /* geo_pot.c */

#define PI 3.1415926535897932384626433832795028841971693993751058209749445923

#ifdef __WATCOMC__
   /* OpenWATCOM apparently lacks sqrtl()... : */
static long double sqrtl( const long double ival)
{
   assert( ival > 0.);
   return( (long double)sqrt( (double)ival));
}
   /* ...and we have a smaller stack to work with : */
#define N_TERMS 10
#else
   /* Everyplace else,  we can go with a lot of spherical harmonic
   terms (more than are probably ever apt to be really needed) : */
#define N_TERMS 50
#endif

/* First few terms for the Earth geopotential expansion,  from  GGM03C

http://www.csr.utexas.edu/grace/gravity/
THE COMBINATION GRAVITY FIELD MODEL GGM03C
B. Tapley, J. Ries, S. Bettadpur, D. Chambers, M. Cheng, F. Condi, S. Poole
Eos Trans. AGU 88(52), Fall Meet. Suppl., Abstract G42A-03, 2007.    */

   static long double ggm03c_terms[] = {
//      1.000000000000E+00,  0.000000000000E+00,   /* 0 0 */
        0.000000000000E+00,  0.000000000000E+00,   /* 0 0 */

        0.000000000000E+00,  0.000000000000E+00,   /* 1 0 */
        0.000000000000E+00,  0.000000000000E+00,   /* 1 1 */

       -4.841693259705E-04,  0.000000000000E+00,   /* 2 0 */
       -2.189810040712E-10,  1.467451636117E-09,   /* 2 1 */
        2.439349093502E-06, -1.400284857733E-06    /* 2 2 */
#if( N_TERMS >= 3)
     ,  9.572141520460E-07,  0.000000000000E+00,   /* 3 0 */
        2.030465664514E-06,  2.482058936058E-07,   /* 3 1 */
        9.047902456370E-07, -6.189883025458E-07,   /* 3 2 */
        7.212791564398E-07,  1.414371726452E-06    /* 3 3 */
#endif
#if( N_TERMS >= 4)
     ,  5.399939212992E-07,  0.000000000000E+00,   /* 4 0 */
       -5.361485981769E-07, -4.735637114812E-07,   /* 4 1 */
        3.504959888509E-07,  6.624861198979E-07,   /* 4 2 */
        9.908596610199E-07, -2.009482969644E-07,   /* 4 3 */
       -1.885028579771E-07,  3.088181177841E-07    /* 4 4 */
#endif
#if( N_TERMS >= 5)
     ,  6.866459123078E-08,  0.000000000000E+00,   /* 5 0 */
       -6.292437578812E-08, -9.437639579747E-08,   /* 5 1 */
        6.520829513600E-07, -3.233447156874E-07,   /* 5 2 */
       -4.518631283604E-07, -2.149525780362E-07,   /* 5 3 */
       -2.953287028053E-07,  4.980758726087E-08,   /* 5 4 */
        1.748027838266E-07, -6.693662895546E-07    /* 5 5 */
#endif
#if( N_TERMS >= 6)
     , -1.499598315082E-07,  0.000000000000E+00,   /* 6 0 */
       -7.592679318459E-08,  2.651579309953E-08,   /* 6 1 */
        4.864305116787E-08, -3.737893103795E-07,   /* 6 2 */
        5.724155838410E-08,  8.951781823528E-09,   /* 6 3 */
       -8.601539327927E-08, -4.714232419474E-07,   /* 6 4 */
       -2.671803868285E-07, -5.364978063152E-07,   /* 6 5 */
        9.479463406484E-09, -2.373900388358E-07    /* 6 6 */
#endif
#if( N_TERMS >= 7)
     ,  9.050533439774E-08,  0.000000000000E+00,   /* 7 0 */
        2.808844953664E-07,  9.512526225104E-08,   /* 7 1 */
        3.304034289230E-07,  9.300153897576E-08,   /* 7 2 */
        2.504519105576E-07, -2.171158524106E-07,   /* 7 3 */
       -2.749960076819E-07, -1.240599610585E-07,   /* 7 4 */
        1.654111622021E-09,  1.793036569452E-08,   /* 7 5 */
       -3.588080478271E-07,  1.517987797259E-07,   /* 7 6 */
        1.519585748601E-09,  2.411089308219E-08    /* 7 7 */
#endif
#if( N_TERMS >= 8)
     ,  4.947717763987E-08,  0.000000000000E+00,   /* 8 0 */
        2.315213224240E-08,  5.889587918459E-08,   /* 8 1 */
        8.000904745527E-08,  6.528471379426E-08,   /* 8 2 */
       -1.937059244511E-08, -8.596167867757E-08,   /* 8 3 */
       -2.443554104084E-07,  6.980953427522E-08,   /* 8 4 */
       -2.570597539876E-08,  8.920039898598E-08,   /* 8 5 */
       -6.596539742152E-08,  3.089454690559E-07,   /* 8 6 */
        6.725805803981E-08,  7.486496285677E-08,   /* 8 7 */
       -1.240398774721E-07,  1.205432614900E-07    /* 8 8 */
#endif
#if( N_TERMS >= 9)
     ,  2.802144939761E-08,  0.000000000000E+00,   /* 9 0 */
        1.421474978635E-07,  2.139928699393E-08,   /* 9 1 */
        2.141353565702E-08, -3.169745130049E-08,   /* 9 2 */
       -1.606164564971E-07, -7.426942694866E-08,   /* 9 3 */
       -9.365864322082E-09,  1.990088295118E-08,   /* 9 4 */
       -1.630736109276E-08, -5.404137940019E-08,   /* 9 5 */
        6.278540857791E-08,  2.229662503132E-07,   /* 9 6 */
       -1.179868812654E-07, -9.692724908489E-08,   /* 9 7 */
        1.881423076311E-07, -3.000354849246E-09,   /* 9 8 */
       -4.755335402828E-08,  9.687123446288E-08    /* 9 9 */
#endif
#if( N_TERMS >= 10)
     ,  5.332872206339E-08,  0.000000000000E+00,   /* 10 0 */
        8.376111145897E-08, -1.310928645967E-07,   /* 10 1 */
       -9.399255140566E-08, -5.127653720129E-08,   /* 10 2 */
       -7.005368053537E-09, -1.541425435369E-07,   /* 10 3 */
       -8.446628400020E-08, -7.902664299306E-08,   /* 10 4 */
       -4.929098071452E-08, -5.061601820481E-08,   /* 10 5 */
       -3.758514495974E-08, -7.977013211026E-08,   /* 10 6 */
        8.260939438061E-09, -3.046340591979E-09,   /* 10 7 */
        4.059211174828E-08, -9.171581581980E-08,   /* 10 8 */
        1.253832700848E-07, -3.794425045512E-08,   /* 10 9 */
        1.004229077541E-07, -2.385629426228E-08    /* 10 10 */
#endif
#if( N_TERMS >= 11)
     , -5.076684067354E-08,  0.000000000000E+00,   /* 11 0 */
        1.561187804078E-08, -2.712348064969E-08,   /* 11 1 */
        2.011423100703E-08, -9.899946750685E-08,   /* 11 2 */
       -3.057925186015E-08, -1.488361487913E-07,   /* 11 3 */
       -3.795224682616E-08, -6.377016394095E-08,   /* 11 4 */
        3.742247518693E-08,  4.959112109226E-08,   /* 11 5 */
       -1.565920036827E-09,  3.427367173521E-08,   /* 11 6 */
        4.654747377856E-09, -8.982781854875E-08,   /* 11 7 */
       -6.301356391485E-09,  2.454773002353E-08,   /* 11 8 */
       -3.107538124489E-08,  4.207091340282E-08,   /* 11 9 */
       -5.224977584439E-08, -1.841642451641E-08,   /* 11 10 */
        4.623389723690E-08, -6.967357602229E-08    /* 11 11 */
#endif
#if( N_TERMS >= 12)
     ,  3.643698716802E-08,  0.000000000000E+00,   /* 12 0 */
       -5.358752398482E-08, -4.316458223037E-08,   /* 12 1 */
        1.426661258608E-08,  3.109064951397E-08,   /* 12 2 */
        3.962415995470E-08,  2.506149544819E-08,   /* 12 3 */
       -6.772572133772E-08,  3.839316687212E-09,   /* 12 4 */
        3.087560954874E-08,  7.588579694650E-09,   /* 12 5 */
        3.132644254277E-09,  3.898098866254E-08,   /* 12 6 */
       -1.905168826766E-08,  3.572792342750E-08,   /* 12 7 */
       -2.588852721232E-08,  1.693748226686E-08,   /* 12 8 */
        4.191770164809E-08,  2.496229497578E-08,   /* 12 9 */
       -6.199896784872E-09,  3.093427812562E-08,   /* 12 10 */
        1.136258459209E-08, -6.385321730657E-09,   /* 12 11 */
       -2.423026558875E-09, -1.111510144261E-08    /* 12 12 */
#endif
#if( N_TERMS >= 13)
     ,  4.173145479803E-08,  0.000000000000E+00,   /* 13 0 */
       -5.144000572708E-08,  3.869034387873E-08,   /* 13 1 */
        5.530988811097E-08, -6.269439481257E-08,   /* 13 2 */
       -2.155800022081E-08,  9.768510167924E-08,   /* 13 3 */
       -3.651797523913E-09, -1.175070318615E-08,   /* 13 4 */
        5.837167041440E-08,  6.722686386365E-08,   /* 13 5 */
       -3.504446356069E-08, -6.273525421439E-09,   /* 13 6 */
        3.015092155107E-09, -7.323017189905E-09,   /* 13 7 */
       -1.005497521179E-08, -9.857235841573E-09,   /* 13 8 */
        2.476679196786E-08,  4.589035920265E-08,   /* 13 9 */
        4.110412490315E-08, -3.683656180493E-08,   /* 13 10 */
       -4.452226413314E-08, -4.841568358339E-09,   /* 13 11 */
       -3.131887022807E-08,  8.793436179258E-08,   /* 13 12 */
       -6.120881679019E-08,  6.814363771627E-08    /* 13 13 */
#endif
#if( N_TERMS >= 14)
     , -2.266932614809E-08,  0.000000000000E+00,   /* 14 0 */
       -1.877109781623E-08,  2.886211920225E-08,   /* 14 1 */
       -3.591920480342E-08, -4.054659579019E-09,   /* 14 2 */
        3.651607433528E-08,  1.969199774505E-08,   /* 14 3 */
        1.602910566428E-09, -2.266180766986E-08,   /* 14 4 */
        2.930775661205E-08, -1.679010211399E-08,   /* 14 5 */
       -1.906970629630E-08,  2.456983563782E-09,   /* 14 6 */
        3.763036962799E-08, -3.933698459869E-09,   /* 14 7 */
       -3.494137393294E-08, -1.544686306971E-08,   /* 14 8 */
        3.195228258282E-08,  2.846426004693E-08,   /* 14 9 */
        3.880182386363E-08, -1.297935326294E-09,   /* 14 10 */
        1.564625400671E-08, -3.904229679272E-08,   /* 14 11 */
        8.460976772264E-09, -3.111925531137E-08,   /* 14 12 */
        3.224218717741E-08,  4.514881135110E-08,   /* 14 13 */
       -5.187076100301E-08, -4.822175650729E-09    /* 14 14 */
#endif
#if( N_TERMS >= 15)
     ,  2.191678708149E-09,  0.000000000000E+00,   /* 15 0 */
        9.430607665241E-09,  1.048343697123E-08,   /* 15 1 */
       -2.053202027793E-08, -3.029929942704E-08,   /* 15 2 */
        5.341304630709E-08,  1.766096915361E-08,   /* 15 3 */
       -4.017381916458E-08,  6.811721256429E-09,   /* 15 4 */
        1.224207146925E-08,  7.621491034307E-09,   /* 15 5 */
        3.285198624026E-08, -3.646985465262E-08,   /* 15 6 */
        5.965511978744E-08,  5.073057805615E-09,   /* 15 7 */
       -3.208864903358E-08,  2.217210257117E-08,   /* 15 8 */
        1.329848455013E-08,  3.799393471601E-08,   /* 15 9 */
        1.026325953351E-08,  1.469238135563E-08,   /* 15 10 */
       -1.305441830526E-09,  1.852183740538E-08,   /* 15 11 */
       -3.241821298600E-08,  1.560533743612E-08,   /* 15 12 */
       -2.836870432250E-08, -4.577079272453E-09,   /* 15 13 */
        5.200241654303E-09, -2.439700582238E-08,   /* 15 14 */
       -1.902751314587E-08, -4.690395287240E-09    /* 15 15 */
#endif
#if( N_TERMS >= 16)
     , -4.711399566556E-09,  0.000000000000E+00,   /* 16 0 */
        2.618495087563E-08,  3.334313589953E-08,   /* 16 1 */
       -2.451051568312E-08,  2.803047576995E-08,   /* 16 2 */
       -3.391353117356E-08, -2.133881575508E-08,   /* 16 3 */
        4.085472497887E-08,  4.798864908709E-08,   /* 16 4 */
       -1.212203260105E-08, -3.443409814726E-09,   /* 16 5 */
        1.387384159872E-08, -3.559593322814E-08,   /* 16 6 */
       -8.062457398106E-09, -8.651969069085E-09,   /* 16 7 */
       -2.120437927688E-08,  5.406987372004E-09,   /* 16 8 */
       -2.241391484986E-08, -3.966799165656E-08,   /* 16 9 */
       -1.180463195465E-08,  1.153517812657E-08,   /* 16 10 */
        1.911171902867E-08, -3.202892179004E-09,   /* 16 11 */
        1.956110670862E-08,  6.727712403290E-09,   /* 16 12 */
        1.377544553767E-08,  1.048199370467E-09,   /* 16 13 */
       -1.934458914407E-08, -3.864568321338E-08,   /* 16 14 */
       -1.441678809455E-08, -3.277186361861E-08,   /* 16 15 */
       -3.830521289156E-08,  2.968301836612E-09    /* 16 16 */
#endif
#if( N_TERMS >= 17)
     ,  1.918719953971E-08,  0.000000000000E+00,   /* 17 0 */
       -2.536543145807E-08, -3.170426084762E-08,   /* 17 1 */
       -2.010189539645E-08,  6.815146349676E-09,   /* 17 2 */
        6.307024280928E-09,  5.082451097863E-09,   /* 17 3 */
        6.474528752660E-09,  2.533573386703E-08,   /* 17 4 */
       -1.621865483036E-08,  8.029977568230E-09,   /* 17 5 */
       -1.173140106021E-08, -2.944033869246E-08,   /* 17 6 */
        2.497721913907E-08, -4.386121197077E-09,   /* 17 7 */
        3.899764336161E-08,  3.634136415772E-09,   /* 17 8 */
        3.478665021210E-09, -2.764039559622E-08,   /* 17 9 */
       -3.796898451483E-09,  1.837992072913E-08,   /* 17 10 */
       -1.601763828493E-08,  1.108739650175E-08,   /* 17 11 */
        2.871887934705E-08,  2.045542444509E-08,   /* 17 12 */
        1.650463723976E-08,  2.013518952097E-08,   /* 17 13 */
       -1.427460002951E-08,  1.157156500739E-08,   /* 17 14 */
        5.543854357519E-09,  5.246436145947E-09,   /* 17 15 */
       -3.040604279979E-08,  3.603514233845E-09,   /* 17 16 */
       -3.469797352459E-08, -1.987136609513E-08    /* 17 17 */
#endif
#if( N_TERMS >= 18)
     ,  6.099839777447E-09,  0.000000000000E+00,   /* 18 0 */
        7.200890117147E-09, -3.929714091901E-08,   /* 18 1 */
        1.472647784594E-08,  1.083323002301E-08,   /* 18 2 */
       -5.042582240325E-09, -5.848316066814E-09,   /* 18 3 */
        5.462655087026E-08, -7.860161155397E-10,   /* 18 4 */
        5.976326427116E-09,  2.613893031243E-08,   /* 18 5 */
        1.357755364840E-08, -1.324502398425E-08,   /* 18 6 */
        6.793356970878E-09,  7.468516247213E-09,   /* 18 7 */
        3.049947645139E-08,  4.344765543445E-09,   /* 18 8 */
       -1.956913241337E-08,  3.613054348158E-08,   /* 18 9 */
        5.217068039748E-09, -4.241339716815E-09,   /* 18 10 */
       -6.886866721953E-09,  2.116605907084E-09,   /* 18 11 */
       -2.975064394003E-08, -1.655920297382E-08,   /* 18 12 */
       -6.252742341601E-09, -3.493981100217E-08,   /* 18 13 */
       -8.293011190779E-09, -1.282545521655E-08,   /* 18 14 */
       -4.046414045990E-08, -2.027914008746E-08,   /* 18 15 */
        1.016009073262E-08,  6.504574931285E-09,   /* 18 16 */
        3.478630482906E-09,  4.375503328823E-09,   /* 18 17 */
        2.993575591165E-09, -1.084584548061E-08    /* 18 18 */
#endif
#if( N_TERMS >= 19)
     , -3.303611005089E-09,  0.000000000000E+00,   /* 19 0 */
       -8.973724128996E-09,  1.192749813314E-09,   /* 19 1 */
        3.573841904642E-08, -2.369569816465E-09,   /* 19 2 */
       -7.561456543083E-09,  1.102814055291E-09,   /* 19 3 */
        1.580732431302E-08, -8.141704769796E-09,   /* 19 4 */
        1.039028392344E-08,  2.745003294980E-08,   /* 19 5 */
       -4.800131208296E-09,  1.875575251336E-08,   /* 19 6 */
        5.641919836426E-09, -8.742734824356E-09,   /* 19 7 */
        2.988673869872E-08, -9.993347601634E-09,   /* 19 8 */
        3.287434355406E-09,  7.239278901713E-09,   /* 19 9 */
       -3.387904507824E-08, -7.578258578214E-09,   /* 19 10 */
        1.630428385441E-08,  1.035768243747E-08,   /* 19 11 */
       -2.441665985132E-09,  9.454576020749E-09,   /* 19 12 */
       -7.542804532513E-09, -2.852364813370E-08,   /* 19 13 */
       -4.743284023116E-09, -1.285332208711E-08,   /* 19 14 */
       -1.758836964655E-08, -1.407114090737E-08,   /* 19 15 */
       -2.174952059721E-08, -7.094966441354E-09,   /* 19 16 */
        2.880440044609E-08, -1.533916350067E-08,   /* 19 17 */
        3.501252894096E-08, -9.691506132019E-09,   /* 19 18 */
       -2.706463175805E-09,  5.199715479330E-09    /* 19 19 */
#endif
#if( N_TERMS >= 20)
     ,  2.155906358094E-08,  0.000000000000E+00,   /* 20 0 */
        5.567806135568E-09,  7.027894247596E-09,   /* 20 1 */
        2.029201703681E-08,  1.718421855552E-08,   /* 20 2 */
       -4.749736550698E-09,  3.890066401427E-08,   /* 20 3 */
        4.270381680578E-09, -2.262434522892E-08,   /* 20 4 */
       -1.012657231181E-08, -8.260342958671E-09,   /* 20 5 */
        1.216130160720E-08, -4.364779479425E-09,   /* 20 6 */
       -2.122679565023E-08, -7.051925039319E-10,   /* 20 7 */
        5.094555084680E-09,  2.153773580349E-09,   /* 20 8 */
        1.718739419353E-08, -7.013144414492E-09,   /* 20 9 */
       -3.229471482326E-08, -4.790123350912E-09,   /* 20 10 */
        1.445078164737E-08, -1.915322553215E-08,   /* 20 11 */
       -6.467900697722E-09,  1.813545667679E-08,   /* 20 12 */
        2.741357553594E-08,  6.763663996575E-09,   /* 20 13 */
        1.152838652450E-08, -1.437660240950E-08,   /* 20 14 */
       -2.578635379062E-08, -8.634630033803E-10,   /* 20 15 */
       -1.242821613571E-08, -3.458762829458E-10,   /* 20 16 */
        4.501894307532E-09, -1.372833289064E-08,   /* 20 17 */
        1.535957443561E-08, -8.919522021433E-10,   /* 20 18 */
       -3.027200881708E-09,  1.092102670580E-08,   /* 20 19 */
        3.734521298160E-09, -1.269812235124E-08    /* 20 20 */
#endif
#if( N_TERMS >= 21)
     ,  6.251370596805E-09,  0.000000000000E+00,   /* 21 0 */
       -1.615889192208E-08,  2.869255160899E-08,   /* 21 1 */
       -5.616669142444E-09,  4.178994773185E-09,   /* 21 2 */
        1.914457378933E-08,  2.272242433600E-08,   /* 21 3 */
       -5.110443439414E-09,  1.898497460527E-08,   /* 21 4 */
        2.607178873405E-09,  1.097486580948E-09,   /* 21 5 */
       -1.354999472709E-08,  1.299361237293E-11,   /* 21 6 */
       -6.610113794696E-09,  2.520845797836E-09,   /* 21 7 */
       -1.723219902874E-08,  2.148406365047E-09,   /* 21 8 */
        1.585516564710E-08,  9.079459097214E-09,   /* 21 9 */
       -1.140028751801E-08, -1.139776865651E-09,   /* 21 10 */
        6.893792521604E-09, -3.557820500236E-08,   /* 21 11 */
       -3.327893467118E-09,  1.477289349317E-08,   /* 21 12 */
       -1.936445125476E-08,  1.393881075421E-08,   /* 21 13 */
        2.026454910879E-08,  7.351410551322E-09,   /* 21 14 */
        1.757374547042E-08,  1.036888610948E-08,   /* 21 15 */
        7.488654452606E-09, -6.650981729082E-09,   /* 21 16 */
       -7.466407406915E-09, -7.375177537242E-09,   /* 21 17 */
        2.647474893486E-08, -1.107339977520E-08,   /* 21 18 */
       -2.720456475043E-08,  1.655388461706E-08,   /* 21 19 */
       -2.695007223244E-08,  1.592075535389E-08,   /* 21 20 */
        8.456909828626E-09, -3.653701496556E-09    /* 21 21 */
#endif
#if( N_TERMS >= 22)
     , -1.077794223838E-08,  0.000000000000E+00,   /* 22 0 */
        1.568162153797E-08, -3.840702987146E-09,   /* 22 1 */
       -2.648953865327E-08, -1.164831718953E-09,   /* 22 2 */
        1.134421764263E-08,  1.012149550458E-08,   /* 22 3 */
       -3.613988833116E-09,  1.872794673494E-08,   /* 22 4 */
        9.681753149397E-11, -3.185480615707E-10,   /* 22 5 */
        1.016445318467E-08, -5.508041696537E-09,   /* 22 6 */
        1.746404202183E-08,  4.748343852545E-09,   /* 22 7 */
       -2.349854267919E-08,  3.814912462647E-09,   /* 22 8 */
        6.683000441139E-09,  8.376708391365E-09,   /* 22 9 */
        5.627637776937E-09,  2.235138776381E-08,   /* 22 10 */
       -4.814627609889E-09, -1.756560291489E-08,   /* 22 11 */
        2.418096242155E-09, -8.208292831918E-09,   /* 22 12 */
       -1.715841666540E-08,  1.951244545527E-08,   /* 22 13 */
        1.087230065918E-08,  8.331043904076E-09,   /* 22 14 */
        2.577101921970E-08,  4.712711645894E-09,   /* 22 15 */
        1.090346517444E-10, -7.291582460108E-09,   /* 22 16 */
        8.567737628416E-09, -1.459506505103E-08,   /* 22 17 */
        1.019896759180E-08, -1.620174097242E-08,   /* 22 18 */
        1.405955155925E-08, -3.362623220086E-09,   /* 22 19 */
       -1.677211351188E-08,  1.958200832747E-08,   /* 22 20 */
       -2.531929263849E-08,  2.396586262267E-08,   /* 22 21 */
       -1.008569352447E-08,  2.334349296497E-09    /* 22 22 */
#endif
#if( N_TERMS >= 23)
     , -2.225920316255E-08,  0.000000000000E+00,   /* 23 0 */
        9.175175862564E-09,  1.619510078592E-08,   /* 23 1 */
       -1.439331652064E-08, -4.585678480642E-09,   /* 23 2 */
       -2.407806960989E-08, -1.749591750678E-08,   /* 23 3 */
       -2.386851340269E-08,  8.291853042697E-09,   /* 23 4 */
       -8.822695608885E-10,  1.649240375855E-10,   /* 23 5 */
       -1.192794464869E-08,  1.612966489173E-08,   /* 23 6 */
       -6.887458858845E-09, -1.914519670121E-09,   /* 23 7 */
        7.359742184708E-09,  1.810643029623E-10,   /* 23 8 */
        1.817800736148E-09, -1.284894083587E-08,   /* 23 9 */
        1.686166145583E-08, -2.269764791533E-09,   /* 23 10 */
        9.230256429363E-09,  1.429364657131E-08,   /* 23 11 */
        1.646514043385E-08, -1.201056568372E-08,   /* 23 12 */
       -1.161262520251E-08, -5.204577946762E-09,   /* 23 13 */
        6.956192034157E-09, -1.465840742834E-09,   /* 23 14 */
        1.894598167577E-08, -3.591191010097E-09,   /* 23 15 */
        5.904760651721E-09,  1.107897879461E-08,   /* 23 16 */
       -5.464119675160E-09, -1.293362638478E-08,   /* 23 17 */
        8.546100958298E-09, -1.481704711972E-08,   /* 23 18 */
       -5.476312661774E-09,  1.065458506257E-08,   /* 23 19 */
        7.971402434830E-09, -5.454970554903E-09,   /* 23 20 */
        1.571010377993E-08,  1.174310283846E-08,   /* 23 21 */
       -1.797650219459E-08,  4.732976976196E-09,   /* 23 22 */
        3.051192488872E-09, -1.204654000598E-08    /* 23 23 */
#endif
#if( N_TERMS >= 24)
     , -7.400484865791E-11,  0.000000000000E+00,   /* 24 0 */
       -2.730195285268E-09, -1.532882688182E-09,   /* 24 1 */
        9.594244302803E-10,  1.515419213564E-08,   /* 24 2 */
       -4.808517977690E-09, -9.734706227880E-09,   /* 24 3 */
        5.972297499320E-09,  5.089906666564E-09,   /* 24 4 */
       -7.118049883123E-09, -2.142633546177E-08,   /* 24 5 */
        3.622150602082E-09,  1.360296866252E-09,   /* 24 6 */
       -6.063949569602E-09,  4.917333187657E-09,   /* 24 7 */
        1.540704788414E-08, -3.608299816260E-09,   /* 24 8 */
       -1.157503471282E-08, -1.783577975274E-08,   /* 24 9 */
        1.097196445143E-08,  2.125756978910E-08,   /* 24 10 */
        1.518513348987E-08,  1.780212848397E-08,   /* 24 11 */
        1.148603191767E-08, -6.179208579820E-09,   /* 24 12 */
       -3.021764195718E-09,  2.934464223776E-09,   /* 24 13 */
       -1.995529267426E-08, -2.043088875442E-09,   /* 24 14 */
        6.359327224479E-09, -1.595529038531E-08,   /* 24 15 */
        8.445753471546E-09,  2.717137578757E-09,   /* 24 16 */
       -1.194085609401E-08, -6.438634839927E-09,   /* 24 17 */
       -3.669128888644E-10, -1.030306301941E-08,   /* 24 18 */
       -4.445100083593E-09, -8.674492136411E-09,   /* 24 19 */
       -5.657260163815E-09,  8.641659399962E-09,   /* 24 20 */
        5.537287797386E-09,  1.411797706603E-08,   /* 24 21 */
        3.993513090153E-09, -3.938014320970E-09,   /* 24 22 */
       -6.196982614615E-09, -8.822615997969E-09,   /* 24 23 */
        1.265817970589E-08, -3.689117832362E-09    /* 24 24 */
#endif
#if( N_TERMS >= 25)
     ,  3.206709768640E-09,  0.000000000000E+00,   /* 25 0 */
        6.371540723832E-09, -9.157248642574E-09,   /* 25 1 */
        2.271750606924E-08,  9.346552221724E-09,   /* 25 2 */
       -9.681603896360E-09, -1.430648318740E-08,   /* 25 3 */
        1.016232555075E-08,  2.968362557904E-10,   /* 25 4 */
       -1.104110918945E-08, -4.126922307036E-10,   /* 25 5 */
        1.627447085954E-08,  1.631007427500E-10,   /* 25 6 */
        9.593094696042E-09, -6.622827982918E-09,   /* 25 7 */
        2.081625502341E-09,  1.824099726776E-10,   /* 25 8 */
       -3.037358321414E-08,  2.295403913348E-08,   /* 25 9 */
        8.995344863654E-09, -4.417514706154E-09,   /* 25 10 */
        1.888978156198E-09,  1.031999266423E-08,   /* 25 11 */
       -7.761513839807E-09,  1.156954145835E-08,   /* 25 12 */
        7.963060208321E-09, -1.165064502174E-08,   /* 25 13 */
       -1.992343533828E-08,  6.559608778294E-09,   /* 25 14 */
       -4.445831710571E-09, -7.411978861748E-09,   /* 25 15 */
        1.302564294674E-09, -1.290021429970E-08,   /* 25 16 */
       -1.551238702293E-08, -3.705182194934E-09,   /* 25 17 */
        1.538685065169E-09, -1.488379630485E-08,   /* 25 18 */
        7.764354729047E-09,  9.804256853891E-09,   /* 25 19 */
       -7.983599965871E-09, -9.655986622373E-10,   /* 25 20 */
        1.069557092717E-08,  7.761539500825E-09,   /* 25 21 */
       -1.413743740599E-08,  3.860985288448E-09,   /* 25 22 */
        8.586762175111E-09, -1.263668453684E-08,   /* 25 23 */
        4.242602679120E-09, -8.399118155451E-09,   /* 25 24 */
        1.049021184869E-08,  4.941430258052E-09    /* 25 25 */
#endif
#if( N_TERMS >= 26)
     ,  5.893618072670E-09,  0.000000000000E+00,   /* 26 0 */
       -1.431371102800E-10, -6.648786066825E-09,   /* 26 1 */
       -1.586408518363E-09,  1.150377923939E-08,   /* 26 2 */
        1.510530147308E-08,  4.045218008006E-09,   /* 26 3 */
        1.907733249115E-08, -2.022605276855E-08,   /* 26 4 */
        1.315447505293E-08,  7.822854996024E-09,   /* 26 5 */
        9.603422309080E-09, -1.051504439264E-08,   /* 26 6 */
       -1.587186068640E-09,  4.447735647684E-09,   /* 26 7 */
        3.471007736543E-09,  1.781207227056E-09,   /* 26 8 */
       -1.309495562609E-08,  7.123629070978E-10,   /* 26 9 */
       -1.496890494869E-08, -5.660360476141E-09,   /* 26 10 */
       -4.626848270274E-09,  1.673506843852E-09,   /* 26 11 */
       -1.701202316238E-08,  2.329946166824E-09,   /* 26 12 */
       -1.756152247360E-10,  1.536100602626E-09,   /* 26 13 */
        7.669277713826E-09,  8.066712223915E-09,   /* 26 14 */
       -1.335462077029E-08,  8.298720983937E-09,   /* 26 15 */
        1.582752056564E-09, -6.402522666199E-09,   /* 26 16 */
       -1.200118725050E-08,  7.921553394885E-09,   /* 26 17 */
       -1.293506849310E-08,  4.899403731342E-09,   /* 26 18 */
       -2.263856727476E-09,  3.770126150680E-09,   /* 26 19 */
        6.230263235403E-09, -1.197997404224E-08,   /* 26 20 */
       -9.162408616574E-09,  1.941026806744E-09,   /* 26 21 */
        1.037661941701E-08,  7.063686462494E-09,   /* 26 22 */
        1.019833431649E-09,  1.072391244476E-08,   /* 26 23 */
        9.028055663719E-09,  1.478048212490E-08,   /* 26 24 */
        3.788602005733E-09, -5.845919648273E-10,   /* 26 25 */
        6.645801376768E-10,  2.079561312706E-09    /* 26 26 */
#endif
#if( N_TERMS >= 27)
     ,  3.613982249929E-09,  0.000000000000E+00,   /* 27 0 */
        2.861711342456E-09,  1.587585184672E-09,   /* 27 1 */
        6.603484137243E-10, -6.167433669393E-10,   /* 27 2 */
        3.530509303890E-09,  1.048207549818E-08,   /* 27 3 */
       -1.599657828199E-09,  8.058187869920E-09,   /* 27 4 */
        1.460863201501E-08,  1.499050507717E-08,   /* 27 5 */
        4.968549270145E-09,  6.411806598682E-09,   /* 27 6 */
       -1.113140649500E-08, -6.905524150781E-09,   /* 27 7 */
       -8.038117894224E-09, -8.763918798838E-09,   /* 27 8 */
        3.065585874713E-09,  1.127019363707E-08,   /* 27 9 */
       -1.351281069144E-08,  1.266828703104E-09,   /* 27 10 */
        2.236231680620E-09, -9.439396888840E-09,   /* 27 11 */
       -1.096513974620E-08,  2.068676402624E-09,   /* 27 12 */
       -4.572424571644E-09, -4.673293295486E-09,   /* 27 13 */
        1.533639036452E-08,  1.182107461821E-08,   /* 27 14 */
       -2.131908825316E-09,  1.470479907499E-09,   /* 27 15 */
        2.569578634251E-09,  3.171777060835E-09,   /* 27 16 */
        4.423596743417E-09,  5.035986142703E-10,   /* 27 17 */
       -2.071376040104E-09,  7.877693595215E-09,   /* 27 18 */
       -2.726455872931E-10, -2.402774046329E-09,   /* 27 19 */
       -1.269879326268E-09,  3.657840572071E-09,   /* 27 20 */
        4.925204350791E-09, -6.651839647743E-09,   /* 27 21 */
       -5.817957306566E-09,  2.890291604734E-09,   /* 27 22 */
       -5.320355826264E-09, -1.159995150737E-08,   /* 27 23 */
        3.822303524789E-10, -2.240759290126E-09,   /* 27 24 */
        1.209063082756E-08,  6.014385198071E-09,   /* 27 25 */
       -6.832640574450E-09, -2.385939030023E-09,   /* 27 26 */
        8.053261859972E-09,  1.071579308002E-09    /* 27 27 */
#endif
#if( N_TERMS >= 28)
     , -9.773824093722E-09,  0.000000000000E+00,   /* 28 0 */
       -5.277513444536E-09,  8.718952159890E-09,   /* 28 1 */
       -1.500901718089E-08, -8.255072575083E-09,   /* 28 2 */
        2.903359855271E-09,  1.018333071548E-08,   /* 28 3 */
       -1.412863558748E-09,  1.128509748409E-08,   /* 28 4 */
        1.197362482966E-08, -4.722106443514E-09,   /* 28 5 */
       -4.611842089581E-09,  1.292714877481E-08,   /* 28 6 */
       -2.587438899408E-09,  5.652127059006E-09,   /* 28 7 */
       -3.068471705935E-09, -1.756539082009E-09,   /* 28 8 */
        9.282028500257E-09, -1.269557481229E-08,   /* 28 9 */
       -1.062771368842E-08,  7.968635937290E-09,   /* 28 10 */
       -3.543948253165E-09, -1.840220811196E-09,   /* 28 11 */
       -8.668382043881E-10,  1.033790004629E-08,   /* 28 12 */
        2.126069910633E-09,  5.900480495348E-09,   /* 28 13 */
       -8.120356097421E-09, -1.286103814266E-08,   /* 28 14 */
       -1.224689015201E-08, -2.184978708631E-09,   /* 28 15 */
       -4.641145063367E-09, -1.328270775677E-08,   /* 28 16 */
        1.379795610058E-08, -4.978627525553E-09,   /* 28 17 */
        5.707462604172E-09, -3.333813521457E-09,   /* 28 18 */
        6.272964931926E-09,  2.410767374969E-08,   /* 28 19 */
       -1.522419312917E-09,  6.497575951724E-09,   /* 28 20 */
        6.776374100372E-09,  6.616486475831E-09,   /* 28 21 */
       -2.230820050289E-09, -7.311052175474E-09,   /* 28 22 */
        6.887594085801E-09,  2.669020538908E-09,   /* 28 23 */
        1.105854138833E-08, -1.388601102944E-08,   /* 28 24 */
        7.368565096995E-09, -1.745343645905E-08,   /* 28 25 */
        1.207209270360E-08,  3.826057453401E-09,   /* 28 26 */
       -8.035271236038E-09,  1.206682428294E-09,   /* 28 27 */
        6.813698196651E-09,  6.680546823427E-09    /* 28 28 */
#endif
#if( N_TERMS >= 29)
     , -5.278514809296E-09,  0.000000000000E+00,   /* 29 0 */
        4.028547559101E-09, -1.352980193199E-08,   /* 29 1 */
       -2.380068654799E-09, -2.442384426781E-09,   /* 29 2 */
        3.813546515856E-09, -1.157743224294E-08,   /* 29 3 */
       -2.538970630748E-08,  2.399501062659E-09,   /* 29 4 */
       -7.983228821083E-09,  5.956332562525E-09,   /* 29 5 */
        1.165064015423E-08,  1.038069662895E-08,   /* 29 6 */
       -3.589532603088E-09, -3.150093346915E-09,   /* 29 7 */
       -1.957953879998E-08,  9.578180566620E-09,   /* 29 8 */
        7.634268361244E-11,  2.693361299898E-09,   /* 29 9 */
        1.375972401385E-08,  5.324496381873E-11,   /* 29 10 */
       -6.229015473697E-09,  6.867264622705E-09,   /* 29 11 */
       -7.806039543052E-10, -4.857642401910E-09,   /* 29 12 */
       -1.448883320161E-09, -2.636630707426E-09,   /* 29 13 */
       -3.079438059161E-09, -4.723255424988E-09,   /* 29 14 */
       -9.484103281945E-09, -7.050591872949E-09,   /* 29 15 */
        1.518251086839E-10, -1.468144564844E-08,   /* 29 16 */
       -2.283677644219E-09, -4.713163158849E-09,   /* 29 17 */
       -3.551115556510E-09, -2.822297341350E-09,   /* 29 18 */
       -6.210937652561E-09,  6.814687496000E-09,   /* 29 19 */
       -8.120336101823E-09,  5.782667552292E-09,   /* 29 20 */
       -9.959021507144E-09, -5.139046865195E-09,   /* 29 21 */
        1.171396927717E-08, -1.239080849321E-09,   /* 29 22 */
       -1.911180984945E-09,  2.217794377852E-09,   /* 29 23 */
        3.097399678246E-10, -2.238624483960E-09,   /* 29 24 */
        5.788716619555E-09,  8.747735709532E-09,   /* 29 25 */
        7.859838086124E-09, -6.812889634950E-09,   /* 29 26 */
       -7.726061463970E-09, -7.185981798534E-10,   /* 29 27 */
        9.532678550612E-09, -5.741890704239E-09,   /* 29 28 */
        1.280128856698E-08, -5.218022488484E-09    /* 29 29 */
#endif
#if( N_TERMS >= 30)
     ,  6.256315749606E-09,  0.000000000000E+00,   /* 30 0 */
        2.729113960887E-10,  1.087073149988E-09,   /* 30 1 */
       -9.962042645335E-09, -1.172707037984E-09,   /* 30 2 */
        3.919062051013E-09, -1.373605434462E-08,   /* 30 3 */
       -1.665054498161E-09, -3.757687650882E-09,   /* 30 4 */
       -2.632268720726E-09, -5.674105647645E-09,   /* 30 5 */
       -1.598062828359E-10,  8.367434740453E-10,   /* 30 6 */
        2.392421164439E-09,  3.812827558631E-09,   /* 30 7 */
        4.655571609209E-09,  3.271126227544E-09,   /* 30 8 */
       -8.021580423668E-09, -1.170872147219E-08,   /* 30 9 */
        4.888430224355E-09, -4.955137932401E-09,   /* 30 10 */
       -9.549626151595E-09,  1.038678285896E-08,   /* 30 11 */
        1.709894231535E-08, -1.073808387187E-08,   /* 30 12 */
        1.379347851846E-08,  2.979238921459E-09,   /* 30 13 */
        4.836762997754E-09,  8.122402297461E-09,   /* 30 14 */
        6.592176740173E-10, -1.062580125185E-09,   /* 30 15 */
       -1.056722947979E-08,  4.140625278172E-09,   /* 30 16 */
       -6.882831497381E-09, -5.872892866821E-09,   /* 30 17 */
       -1.116132406483E-08, -7.965729460095E-09,   /* 30 18 */
       -1.363293081545E-08,  2.750130956147E-09,   /* 30 19 */
       -5.224345617430E-09,  1.333828157857E-08,   /* 30 20 */
       -1.166349667999E-08, -5.543090046975E-09,   /* 30 21 */
       -5.244853270775E-09, -8.708369275807E-09,   /* 30 22 */
        5.393496180115E-09, -1.097438602428E-08,   /* 30 23 */
       -2.738933147953E-09, -2.580115805263E-09,   /* 30 24 */
        3.078415893046E-09, -1.572052180194E-08,   /* 30 25 */
        1.355656039439E-09,  1.254861534110E-08,   /* 30 26 */
       -7.731538063628E-09,  1.255513461818E-08,   /* 30 27 */
       -5.826914080225E-09, -8.088408367804E-09,   /* 30 28 */
        3.942134726006E-09,  1.874354081113E-09,   /* 30 29 */
        2.587820428693E-09,  8.475154340484E-09    /* 30 30 */
#endif
#if( N_TERMS >= 31)
     ,  6.759314409067E-09,  0.000000000000E+00,   /* 31 0 */
        7.121189093734E-09, -1.847686878031E-08,   /* 31 1 */
        6.261884753730E-09,  5.116720272739E-09,   /* 31 2 */
       -6.595545649338E-09, -7.543200171057E-09,   /* 31 3 */
        1.139088231971E-08, -5.176418159076E-09,   /* 31 4 */
       -1.148131950230E-08,  5.456655046124E-09,   /* 31 5 */
       -8.471097516909E-11, -2.962874071552E-10,   /* 31 6 */
       -1.507203005359E-09, -1.342179140901E-09,   /* 31 7 */
       -3.134217611332E-09,  2.139072610337E-09,   /* 31 8 */
        9.049597121701E-10,  5.849364060007E-09,   /* 31 9 */
        4.370431937603E-09, -4.893673225855E-09,   /* 31 10 */
        1.986102653272E-09,  2.170494271513E-08,   /* 31 11 */
        5.730370959689E-10,  3.994664139533E-09,   /* 31 12 */
        9.756328604618E-09,  4.667189717097E-09,   /* 31 13 */
       -8.056701724066E-09,  3.233510728421E-09,   /* 31 14 */
        4.158546855886E-09, -2.363866136722E-09,   /* 31 15 */
       -6.881522880525E-09,  6.144414646252E-09,   /* 31 16 */
       -2.945316871347E-09,  6.851610890766E-09,   /* 31 17 */
       -5.297915658035E-10, -2.426988357832E-09,   /* 31 18 */
        2.141301647049E-09,  4.767334174575E-09,   /* 31 19 */
       -2.447045640665E-09,  5.730346321564E-09,   /* 31 20 */
       -9.954789268223E-09,  7.431428663834E-09,   /* 31 21 */
       -9.886300963609E-09, -1.122927783604E-08,   /* 31 22 */
        8.063415098825E-09,  4.305151681453E-09,   /* 31 23 */
       -2.895490564787E-09, -3.714335211396E-09,   /* 31 24 */
       -1.664039846245E-08, -1.759012695608E-09,   /* 31 25 */
       -1.285373760803E-08,  1.783796009790E-09,   /* 31 26 */
       -1.128725915915E-09,  1.102517255170E-08,   /* 31 27 */
        1.021373005512E-08,  2.840954687741E-09,   /* 31 28 */
       -2.017052039668E-09, -2.316821242562E-09,   /* 31 29 */
       -8.237588644052E-10, -8.138559161059E-09,   /* 31 30 */
       -8.818389523673E-09, -1.578445203501E-09    /* 31 31 */
#endif
#if( N_TERMS >= 32)
     , -2.400303950319E-09,  0.000000000000E+00,   /* 32 0 */
       -7.623115663754E-11,  3.579083377776E-09,   /* 32 1 */
        1.150336576052E-08, -2.872934786469E-09,   /* 32 2 */
       -4.178140066589E-10,  3.740566777046E-09,   /* 32 3 */
        1.974470942099E-09, -7.304449146407E-09,   /* 32 4 */
        9.633997883010E-09,  1.279717008753E-09,   /* 32 5 */
       -1.118748216901E-08, -8.393768566102E-09,   /* 32 6 */
        1.046064576029E-09,  4.452631351672E-09,   /* 32 7 */
        1.343961474020E-08,  7.283830145706E-09,   /* 32 8 */
        5.476695495158E-09, -1.484644002730E-09,   /* 32 9 */
       -1.417404046453E-09, -4.988557065431E-09,   /* 32 10 */
       -3.527507538217E-09,  7.912129534825E-09,   /* 32 11 */
       -1.708019437275E-08,  1.373929052842E-08,   /* 32 12 */
        4.138232031105E-09,  4.777461837649E-09,   /* 32 13 */
       -5.531024946720E-09,  1.960680161269E-09,   /* 32 14 */
        4.840996096090E-09, -8.417401780722E-09,   /* 32 15 */
        3.736820717566E-09,  3.871208553113E-09,   /* 32 16 */
       -6.505271452141E-09,  1.008935868077E-08,   /* 32 17 */
        1.302517186851E-08, -1.764905284611E-09,   /* 32 18 */
        7.000758955235E-10, -2.872939757780E-09,   /* 32 19 */
        2.963909723860E-09, -1.349278095083E-10,   /* 32 20 */
       -2.384758131957E-09,  1.169843262763E-08,   /* 32 21 */
       -1.227899264467E-08, -2.363339786134E-09,   /* 32 22 */
        7.668569484572E-09, -2.505154783153E-09,   /* 32 23 */
       -3.749777625138E-09,  1.425812354360E-10,   /* 32 24 */
       -1.933768533095E-08, -5.803579231931E-09,   /* 32 25 */
        5.363782743379E-09, -3.832371236576E-09,   /* 32 26 */
       -5.057343846140E-09, -6.697072987656E-09,   /* 32 27 */
        1.576362488773E-09, -5.697391978846E-09,   /* 32 28 */
        3.748034254598E-09,  2.992928835358E-09,   /* 32 29 */
       -6.927915918641E-09,  1.340815404284E-09,   /* 32 30 */
       -6.090504144136E-09, -2.942031372928E-10,   /* 32 31 */
        3.474176823032E-09,  1.269092885223E-09    /* 32 32 */
#endif
#if( N_TERMS >= 33)
     , -3.634596816254E-09,  0.000000000000E+00,   /* 33 0 */
       -1.751116934128E-09, -3.890533141544E-09,   /* 33 1 */
       -6.056340146743E-09,  2.323139739458E-09,   /* 33 2 */
       -3.914211700455E-10,  6.157959607407E-09,   /* 33 3 */
       -6.406284122937E-09,  5.088678734067E-09,   /* 33 4 */
       -3.248329418556E-10,  4.277448782430E-09,   /* 33 5 */
        5.147075937995E-10, -2.601723344517E-09,   /* 33 6 */
       -3.735379793511E-09,  7.375541629893E-10,   /* 33 7 */
       -4.002298975348E-09,  1.508139902661E-08,   /* 33 8 */
        5.240465624323E-09,  1.098696545195E-08,   /* 33 9 */
       -1.606057623918E-09,  1.143795757666E-09,   /* 33 10 */
        2.050748871859E-09, -6.680966150088E-09,   /* 33 11 */
       -1.001489958430E-09,  9.692703604595E-09,   /* 33 12 */
        2.058954327214E-09,  2.975497821069E-09,   /* 33 13 */
        4.881102300680E-09,  5.649189664442E-09,   /* 33 14 */
       -4.614169453928E-09, -3.472743477133E-09,   /* 33 15 */
        6.756973243607E-09,  5.607008062028E-09,   /* 33 16 */
       -5.186691823215E-09,  1.234581277538E-08,   /* 33 17 */
       -1.024327114800E-08, -2.945474316637E-09,   /* 33 18 */
        8.010413148011E-09,  2.278959121786E-09,   /* 33 19 */
       -3.544444604969E-09, -8.455952161526E-09,   /* 33 20 */
        8.111548635769E-10,  2.383634957261E-10,   /* 33 21 */
       -9.402227668491E-09, -1.534494303909E-08,   /* 33 22 */
       -3.449797024899E-10, -1.052201936741E-08,   /* 33 23 */
        1.110292991593E-08, -9.148893711610E-09,   /* 33 24 */
        5.083035527037E-09, -1.062208421463E-08,   /* 33 25 */
        1.030814161250E-08,  4.573777686866E-09,   /* 33 26 */
       -9.815334540163E-10,  1.063873062080E-09,   /* 33 27 */
        1.529736790765E-09, -7.889284742896E-10,   /* 33 28 */
       -1.643076591905E-08,  5.524647737175E-09,   /* 33 29 */
       -1.615137693127E-09, -1.842963693913E-08,   /* 33 30 */
        4.251910366817E-09,  8.498262050718E-10,   /* 33 31 */
        6.255988366533E-09, -4.700527124366E-09,   /* 33 32 */
       -1.695189698346E-09,  8.357922638772E-09    /* 33 33 */
#endif
#if( N_TERMS >= 34)
     , -8.935608920157E-09,  0.000000000000E+00,   /* 34 0 */
       -4.202708111558E-10,  6.530999051799E-09,   /* 34 1 */
        6.942744452950E-09,  7.542160531149E-09,   /* 34 2 */
        1.339670012648E-08,  8.555103107213E-09,   /* 34 3 */
       -8.084604779590E-09,  3.311277910826E-10,   /* 34 4 */
       -4.343891479482E-09,  2.637457025489E-09,   /* 34 5 */
       -7.338152468664E-10,  6.673874474695E-09,   /* 34 6 */
        2.125804796081E-09, -6.911742572115E-09,   /* 34 7 */
       -7.515492620948E-09,  6.165039575088E-09,   /* 34 8 */
        2.159060136352E-11, -2.176434413377E-10,   /* 34 9 */
       -9.528578115501E-09,  1.812957205835E-09,   /* 34 10 */
       -1.562717009301E-09, -8.398670810558E-10,   /* 34 11 */
        1.486367758883E-08, -4.160076972577E-09,   /* 34 12 */
       -3.384979378566E-09,  1.609515227235E-09,   /* 34 13 */
       -2.608686186659E-09,  9.736270318831E-09,   /* 34 14 */
        4.741109007211E-10,  6.006979898769E-09,   /* 34 15 */
       -1.996032794700E-09, -2.154187456174E-09,   /* 34 16 */
       -4.004830217152E-09,  2.718596125973E-09,   /* 34 17 */
       -1.369924385440E-08, -5.462351468698E-09,   /* 34 18 */
       -3.393071964949E-09,  6.543197411098E-09,   /* 34 19 */
        3.816874724656E-09, -9.820185526045E-09,   /* 34 20 */
       -1.951241851499E-09, -6.846061576285E-09,   /* 34 21 */
       -3.174101821852E-09,  3.669048526144E-09,   /* 34 22 */
       -9.986761743733E-10, -1.230956584992E-08,   /* 34 23 */
        8.037517978203E-09,  3.614706582211E-09,   /* 34 24 */
        8.475817364488E-09, -1.017024085979E-08,   /* 34 25 */
        3.611464685542E-09, -1.310466830406E-08,   /* 34 26 */
        1.270388583589E-08, -3.968334650183E-09,   /* 34 27 */
       -6.591326255477E-10, -1.995870317744E-08,   /* 34 28 */
        6.665457531671E-09, -4.255619256257E-09,   /* 34 29 */
       -2.074851211873E-08, -9.183194364555E-10,   /* 34 30 */
       -4.772514144116E-09, -1.973708917739E-09,   /* 34 31 */
        8.933795342198E-09,  1.812854647211E-09,   /* 34 32 */
        1.402653436811E-08,  4.296088391393E-09,   /* 34 33 */
       -8.765305491009E-09,  1.621950435846E-09    /* 34 34 */
#endif
#if( N_TERMS >= 35)
     ,  7.768200599803E-09,  0.000000000000E+00,   /* 35 0 */
       -1.254477935764E-08, -1.008161520468E-08,   /* 35 1 */
       -1.507320312194E-08,  7.116792934783E-09,   /* 35 2 */
        1.550295352236E-09,  2.288869695420E-09,   /* 35 3 */
       -2.551088273135E-09,  1.071690295048E-08,   /* 35 4 */
       -7.969021785680E-09, -1.112032303069E-08,   /* 35 5 */
        6.209809771039E-09,  9.378976511274E-09,   /* 35 6 */
       -3.205102377080E-09,  2.340160505501E-09,   /* 35 7 */
        1.502179132044E-09,  9.656712530062E-09,   /* 35 8 */
       -1.404704196197E-09, -2.227050130650E-10,   /* 35 9 */
       -2.287001854174E-09,  1.080018579927E-08,   /* 35 10 */
        2.193475957513E-09, -3.382937998585E-09,   /* 35 11 */
        8.941229161470E-09, -7.201379634390E-09,   /* 35 12 */
       -1.953063028543E-09,  4.068043606043E-09,   /* 35 13 */
       -6.439801274245E-09, -6.586330061798E-09,   /* 35 14 */
       -1.420684238052E-08,  8.685303471402E-09,   /* 35 15 */
       -5.955028281480E-09, -7.404553239665E-09,   /* 35 16 */
        1.124640719298E-09, -9.677785636606E-09,   /* 35 17 */
       -5.221313043323E-09, -1.097963309348E-08,   /* 35 18 */
       -1.280573133239E-09, -3.489792317875E-09,   /* 35 19 */
        1.132864972510E-09, -4.600890138182E-10,   /* 35 20 */
        1.265506912034E-08, -4.867169164180E-10,   /* 35 21 */
        6.512375165990E-09,  5.944665402628E-09,   /* 35 22 */
       -8.496181848687E-09, -2.430175176229E-09,   /* 35 23 */
        2.789355789789E-09,  5.312281672385E-09,   /* 35 24 */
        7.279373427377E-09,  1.742754761032E-09,   /* 35 25 */
       -4.422250117501E-09,  4.433314989437E-09,   /* 35 26 */
        1.107382883856E-08, -1.340740485575E-08,   /* 35 27 */
        7.439944346310E-09, -1.515002520854E-08,   /* 35 28 */
        7.489352698029E-09,  3.168257887725E-09,   /* 35 29 */
       -4.427430638240E-09,  2.883351310071E-09,   /* 35 30 */
        7.855489411822E-09,  3.604838978607E-09,   /* 35 31 */
       -3.461797922441E-09, -8.302654166944E-09,   /* 35 32 */
        5.642564224568E-09, -3.193553641910E-09,   /* 35 33 */
       -7.821642763204E-10,  2.796666863250E-09,   /* 35 34 */
       -5.958905043043E-09, -5.050973102503E-09    /* 35 35 */
#endif
#if( N_TERMS >= 36)
     , -3.654665269201E-09,  0.000000000000E+00,   /* 36 0 */
        4.795381877164E-11,  6.412144550322E-09,   /* 36 1 */
       -3.748999061066E-09, -2.875634405704E-09,   /* 36 2 */
       -2.121880289498E-09, -1.803677749200E-08,   /* 36 3 */
        4.931420323198E-09,  5.141446482507E-10,   /* 36 4 */
       -8.617431225132E-09, -2.478254539483E-10,   /* 36 5 */
        1.073284091301E-08, -3.083737115117E-09,   /* 36 6 */
        4.195208726160E-09,  6.768787274081E-09,   /* 36 7 */
        6.232662774407E-09, -4.553683774838E-09,   /* 36 8 */
        1.612907842322E-09, -1.031985928923E-09,   /* 36 9 */
        2.134196782753E-09,  6.401433719611E-09,   /* 36 10 */
       -3.853756956144E-09,  4.019116015447E-09,   /* 36 11 */
        2.173849949519E-10, -1.057330377083E-08,   /* 36 12 */
       -7.795454795543E-09,  6.974926503624E-09,   /* 36 13 */
       -1.170907087983E-08, -5.281753060895E-09,   /* 36 14 */
        1.898477071076E-09,  4.022972402286E-09,   /* 36 15 */
        2.039895246326E-09,  4.381821174977E-10,   /* 36 16 */
        5.431861026402E-09, -8.780498175673E-09,   /* 36 17 */
        2.036768943147E-09,  4.715869900414E-09,   /* 36 18 */
       -5.888553354114E-09, -6.372732839609E-09,   /* 36 19 */
       -6.110752629059E-09,  2.392013577549E-09,   /* 36 20 */
        1.108130281254E-08, -6.204740814910E-09,   /* 36 21 */
        3.171684503895E-09,  1.162429499875E-09,   /* 36 22 */
        8.818874650688E-11,  2.742062174183E-09,   /* 36 23 */
        1.452722624260E-09, -4.655627424610E-09,   /* 36 24 */
        4.848134640443E-09,  1.618058860130E-08,   /* 36 25 */
        4.059161189533E-09,  9.867831010537E-09,   /* 36 26 */
       -7.623765117874E-09,  9.028807479762E-09,   /* 36 27 */
        2.088305012812E-09, -4.134342830042E-09,   /* 36 28 */
        1.471095559663E-09, -1.397595328513E-10,   /* 36 29 */
       -1.023766699356E-08,  6.570100929431E-09,   /* 36 30 */
       -8.713335002220E-09, -5.330826033967E-09,   /* 36 31 */
        1.303071403334E-08,  2.151956762511E-09,   /* 36 32 */
        3.370060097109E-09, -3.872337787155E-09,   /* 36 33 */
       -8.962607760361E-09,  4.139485624026E-09,   /* 36 34 */
        1.807734946847E-10, -1.261035017111E-08,   /* 36 35 */
        4.971363703107E-09, -5.796800399662E-09    /* 36 36 */
#endif
#if( N_TERMS >= 37)
     , -5.709484973952E-09,  0.000000000000E+00,   /* 37 0 */
       -6.958444612523E-09, -1.290567875894E-09,   /* 37 1 */
       -2.166643716059E-09, -1.162873740392E-08,   /* 37 2 */
       -5.814159537003E-09, -7.921357546352E-11,   /* 37 3 */
        5.185937939174E-09,  2.183161548285E-09,   /* 37 4 */
       -9.300974119047E-09,  1.818314436438E-10,   /* 37 5 */
       -1.429620666648E-09,  8.671990040128E-09,   /* 37 6 */
        7.104081751537E-09,  8.566901326116E-09,   /* 37 7 */
       -3.328803163312E-09, -3.687244675725E-09,   /* 37 8 */
        3.911365387497E-09, -1.760742829583E-10,   /* 37 9 */
        4.696516028759E-09,  2.109534306891E-09,   /* 37 10 */
       -1.541642826769E-09,  4.105180162100E-09,   /* 37 11 */
       -1.595526568828E-09, -5.026990184099E-09,   /* 37 12 */
       -1.096779730885E-09, -7.069593096958E-09,   /* 37 13 */
       -4.101014996904E-09, -1.888912586430E-10,   /* 37 14 */
        9.467752934160E-09, -8.591090601309E-10,   /* 37 15 */
        3.180960305417E-09,  1.408276176776E-08,   /* 37 16 */
        5.787366410031E-09, -3.343408044699E-09,   /* 37 17 */
        2.191976959108E-09,  3.318078301340E-09,   /* 37 18 */
       -6.523526397976E-09,  1.636138842758E-10,   /* 37 19 */
       -7.129507030547E-09, -1.448358742676E-09,   /* 37 20 */
        1.217690906412E-09, -1.297089717166E-09,   /* 37 21 */
        6.654129567595E-09,  5.475211755174E-10,   /* 37 22 */
       -1.208467408875E-09,  3.863325990783E-09,   /* 37 23 */
       -8.767098196563E-09, -9.415719260255E-09,   /* 37 24 */
        6.676058905436E-09, -2.732186979607E-09,   /* 37 25 */
        5.151307099937E-09,  1.095188193489E-08,   /* 37 26 */
       -5.707213576359E-09,  4.872048841067E-09,   /* 37 27 */
        1.240584190469E-08,  4.046028294559E-09,   /* 37 28 */
        4.616219626251E-09,  6.167200285369E-09,   /* 37 29 */
       -8.561680710916E-09,  1.217647530956E-08,   /* 37 30 */
        3.349485955504E-09, -9.222566900876E-09,   /* 37 31 */
       -1.031816385742E-10,  4.281628680004E-09,   /* 37 32 */
        2.528510632368E-09, -1.623459673616E-08,   /* 37 33 */
        2.324722961804E-09,  5.039888709762E-10,   /* 37 34 */
       -1.022203033881E-08, -8.800265956797E-09,   /* 37 35 */
       -4.042235151955E-09, -4.395018690302E-09,   /* 37 36 */
        5.577006247258E-09, -4.086186660480E-09    /* 37 37 */
#endif
#if( N_TERMS >= 38)
     , -2.429064660302E-09,  0.000000000000E+00,   /* 38 0 */
        5.091399585529E-09,  3.143622050508E-09,   /* 38 1 */
        7.503114470670E-09, -1.189568310103E-09,   /* 38 2 */
       -1.329533191457E-09, -4.711877759426E-10,   /* 38 3 */
        6.246661470554E-09, -4.590970273069E-09,   /* 38 4 */
       -9.735421172856E-09,  9.265424812579E-09,   /* 38 5 */
       -1.262421508969E-08,  2.883445977815E-09,   /* 38 6 */
        2.070223630823E-09, -1.083046484512E-09,   /* 38 7 */
        3.904320369160E-09,  6.162550226236E-09,   /* 38 8 */
        3.728841271388E-09, -3.054730170404E-09,   /* 38 9 */
       -2.786692595690E-09, -5.567581452486E-09,   /* 38 10 */
        1.754442845178E-09,  7.419199998419E-09,   /* 38 11 */
       -3.805572186966E-09, -7.522083408036E-09,   /* 38 12 */
        2.470133478495E-09, -1.145834172078E-08,   /* 38 13 */
       -7.777448780738E-09,  3.963968537033E-09,   /* 38 14 */
        2.671660533794E-09, -2.628294766884E-09,   /* 38 15 */
       -6.050621373870E-09,  1.001616860993E-08,   /* 38 16 */
        2.783041998892E-09,  4.325403303974E-09,   /* 38 17 */
        9.082815796191E-09, -1.621270950469E-09,   /* 38 18 */
        1.163652568672E-09, -4.485486865355E-12,   /* 38 19 */
        4.629313804627E-09, -2.753333426184E-09,   /* 38 20 */
       -1.032606375632E-09,  3.460225485053E-09,   /* 38 21 */
        1.180462331045E-09,  7.611223124978E-09,   /* 38 22 */
       -1.534110720668E-09,  5.866948651713E-09,   /* 38 23 */
       -1.344205675177E-08,  1.645718618716E-09,   /* 38 24 */
       -3.690532125622E-09, -3.103083349846E-09,   /* 38 25 */
       -2.069954938965E-09,  5.401122231226E-09,   /* 38 26 */
       -2.333285977808E-09,  9.005267905959E-09,   /* 38 27 */
       -5.422323308079E-09, -4.764898383325E-09,   /* 38 28 */
        6.150159997365E-09,  2.757120178314E-09,   /* 38 29 */
       -9.495358615254E-11,  2.016039923190E-09,   /* 38 30 */
        4.023114290114E-09, -8.771955951567E-09,   /* 38 31 */
        7.936106626708E-09,  1.453223126137E-09,   /* 38 32 */
        3.131009563728E-09,  1.417465541126E-08,   /* 38 33 */
       -9.435818170787E-09,  3.531028199439E-09,   /* 38 34 */
        5.069563561995E-09,  2.301046830461E-09,   /* 38 35 */
        8.862043666536E-10, -1.235362944104E-09,   /* 38 36 */
       -3.827576408028E-09,  2.284170529174E-09,   /* 38 37 */
        2.811802300048E-09, -2.827300737169E-09    /* 38 38 */
#endif
#if( N_TERMS >= 39)
     ,  1.294853417758E-09,  0.000000000000E+00,   /* 39 0 */
       -4.430564775883E-09,  8.311247200756E-09,   /* 39 1 */
        3.065201059592E-09,  7.074771492572E-09,   /* 39 2 */
       -4.898907253612E-09,  6.062773428824E-09,   /* 39 3 */
       -4.340764231997E-09, -4.702101252112E-09,   /* 39 4 */
        4.635395991175E-09,  2.425192294173E-09,   /* 39 5 */
       -2.693556801749E-09,  2.455575509762E-09,   /* 39 6 */
        2.369376595127E-09, -1.100136340790E-09,   /* 39 7 */
        2.766524611188E-10,  1.260593424422E-08,   /* 39 8 */
        7.282245963017E-09,  5.271523716330E-09,   /* 39 9 */
        2.649556876232E-09,  6.736722524963E-10,   /* 39 10 */
        1.253749814647E-08, -2.256918909386E-09,   /* 39 11 */
       -3.403783513630E-09,  7.894670790377E-09,   /* 39 12 */
       -5.017553901732E-10, -6.417128402449E-09,   /* 39 13 */
       -2.906911558754E-09,  2.413194762081E-09,   /* 39 14 */
       -5.682688570105E-09, -7.933771833700E-10,   /* 39 15 */
        9.147020903701E-10, -2.598109081452E-09,   /* 39 16 */
       -1.420098296696E-09, -1.665050448052E-09,   /* 39 17 */
        1.821581930082E-09,  5.101276638377E-10,   /* 39 18 */
        5.051315923029E-09,  6.454791809617E-09,   /* 39 19 */
        2.526029971686E-10, -9.010994246708E-09,   /* 39 20 */
       -4.518575043486E-09,  1.104280622545E-09,   /* 39 21 */
       -6.365340452382E-09, -1.001459407740E-09,   /* 39 22 */
       -2.817156982224E-09,  5.768146235675E-09,   /* 39 23 */
       -9.775002717142E-09,  7.998167034392E-09,   /* 39 24 */
       -5.666665486678E-09, -5.534201252022E-09,   /* 39 25 */
       -3.708852164810E-09,  7.811243230080E-09,   /* 39 26 */
       -7.929041889146E-09, -2.557428249512E-09,   /* 39 27 */
       -3.433499515599E-09, -1.054155904838E-08,   /* 39 28 */
       -5.846543278256E-10, -3.101020509363E-09,   /* 39 29 */
        4.319187004881E-09, -1.054741311802E-08,   /* 39 30 */
        1.312647681604E-09, -1.121900883639E-08,   /* 39 31 */
        3.231257675321E-09,  4.372676971228E-09,   /* 39 32 */
       -5.830604055861E-09,  3.184107088036E-09,   /* 39 33 */
       -1.456712873507E-09,  3.301012998886E-09,   /* 39 34 */
       -1.388868189961E-08,  2.515712056633E-09,   /* 39 35 */
        4.521168671236E-09, -3.498783803397E-09,   /* 39 36 */
        8.708501536245E-10, -5.071214203484E-09,   /* 39 37 */
       -9.472800915536E-10,  7.548670182366E-09,   /* 39 38 */
       -1.213319142850E-10,  1.965784622490E-09    /* 39 39 */
#endif
#if( N_TERMS >= 40)
     , -6.219884759578E-09,  0.000000000000E+00,   /* 40 0 */
        3.807343607546E-09, -1.150225443260E-09,   /* 40 1 */
       -1.121968116947E-09,  4.462888665149E-10,   /* 40 2 */
       -1.175290227539E-09, -2.478685581233E-09,   /* 40 3 */
        6.660960411047E-09, -7.628175557063E-09,   /* 40 4 */
        1.231122674302E-08,  1.136156024855E-09,   /* 40 5 */
       -1.473742246815E-09,  3.090187344100E-09,   /* 40 6 */
       -2.150136499374E-10,  1.580529068603E-09,   /* 40 7 */
        6.112416032525E-09,  4.645270049013E-09,   /* 40 8 */
       -3.089226461411E-09,  9.332931348883E-10,   /* 40 9 */
       -5.196559425129E-09,  3.380771596121E-09,   /* 40 10 */
        4.470469231929E-09, -3.561813622844E-09,   /* 40 11 */
        7.095352185502E-09,  1.357648788728E-09,   /* 40 12 */
       -3.077209725324E-09, -5.813458070763E-09,   /* 40 13 */
       -1.242673153474E-09,  1.124449882102E-09,   /* 40 14 */
       -5.065030666627E-09, -1.776401637916E-09,   /* 40 15 */
       -1.450342689165E-09, -3.851358309839E-09,   /* 40 16 */
        5.467102645062E-10,  1.373267360318E-10,   /* 40 17 */
       -9.799472438969E-10,  9.692564464853E-10,   /* 40 18 */
       -2.020494977835E-09, -3.386840760685E-10,   /* 40 19 */
       -7.796036121601E-09,  7.629020842808E-09,   /* 40 20 */
       -3.484368859850E-09, -5.476549181020E-10,   /* 40 21 */
       -1.357986056697E-08, -1.575902355052E-08,   /* 40 22 */
       -2.177604721404E-11, -1.292674528757E-08,   /* 40 23 */
        4.242150450697E-09,  3.114275347739E-09,   /* 40 24 */
        7.489787120819E-10, -3.515780922744E-09,   /* 40 25 */
        7.204213369194E-09, -4.625184031228E-09,   /* 40 26 */
       -1.364503397966E-09,  2.217555074153E-09,   /* 40 27 */
        2.256499981819E-09,  6.903615404602E-09,   /* 40 28 */
        2.165476004083E-09,  2.637281567606E-09,   /* 40 29 */
       -8.997998209090E-11,  9.445161619828E-10,   /* 40 30 */
       -6.204378312611E-09, -1.096540278250E-09,   /* 40 31 */
       -1.910606484507E-09, -5.801501453178E-09,   /* 40 32 */
       -1.438296528054E-09, -1.317316039053E-09,   /* 40 33 */
        8.436675469255E-10,  1.521049161139E-09,   /* 40 34 */
        7.257399224461E-09, -8.394907536407E-09,   /* 40 35 */
        3.659781824766E-09,  6.420196649151E-09,   /* 40 36 */
       -5.446838734546E-09,  1.300727141880E-09,   /* 40 37 */
        3.719518928451E-10,  4.097957042283E-09,   /* 40 38 */
        6.468735147238E-09,  3.962664938053E-09,   /* 40 39 */
       -1.779451317694E-09,  6.015981960523E-10    /* 40 40 */
#endif
#if( N_TERMS >= 41)
     , -3.241319802548E-09,  0.000000000000E+00,   /* 41 0 */
       -7.143575016046E-09, -3.293533927483E-09,   /* 41 1 */
        3.614112513746E-09,  3.350223070581E-09,   /* 41 2 */
        3.939873238585E-09,  3.145735642010E-09,   /* 41 3 */
       -1.647563894979E-09,  3.730338809310E-09,   /* 41 4 */
        4.602694622858E-09, -3.023293054666E-09,   /* 41 5 */
        2.516621129813E-09,  1.505230292293E-09,   /* 41 6 */
       -7.098202549503E-10,  2.653481917831E-09,   /* 41 7 */
       -1.607904992772E-09, -4.545793995357E-09,   /* 41 8 */
       -1.678650768842E-09,  4.814074992810E-09,   /* 41 9 */
        5.729035063691E-09,  1.481148193973E-09,   /* 41 10 */
        2.576580830944E-09, -5.754909003170E-09,   /* 41 11 */
        4.720286369777E-09,  8.634698455609E-11,   /* 41 12 */
       -1.518257327185E-09,  6.411417468926E-09,   /* 41 13 */
        4.153178097977E-09, -3.735209458310E-10,   /* 41 14 */
       -9.741976759633E-10,  1.550526129211E-09,   /* 41 15 */
       -3.506441072213E-10, -4.508799342345E-09,   /* 41 16 */
       -1.942436127697E-09,  2.216197789087E-09,   /* 41 17 */
       -2.681835838935E-09,  4.270394893398E-09,   /* 41 18 */
       -2.046752085828E-09, -1.324933286990E-09,   /* 41 19 */
       -1.878340609835E-09, -6.648360397673E-10,   /* 41 20 */
       -2.204483549946E-09, -3.021426589537E-09,   /* 41 21 */
       -1.014398489201E-08, -2.383837904106E-09,   /* 41 22 */
        4.852899469772E-10, -1.397839699997E-08,   /* 41 23 */
        6.436777834428E-09, -2.113240169940E-09,   /* 41 24 */
        1.469600614198E-10,  2.832722164772E-09,   /* 41 25 */
        6.138062164960E-09, -8.232792441604E-09,   /* 41 26 */
        1.809210127374E-09, -7.483970911144E-10,   /* 41 27 */
       -1.688916200158E-09, -4.895714303557E-09,   /* 41 28 */
       -5.053582984875E-09,  5.809132799674E-09,   /* 41 29 */
        2.134578232831E-09, -7.943313880955E-10,   /* 41 30 */
        1.081425242233E-08,  5.551874534844E-10,   /* 41 31 */
       -2.241356339041E-09,  4.038031342148E-09,   /* 41 32 */
       -1.960491627781E-09,  1.074830049286E-08,   /* 41 33 */
       -2.741366800416E-09,  4.863404891514E-09,   /* 41 34 */
       -1.385748789944E-08,  4.121507723042E-09,   /* 41 35 */
        2.656691336905E-09, -2.995740666746E-09,   /* 41 36 */
        6.390568784001E-10, -1.018419362161E-08,   /* 41 37 */
       -1.055527831914E-08, -1.535161219226E-09,   /* 41 38 */
       -5.512912080292E-09, -2.609774203346E-09,   /* 41 39 */
        3.959727750219E-09, -4.770119883179E-09,   /* 41 40 */
        4.138927091849E-09,  5.794460296649E-09    /* 41 41 */
#endif
#if( N_TERMS >= 42)
     , -2.208273511867E-09,  0.000000000000E+00,   /* 42 0 */
       -2.274562307404E-09, -3.787958488800E-10,   /* 42 1 */
       -3.815604968062E-09, -2.883583611173E-09,   /* 42 2 */
       -3.728517814390E-11,  9.946160657427E-09,   /* 42 3 */
        7.110421388059E-09,  1.425262528302E-09,   /* 42 4 */
       -9.629948289045E-09, -3.358596373898E-09,   /* 42 5 */
        3.480859724857E-09, -1.218612907486E-09,   /* 42 6 */
        4.072413956735E-09, -3.255693175091E-09,   /* 42 7 */
        7.720979639560E-10,  8.186220764424E-10,   /* 42 8 */
       -6.888729584871E-10,  1.623966301070E-09,   /* 42 9 */
        3.432011005070E-09,  5.456443203005E-09,   /* 42 10 */
        1.195311025492E-09,  1.931013243927E-09,   /* 42 11 */
        3.946961559448E-09, -1.009235812520E-08,   /* 42 12 */
        7.170734921115E-10,  4.247018752821E-09,   /* 42 13 */
       -7.046139769241E-09,  5.457916494061E-09,   /* 42 14 */
       -1.088868972832E-09,  7.351885395201E-09,   /* 42 15 */
        4.174158016393E-09, -2.805202434613E-09,   /* 42 16 */
       -1.644163719166E-09, -3.209456955481E-09,   /* 42 17 */
       -1.214929242137E-08,  1.841479942793E-09,   /* 42 18 */
       -2.825605853385E-09, -5.738904459409E-09,   /* 42 19 */
        6.650612688353E-09,  8.151465968437E-10,   /* 42 20 */
        4.474257215816E-10, -4.512681400024E-09,   /* 42 21 */
        9.966667162065E-10, -3.483613047182E-09,   /* 42 22 */
       -4.305033348045E-09, -4.658050740354E-09,   /* 42 23 */
        4.663081640399E-09,  1.333771580945E-09,   /* 42 24 */
       -4.081408676977E-09,  4.319947531117E-09,   /* 42 25 */
       -2.515060560123E-09, -6.359730864449E-09,   /* 42 26 */
        6.760264719651E-09, -2.334152037337E-09,   /* 42 27 */
       -5.051868966251E-09,  2.168942753796E-09,   /* 42 28 */
       -5.914722642500E-09, -2.711943782515E-09,   /* 42 29 */
        3.370718563982E-09,  6.952539469001E-10,   /* 42 30 */
        6.091698747744E-09,  4.596309717010E-09,   /* 42 31 */
        7.034591473012E-09,  5.166829523583E-09,   /* 42 32 */
        6.383496170194E-09,  6.349929648268E-09,   /* 42 33 */
        3.007384663183E-09,  1.128467660087E-08,   /* 42 34 */
       -5.510256631407E-09,  1.990199498921E-10,   /* 42 35 */
        4.634449616506E-09, -5.393297133328E-09,   /* 42 36 */
       -7.021939963426E-09,  3.264868406600E-09,   /* 42 37 */
        2.500777713798E-09, -1.305476897702E-08,   /* 42 38 */
        4.307351277897E-09,  9.852980238968E-09,   /* 42 39 */
        1.467093578847E-09, -2.848830963704E-09,   /* 42 40 */
        5.106036753499E-10, -4.389068975781E-11,   /* 42 41 */
       -6.488517223183E-09,  2.834077933497E-09    /* 42 42 */
#endif
#if( N_TERMS >= 43)
     ,  6.462672299696E-09,  0.000000000000E+00,   /* 43 0 */
       -4.890610792092E-09,  4.193266640049E-09,   /* 43 1 */
       -9.441320210995E-09, -1.348500242389E-09,   /* 43 2 */
        5.124404266765E-10, -1.445616407947E-10,   /* 43 3 */
        1.831910715021E-09,  9.162696202067E-10,   /* 43 4 */
       -8.878349737488E-09,  6.489563283677E-09,   /* 43 5 */
        6.275864379640E-09,  9.460776760462E-11,   /* 43 6 */
       -1.445998289758E-09,  5.792274047503E-09,   /* 43 7 */
       -5.640727006485E-10, -3.635216091739E-10,   /* 43 8 */
       -1.433031857177E-09, -6.170200830860E-09,   /* 43 9 */
       -3.534388819942E-10,  1.416976535699E-09,   /* 43 10 */
       -5.263753342682E-09,  5.335243895903E-09,   /* 43 11 */
       -1.914220971024E-09,  4.634690302574E-10,   /* 43 12 */
        2.218153549155E-09, -1.436707158228E-09,   /* 43 13 */
       -5.075711050410E-09,  3.406121059004E-09,   /* 43 14 */
        3.886409906623E-09,  6.705907297104E-09,   /* 43 15 */
        2.389636727985E-09,  8.040044746796E-10,   /* 43 16 */
        4.445719633477E-09, -4.367537891395E-09,   /* 43 17 */
       -3.191438445687E-09, -4.110705857804E-09,   /* 43 18 */
       -5.544772167716E-09, -6.956730234379E-09,   /* 43 19 */
       -8.714818530137E-10,  4.959691006305E-10,   /* 43 20 */
        3.383088927422E-09,  5.394615646361E-09,   /* 43 21 */
        5.515634741580E-09, -2.251009894132E-09,   /* 43 22 */
       -9.438179397851E-12, -6.276379771092E-09,   /* 43 23 */
        4.740800278924E-09, -1.969226919699E-09,   /* 43 24 */
        1.410317550204E-09,  3.237629516645E-09,   /* 43 25 */
       -3.895833062544E-09,  3.158249647469E-09,   /* 43 26 */
        4.871933641204E-09,  7.512056075434E-11,   /* 43 27 */
       -1.639071799818E-09,  8.346087638948E-09,   /* 43 28 */
       -2.427434775702E-09,  7.409163819743E-10,   /* 43 29 */
       -9.902584301896E-09, -8.776873845923E-09,   /* 43 30 */
       -4.332668245979E-09, -7.487088067588E-10,   /* 43 31 */
       -3.834719096211E-09,  5.550969467179E-09,   /* 43 32 */
        4.951940640354E-09, -9.875938280547E-10,   /* 43 33 */
        3.263050255153E-09,  7.438627076003E-10,   /* 43 34 */
       -2.008057984331E-09,  5.086401929645E-09,   /* 43 35 */
        6.049572353399E-10, -3.769746915650E-09,   /* 43 36 */
        3.457226636057E-09,  5.470857020756E-09,   /* 43 37 */
       -6.485437310769E-09,  8.179223807722E-10,   /* 43 38 */
        4.735254148060E-09, -3.280646737774E-09,   /* 43 39 */
        1.107904676665E-08,  7.885435187638E-10,   /* 43 40 */
       -1.963186793002E-09,  3.118513150859E-09,   /* 43 41 */
       -8.547070679120E-09,  3.948506055716E-09,   /* 43 42 */
       -3.361235357979E-09, -8.160628856802E-09    /* 43 43 */
#endif
#if( N_TERMS >= 44)
     ,  3.413677245776E-10,  0.000000000000E+00,   /* 44 0 */
        5.802220995923E-09, -2.166349517225E-09,   /* 44 1 */
       -6.247348356186E-10,  3.440310423355E-09,   /* 44 2 */
       -4.405464323707E-10, -4.181676744220E-09,   /* 44 3 */
        1.517253656067E-09, -1.259813332691E-09,   /* 44 4 */
        5.005535432884E-10,  4.033338750192E-09,   /* 44 5 */
       -7.177234105635E-09,  2.480947939137E-09,   /* 44 6 */
        5.245750260913E-09,  9.550843473544E-09,   /* 44 7 */
       -4.602989235623E-09, -1.256530132580E-09,   /* 44 8 */
       -6.790317552013E-10, -6.194891587983E-09,   /* 44 9 */
       -3.636849250106E-09, -6.088719421766E-09,   /* 44 10 */
       -1.254198105629E-09, -1.315280062104E-09,   /* 44 11 */
       -3.737419442682E-09, -1.280214289875E-09,   /* 44 12 */
        1.314898682595E-09, -6.372081405218E-09,   /* 44 13 */
       -6.066792448566E-09, -2.895905016716E-09,   /* 44 14 */
        1.730615506777E-09, -6.166817109239E-09,   /* 44 15 */
        4.458231869976E-09,  6.342609481360E-09,   /* 44 16 */
        4.623234159620E-09,  1.567324303039E-09,   /* 44 17 */
        5.869916694159E-09, -3.866234218336E-09,   /* 44 18 */
        2.711698007636E-11, -4.779947753839E-09,   /* 44 19 */
       -2.107557908245E-09,  3.782673162394E-10,   /* 44 20 */
       -7.311414826649E-09,  4.219192946909E-11,   /* 44 21 */
        5.338705207776E-09,  1.308146441552E-09,   /* 44 22 */
        1.463859849900E-09,  8.284114099665E-09,   /* 44 23 */
       -1.800301552563E-10, -8.111009452405E-09,   /* 44 24 */
        4.189469511364E-09,  1.220578732794E-10,   /* 44 25 */
       -4.190332613320E-09,  1.033076913910E-09,   /* 44 26 */
        3.691966153874E-09, -2.983403741621E-09,   /* 44 27 */
       -1.788564963519E-10,  5.329221101594E-09,   /* 44 28 */
       -6.849196747751E-09,  5.212734662952E-09,   /* 44 29 */
        4.736671743227E-09,  1.989552847645E-09,   /* 44 30 */
       -4.970301027387E-10,  2.695666213163E-09,   /* 44 31 */
       -4.065651852016E-09,  1.697091991493E-09,   /* 44 32 */
       -5.252605361803E-09, -3.099317058039E-10,   /* 44 33 */
       -3.415153179066E-09,  5.950484773094E-09,   /* 44 34 */
       -7.518983132616E-09, -2.916899533463E-09,   /* 44 35 */
        2.538454566892E-09, -7.827275215176E-09,   /* 44 36 */
        1.088551258482E-08,  6.737494338617E-09,   /* 44 37 */
        3.509883551668E-09, -6.139654075693E-09,   /* 44 38 */
        6.259254512716E-09,  3.246620495218E-09,   /* 44 39 */
       -3.850804878732E-09,  6.600055780479E-09,   /* 44 40 */
        3.207413483540E-09, -1.412103434417E-09,   /* 44 41 */
       -7.381430514504E-10, -8.829791571151E-10,   /* 44 42 */
        2.160760541866E-09, -3.018239137148E-09,   /* 44 43 */
        2.819847685152E-09, -1.704728591300E-09    /* 44 44 */
#endif
#if( N_TERMS >= 45)
     , -3.252083190278E-09,  0.000000000000E+00,   /* 45 0 */
        3.413264922945E-09, -4.601572909311E-09,   /* 45 1 */
        2.056822424065E-09, -3.305435912465E-09,   /* 45 2 */
       -1.342559241634E-09, -5.942284796136E-09,   /* 45 3 */
        3.398188178441E-10, -2.601008160773E-09,   /* 45 4 */
        1.125728472410E-09, -1.457994661223E-09,   /* 45 5 */
       -6.221856609418E-09, -8.475761549441E-10,   /* 45 6 */
        5.257673281470E-10,  3.445445154788E-09,   /* 45 7 */
       -2.019476892938E-09,  9.587282855170E-10,   /* 45 8 */
        8.356906611882E-09, -6.465910899537E-09,   /* 45 9 */
       -1.794629625334E-09, -1.520805779155E-09,   /* 45 10 */
        4.290808015423E-10, -2.858554018699E-09,   /* 45 11 */
       -3.932914837024E-09, -1.573066607604E-09,   /* 45 12 */
       -2.531939384558E-09, -9.731805365745E-10,   /* 45 13 */
        1.438585145564E-09, -3.603983833566E-09,   /* 45 14 */
       -3.841337870293E-09, -2.293600924938E-10,   /* 45 15 */
        6.234183598619E-09,  1.112252311367E-09,   /* 45 16 */
        2.812521518258E-09, -1.688859992057E-09,   /* 45 17 */
        1.204021028813E-09, -5.234137729320E-09,   /* 45 18 */
       -4.763212242772E-09, -2.318560725051E-09,   /* 45 19 */
        5.011201604196E-09,  3.318863089664E-09,   /* 45 20 */
       -3.350509336823E-09, -1.051075362677E-09,   /* 45 21 */
        3.153075083444E-09,  4.525803321178E-09,   /* 45 22 */
        2.849547355811E-09,  4.147985441027E-09,   /* 45 23 */
       -1.062674627900E-08,  4.546981204995E-09,   /* 45 24 */
        8.843722751091E-09, -3.911371831585E-09,   /* 45 25 */
       -1.354257765344E-09,  6.224685666107E-09,   /* 45 26 */
       -6.549872151724E-09,  2.769590272397E-10,   /* 45 27 */
        6.056139446937E-09, -1.266908901656E-10,   /* 45 28 */
       -8.072503501643E-09, -3.164058741355E-09,   /* 45 29 */
       -1.785408702717E-09, -8.700290352076E-10,   /* 45 30 */
       -1.058991357619E-09, -6.096405062879E-09,   /* 45 31 */
       -5.829594080977E-10, -2.903934018081E-09,   /* 45 32 */
       -1.943558854376E-09, -2.384065228053E-09,   /* 45 33 */
       -2.479127649245E-09,  5.477910940402E-09,   /* 45 34 */
       -6.877044942205E-09,  8.295016789881E-09,   /* 45 35 */
       -8.913613896588E-09,  7.256479774253E-09,   /* 45 36 */
       -6.008038845491E-09,  4.378803489977E-09,   /* 45 37 */
       -4.535764373276E-09,  4.043397227502E-09,   /* 45 38 */
       -2.013165983024E-09, -7.581044471026E-09,   /* 45 39 */
        3.456431283405E-09, -3.728757664730E-09,   /* 45 40 */
        9.794800684677E-10,  7.053998842201E-10,   /* 45 41 */
       -1.478762399244E-09, -1.099241955208E-08,   /* 45 42 */
        4.330872135405E-09,  1.056024985810E-09,   /* 45 43 */
        1.127420762627E-08,  3.109748421506E-09,   /* 45 44 */
       -5.003449281823E-10,  5.176428661987E-10    /* 45 45 */
#endif
#if( N_TERMS >= 46)
     , -3.107312673777E-09,  0.000000000000E+00,   /* 46 0 */
        1.761204010120E-09, -2.287650212269E-10,   /* 46 1 */
        5.111746054695E-09,  3.149086864478E-09,   /* 46 2 */
       -1.714163987906E-09, -1.476036274843E-10,   /* 46 3 */
        1.097504547429E-09, -7.057451638701E-09,   /* 46 4 */
       -3.227302304654E-09, -1.049211167949E-08,   /* 46 5 */
       -4.480852160072E-09, -2.385037094465E-09,   /* 46 6 */
        5.494771911543E-09, -8.731784321957E-09,   /* 46 7 */
       -1.918901697680E-11,  4.288755130810E-09,   /* 46 8 */
        8.548133702308E-09,  5.203252023138E-09,   /* 46 9 */
        3.009722945950E-09, -1.313546225865E-09,   /* 46 10 */
       -2.736031270411E-09, -4.135332372122E-09,   /* 46 11 */
       -2.298867017588E-09, -1.055021802702E-10,   /* 46 12 */
       -5.314936038652E-09, -3.427942552744E-09,   /* 46 13 */
        2.449742148770E-10, -7.487334561814E-11,   /* 46 14 */
       -5.284060265339E-09, -7.839220809292E-10,   /* 46 15 */
        2.076272395929E-09,  4.678553954533E-09,   /* 46 16 */
       -4.796376094409E-09,  7.468350925839E-10,   /* 46 17 */
        3.001163093188E-09, -4.620739755018E-09,   /* 46 18 */
       -8.277545166359E-10, -2.654956543242E-09,   /* 46 19 */
       -2.885841837432E-09, -3.933193388691E-09,   /* 46 20 */
       -5.773358498163E-09,  3.100529557415E-09,   /* 46 21 */
        6.898652647719E-09,  1.552418375839E-09,   /* 46 22 */
        2.900357892693E-09,  3.447953864319E-09,   /* 46 23 */
       -3.397393576212E-09,  6.152365536123E-10,   /* 46 24 */
        3.835735415447E-09, -7.264034753092E-09,   /* 46 25 */
        4.263374652474E-09,  1.171861127998E-08,   /* 46 26 */
       -2.574032680835E-09, -2.674711864798E-10,   /* 46 27 */
       -6.584214054606E-10, -5.003151462269E-09,   /* 46 28 */
       -2.484927042273E-09, -3.206444937322E-09,   /* 46 29 */
       -4.990477224058E-09, -7.096524230182E-09,   /* 46 30 */
       -1.874242582409E-09, -1.267997171146E-09,   /* 46 31 */
       -1.325186263555E-10, -3.705690025745E-09,   /* 46 32 */
        1.574657664187E-08,  4.068449469582E-10,   /* 46 33 */
       -1.631398954142E-09,  3.061804730218E-09,   /* 46 34 */
       -5.890594214603E-09,  1.389079474543E-09,   /* 46 35 */
       -1.039252106723E-09, -1.985998356129E-09,   /* 46 36 */
       -4.143164507744E-09,  6.080966108120E-09,   /* 46 37 */
       -5.620850125447E-09, -1.984933001704E-09,   /* 46 38 */
        7.182953007941E-09, -2.040287603732E-10,   /* 46 39 */
        1.682191204733E-10, -1.079156253247E-09,   /* 46 40 */
       -1.629193426120E-10, -6.227527146573E-09,   /* 46 41 */
        1.145036912772E-09,  6.832163800426E-09,   /* 46 42 */
       -2.700450858415E-09,  1.206455680232E-08,   /* 46 43 */
        2.830130833120E-09, -3.036658938602E-09,   /* 46 44 */
       -1.005140569152E-09,  4.981380458166E-09,   /* 46 45 */
        2.842393341414E-10, -2.599390929514E-09    /* 46 46 */
#endif
#if( N_TERMS >= 47)
     ,  9.363423781410E-10,  0.000000000000E+00,   /* 47 0 */
       -6.924947813044E-09, -1.291342693013E-09,   /* 47 1 */
        4.354197602951E-09, -2.732710105952E-09,   /* 47 2 */
        1.097018522473E-09,  2.415842734018E-09,   /* 47 3 */
        5.609905383113E-10, -1.738999235589E-09,   /* 47 4 */
       -1.773140433737E-09, -2.327313277193E-09,   /* 47 5 */
        3.041716048537E-09, -4.167154208619E-09,   /* 47 6 */
        4.320467091012E-10, -2.430980224415E-09,   /* 47 7 */
        6.449818435991E-09, -6.760434444723E-10,   /* 47 8 */
       -8.547044323899E-10,  3.216704399513E-09,   /* 47 9 */
        4.000981547071E-09,  3.870319753489E-09,   /* 47 10 */
        4.479835018600E-10, -3.729234612194E-09,   /* 47 11 */
        1.076891456714E-08,  1.962792796370E-09,   /* 47 12 */
       -2.441683380505E-09, -7.246833013034E-10,   /* 47 13 */
        1.058367790713E-09,  4.749744439954E-10,   /* 47 14 */
       -2.054768144967E-09,  5.743678659476E-10,   /* 47 15 */
       -7.417296553008E-10, -1.403009184599E-09,   /* 47 16 */
       -2.081144682905E-09,  2.495903567548E-09,   /* 47 17 */
       -1.907610136780E-09,  7.796778348522E-09,   /* 47 18 */
        2.366246717052E-09,  3.610878781065E-09,   /* 47 19 */
       -1.025649487891E-08,  1.562084030175E-09,   /* 47 20 */
       -5.672781596491E-09, -7.950664476938E-10,   /* 47 21 */
       -7.640029318963E-09, -5.012782928915E-10,   /* 47 22 */
        3.243599442538E-09,  6.697204999831E-10,   /* 47 23 */
       -5.786148068735E-10, -1.498309088940E-09,   /* 47 24 */
       -2.186792316086E-09, -9.127840637975E-09,   /* 47 25 */
        8.266945496873E-09,  1.322961599402E-09,   /* 47 26 */
       -5.858065122754E-09, -1.481375923784E-09,   /* 47 27 */
        1.728250497381E-09, -5.996381077345E-09,   /* 47 28 */
        5.394976291530E-09,  6.325969526270E-10,   /* 47 29 */
       -3.066586296133E-09,  2.594317229896E-09,   /* 47 30 */
        7.571004091895E-10,  1.708774531528E-09,   /* 47 31 */
       -1.576901742430E-09, -6.068364780530E-10,   /* 47 32 */
       -4.905256263036E-09,  3.176255877293E-09,   /* 47 33 */
        9.485690447722E-10,  2.929853378690E-09,   /* 47 34 */
       -8.340125494818E-09, -7.265262446097E-11,   /* 47 35 */
        7.248741365009E-09, -4.482854955326E-09,   /* 47 36 */
        8.065869769152E-09,  1.043677735374E-09,   /* 47 37 */
        4.493607725074E-10,  1.612498906340E-09,   /* 47 38 */
       -1.295442454423E-09,  8.839938333244E-09,   /* 47 39 */
       -8.726280791899E-09,  7.892721355882E-09,   /* 47 40 */
       -3.360093718813E-09,  4.548842744109E-09,   /* 47 41 */
       -1.896541600400E-09, -5.892547803144E-09,   /* 47 42 */
        1.546838584478E-09,  3.777373418589E-09,   /* 47 43 */
       -2.936269452698E-09,  1.020877615618E-08,   /* 47 44 */
        6.229344793020E-09,  3.407473414943E-09,   /* 47 45 */
       -6.566133406980E-10, -4.183688894881E-09,   /* 47 46 */
        2.695331417697E-09, -6.171994242556E-09    /* 47 47 */
#endif
#if( N_TERMS >= 48)
     ,  3.516484661374E-09,  0.000000000000E+00,   /* 48 0 */
        1.426496635901E-09,  3.458042986962E-09,   /* 48 1 */
        4.718612628786E-09,  2.893956834861E-09,   /* 48 2 */
       -1.232447251981E-09,  3.319854600861E-09,   /* 48 3 */
        4.130618284495E-10, -1.700481311931E-10,   /* 48 4 */
        6.528992828899E-09, -2.123058191547E-09,   /* 48 5 */
        5.907946018783E-09,  8.079515616760E-09,   /* 48 6 */
       -1.615753221470E-09,  1.422483365147E-09,   /* 48 7 */
        1.044657548864E-09,  3.985556511888E-09,   /* 48 8 */
       -1.490379187919E-09,  3.832138647967E-09,   /* 48 9 */
       -2.200283122916E-10,  1.580307859677E-09,   /* 48 10 */
        1.105896306586E-09,  1.276246117740E-09,   /* 48 11 */
        1.118760100047E-10, -2.795934287065E-09,   /* 48 12 */
        1.729641432302E-09, -2.362569151842E-10,   /* 48 13 */
       -6.251257377199E-10, -6.876274274835E-11,   /* 48 14 */
        4.204519262533E-09,  1.657451435958E-09,   /* 48 15 */
       -5.020513045038E-10,  1.600791237488E-09,   /* 48 16 */
        9.683186563979E-10,  3.442722635884E-09,   /* 48 17 */
       -6.851928650883E-10,  1.110455823092E-09,   /* 48 18 */
       -1.194580976706E-09,  4.475030539210E-09,   /* 48 19 */
       -4.758604636513E-09,  4.638012015485E-09,   /* 48 20 */
        1.534427850905E-09, -2.852990124588E-09,   /* 48 21 */
       -6.690462410527E-09,  2.803955495332E-09,   /* 48 22 */
       -2.369812624939E-09, -3.598819074310E-10,   /* 48 23 */
       -4.818178305117E-09, -1.063486324973E-09,   /* 48 24 */
       -3.900631454582E-09,  1.770093301246E-09,   /* 48 25 */
       -6.644863496378E-10, -6.688181636866E-09,   /* 48 26 */
       -8.466187205165E-09,  5.266727390266E-09,   /* 48 27 */
        3.107266565649E-10, -7.867812805975E-09,   /* 48 28 */
        2.310043159489E-09, -5.936078721582E-09,   /* 48 29 */
       -1.098632751831E-09, -9.280780190718E-10,   /* 48 30 */
       -6.633898220141E-10, -3.063543251780E-09,   /* 48 31 */
        3.405609972483E-09, -2.099456692244E-09,   /* 48 32 */
        1.857383972314E-09,  1.609024178835E-09,   /* 48 33 */
        3.814353199172E-10,  7.401815043550E-09,   /* 48 34 */
       -5.121269563649E-09,  9.414540749502E-10,   /* 48 35 */
       -4.434567085509E-09, -7.051222658581E-10,   /* 48 36 */
       -1.590408889193E-09, -4.999480816575E-09,   /* 48 37 */
       -8.940497792843E-09, -1.219193200480E-09,   /* 48 38 */
        4.419201822721E-09, -7.678805615470E-09,   /* 48 39 */
        8.266884898309E-10,  4.655196525858E-09,   /* 48 40 */
       -2.545391115559E-09, -9.918692997547E-09,   /* 48 41 */
        2.379102501931E-09,  2.193879594064E-09,   /* 48 42 */
        3.810472403609E-09,  5.255195131986E-09,   /* 48 43 */
        1.548477272008E-10, -8.885934763302E-11,   /* 48 44 */
        5.865126322165E-09,  4.686502323662E-09,   /* 48 45 */
       -3.099347559284E-09,  8.840254775885E-09,   /* 48 46 */
        3.686377717824E-09,  3.896954251557E-09,   /* 48 47 */
        5.570783337802E-09, -2.092452656966E-09    /* 48 48 */
#endif
#if( N_TERMS >= 49)
     ,  2.038461913001E-10,  0.000000000000E+00,   /* 49 0 */
        6.643654611360E-09, -1.900308055967E-09,   /* 49 1 */
       -3.496246414178E-10,  9.898826116484E-10,   /* 49 2 */
        7.936902208274E-10,  1.686082782315E-09,   /* 49 3 */
        7.051303912889E-10,  8.014537676213E-09,   /* 49 4 */
        1.103827622063E-09,  1.541991371523E-09,   /* 49 5 */
       -8.834041864416E-10,  1.669620729665E-09,   /* 49 6 */
        3.243471384094E-09,  4.919064069623E-09,   /* 49 7 */
        2.547879530891E-10,  3.114674823092E-09,   /* 49 8 */
        7.424659178173E-11,  5.311745606202E-09,   /* 49 9 */
       -7.322779467393E-09, -1.180335357803E-09,   /* 49 10 */
        5.747315476802E-09,  3.971972883447E-09,   /* 49 11 */
       -3.036825784004E-09, -3.071136000128E-09,   /* 49 12 */
        3.929942746223E-09,  6.279784956672E-09,   /* 49 13 */
        4.239847040033E-10, -1.544004770843E-09,   /* 49 14 */
       -1.471006351895E-09,  6.192811257735E-10,   /* 49 15 */
       -5.215528959384E-11, -6.728691018641E-09,   /* 49 16 */
       -1.595921422110E-09, -1.144122675655E-09,   /* 49 17 */
       -2.294403453967E-09, -3.110399299535E-09,   /* 49 18 */
       -2.173000071198E-09,  5.220716940638E-10,   /* 49 19 */
        5.417469741128E-09, -8.169675864694E-11,   /* 49 20 */
       -2.111927001938E-09, -4.702734578966E-09,   /* 49 21 */
       -6.521719926612E-11,  3.806538629379E-09,   /* 49 22 */
        2.098860846188E-09, -1.117857071399E-10,   /* 49 23 */
        3.842849434229E-09,  1.264667066575E-09,   /* 49 24 */
       -5.247300899215E-09,  5.765363636503E-09,   /* 49 25 */
       -8.389473647577E-09, -1.396096978394E-09,   /* 49 26 */
       -3.955404214074E-09,  2.580833438016E-09,   /* 49 27 */
       -3.778262583486E-09, -1.117874967339E-08,   /* 49 28 */
       -1.915551666371E-10, -1.566614772636E-09,   /* 49 29 */
        3.283681714712E-09,  3.697440556167E-09,   /* 49 30 */
       -5.304796088638E-10, -6.345690579123E-09,   /* 49 31 */
        1.679769729008E-09, -5.935738641160E-09,   /* 49 32 */
        2.625272545057E-09, -1.228817523543E-09,   /* 49 33 */
        4.546442653134E-09,  1.021200652534E-09,   /* 49 34 */
        3.250213132831E-09,  5.602789694161E-09,   /* 49 35 */
       -4.632840295099E-09,  2.251342311430E-09,   /* 49 36 */
       -1.789512032112E-09,  1.264096347586E-09,   /* 49 37 */
        2.874137773096E-09, -2.048981297857E-09,   /* 49 38 */
        1.902151420427E-09,  1.644127624931E-09,   /* 49 39 */
       -3.287866340502E-09,  1.569877358283E-09,   /* 49 40 */
       -2.331274478967E-09, -2.376413179279E-09,   /* 49 41 */
       -2.867031145649E-09, -4.760239399804E-10,   /* 49 42 */
        5.510985756262E-09, -7.354647731385E-09,   /* 49 43 */
        5.760828134464E-09,  7.890494915575E-09,   /* 49 44 */
        1.157088638427E-09, -1.091025352233E-09,   /* 49 45 */
        2.460693665701E-09,  4.602159533513E-10,   /* 49 46 */
        3.237204343963E-09,  1.333649594159E-09,   /* 49 47 */
       -1.577065117898E-09,  8.681447931375E-10,   /* 49 48 */
        2.552221440364E-09,  2.860176686223E-09    /* 49 49 */
#endif
#if( N_TERMS >= 50)
     , -4.844161606601E-09,  0.000000000000E+00,   /* 50 0 */
        3.507768398078E-09,  3.054339303586E-10,   /* 50 1 */
       -8.057895759191E-09, -1.632795969404E-09,   /* 50 2 */
       -9.134069058477E-11, -5.225485314272E-10,   /* 50 3 */
       -8.369767304508E-09,  3.576721510092E-10,   /* 50 4 */
        6.208496308162E-11, -2.746553361506E-09,   /* 50 5 */
       -3.329300947428E-10,  3.170156774121E-09,   /* 50 6 */
        2.110476932138E-09,  3.096603561807E-09,   /* 50 7 */
       -3.722045622293E-09, -2.278648730767E-10,   /* 50 8 */
       -2.257336641769E-09,  2.664098367763E-09,   /* 50 9 */
       -2.746082584143E-09, -2.074383518302E-09,   /* 50 10 */
       -2.233229194863E-09,  1.703993115519E-09,   /* 50 11 */
       -5.512667399912E-09,  5.063569684866E-09,   /* 50 12 */
       -9.515521173616E-10, -5.557715290799E-11,   /* 50 13 */
       -2.477681968510E-09,  3.319986830118E-09,   /* 50 14 */
       -3.300393615426E-09, -2.951462212229E-10,   /* 50 15 */
       -2.608613453834E-09, -5.268341930931E-09,   /* 50 16 */
        6.846193351349E-10, -2.986729817814E-09,   /* 50 17 */
        1.955856442777E-09, -3.841427869943E-09,   /* 50 18 */
        5.926860482521E-10,  4.814289651490E-10,   /* 50 19 */
        1.725639945337E-09, -2.148649122611E-09,   /* 50 20 */
       -2.919011466994E-10, -4.441255126039E-10,   /* 50 21 */
        1.087865097559E-09, -5.657756217896E-10,   /* 50 22 */
       -1.963432264867E-09, -5.449631857371E-09,   /* 50 23 */
        9.308509807516E-09, -6.823277731120E-10,   /* 50 24 */
        4.771048180034E-09,  2.621955788485E-09,   /* 50 25 */
       -8.762488639956E-09, -1.899303369454E-09,   /* 50 26 */
        5.924255487229E-09, -3.289328233925E-09,   /* 50 27 */
       -1.247567758177E-09,  6.835547320865E-09,   /* 50 28 */
        5.238887147976E-09,  1.557273769572E-09,   /* 50 29 */
        4.049744309270E-09,  6.971324654334E-09,   /* 50 30 */
       -2.861300293842E-09,  5.828883899587E-09,   /* 50 31 */
       -2.602120430330E-09,  1.136255412048E-09,   /* 50 32 */
       -3.126485202458E-09, -2.817446378018E-09,   /* 50 33 */
       -1.591522360039E-09, -1.469977239773E-09,   /* 50 34 */
        2.292121027574E-09,  1.603130762551E-10,   /* 50 35 */
       -1.948842992584E-10,  6.553041595127E-10,   /* 50 36 */
       -1.143979019096E-09, -1.025189787206E-09,   /* 50 37 */
       -1.119509199096E-09, -5.589525165835E-09,   /* 50 38 */
       -5.391514931564E-09,  8.519436130510E-09,   /* 50 39 */
        2.190309731142E-09,  5.308243727871E-09,   /* 50 40 */
       -6.328099240226E-09, -5.805749363565E-09,   /* 50 41 */
        5.456868510829E-09, -3.953204412412E-09,   /* 50 42 */
        9.363479324485E-12, -1.587750305096E-09,   /* 50 43 */
        8.986959046813E-10, -8.216488275453E-10,   /* 50 44 */
       -2.804483386878E-09,  5.607455966107E-09,   /* 50 45 */
       -5.742927650298E-09,  2.195506423330E-09,   /* 50 46 */
       -6.092146179368E-09, -1.138198443157E-08,   /* 50 47 */
        8.549856162018E-10,  6.919722017180E-10,   /* 50 48 */
        2.199986447546E-09, -4.799894986926E-09,   /* 50 49 */
        4.529525036309E-09,  2.554484349746E-09    /* 50 50 */
#endif
};

/* See ftp://ftp.csr.utexas.edu/pub/grace/GGM03/GGM03_Notes.pdf for
some light on the following function.  Basically,  the normalization
convention used for GGM03 includes a factor

N(l,m) = sqrt( mfactor * (2l+1)(l-m)! / (l+m)! )

   where mfactor = 1 for m=0,  mfactor=2 for all other m.  Rather than
compute N(l, m) in a loop each time the gravitational potential is
evaluated,  'renormalize_terms' does it once and multiplies all the
GGM03 terms accordingly.  After that,  we forget normalization ever happened.

   A warning,  though:  if you use 64-bit floats,  the above will fail
beyond about l=85.  For l=m=85,  N(l,m) = sqrt( 2 * 171 / 170!),  and
170! just barely fits in a 64-bit IEEE float.

   I've evaded this by switching to long (80-bit) doubles.  1754! will
fit in the range of such doubles,  allowing us to go to l=m=877.  (Or
slightly more or less,  depending on the magnitude of the terms.)  At
present,  the solutions only go up to l=m=360,  and one is advised
that most of the terms are iffy past l=m=180,  _and_ I'm not using
more than the first dozen or so harmonics anyway.

   The traditional way to do this is to renormalize as you're computing
the associated Legendre polynomials (ALPs).  The problem is that you're
doing a fair bit of extra floating point math,  including a square root,
for each ALP.  The following lets you avoid that... admittedly,  at the
cost of possibly hitting issues for l >= 877,  if that ever happens.
(I currently set a stricter assert of l < 800.)  */

static void renormalize_terms( void)
{
   int l, m;
   long double *geo_tptr = ggm03c_terms;

                        /* Find_Orb already handles J2 and "J0": */
#ifndef TEST_MAIN
//   ggm03c_terms[0] = ggm03c_terms[6] = 0.;
#else
// ggm03c_terms[0] =                   0.;
#endif
   for( l = 0; l < N_TERMS - 1; l++)       /* skip l=0 & l=1 */
      {
      long double factor = sqrtl( (long double)( l + l + 1));
      const long double sqrt_2 =
             1.41421356237309504880168872420969807856967187537694807317667973799;

      for( m = 0; m <= l; m++)
         {
         *geo_tptr++ *= ( m ? factor * sqrt_2 : factor);
         *geo_tptr++ *= ( m ? factor * sqrt_2 : factor);

         if( l != m)
            factor /= sqrtl((long double)((l + m + 1) * (l - m)));
         }
      }
}

/* A note on determining the derivative of an associated Legendre polynomial:
I don't know of a "one-size-fits-all" solution to this.  The following
is used for l != m (and would fail for l=m) :

         d   m                   m+1        m
(x^2-1) --- P (x) = sqrt(1-x^2) P  (x) + mxP (x)
        dx   l                    l         l

   Fortunately,  l=m can be handled using

 l          l               (l/2)            (l/2)
P (x) = (-1) (2l-1)!!(1-x^2)      = C (1-x^2)
 l

 d  l           l
-- P (x) = lx P (x) / (1-x^2)
dx  l           l

Since x = cos(phi),

 d  l                   l                2
-- P (x) = -l cos(phi) P (cos(phi)) / sin (phi)
dx  l                   l


 d    l                       d  l                  l
---  P (cos(phi)) = -sin(phi)-- P (x) = l cot(phi) P (cos(phi))
dphi  l                      dx  l                  l

   Fortunately,  this winds up reducing to the l != m case if we define
the usually nonexistent associated Legendre polynomial

 l+1
P  (x) = 0
  l
*/

/* For geo_potential,  xyz are in units of the earth's radius.  The
return value is 1 at the earth's radius.  Both facts are a bit of
a pain,  which is why geo_potential_in_au() gives values in AUs and
days.  See the 'test_main' code for conversions to MKS. */

long double geo_potential( const long double x, const long double y,
                           const long double z, long double *derivs,
                           int n_terms)
{
   long double rpow = x * x + y * y + z * z;
   const long double r = sqrtl( rpow);
   const long double r_cyl = sqrtl( x * x + y * y);
   const long double sin_phi = r_cyl / r, cos_phi = z / r;
   const long double cot_phi = z / r_cyl;
   const long double *geo_tptr = ggm03c_terms;
   long double p[N_TERMS][N_TERMS];
   long double sin_mtheta[N_TERMS], cos_mtheta[N_TERMS];
   long double rval = 0.;
   long double drval_dr = 0., drval_dtheta = 0., drval_dphi = 0.;
   int l, m;
   static bool renormalized = false;

   assert( n_terms < 800);       /* see above comments on limits */
   if( n_terms > N_TERMS - 1)
      n_terms = N_TERMS - 1;
   if( renormalized == false)
      {
      renormalize_terms( );
      renormalized = true;
      }

   sin_mtheta[0] = 0.;
   cos_mtheta[0] = 1.;
   sin_mtheta[1] = y / r_cyl;
   cos_mtheta[1] = x / r_cyl;
   for( m = 1; m < n_terms; m++)
      {
      sin_mtheta[m + 1] = sin_mtheta[m] * cos_mtheta[1] + cos_mtheta[m] * sin_mtheta[1];
      cos_mtheta[m + 1] = cos_mtheta[m] * cos_mtheta[1] - sin_mtheta[m] * sin_mtheta[1];
      }
   p[0][0] = 1.;
   for( m = 0; m < n_terms; m++)
      {
      const long double tval = (long double)( 2 * m + 1) * p[m][m];

      p[m + 1][m + 1] = tval * sin_phi;
      p[m + 1][m]     = tval * cos_phi;
      for( l = m + 1; l < n_terms - 1; l++)
         p[l + 1][m] = ((long double)(2 * l + 1) * cos_phi * p[l][m]
                             - (long double)(l + m) * p[l - 1][m])
                                  / (long double)(l - m + 1);
      }

   rpow = 1. / r;

   for( l = 0; l < n_terms; l++, rpow /= r)
      {
      long double contrib_this_l = 0.;
      long double contrib_drval_dtheta = 0.;
      long double contrib_drval_dphi = 0.;

//    printf( "r = %.5Le; rpow = %.5Le\n", r, rpow);
      if( l == 1)       /* terms are all zero;  skip 'em */
         geo_tptr += 4;
      else for( m = 0; m <= l; m++, geo_tptr += 2)
         {
         const long double dp_dphi =
                p[l][m] * ((long double)m * cot_phi) - (l == m ? 0. : p[l][m + 1]);
         const long double contribution =
                         geo_tptr[0] * cos_mtheta[m] + geo_tptr[1] * sin_mtheta[m];

         assert( !isnan( p[l][m]));
         assert( !isnan( dp_dphi));
         contrib_this_l += p[l][m] * contribution;
         contrib_drval_dphi += dp_dphi * contribution;
         contrib_drval_dtheta += p[l][m] * (long double)m *
                     (-geo_tptr[0] * sin_mtheta[m] + geo_tptr[1] * cos_mtheta[m]);
         }
#ifdef TEMP_REMOVE
                     {
                     long double dth = contrib_drval_dtheta * rpow / r_cyl;
                     long double dph = contrib_drval_dphi * rpow / r;
                     long double dr = (long double)( l + 1) * contrib_this_l * rpow / r;
                     long double diff = sqrtl( dth * dth + dph * dph + dr * dr);

                     printf( "%d: %Le\n", l, diff);
                     }
#endif
      rval += contrib_this_l * rpow;
      drval_dtheta -= contrib_drval_dtheta * rpow;
      drval_dphi += contrib_drval_dphi * rpow;
      drval_dr += (long double)( l + 1) * contrib_this_l * rpow / r;
      }
   *derivs++ = drval_dr;
   *derivs++ = drval_dtheta;
   *derivs++ = drval_dphi;
   return( rval);
}

#define EARTH_MAJOR_AXIS 6378140.
#define AU_IN_KM 1.495978707e+8
#define AU_IN_METERS (AU_IN_KM * 1000.)
#define EARTH_R (EARTH_MAJOR_AXIS / AU_IN_METERS)

const double seconds_per_day = 24. * 60. * 60.;

/* Input xyz are in AU.  The return value is in AU^2/day^2,  with the
derivatives in AU/day^2. */

double geo_potential_in_au( const double x, const double y, const double z,
                 double *derivs, const int n_terms)
{
   long double lderivs[3];
   const double earth_gm_mks = 0.3986004415E+15; /* GGM03 value, in m^3/s^2 */
   const double earth_gm_aud = earth_gm_mks * seconds_per_day * seconds_per_day
               / (AU_IN_METERS * AU_IN_METERS * AU_IN_METERS);
                                       /* in AU^3/day^2 */
   double rval =  -(double)geo_potential( (long double)( x / EARTH_R),
                                          (long double)( y / EARTH_R),
                                          (long double)( z / EARTH_R),
                                               lderivs, n_terms);

   rval *= earth_gm_aud / EARTH_R;
   if( derivs)
      {
      const double r_cyl = sqrt( x * x + y * y);
      const double r = sqrt( x * x + y * y + z * z);
      const double sin_lon = y / r_cyl;
      const double cos_lon = x / r_cyl;
      const double sin_lat = z / r;
      const double cos_lat = r_cyl / r;
      long double dxyz[3];

      lderivs[1] /= r_cyl / EARTH_R;
      lderivs[2] /= r / EARTH_R;
      dxyz[0] = lderivs[0] * cos_lon * cos_lat               /* dpot/dx */
              - lderivs[1] * sin_lon
              - lderivs[2] * cos_lon * sin_lat;
      dxyz[1] = lderivs[0] * sin_lon * cos_lat              /* dpot/dy */
              + lderivs[1] * cos_lon
              - lderivs[2] * sin_lon * sin_lat;
      dxyz[2] = lderivs[0] * sin_lat               /* dpot/dz */
              + lderivs[2] * cos_lat;
                  /* At present,  we're in units where the geopotential
                  and acceleration at the earth's surface are both 1.
                  Convert the acceleration to meters per second^2, or
                  to AU/day^2 (the default) : */
      for( size_t i = 0; i < 3; i++)
         derivs[i] = (double)dxyz[i] * earth_gm_aud / (EARTH_R * EARTH_R);
      }
   return( rval);
}

#ifdef TEST_MAIN

static double jn_potential( const double x, const double y, const double z,
                         const double j2,  const double j3, const double j4)
{
   const double r2 = x * x + y * y + z * z;
   const double r = sqrt( r2);
   const double mu = z / r;
   const double mu2 = mu * mu;
   const double p3 = mu * (2.5 * mu2 - 1.5);
   const double p4 = (35. * mu2 * mu2 - 30. * mu2 + 3.) / 8.;
   const double p2 = 1.5 * mu2 - .5;     /* Danby, p. 115 */

   return( (j2 * p2 + j3 * p3 / r + j4 * p4 / r2) / (r * r2));
// return( (          j3 * p3 / r + j4 * p4 / r2) / (r * r2));
}

#include <stdio.h>

#define EARTH_R2 (EARTH_R * EARTH_R)
#define EARTH_R3 (EARTH_R * EARTH_R2)
#define J2_IN_EARTH_UNITS (1.0826355254e-3)
#define J3_IN_EARTH_UNITS (-2.5325505977e-6)
#define J4_IN_EARTH_UNITS (-1.62870177e-6)
#define EARTH_J2 (J2_IN_EARTH_UNITS * EARTH_R2)
#define EARTH_J3 (J3_IN_EARTH_UNITS * EARTH_R3)
#define EARTH_J4 (J4_IN_EARTH_UNITS * EARTH_R3 * EARTH_R)

#include <stdlib.h>

int main( const int argc, const char **argv)
{
   const double lat = atof( argv[1]) * PI / 180.;
   const double lon = atof( argv[2]) * PI / 180.;
   int n_terms = N_TERMS - 1;
#ifdef GEOID_HEIGHT
   double oval;
   long double loc[3], derivs[3];

   const double earth_gm = 0.3986004415E+15;   /* GGM03 value, in m^3/s^2 */
   const double omega = 7292115e-11;           /* in radians/second */
   const double earth_minor_axis = 6356755.;    /* polar radius */
   const double centrifugal_pot_at_equator =
         EARTH_MAJOR_AXIS * EARTH_MAJOR_AXIS * EARTH_MAJOR_AXIS * omega * omega / earth_gm;

   if( argc > 3)
      n_terms = atoi( argv[3]);
   loc[0] = (long double)( cos( lon) * cos( lat));
   loc[1] = (long double)( sin( lon) * cos( lat));
   loc[2] = (long double)( sin( lat) * earth_minor_axis / EARTH_MAJOR_AXIS);
   ggm03c_terms[0] = 1.;      /* include "J0" term    */
   oval = 1. - (double)geo_potential( loc[0], loc[1], loc[2], derivs, n_terms);
   oval -= centrifugal_pot_at_equator * cos( lat) * cos( lat) / 2.;
   printf( "%e  %f\n", oval,
                 -14497.68 - oval * EARTH_MAJOR_AXIS);
#else
                     /* cvt radius from units of earth radii to AU: */
   const double r = atof( argv[3]) * EARTH_MAJOR_AXIS / AU_IN_METERS;
   const double delta = r * .0001;
   const double x = r * cos( lon) * cos( lat);
   const double y = r * sin( lon) * cos( lat);
   const double z = r *             sin( lat);
   double derivs[3], dpot;

   if( argc > 4)
      n_terms = atoi( argv[4]);
   printf( "  %e\n", jn_potential( x * AU_IN_METERS / EARTH_MAJOR_AXIS,
                                   y * AU_IN_METERS / EARTH_MAJOR_AXIS,
                                   z * AU_IN_METERS / EARTH_MAJOR_AXIS,
                                   EARTH_J2, EARTH_J3, EARTH_J4));
   printf( "  %e\n",
              geo_potential_in_au( x, y, z, derivs, n_terms));
   printf( "  Derivs: %.10e %.10e %.10e (analytical)\n", derivs[0], derivs[1], derivs[2]);
   for( size_t i = 0; i < 3; i++)
      derivs[i] *= AU_IN_METERS / (seconds_per_day * seconds_per_day);
   printf( "  Derivs: %.10e %.10e %.10e (analytical, m/s^2)\n", derivs[0], derivs[1], derivs[2]);

   dpot = geo_potential_in_au( x + delta, y, z, NULL, n_terms)
        - geo_potential_in_au( x - delta, y, z, NULL, n_terms);
   derivs[0] = .5 * dpot / delta;
   dpot = geo_potential_in_au( x, y + delta, z, NULL, n_terms)
        - geo_potential_in_au( x, y - delta, z, NULL, n_terms);
   derivs[1] = .5 * dpot / delta;
   dpot = geo_potential_in_au( x, y, z + delta, NULL, n_terms)
        - geo_potential_in_au( x, y, z - delta, NULL, n_terms);
   derivs[2] = .5 * dpot / delta;
   printf( "  Derivs: %.10e %.10e %.10e (numerical, AU/day^2)\n", derivs[0], derivs[1], derivs[2]);
#endif
   return( 0);
}
#endif          // #ifdef TEST_MAIN

/*
   Comparisons made to

http://geographiclib.sourceforge.net/cgi-bin/GeoidEval?input=44+-69.9&option=Submit

0 0:       17.226  16.927145
45 0:      46.767  47.289086
90 0:      14.898  14.898461
0 120:     59.82   58.211502
0 100:     -6.92   -6.904056
0 80:    -102.59 -102.701770
0 60:     -62.59  -62.740079
10 125:    63.91   64.616471
44 -69.9: -26.70  -26.649304
-10 -125: -10.25  -10.678747
lat lon
         online   geo_pot.c

   Note that rearrangement of the order of computation has changed the results
by a millimeter or so...

phred@phred:~/find_orb$ ./geo_pot 0 0 1 19
  -2.085725e-05
  Derivs: 4.8973461530e-01 2.3583555353e-06 -5.7623158275e-06 (analytical)
  Derivs: 9.8142864339e+00 4.7261467768e-05 -1.1547686499e-04 (analytical, m/s^2)
  Derivs: 4.8973462022e-01 2.3583549381e-06 -5.7623145439e-06 (numerical, AU/day^2)
phred@phred:~/find_orb$ ./geo_pot 31.4 159 1 19
  -2.084797e-05
  Derivs: -3.8937807981e-01 1.4946019510e-01 2.5541973048e-01 (analytical)
  Derivs: -7.8031404906e+00 2.9951837573e+00 5.1186138726e+00 (analytical, m/s^2)
  Derivs: -3.8937808013e-01 1.4946019321e-01 2.5541972839e-01 (numerical, AU/day^2)
phred@phred:~/find_orb$ ./geo_pot 31.4 159 .8 19
  -2.606101e-05
  Derivs: -6.0807926146e-01 2.3343379352e-01 3.9961972747e-01 (analytical)
  Derivs: -1.2185914289e+01 4.6780154831e+00 8.0083832089e+00 (analytical, m/s^2)
  Derivs: -6.0807926193e-01 2.3343379057e-01 3.9961972424e-01 (numerical, AU/day^2) */
