/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.statediagram.StateDiagram;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

public class CommandAddField
extends SingleLineCommand2<StateDiagram> {
    public CommandAddField() {
        super(CommandAddField.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandAddField.class.getName(), RegexLeaf.start(), new RegexOr(new RegexLeaf("CODE3", "([%pLN_.]+)"), new RegexLeaf("CODE4", "[%g]([^%g]+)[%g]")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("FIELD", "(.*)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(StateDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        String codeString = arg.getLazzy("CODE", 0);
        String field = arg.get("FIELD", 0);
        Ident ident = diagram.buildLeafIdent(codeString);
        if (diagram.V1972() && ident.parent().getLast().equals(codeString)) {
            ident = ident.parent();
        }
        Ident code = diagram.V1972() ? ident : diagram.buildCode(codeString);
        IEntity entity = diagram.getOrCreateLeaf(ident, code, null, null);
        entity.getBodier().addFieldOrMethod(field);
        return CommandExecutionResult.ok();
    }
}

