/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class ClusterDecoration {
    private final UStroke defaultStroke;
    private final USymbol symbol;
    private final TextBlock title;
    private final TextBlock stereo;
    private final double minX;
    private final double minY;
    private final double maxX;
    private final double maxY;

    public ClusterDecoration(PackageStyle style, USymbol symbol, TextBlock title, TextBlock stereo, double minX, double minY, double maxX, double maxY, UStroke stroke) {
        this.symbol = ClusterDecoration.guess(symbol, style);
        this.stereo = stereo;
        this.title = title;
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.defaultStroke = stroke;
    }

    private static USymbol guess(USymbol symbol, PackageStyle style) {
        if (symbol != null) {
            return symbol;
        }
        return style.toUSymbol();
    }

    public void drawU(UGraphic ug, HColor backColor, HColor borderColor, double shadowing, double roundCorner, HorizontalAlignment titleAlignment, HorizontalAlignment stereoAlignment) {
        SymbolContext biColor = new SymbolContext(backColor, borderColor);
        if (this.symbol == null) {
            throw new UnsupportedOperationException();
        }
        SymbolContext symbolContext = biColor.withShadow(shadowing).withStroke(this.defaultStroke).withCorner(roundCorner, 0.0);
        this.symbol.asBig(this.title, titleAlignment, this.stereo, this.maxX - this.minX, this.maxY - this.minY, symbolContext, stereoAlignment).drawU(ug.apply(new UTranslate(this.minX, this.minY)));
    }
}

