---
layout: default
built_from_commit: 70303b65ae864066c583e1436011ff135847f6ad
title: 'Man Page: puppet facts'
canonical: "/puppet/latest/man/facts.html"
---

# Man Page: puppet facts

> **NOTE:** This page was generated from the Puppet source code on 2024-08-29 17:41:46 -0700

## NAME
**puppet-facts** - Retrieve and store facts.

## SYNOPSIS
puppet facts *action* \[\--terminus \_TERMINUS\]

## DESCRIPTION
This subcommand manages facts, which are collections of normalized
system information used by Puppet. It can read facts directly from the
local system (with the default **facter** terminus).

## OPTIONS
Note that any setting that\'s valid in the configuration file is also a
valid long argument, although it may or may not be relevant to the
present action. For example, **server** and **run_mode** are valid
settings, so you can specify **\--server \<servername\>**, or
**\--run_mode \<runmode\>** as an argument.

See the configuration file documentation at
*https://puppet.com/docs/puppet/latest/configuration.html* for the full
list of acceptable parameters. A commented list of all configuration
options can also be generated by running puppet with **\--genconfig**.

\--render-as FORMAT

:   The format in which to render output. The most common formats are
    **json**, **s** (string), **yaml**, and **console**, but other
    options such as **dot** are sometimes available.

\--verbose

:   Whether to log verbosely.

\--debug

:   Whether to log debug information.

\--terminus \_TERMINUS

:   Indirector faces expose indirected subsystems of Puppet. These
    subsystems are each able to retrieve and alter a specific type of
    data (with the familiar actions of **find**, **search**, **save**,
    and **destroy**) from an arbitrary number of pluggable backends. In
    Puppet parlance, these backends are called terminuses.

    Almost all indirected subsystems have a **rest** terminus that
    interacts with the puppet master\'s data. Most of them have
    additional terminuses for various local data models, which are in
    turn used by the indirected subsystem on the puppet master whenever
    it receives a remote request.

    The terminus for an action is often determined by context, but
    occasionally needs to be set explicitly. See the \"Notes\" section
    of this face\'s manpage for more details.

## ACTIONS
**find** - Retrieve a node\'s facts.

:   **SYNOPSIS**

    puppet facts find \[\--terminus \_TERMINUS\] \[*node_certname*\]

    **DESCRIPTION**

    Retrieve a node\'s facts.

    **RETURNS**

    A hash containing some metadata and (under the \"values\" key) the
    set of facts for the requested node. When used from the Ruby API: A
    Puppet::Node::Facts object.

    RENDERING ISSUES: Facts cannot currently be rendered as a string;
    use yaml or json.

    **NOTES**

    When using the **facter** terminus, the host argument is ignored.

**info** - Print the default terminus class for this face.

:   **SYNOPSIS**

    puppet facts info \[\--terminus \_TERMINUS\]

    **DESCRIPTION**

    Prints the default terminus class for this subcommand. Note that
    different run modes may have different default termini; when in
    doubt, specify the run mode with the \'\--run_mode\' option.

**save** - API only: create or overwrite an object.

:   **SYNOPSIS**

    puppet facts save \[\--terminus \_TERMINUS\] *key*

    **DESCRIPTION**

    API only: create or overwrite an object. As the Faces framework does
    not currently accept data from STDIN, save actions cannot currently
    be invoked from the command line.

**show** - Retrieve current node\'s facts.

:   **SYNOPSIS**

    puppet facts \[\--terminus \_TERMINUS\] \[\--config-file *path*\]
    \[\--custom-dir *path*\] \[\--external-dir *path*\] \[\--no-block\]
    \[\--no-cache\] \[\--show-legacy\] \[\--value-only\] \[\--timing\]
    \[*facts*\]

    **DESCRIPTION**

    Reads facts from the local system using **facter** terminus. A query
    can be provided to retrieve just a specific fact or a set of facts.

    **OPTIONS** *\--config-file \<path*\> - The location of the config
    file for Facter.

    *\--custom-dir \<path*\> - The path to a directory that contains
    custom facts.

    *\--external-dir \<path*\> - The path to a directory that contains
    external facts.

    *\--no-block* - Disable fact blocking mechanism.

    *\--no-cache* - Disable fact caching mechanism.

    *\--show-legacy* - Show legacy facts when querying all facts.

    *\--timing* - Show how much time it took to resolve each fact.

    *\--value-only* - Show only the value when the action is called with
    a single query

    **RETURNS**

    The output of facter with added puppet specific facts.

    **NOTES**

**upload** - Upload local facts to the puppet master.

:   **SYNOPSIS**

    puppet facts upload \[\--terminus \_TERMINUS\]

    **DESCRIPTION**

    Reads facts from the local system using the **facter** terminus,
    then saves the returned facts using the rest terminus.

    **RETURNS**

    Nothing.

    **NOTES**

    This action requires that the Puppet Server\'s **auth.conf** file
    allow **PUT** or **save** access to the **/puppet/v3/facts** API
    endpoint.

    For details on configuring Puppet Server\'s **auth.conf**, see:

    *https://puppet.com/docs/puppetserver/latest/config_file_auth.html*

## EXAMPLES
**find**

Get facts from the local system:

\$ puppet facts find

**show**

retrieve facts:

\$ puppet facts show os

**upload**

Upload facts:

\$ puppet facts upload

## NOTES
This subcommand is an indirector face, which exposes **find**,
**search**, **save**, and **destroy** actions for an indirected
subsystem of Puppet. Valid termini for this face include:

-   **facter**

-   **json**

-   **memory**

-   **network_device**

-   **rest**

-   **store_configs**

-   **yaml**

## COPYRIGHT AND LICENSE
Copyright 2011 by Puppet Inc. Apache 2 license; see COPYING
