/**********************************************************************
 * $propagatep_test example -- C source code using TF/ACC PLI routines
 *
 * C source to illustrate reading 4-state logic values into C integers.
 * The signals in Verilog to be read can be a vector of any bit size
 * (including scalar).
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *
 * Usage:
 * ------
 *
 *   Syntax:   $propagatep_test(<signal>);
 *
 *   Example:
 *    reg [0:39] data;
 *    initial $propagatep_test(data);
 *
 * Routine definitions for a veriusertfs array:
 *  /* routine prototypes -/
 *   extern int PLIbook_propagatepTest_checktf(),
 *              PLIbook_propagatepTest_calltf(),
 *              PLIbook_propagatepTest_misctf();
 *  /* table entries -/
 *   {usertask,                         /* type of PLI routine -/
 *     0,                               /* user_data value -/
 *     PLIbook_propagatepTest_checktf,  /* checktf routine -/
 *     0,                               /* sizetf routine -/
 *     PLIbook_propagatepTest_calltf,   /* calltf routine -/
 *     PLIbook_propagatepTest_misctf,   /* misctf routine -/
 *     "$propagatep_test",              /* system task/function name -/
 *     1                                /* forward reference = true -/
 *   },
 *********************************************************************/

#include "veriuser.h"         /* IEEE 1364 PLI TF  routine library */
/**********************************************************************
 * checktf routine
 *********************************************************************/
int PLIbook_propagatepTest_checktf()
{
  if (tf_nump() != 1)
    tf_error("Usage error: $propagatep_test(<signal>);");
  return(0);
}

/**********************************************************************
 * misctf routine
 *
 * The misctf routine is used to call tf_exprinfo() at the 
 * beginning of simulation, so that the memory allocated by 
 * tf_exprinfo() is only allocated one time for each instance of
 * $read_4state_value.
 *********************************************************************/
int PLIbook_propagatepTest_misctf(int user_data, int reason)
{
  p_tfexprinfo info_p;     /* pointer to structure for tf_exprinfo() */

  if (reason != REASON_ENDOFCOMPILE)
    return(0);  /* exit now if this is not the start of simulation */
  
  /* allocate memory for an s_tfexprinfo structure */
  info_p = (p_tfexprinfo)malloc(sizeof(s_tfexprinfo));

  tf_exprinfo(1, info_p);  /* read expression info for arg 1 */
  if (   (info_p->expr_type != TF_READWRITE)
      && (info_p->expr_type != TF_READWRITEREAL) 
      && (info_p->expr_type != TF_RWBITSELECT) 
      && (info_p->expr_type != TF_RWPARTSELECT) 
      && (info_p->expr_type != TF_RWMEMSELECT) ) {
    io_printf("ERROR: Signal type not supported by $propagatep_test\n");
    tf_dofinish();
  }
  else
    tf_setworkarea((char *)info_p); /* save info pointer in workarea */

  return(0);
}

/**********************************************************************
 * calltf routine
 *********************************************************************/
/* prototype for subroutine used by calltf routine */
void PLIbook_Print4stateValue();

int PLIbook_propagatepTest_calltf()
{
  p_tfexprinfo info_p;     /* pointer to structure for tf_exprinfo() */

  info_p = (p_tfexprinfo)tf_getworkarea(); /* retrieve info pointer */

  io_printf("$propagatep_test called at time %d to read & modify arg value\n",
            tf_gettime());
  /* read current value of argument 1 */
  io_printf(" current value:\n");
  tf_evaluatep(1);
  PLIbook_Print4stateValue(info_p);

  /* modify value of argument 1 */
  switch (info_p->expr_type) {
    case TF_READWRITE:
    case TF_RWBITSELECT:
    case TF_RWPARTSELECT:
    case TF_RWMEMSELECT:
      info_p->expr_value_p[0].avalbits++;
      info_p->expr_value_p[0].bvalbits = 0;
      break;
    case TF_READWRITEREAL:
      info_p->real_value++;
      break;
  }
  tf_propagatep(1);

  /* read new value of argument 1 */
  io_printf(" new value:\n");
  tf_evaluatep(1);
  PLIbook_Print4stateValue(info_p);

  return(0);
}

void PLIbook_Print4stateValue(p_tfexprinfo info_p)
{
  int i;

  switch (info_p->expr_type) {
    case TF_READWRITEREAL:
      io_printf("  real value = %0.1f\n", info_p->real_value); break;
    case TF_READWRITE:
    case TF_RWBITSELECT:
    case TF_RWPARTSELECT:
    case TF_RWMEMSELECT:
      io_printf("  vector value (in hex):\n");
      for (i=0; i<info_p->expr_ngroups; i++) {
        io_printf("   avalbits[%d] = %x\n",
                  i, info_p->expr_value_p[i].avalbits);
        io_printf("   bvalbits[%d] = %x\n",
                  i, info_p->expr_value_p[i].bvalbits);
      }
      break;
  }
  return;
}

/*********************************************************************/
