from ctypes import c_char_p, c_int
from .dll import _bind

__all__ = ["SDL_SetError", "SDL_GetError", "SDL_ClearError", "SDL_ENOMEM",
           "SDL_EFREAD", "SDL_EFWRITE", "SDL_EFSEEK", "SDL_UNSUPPORTED",
           "SDL_LASTERROR", "SDL_errorcode", "SDL_Error", "SDL_OutOfMemory",
           "SDL_Unsupported", "SDL_InvalidParamError"
           ]

SDL_SetError = _bind("SDL_SetError", [c_char_p], c_int)
SDL_GetError = _bind("SDL_GetError", None, c_char_p)
SDL_ClearError = _bind("SDL_ClearError")

SDL_ENOMEM = 0
SDL_EFREAD = 1
SDL_EFWRITE = 2
SDL_EFSEEK = 3
SDL_UNSUPPORTED = 4
SDL_LASTERROR = 5
SDL_errorcode = c_int
SDL_Error = _bind("SDL_Error", [SDL_errorcode], c_int)
SDL_OutOfMemory = SDL_Error(SDL_ENOMEM)
SDL_Unsupported = SDL_Error(SDL_UNSUPPORTED)
SDL_InvalidParamError = lambda x: SDL_SetError("Parameter '%s' is invalid" % (x))
