# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.servicefabricmanagedclusters.aio import ServiceFabricManagedClustersManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestServiceFabricManagedClustersManagementManagedClustersOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ServiceFabricManagedClustersManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_clusters_list_by_resource_group(self, resource_group):
        response = self.client.managed_clusters.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-09-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_clusters_list_by_subscription(self, resource_group):
        response = self.client.managed_clusters.list_by_subscription(
            api_version="2024-09-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_clusters_get(self, resource_group):
        response = await self.client.managed_clusters.get(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_clusters_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.managed_clusters.begin_create_or_update(
                resource_group_name=resource_group.name,
                cluster_name="str",
                parameters={
                    "location": "str",
                    "sku": {"name": "str"},
                    "addonFeatures": ["str"],
                    "adminPassword": "str",
                    "adminUserName": "str",
                    "allocatedOutboundPorts": 0,
                    "allowRdpAccess": bool,
                    "applicationTypeVersionsCleanupPolicy": {"maxUnusedVersionsToKeep": 0},
                    "autoGeneratedDomainNameLabelScope": "str",
                    "auxiliarySubnets": [
                        {
                            "name": "str",
                            "enableIpv6": bool,
                            "networkSecurityGroupId": "str",
                            "privateEndpointNetworkPolicies": "str",
                            "privateLinkServiceNetworkPolicies": "str",
                        }
                    ],
                    "azureActiveDirectory": {
                        "clientApplication": "str",
                        "clusterApplication": "str",
                        "tenantId": "str",
                    },
                    "clientConnectionPort": 19000,
                    "clients": [{"isAdmin": bool, "commonName": "str", "issuerThumbprint": "str", "thumbprint": "str"}],
                    "clusterCertificateThumbprints": ["str"],
                    "clusterCodeVersion": "str",
                    "clusterId": "str",
                    "clusterState": "str",
                    "clusterUpgradeCadence": "str",
                    "clusterUpgradeMode": "Automatic",
                    "ddosProtectionPlanId": "str",
                    "dnsName": "str",
                    "enableAutoOSUpgrade": bool,
                    "enableHttpGatewayExclusiveAuthMode": bool,
                    "enableIpv6": bool,
                    "enableServicePublicIP": bool,
                    "etag": "str",
                    "fabricSettings": [{"name": "str", "parameters": [{"name": "str", "value": "str"}]}],
                    "fqdn": "str",
                    "httpGatewayConnectionPort": 19080,
                    "httpGatewayTokenAuthConnectionPort": 0,
                    "id": "str",
                    "ipTags": [{"ipTagType": "str", "tag": "str"}],
                    "ipv4Address": "str",
                    "ipv6Address": "str",
                    "loadBalancingRules": [
                        {
                            "backendPort": 0,
                            "frontendPort": 0,
                            "probeProtocol": "str",
                            "protocol": "str",
                            "loadDistribution": "str",
                            "probePort": 0,
                            "probeRequestPath": "str",
                        }
                    ],
                    "name": "str",
                    "networkSecurityRules": [
                        {
                            "access": "str",
                            "direction": "str",
                            "name": "str",
                            "priority": 0,
                            "protocol": "str",
                            "description": "str",
                            "destinationAddressPrefix": "str",
                            "destinationAddressPrefixes": ["str"],
                            "destinationPortRange": "str",
                            "destinationPortRanges": ["str"],
                            "sourceAddressPrefix": "str",
                            "sourceAddressPrefixes": ["str"],
                            "sourcePortRange": "str",
                            "sourcePortRanges": ["str"],
                        }
                    ],
                    "provisioningState": "str",
                    "publicIPPrefixId": "str",
                    "publicIPv6PrefixId": "str",
                    "serviceEndpoints": [{"service": "str", "locations": ["str"]}],
                    "subnetId": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                    "upgradeDescription": {
                        "deltaHealthPolicy": {
                            "maxPercentDeltaUnhealthyNodes": 0,
                            "maxPercentDeltaUnhealthyApplications": 0,
                            "maxPercentUpgradeDomainDeltaUnhealthyNodes": 0,
                        },
                        "forceRestart": bool,
                        "healthPolicy": {"maxPercentUnhealthyApplications": 0, "maxPercentUnhealthyNodes": 0},
                        "monitoringPolicy": {
                            "healthCheckRetryTimeout": "str",
                            "healthCheckStableDuration": "str",
                            "healthCheckWaitDuration": "str",
                            "upgradeDomainTimeout": "str",
                            "upgradeTimeout": "str",
                        },
                        "upgradeReplicaSetCheckTimeout": "str",
                    },
                    "useCustomVnet": bool,
                    "zonalResiliency": False,
                    "zonalUpdateMode": "str",
                },
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_clusters_update(self, resource_group):
        response = await self.client.managed_clusters.update(
            resource_group_name=resource_group.name,
            cluster_name="str",
            parameters={"tags": {"str": "str"}},
            api_version="2024-09-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_clusters_begin_delete(self, resource_group):
        response = await (
            await self.client.managed_clusters.begin_delete(
                resource_group_name=resource_group.name,
                cluster_name="str",
                api_version="2024-09-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
