
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BinMDF_ADriverTable.hxx>
#include <Message_Messenger.hxx>
#include <TDocStd_Application.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <BinTObjDrivers.hxx>
#include <BinTObjDrivers_DocumentRetrievalDriver.hxx>
#include <BinTObjDrivers_DocumentStorageDriver.hxx>
#include <BinTObjDrivers_IntSparseArrayDriver.hxx>
#include <BinTObjDrivers_ModelDriver.hxx>
#include <BinTObjDrivers_ObjectDriver.hxx>
#include <BinTObjDrivers_ReferenceDriver.hxx>
#include <BinTObjDrivers_XYZDriver.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_BinTObjDrivers(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("BinTObjDrivers"));
py::object klass;

//Python trampoline classes

// classes

    // Class BinTObjDrivers from ./opencascade/BinTObjDrivers.hxx
    klass = m.attr("BinTObjDrivers");

    // default constructor
    register_default_constructor<BinTObjDrivers , shared_ptr<BinTObjDrivers>>(m,"BinTObjDrivers");

    // nested enums

    static_cast<py::class_<BinTObjDrivers , shared_ptr<BinTObjDrivers>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Factory_s",
                    ( const handle<Standard_Transient> & (*)(  const Standard_GUID &  ) ) static_cast< const handle<Standard_Transient> & (*)(  const Standard_GUID &  ) >(&BinTObjDrivers::Factory),
                    R"#()#"  , py::arg("aGUID")
          )
        .def_static("DefineFormat_s",
                    (void (*)(  const handle<TDocStd_Application> &  ) ) static_cast<void (*)(  const handle<TDocStd_Application> &  ) >(&BinTObjDrivers::DefineFormat),
                    R"#(Defines format "TObjBin" and registers its read and write drivers in the specified application)#"  , py::arg("theApp")
          )
        .def_static("AddDrivers_s",
                    (void (*)(  const handle<BinMDF_ADriverTable> & ,   const handle<Message_Messenger> &  ) ) static_cast<void (*)(  const handle<BinMDF_ADriverTable> & ,   const handle<Message_Messenger> &  ) >(&BinTObjDrivers::AddDrivers),
                    R"#()#"  , py::arg("aDriverTable"),  py::arg("aMsgDrv")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class BinTObjDrivers_DocumentRetrievalDriver from ./opencascade/BinTObjDrivers_DocumentRetrievalDriver.hxx
    klass = m.attr("BinTObjDrivers_DocumentRetrievalDriver");


    // nested enums

    static_cast<py::class_<BinTObjDrivers_DocumentRetrievalDriver ,opencascade::handle<BinTObjDrivers_DocumentRetrievalDriver>  , BinLDrivers_DocumentRetrievalDriver >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("AttributeDrivers",
             (handle<BinMDF_ADriverTable> (BinTObjDrivers_DocumentRetrievalDriver::*)(  const handle<Message_Messenger> &  ) ) static_cast<handle<BinMDF_ADriverTable> (BinTObjDrivers_DocumentRetrievalDriver::*)(  const handle<Message_Messenger> &  ) >(&BinTObjDrivers_DocumentRetrievalDriver::AttributeDrivers),
             R"#()#"  , py::arg("theMsgDriver")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BinTObjDrivers_DocumentRetrievalDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BinTObjDrivers_DocumentRetrievalDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (BinTObjDrivers_DocumentRetrievalDriver::*)() const) static_cast< const handle<Standard_Type> & (BinTObjDrivers_DocumentRetrievalDriver::*)() const>(&BinTObjDrivers_DocumentRetrievalDriver::DynamicType),
             R"#()#"
             
         )
;

    // Class BinTObjDrivers_DocumentStorageDriver from ./opencascade/BinTObjDrivers_DocumentStorageDriver.hxx
    klass = m.attr("BinTObjDrivers_DocumentStorageDriver");


    // nested enums

    static_cast<py::class_<BinTObjDrivers_DocumentStorageDriver ,opencascade::handle<BinTObjDrivers_DocumentStorageDriver>  , BinLDrivers_DocumentStorageDriver >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("AttributeDrivers",
             (handle<BinMDF_ADriverTable> (BinTObjDrivers_DocumentStorageDriver::*)(  const handle<Message_Messenger> &  ) ) static_cast<handle<BinMDF_ADriverTable> (BinTObjDrivers_DocumentStorageDriver::*)(  const handle<Message_Messenger> &  ) >(&BinTObjDrivers_DocumentStorageDriver::AttributeDrivers),
             R"#()#"  , py::arg("theMsgDriver")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BinTObjDrivers_DocumentStorageDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BinTObjDrivers_DocumentStorageDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (BinTObjDrivers_DocumentStorageDriver::*)() const) static_cast< const handle<Standard_Type> & (BinTObjDrivers_DocumentStorageDriver::*)() const>(&BinTObjDrivers_DocumentStorageDriver::DynamicType),
             R"#()#"
             
         )
;

    // Class BinTObjDrivers_IntSparseArrayDriver from ./opencascade/BinTObjDrivers_IntSparseArrayDriver.hxx
    klass = m.attr("BinTObjDrivers_IntSparseArrayDriver");


    // nested enums

    static_cast<py::class_<BinTObjDrivers_IntSparseArrayDriver ,opencascade::handle<BinTObjDrivers_IntSparseArrayDriver>  , BinMDF_ADriver >>(klass)
    // constructors
        .def(py::init<  const handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (handle<TDF_Attribute> (BinTObjDrivers_IntSparseArrayDriver::*)() const) static_cast<handle<TDF_Attribute> (BinTObjDrivers_IntSparseArrayDriver::*)() const>(&BinTObjDrivers_IntSparseArrayDriver::NewEmpty),
             R"#()#" 
          )
        .def("Paste",
             (Standard_Boolean (BinTObjDrivers_IntSparseArrayDriver::*)(  const BinObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (BinTObjDrivers_IntSparseArrayDriver::*)(  const BinObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const>(&BinTObjDrivers_IntSparseArrayDriver::Paste),
             R"#()#"  , py::arg("theSource"),  py::arg("theTarget"),  py::arg("theRelocTable")
          )
        .def("Paste",
             (void (BinTObjDrivers_IntSparseArrayDriver::*)(  const handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  BinObjMgt_SRelocationTable &  ) const) static_cast<void (BinTObjDrivers_IntSparseArrayDriver::*)(  const handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  BinObjMgt_SRelocationTable &  ) const>(&BinTObjDrivers_IntSparseArrayDriver::Paste),
             R"#()#"  , py::arg("theSource"),  py::arg("theTarget"),  py::arg("theRelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BinTObjDrivers_IntSparseArrayDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BinTObjDrivers_IntSparseArrayDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (BinTObjDrivers_IntSparseArrayDriver::*)() const) static_cast< const handle<Standard_Type> & (BinTObjDrivers_IntSparseArrayDriver::*)() const>(&BinTObjDrivers_IntSparseArrayDriver::DynamicType),
             R"#()#"
             
         )
;

    // Class BinTObjDrivers_ModelDriver from ./opencascade/BinTObjDrivers_ModelDriver.hxx
    klass = m.attr("BinTObjDrivers_ModelDriver");


    // nested enums

    static_cast<py::class_<BinTObjDrivers_ModelDriver ,opencascade::handle<BinTObjDrivers_ModelDriver>  , BinMDF_ADriver >>(klass)
    // constructors
        .def(py::init<  const handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (handle<TDF_Attribute> (BinTObjDrivers_ModelDriver::*)() const) static_cast<handle<TDF_Attribute> (BinTObjDrivers_ModelDriver::*)() const>(&BinTObjDrivers_ModelDriver::NewEmpty),
             R"#()#" 
          )
        .def("Paste",
             (Standard_Boolean (BinTObjDrivers_ModelDriver::*)(  const BinObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (BinTObjDrivers_ModelDriver::*)(  const BinObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const>(&BinTObjDrivers_ModelDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("Paste",
             (void (BinTObjDrivers_ModelDriver::*)(  const handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  BinObjMgt_SRelocationTable &  ) const) static_cast<void (BinTObjDrivers_ModelDriver::*)(  const handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  BinObjMgt_SRelocationTable &  ) const>(&BinTObjDrivers_ModelDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BinTObjDrivers_ModelDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BinTObjDrivers_ModelDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (BinTObjDrivers_ModelDriver::*)() const) static_cast< const handle<Standard_Type> & (BinTObjDrivers_ModelDriver::*)() const>(&BinTObjDrivers_ModelDriver::DynamicType),
             R"#()#"
             
         )
;

    // Class BinTObjDrivers_ObjectDriver from ./opencascade/BinTObjDrivers_ObjectDriver.hxx
    klass = m.attr("BinTObjDrivers_ObjectDriver");


    // nested enums

    static_cast<py::class_<BinTObjDrivers_ObjectDriver ,opencascade::handle<BinTObjDrivers_ObjectDriver>  , BinMDF_ADriver >>(klass)
    // constructors
        .def(py::init<  const handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (handle<TDF_Attribute> (BinTObjDrivers_ObjectDriver::*)() const) static_cast<handle<TDF_Attribute> (BinTObjDrivers_ObjectDriver::*)() const>(&BinTObjDrivers_ObjectDriver::NewEmpty),
             R"#()#" 
          )
        .def("Paste",
             (Standard_Boolean (BinTObjDrivers_ObjectDriver::*)(  const BinObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (BinTObjDrivers_ObjectDriver::*)(  const BinObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const>(&BinTObjDrivers_ObjectDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("Paste",
             (void (BinTObjDrivers_ObjectDriver::*)(  const handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  BinObjMgt_SRelocationTable &  ) const) static_cast<void (BinTObjDrivers_ObjectDriver::*)(  const handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  BinObjMgt_SRelocationTable &  ) const>(&BinTObjDrivers_ObjectDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BinTObjDrivers_ObjectDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BinTObjDrivers_ObjectDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (BinTObjDrivers_ObjectDriver::*)() const) static_cast< const handle<Standard_Type> & (BinTObjDrivers_ObjectDriver::*)() const>(&BinTObjDrivers_ObjectDriver::DynamicType),
             R"#()#"
             
         )
;

    // Class BinTObjDrivers_ReferenceDriver from ./opencascade/BinTObjDrivers_ReferenceDriver.hxx
    klass = m.attr("BinTObjDrivers_ReferenceDriver");


    // nested enums

    static_cast<py::class_<BinTObjDrivers_ReferenceDriver ,opencascade::handle<BinTObjDrivers_ReferenceDriver>  , BinMDF_ADriver >>(klass)
    // constructors
        .def(py::init<  const handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (handle<TDF_Attribute> (BinTObjDrivers_ReferenceDriver::*)() const) static_cast<handle<TDF_Attribute> (BinTObjDrivers_ReferenceDriver::*)() const>(&BinTObjDrivers_ReferenceDriver::NewEmpty),
             R"#()#" 
          )
        .def("Paste",
             (Standard_Boolean (BinTObjDrivers_ReferenceDriver::*)(  const BinObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (BinTObjDrivers_ReferenceDriver::*)(  const BinObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const>(&BinTObjDrivers_ReferenceDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
        .def("Paste",
             (void (BinTObjDrivers_ReferenceDriver::*)(  const handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  BinObjMgt_SRelocationTable &  ) const) static_cast<void (BinTObjDrivers_ReferenceDriver::*)(  const handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  BinObjMgt_SRelocationTable &  ) const>(&BinTObjDrivers_ReferenceDriver::Paste),
             R"#()#"  , py::arg("Source"),  py::arg("Target"),  py::arg("RelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BinTObjDrivers_ReferenceDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BinTObjDrivers_ReferenceDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (BinTObjDrivers_ReferenceDriver::*)() const) static_cast< const handle<Standard_Type> & (BinTObjDrivers_ReferenceDriver::*)() const>(&BinTObjDrivers_ReferenceDriver::DynamicType),
             R"#()#"
             
         )
;

    // Class BinTObjDrivers_XYZDriver from ./opencascade/BinTObjDrivers_XYZDriver.hxx
    klass = m.attr("BinTObjDrivers_XYZDriver");


    // nested enums

    static_cast<py::class_<BinTObjDrivers_XYZDriver ,opencascade::handle<BinTObjDrivers_XYZDriver>  , BinMDF_ADriver >>(klass)
    // constructors
        .def(py::init<  const handle<Message_Messenger> & >()  , py::arg("theMessageDriver") )
    // custom constructors
    // methods
        .def("NewEmpty",
             (handle<TDF_Attribute> (BinTObjDrivers_XYZDriver::*)() const) static_cast<handle<TDF_Attribute> (BinTObjDrivers_XYZDriver::*)() const>(&BinTObjDrivers_XYZDriver::NewEmpty),
             R"#()#" 
          )
        .def("Paste",
             (Standard_Boolean (BinTObjDrivers_XYZDriver::*)(  const BinObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const) static_cast<Standard_Boolean (BinTObjDrivers_XYZDriver::*)(  const BinObjMgt_Persistent & ,   const handle<TDF_Attribute> & ,  BinObjMgt_RRelocationTable &  ) const>(&BinTObjDrivers_XYZDriver::Paste),
             R"#()#"  , py::arg("theSource"),  py::arg("theTarget"),  py::arg("theRelocTable")
          )
        .def("Paste",
             (void (BinTObjDrivers_XYZDriver::*)(  const handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  BinObjMgt_SRelocationTable &  ) const) static_cast<void (BinTObjDrivers_XYZDriver::*)(  const handle<TDF_Attribute> & ,  BinObjMgt_Persistent & ,  BinObjMgt_SRelocationTable &  ) const>(&BinTObjDrivers_XYZDriver::Paste),
             R"#()#"  , py::arg("theSource"),  py::arg("theTarget"),  py::arg("theRelocTable")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    ( const char * (*)() ) static_cast< const char * (*)() >(&BinTObjDrivers_XYZDriver::get_type_name),
                    R"#()#" 
          )
        .def_static("get_type_descriptor_s",
                    ( const handle<Standard_Type> & (*)() ) static_cast< const handle<Standard_Type> & (*)() >(&BinTObjDrivers_XYZDriver::get_type_descriptor),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             ( const handle<Standard_Type> & (BinTObjDrivers_XYZDriver::*)() const) static_cast< const handle<Standard_Type> & (BinTObjDrivers_XYZDriver::*)() const>(&BinTObjDrivers_XYZDriver::DynamicType),
             R"#()#"
             
         )
;

// functions

// ./opencascade/BinTObjDrivers.hxx
// ./opencascade/BinTObjDrivers_DocumentRetrievalDriver.hxx
// ./opencascade/BinTObjDrivers_DocumentStorageDriver.hxx
// ./opencascade/BinTObjDrivers_IntSparseArrayDriver.hxx
// ./opencascade/BinTObjDrivers_ModelDriver.hxx
// ./opencascade/BinTObjDrivers_ObjectDriver.hxx
// ./opencascade/BinTObjDrivers_ReferenceDriver.hxx
// ./opencascade/BinTObjDrivers_XYZDriver.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
